#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "outputwin.h"
#include "icq-defines.h"

//-----OutputWin::constructor----------------------------------------------------------------------
OutputWin::OutputWin(QWidget *parent = 0, const char *name = 0) : QWidget(parent, name)
{
   resize(430, 220);
   
   outputBox = new MLEditWrap (true, this);
   outputBox->setGeometry(5, 5, 400, 200);
   outputBox->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
   outputBox->setReadOnly(true);

   btnHide = new QPushButton("Hide Window", this);
   connect(btnHide, SIGNAL(clicked()), this, SLOT(hide()));

   btnClear = new QPushButton("Clear", this);
   connect(btnClear, SIGNAL(clicked()), outputBox, SLOT(clear()));
   
}


//-----OutputWin::resizeEvent----------------------------------------------------------------------
void OutputWin::resizeEvent(QResizeEvent *)                                                        
{
   outputBox->resize(width() - 10, height() - 45);
   btnHide->setGeometry(5, height() - 35, 100, 30);
   btnClear->setGeometry(120, height() - 35, 100, 30);
}


//-----OutputWin::wprintf--------------------------------------------------------------------------
void OutputWin::wprintf(const char *_szFormat, va_list argp)
{
   char szLine[MAX_MSG_SIZE];
   vsprintf(szLine, _szFormat, argp);   
   outputBox->append(szLine);
   outputBox->goToEnd();
}


