#ifndef PLUGIN_H
#define PLUGIN_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <string.h>

#include "user.h"
#include "icq-defines.h"

//=====CPluginUserField=========================================================
class CPluginUserField
{
public:
  CPluginUserField(const char *_szTitle, const char *_szDefault)
  {
    m_szTitle = strdup(_szTitle);
    m_szDefault = strdup(_szDefault);
  }
  ~CPluginUserField(void)
  {
    free (m_szTitle);
    free (m_szDefault);
  }
  const char *Title(void)  { return m_szTitle; }
  const char *Default(void)  { return m_szDefault; }
protected:
  char *m_szTitle;
  char *m_szDefault;
};


//=====CPlugin==================================================================
enum EWinType { PluginWinLicq, PluginWinTerm, PluginWinGui };

class CPlugin
{
public:
  CPlugin(const char *_szFileName);
  const char *Name(void)  { return m_szName; }
  const char *Command(ICQUser *u) { return m_szCommand; }
  EWinType WinType(void)  { return m_eWinType; }

  void SetFields(ICQUser *u);
  void SetUserFields(vector<const char *> &_vszUserFields);
  void SetBackgroundTask(void)  { strcat(m_szFullCommand, " &"); }
  const char *FullCommand(void) { return m_szFullCommand; }
  
  unsigned short NumUserFields(void)  { return m_vxUserField.size(); }
  CPluginUserField *UserField(unsigned short i)  { return m_vxUserField[i]; }

  bool Exception(void)  { return bException; }

protected:
  char *m_szName;
  EWinType m_eWinType;
  char *m_szCommand;
  char m_szFullCommand[MAX_CMD_LEN];
  vector <CPluginUserField *> m_vxUserField;
  bool bException;
};


//=====CPluginManager===========================================================
class CPluginManager
{
public:
  CPluginManager(void);
  unsigned short LoadPlugins(const char *_szDir);
  CPlugin *Plugin(unsigned short n)  { return m_vxPlugins[n]; }
  unsigned short NumPlugins(void)  { return m_vxPlugins.size(); }
protected:
  vector <CPlugin *> m_vxPlugins;
};

extern CPluginManager gPluginManager;


#endif
