// Skin Spec 0.1

#ifndef SKIN_H
#define SKIN_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qrect.h>
#include <qpixmap.h>

#include "file.h"


struct Border
{
   unsigned short top, bottom;
   unsigned short left, right;
};

class CFrameSkin
{
public:
   struct Border border;
   bool maintainBorder;
   bool hasMenuBar;
   char *pixmap;
   char *mask;
};

struct Rect
{
   signed short x1, y1;
   signed short x2, y2;
};

struct Color
{
   char *fg, *bg;
};

class CShapeSkin
{
public:
   struct Rect rect;
   struct Color color;
};

class CButtonSkin : public CShapeSkin
{
public:
   char *pixmapUpFocus, *pixmapUpNoFocus, *pixmapDown;
   char *caption;
};

class CLabelSkin : public CShapeSkin
{
public:
   char *pixmap;
   unsigned short frameStyle;
   bool transparent;
   unsigned short margin;
};

class CComboSkin : public CShapeSkin { };

class CListSkin : public CShapeSkin { };

class CSkin
{
public:
   CSkin(char *);
   ~CSkin(void);
   CFrameSkin frame;
   CButtonSkin btnSys;
   CLabelSkin lblStatus, lblMsg;
   CComboSkin cmbGroups;
   CListSkin lstUsers;
  
   // Functions
   QRect borderToRect(CShapeSkin *, QWidget *);
   QRect borderToRect(CShapeSkin *, QPixmap *);
   int frameWidth(void);
   int frameHeight(void);
};


#endif
