#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qpainter.h>
#include <qheader.h>
#include <qkeycode.h>
#include <qscrollbar.h>

#include <math.h>
#include "userbox.h"
#include "gui-defines.h"


bool    CUserViewItem::s_bGridLines;
QPixmap *CUserViewItem::s_pOnline = NULL,
        *CUserViewItem::s_pOffline = NULL,
        *CUserViewItem::s_pAway = NULL,
        *CUserViewItem::s_pNa = NULL,
        *CUserViewItem::s_pOccupied = NULL,
        *CUserViewItem::s_pDnd = NULL,
        *CUserViewItem::s_pPrivate = NULL, 
        *CUserViewItem::s_pMessage = NULL;
QColor  *CUserViewItem::s_cOnline = NULL,
        *CUserViewItem::s_cAway = NULL,
        *CUserViewItem::s_cOffline = NULL,
        *CUserViewItem::s_cNew = NULL,
        *CUserViewItem::s_cBack = NULL,
        *CUserViewItem::s_cGridLines = NULL;


//-----CUserViewItem::constructor-----------------------------------------------
CUserViewItem::CUserViewItem(ICQUser *_cUser, unsigned short _nIndex, 
                            QListView *parent) 
   : QListViewItem(parent)
{ 
   m_cUser = _cUser;
   m_nIndex = _nIndex;
   setGraphics();
}


//-----CUserViewItem::setGraphics-----------------------------------------------
void CUserViewItem::setGraphics(void)
{ 
   switch (m_cUser->getStatus())
   {
   case ICQ_STATUS_FREEFORCHAT: 
   case ICQ_STATUS_ONLINE: 
      m_pIcon = CUserViewItem::s_pOnline;
      m_cFore = CUserViewItem::s_cOnline; 
      break;
   case ICQ_STATUS_AWAY: 
      m_pIcon = CUserViewItem::s_pAway;
      m_cFore = CUserViewItem::s_cAway; 
      break;
   case ICQ_STATUS_OCCUPIED: 
      m_pIcon = CUserViewItem::s_pOccupied;
      m_cFore = CUserViewItem::s_cAway; 
      break;
   case ICQ_STATUS_DND: 
      m_pIcon = CUserViewItem::s_pDnd;
      m_cFore = CUserViewItem::s_cAway; 
      break;
   case ICQ_STATUS_FxPRIVATE: 
      m_pIcon = CUserViewItem::s_pPrivate;
      m_cFore = CUserViewItem::s_cAway; 
      break;
   case ICQ_STATUS_NA: 
      m_pIcon = CUserViewItem::s_pNa;
      m_cFore = CUserViewItem::s_cAway; 
      break;
   case ICQ_STATUS_OFFLINE: 
      m_pIcon = CUserViewItem::s_pOffline;
      m_cFore = CUserViewItem::s_cOffline; 
      break;
   default: 
      m_pIcon = CUserViewItem::s_pOnline;
      m_cFore = CUserViewItem::s_cOnline; 
      break;
   }
   
   if (m_cUser->getNumMessages() > 0)
      m_pIcon = CUserViewItem::s_pMessage;
   if (m_cUser->getIsNew()) 
      m_cFore = CUserViewItem::s_cNew;
   
   m_cBack = CUserViewItem::s_cBack;   
   if (m_pIcon != NULL) setPixmap(0, *m_pIcon);

   CUserView *v = (CUserView *)listView();
   char sTemp[64];
   for (unsigned short i = 0; i < v->colInfo.size(); i++) 
   {
      switch (v->colInfo[i].info) 
      {
      case COL_ALIAS:
         setText(i + 1, m_cUser->getAlias());
         break;
      case COL_UIN:
         sprintf (sTemp, "%ld", m_cUser->getUin());
         setText(i + 1, sTemp);
         break;
      case COL_NAME:
         sprintf(sTemp, "%s %s", m_cUser->getFirstName(), 
                 m_cUser->getLastName());
         setText(i + 1, sTemp);
         break;
      case COL_EMAIL:
         setText(i + 1, m_cUser->getEmail());
         break;
      }
   }
}


//-----CUserViewItem::paintCell-------------------------------------------------
void CUserViewItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
   QFont newFont(p->font());
   newFont.setBold(m_cUser->getNumMessages() > 0);
   p->setFont(newFont);

   QListViewItem::paintCell(p, QColorGroup(cg.foreground(), cg.background(), cg.light(), cg.dark(), cg.mid(), *m_cFore, *m_cBack), column, width, align);
      
   // add line to bottom and right side
   if (s_bGridLines)
   {
      p->setPen(*s_cGridLines);
      p->drawLine(0, height() - 1, width - 1, height() - 1);
      p->drawLine(width - 1, 0, width - 1, height() - 1);
   }
}


//-----CUserViewItem::key-------------------------------------------------------
const char *CUserViewItem::key (int column, bool ascending) const
{
   static char tmpString[64];

   if (column == 0) 
   {
      sprintf(tmpString, "%09d", m_nIndex);
   }
   else if (column == 2) 
   {
      sprintf(tmpString, "%09ld", m_cUser->getUin());
   } 
   else 
   {
      sprintf(tmpString, "%s", QListViewItem::key(column, ascending));
   }
   return (tmpString);

}



//-----UserList::constructor-----------------------------------------------------------------------
CUserView::CUserView (QPopupMenu *m, QPopupMenu *mg, vector <ColInfo> theColInfo, 
                    bool isHeader, bool _bGridLines, QWidget *parent = 0, const char *name = 0) 
   : QListView(parent, name)
{
   mnuUser = m;
   mnuGroup = mg;
   colInfo = theColInfo;
   
   addColumn("S", 20);
   for (unsigned short i = 0; i < colInfo.size(); i++) 
   {
      switch (theColInfo[i].info) 
      {
      case COL_ALIAS:
         addColumn("Alias", colInfo[i].width);
         break;
      case COL_UIN:
         addColumn("UIN", colInfo[i].width);
         break;
      case COL_NAME:
         addColumn("Name", colInfo[i].width);
         break;
      case COL_EMAIL:
         addColumn("EMail Address", colInfo[i].width);
         break;
      }
      setColumnAlignment(i + 1, pow(2, colInfo[i].align));
   }
   
   setAllColumnsShowFocus (true);
   setFrameStyle(QFrame::Panel | QFrame::Sunken);
   setShowHeader(isHeader);
   setGridLines(_bGridLines);
}


//-----CUserView::setPixmaps----------------------------------------------------
void CUserView::setPixmaps(QPixmap *_pOnline, QPixmap *_pOffline, QPixmap *_pAway,
                   QPixmap *_pNa, QPixmap *_pOccupied, QPixmap *_pDnd,
                   QPixmap *_pPrivate, QPixmap *_pMessage)
{
   CUserViewItem::s_pOnline = _pOnline; 
   CUserViewItem::s_pOffline = _pOffline;
   CUserViewItem::s_pAway = _pAway;
   CUserViewItem::s_pNa = _pNa;
   CUserViewItem::s_pOccupied = _pOccupied;
   CUserViewItem::s_pDnd = _pDnd;
   CUserViewItem::s_pPrivate = _pPrivate;
   CUserViewItem::s_pMessage = _pMessage;
}


//-----CUserView::setColors-----------------------------------------------------
void CUserView::setColors(char *_sOnline, char *_sAway, char *_sOffline,
                          char *_sNew, char *_sBack, char *_sGridLines)
{
   if (CUserViewItem::s_cOnline == NULL) CUserViewItem::s_cOnline = new QColor;
   if (CUserViewItem::s_cAway == NULL) CUserViewItem::s_cAway = new QColor;
   if (CUserViewItem::s_cOffline == NULL) CUserViewItem::s_cOffline = new QColor;
   if (CUserViewItem::s_cNew == NULL) CUserViewItem::s_cNew = new QColor;
   if (CUserViewItem::s_cBack == NULL) CUserViewItem::s_cBack = new QColor;
   if (CUserViewItem::s_cGridLines == NULL) CUserViewItem::s_cGridLines = new QColor;
   
   CUserViewItem::s_cOnline->setNamedColor(_sOnline);
   CUserViewItem::s_cAway->setNamedColor(_sAway);
   CUserViewItem::s_cOffline->setNamedColor(_sOffline);
   CUserViewItem::s_cNew->setNamedColor(_sNew);
   CUserViewItem::s_cBack->setNamedColor(_sBack);
   CUserViewItem::s_cGridLines->setNamedColor(_sGridLines);
   
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), *CUserViewItem::s_cBack); //QColor(194, 194, 194));
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));

}


void CUserView::setShowHeader(bool isHeader)
{
   QHeader *h = CHILD(this, QHeader, "list view header");
   if (!isHeader) h->hide();
   else h->show();
}


ICQUser *CUserView::getSelectedUser(void)
{
   CUserViewItem *i = (CUserViewItem *)currentItem();
   if (i == NULL) return (NULL);
   return i->getUser();
}


//-----CUserList::mouseReleaseEvent---------------------------------------------
void CUserView::mouseReleaseEvent(QMouseEvent *e)
{
   QListView::mouseReleaseEvent(e);
   if (e->button() == RightButton) 
   {
      QPoint clickPoint(e->x(), e->y());
      QListViewItem *clickedItem = itemAt(clickPoint);
      if (clickedItem != NULL) 
      {
         setSelected(clickedItem, true);
         setCurrentItem(clickedItem);
         mnuUser->setItemChecked(MNUxITEM_ONLINExNOTIFY, 
                                 getSelectedUser()->getOnlineNotify());
         mnuUser->setItemChecked(MNUxITEM_INVISIBLExLIST, 
                                 getSelectedUser()->getInvisibleList());
         mnuUser->setItemChecked(MNUxITEM_VISIBLExLIST, 
                                 getSelectedUser()->getVisibleList());
         for (unsigned short i = 0; i < mnuGroup->count(); i++)
            mnuGroup->setItemEnabled(i, !getSelectedUser()->getIsInGroup(i));
         mnuUser->popup(mapToGlobal(clickPoint));
      }
   }
}



void CUserView::keyPressEvent(QKeyEvent *e)
{
   // Space will popup the user menu over the current user
   if ( (e->key() == Key_Space) && mnuUser != NULL) 
   {
      cout << "hello" << endl;
      // Get the menu width (512 when not initialized; used sane value)
      int nMenuWidth = mnuUser->width();
      if ( 512 == nMenuWidth )
         nMenuWidth = 120;
      // Calculate where to position the menu
      const QListViewItem *pcItem = currentItem();
      QPoint cRelPos( (width() - nMenuWidth)/2,
                      itemPos(pcItem) + pcItem->height() );
      QPoint cPos( mapToGlobal( cRelPos ) );
      mnuUser->popup( cPos );
   }
   else 
   {
      QListView::keyPressEvent(e);
   }
}

void CUserView::maxLastColumn(void)
{/*
   unsigned short totalWidth = 0;
   unsigned short nNumCols = header()->count();
   cout << nNumCols << endl;
   for (unsigned short i = 0; i < nNumCols - 1; i++)
      totalWidth += columnWidth(i);
   QScrollBar *s = verticalScrollBar();
   if (s != NULL) totalWidth += s->width();
   setColumnWidth(nNumCols - 1, width() - totalWidth); */
}

