; m4 macro definitions for some elementary math functions and constants in Mathomatic.
m4_define(`sqrt', `(($1)^.5)')m4_dnl; function sqrt(x) = square root of x
m4_define(`cbrt', `(($1)^(1/3))')m4_dnl; function cbrt(x) = cube root of x
m4_define(`exp', `(e^($1))')m4_dnl; function exp(x) = e^x
m4_define(`pow', `(($1)^($2))')m4_dnl; function pow(x, y) = x^y
m4_define(`abs', `(|($1)|)')m4_dnl; function abs(x) = absolute value = |x|
m4_define(`fact', `(($1)!)')m4_dnl; function fact(x) = factorial = x!
m4_define(`phi', `((1+5^.5)/2)')m4_dnl; phi = the golden ratio constant

; floor() and ceil() only work properly with "set true_modulus" enabled.
set true_modulus
m4_define(`floor', `(($1)-($1)%1)')m4_dnl; floor(x) = floor function, real x -> integer result
m4_define(`ceil', `(($1)+(-($1))%1)')m4_dnl; ceil(x) = ceiling function, real x -> integer result
m4_define(`int', `(($1)//1)')m4_dnl; int(x) = truncate to integer function, real x -> integer result
m4_define(`round', `((($1)+|($1)|/($1)/2)//1)')m4_dnl; round(x) = round to nearest integer function; round(0) fails

; Standard trigonometry functions as complex exponentials, argument x is in radians:
m4_define(`sin', `((e^(i*($1))-e^(-i*($1)))/(2i))')m4_dnl; sin(x) = sine of x
m4_define(`cos', `((e^(i*($1))+e^(-i*($1)))/2)')m4_dnl; cos(x) = cosine of x
m4_define(`tan', `((e^(i*($1))-e^(-i*($1)))/(i*(e^(i*($1))+e^(-i*($1)))))')m4_dnl; tan(x) = tangent of x
m4_define(`cot', `(i*(e^(i*($1))+e^(-i*($1)))/(e^(i*($1))-e^(-i*($1))))')m4_dnl; cot(x) = cotangent of x
m4_define(`sec', `(2/(e^(i*($1))+e^(-i*($1))))')m4_dnl; sec(x) = secant of x
m4_define(`csc', `(2i/(e^(i*($1))-e^(-i*($1))))')m4_dnl; csc(x) = cosecant of x

; The following are hyperbolic trigonometry functions: sinh(x), cosh(x), tanh(x), coth(x), sech(x), and csch(x).
; These are related to the above trigonometry functions without the "h" appended to the function name.
m4_define(`sinh', `((e^($1)-e^-($1))/2)')m4_dnl
m4_define(`cosh', `((e^($1)+e^-($1))/2)')m4_dnl
m4_define(`tanh', `((e^($1)-e^-($1))/(e^($1)+e^-($1)))')m4_dnl
m4_define(`coth', `((e^($1)+e^-($1))/(e^($1)-e^-($1)))')m4_dnl
m4_define(`sech', `(2/(e^($1)+e^-($1)))')m4_dnl
m4_define(`csch', `(2/(e^($1)-e^-($1)))')m4_dnl
echo Functions are now available.
