<?php

require_once("QueryPage.php");

class CategoriesPage extends QueryPage {

	function getName() {
		return "Categories";
	}

	function isExpensive() {
		return false;
	}

	function getPageHeader() {
		return '<p>'.wfMsg('categoriespagetext')."</p><br>\n";
	}
	function getSQL() {
		$NScat = NS_CATEGORY;
		return "SELECT DISTINCT 'Categories' as type, 
				{$NScat} as namespace,
				cl_to as title,
				1 as value
			   FROM categorylinks";
	}
	
	function sortDescending() {
		return false;
	}

	function formatResult( $skin, $result ) {
		global $wgLang;
		$title = Title::makeTitle( NS_CATEGORY, $result->title );
		return $skin->makeLinkObj( $title, $title->getText() );
	}
}

function wfSpecialCategories()
{
	list( $limit, $offset ) = wfCheckLimits();

	$cap = new CategoriesPage();

	return $cap->doQuery( $offset, $limit );
}

?>
