/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */

#ifndef nsEvent_h__
#define nsEvent_h__

/*
 * This is in a separate header file because it needs to be included
 * in many places where including nsGUIEvent.h would bring in many
 * header files that are totally unneccessary.
 */

/**
 * Return status for event processors.
 */

enum nsEventStatus {  
    /// The event is ignored, do default processing
  nsEventStatus_eIgnore,            
    /// The event is consumed, don't do default processing
  nsEventStatus_eConsumeNoDefault, 
    /// The event is consumed, but do default processing
  nsEventStatus_eConsumeDoDefault  
};

struct nsEvent;

struct nsGUIEvent;
struct nsSizeEvent;
struct nsSizeModeEvent;
struct nsZLevelEvent;
struct nsPaintEvent;
struct nsScrollbarEvent;
struct nsScrollPortEvent;
struct nsInputEvent;
struct nsMouseEvent;
struct nsAccessibleEvent;
struct nsKeyEvent;
struct nsTextEvent;
struct nsCompositionEvent;
struct nsMouseScrollEvent;
struct nsReconversionEvent;
struct nsTooltipEvent;
struct nsMenuEvent;

struct nsTextEventReply;
struct nsReconversionEventReply;

#endif // nsEvent_h__
