/* This file was contributed by Suzanne Skinner and is copyrighted
   under the GNU General Public License. (C) 2002 Suzanne Skinner.

   The code contained in this file is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _NAP_DLUL_SCREEN_H
#define _NAP_DLUL_SCREEN_H

#define DLUL_REFRESH_INTERVAL 1     /* seconds */

extern WINDOW *dlul_win;

typedef enum dlul_field_enum {
    FLD_FILENAME,
    FLD_USER,
    FLD_PROGRESS,

    DLUL_NUM_FIELDS
} dlul_field;

typedef struct dlul_field_info_struct {
    dlul_field  id;
    int         len;
} dlul_field_info_type;

void  dlulscr(void);
void  enddlulscr(void);
void  dlul_refresh(void);
void  dlul_print_download(int index, const download_t *task);
void  dlul_print_upload(int index, const upload_t *task);
void  dlul_print_task(int index, const char *nick, const char *fn, int state,
                      size_t size, size_t bsz, size_t pos, time_t p_time);
const char *dlul_get_status_desc(int status);
int   dlul_input(WINDOW *win, sock_t *m);

#endif


