/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 *
 * nemesis-proto_ospf.c (OSPF Packet Generator)
 *
 */

#include "nemesis-ospf.h"

int
buildospf()
{				/* Nemesis OSPF wrapper */
   int             state = -1;

   switch (ospftype) {
   case 0:
      if (verbose)
	 printf("\nOSPF Hello\n");
      state = build_hello();
      break;
   case 1:
      if (verbose)
	 printf("\nOSPF Database Description\n");
      state = build_dbd();
      break;
   case 2:
      if (verbose)
	 printf("\nOSPF Link State Request\n");
      state = build_lsr();
      break;
   case 3:
      if (verbose)
	 printf("\nOSPF Link State Update\n");
      state = build_lsu();
      break;
   case 4:
      if (verbose)
	 printf("\nOSPF Router Links Advertisement\n");
      state = build_lsartr();
      break;
   case 5:
      if (verbose)
	 printf("\nOSPF Network Links Advertisement\n");
      state = build_lsanet();
      break;
   case 6:
      if (verbose)
	 printf("\nOSPF IP Summary Links Advertisement\n");
      state = build_lsasum_ip();
      break;
   case 7:
      if (verbose)
	 printf("\nOSPF AS External Link Advertisement\n");
      state = build_lsaas();
      break;
   }
   return state;
}

int
build_hello()
{				/* OSPF Hello */
   int             c, n;
   static int      sockfd = -1;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload == NULL)
      payload_s = 0;
   else
      payload_s = strlen(payload);

   if (*options == NULL)
      option_s = 0;
   else
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */
      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
			     LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_HELLO_H,
      /* size of p acket */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_HELLO_H + LIBNET_AUTH_H,
      /* size of packet */
			LIBNET_OSPF_HELLO,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H +
			  LIBNET_ETH_H, auth);

      libnet_build_ospf_hello(mask,	/* OSPF netmask */
			      interval,	/* secs since last pkt sent */
			      ooptions,	/* OSPF options */
			      priority,	/* OSPF priority */
			      dead_int,	/* Time til router is deemed down */
			      source,	/* designated router */
			      source,	/* backup router */
			      neighbor,	/* address of neigbor router */
			      payload,	/* OSPF payload pointer */
			      payload_s,	/* OSPF payload size */
			    pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H
			      + LIBNET_AUTH_H);
      /* pkt hdr mem */

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_OSPF_H +
		  LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
	      LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_HELLO_H + LIBNET_AUTH_H +
				  payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_HELLO_H +
	  LIBNET_AUTH_H + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
		 } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_HELLO_H,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_HELLO_H + LIBNET_AUTH_H,	/* size of packet */
			LIBNET_OSPF_HELLO,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_hello(mask,	/* OSPF netmask */
			      interval,	/* secs since last pkt sent */
			      ooptions,	/* OSPF options */
			      priority,	/* OSPF priority */
			      dead_int,	/* Time til router is deemed down */
			      source,	/* designated router */
			      source,	/* backup router */
			      neighbor,	/* address of neigbor router */
			      payload,	/* OSPF payload pointer */
			      payload_s,	/* OSPF payload size */
			 pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H);	/* pkt hdr mem */

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_OSPF_H + LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_OSPF_H + LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      if (c < LIBNET_OSPF_H + LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "libnet_write_ip\n");
	 return -1;
      } else {
	 printf("%d bytes written\n", c);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }				/* end of ip layer */
}

int
build_dbd()
{				/* Database Description */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_DBD_H
		  + LIBNET_IP_H + LIBNET_ETH_H + payload_s + option_s, &pkt)
	  == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_DBD_H,
      /* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_DBD_H + LIBNET_AUTH_H,	/* size of packet */
			LIBNET_OSPF_DBD,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H + LIBNET_ETH_H,
			  auth);

      libnet_build_ospf_dbd(mtusize,	/* max dgram length */
			    ooptions,	/* OSPF options */
			    exchange,	/* exchange type */
			    seqnum,	/* DBD sequence number */
			    payload,	/* DBD payload pointer */
			    payload_s,	/* DBD payload size */
			    pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H
			    + LIBNET_AUTH_H);
      /* packet header memory */

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_OSPF_H +
		    LIBNET_DBD_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_DBD_H + LIBNET_AUTH_H +
				  payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_DBD_H +
	  LIBNET_AUTH_H + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
		 } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_DBD_H,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_DBD_H + LIBNET_AUTH_H,	/* size of packet */
			LIBNET_OSPF_DBD,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;
      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_dbd(mtusize,	/* max dgram length */
			    ooptions,	/* OSPF options */
			    exchange,	/* exchange type */
			    seqnum,	/* DBD sequence number */
			    payload,	/* DBD payload pointer */
			    payload_s,	/* DBD payload size */
			 pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H);	/* packet header memory */

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_OSPF_H + LIBNET_DBD_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */
      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_OSPF_H + LIBNET_DBD_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      if (c < LIBNET_OSPF_H + LIBNET_DBD_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "libnet_write_ip\n");
	 return -1;
      } else {
	 printf("%d bytes written\n", c);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }				/* end of ip layer */
}

int
build_lsr()
{				/* Link State Request */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
			     LIBNET_LSR_H + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSR_H,
      /* size of p acket */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_HELLO_H + LIBNET_AUTH_H,
      /* size of packet */
			LIBNET_OSPF_HELLO,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H +
			  LIBNET_ETH_H, auth);

      libnet_build_ospf_lsr(LIBNET_LS_TYPE_RTR,
			    rtrid,
			    router,
			    payload,
			    payload_s,
			  pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H +
			    LIBNET_AUTH_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_OSPF_H +
		    LIBNET_LSR_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSR_H + LIBNET_AUTH_H +
				  payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_HELLO_H +
	  LIBNET_AUTH_H + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
		 } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {			/* ip layer */
      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSR_H,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* Don't frag - IP_DF */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSR_H,	/* size of packet */
			LIBNET_OSPF_LSR,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsr(LIBNET_LS_TYPE_RTR,
			    rtrid,
			    router,
			    payload,
			    payload_s,
			 pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H + LIBNET_OSPF_H +
			 LIBNET_AUTH_H + LIBNET_LSR_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_write_ip(sockfd, pkt, LIBNET_IP_H + LIBNET_OSPF_H +
			  LIBNET_AUTH_H + LIBNET_LSR_H + payload_s +
			  option_s);

      if (c < LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSR_H +
	  payload_s + option_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "write_ip\n");
	 return -1;
      }
      if (verbose)
	 printf("Wrote %d bytes\n", c);
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }				/* end of ip layer */
}

int
build_lsu()
{				/* Link State Update */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);
   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
			     LIBNET_HELLO_H + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSU_H,
      /* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_LSU_H + LIBNET_AUTH_H,	/* size of packet */
			LIBNET_OSPF_LSU,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H
			  + LIBNET_ETH_H, auth);

      libnet_build_ospf_lsu(bcastnum,	/* num of LSAs to bcast */
			    payload,	/* DBD payload pointer */
			    payload_s,	/* DBD payload size */
			 pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H);
      /* packet header memory */

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_OSPF_H +
		    LIBNET_LSU_H + LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */
      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSU_H + LIBNET_AUTH_H +
				  payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSU_H +
	  LIBNET_AUTH_H + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
      } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSU_H,
      /* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best not to frag (IP_DF) */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_LSU_H + LIBNET_AUTH_H,	/* size of packet */
			LIBNET_OSPF_LSU,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsu(bcastnum,	/* num of LSAs to bcast */
			    payload,	/* DBD payload pointer */
			    payload_s,	/* DBD payload size */
			 pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H);
      /* packet header memory */

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_OSPF_H + LIBNET_LSU_H +
			 LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_OSPF_H + LIBNET_LSU_H +
			  LIBNET_IP_H + LIBNET_AUTH_H + payload_s);

      if (c < LIBNET_OSPF_H + LIBNET_LSU_H + LIBNET_IP_H + LIBNET_AUTH_H
	  + payload_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "libnet_write_ip\n");
	 return -1;
      } else {
	 printf("%d bytes written\n", c);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }				/* end of ip layer */
}

int
build_lsartr()
{				/* Router Links Advertisement */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */
      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
	       LIBNET_LSA_H + LIBNET_LS_RTR_LEN + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_RTR_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_ETH_H + LIBNET_IP_H,
			  auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_RTR,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_RTR_LEN,
			    NULL,
			    0,
			pkt + LIBNET_ETH_H + LIBNET_AUTH_H + LIBNET_OSPF_H +
			    LIBNET_IP_H);

      libnet_build_ospf_lsa_rtr(rtr_flags,
				num,
				rtrid,
				rtrdata,
				rtrtype,
				tos,
				metric,
				payload,
				payload_s,
			 pkt + LIBNET_ETH_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_IP_H
	+ LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN);

      libnet_do_checksum(pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H +
	   LIBNET_AUTH_H, IPPROTO_OSPF_LSA, LIBNET_LS_RTR_LEN + LIBNET_LSA_H
			 + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				  LIBNET_LS_RTR_LEN + payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H +
	  LIBNET_AUTH_H + LIBNET_LS_RTR_LEN + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
		 } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_RTR_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_RTR,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_RTR_LEN,
			    NULL,
			    0,
			 pkt + LIBNET_AUTH_H + LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_build_ospf_lsa_rtr(rtr_flags,
				num,
				rtrid,
				rtrdata,
				rtrtype,
				tos,
				metric,
				payload,
				payload_s,
				pkt + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H + LIBNET_OSPF_H +
			 LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN);

      libnet_do_checksum(pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H,
	    IPPROTO_OSPF_LSA, LIBNET_LS_RTR_LEN + LIBNET_LSA_H + payload_s);


      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      c = libnet_write_ip(sockfd, pkt, LIBNET_IP_H + LIBNET_OSPF_H +
			  LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN +
			  payload_s + option_s);

      if (c < LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
	  LIBNET_LS_RTR_LEN + payload_s + option_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "write_ip\n");
	 return -1;
      }
      if (verbose)
	 printf("Wrote %d bytes\n", c);
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }
}

int
build_lsanet()
{				/* Network Links Advertisement */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
	       LIBNET_LSA_H + LIBNET_LS_NET_LEN + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_NET_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_NET_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_ETH_H + LIBNET_IP_H,
			  auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_NET,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_NET_LEN,
			    NULL,
			    0,
			pkt + LIBNET_ETH_H + LIBNET_AUTH_H + LIBNET_OSPF_H +
			    LIBNET_IP_H);

      libnet_build_ospf_lsa_net(mask,
				rtrid,
				payload,
				payload_s,
			 pkt + LIBNET_ETH_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF,
		  LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H
			 + LIBNET_LS_NET_LEN);

      libnet_do_checksum(pkt + LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H
		      + LIBNET_AUTH_H, IPPROTO_OSPF_LSA, LIBNET_LS_NET_LEN +
			 LIBNET_LSA_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				  LIBNET_LS_NET_LEN + payload_s + option_s);


      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H +
	  LIBNET_AUTH_H + LIBNET_LS_NET_LEN + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes\n", n);
		 } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {
      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_NET_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_NET_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_NET,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_NET_LEN,
			    NULL,
			    0,
			 pkt + LIBNET_AUTH_H + LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_build_ospf_lsa_net(mask,
				rtrid,
				payload,
				payload_s,
				pkt + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H + LIBNET_OSPF_H +
			 LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_RTR_LEN);

      libnet_do_checksum(pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H,
	    IPPROTO_OSPF_LSA, LIBNET_LS_RTR_LEN + LIBNET_LSA_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_IP_H + LIBNET_OSPF_H +
			  LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_NET_LEN +
			  payload_s + option_s);

      if (c < LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
	  LIBNET_LS_NET_LEN + payload_s + option_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "write_ip\n");
	 return -1;
      }
      if (verbose)
	 printf("Wrote %d bytes\n", c);
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }
}

int
build_lsasum_ip()
{				/* Summary Links Advertisement */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
	       LIBNET_LSA_H + LIBNET_LS_SUM_LEN + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_SUM_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_SUM_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H + LIBNET_ETH_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_ETH_H + LIBNET_OSPF_H + LIBNET_IP_H,
			  auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_IP,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_SUM_LEN,
			    NULL,
			    0,
			pkt + LIBNET_ETH_H + LIBNET_AUTH_H + LIBNET_OSPF_H +
			    LIBNET_IP_H);

      libnet_build_ospf_lsa_sum(mask,
				metric,
				tos,
				payload,
				payload_s,
			 pkt + LIBNET_ETH_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_OSPF, LIBNET_IP_H +
	  LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_SUM_LEN);

      libnet_do_checksum(pkt + LIBNET_ETH_H + LIBNET_IP_H +
			 LIBNET_OSPF_H + LIBNET_AUTH_H, IPPROTO_OSPF_LSA,
			 LIBNET_LS_SUM_LEN + LIBNET_LSA_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H + LIBNET_AUTH_H +
				  LIBNET_LS_SUM_LEN + payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H +
	  LIBNET_AUTH_H + LIBNET_LS_SUM_LEN + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes \n", n);
      } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_SUM_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_SUM_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_IP,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_SUM_LEN,
			    NULL,
			    0,
			 pkt + LIBNET_AUTH_H + LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_build_ospf_lsa_sum(mask,
				metric,
				tos,
				payload,
				payload_s,
				pkt + LIBNET_LSA_H + LIBNET_AUTH_H +
				LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H +
	  LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_SUM_LEN);

      libnet_do_checksum(pkt + LIBNET_IP_H +
			 LIBNET_OSPF_H + LIBNET_AUTH_H, IPPROTO_OSPF_LSA,
			 LIBNET_LS_SUM_LEN + LIBNET_LSA_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_IP_H + LIBNET_OSPF_H +
			  LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_SUM_LEN +
			  payload_s + option_s);

      if (c < LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
	  LIBNET_LS_SUM_LEN + payload_s + option_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "write_ip\n");
	 return -1;
      }
      if (verbose)
	 printf("Wrote %d bytes\n", c);
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }
}

int
build_lsaas()
{				/* Summary Links Advertisement */
   int             c, n;
   static int      sockfd;
   static u_char  *pkt;
   struct libnet_link_int *l;
   struct ipoption ipopt;
   char            errbuf[256];

   if (got_link && !device) {
      printf("Unspecified Device.\n");
      exit(1);
   }
   if (payload != NULL)
      payload_s = strlen(payload);
   if (*options != NULL)
      option_s = strlen(options);

   pkt = malloc(IP_MAXPACKET);
   sockfd = libnet_open_raw_sock(IPPROTO_RAW);

   if (sockfd < 0) {
      perror("socket");
      exit(1);
   }
   if (got_link) {		/* data link layer transport */

      if ((l = libnet_open_link_interface(device, errbuf)) == NULL) {
	 fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	 exit(1);
      }
      if (libnet_init_packet(LIBNET_OSPF_H + LIBNET_AUTH_H +
	    LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN + LIBNET_IP_H + LIBNET_ETH_H
			     + payload_s + option_s, &pkt) == -1) {
	 printf("libnet_init_packet memory error\n");
	 exit(1);
      }
      libnet_build_ethernet(enet_dst,
			    enet_src,
			    ETHERTYPE_IP,
			    NULL,
			    0,
			    pkt);

      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_AS_EXT_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt + LIBNET_ETH_H);	/* packet header memory */


      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_ETH_H + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_ETH_H + LIBNET_OSPF_H + LIBNET_IP_H,
			  auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_ASEXT,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_AS_EXT_LEN,
			    NULL,
			    0,
			pkt + LIBNET_ETH_H + LIBNET_AUTH_H + LIBNET_OSPF_H +
			    LIBNET_IP_H);

      libnet_build_ospf_lsa_as(mask,
			       metric,
			       as_fwd,
			       as_tag,
			       payload,
			       payload_s,
			 pkt + LIBNET_ETH_H + LIBNET_LSA_H + LIBNET_AUTH_H +
			       LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H + LIBNET_OSPF_H +
		       LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN);

      libnet_do_checksum(pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H,
	 IPPROTO_OSPF_LSA, LIBNET_LS_AS_EXT_LEN + LIBNET_LSA_H + payload_s);

      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      n = libnet_write_link_layer(l, device, pkt, LIBNET_ETH_H +
		LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H + LIBNET_AUTH_H +
			       LIBNET_LS_AS_EXT_LEN + payload_s + option_s);

      if (n != LIBNET_ETH_H + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_LSA_H +
	  LIBNET_AUTH_H + LIBNET_LS_AS_EXT_LEN + payload_s + option_s) {
	 fprintf(stderr, "Incomplete data transmission.  Only wrote %d bytes \n", n);
      } else {
	 if (verbose)
	    printf("Wrote %d byte OSPF packet through linktype %d\n", n,
		   l->linktype);
      }
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return (n);
   }
    /* end of data link layer */ 
   else {
      libnet_build_ip(LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
		      LIBNET_LS_AS_EXT_LEN,	/* size of packet */
		      tos,	/* type of service */
		      id,	/* IP id */
		      frag,	/* frag shit - best to not frag */
		      ttl,	/* TTL */
		      IPPROTO_OSPF,	/* transport protocol */
		      source,	/* source address */
		      dest,	/* destination address */
		      NULL,	/* IP payload pointer */
		      0,	/* IP payload size */
		      pkt);	/* packet header memory */

      libnet_build_ospf(LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN,
      /* size of packet */
			LIBNET_OSPF_LSA,	/* OSPF type */
			addrid,	/* router ID */
			addaid,	/* area ID */
			LIBNET_OSPF_AUTH_NULL,	/* auth type */
			NULL,	/* OSPF payload pointer */
			0,	/* OSPF payload size */
			pkt + LIBNET_IP_H);	/* packet header memory */

      auth[0] = 0;
      auth[1] = 0;

      LIBNET_OSPF_AUTHCPY(pkt + LIBNET_OSPF_H + LIBNET_IP_H, auth);

      libnet_build_ospf_lsa(ospf_age,
			    ooptions,
			    LIBNET_LS_TYPE_ASEXT,
			    rtrid,
			    router,
			    seqnum,
			    LIBNET_LS_AS_EXT_LEN,
			    NULL,
			    0,
			 pkt + LIBNET_AUTH_H + LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_build_ospf_lsa_as(mask,
			       metric,
			       as_fwd,
			       as_tag,
			       payload,
			       payload_s,
			       pkt + LIBNET_LSA_H + LIBNET_AUTH_H +
			       LIBNET_OSPF_H + LIBNET_IP_H);

      libnet_do_checksum(pkt, IPPROTO_OSPF, LIBNET_IP_H + LIBNET_OSPF_H +
		       LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN);

      libnet_do_checksum(pkt + LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H,
	 IPPROTO_OSPF_LSA, LIBNET_LS_AS_EXT_LEN + LIBNET_LSA_H + payload_s);


      memcpy(ipopt.ipopt_list, options, option_s);
      *(ipopt.ipopt_list) = IPOPT_SECURITY;
      *(ipopt.ipopt_list + 1) = 1;

      c = libnet_insert_ipo(&ipopt,	/* pointer to ipopt struct */
			    option_s,	/* Length of option list */
			    pkt);	/* Packet header memory */

      if (c == -1) {
	 fprintf(stderr, "Can't add options, discarding them.\n");
      }
      c = libnet_write_ip(sockfd, pkt, LIBNET_IP_H + LIBNET_OSPF_H +
		       LIBNET_AUTH_H + LIBNET_LSA_H + LIBNET_LS_AS_EXT_LEN +
			  payload_s + option_s);

      if (c < LIBNET_IP_H + LIBNET_OSPF_H + LIBNET_AUTH_H + LIBNET_LSA_H +
	  LIBNET_LS_AS_EXT_LEN + payload_s + option_s) {
	 libnet_destroy_packet(&pkt);
	 libnet_close_raw_sock(sockfd);
	 fprintf(stderr, "write_ip\n");
	 return -1;
      }
      if (verbose)
	 printf("Wrote %d bytes\n", c);
      libnet_destroy_packet(&pkt);
      libnet_close_raw_sock(sockfd);
      return 0;
   }
}
