/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

void
wireExcpt_serialize(SDR_stream *strm, const void *ob)
{
  const WireException *ex = ob;
  
  sdr_w_string("name", strm, ex->name);
  sdr_w_string("fname", strm, ex->fname);
  sdr_w_u32("line", strm, ex->line);
  sdr_w_string("str", strm, ex->str);
  
} /* end wireExcpt_serialize */

void *
wireExcpt_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  WireException *ex =
    (WireException *) GC_MALLOC(sizeof(WireException));

  ser_init(ex, &WireException_SerType, di->ver);
  ex->name          = sdr_r_string("name", strm);
  ex->fname         = sdr_r_string("fname", strm);
  ex->line          = sdr_r_u32("line", strm);
  ex->str           = sdr_r_string("str", strm);

  SER_MODIFIED(ex);

  return ex;
} /* end wireExcpt_deserialize */

void
wireExcpt_mark(Repository *r, const void *container, 
	       const void *ob, rbtree *memObs)
{
  assert(container == ob);
  /* Leaf object. Nothing to do */
}

WireException *
wireExcpt_create(Exception excpt, const char *fname,
		 uint32_t line, const char *str)
{
  WireException *ex = 
    (WireException *) GC_MALLOC(sizeof(WireException));

  ser_init(ex, &WireException_SerType, WireException_SerType.ver);

  ex->name = EXCEPTION_NAME(excpt);
  ex->fname = fname;
  ex->line = line;
  ex->str = str;

  SER_MODIFIED(ex);

  return ex;
} /* end wireExcpt_create */

OC_bool
wireExcpt_check(const void *v)
{
  return TRUE;
}

void
wireExcpt_show(const void *ob)
{
  const WireException *ex = ob;
  report(0, "Name:     %s\n", ex->name);
  report(0, "File:     %s\n", ex->fname);
  report(0, "Line:     %u\n", ex->line);
  report(0, "Str:      %s\n", ex->str);
}
