#ifndef COMMON_SXDELTA_H
#define COMMON_SXDELTA_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define SDR_XDCS SDR_RAW

typedef struct SXDelta {
  Serializable ser;

  Buffer *ins;
  Buffer *cmd;
} SXDelta;

SXDelta *sxdelta_create(Buffer *cmd, Buffer *ins);

typedef struct xdirent_t {
  unsigned const char *name;	/* entry name */

  /* only in-memory copy: */
  SXDelta *sxdelta;

} xdirent_t;

typedef struct XDeltaArchive_t {
  const char *magic;		/* "sxd2" */
  unsigned short version;	/* currently 2 */
  unsigned short flags;		/* currently 0 */

  uint32_t nDirent;	/* number of entries */
  uint32_t maxDirent;	/* allocated dir space */

  struct xdirent_t *dir;
} XDeltaArchive_t;


void xdcs_iterate(XDeltaArchive_t *xda, 
		  void (*fn)(XDeltaArchive_t *xda, xdirent_t *, void *aux), 
		  void *aux);

void xdcs_insert(SDR_stream *archive, 
		 SDR_stream *content,
		 const char *name,
		 SDR_stream *output);

void xdcs_extract(XDeltaArchive_t *xda,
		  const char *name, 
		  SDR_stream *outFile);

XDeltaArchive_t *xda_fromStream(SDR_stream *s);

SXDelta *xdcs_gen_delta(Buffer *src, Buffer *dst);

Buffer *xdcs_apply_delta(Buffer *base, SXDelta *xd);

#endif /* COMMON_SXDELTA_H */
