#!/usr/bin/python
# $Id: quickreference.py,v 1.3.2.2 2002/06/14 14:59:53 rp Exp $
#
# PDFlib/PDI client: mini imposition demo
#

from sys import *
from pdflib_py import *

p = PDF_new()

if PDF_open_file(p, "quickreference.pdf") == -1:
    print "Couldn't open PDF file 'quickreference.pdf'\n"
    exit(2)

PDF_set_info(p, "Author", "Thomas Merz")
PDF_set_info(p, "Creator", "quickreference.py")
PDF_set_info(p, "Title", "mini imposition demo (Python)")

infile = "../../doc/PDFlib-manual.pdf"
manual = PDF_open_pdi(p, infile, "", 0)

if manual == -1:
    print "Couldn't open input file '" + infile + "'\n"
    exit(2)

maxrow = 2
maxcol = 2
startpage = 132
endpage = 135
width = 500.0
height = 770.0

row = 0
col = 0

for pageno in range(startpage, endpage+1):
    if row == 0 and col == 0:
	PDF_begin_page(p, width, height)
	font = PDF_findfont(p, "Helvetica-Bold", "host", 0)
	PDF_setfont(p, font, 18)
	PDF_set_text_pos(p, 25, height-24)
	PDF_show(p, "PDFlib 4.0 Quick Reference")

    page = PDF_open_pdi_page(p, manual, pageno, "")

    if page == -1:
	print "Couldn't open page", pageno, "in '" + infile + "'.\n"
	exit(2)

    PDF_place_pdi_page(p, page, width/maxcol*col, height - (row + 1) 
		    * height/maxrow, 1.0/maxrow, 1.0/maxrow)
    PDF_close_pdi_page(p, page)

    col = col+1
    if col == maxcol:
	col = 0
	row = row+1

    if row == maxrow:
	row = 0
	PDF_end_page(p)

# finish the last partial page
if row != 0 or col != 0:
    PDF_end_page(p)

PDF_close(p)
PDF_close_pdi(p, manual)
PDF_delete(p)
