/* ScummVM - Scumm Interpreter
 * Copyright (C) 2001/2002 The ScummVM project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /cvsroot/scummvm/scummvm/backends/wince/bitmaps.cpp,v 1.3 2002/11/19 08:14:58 arisme Exp $
 *
 */

#ifdef _WIN32_WCE

// Bitmaps used for WCE

#include <windows.h>
#include "screen.h"

// Loading

unsigned char item_loading_colors[] = { 
	0xff, 0xff, 0xff, 
	0x04, 0x02, 0x04, 
	0x21, 0x11, 0x1d, 
	0x40, 0x21, 0x37, 
	0x2c, 0x17, 0x26, 
	0x7d, 0x41, 0x6b, 
	0xf6, 0x80, 0xd3, 
	0xb9, 0x60, 0x9f, 
	0x90, 0x4b, 0x7c, 
	0x18, 0x0c, 0x15, 
	0x9b, 0x51, 0x85, 
	0x5e, 0x31, 0x51, 
	0xcd, 0x6b, 0xb0, 
	0xe1, 0x75, 0xc1, 
	0x36, 0x1c, 0x2f, 
	0xc3, 0x65, 0xa7, 
	0x4a, 0x27, 0x40, 
	0xd8, 0x70, 0xb9, 
	0x72, 0x3b, 0x62, 
	0x55, 0x2c, 0x49, 
	0x87, 0x46, 0x74, 
	0xaf, 0x5b, 0x96, 
	0xec, 0x7b, 0xca, 
	0x69, 0x36, 0x5a, 
	0xa5, 0x56, 0x8e

};
unsigned char item_loading[] = { 
	0x00, 0x2c, 0x01, 0x02, 0x03, 0x04, 0x00, 0x61, 0x01, 
	0x05, 0x06, 0x07, 0x00, 0x3a, 0x01, 0x05, 0x06, 0x06, 
	0x03, 0x00, 0x23, 0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x00, 0x35, 0x01, 0x05, 0x06, 0x06, 
	0x03, 0x00, 0x23, 0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x00, 0x35, 0x01, 0x05, 0x06, 0x06, 
	0x03, 0x00, 0x23, 0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 
	0x08, 0x07, 0x07, 0x00, 0x35, 0x01, 0x05, 0x06, 0x06, 
	0x03, 0x00, 0x09, 0x01, 0x09, 0x03, 0x03, 0x09, 0x00, 
	0x16, 0x01, 0x05, 0x06, 0x07, 0x00, 0x3a, 0x01, 0x05, 
	0x06, 0x06, 0x03, 0x00, 0x07, 0x01, 0x09, 0x0a, 0x00, 
	0x04, 0x06, 0x0a, 0x09, 0x00, 0x05, 0x01, 0x0b, 0x0c, 
	0x06, 0x0d, 0x08, 0x00, 0x05, 0x01, 0x0e, 0x0c, 0x06, 
	0x0d, 0x0a, 0x0a, 0x06, 0x07, 0x01, 0x01, 0x08, 0x07, 
	0x07, 0x01, 0x01, 0x08, 0x07, 0x07, 0x09, 0x08, 0x0d, 
	0x06, 0x0f, 0x04, 0x00, 0x04, 0x01, 0x10, 0x0c, 0x06, 
	0x06, 0x0c, 0x05, 0x05, 0x05, 0x0b, 0x00, 0x1d, 0x01, 
	0x05, 0x06, 0x06, 0x03, 0x00, 0x06, 0x01, 0x09, 0x0c, 
	0x06, 0x06, 0x0c, 0x0c, 0x06, 0x06, 0x0c, 0x01, 0x01, 
	0x01, 0x04, 0x11, 0x00, 0x05, 0x06, 0x12, 0x01, 0x01, 
	0x01, 0x13, 0x00, 0x07, 0x06, 0x07, 0x01, 0x01, 0x07, 
	0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 0x0c, 0x00, 
	0x04, 0x06, 0x11, 0x01, 0x01, 0x01, 0x13, 0x06, 0x06, 
	0x0a, 0x14, 0x0d, 0x06, 0x06, 0x06, 0x07, 0x00, 0x1d, 
	0x01, 0x05, 0x06, 0x06, 0x03, 0x00, 0x06, 0x01, 0x05, 
	0x06, 0x06, 0x13, 0x01, 0x01, 0x05, 0x06, 0x06, 0x0b, 
	0x01, 0x01, 0x13, 0x06, 0x15, 0x02, 0x09, 0x15, 0x06, 
	0x07, 0x01, 0x01, 0x04, 0x06, 0x06, 0x06, 0x15, 0x05, 
	0x0f, 0x06, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x06, 
	0x01, 0x01, 0x07, 0x06, 0x06, 0x06, 0x0f, 0x14, 0x0d, 
	0x06, 0x06, 0x04, 0x01, 0x01, 0x0d, 0x06, 0x05, 0x01, 
	0x01, 0x0e, 0x06, 0x16, 0x03, 0x04, 0x00, 0x1d, 0x01, 
	0x05, 0x06, 0x06, 0x03, 0x00, 0x06, 0x01, 0x0d, 0x06, 
	0x0c, 0x00, 0x04, 0x01, 0x06, 0x06, 0x07, 0x01, 0x01, 
	0x01, 0x03, 0x01, 0x01, 0x01, 0x05, 0x06, 0x07, 0x01, 
	0x01, 0x0a, 0x06, 0x06, 0x17, 0x01, 0x01, 0x01, 0x14, 
	0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x17, 0x01, 0x01, 0x14, 0x06, 0x06, 
	0x03, 0x01, 0x01, 0x06, 0x06, 0x03, 0x01, 0x01, 0x01, 
	0x06, 0x06, 0x03, 0x00, 0x1e, 0x01, 0x05, 0x06, 0x06, 
	0x03, 0x00, 0x05, 0x01, 0x04, 0x06, 0x06, 0x14, 0x00, 
	0x04, 0x01, 0x07, 0x06, 0x06, 0x00, 0x04, 0x01, 0x02, 
	0x12, 0x15, 0x11, 0x06, 0x07, 0x01, 0x01, 0x0d, 0x06, 
	0x11, 0x00, 0x04, 0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 
	0x01, 0x01, 0x05, 0x06, 0x06, 0x03, 0x01, 0x01, 0x0d, 
	0x06, 0x05, 0x01, 0x01, 0x0e, 0x06, 0x06, 0x04, 0x00, 
	0x1e, 0x01, 0x05, 0x06, 0x06, 0x03, 0x00, 0x05, 0x01, 
	0x03, 0x06, 0x06, 0x05, 0x00, 0x04, 0x01, 0x07, 0x06, 
	0x06, 0x01, 0x01, 0x01, 0x08, 0x06, 0x06, 0x11, 0x11, 
	0x06, 0x07, 0x01, 0x01, 0x06, 0x06, 0x07, 0x00, 0x04, 
	0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x06, 
	0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 0x01, 0x05, 
	0x06, 0x06, 0x03, 0x01, 0x01, 0x13, 0x06, 0x06, 0x14, 
	0x14, 0x0d, 0x06, 0x18, 0x00, 0x1f, 0x01, 0x05, 0x06, 
	0x06, 0x03, 0x00, 0x05, 0x01, 0x03, 0x06, 0x06, 0x05, 
	0x00, 0x04, 0x01, 0x0c, 0x06, 0x06, 0x01, 0x01, 0x15, 
	0x06, 0x0c, 0x0e, 0x01, 0x05, 0x06, 0x07, 0x01, 0x01, 
	0x06, 0x06, 0x11, 0x00, 0x04, 0x01, 0x05, 0x06, 0x07, 
	0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 
	0x06, 0x01, 0x01, 0x01, 0x05, 0x06, 0x06, 0x03, 0x01, 
	0x01, 0x10, 0x0d, 0x16, 0x06, 0x06, 0x11, 0x05, 0x00, 
	0x20, 0x01, 0x05, 0x06, 0x06, 0x03, 0x00, 0x06, 0x01, 
	0x06, 0x06, 0x0c, 0x01, 0x01, 0x01, 0x09, 0x06, 0x06, 
	0x15, 0x01, 0x04, 0x06, 0x06, 0x02, 0x01, 0x01, 0x05, 
	0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x06, 0x0e, 0x01, 
	0x01, 0x01, 0x14, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 
	0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 0x01, 
	0x05, 0x06, 0x06, 0x03, 0x01, 0x18, 0x06, 0x15, 0x00, 
	0x25, 0x01, 0x05, 0x06, 0x06, 0x17, 0x00, 0x04, 0x03, 
	0x04, 0x01, 0x0a, 0x06, 0x06, 0x13, 0x01, 0x01, 0x18, 
	0x06, 0x06, 0x0b, 0x01, 0x03, 0x06, 0x06, 0x02, 0x01, 
	0x09, 0x0c, 0x06, 0x07, 0x01, 0x01, 0x0b, 0x06, 0x06, 
	0x0d, 0x12, 0x03, 0x05, 0x06, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 
	0x01, 0x01, 0x05, 0x06, 0x06, 0x03, 0x03, 0x06, 0x06, 
	0x0d, 0x07, 0x05, 0x12, 0x03, 0x02, 0x00, 0x0a, 0x01, 
	0x0b, 0x07, 0x07, 0x04, 0x01, 0x01, 0x08, 0x07, 0x07, 
	0x01, 0x01, 0x01, 0x07, 0x07, 0x08, 0x00, 0x07, 0x01, 
	0x05, 0x00, 0x07, 0x06, 0x07, 0x01, 0x09, 0x0d, 0x06, 
	0x06, 0x07, 0x11, 0x06, 0x06, 0x18, 0x01, 0x01, 0x01, 
	0x0d, 0x06, 0x0d, 0x07, 0x0d, 0x06, 0x06, 0x06, 0x05, 
	0x0e, 0x01, 0x0c, 0x00, 0x07, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 
	0x01, 0x01, 0x05, 0x06, 0x06, 0x03, 0x01, 0x0a, 0x00, 
	0x07, 0x06, 0x0f, 0x04, 0x00, 0x08, 0x01, 0x05, 0x06, 
	0x06, 0x03, 0x01, 0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 
	0x01, 0x06, 0x06, 0x07, 0x00, 0x07, 0x01, 0x05, 0x00, 
	0x07, 0x06, 0x07, 0x01, 0x01, 0x04, 0x0f, 0x06, 0x06, 
	0x06, 0x0d, 0x05, 0x00, 0x04, 0x01, 0x04, 0x0d, 0x06, 
	0x06, 0x11, 0x03, 0x0d, 0x06, 0x06, 0x12, 0x01, 0x09, 
	0x0f, 0x06, 0x06, 0x06, 0x11, 0x18, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x06, 0x01, 0x01, 0x07, 0x06, 0x06, 
	0x01, 0x01, 0x01, 0x05, 0x06, 0x06, 0x03, 0x01, 0x01, 
	0x05, 0x06, 0x0f, 0x07, 0x0c, 0x06, 0x06, 0x06, 0x0d, 
	0x00, 0x08, 0x01, 0x05, 0x06, 0x06, 0x03, 0x01, 0x01, 
	0x07, 0x06, 0x06, 0x01, 0x01, 0x01, 0x06, 0x06, 0x07, 
	0x00, 0x07, 0x01, 0x02, 0x00, 0x07, 0x03, 0x04, 0x00, 
	0x04, 0x01, 0x02, 0x03, 0x03, 0x00, 0x08, 0x01, 0x03, 
	0x03, 0x01, 0x01, 0x09, 0x03, 0x09, 0x00, 0x04, 0x01, 
	0x02, 0x03, 0x04, 0x01, 0x02, 0x03, 0x04, 0x01, 0x01, 
	0x04, 0x03, 0x03, 0x01, 0x01, 0x04, 0x03, 0x03, 0x01, 
	0x01, 0x01, 0x02, 0x03, 0x03, 0x09, 0x01, 0x18, 0x06, 
	0x18, 0x00, 0x04, 0x01, 0x18, 0x06, 0x06, 0x03, 0x00, 
	0x07, 0x01, 0x02, 0x03, 0x03, 0x09, 0x01, 0x01, 0x04, 
	0x03, 0x03, 0x01, 0x01, 0x01, 0x03, 0x03, 0x04, 0x00, 
	0x42, 0x01, 0x04, 0x06, 0x06, 0x00, 0x05, 0x01, 0x03, 
	0x06, 0x06, 0x03, 0x00, 0x58, 0x01, 0x04, 0x06, 0x06, 
	0x0e, 0x00, 0x04, 0x01, 0x15, 0x06, 0x11, 0x00, 0x5a, 
	0x01, 0x0c, 0x06, 0x06, 0x0a, 0x05, 0x14, 0x11, 0x06, 
	0x0d, 0x04, 0x00, 0x5a, 0x01, 0x09, 0x0a, 0x00, 0x05, 
	0x06, 0x0a, 0x02, 0x00, 0x5e, 0x01, 0x03, 0x03, 0x03, 
	0x00, 0xe5, 0x01, 0x00, 0x00 
};

// *************************************************************************
//									PORTRAIT				
// *************************************************************************

// Toolbar

unsigned char item_toolbarPortrait_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0xe7, 0x63, 0x18, 
	0xe7, 0x5a, 0x18, 
	0xde, 0x52, 0x18, 
	0xde, 0x4a, 0x18, 
	0xde, 0x42, 0x10, 
	0x9c, 0x31, 0x10, 
	0xe7, 0x39, 0x18, 
	0x94, 0x21, 0x10, 
	0x52, 0x21, 0x08, 
	0xf7, 0x84, 0x18, 
	0xef, 0x7b, 0x10, 
	0xde, 0x39, 0x10, 
	0xd6, 0x31, 0x10, 
	0xad, 0x29, 0x10, 
	0x42, 0x10, 0x00, 
	0x4a, 0x18, 0x00, 
	0xde, 0x5a, 0x08, 
	0xce, 0x6b, 0x10, 
	0xe7, 0x6b, 0x10, 
	0xd6, 0x6b, 0x18, 
	0xef, 0x5a, 0x18, 
	0xce, 0x42, 0x10, 
	0xa5, 0x31, 0x10, 
	0x8c, 0x31, 0x08, 
	0xd6, 0x4a, 0x10, 
	0xbd, 0x39, 0x10, 
	0xad, 0x42, 0x10, 
	0xce, 0x31, 0x10, 
	0xb5, 0x29, 0x10, 
	0x8c, 0x21, 0x08, 
	0x31, 0x08, 0x00, 
	0xde, 0x6b, 0x10, 
	0xce, 0x5a, 0x08, 
	0xad, 0x4a, 0x08, 
	0xc6, 0x5a, 0x08, 
	0xb5, 0x52, 0x08, 
	0xde, 0x6b, 0x08, 
	0xe7, 0x63, 0x10, 
	0xa5, 0x5a, 0x10, 
	0xc6, 0x6b, 0x18, 
	0xff, 0x52, 0x18, 
	0xf7, 0x42, 0x18, 
	0xef, 0x39, 0x18, 
	0x7b, 0x21, 0x08, 
	0x5a, 0x18, 0x08, 
	0xc6, 0x31, 0x18, 
	0x42, 0x18, 0x00, 
	0xde, 0x63, 0x08, 
	0xd6, 0x5a, 0x08, 
	0xce, 0x52, 0x08, 
	0x5a, 0x29, 0x00, 
	0xce, 0x63, 0x08, 
	0xd6, 0x52, 0x08, 
	0xbd, 0x4a, 0x08, 
	0x63, 0x29, 0x00, 
	0xef, 0x6b, 0x10, 
	0x7b, 0x42, 0x08, 
	0xe7, 0x7b, 0x21, 
	0xad, 0x5a, 0x18, 
	0xff, 0x4a, 0x18, 
	0xff, 0x42, 0x18, 
	0xbd, 0x31, 0x10, 
	0x9c, 0x29, 0x10, 
	0x6b, 0x18, 0x08, 
	0x73, 0x21, 0x08, 
	0xff, 0x63, 0x18, 
	0xc6, 0x31, 0x10, 
	0xa5, 0x29, 0x10, 
	0x84, 0x21, 0x08, 
	0x6b, 0x21, 0x08, 
	0xe7, 0x63, 0x08, 
	0xf7, 0x63, 0x08, 
	0xef, 0x63, 0x08, 
	0xe7, 0x5a, 0x08, 
	0x8c, 0x39, 0x08, 
	0x31, 0x10, 0x00, 
	0x7b, 0x31, 0x00, 
	0x39, 0x18, 0x00, 
	0xef, 0x63, 0x10, 
	0xe7, 0x73, 0x10, 
	0xef, 0x73, 0x18, 
	0xe7, 0x7b, 0x29, 
	0xd6, 0x39, 0x10, 
	0x73, 0x18, 0x08, 
	0x52, 0x18, 0x08, 
	0xc6, 0x42, 0x10, 
	0xb5, 0x4a, 0x08, 
	0xc6, 0x5a, 0x10, 
	0xbd, 0x5a, 0x10, 
	0xc6, 0x63, 0x10, 
	0xc6, 0x4a, 0x08, 
	0x52, 0x21, 0x00, 
	0x29, 0x10, 0x00, 
	0xad, 0x42, 0x08, 
	0x4a, 0x21, 0x00, 
	0xf7, 0x73, 0x18, 
	0xff, 0x84, 0x29, 
	0xde, 0x73, 0x29, 
	0xff, 0x5a, 0x18, 
	0xb5, 0x31, 0x10, 
	0xef, 0x42, 0x18, 
	0x52, 0x10, 0x08, 
	0x4a, 0x10, 0x08, 
	0x8c, 0x29, 0x10, 
	0xd6, 0x52, 0x18, 
	0x84, 0x31, 0x00, 
	0x6b, 0x31, 0x00, 
	0xa5, 0x42, 0x08, 
	0x9c, 0x42, 0x08, 
	0xd6, 0x73, 0x10, 
	0x73, 0x29, 0x00, 
	0x7b, 0x39, 0x08, 
	0xff, 0x73, 0x10, 
	0xc6, 0x52, 0x08, 
	0xf7, 0x7b, 0x21, 
	0xff, 0x8c, 0x31, 
	0xc6, 0x6b, 0x21, 
	0x52, 0x29, 0x00, 
	0x63, 0x18, 0x08, 
	0x39, 0x10, 0x00, 
	0xef, 0x5a, 0x08, 
	0x84, 0x39, 0x00, 
	0x5a, 0x21, 0x00, 
	0x73, 0x39, 0x08, 
	0x8c, 0x39, 0x00, 
	0xef, 0x73, 0x10, 
	0xa5, 0x52, 0x18, 
	0x4a, 0x29, 0x00, 
	0xff, 0x63, 0x08, 
	0xbd, 0x63, 0x10, 
	0xf7, 0x6b, 0x10, 
	0x42, 0x21, 0x00, 
	0xf7, 0x39, 0x18, 
	0xf7, 0x63, 0x18, 
	0x94, 0x39, 0x08, 
	0x6b, 0x29, 0x00, 
	0xff, 0x6b, 0x10, 
	0xce, 0x63, 0x18, 
	0x63, 0x21, 0x08, 
	0x73, 0x31, 0x00, 
	0x63, 0x31, 0x08, 
	0xa5, 0x4a, 0x08, 
	0xef, 0x4a, 0x18, 
	0xb5, 0x52, 0x10, 
	0xe7, 0x42, 0x18, 
	0x31, 0x18, 0x00, 
	0x84, 0x42, 0x08, 
	0xd6, 0x6b, 0x21, 
	0x94, 0x31, 0x10, 
	0x73, 0x29, 0x08, 
	0x8c, 0x42, 0x08, 
	0xbd, 0x52, 0x08, 
	0xbd, 0x5a, 0x18, 
	0x7b, 0x29, 0x00, 
	0xde, 0x73, 0x21, 
	0x9c, 0x21, 0x10, 
	0x9c, 0x4a, 0x10, 
	0xef, 0x7b, 0x29, 
	0xe7, 0x42, 0x21, 
	0xd6, 0x42, 0x10, 
	0xce, 0x42, 0x21, 
	0x94, 0x29, 0x18, 
	0xce, 0x39, 0x10, 
	0x63, 0x21, 0x00, 
	0xe7, 0x52, 0x18, 
	0xe7, 0x4a, 0x18, 
	0xa5, 0x42, 0x10, 
	0x94, 0x39, 0x00, 
	0xc6, 0x39, 0x10, 
	0x9c, 0x4a, 0x08, 
	0x52, 0x31, 0x00

};
unsigned char item_toolbarPortrait[] = { 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0x28, 0x01, 
	0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x00, 0xff, 0x01, 
	0x00, 0x3b, 0x01, 0x00, 0x04, 0x08, 0x09, 0x0a, 0x00, 
	0x46, 0x01, 0x0b, 0x0c, 0x0b, 0x00, 0xf1, 0x01, 0x08, 
	0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x00, 0x36, 0x01, 0x12, 
	0x13, 0x00, 0x0e, 0x01, 0x14, 0x12, 0x15, 0x00, 0xc6, 
	0x01, 0x16, 0x17, 0x18, 0x19, 0x00, 0x1e, 0x01, 0x04, 
	0x1a, 0x17, 0x1b, 0x1c, 0x00, 0x04, 0x01, 0x08, 0x1d, 
	0x1e, 0x1f, 0x20, 0x11, 0x00, 0x1d, 0x01, 0x21, 0x22, 
	0x22, 0x23, 0x01, 0x01, 0x00, 0x04, 0x24, 0x25, 0x00, 
	0x0d, 0x01, 0x26, 0x27, 0x28, 0x00, 0x0d, 0x01, 0x0c, 
	0x12, 0x02, 0x29, 0x00, 0xc4, 0x01, 0x2a, 0x2b, 0x2c, 
	0x1d, 0x0f, 0x2d, 0x2e, 0x00, 0x1b, 0x01, 0x2b, 0x2c, 
	0x08, 0x08, 0x0d, 0x2f, 0x0f, 0x2d, 0x01, 0x01, 0x01, 
	0x08, 0x2f, 0x0f, 0x1f, 0x20, 0x30, 0x00, 0x1b, 0x01, 
	0x31, 0x32, 0x12, 0x12, 0x33, 0x34, 0x01, 0x35, 0x32, 
	0x36, 0x36, 0x37, 0x38, 0x00, 0x0d, 0x01, 0x12, 0x39, 
	0x3a, 0x00, 0x0d, 0x01, 0x31, 0x27, 0x3b, 0x3c, 0x00, 
	0xc3, 0x01, 0x3d, 0x3e, 0x2c, 0x08, 0x3f, 0x40, 0x1f, 
	0x41, 0x42, 0x00, 0x18, 0x01, 0x43, 0x3e, 0x2b, 0x2c, 
	0x08, 0x0d, 0x0e, 0x44, 0x45, 0x46, 0x47, 0x01, 0x01, 
	0x08, 0x1d, 0x0f, 0x1f, 0x20, 0x30, 0x00, 0x08, 0x01, 
	0x22, 0x25, 0x00, 0x10, 0x01, 0x48, 0x49, 0x4a, 0x4b, 
	0x12, 0x4c, 0x4d, 0x01, 0x35, 0x12, 0x12, 0x33, 0x4e, 
	0x4f, 0x00, 0x0c, 0x01, 0x31, 0x50, 0x27, 0x34, 0x00, 
	0x0c, 0x01, 0x51, 0x12, 0x52, 0x53, 0x00, 0xc3, 0x01, 
	0x2a, 0x2b, 0x54, 0x3f, 0x3f, 0x0f, 0x1f, 0x2d, 0x55, 
	0x2d, 0x00, 0x18, 0x01, 0x3e, 0x2c, 0x1d, 0x3f, 0x1e, 
	0x1e, 0x1e, 0x0f, 0x09, 0x41, 0x2e, 0x01, 0x01, 0x08, 
	0x1d, 0x0f, 0x46, 0x20, 0x56, 0x1b, 0x57, 0x1b, 0x01, 
	0x01, 0x01, 0x48, 0x4a, 0x12, 0x58, 0x4c, 0x00, 0x06, 
	0x01, 0x21, 0x35, 0x59, 0x24, 0x5a, 0x5b, 0x01, 0x01, 
	0x14, 0x4a, 0x49, 0x4b, 0x5c, 0x23, 0x5d, 0x5e, 0x01, 
	0x35, 0x12, 0x12, 0x5f, 0x5d, 0x60, 0x00, 0x0b, 0x01, 
	0x51, 0x4b, 0x61, 0x59, 0x5d, 0x23, 0x00, 0x0a, 0x01, 
	0x0b, 0x12, 0x02, 0x62, 0x63, 0x00, 0xbb, 0x01, 0x64, 
	0x3d, 0x08, 0x0e, 0x3f, 0x09, 0x01, 0x01, 0x2b, 0x0e, 
	0x3f, 0x3f, 0x3f, 0x65, 0x09, 0x41, 0x41, 0x2d, 0x07, 
	0x01, 0x01, 0x01, 0x3d, 0x66, 0x2c, 0x08, 0x0e, 0x65, 
	0x09, 0x18, 0x00, 0x04, 0x08, 0x2c, 0x3f, 0x42, 0x00, 
	0x04, 0x01, 0x2a, 0x2b, 0x2f, 0x1e, 0x1e, 0x00, 0x04, 
	0x0f, 0x40, 0x67, 0x68, 0x69, 0x6a, 0x08, 0x1d, 0x0f, 
	0x1f, 0x68, 0x0f, 0x0d, 0x0e, 0x46, 0x01, 0x0c, 0x4a, 
	0x49, 0x4a, 0x12, 0x5f, 0x6b, 0x6c, 0x01, 0x01, 0x01, 
	0x0c, 0x48, 0x4b, 0x32, 0x36, 0x33, 0x5c, 0x6d, 0x6e, 
	0x6f, 0x31, 0x4b, 0x4a, 0x37, 0x6d, 0x6e, 0x5d, 0x5e, 
	0x01, 0x22, 0x12, 0x12, 0x6d, 0x5d, 0x70, 0x71, 0x00, 
	0x0a, 0x01, 0x12, 0x39, 0x72, 0x23, 0x60, 0x73, 0x00, 
	0x0a, 0x01, 0x27, 0x12, 0x74, 0x75, 0x76, 0x77, 0x00, 
	0xb9, 0x01, 0x3e, 0x3e, 0x2c, 0x0d, 0x1d, 0x3f, 0x0f, 
	0x09, 0x54, 0x08, 0x00, 0x05, 0x3f, 0x45, 0x55, 0x78, 
	0x41, 0x69, 0x01, 0x2a, 0x3e, 0x2b, 0x08, 0x08, 0x0d, 
	0x1d, 0x1e, 0x40, 0x0f, 0x08, 0x2c, 0x08, 0x08, 0x0f, 
	0x2e, 0x41, 0x00, 0x04, 0x01, 0x2b, 0x08, 0x1e, 0x1e, 
	0x0f, 0x46, 0x41, 0x45, 0x0f, 0x45, 0x67, 0x1f, 0x1d, 
	0x08, 0x08, 0x1d, 0x0f, 0x40, 0x45, 0x0e, 0x1d, 0x1f, 
	0x79, 0x6d, 0x49, 0x49, 0x7a, 0x33, 0x5f, 0x6e, 0x4e, 
	0x38, 0x6c, 0x01, 0x01, 0x4a, 0x49, 0x4a, 0x12, 0x33, 
	0x33, 0x37, 0x6d, 0x7b, 0x7b, 0x25, 0x33, 0x73, 0x6d, 
	0x6d, 0x6e, 0x7c, 0x5e, 0x01, 0x22, 0x12, 0x12, 0x6d, 
	0x5d, 0x7b, 0x4c, 0x7d, 0x00, 0x08, 0x01, 0x21, 0x27, 
	0x72, 0x61, 0x4c, 0x30, 0x12, 0x7e, 0x00, 0x08, 0x01, 
	0x7f, 0x12, 0x52, 0x75, 0x75, 0x80, 0x81, 0x00, 0xb8, 
	0x01, 0x3e, 0x2b, 0x54, 0x2f, 0x44, 0x3f, 0x0f, 0x45, 
	0x45, 0x0d, 0x0e, 0x00, 0x05, 0x3f, 0x1e, 0x2d, 0x78, 
	0x78, 0x09, 0x54, 0x3e, 0x2c, 0x1d, 0x2f, 0x3f, 0x3f, 
	0x3f, 0x45, 0x1f, 0x09, 0x0e, 0x2f, 0x44, 0x65, 0x41, 
	0x68, 0x41, 0x00, 0x04, 0x01, 0x2c, 0x1d, 0x1e, 0x1e, 
	0x40, 0x2e, 0x42, 0x1e, 0x1e, 0x0f, 0x55, 0x2f, 0x54, 
	0x08, 0x2c, 0x1d, 0x0f, 0x0f, 0x1e, 0x1e, 0x0f, 0x67, 
	0x79, 0x37, 0x82, 0x4b, 0x37, 0x6d, 0x6e, 0x6d, 0x4c, 
	0x7c, 0x7c, 0x83, 0x4a, 0x49, 0x49, 0x32, 0x58, 0x5f, 
	0x5f, 0x6d, 0x6e, 0x4e, 0x38, 0x71, 0x5f, 0x5f, 0x6d, 
	0x6d, 0x6e, 0x7c, 0x5e, 0x01, 0x33, 0x12, 0x36, 0x6d, 
	0x5d, 0x7e, 0x5f, 0x38, 0x00, 0x08, 0x01, 0x12, 0x84, 
	0x72, 0x39, 0x6c, 0x30, 0x12, 0x37, 0x34, 0x00, 0x07, 
	0x01, 0x31, 0x27, 0x62, 0x75, 0x75, 0x71, 0x85, 0x00, 
	0xb8, 0x01, 0x08, 0x2f, 0x00, 0x04, 0x3f, 0x1e, 0x45, 
	0x45, 0x1d, 0x2f, 0x00, 0x04, 0x3f, 0x65, 0x65, 0x09, 
	0x2e, 0x2e, 0x40, 0x86, 0x2c, 0x2f, 0x00, 0x04, 0x65, 
	0x1e, 0x0f, 0x2d, 0x55, 0x44, 0x3f, 0x65, 0x0f, 0x78, 
	0x68, 0x55, 0x01, 0x01, 0x01, 0x87, 0x08, 0x3f, 0x1e, 
	0x0f, 0x46, 0x68, 0x1f, 0x1d, 0x1e, 0x0f, 0x2d, 0x2f, 
	0x3f, 0x3f, 0x1e, 0x00, 0x06, 0x0f, 0x2e, 0x56, 0x36, 
	0x4b, 0x58, 0x6d, 0x88, 0x4e, 0x37, 0x6d, 0x89, 0x30, 
	0x7b, 0x4a, 0x49, 0x36, 0x00, 0x06, 0x6d, 0x7e, 0x60, 
	0x5d, 0x37, 0x36, 0x73, 0x6d, 0x6e, 0x38, 0x5e, 0x01, 
	0x33, 0x12, 0x36, 0x6d, 0x5d, 0x7e, 0x33, 0x4e, 0x38, 
	0x00, 0x06, 0x01, 0x12, 0x50, 0x8a, 0x61, 0x73, 0x38, 
	0x30, 0x12, 0x12, 0x70, 0x7c, 0x00, 0x05, 0x01, 0x14, 
	0x12, 0x74, 0x75, 0x75, 0x8b, 0x89, 0x85, 0x00, 0xb8, 
	0x01, 0x44, 0x00, 0x06, 0x3f, 0x1e, 0x45, 0x3f, 0x44, 
	0x00, 0x04, 0x3f, 0x65, 0x65, 0x45, 0x2e, 0x2e, 0x45, 
	0x2b, 0x1d, 0x65, 0x65, 0x45, 0x46, 0x40, 0x1e, 0x1e, 
	0x46, 0x78, 0x1e, 0x3f, 0x65, 0x0f, 0x2e, 0x68, 0x2d, 
	0x01, 0x01, 0x01, 0x16, 0x08, 0x3f, 0x1e, 0x0f, 0x78, 
	0x68, 0x45, 0x08, 0x65, 0x0f, 0x2d, 0x3f, 0x00, 0x09, 
	0x0f, 0x78, 0x8c, 0x12, 0x5c, 0x6d, 0x6d, 0x8d, 0x88, 
	0x37, 0x6d, 0x8d, 0x4f, 0x4e, 0x4a, 0x4b, 0x5f, 0x6d, 
	0x6d, 0x6b, 0x4e, 0x6e, 0x6d, 0x6e, 0x30, 0x4f, 0x73, 
	0x7a, 0x33, 0x6d, 0x6e, 0x38, 0x5e, 0x01, 0x33, 0x12, 
	0x33, 0x6d, 0x5d, 0x88, 0x36, 0x88, 0x38, 0x8e, 0x00, 
	0x04, 0x01, 0x51, 0x48, 0x84, 0x8a, 0x27, 0x6d, 0x38, 
	0x30, 0x12, 0x12, 0x88, 0x38, 0x6c, 0x00, 0x04, 0x01, 
	0x12, 0x14, 0x62, 0x75, 0x53, 0x8f, 0x89, 0x85, 0x00, 
	0xb8, 0x01, 0x00, 0x08, 0x3f, 0x0f, 0x45, 0x3f, 0x3f, 
	0x3f, 0x00, 0x04, 0x65, 0x0f, 0x78, 0x2e, 0x1e, 0x08, 
	0x3f, 0x65, 0x65, 0x09, 0x2e, 0x1f, 0x1e, 0x65, 0x09, 
	0x2e, 0x0f, 0x3f, 0x65, 0x0f, 0x2e, 0x68, 0x2d, 0x01, 
	0x01, 0x01, 0x90, 0x08, 0x65, 0x1e, 0x45, 0x68, 0x68, 
	0x3f, 0x08, 0x65, 0x0f, 0x2d, 0x3f, 0x00, 0x09, 0x0f, 
	0x41, 0x47, 0x32, 0x6d, 0x6d, 0x88, 0x7c, 0x58, 0x37, 
	0x6d, 0x4e, 0x4d, 0x4c, 0x4a, 0x73, 0x6d, 0x6d, 0x6d, 
	0x5d, 0x89, 0x6d, 0x6d, 0x6d, 0x60, 0x4d, 0x33, 0x4b, 
	0x37, 0x6d, 0x6e, 0x89, 0x5e, 0x01, 0x33, 0x12, 0x33, 
	0x6e, 0x5d, 0x6e, 0x36, 0x6d, 0x6b, 0x38, 0x7d, 0x01, 
	0x01, 0x01, 0x12, 0x84, 0x8a, 0x39, 0x58, 0x6e, 0x38, 
	0x30, 0x12, 0x12, 0x6e, 0x6b, 0x7c, 0x7d, 0x01, 0x01, 
	0x31, 0x27, 0x74, 0x75, 0x75, 0x91, 0x88, 0x89, 0x4f, 
	0x00, 0xb8, 0x01, 0x00, 0x05, 0x3f, 0x65, 0x3f, 0x3f, 
	0x65, 0x45, 0x65, 0x3f, 0x00, 0x05, 0x65, 0x1e, 0x55, 
	0x2e, 0x3f, 0x0d, 0x65, 0x65, 0x1e, 0x09, 0x2e, 0x1f, 
	0x3f, 0x65, 0x45, 0x2e, 0x45, 0x3f, 0x65, 0x45, 0x67, 
	0x68, 0x46, 0x01, 0x01, 0x01, 0x92, 0x0d, 0x65, 0x1e, 
	0x09, 0x10, 0x10, 0x0e, 0x08, 0x1e, 0x0f, 0x2d, 0x3f, 
	0x00, 0x09, 0x0f, 0x55, 0x47, 0x33, 0x6d, 0x6d, 0x6b, 
	0x5d, 0x33, 0x37, 0x6d, 0x4e, 0x4d, 0x5f, 0x4a, 0x58, 
	0x6d, 0x6d, 0x6e, 0x60, 0x8d, 0x5c, 0x6d, 0x6d, 0x5d, 
	0x93, 0x33, 0x4b, 0x23, 0x6d, 0x6e, 0x70, 0x5e, 0x01, 
	0x36, 0x12, 0x33, 0x6e, 0x5d, 0x6e, 0x33, 0x6d, 0x6e, 
	0x4e, 0x38, 0x94, 0x01, 0x31, 0x27, 0x8a, 0x8a, 0x22, 
	0x6e, 0x6e, 0x89, 0x30, 0x12, 0x12, 0x6e, 0x6e, 0x8d, 
	0x7c, 0x94, 0x21, 0x12, 0x52, 0x62, 0x75, 0x95, 0x6e, 
	0x88, 0x70, 0x4f, 0x00, 0xb8, 0x01, 0x3f, 0x3f, 0x0f, 
	0x46, 0x78, 0x67, 0x2d, 0x1e, 0x65, 0x0f, 0x1e, 0x65, 
	0x65, 0x65, 0x0f, 0x2d, 0x1f, 0x1e, 0x46, 0x2e, 0x65, 
	0x1d, 0x65, 0x65, 0x1e, 0x09, 0x2e, 0x1f, 0x2f, 0x65, 
	0x0f, 0x56, 0x45, 0x3f, 0x1e, 0x45, 0x68, 0x68, 0x40, 
	0x44, 0x09, 0x96, 0x08, 0x54, 0x1e, 0x0f, 0x46, 0x10, 
	0x68, 0x08, 0x0d, 0x1e, 0x45, 0x2d, 0x2f, 0x00, 0x09, 
	0x0f, 0x2d, 0x97, 0x5c, 0x6d, 0x6d, 0x4e, 0x7c, 0x36, 
	0x58, 0x6d, 0x8d, 0x4d, 0x58, 0x12, 0x6d, 0x6d, 0x6d, 
	0x6e, 0x30, 0x4e, 0x36, 0x5f, 0x6d, 0x7c, 0x30, 0x36, 
	0x12, 0x5f, 0x6d, 0x6e, 0x8d, 0x5e, 0x01, 0x36, 0x12, 
	0x73, 0x6e, 0x5d, 0x6d, 0x33, 0x6d, 0x6e, 0x88, 0x89, 
	0x38, 0x98, 0x12, 0x84, 0x8a, 0x50, 0x6d, 0x6e, 0x6e, 
	0x89, 0x30, 0x12, 0x32, 0x6e, 0x6e, 0x88, 0x89, 0x34, 
	0x88, 0x27, 0x62, 0x62, 0x53, 0x23, 0x88, 0x88, 0x70, 
	0x93, 0x00, 0xb8, 0x01, 0x3f, 0x3f, 0x40, 0x78, 0x67, 
	0x68, 0x2d, 0x65, 0x65, 0x1e, 0x1e, 0x65, 0x65, 0x65, 
	0x09, 0x78, 0x40, 0x65, 0x09, 0x78, 0x1e, 0x2f, 0x65, 
	0x65, 0x1e, 0x1f, 0x2e, 0x46, 0x1d, 0x65, 0x45, 0x2e, 
	0x45, 0x3f, 0x1e, 0x45, 0x68, 0x67, 0x54, 0x54, 0x3f, 
	0x3f, 0x08, 0x1d, 0x1e, 0x0f, 0x46, 0x10, 0x2e, 0x08, 
	0x0e, 0x1e, 0x09, 0x46, 0x2f, 0x00, 0x09, 0x0f, 0x1f, 
	0x97, 0x37, 0x6d, 0x6d, 0x4c, 0x89, 0x33, 0x6e, 0x4c, 
	0x38, 0x4d, 0x73, 0x33, 0x6d, 0x6d, 0x6d, 0x88, 0x30, 
	0x4e, 0x36, 0x5f, 0x6e, 0x5d, 0x38, 0x36, 0x33, 0x6d, 
	0x6d, 0x6e, 0x4e, 0x5e, 0x01, 0x36, 0x12, 0x5c, 0x6e, 
	0x60, 0x6d, 0x33, 0x6d, 0x6e, 0x6e, 0x88, 0x89, 0x38, 
	0x37, 0x8a, 0x84, 0x99, 0x6e, 0x6e, 0x6e, 0x8d, 0x11, 
	0x12, 0x36, 0x6e, 0x6e, 0x6e, 0x7e, 0x38, 0x38, 0x95, 
	0x62, 0x62, 0x9a, 0x88, 0x88, 0x88, 0x8d, 0x93, 0x00, 
	0xb8, 0x01, 0x3f, 0x3f, 0x40, 0x41, 0x41, 0x09, 0x0d, 
	0x44, 0x3f, 0x1e, 0x00, 0x04, 0x65, 0x46, 0x78, 0x40, 
	0x3f, 0x40, 0x78, 0x1e, 0x44, 0x65, 0x65, 0x1e, 0x1f, 
	0x56, 0x46, 0x1d, 0x45, 0x2d, 0x78, 0x0f, 0x44, 0x1e, 
	0x40, 0x68, 0x2d, 0x2b, 0x54, 0x1e, 0x0f, 0x1d, 0x1d, 
	0x0f, 0x0f, 0x09, 0x68, 0x40, 0x08, 0x1d, 0x0f, 0x46, 
	0x1f, 0x2f, 0x00, 0x07, 0x0f, 0x45, 0x40, 0x2d, 0x9b, 
	0x58, 0x6d, 0x6d, 0x6e, 0x4e, 0x4e, 0x60, 0x30, 0x30, 
	0x30, 0x36, 0x73, 0x6d, 0x6d, 0x6d, 0x7e, 0x4f, 0x6b, 
	0x36, 0x5f, 0x4e, 0x60, 0x6b, 0x36, 0x5c, 0x6d, 0x6e, 
	0x6e, 0x4e, 0x4d, 0x01, 0x36, 0x12, 0x37, 0x88, 0x11, 
	0x58, 0x33, 0x00, 0x04, 0x6e, 0x7b, 0x38, 0x6d, 0x84, 
	0x12, 0x6d, 0x6e, 0x6e, 0x6e, 0x8d, 0x11, 0x32, 0x33, 
	0x00, 0x04, 0x6e, 0x6b, 0x34, 0x9a, 0x62, 0x9c, 0x6e, 
	0x88, 0x88, 0x88, 0x4e, 0x4d, 0x00, 0xb8, 0x01, 0x44, 
	0x3f, 0x40, 0x41, 0x41, 0x0f, 0x2c, 0x54, 0x65, 0x0f, 
	0x1e, 0x65, 0x65, 0x1e, 0x2d, 0x78, 0x45, 0x2f, 0x45, 
	0x41, 0x0f, 0x3f, 0x65, 0x65, 0x1e, 0x46, 0x56, 0x46, 
	0x44, 0x41, 0x2e, 0x42, 0x44, 0x44, 0x1e, 0x9d, 0x67, 
	0x3f, 0x2c, 0x3f, 0x2d, 0x41, 0x2f, 0x2f, 0x0f, 0x0f, 
	0x40, 0x40, 0x54, 0x08, 0x2f, 0x0f, 0x42, 0x69, 0x2f, 
	0x0f, 0x0f, 0x45, 0x45, 0x0f, 0x45, 0x42, 0x2e, 0x68, 
	0x56, 0x58, 0x58, 0x6d, 0x6d, 0x6d, 0x7e, 0x38, 0x7c, 
	0x60, 0x7d, 0x99, 0x4b, 0x37, 0x6d, 0x6d, 0x6d, 0x6b, 
	0x4f, 0x4c, 0x36, 0x8d, 0x60, 0x6c, 0x58, 0x32, 0x5c, 
	0x6d, 0x6e, 0x6e, 0x4e, 0x4d, 0x01, 0x36, 0x12, 0x37, 
	0x4e, 0x5d, 0x73, 0x73, 0x00, 0x05, 0x6e, 0x6b, 0x88, 
	0x27, 0x23, 0x00, 0x04, 0x6e, 0x4e, 0x60, 0x32, 0x73, 
	0x00, 0x04, 0x6e, 0x88, 0x4e, 0x9e, 0x9f, 0x23, 0x00, 
	0x04, 0x88, 0x4e, 0x4d, 0x00, 0xb8, 0x01, 0x44, 0x3f, 
	0x09, 0x41, 0x41, 0x0f, 0x0d, 0x3f, 0x65, 0x40, 0x0f, 
	0x65, 0x65, 0x0f, 0x55, 0x78, 0x0f, 0x2f, 0x0f, 0x55, 
	0x0f, 0x3f, 0x65, 0x65, 0x1e, 0x46, 0x56, 0x46, 0x45, 
	0x2e, 0x8c, 0x01, 0x54, 0x44, 0x1e, 0x09, 0x41, 0x08, 
	0x44, 0x1f, 0x78, 0x45, 0x08, 0x44, 0x0f, 0x0f, 0x0f, 
	0x1e, 0x3f, 0x3f, 0x1e, 0x0f, 0x41, 0x09, 0x1e, 0x46, 
	0x41, 0x78, 0x0f, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x6d, 
	0x33, 0x58, 0x00, 0x04, 0x6d, 0x4e, 0x89, 0x89, 0x4c, 
	0x32, 0x12, 0x58, 0x6d, 0x6d, 0x6d, 0x4e, 0x4f, 0x4c, 
	0x5f, 0x5d, 0x01, 0x01, 0x22, 0x32, 0x73, 0x6d, 0x6e, 
	0x6e, 0x6b, 0x4d, 0x01, 0x36, 0x12, 0x37, 0x38, 0x38, 
	0x33, 0x73, 0x00, 0x05, 0x6e, 0x88, 0x6e, 0x99, 0x00, 
	0x05, 0x6e, 0x4e, 0x60, 0x36, 0x5c, 0x00, 0x04, 0x6e, 
	0x88, 0x88, 0x98, 0x8b, 0x6e, 0x00, 0x04, 0x88, 0x4e, 
	0x5e, 0x00, 0xb8, 0x01, 0x44, 0x65, 0x40, 0x41, 0x69, 
	0xa0, 0x54, 0x65, 0x1e, 0x46, 0x0f, 0x65, 0x65, 0x45, 
	0x41, 0x78, 0x1e, 0x44, 0x1e, 0x46, 0x45, 0x3f, 0x65, 
	0x65, 0x1e, 0x2d, 0x56, 0x42, 0x2d, 0x01, 0x01, 0x01, 
	0x0d, 0x44, 0x1e, 0x09, 0x45, 0x1d, 0x09, 0x55, 0x07, 
	0xa1, 0x08, 0x3f, 0x0f, 0x0f, 0x0f, 0x45, 0x45, 0x45, 
	0x0f, 0x45, 0x2e, 0x2d, 0x68, 0x10, 0x56, 0x0f, 0x1d, 
	0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x58, 0x5f, 0x00, 
	0x04, 0x6d, 0x6e, 0x4e, 0x89, 0x6b, 0x33, 0x12, 0x23, 
	0x6d, 0x6d, 0x6d, 0x70, 0x4d, 0x6b, 0x71, 0x01, 0x01, 
	0x01, 0x22, 0x32, 0x5c, 0x6d, 0x6e, 0x6e, 0x6b, 0x4f, 
	0x01, 0x36, 0x12, 0x58, 0x60, 0x70, 0x32, 0x5c, 0x00, 
	0x0d, 0x6e, 0x6b, 0x60, 0x36, 0x37, 0x00, 0x05, 0x6e, 
	0x88, 0x88, 0x6e, 0x00, 0x05, 0x88, 0x6b, 0x4d, 0x00, 
	0xb8, 0x01, 0x44, 0x65, 0x40, 0x41, 0xa2, 0x2b, 0x0d, 
	0x65, 0x0f, 0x55, 0x0f, 0x65, 0x65, 0x40, 0x78, 0x78, 
	0x1e, 0x44, 0x65, 0x1f, 0x45, 0x65, 0x65, 0x65, 0x0f, 
	0x2d, 0x56, 0x78, 0x69, 0x01, 0x01, 0x01, 0x0d, 0x44, 
	0x1e, 0x09, 0x3f, 0x45, 0x09, 0x1e, 0x40, 0x44, 0x0d, 
	0x65, 0x0f, 0x0f, 0x0f, 0x2d, 0x2e, 0x2e, 0x78, 0x78, 
	0x68, 0x68, 0x01, 0x01, 0x01, 0x0d, 0x1d, 0x0f, 0x09, 
	0x79, 0x10, 0x01, 0x01, 0x6d, 0x6e, 0x6e, 0x00, 0x04, 
	0x6d, 0x88, 0x70, 0x89, 0x73, 0x36, 0x5f, 0x6d, 0x6d, 
	0x6d, 0x89, 0x4d, 0x71, 0x00, 0x04, 0x01, 0x22, 0x32, 
	0x5c, 0x6d, 0x6e, 0x6e, 0x7b, 0x4f, 0x01, 0x36, 0x12, 
	0x5f, 0x30, 0x4e, 0x12, 0x37, 0x00, 0x0d, 0x6e, 0x6b, 
	0x60, 0x36, 0x58, 0x00, 0x04, 0x6e, 0x00, 0x09, 0x88, 
	0x6b, 0x4d, 0x00, 0xb8, 0x01, 0x44, 0x65, 0x40, 0xa3, 
	0x2b, 0x08, 0x3f, 0x65, 0x40, 0x78, 0x0f, 0x65, 0x65, 
	0x09, 0x2e, 0x78, 0x65, 0x44, 0x65, 0x09, 0x45, 0x65, 
	0x65, 0x65, 0x0f, 0x2d, 0x56, 0x41, 0x65, 0x01, 0x01, 
	0x01, 0x0d, 0x44, 0x1e, 0x0f, 0x1e, 0x45, 0x2f, 0x44, 
	0x0f, 0x65, 0x2f, 0x1e, 0x0f, 0x0f, 0x0f, 0x78, 0x68, 
	0x2d, 0x46, 0x2e, 0x68, 0x56, 0x01, 0x01, 0x01, 0x08, 
	0x44, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x01, 0x7b, 
	0x6b, 0x88, 0x00, 0x04, 0x6d, 0x7b, 0x7c, 0x6d, 0x33, 
	0x6d, 0x6d, 0x6d, 0x6e, 0x38, 0x4d, 0x00, 0x05, 0x01, 
	0x22, 0x32, 0x5c, 0x6d, 0x6e, 0x6e, 0x7e, 0x4f, 0x01, 
	0x36, 0x32, 0x6d, 0x30, 0x4e, 0x12, 0x37, 0x00, 0x0d, 
	0x6e, 0x7e, 0x60, 0x36, 0x58, 0x6e, 0x6e, 0x6e, 0x00, 
	0x0a, 0x88, 0x6b, 0x4d, 0x00, 0xb8, 0x01, 0x44, 0x65, 
	0x0f, 0x2f, 0x54, 0x3f, 0x65, 0x1e, 0x2d, 0x78, 0x45, 
	0x65, 0x65, 0x09, 0x2e, 0x41, 0x3f, 0x44, 0x65, 0x09, 
	0x09, 0x65, 0x65, 0x65, 0x0f, 0x42, 0x56, 0x41, 0x65, 
	0x01, 0x01, 0x01, 0x06, 0x44, 0x1e, 0x0f, 0x0f, 0x1e, 
	0x3f, 0x1e, 0x40, 0x40, 0x44, 0x1e, 0x0f, 0x0f, 0x40, 
	0x67, 0x2d, 0x54, 0x0d, 0x65, 0x40, 0x41, 0x01, 0x01, 
	0x01, 0x08, 0x44, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 
	0x01, 0x88, 0x4e, 0x4e, 0x88, 0x6d, 0x6d, 0x6d, 0x6e, 
	0x7c, 0x6b, 0x73, 0x6d, 0x6d, 0x6d, 0x6e, 0x7c, 0x93, 
	0x00, 0x05, 0x01, 0x22, 0x32, 0x73, 0x6d, 0x6e, 0x6e, 
	0x7e, 0x30, 0x01, 0x36, 0x32, 0x6d, 0x30, 0x6b, 0x12, 
	0x58, 0x00, 0x0a, 0x6e, 0x6d, 0x6d, 0x6e, 0x4c, 0x60, 
	0x36, 0x5f, 0x6e, 0x6e, 0x6e, 0x00, 0x07, 0x88, 0x6d, 
	0x6e, 0x88, 0x6b, 0x4f, 0x00, 0xb8, 0x01, 0x44, 0x3f, 
	0x65, 0x3f, 0x65, 0x65, 0x1e, 0x1f, 0x78, 0x41, 0x0f, 
	0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 0x44, 0x65, 0x40, 
	0x1f, 0x65, 0x1e, 0x1e, 0x0f, 0x55, 0x56, 0x55, 0x3f, 
	0x01, 0x01, 0x01, 0x54, 0x44, 0x00, 0x06, 0x0f, 0x09, 
	0x2d, 0x1e, 0x65, 0x0f, 0x0f, 0x2d, 0x2e, 0x3f, 0x2c, 
	0x54, 0x44, 0x1e, 0x1f, 0x8c, 0x01, 0x01, 0x08, 0x44, 
	0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x01, 0x33, 0x37, 
	0x6e, 0x6b, 0x4c, 0x6d, 0x6d, 0x6d, 0x89, 0x38, 0x73, 
	0x6d, 0x6d, 0x6d, 0x6e, 0x60, 0x4f, 0x00, 0x05, 0x01, 
	0x73, 0x32, 0x73, 0x6d, 0x6e, 0x6e, 0x4c, 0x30, 0x01, 
	0x36, 0x36, 0x6e, 0x30, 0x4c, 0x12, 0x58, 0x6e, 0x88, 
	0x00, 0x08, 0x6e, 0x5f, 0x6d, 0x6e, 0x88, 0x5d, 0x33, 
	0x5f, 0x6e, 0x00, 0x09, 0x88, 0x37, 0x88, 0x88, 0x6b, 
	0x4f, 0x00, 0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x65, 0x1e, 
	0x0f, 0x46, 0x78, 0x78, 0x46, 0x44, 0x3f, 0x65, 0x09, 
	0x78, 0x41, 0x1e, 0x44, 0x65, 0x69, 0x46, 0x65, 0x1e, 
	0x1e, 0x0f, 0x55, 0x56, 0x55, 0x65, 0x01, 0xa4, 0x1d, 
	0x54, 0x44, 0x0f, 0x0f, 0x2d, 0x46, 0x45, 0x0f, 0x45, 
	0x41, 0x09, 0x3f, 0x0f, 0x0f, 0x55, 0x56, 0x3f, 0x1d, 
	0x3f, 0x65, 0x40, 0x42, 0x41, 0x01, 0x16, 0x08, 0x3f, 
	0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x01, 0x36, 0x32, 
	0x36, 0x58, 0x4c, 0x88, 0x6d, 0x6d, 0x70, 0x60, 0x73, 
	0x5f, 0x6d, 0x6d, 0x88, 0x30, 0x4f, 0x01, 0x99, 0x58, 
	0x58, 0x58, 0x73, 0x36, 0x73, 0x6d, 0x6e, 0x6e, 0x88, 
	0x30, 0x01, 0x36, 0x36, 0x88, 0x30, 0x88, 0x12, 0x5f, 
	0x6e, 0x6b, 0x4c, 0x00, 0x07, 0x6e, 0x5c, 0x6d, 0x6e, 
	0x88, 0x5d, 0x33, 0x6d, 0x6e, 0x4e, 0x6e, 0x00, 0x06, 
	0x88, 0x6d, 0x73, 0x88, 0x88, 0x6b, 0x4f, 0x00, 0xb8, 
	0x01, 0x2f, 0x3f, 0x65, 0x1e, 0x09, 0x41, 0x2e, 0x2e, 
	0x01, 0x01, 0x01, 0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 
	0x2f, 0x1e, 0x46, 0x46, 0x65, 0x1e, 0x1e, 0x0f, 0x41, 
	0x56, 0x55, 0x65, 0x66, 0x08, 0x08, 0x0e, 0x44, 0x0f, 
	0x45, 0x56, 0x67, 0x2d, 0x45, 0x45, 0x41, 0x2d, 0x3f, 
	0x0f, 0x0f, 0x46, 0x67, 0x65, 0x3f, 0x0f, 0x0f, 0x09, 
	0x78, 0x67, 0x01, 0x16, 0x08, 0x3f, 0x0f, 0x09, 0x79, 
	0x10, 0x01, 0x01, 0x01, 0x36, 0x73, 0x5c, 0x58, 0x6b, 
	0x4c, 0x6d, 0x6d, 0x70, 0x60, 0x73, 0x5f, 0x6d, 0x6d, 
	0x88, 0x4f, 0x4f, 0x35, 0x12, 0x36, 0x36, 0x37, 0x6e, 
	0x33, 0x73, 0x6d, 0x6e, 0x6e, 0x88, 0x11, 0x01, 0x36, 
	0x36, 0x4c, 0x30, 0x6e, 0x12, 0x5f, 0x6e, 0x8d, 0x6b, 
	0x00, 0x06, 0x6e, 0x6d, 0x73, 0x6d, 0x6e, 0x88, 0x5d, 
	0x33, 0x6d, 0x88, 0x38, 0x6e, 0x6e, 0x00, 0x05, 0x88, 
	0x58, 0x33, 0x88, 0x88, 0x6b, 0x4f, 0x00, 0xb8, 0x01, 
	0x2f, 0x3f, 0x65, 0x1e, 0x46, 0x41, 0x41, 0x00, 0x04, 
	0x01, 0x44, 0x65, 0x09, 0x78, 0x41, 0x1e, 0x2f, 0x1e, 
	0x2d, 0x46, 0x65, 0x1e, 0x1e, 0x0f, 0x55, 0x56, 0x41, 
	0x2f, 0x2c, 0x08, 0x40, 0x09, 0x2f, 0x0f, 0x45, 0x56, 
	0x56, 0x0f, 0x3f, 0x0f, 0x55, 0x78, 0x1e, 0x0f, 0x0f, 
	0x40, 0x68, 0x0f, 0x3f, 0x0f, 0x0f, 0x40, 0x68, 0x79, 
	0x01, 0x03, 0x08, 0x65, 0x0f, 0x09, 0x79, 0x10, 0x01, 
	0x01, 0x01, 0x36, 0x58, 0x6d, 0x6e, 0x38, 0x7e, 0x37, 
	0x6d, 0x89, 0x60, 0x33, 0x5f, 0x6d, 0x6d, 0x88, 0x30, 
	0x4f, 0x73, 0x4a, 0x12, 0x5c, 0xa5, 0x4e, 0x36, 0x73, 
	0x6d, 0x6e, 0x6e, 0x88, 0x60, 0x01, 0x36, 0x33, 0x4c, 
	0x30, 0x6d, 0x12, 0x5f, 0x6e, 0x38, 0x70, 0x00, 0x05, 
	0x6e, 0x88, 0x6d, 0x33, 0x6e, 0x6e, 0x88, 0x7c, 0x73, 
	0x6d, 0x88, 0x60, 0x88, 0x6e, 0x00, 0x05, 0x88, 0x73, 
	0x73, 0x88, 0x88, 0x4c, 0x30, 0x00, 0xb8, 0x01, 0x2f, 
	0x3f, 0x65, 0x1e, 0x09, 0x41, 0x41, 0x00, 0x04, 0x01, 
	0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 0x2f, 0x0f, 0x55, 
	0x2d, 0x1e, 0x1e, 0x1e, 0x0f, 0x2d, 0x2e, 0x41, 0x0e, 
	0x08, 0x1e, 0x56, 0x09, 0x2f, 0x0f, 0x45, 0x56, 0x56, 
	0x44, 0x44, 0x0f, 0x2d, 0x56, 0x40, 0x0f, 0x0f, 0x45, 
	0x68, 0x1e, 0x3f, 0x0f, 0x0f, 0x40, 0x68, 0x68, 0x01, 
	0xa6, 0x08, 0x65, 0x0f, 0x09, 0x10, 0x10, 0x01, 0x01, 
	0x01, 0x36, 0x58, 0x6d, 0x6d, 0x38, 0x7e, 0x37, 0x6e, 
	0x7c, 0x7c, 0x73, 0x5f, 0x6d, 0x6d, 0x88, 0x60, 0x30, 
	0x73, 0x4a, 0x36, 0x4e, 0x4d, 0x4c, 0x36, 0x73, 0x6d, 
	0x6e, 0x6e, 0x88, 0x5d, 0x01, 0x36, 0x33, 0x6b, 0x30, 
	0x5f, 0x12, 0x6d, 0x6e, 0x5d, 0x38, 0x00, 0x05, 0x6e, 
	0x7e, 0x5f, 0x33, 0x6e, 0x6e, 0x6e, 0x7c, 0x73, 0x6d, 
	0x4c, 0x11, 0x6b, 0x6e, 0x6e, 0x00, 0x04, 0x88, 0x36, 
	0x5c, 0x88, 0x88, 0x4c, 0x30, 0x00, 0xb8, 0x01, 0x2f, 
	0x3f, 0x65, 0x65, 0x1f, 0x78, 0x41, 0x00, 0x04, 0x01, 
	0x3f, 0x65, 0x40, 0x78, 0x41, 0x0f, 0x2f, 0x0f, 0x41, 
	0x41, 0x45, 0x1e, 0x1e, 0x1e, 0x09, 0x78, 0x2d, 0x0d, 
	0x0e, 0x1f, 0x68, 0x09, 0x2f, 0x0f, 0x45, 0x56, 0x67, 
	0x3f, 0x2f, 0x0f, 0x46, 0x68, 0x46, 0x0f, 0x0f, 0x45, 
	0x78, 0x3f, 0x0f, 0x0f, 0x0f, 0x46, 0x68, 0x8c, 0x01, 
	0xa7, 0x08, 0x1e, 0x0f, 0x09, 0x10, 0x10, 0x01, 0x01, 
	0x01, 0x36, 0x58, 0x6d, 0x6d, 0x38, 0x88, 0x37, 0x88, 
	0x30, 0x7c, 0x58, 0x5f, 0x6d, 0x6d, 0x6e, 0x38, 0x60, 
	0x73, 0x4a, 0x5f, 0x7c, 0x4f, 0x6e, 0x33, 0x37, 0x6d, 
	0x6e, 0x6e, 0x6e, 0x38, 0x38, 0x12, 0x33, 0x4e, 0x30, 
	0x5f, 0x32, 0x6d, 0x6e, 0x60, 0x60, 0x88, 0x6e, 0x6e, 
	0x6e, 0x88, 0x6b, 0x37, 0x73, 0x6e, 0x6e, 0x6e, 0x38, 
	0x5c, 0x6e, 0x4c, 0x30, 0x70, 0x6e, 0x6e, 0x00, 0x04, 
	0x88, 0x12, 0x37, 0x88, 0x88, 0x4c, 0x30, 0x00, 0xb8, 
	0x01, 0x2f, 0x3f, 0x65, 0x65, 0x46, 0x78, 0x41, 0x00, 
	0x04, 0x01, 0x3f, 0x65, 0x45, 0x55, 0x41, 0x65, 0x1d, 
	0x45, 0x78, 0x78, 0x1f, 0x0f, 0x1e, 0x1e, 0x45, 0x2d, 
	0x1f, 0x0d, 0x3f, 0x2d, 0x68, 0x09, 0x2f, 0x0f, 0x45, 
	0x56, 0x67, 0x3f, 0x0e, 0x0f, 0x09, 0x68, 0x55, 0x0f, 
	0x0f, 0x0f, 0x42, 0x1e, 0x0f, 0x0f, 0x45, 0x55, 0x67, 
	0x01, 0x01, 0xa7, 0x08, 0x0f, 0x0f, 0x09, 0x10, 0x79, 
	0x01, 0x01, 0x01, 0x36, 0x58, 0x6d, 0x6d, 0x38, 0x6e, 
	0x58, 0x7b, 0x4f, 0x8e, 0x00, 0x04, 0x6d, 0x6e, 0x4e, 
	0x7c, 0x33, 0x12, 0x88, 0x60, 0x01, 0x01, 0x99, 0x37, 
	0x6d, 0x6e, 0x6e, 0x6e, 0x6b, 0x6b, 0x4b, 0x37, 0x4e, 
	0x30, 0x58, 0x32, 0x6e, 0x6e, 0x30, 0x30, 0x4c, 0x6e, 
	0x6e, 0x6e, 0x88, 0x4e, 0x33, 0x5c, 0x6e, 0x6e, 0x6e, 
	0x89, 0x37, 0x6e, 0x6b, 0x4f, 0x7c, 0x6e, 0x6e, 0x6e, 
	0x88, 0x6b, 0x6d, 0x12, 0x58, 0x88, 0x88, 0x4c, 0x30, 
	0x00, 0xb8, 0x01, 0xa4, 0x3f, 0x65, 0x65, 0x46, 0x78, 
	0x41, 0x00, 0x04, 0x01, 0x65, 0x0f, 0x0f, 0x09, 0x40, 
	0x2c, 0x1d, 0x09, 0x2e, 0x2e, 0x1f, 0x09, 0x45, 0x0f, 
	0x0f, 0x40, 0x1f, 0x1d, 0x0f, 0x41, 0x67, 0x45, 0x2f, 
	0x0f, 0x45, 0x67, 0x67, 0x1d, 0x0d, 0x0f, 0x40, 0x68, 
	0x56, 0x1f, 0x45, 0x0f, 0x45, 0x65, 0x0f, 0x0f, 0x1f, 
	0x67, 0x8c, 0x01, 0x01, 0x92, 0x0d, 0x0f, 0x0f, 0x09, 
	0x10, 0x79, 0x01, 0x01, 0x01, 0x33, 0x58, 0x6d, 0x6d, 
	0x89, 0x58, 0x5f, 0x89, 0x4f, 0x01, 0x01, 0x88, 0x88, 
	0x6e, 0x6e, 0x6e, 0x70, 0x5c, 0x37, 0x6b, 0x30, 0x01, 
	0x01, 0x73, 0x37, 0x6d, 0x00, 0x05, 0x6e, 0x58, 0x6e, 
	0x89, 0x30, 0x33, 0x36, 0x6e, 0x6e, 0x4f, 0x34, 0x01, 
	0x6e, 0x6e, 0x6e, 0x4e, 0x7e, 0x32, 0x37, 0x6e, 0x88, 
	0x88, 0x89, 0x37, 0x6e, 0x4e, 0x4f, 0x01, 0x4c, 0x6e, 
	0x6e, 0x88, 0x8d, 0x37, 0x12, 0x5f, 0x88, 0x88, 0x4c, 
	0x11, 0x00, 0xb8, 0x01, 0xa4, 0x3f, 0x65, 0x0f, 0x55, 
	0x78, 0x55, 0x00, 0x05, 0x01, 0x45, 0x1e, 0x0f, 0x3f, 
	0x0e, 0x1e, 0x46, 0x2e, 0x78, 0x01, 0xa8, 0x1f, 0x0f, 
	0x0f, 0x0f, 0x45, 0x3f, 0x40, 0x78, 0x2e, 0x0f, 0x1d, 
	0x0f, 0x45, 0x67, 0x56, 0x08, 0x54, 0x0f, 0x45, 0x67, 
	0x68, 0x42, 0x40, 0x45, 0x0f, 0x0f, 0x0f, 0x45, 0x78, 
	0x67, 0x01, 0x01, 0x01, 0x92, 0x0d, 0x0f, 0x0f, 0x09, 
	0x10, 0x79, 0x01, 0x01, 0x01, 0x33, 0x58, 0x6d, 0x6d, 
	0xa9, 0x37, 0x6e, 0x7c, 0x00, 0x04, 0x01, 0x4c, 0x88, 
	0x6e, 0x6e, 0x4c, 0x58, 0x6d, 0x38, 0x30, 0x01, 0x01, 
	0x01, 0x5f, 0x6d, 0x00, 0x06, 0x6e, 0x88, 0x5d, 0x38, 
	0x32, 0x36, 0x6e, 0x88, 0x4f, 0x8e, 0x01, 0x8f, 0x6e, 
	0x88, 0x38, 0x5f, 0x12, 0x37, 0x6e, 0x88, 0x88, 0x8d, 
	0x58, 0x6e, 0x4e, 0x4d, 0x01, 0x01, 0x6e, 0x6e, 0x88, 
	0x8d, 0x33, 0x12, 0x5f, 0x88, 0x88, 0x4c, 0x60, 0x00, 
	0xb8, 0x01, 0x17, 0x3f, 0x45, 0x2d, 0x2e, 0x78, 0x00, 
	0x06, 0x01, 0x07, 0x45, 0x0f, 0x1e, 0x1e, 0x40, 0x78, 
	0x2e, 0x96, 0x01, 0x01, 0x9e, 0x09, 0x00, 0x04, 0x0f, 
	0x42, 0x2e, 0x97, 0xaa, 0x1d, 0x0f, 0x40, 0x68, 0x78, 
	0x2c, 0x2f, 0x45, 0x1f, 0x67, 0x68, 0x47, 0x18, 0x40, 
	0x45, 0x0f, 0x45, 0x46, 0x67, 0x00, 0x04, 0x01, 0x08, 
	0x0d, 0x0f, 0x0f, 0x09, 0x10, 0x79, 0x01, 0x01, 0x01, 
	0x58, 0x00, 0x04, 0x6d, 0x6e, 0x4e, 0x60, 0x00, 0x04, 
	0x01, 0xab, 0x4c, 0x88, 0x6e, 0x6e, 0x6e, 0x6b, 0x60, 
	0x00, 0x04, 0x01, 0x8f, 0x88, 0x88, 0x6e, 0x6e, 0x6e, 
	0x88, 0x7e, 0x38, 0x01, 0x6d, 0x33, 0x37, 0x88, 0x88, 
	0x4d, 0x01, 0x01, 0x01, 0x6e, 0x88, 0x38, 0x33, 0x12, 
	0x58, 0x88, 0x88, 0x4c, 0x89, 0x6d, 0x88, 0x8d, 0x4d, 
	0x01, 0x01, 0x98, 0x6e, 0x7e, 0x6b, 0x32, 0x36, 0x6d, 
	0x88, 0x4c, 0x6b, 0x60, 0x00, 0xb8, 0x01, 0x6a, 0x45, 
	0x41, 0x2e, 0x8c, 0x00, 0x08, 0x01, 0x2d, 0x2d, 0x46, 
	0x2d, 0x78, 0x2e, 0x97, 0x00, 0x04, 0x01, 0x96, 0x2d, 
	0x46, 0x2d, 0x41, 0x56, 0x8c, 0x01, 0x01, 0x3f, 0x2d, 
	0x2e, 0x68, 0x1f, 0x0d, 0x09, 0x2e, 0x68, 0x56, 0x01, 
	0x01, 0x01, 0x96, 0x2d, 0x2d, 0x42, 0x2e, 0x2e, 0x00, 
	0x04, 0x01, 0x0d, 0x44, 0x2d, 0x42, 0x78, 0x79, 0x79, 
	0x00, 0x04, 0x01, 0x6b, 0x4e, 0x8d, 0x70, 0x38, 0x60, 
	0x00, 0x06, 0x01, 0x98, 0x8d, 0x70, 0x8d, 0x89, 0x5d, 
	0x00, 0x06, 0x01, 0x7b, 0x70, 0x70, 0x8d, 0x89, 0x7c, 
	0x60, 0x01, 0x01, 0x01, 0x4c, 0x38, 0x38, 0x70, 0x5e, 
	0x00, 0x04, 0x01, 0x88, 0x4e, 0x36, 0x36, 0x6b, 0x38, 
	0x5d, 0x60, 0x30, 0x7c, 0x38, 0x7c, 0x4d, 0x01, 0x01, 
	0x01, 0x4c, 0x7e, 0x6d, 0x12, 0x5c, 0x8d, 0x7c, 0x5d, 
	0x60, 0x85, 0x00, 0xb9, 0x01, 0x46, 0x2e, 0x97, 0x00, 
	0x0b, 0x01, 0x11, 0x30, 0x0a, 0x00, 0x08, 0x01, 0x0a, 
	0x30, 0x0a, 0x00, 0x04, 0x01, 0x2d, 0x56, 0x01, 0x9e, 
	0xa4, 0x46, 0x56, 0x00, 0x08, 0x01, 0x68, 0x11, 0x00, 
	0x06, 0x01, 0x65, 0x78, 0x00, 0x04, 0x30, 0x00, 0x06, 
	0x01, 0x77, 0x85, 0x85, 0x77, 0x00, 0x15, 0x01, 0x60, 
	0x85, 0x85, 0x00, 0x07, 0x01, 0x6c, 0x7c, 0x4f, 0x00, 
	0x04, 0x01, 0xab, 0x6e, 0x73, 0x6b, 0x60, 0x60, 0x34, 
	0x3a, 0x28, 0x94, 0x38, 0x5d, 0x4f, 0x00, 0x04, 0x01, 
	0x88, 0x5c, 0x58, 0x8e, 0x81, 0xac, 0x00, 0xff, 0x01, 
	0x00, 0x45, 0x01, 0x00, 0x00 
};

// Keyboard

unsigned char item_keyboardPortrait_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0xff, 0xc6, 0x21, 
	0xf7, 0xbd, 0x18, 
	0xce, 0x9c, 0x18, 
	0x9c, 0x7b, 0x10, 
	0x84, 0x63, 0x10, 
	0x7b, 0x63, 0x10, 
	0xe7, 0xb5, 0x18, 
	0xff, 0xbd, 0x21, 
	0x73, 0x5a, 0x10, 
	0xef, 0xbd, 0x42, 
	0xe7, 0xb5, 0x39, 
	0xe7, 0xb5, 0x31, 
	0xde, 0xad, 0x29, 
	0x6b, 0x52, 0x10, 
	0xef, 0x9c, 0x42, 
	0xe7, 0x94, 0x39, 
	0xe7, 0x8c, 0x31, 
	0xde, 0x8c, 0x29, 
	0xde, 0x84, 0x29, 
	0xef, 0xb5, 0x18, 
	0xe7, 0x94, 0x31, 
	0xde, 0x84, 0x21, 
	0x9c, 0x73, 0x10, 
	0x52, 0x39, 0x08, 
	0xde, 0xa5, 0x18, 
	0xef, 0x9c, 0x4a, 
	0xf7, 0xc6, 0x4a, 
	0x31, 0x21, 0x08, 
	0xf7, 0xa5, 0x4a, 
	0xf7, 0xd6, 0xb5, 
	0xef, 0xbd, 0x84, 
	0xf7, 0xe7, 0xce, 
	0xff, 0xf7, 0xef, 
	0xff, 0xff, 0xff, 
	0xf7, 0xce, 0xad, 
	0x63, 0x52, 0x18, 
	0x39, 0x31, 0x10, 
	0xf7, 0xd6, 0xad, 
	0x9c, 0x7b, 0x31, 
	0xff, 0xe7, 0xce, 
	0xef, 0xa5, 0x52, 
	0xbd, 0x94, 0x39, 
	0xb5, 0x94, 0x31, 
	0xd6, 0xad, 0x39, 
	0xf7, 0xbd, 0x7b, 
	0xf7, 0xb5, 0x73, 
	0xf7, 0xce, 0x52, 
	0x29, 0x21, 0x08, 
	0xf7, 0xa5, 0x52, 
	0xff, 0xe7, 0xd6, 
	0xf7, 0xce, 0x9c, 
	0xf7, 0xce, 0xa5, 
	0xef, 0xa5, 0x5a, 
	0x7b, 0x63, 0x29, 
	0xf7, 0xb5, 0x6b, 
	0xff, 0xef, 0xde, 
	0xf7, 0xbd, 0x84, 
	0xff, 0xef, 0xe7, 
	0x42, 0x31, 0x10, 
	0x73, 0x5a, 0x21, 
	0xe7, 0x9c, 0x4a, 
	0xd6, 0xad, 0x42, 
	0x10, 0x10, 0x08, 
	0xef, 0xad, 0x6b, 
	0xff, 0xce, 0x5a, 
	0xf7, 0xad, 0x5a, 
	0x7b, 0x6b, 0x29, 
	0xff, 0xe7, 0xc6, 
	0xf7, 0xd6, 0xa5, 
	0xc6, 0xa5, 0x42, 
	0xe7, 0xbd, 0x52, 
	0x8c, 0x73, 0x29, 
	0xef, 0xb5, 0x6b, 
	0xef, 0xc6, 0x94, 
	0x31, 0x29, 0x10, 
	0xff, 0xd6, 0x5a, 
	0xd6, 0xad, 0x4a, 
	0x7b, 0x63, 0x21, 
	0xce, 0xa5, 0x39, 
	0xff, 0xef, 0xd6, 
	0xf7, 0xc6, 0x8c, 
	0xef, 0xad, 0x63, 
	0xde, 0xb5, 0x4a, 
	0xad, 0x8c, 0x31, 
	0xff, 0xb5, 0x63, 
	0xf7, 0xc6, 0x94, 
	0x84, 0x6b, 0x21, 
	0xad, 0x8c, 0x29, 
	0xbd, 0x9c, 0x42, 
	0xc6, 0x9c, 0x31, 
	0xff, 0xb5, 0x6b, 
	0xff, 0xbd, 0x84, 
	0xbd, 0x9c, 0x39, 
	0xa5, 0x84, 0x29, 
	0xf7, 0xc6, 0x9c, 
	0x94, 0x7b, 0x29, 
	0x21, 0x18, 0x08, 
	0xf7, 0xad, 0x63, 
	0xff, 0xde, 0xb5, 
	0x73, 0x5a, 0x29, 
	0xce, 0xa5, 0x31, 
	0xf7, 0xde, 0xbd, 
	0xef, 0xb5, 0x7b, 
	0x4a, 0x39, 0x18, 
	0x6b, 0x5a, 0x21, 
	0x52, 0x42, 0x18, 
	0x4a, 0x39, 0x10, 
	0xff, 0xbd, 0x73, 
	0xa5, 0x84, 0x31, 
	0x9c, 0x7b, 0x29, 
	0x94, 0x73, 0x21, 
	0xff, 0xde, 0xbd, 
	0xe7, 0xbd, 0x4a, 
	0xde, 0xb5, 0x39, 
	0xf7, 0xde, 0xc6, 
	0x42, 0x39, 0x10, 
	0xff, 0xde, 0xc6, 
	0x73, 0x5a, 0x18, 
	0xd6, 0xad, 0x31, 
	0xef, 0xb5, 0x73, 
	0x6b, 0x52, 0x21, 
	0x5a, 0x4a, 0x18, 
	0xff, 0xf7, 0xe7, 
	0xe7, 0xa5, 0x5a, 
	0xe7, 0x9c, 0x52, 
	0xde, 0x8c, 0x31, 
	0xe7, 0xa5, 0x63, 
	0x08, 0x08, 0x00, 
	0xe7, 0x94, 0x42, 
	0xd6, 0xa5, 0x21, 
	0xad, 0x84, 0x29, 
	0xbd, 0x94, 0x31, 
	0xe7, 0x9c, 0x42, 
	0xd6, 0x7b, 0x18, 
	0xef, 0xce, 0xa5, 
	0x31, 0x29, 0x08, 
	0x39, 0x29, 0x08, 
	0xe7, 0xad, 0x6b, 
	0xef, 0xbd, 0x8c, 
	0x63, 0x52, 0x10, 
	0xd6, 0xa5, 0x18, 
	0xb5, 0x8c, 0x29, 
	0xa5, 0x84, 0x21, 
	0xc6, 0x94, 0x21, 
	0xc6, 0x9c, 0x21, 
	0x8c, 0x6b, 0x18, 
	0x52, 0x42, 0x10, 
	0x9c, 0x7b, 0x21, 
	0xde, 0x94, 0x39, 
	0xbd, 0x94, 0x21, 
	0x18, 0x18, 0x08, 
	0x8c, 0x6b, 0x21, 
	0x42, 0x31, 0x08, 
	0xd6, 0x9c, 0x10, 
	0xd6, 0x73, 0x10, 
	0xce, 0xa5, 0x29, 
	0x10, 0x10, 0x00, 
	0xb5, 0x8c, 0x18, 
	0xef, 0xad, 0x73, 
	0xb5, 0x8c, 0x21, 
	0x5a, 0x4a, 0x10, 
	0x84, 0x63, 0x18, 
	0x8c, 0x6b, 0x10, 
	0xce, 0x9c, 0x08, 
	0xce, 0x73, 0x08, 
	0xbd, 0x94, 0x18, 
	0x63, 0x4a, 0x10, 
	0x9c, 0x7b, 0x18, 
	0xa5, 0x7b, 0x18, 
	0xad, 0x84, 0x10, 
	0xce, 0x94, 0x00, 
	0xce, 0x6b, 0x00, 
	0xa5, 0x7b, 0x10, 
	0xe7, 0xbd, 0x39, 
	0xde, 0xad, 0x21, 
	0xbd, 0x94, 0x29, 
	0xff, 0xd6, 0xad, 
	0xa5, 0x8c, 0x39, 
	0xff, 0xbd, 0x7b, 
	0xce, 0xad, 0x42, 
	0xa5, 0x84, 0x39, 
	0xc6, 0x9c, 0x39, 
	0xbd, 0x9c, 0x31, 
	0x18, 0x10, 0x00, 
	0xef, 0xad, 0x5a, 
	0xff, 0xd6, 0xb5, 
	0x7b, 0x63, 0x18, 
	0xef, 0xbd, 0x7b, 
	0xe7, 0xb5, 0x42, 
	0xce, 0x9c, 0x21, 
	0xd6, 0xa5, 0x31, 
	0x6b, 0x52, 0x18, 
	0xff, 0xf7, 0xf7, 
	0xde, 0xad, 0x39, 
	0x63, 0x4a, 0x18, 
	0xad, 0x84, 0x18, 
	0xad, 0x84, 0x21, 
	0xc6, 0x94, 0x18, 
	0xce, 0x9c, 0x10, 
	0xef, 0xce, 0x9c, 
	0x5a, 0x42, 0x08, 
	0x4a, 0x39, 0x08

};
unsigned char item_keyboardPortrait[] = { 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xdc, 0x01, 0x02, 0x03, 0x04, 
	0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 
	0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 
	0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 
	0x04, 0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 
	0x05, 0x04, 0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 
	0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 
	0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 0x06, 0x00, 
	0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 0x06, 
	0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 
	0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 
	0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 
	0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 
	0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 
	0x04, 0x08, 0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 
	0x05, 0x04, 0x03, 0x09, 0x03, 0x04, 0x05, 0x06, 0x00, 
	0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 0x06, 
	0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 0x05, 
	0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 0x04, 
	0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x08, 
	0x04, 0x05, 0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 
	0x03, 0x00, 0x0f, 0x02, 0x03, 0x04, 0x05, 0x06, 0x00, 
	0x07, 0x07, 0x06, 0x05, 0x04, 0x03, 0x00, 0x0f, 0x02, 
	0x03, 0x04, 0x05, 0x06, 0x00, 0x08, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x02, 0x02, 0x01, 0x09, 0x04, 0x0a, 0x00, 
	0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x05, 
	0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 
	0x0f, 0x05, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x0e, 0x0e, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x14, 0x0f, 0x05, 0x0f, 0x00, 0x06, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x05, 0x0f, 
	0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 
	0x05, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 
	0x0e, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 
	0x12, 0x13, 0x14, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x05, 0x0f, 0x00, 
	0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 0x05, 
	0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 
	0x0f, 0x05, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 
	0x13, 0x14, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x0e, 0x0a, 0x04, 0x15, 0x04, 0x0a, 
	0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 
	0x05, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 
	0x0e, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 
	0x12, 0x13, 0x14, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x05, 0x0f, 0x00, 
	0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0a, 0x04, 
	0x09, 0x00, 0x0d, 0x02, 0x09, 0x04, 0x0a, 0x00, 0x06, 
	0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0a, 0x04, 0x09, 
	0x00, 0x0d, 0x02, 0x09, 0x04, 0x0a, 0x00, 0x06, 0x10, 
	0x11, 0x16, 0x16, 0x12, 0x14, 0x17, 0x0a, 0x04, 0x09, 
	0x02, 0x01, 0x15, 0x18, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x18, 0x1a, 0x18, 0x00, 0x08, 0x10, 
	0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 
	0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 
	0x11, 0x12, 0x13, 0x13, 0x14, 0x18, 0x15, 0x00, 0x0d, 
	0x02, 0x15, 0x18, 0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 
	0x13, 0x14, 0x18, 0x15, 0x00, 0x0d, 0x02, 0x15, 0x18, 
	0x10, 0x00, 0x05, 0x1b, 0x10, 0x10, 0x11, 0x16, 0x12, 
	0x12, 0x14, 0x17, 0x18, 0x15, 0x02, 0x01, 0x08, 0x06, 
	0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x1d, 0x10, 0x1e, 0x1e, 0x1f, 0x1f, 0x1e, 
	0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 
	0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x20, 
	0x21, 0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 
	0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 
	0x00, 0x04, 0x1e, 0x1f, 0x22, 0x23, 0x23, 0x24, 0x12, 
	0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x1e, 0x1e, 
	0x1f, 0x1f, 0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x25, 0x26, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 
	0x10, 0x21, 0x27, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 
	0x1c, 0x1c, 0x28, 0x26, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x1e, 0x1e, 0x1e, 0x1f, 
	0x29, 0x21, 0x21, 0x27, 0x11, 0x12, 0x13, 0x14, 0x1d, 
	0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x06, 0x04, 0x06, 0x10, 0x00, 0x05, 0x1e, 
	0x10, 0x2a, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 
	0x00, 0x04, 0x1c, 0x2b, 0x2c, 0x2d, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x04, 0x1e, 0x2e, 0x2f, 
	0x2a, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 
	0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x1d, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x06, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x06, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x06, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x06, 0x1b, 0x00, 0x05, 0x1e, 0x1b, 0x10, 0x10, 0x11, 
	0x16, 0x12, 0x14, 0x17, 0x06, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 0x33, 0x33, 
	0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 0x10, 
	0x34, 0x23, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 
	0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x32, 0x32, 0x35, 0x23, 0x2f, 0x10, 0x2a, 
	0x36, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x33, 0x33, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 
	0x26, 0x01, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 
	0x05, 0x32, 0x1e, 0x23, 0x21, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x30, 0x37, 0x01, 0x30, 0x1c, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 
	0x32, 0x38, 0x2e, 0x2e, 0x39, 0x21, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x07, 0x04, 0x07, 0x1e, 0x32, 
	0x32, 0x32, 0x3a, 0x27, 0x3b, 0x21, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 0x28, 0x01, 0x3c, 
	0x31, 0x01, 0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x32, 0x23, 0x39, 0x29, 0x23, 0x33, 0x3e, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x3f, 
	0x40, 0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x32, 0x32, 0x33, 0x00, 0x04, 0x23, 0x41, 0x12, 0x13, 
	0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x1e, 
	0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x1e, 
	0x00, 0x05, 0x32, 0x1e, 0x1b, 0x10, 0x11, 0x16, 0x12, 
	0x14, 0x17, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x1c, 
	0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x33, 0x33, 
	0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 
	0x43, 0x32, 0x1e, 0x10, 0x34, 0x23, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x43, 0x33, 0x33, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x43, 0x33, 0x33, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x44, 0x01, 
	0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 0x21, 0x21, 
	0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 
	0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x07, 0x04, 0x07, 0x1e, 0x32, 0x43, 0x45, 0x33, 0x46, 
	0x39, 0x21, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x42, 0x47, 0x48, 0x30, 0x1c, 0x49, 0x01, 0x2c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x38, 
	0x32, 0x1e, 0x4a, 0x23, 0x4b, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x4c, 0x01, 0x3d, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 
	0x33, 0x34, 0x2e, 0x2f, 0x4a, 0x3e, 0x12, 0x13, 0x14, 
	0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x1e, 0x32, 
	0x43, 0x43, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 
	0x1e, 0x32, 0x00, 0x04, 0x43, 0x38, 0x1b, 0x10, 0x11, 
	0x16, 0x12, 0x14, 0x17, 0x07, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x1c, 0x30, 0x42, 0x4d, 0x4e, 0x49, 0x37, 0x4f, 
	0x50, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x51, 0x33, 0x32, 0x52, 0x35, 0x53, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x54, 0x49, 0x37, 
	0x4f, 0x55, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x43, 0x56, 0x56, 0x57, 0x35, 0x4a, 0x34, 0x23, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x47, 
	0x37, 0x58, 0x50, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x56, 0x33, 0x33, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x48, 
	0x28, 0x37, 0x2d, 0x50, 0x59, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x51, 0x33, 0x32, 0x52, 0x35, 0x53, 
	0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 
	0x4e, 0x5a, 0x2b, 0x2c, 0x5b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x43, 0x5c, 0x5d, 0x2e, 0x2e, 0x2f, 
	0x2a, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 
	0x44, 0x01, 0x30, 0x1c, 0x0b, 0x5b, 0x59, 0x0d, 0x0e, 
	0x0e, 0x31, 0x1e, 0x32, 0x43, 0x56, 0x43, 0x32, 0x1e, 
	0x21, 0x21, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 
	0x48, 0x5a, 0x42, 0x49, 0x5e, 0x0b, 0x5f, 0x4f, 0x0d, 
	0x0e, 0x0e, 0x07, 0x04, 0x07, 0x1e, 0x32, 0x43, 0x56, 
	0x43, 0x32, 0x29, 0x21, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x30, 0x1c, 0x0b, 
	0x01, 0x3d, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x56, 0x43, 0x32, 0x1e, 0x10, 0x23, 0x60, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x61, 0x62, 
	0x31, 0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x43, 0x56, 0x33, 0x2e, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 
	0x1e, 0x32, 0x43, 0x56, 0x43, 0x32, 0x1e, 0x10, 0x10, 
	0x11, 0x12, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 
	0x08, 0x07, 0x1e, 0x32, 0x43, 0x56, 0x63, 0x64, 0x33, 
	0x2a, 0x10, 0x11, 0x16, 0x12, 0x14, 0x17, 0x07, 0x08, 
	0x02, 0x01, 0x08, 0x07, 0x1c, 0x30, 0x42, 0x5a, 0x62, 
	0x65, 0x37, 0x4c, 0x40, 0x66, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x33, 0x33, 0x33, 0x67, 0x24, 0x23, 
	0x68, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x61, 
	0x01, 0x69, 0x37, 0x6a, 0x62, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x43, 0x56, 0x3b, 0x39, 0x35, 0x33, 
	0x33, 0x23, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 
	0x42, 0x6b, 0x62, 0x37, 0x6c, 0x40, 0x5b, 0x0d, 0x0e, 
	0x0e, 0x31, 0x1e, 0x32, 0x00, 0x07, 0x23, 0x60, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x48, 0x31, 0x31, 
	0x37, 0x4c, 0x4c, 0x01, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x33, 0x33, 0x33, 0x3b, 0x39, 0x23, 0x20, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0x6a, 
	0x3c, 0x26, 0x40, 0x26, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x6d, 0x33, 0x33, 0x29, 0x23, 0x34, 
	0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x44, 
	0x01, 0x30, 0x1c, 0x6e, 0x01, 0x6f, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 0x21, 
	0x21, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x5a, 
	0x01, 0x6a, 0x40, 0x40, 0x61, 0x62, 0x01, 0x70, 0x0e, 
	0x0e, 0x07, 0x04, 0x07, 0x1e, 0x32, 0x43, 0x43, 0x43, 
	0x32, 0x29, 0x21, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x2d, 0x01, 
	0x70, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 
	0x43, 0x32, 0x1e, 0x4a, 0x23, 0x2a, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x42, 0x42, 0x54, 0x40, 0x5e, 0x26, 
	0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x43, 0x33, 0x2e, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x1e, 
	0x32, 0x43, 0x43, 0x43, 0x32, 0x43, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x1e, 0x32, 0x43, 0x63, 0x71, 0x3b, 0x2e, 0x1b, 
	0x10, 0x11, 0x16, 0x12, 0x14, 0x17, 0x07, 0x08, 0x02, 
	0x01, 0x08, 0x07, 0x1c, 0x30, 0x30, 0x72, 0x30, 0x30, 
	0x1c, 0x73, 0x01, 0x3d, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x33, 0x23, 0x2f, 0x1e, 0x10, 0x35, 0x22, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x47, 0x01, 0x61, 
	0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x32, 0x46, 0x22, 0x63, 0x1e, 0x10, 0x74, 
	0x23, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 0x37, 
	0x40, 0x72, 0x1c, 0x0b, 0x31, 0x75, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x32, 0x32, 0x33, 0x33, 0x1e, 0x10, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 
	0x37, 0x40, 0x72, 0x1c, 0x0b, 0x75, 0x01, 0x0d, 0x0e, 
	0x0e, 0x31, 0x1e, 0x32, 0x32, 0x33, 0x23, 0x76, 0x1e, 
	0x10, 0x3b, 0x21, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 
	0x05, 0x30, 0x1c, 0x26, 0x26, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 0x23, 0x34, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 0x37, 0x01, 
	0x30, 0x50, 0x40, 0x6f, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x00, 0x05, 0x32, 0x1e, 0x21, 0x21, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x5a, 0x01, 0x6b, 0x30, 
	0x01, 0x31, 0x0b, 0x26, 0x77, 0x0e, 0x0e, 0x07, 0x04, 
	0x07, 0x1e, 0x00, 0x05, 0x32, 0x29, 0x21, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 
	0x25, 0x40, 0x78, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x32, 0x32, 0x38, 0x46, 0x67, 0x33, 0x79, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 0x30, 0x4c, 0x7a, 
	0x1c, 0x26, 0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x32, 0x33, 0x23, 0x3b, 0x1f, 0x2a, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x1e, 0x00, 0x04, 0x32, 0x76, 0x39, 0x2a, 0x10, 
	0x11, 0x12, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 
	0x08, 0x07, 0x1e, 0x32, 0x43, 0x64, 0x3b, 0x3a, 0x1e, 
	0x1b, 0x10, 0x11, 0x16, 0x12, 0x14, 0x17, 0x07, 0x08, 
	0x02, 0x01, 0x08, 0x07, 0x0b, 0x00, 0x04, 0x1c, 0x54, 
	0x2c, 0x55, 0x01, 0x3d, 0x0d, 0x0e, 0x0e, 0x31, 0x10, 
	0x1e, 0x1e, 0x29, 0x29, 0x1e, 0x10, 0x10, 0x4a, 0x23, 
	0x53, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x7b, 0x62, 0x1c, 
	0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x10, 0x1e, 0x1e, 0x39, 0x67, 0x1e, 0x10, 0x10, 0x34, 
	0x23, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 0x62, 
	0x69, 0x1c, 0x0b, 0x0b, 0x3d, 0x40, 0x0d, 0x0e, 0x0e, 
	0x31, 0x10, 0x1e, 0x1e, 0x1e, 0x29, 0x29, 0x10, 0x10, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 
	0x62, 0x7b, 0x1c, 0x0b, 0x0b, 0x3d, 0x01, 0x0d, 0x0e, 
	0x0e, 0x31, 0x10, 0x1e, 0x1e, 0x29, 0x39, 0x1e, 0x10, 
	0x10, 0x21, 0x21, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x00, 
	0x05, 0x1c, 0x0b, 0x26, 0x26, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x23, 0x34, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 0x37, 0x01, 
	0x50, 0x40, 0x6b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x10, 0x00, 0x05, 0x1e, 0x10, 0x21, 0x21, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x0b, 0x1c, 0x2b, 0x01, 0x54, 0x1c, 
	0x01, 0x5f, 0x0b, 0x26, 0x77, 0x0e, 0x0e, 0x07, 0x04, 
	0x07, 0x10, 0x00, 0x05, 0x1e, 0x21, 0x21, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x0b, 0x00, 0x05, 0x1c, 0x6e, 
	0x40, 0x5b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x10, 0x1e, 
	0x1e, 0x1e, 0x63, 0x35, 0x1f, 0x22, 0x27, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 0x49, 0x62, 0x54, 
	0x0b, 0x26, 0x3d, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x10, 
	0x00, 0x05, 0x1e, 0x2e, 0x39, 0x39, 0x11, 0x12, 0x13, 
	0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x10, 
	0x1e, 0x1e, 0x1e, 0x74, 0x23, 0x23, 0x39, 0x2a, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x1b, 0x43, 0x29, 0x7c, 0x57, 0x38, 0x41, 0x53, 
	0x53, 0x36, 0x7d, 0x7e, 0x7f, 0x17, 0x07, 0x08, 0x02, 
	0x01, 0x08, 0x07, 0x0b, 0x0b, 0x0b, 0x73, 0x7b, 0x01, 
	0x31, 0x26, 0x01, 0x77, 0x0e, 0x0e, 0x0e, 0x31, 0x10, 
	0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x10, 0x41, 0x23, 
	0x80, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x26, 0x26, 0x00, 
	0x04, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x31, 0x10, 
	0x10, 0x10, 0x23, 0x35, 0x10, 0x10, 0x10, 0x60, 0x23, 
	0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x0b, 0x01, 0x62, 
	0x26, 0x26, 0x26, 0x62, 0x01, 0x0e, 0x0e, 0x0e, 0x31, 
	0x00, 0x04, 0x10, 0x21, 0x21, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x0b, 0x01, 0x4f, 
	0x0b, 0x0b, 0x0b, 0x3d, 0x01, 0x0e, 0x0e, 0x0e, 0x31, 
	0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x10, 0x21, 
	0x21, 0x13, 0x13, 0x14, 0x31, 0x00, 0x07, 0x0b, 0x26, 
	0x26, 0x0d, 0x0e, 0x0e, 0x0e, 0x31, 0x00, 0x07, 0x10, 
	0x23, 0x60, 0x12, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 
	0x0b, 0x4f, 0x01, 0x26, 0x81, 0x2d, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x0e, 0x31, 0x00, 0x07, 0x10, 0x21, 0x21, 0x12, 
	0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x2c, 0x01, 0x0b, 
	0x0b, 0x01, 0x55, 0x0c, 0x26, 0x77, 0x0e, 0x0e, 0x07, 
	0x04, 0x07, 0x00, 0x06, 0x10, 0x21, 0x21, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x31, 0x00, 0x05, 0x0b, 0x6e, 0x40, 
	0x5b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x31, 0x00, 0x07, 
	0x10, 0x53, 0x23, 0x4b, 0x13, 0x13, 0x14, 0x31, 0x0b, 
	0x0b, 0x2d, 0x40, 0x5e, 0x0b, 0x0b, 0x26, 0x3d, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x31, 0x00, 0x07, 0x10, 0x2a, 0x23, 
	0x68, 0x13, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 0x02, 
	0x08, 0x07, 0x10, 0x10, 0x10, 0x67, 0x00, 0x04, 0x23, 
	0x39, 0x82, 0x13, 0x13, 0x14, 0x07, 0x08, 0x00, 0x0d, 
	0x02, 0x08, 0x07, 0x10, 0x34, 0x23, 0x22, 0x00, 0x04, 
	0x33, 0x21, 0x21, 0x21, 0x74, 0x3e, 0x17, 0x07, 0x08, 
	0x02, 0x01, 0x08, 0x07, 0x0b, 0x0b, 0x0b, 0x4c, 0x62, 
	0x50, 0x0b, 0x0c, 0x01, 0x77, 0x0e, 0x0e, 0x83, 0x31, 
	0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x11, 0x53, 
	0x23, 0x7e, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x26, 0x31, 
	0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x83, 
	0x31, 0x10, 0x10, 0x10, 0x23, 0x34, 0x10, 0x10, 0x11, 
	0x4b, 0x23, 0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x0b, 
	0x01, 0x7b, 0x55, 0x55, 0x59, 0x84, 0x84, 0x0e, 0x0e, 
	0x83, 0x31, 0x00, 0x04, 0x10, 0x21, 0x21, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x0b, 
	0x01, 0x3d, 0x0b, 0x0b, 0x0c, 0x77, 0x01, 0x0e, 0x0e, 
	0x83, 0x31, 0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 
	0x11, 0x21, 0x21, 0x13, 0x14, 0x17, 0x31, 0x00, 0x07, 
	0x0b, 0x26, 0x26, 0x0d, 0x0e, 0x0e, 0x83, 0x31, 0x00, 
	0x07, 0x10, 0x23, 0x4b, 0x12, 0x13, 0x14, 0x17, 0x31, 
	0x0b, 0x0b, 0x0b, 0x3d, 0x01, 0x5b, 0x40, 0x31, 0x66, 
	0x0d, 0x0e, 0x0e, 0x83, 0x31, 0x00, 0x07, 0x10, 0x21, 
	0x21, 0x12, 0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x55, 
	0x01, 0x0b, 0x0b, 0x01, 0x59, 0x0d, 0x26, 0x77, 0x0e, 
	0x83, 0x07, 0x04, 0x07, 0x00, 0x06, 0x10, 0x21, 0x21, 
	0x12, 0x12, 0x13, 0x14, 0x17, 0x31, 0x00, 0x04, 0x0b, 
	0x85, 0x01, 0x85, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x83, 
	0x31, 0x00, 0x07, 0x10, 0x11, 0x21, 0x21, 0x13, 0x14, 
	0x17, 0x31, 0x0b, 0x0b, 0x55, 0x00, 0x07, 0x01, 0x0e, 
	0x0e, 0x83, 0x31, 0x00, 0x07, 0x10, 0x11, 0x23, 0x4b, 
	0x13, 0x14, 0x17, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x10, 0x10, 0x67, 0x00, 0x06, 0x23, 0x39, 0x11, 
	0x14, 0x17, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 
	0x10, 0x10, 0x60, 0x22, 0x57, 0x1b, 0x1b, 0x86, 0x82, 
	0x82, 0x11, 0x7f, 0x17, 0x87, 0x07, 0x08, 0x02, 0x01, 
	0x08, 0x07, 0x0c, 0x0c, 0x0c, 0x01, 0x3d, 0x0c, 0x0c, 
	0x0d, 0x01, 0x77, 0x0e, 0x83, 0x83, 0x31, 0x11, 0x11, 
	0x11, 0x21, 0x21, 0x11, 0x11, 0x12, 0x88, 0x22, 0x14, 
	0x17, 0x17, 0x31, 0x0c, 0x0c, 0x4f, 0x01, 0x66, 0x0c, 
	0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x83, 0x83, 0x31, 0x11, 
	0x11, 0x11, 0x39, 0x1f, 0x11, 0x11, 0x12, 0x21, 0x23, 
	0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 0x0c, 0x75, 0x31, 
	0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x83, 0x83, 0x31, 
	0x00, 0x04, 0x11, 0x21, 0x21, 0x11, 0x12, 0x12, 0x13, 
	0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 0x0c, 0x31, 0x31, 
	0x0c, 0x0c, 0x0d, 0x89, 0x01, 0x0e, 0x83, 0x83, 0x31, 
	0x11, 0x11, 0x11, 0x21, 0x21, 0x11, 0x11, 0x12, 0x21, 
	0x74, 0x14, 0x17, 0x17, 0x31, 0x00, 0x07, 0x0c, 0x26, 
	0x26, 0x0e, 0x0e, 0x83, 0x83, 0x31, 0x00, 0x07, 0x11, 
	0x23, 0x4b, 0x13, 0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 
	0x0c, 0x3d, 0x01, 0x0c, 0x5f, 0x01, 0x6c, 0x0e, 0x0e, 
	0x83, 0x83, 0x31, 0x00, 0x07, 0x11, 0x21, 0x21, 0x13, 
	0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 0x59, 0x01, 0x0c, 
	0x0c, 0x01, 0x84, 0x0d, 0x8a, 0x0f, 0x83, 0x83, 0x07, 
	0x04, 0x07, 0x00, 0x06, 0x11, 0x21, 0x21, 0x12, 0x13, 
	0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 0x0c, 0x78, 0x40, 
	0x3d, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x83, 0x83, 0x31, 
	0x00, 0x07, 0x11, 0x12, 0x3b, 0x67, 0x14, 0x17, 0x17, 
	0x31, 0x00, 0x07, 0x0c, 0x26, 0x77, 0x0e, 0x0e, 0x83, 
	0x83, 0x31, 0x00, 0x07, 0x11, 0x3e, 0x23, 0x68, 0x14, 
	0x17, 0x17, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 
	0x11, 0x53, 0x00, 0x05, 0x60, 0x4b, 0x4b, 0x4b, 0x8b, 
	0x17, 0x17, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 
	0x11, 0x11, 0x11, 0x8c, 0x7c, 0x8c, 0x11, 0x16, 0x16, 
	0x12, 0x14, 0x17, 0x17, 0x87, 0x07, 0x08, 0x02, 0x01, 
	0x08, 0x07, 0x0d, 0x0d, 0x0d, 0x62, 0x31, 0x66, 0x66, 
	0x6c, 0x01, 0x8d, 0x0e, 0x83, 0x8e, 0x31, 0x12, 0x12, 
	0x12, 0x21, 0x23, 0x20, 0x12, 0x7e, 0x22, 0x4b, 0x14, 
	0x17, 0x87, 0x31, 0x0d, 0x0d, 0x66, 0x31, 0x31, 0x8f, 
	0x0d, 0x0e, 0x90, 0x91, 0x0e, 0x83, 0x8e, 0x31, 0x12, 
	0x12, 0x12, 0x4b, 0x22, 0x7e, 0x82, 0x1f, 0x21, 0x23, 
	0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 0x0d, 0x8f, 0x01, 
	0x6c, 0x66, 0x0e, 0x92, 0x93, 0x0e, 0x83, 0x8e, 0x31, 
	0x00, 0x04, 0x12, 0x21, 0x21, 0x12, 0x13, 0x13, 0x14, 
	0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 0x0d, 0x90, 0x01, 
	0x77, 0x84, 0x3c, 0x3c, 0x01, 0x0e, 0x83, 0x8e, 0x31, 
	0x12, 0x12, 0x12, 0x21, 0x21, 0x12, 0x12, 0x13, 0x74, 
	0x74, 0x14, 0x17, 0x87, 0x31, 0x00, 0x07, 0x0d, 0x8a, 
	0x8a, 0x0e, 0x0e, 0x83, 0x8e, 0x31, 0x00, 0x07, 0x12, 
	0x23, 0x4b, 0x14, 0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 
	0x0d, 0x77, 0x01, 0x0d, 0x0d, 0x70, 0x01, 0x6c, 0x0e, 
	0x83, 0x8e, 0x31, 0x00, 0x07, 0x12, 0x74, 0x74, 0x14, 
	0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 0x84, 0x01, 0x0d, 
	0x0d, 0x01, 0x90, 0x0e, 0x8a, 0x0f, 0x83, 0x8e, 0x07, 
	0x04, 0x07, 0x12, 0x12, 0x12, 0x7e, 0x53, 0x53, 0x39, 
	0x39, 0x80, 0x7d, 0x3e, 0x17, 0x87, 0x31, 0x0d, 0x0d, 
	0x0d, 0x94, 0x01, 0x95, 0x84, 0x90, 0x90, 0x91, 0x0e, 
	0x83, 0x8e, 0x31, 0x12, 0x12, 0x12, 0x3e, 0x41, 0x12, 
	0x82, 0x88, 0x23, 0x7e, 0x14, 0x17, 0x87, 0x31, 0x00, 
	0x07, 0x0d, 0x8a, 0x77, 0x0e, 0x0e, 0x83, 0x8e, 0x31, 
	0x00, 0x04, 0x12, 0x41, 0x12, 0x82, 0x39, 0x3b, 0x96, 
	0x14, 0x17, 0x87, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x00, 0x07, 0x12, 0x13, 0x13, 0x14, 0x14, 0x17, 
	0x87, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x16, 
	0x16, 0x16, 0x11, 0x20, 0x3b, 0x20, 0x12, 0x12, 0x14, 
	0x14, 0x17, 0x87, 0x87, 0x07, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x0e, 0x0e, 0x0e, 0x97, 0x31, 0x01, 0x98, 0x99, 
	0x70, 0x01, 0x9a, 0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 
	0x88, 0x68, 0x4b, 0x22, 0x22, 0x88, 0x17, 0x17, 0x87, 
	0x9c, 0x31, 0x0e, 0x0e, 0x0e, 0x9d, 0x94, 0x9e, 0x01, 
	0x01, 0x8a, 0x9f, 0x83, 0x8e, 0x9b, 0x31, 0x00, 0x04, 
	0x13, 0x88, 0x23, 0x22, 0xa0, 0x79, 0x74, 0x17, 0x87, 
	0x9c, 0x31, 0x00, 0x04, 0x0e, 0xa1, 0x3c, 0x01, 0x01, 
	0x98, 0x9a, 0x83, 0x8e, 0x9b, 0x31, 0x00, 0x04, 0x13, 
	0x88, 0x88, 0x13, 0x13, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x31, 0x00, 0x04, 0x0e, 0x95, 0x8a, 0x3c, 0xa1, 0x0f, 
	0x01, 0x83, 0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x88, 
	0x88, 0x13, 0x13, 0x13, 0x88, 0x88, 0x17, 0x87, 0x9c, 
	0x31, 0x00, 0x07, 0x0e, 0xa2, 0xa2, 0x83, 0x83, 0x8e, 
	0x9b, 0x31, 0x00, 0x07, 0x13, 0x23, 0x4b, 0x17, 0x17, 
	0x87, 0x9c, 0x31, 0x0e, 0x0e, 0x0e, 0x99, 0x8a, 0x0e, 
	0x0e, 0x0e, 0xa3, 0x8a, 0x07, 0x8e, 0x9b, 0x31, 0x00, 
	0x07, 0x13, 0x88, 0x88, 0x17, 0x17, 0x87, 0x9c, 0x31, 
	0x0e, 0x0e, 0x97, 0x8a, 0x0e, 0x0e, 0x8a, 0x97, 0x0e, 
	0xa2, 0xa4, 0x8e, 0x9b, 0x07, 0x04, 0x07, 0x13, 0x13, 
	0x13, 0x88, 0x00, 0x06, 0x74, 0x88, 0x87, 0x9c, 0x31, 
	0x0e, 0x0e, 0x0e, 0xa2, 0x00, 0x05, 0x8a, 0xa4, 0x83, 
	0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x7e, 0x3b, 0x23, 
	0x23, 0x39, 0x80, 0x17, 0x17, 0x87, 0x9c, 0x31, 0x00, 
	0x07, 0x0e, 0xa2, 0x93, 0x83, 0x83, 0x8e, 0x9b, 0x31, 
	0x00, 0x04, 0x13, 0x39, 0x23, 0x23, 0x67, 0x82, 0x17, 
	0x17, 0x87, 0x9c, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x00, 0x08, 0x13, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x00, 0x05, 
	0x12, 0x20, 0x67, 0x82, 0x14, 0x17, 0x17, 0x87, 0x87, 
	0x87, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x00, 0x08, 
	0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x08, 
	0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x08, 
	0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x08, 
	0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x08, 
	0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x08, 
	0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x08, 
	0x0e, 0x94, 0x8a, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x08, 
	0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x08, 
	0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x06, 
	0x14, 0x96, 0x23, 0x8b, 0x17, 0x87, 0x9c, 0x9c, 0x31, 
	0x00, 0x08, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 
	0x00, 0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 
	0x00, 0x08, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x07, 
	0x04, 0x07, 0x00, 0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x9c, 0x31, 0x00, 0x08, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x31, 0x00, 0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x9c, 0x31, 0x00, 0x08, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x31, 0x00, 0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x9c, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 0x07, 0x00, 
	0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x07, 0x08, 
	0x00, 0x0d, 0x02, 0x08, 0x07, 0x00, 0x06, 0x14, 0x7f, 
	0x14, 0x17, 0x17, 0x87, 0x87, 0x87, 0x9c, 0x07, 0x08, 
	0x02, 0x01, 0x08, 0x07, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x31, 0x83, 0x83, 0x83, 0xa7, 0xa8, 
	0xa9, 0xaa, 0x0f, 0x01, 0xab, 0x9b, 0x9b, 0xa5, 0x31, 
	0x00, 0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 
	0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 
	0x17, 0x17, 0x17, 0x20, 0x80, 0x7e, 0x1f, 0x22, 0x14, 
	0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 
	0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 
	0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 
	0x8e, 0x9b, 0x9b, 0xa5, 0x07, 0x04, 0x07, 0x00, 0x08, 
	0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 
	0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 
	0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 
	0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 
	0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x07, 0x08, 0x00, 
	0x0d, 0x02, 0x08, 0x07, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x07, 0x08, 0x00, 0x0d, 0x02, 0x08, 
	0x07, 0x00, 0x08, 0x17, 0x00, 0x04, 0x87, 0x9c, 0xa6, 
	0x07, 0x08, 0x02, 0x01, 0x08, 0x06, 0x00, 0x08, 0x8e, 
	0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 
	0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 
	0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 
	0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 
	0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 
	0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x8e, 0x8e, 0x8e, 
	0xa7, 0x0f, 0x8a, 0x8a, 0x19, 0xae, 0x9b, 0xa5, 0xa5, 
	0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 
	0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 
	0xac, 0x1d, 0x87, 0x87, 0x87, 0x8b, 0x1f, 0x74, 0x88, 
	0x96, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 
	0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 
	0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 
	0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x06, 0x04, 0x06, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x06, 
	0x08, 0x00, 0x0d, 0x02, 0x08, 0x06, 0x00, 0x08, 0x87, 
	0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x06, 0x08, 0x00, 0x0d, 
	0x02, 0x08, 0x06, 0x00, 0x0a, 0x87, 0x9c, 0x9c, 0xa6, 
	0xa6, 0x06, 0x08, 0x02, 0x01, 0x15, 0x18, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 
	0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 
	0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x18, 0x1a, 0x18, 
	0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 
	0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 
	0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 
	0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 
	0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x18, 
	0x15, 0x00, 0x0d, 0x02, 0x15, 0x18, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x18, 0x15, 0x00, 0x0d, 
	0x02, 0x15, 0x18, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0x9c, 
	0xa6, 0xad, 0xad, 0x18, 0x15, 0x02, 0x01, 0x09, 0x04, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x18, 
	0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x04, 
	0x15, 0x04, 0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 
	0x0f, 0x18, 0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 
	0x0f, 0x18, 0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 
	0x0f, 0x18, 0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 
	0x0f, 0x18, 0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 
	0x0f, 0x04, 0x09, 0x02, 0x09, 0x15, 0x00, 0x09, 0x08, 
	0x15, 0x15, 0x04, 0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 
	0xad, 0x0f, 0x04, 0x15, 0x15, 0x00, 0x09, 0x08, 0x15, 
	0x09, 0x02, 0x09, 0x04, 0x0f, 0x00, 0x08, 0x9c, 0xa6, 
	0xa6, 0xad, 0xad, 0x0f, 0x04, 0x09, 0x02, 0x01, 0x09, 
	0x08, 0x05, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 
	0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 
	0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 
	0x1d, 0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 
	0x31, 0x1d, 0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 
	0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 
	0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 0x18, 0x19, 
	0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 0x18, 
	0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 
	0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 
	0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 
	0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 
	0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 
	0x1d, 0x19, 0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 
	0x31, 0x1d, 0x19, 0x05, 0x08, 0x09, 0x08, 0x05, 0x19, 
	0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 0x18, 
	0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 0x04, 
	0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 0x18, 
	0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 0x19, 
	0x18, 0x04, 0x18, 0x19, 0x1d, 0x00, 0x07, 0x31, 0x1d, 
	0x19, 0x05, 0x08, 0x09, 0x03, 0x04, 0x05, 0x06, 0x00, 
	0x07, 0x07, 0x06, 0x05, 0x04, 0x8e, 0x05, 0x19, 0x1d, 
	0x00, 0x07, 0x31, 0x1d, 0x19, 0x05, 0x8e, 0x04, 0x05, 
	0x06, 0x00, 0x07, 0x07, 0x06, 0x05, 0x04, 0x03, 0x09, 
	0x08, 0x05, 0x19, 0x1d, 0x00, 0x08, 0x31, 0x1d, 0x19, 
	0x05, 0x08, 0x09, 0x02, 0x01, 0x09, 0x04, 0x0f, 0x00, 
	0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 0x18, 
	0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 
	0x0f, 0x18, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 
	0x13, 0x14, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x18, 0x0f, 0x00, 0x06, 
	0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 0x18, 0x0f, 
	0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 
	0x18, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x14, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x0e, 0x0e, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x10, 
	0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 0x18, 0x0f, 0x00, 
	0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x18, 
	0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 
	0x0f, 0x18, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x0e, 0x0e, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x14, 0x0f, 0x04, 0x15, 0x04, 0x0f, 
	0x00, 0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 
	0x18, 0x0f, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x14, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x0e, 0x0e, 0x0f, 0x18, 0x0f, 0x00, 0x06, 0x10, 
	0x11, 0x12, 0x12, 0x13, 0x14, 0x0f, 0x18, 0x0f, 0x00, 
	0x06, 0x0b, 0x0c, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x04, 
	0x15, 0x04, 0x0a, 0x00, 0x06, 0x10, 0x11, 0x12, 0x12, 
	0x13, 0x14, 0x0f, 0x05, 0x0f, 0x00, 0x06, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x05, 0x0f, 0x00, 0x06, 
	0x10, 0x11, 0x12, 0x12, 0x13, 0x14, 0x0a, 0x04, 0x15, 
	0x04, 0x0f, 0x00, 0x06, 0x0b, 0xaf, 0x0d, 0x0d, 0x0d, 
	0x0e, 0xb0, 0x0f, 0x04, 0x09, 0x02, 0x01, 0x15, 0x18, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x19, 
	0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x0e, 0x19, 
	0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 0x14, 0x18, 
	0x1a, 0x18, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 
	0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 0x13, 0x13, 
	0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x0e, 0x18, 0x1a, 0x18, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x19, 0x00, 0x08, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x0e, 0x19, 0x00, 0x08, 0x10, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x18, 0x1a, 0x18, 0x0b, 0x00, 0x05, 
	0x1c, 0x0b, 0x0b, 0xaf, 0x0d, 0x0d, 0x0d, 0x0e, 0xb0, 
	0x18, 0x15, 0x02, 0x01, 0x08, 0x06, 0x10, 0x00, 0x05, 
	0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 
	0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 
	0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 
	0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 
	0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 
	0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 
	0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 
	0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 
	0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x06, 
	0x04, 0x06, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 
	0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 
	0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x1d, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 
	0x11, 0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 
	0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x06, 0x04, 
	0x06, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x1d, 0x0b, 0x00, 0x05, 0x1c, 0x0b, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x1d, 0x10, 0x00, 
	0x05, 0x1e, 0x10, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x06, 0x04, 0x06, 0x00, 0x07, 0x1c, 0x0b, 0x0b, 0xaf, 
	0x0d, 0x0d, 0x0e, 0xb0, 0x06, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x1e, 0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 
	0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 
	0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 
	0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 
	0x05, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x04, 0x07, 0x1c, 0x00, 0x05, 
	0x30, 0x3f, 0x2c, 0x5b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x00, 0x04, 0x30, 0x72, 0x2b, 
	0x2c, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 
	0x04, 0x32, 0x38, 0x2e, 0x2a, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x00, 0x04, 0x30, 0x4e, 0x2b, 0x2d, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x07, 0x04, 0x07, 0x1e, 
	0x00, 0x05, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x0b, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x00, 0x05, 0x32, 
	0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x07, 0x04, 
	0x07, 0x1c, 0x00, 0x05, 0x30, 0x1c, 0x1c, 0x0b, 0x0c, 
	0xb1, 0x0e, 0x0e, 0xb0, 0x07, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 0x10, 
	0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 
	0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 
	0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 
	0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 
	0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 
	0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 
	0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x43, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x43, 0x43, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x07, 0x04, 0x07, 0x1c, 0x30, 0x42, 0x42, 
	0x48, 0x69, 0x40, 0x26, 0x62, 0x26, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x43, 0xb2, 0x00, 0x06, 0x23, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0xb3, 0x40, 
	0x26, 0x62, 0x40, 0x5b, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x43, 0x29, 0x22, 0x29, 0x23, 0x27, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x42, 0x6a, 
	0x40, 0x26, 0x40, 0x25, 0x0c, 0x0d, 0x0e, 0x0e, 0x07, 
	0x04, 0x07, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 
	0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 
	0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x07, 0x04, 
	0x07, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x1c, 
	0x0b, 0x5b, 0x62, 0xb1, 0x0e, 0xb0, 0x07, 0x08, 0x02, 
	0x01, 0x08, 0x07, 0x1e, 0x32, 0x43, 0xb4, 0x6d, 0x32, 
	0x52, 0x35, 0x53, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x42, 0x4d, 0x48, 0x28, 0x37, 0x61, 0x2d, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0xb4, 0x6d, 
	0x32, 0x52, 0x35, 0x53, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0x4d, 0x54, 0x49, 0x37, 0x2d, 0x50, 
	0x5b, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x56, 
	0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x30, 0x1c, 0x0b, 
	0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 
	0x56, 0x43, 0x33, 0x52, 0x10, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x30, 0x1c, 
	0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x43, 0x56, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x30, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x56, 0x43, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 
	0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x56, 0x43, 0x32, 0x1e, 0x10, 0x10, 
	0x11, 0x12, 0x13, 0x14, 0x07, 0x04, 0x07, 0x1c, 0x30, 
	0x42, 0x4d, 0x69, 0x31, 0x54, 0x0b, 0x0b, 0x78, 0x0d, 
	0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x6d, 0x5d, 0x2e, 
	0x2e, 0x2f, 0x67, 0x33, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x42, 0x48, 0x01, 0xb5, 0x1c, 0x0b, 0x4c, 0x75, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0xb2, 0x7c, 
	0x63, 0x1e, 0x4a, 0x23, 0x53, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x42, 0xb6, 0x40, 0xb5, 0x1c, 0xb7, 0x40, 
	0x70, 0x0d, 0x0e, 0x0e, 0x07, 0x04, 0x07, 0x1e, 0x32, 
	0x43, 0x56, 0x43, 0x32, 0x1e, 0x10, 0x53, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4d, 0x42, 0x30, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x56, 0xb4, 0x32, 0x1e, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x04, 0x07, 0x1c, 0x30, 0x42, 
	0x4d, 0x42, 0x30, 0x1c, 0x1c, 0x0b, 0xb8, 0xb9, 0xb1, 
	0x0e, 0xb0, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x1e, 
	0x32, 0x43, 0x33, 0x33, 0x33, 0x3b, 0x39, 0x23, 0x20, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4e, 0x40, 
	0x4c, 0x37, 0x4c, 0x40, 0x5b, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x33, 0x33, 0x76, 0x67, 0x24, 0x23, 
	0x68, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x4e, 
	0x40, 0x69, 0x37, 0x31, 0x31, 0x26, 0x0d, 0x0e, 0x0e, 
	0x31, 0x1e, 0x32, 0x43, 0x6d, 0x6d, 0x32, 0x2f, 0x35, 
	0x34, 0x3e, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 
	0x42, 0x48, 0x49, 0x37, 0x4f, 0x55, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x23, 0x35, 
	0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 
	0x42, 0x4e, 0x4e, 0x30, 0x1c, 0x0b, 0x5b, 0x5b, 0x0d, 
	0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x38, 0x5d, 0x56, 0x32, 
	0x1e, 0x10, 0x2a, 0x41, 0x3e, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x5a, 0x54, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x78, 
	0x84, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x56, 0x5d, 0x6d, 
	0x32, 0x1e, 0x10, 0x2a, 0x41, 0x82, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x54, 0x5a, 0x48, 0x30, 0x1c, 0x0b, 0x0b, 
	0x5b, 0x5b, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x6d, 
	0x5d, 0x2e, 0x2e, 0x2f, 0x4a, 0x36, 0x12, 0x13, 0x14, 
	0x07, 0x04, 0x07, 0x1c, 0x30, 0x42, 0x4e, 0x01, 0x47, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x43, 0x43, 0x43, 0x32, 0x1e, 0xba, 0x22, 0x2a, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x5a, 0x01, 
	0x72, 0x1c, 0x0b, 0x3d, 0x75, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x32, 0x43, 0x22, 0xbb, 0x32, 0x1e, 0x10, 0x39, 
	0x74, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x42, 0x31, 
	0x65, 0x30, 0x1c, 0x0b, 0x6a, 0x31, 0x0d, 0x0e, 0x0e, 
	0x07, 0x04, 0x07, 0x1e, 0x32, 0x43, 0x43, 0x43, 0x32, 
	0x1e, 0x67, 0x34, 0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 0x0b, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x43, 0x43, 0xb2, 
	0x76, 0x1e, 0x10, 0x10, 0x11, 0x12, 0x13, 0x14, 0x07, 
	0x04, 0x07, 0x1c, 0x30, 0x42, 0x42, 0x42, 0x30, 0x1c, 
	0x1c, 0x0b, 0xb8, 0xb9, 0xb1, 0x0e, 0xb0, 0x07, 0x08, 
	0x02, 0x01, 0x08, 0x07, 0x1e, 0x32, 0x32, 0x33, 0x23, 
	0x76, 0x1e, 0x10, 0x3b, 0x21, 0x12, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x30, 0x4c, 0x4c, 0x30, 0x1c, 0x0b, 0x4c, 
	0x89, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 0x33, 
	0x23, 0x2f, 0x1e, 0x10, 0x35, 0x22, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x30, 0x4c, 0x4c, 0x30, 0x1c, 0x73, 
	0x62, 0x26, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 
	0x33, 0x33, 0x76, 0x51, 0x35, 0x3b, 0x41, 0x12, 0x13, 
	0x14, 0x31, 0x1c, 0x30, 0x30, 0x4e, 0x40, 0x69, 0x37, 
	0x6a, 0x31, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 
	0x32, 0x00, 0x07, 0x23, 0x12, 0x13, 0x14, 0x31, 0x1c, 
	0x30, 0x30, 0x3c, 0x3c, 0x30, 0x1c, 0x0b, 0x26, 0x26, 
	0x0d, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x38, 0x23, 0x35, 
	0x32, 0x1e, 0x10, 0x20, 0x23, 0x7e, 0x13, 0x14, 0x31, 
	0x1c, 0x30, 0x62, 0x37, 0x30, 0x4e, 0x37, 0xb7, 0x0b, 
	0x59, 0x31, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 0x29, 
	0x23, 0x38, 0x1e, 0x10, 0x33, 0x33, 0x12, 0x13, 0x14, 
	0x31, 0x1c, 0x30, 0x4e, 0x01, 0x49, 0x30, 0x1c, 0x0b, 
	0x50, 0x01, 0x5b, 0x0e, 0x0e, 0x31, 0x1e, 0x32, 0x32, 
	0xbb, 0x33, 0x33, 0x29, 0x21, 0x23, 0x21, 0x12, 0x13, 
	0x14, 0x07, 0x04, 0x07, 0x1c, 0x30, 0x30, 0x37, 0x40, 
	0x30, 0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x1e, 0x00, 0x05, 0x32, 0x1e, 0x74, 0x34, 0x11, 0x12, 
	0x13, 0x14, 0x31, 0x1c, 0x30, 0x30, 0x72, 0x40, 0x6b, 
	0x54, 0x73, 0x40, 0x5f, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x23, 0x46, 0x32, 0x1e, 0x10, 0x21, 0x3b, 
	0x12, 0x13, 0x14, 0x31, 0x1c, 0x30, 0x72, 0x01, 0x28, 
	0x30, 0x1c, 0x0b, 0x61, 0x01, 0x66, 0x0e, 0x0e, 0x07, 
	0x04, 0x07, 0x1e, 0x00, 0x05, 0x32, 0x74, 0x23, 0x34, 
	0x11, 0x12, 0x13, 0x14, 0x31, 0x1c, 0x00, 0x05, 0x30, 
	0x1c, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 0x1e, 
	0x32, 0x32, 0x32, 0x46, 0x23, 0x74, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x07, 0x04, 0x07, 0x1c, 0x00, 0x05, 
	0x30, 0x1c, 0x1c, 0x0b, 0xb8, 0xb9, 0xb1, 0x0e, 0xb0, 
	0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x10, 0x1e, 0x1e, 
	0x29, 0x39, 0x1e, 0x10, 0x10, 0x21, 0x21, 0x12, 0x13, 
	0x14, 0x31, 0x0b, 0x1c, 0x3f, 0x01, 0x28, 0x1c, 0x0b, 
	0x0b, 0x61, 0x01, 0x5b, 0x0e, 0x0e, 0x31, 0x10, 0x1e, 
	0x1e, 0x29, 0x29, 0x1e, 0x10, 0x10, 0x4a, 0x23, 0x53, 
	0x13, 0x14, 0x31, 0x0b, 0x1c, 0x54, 0x01, 0x28, 0x1c, 
	0x0b, 0x0b, 0x26, 0x26, 0x0d, 0x0e, 0x0e, 0x31, 0x10, 
	0x1e, 0x1e, 0x29, 0x23, 0x35, 0x10, 0x10, 0x21, 0x41, 
	0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 0x37, 0x31, 
	0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 0x31, 
	0x10, 0x00, 0x04, 0x1e, 0x23, 0x35, 0x10, 0x10, 0x11, 
	0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 0x26, 0x26, 
	0x1c, 0x0b, 0x0b, 0x26, 0x26, 0x0d, 0x0e, 0x0e, 0x31, 
	0x10, 0x1e, 0x1e, 0x39, 0x39, 0x1e, 0x10, 0x10, 0x74, 
	0x39, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x69, 0x69, 
	0x1c, 0x28, 0x01, 0x6a, 0x0b, 0x3d, 0x94, 0x0e, 0x0e, 
	0x31, 0x10, 0x1e, 0x1e, 0x43, 0x3b, 0x3b, 0x2a, 0x52, 
	0x22, 0x3e, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 
	0x4c, 0x62, 0x1c, 0x0b, 0x0b, 0x7b, 0x89, 0x0d, 0x0e, 
	0x0e, 0x31, 0x10, 0x00, 0x05, 0x1e, 0x10, 0x27, 0x22, 
	0x36, 0x12, 0x13, 0x14, 0x07, 0x04, 0x07, 0x0b, 0x1c, 
	0x1c, 0x26, 0x26, 0x6e, 0x40, 0x01, 0x75, 0x78, 0x0d, 
	0x0e, 0x0e, 0x31, 0x10, 0x00, 0x05, 0x1e, 0x4a, 0x22, 
	0x2a, 0x11, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 0x1c, 
	0x1c, 0x50, 0x40, 0x62, 0x31, 0x6f, 0x0c, 0x0d, 0x0e, 
	0x0e, 0x31, 0x10, 0x1e, 0x1e, 0x3b, 0x51, 0x1e, 0x10, 
	0x10, 0x3b, 0x23, 0x12, 0x13, 0x14, 0x31, 0x0b, 0x1c, 
	0x2b, 0x01, 0x2b, 0x1c, 0x0b, 0x0b, 0x55, 0x01, 0x84, 
	0x0e, 0x0e, 0x07, 0x04, 0x07, 0x10, 0x00, 0x04, 0x1e, 
	0x74, 0x23, 0x23, 0x34, 0x11, 0x12, 0x13, 0x14, 0x31, 
	0x0b, 0x00, 0x05, 0x1c, 0x0b, 0x0b, 0x0b, 0x0c, 0x0d, 
	0x0e, 0x0e, 0x31, 0x10, 0x1e, 0x1e, 0x1e, 0x35, 0x23, 
	0x23, 0x67, 0x10, 0x11, 0x12, 0x13, 0x14, 0x07, 0x04, 
	0x07, 0x00, 0x07, 0x1c, 0x0b, 0x0b, 0xb8, 0xb9, 0xb1, 
	0x0e, 0xb0, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x10, 
	0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x10, 0x21, 0x21, 
	0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x2c, 0x01, 0x2c, 
	0x0b, 0x0b, 0x0b, 0x59, 0x01, 0x90, 0x0e, 0x0e, 0x31, 
	0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x10, 0x41, 
	0x23, 0x80, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x2c, 0x01, 
	0x2c, 0x0b, 0x0b, 0x0b, 0x26, 0x26, 0x0e, 0x0e, 0x0e, 
	0x31, 0x10, 0x10, 0x10, 0x21, 0x39, 0x10, 0x10, 0x10, 
	0x11, 0x12, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x0b, 
	0x61, 0x01, 0x4f, 0x50, 0x0b, 0x0c, 0x0d, 0x0e, 0x0e, 
	0x0e, 0x31, 0x00, 0x05, 0x10, 0x23, 0x34, 0x10, 0x11, 
	0x12, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x0b, 0x26, 
	0x26, 0x0b, 0x0b, 0x0b, 0x26, 0x26, 0x0e, 0x0e, 0x0e, 
	0x31, 0x10, 0x10, 0x10, 0x52, 0x23, 0x53, 0x10, 0x2a, 
	0x23, 0x68, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x4f, 
	0x31, 0x0b, 0x7b, 0x25, 0x26, 0x0c, 0x94, 0xbc, 0x0e, 
	0x0e, 0x31, 0x00, 0x04, 0x10, 0x4a, 0x23, 0x74, 0x22, 
	0x79, 0x12, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x0b, 
	0x55, 0x01, 0x61, 0x0b, 0x2d, 0x01, 0x90, 0x0e, 0x0e, 
	0x0e, 0x31, 0x00, 0x06, 0x10, 0xbd, 0x23, 0x79, 0x12, 
	0x13, 0x13, 0x14, 0x07, 0x04, 0x07, 0x0b, 0x0b, 0x0b, 
	0x26, 0x40, 0x6b, 0x2d, 0x50, 0x62, 0x89, 0x0e, 0x0e, 
	0x0e, 0x31, 0x00, 0x06, 0x10, 0x39, 0x20, 0x11, 0x12, 
	0x13, 0x13, 0x14, 0x31, 0x00, 0x04, 0x0b, 0x25, 0x40, 
	0x4c, 0x01, 0x89, 0x66, 0x0e, 0x0e, 0x0e, 0x31, 0x10, 
	0x10, 0x10, 0x2e, 0x23, 0x35, 0x4a, 0x74, 0x33, 0x23, 
	0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x2c, 0x01, 0x2c, 
	0x0b, 0x0b, 0x0b, 0x59, 0x01, 0x90, 0x0e, 0x0e, 0x07, 
	0x04, 0x07, 0x00, 0x04, 0x10, 0x67, 0x23, 0x23, 0x23, 
	0x60, 0x12, 0x13, 0x13, 0x14, 0x31, 0x0b, 0x0b, 0x5e, 
	0x4f, 0x4f, 0x4f, 0x3d, 0x3d, 0x3d, 0x77, 0x77, 0x70, 
	0x0e, 0x31, 0x00, 0x04, 0x10, 0x35, 0x23, 0x23, 0x23, 
	0x67, 0x12, 0x13, 0x13, 0x14, 0x07, 0x04, 0x07, 0x0b, 
	0x00, 0x05, 0x1c, 0xbe, 0xb8, 0xaf, 0xb1, 0xb9, 0xb1, 
	0x0e, 0xb0, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x10, 
	0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x11, 0x21, 0x21, 
	0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x55, 0x01, 0x55, 
	0x0b, 0x0b, 0x0c, 0x84, 0x01, 0x90, 0x0e, 0x83, 0x31, 
	0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x11, 0x53, 
	0x23, 0x7e, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x55, 0x01, 
	0x55, 0x0b, 0x0b, 0x0c, 0x26, 0x26, 0x0e, 0x0e, 0x83, 
	0x31, 0x10, 0x10, 0x10, 0x21, 0x21, 0x10, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x14, 0x17, 0x31, 0x00, 0x04, 0x0b, 
	0x25, 0x40, 0x01, 0x75, 0x8f, 0x0d, 0x0e, 0x0e, 0x83, 
	0x31, 0x00, 0x05, 0x10, 0x23, 0x34, 0x11, 0x12, 0x12, 
	0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x0b, 0x26, 0x26, 
	0x0b, 0x0b, 0x0c, 0x26, 0x26, 0x0e, 0x0e, 0x83, 0x31, 
	0x10, 0x10, 0x10, 0x2a, 0x22, 0x1f, 0x10, 0x4b, 0x22, 
	0x82, 0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x5f, 0x01, 
	0x0b, 0x62, 0x5b, 0x01, 0x0d, 0x31, 0x90, 0x0e, 0x83, 
	0x31, 0x00, 0x05, 0x10, 0x35, 0x23, 0x21, 0x12, 0x12, 
	0x13, 0x14, 0x17, 0x31, 0x00, 0x04, 0x0b, 0x62, 0x4c, 
	0x0b, 0x3d, 0x62, 0x0d, 0x0e, 0x0e, 0x83, 0x31, 0x00, 
	0x05, 0x10, 0x53, 0x23, 0x68, 0x12, 0x12, 0x13, 0x14, 
	0x17, 0x07, 0x04, 0x07, 0x0b, 0x0b, 0x0b, 0x26, 0x01, 
	0x2d, 0x0b, 0x0c, 0x70, 0x01, 0x97, 0x0e, 0x83, 0x31, 
	0x00, 0x05, 0x10, 0x20, 0x3b, 0x11, 0x12, 0x12, 0x13, 
	0x14, 0x17, 0x31, 0x0b, 0x0b, 0x0b, 0x61, 0x01, 0x5b, 
	0x0b, 0x5f, 0x9e, 0x31, 0x0e, 0x0e, 0x83, 0x31, 0x00, 
	0x04, 0x10, 0x79, 0x74, 0x21, 0x79, 0x4b, 0x22, 0x13, 
	0x14, 0x17, 0x31, 0x0b, 0x0b, 0x55, 0x01, 0x55, 0x0b, 
	0x0b, 0x0c, 0x84, 0x01, 0x90, 0x0e, 0x83, 0x07, 0x04, 
	0x07, 0x10, 0x10, 0x10, 0x2a, 0x39, 0x23, 0x23, 0x23, 
	0x4b, 0x12, 0x13, 0x14, 0x17, 0x31, 0x0b, 0x0b, 0x0b, 
	0x6b, 0x00, 0x06, 0x01, 0x31, 0xbf, 0x83, 0x31, 0x00, 
	0x04, 0x10, 0x34, 0x23, 0x23, 0x23, 0x39, 0x82, 0x13, 
	0x14, 0x17, 0x07, 0x04, 0x07, 0x00, 0x05, 0x0b, 0x73, 
	0x25, 0x26, 0xc0, 0xb1, 0xb9, 0xa1, 0xb0, 0x83, 0x07, 
	0x08, 0x02, 0x01, 0x08, 0x07, 0x11, 0x11, 0x11, 0x21, 
	0x21, 0x11, 0x11, 0x12, 0x21, 0x74, 0x14, 0x17, 0x17, 
	0x31, 0x0c, 0x0c, 0x0c, 0x40, 0xc1, 0x0c, 0x0c, 0x0d, 
	0xc1, 0x9e, 0x0e, 0x83, 0x83, 0x31, 0x11, 0x11, 0x11, 
	0x21, 0x21, 0x11, 0x11, 0x12, 0x88, 0x22, 0x14, 0x17, 
	0x17, 0x31, 0x0c, 0x0c, 0x78, 0x01, 0x70, 0x0c, 0x0c, 
	0x66, 0x62, 0x8a, 0x0e, 0x83, 0x83, 0x31, 0x11, 0x11, 
	0x11, 0x21, 0x21, 0x11, 0x11, 0x12, 0x12, 0x13, 0x14, 
	0x17, 0x17, 0x31, 0x00, 0x06, 0x0c, 0x5f, 0x89, 0x01, 
	0xa1, 0x0e, 0x83, 0x83, 0x31, 0x00, 0x05, 0x11, 0x23, 
	0x60, 0x12, 0x12, 0x13, 0x14, 0x17, 0x17, 0x31, 0x0c, 
	0x0c, 0x0c, 0x26, 0x26, 0x0c, 0x0c, 0x0d, 0x26, 0x8a, 
	0x0e, 0x83, 0x83, 0x31, 0x00, 0x04, 0x11, 0x35, 0x22, 
	0x11, 0x39, 0x88, 0x13, 0x14, 0x17, 0x17, 0x31, 0x0c, 
	0x0c, 0x66, 0x01, 0x6f, 0x31, 0x0c, 0x31, 0x84, 0x01, 
	0x0e, 0x83, 0x83, 0x31, 0x00, 0x04, 0x11, 0x3e, 0x39, 
	0xc2, 0x22, 0x7e, 0x13, 0x14, 0x17, 0x17, 0x31, 0x00, 
	0x04, 0x0c, 0x4f, 0x01, 0x59, 0x9e, 0x70, 0x0e, 0x0e, 
	0x83, 0x83, 0x31, 0x00, 0x04, 0x11, 0x36, 0x22, 0x67, 
	0x12, 0x12, 0x13, 0x14, 0x17, 0x17, 0x07, 0x04, 0x07, 
	0x0c, 0x0c, 0x0c, 0xc1, 0x01, 0x0c, 0x0c, 0x0d, 0x84, 
	0x01, 0x90, 0x83, 0x83, 0x31, 0x00, 0x05, 0x11, 0x3b, 
	0x60, 0x12, 0x12, 0x13, 0x14, 0x17, 0x17, 0x31, 0x0c, 
	0x0c, 0x0c, 0x26, 0x26, 0x0c, 0x0c, 0x0d, 0x58, 0x01, 
	0x90, 0x83, 0x83, 0x31, 0x00, 0x07, 0x11, 0x12, 0x21, 
	0x67, 0x14, 0x17, 0x17, 0x31, 0x0c, 0x0c, 0x0c, 0x01, 
	0x4f, 0x0c, 0x0c, 0x0d, 0xbc, 0x01, 0x0e, 0x83, 0x83, 
	0x07, 0x04, 0x07, 0x00, 0x04, 0x11, 0x3e, 0x39, 0x23, 
	0x23, 0x4b, 0x13, 0x14, 0x17, 0x17, 0x31, 0x00, 0x04, 
	0x0c, 0x94, 0x00, 0x04, 0x01, 0x31, 0xbf, 0x83, 0x83, 
	0x31, 0x00, 0x04, 0x11, 0x60, 0x23, 0x23, 0x39, 0x82, 
	0x13, 0x14, 0x17, 0x17, 0x07, 0x04, 0x07, 0x00, 0x04, 
	0xaf, 0xc3, 0xc4, 0x62, 0x84, 0x0d, 0xb1, 0xb9, 0xa1, 
	0xb0, 0x83, 0x07, 0x08, 0x02, 0x01, 0x08, 0x07, 0x12, 
	0x12, 0x12, 0x21, 0x21, 0x12, 0x12, 0x13, 0x74, 0x74, 
	0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 0x0d, 0x77, 0x9e, 
	0x8f, 0x0d, 0xa1, 0x9e, 0x0f, 0x0e, 0x83, 0x8e, 0x31, 
	0x12, 0x12, 0x12, 0x21, 0x23, 0x20, 0x12, 0x7e, 0x22, 
	0x4b, 0x14, 0x17, 0x87, 0x31, 0x0d, 0x0d, 0x0d, 0x89, 
	0x31, 0x66, 0x5b, 0x94, 0x98, 0x8a, 0x0e, 0x83, 0x8e, 
	0x31, 0x12, 0x12, 0x12, 0x21, 0x21, 0x12, 0x12, 0x13, 
	0x13, 0x14, 0x14, 0x17, 0x87, 0x31, 0x00, 0x07, 0x0d, 
	0x0e, 0x31, 0x0f, 0x0e, 0x83, 0x8e, 0x31, 0x00, 0x05, 
	0x12, 0x23, 0x4b, 0x13, 0x13, 0x14, 0x14, 0x17, 0x87, 
	0x31, 0x0d, 0x0d, 0x0d, 0x26, 0x26, 0x0d, 0x0d, 0x97, 
	0x9e, 0x8a, 0x0e, 0x83, 0x8e, 0x31, 0x00, 0x04, 0x12, 
	0x3e, 0x23, 0x4b, 0x23, 0x82, 0x14, 0x14, 0x17, 0x87, 
	0x31, 0x0d, 0x0d, 0x0d, 0x9e, 0x26, 0x77, 0x0d, 0x8d, 
	0x6c, 0x31, 0x0e, 0x83, 0x8e, 0x31, 0x00, 0x04, 0x12, 
	0x67, 0x39, 0x82, 0x22, 0x39, 0x14, 0x14, 0x17, 0x87, 
	0x31, 0x00, 0x04, 0x0d, 0x66, 0x9e, 0x81, 0x9e, 0x9d, 
	0x0e, 0x0e, 0x83, 0x8e, 0x31, 0x12, 0x12, 0x12, 0x82, 
	0x39, 0x21, 0x12, 0x13, 0x13, 0x14, 0x14, 0x17, 0x87, 
	0x07, 0x04, 0x07, 0x0d, 0x0d, 0x0d, 0x70, 0x01, 0x5b, 
	0x0d, 0x0e, 0x99, 0x01, 0x91, 0x83, 0x8e, 0x31, 0x00, 
	0x04, 0x12, 0x68, 0x23, 0x3e, 0x13, 0x13, 0x14, 0x14, 
	0x17, 0x87, 0x31, 0x0d, 0x0d, 0x0d, 0x26, 0x31, 0x0d, 
	0x0d, 0x0e, 0x90, 0x01, 0xa1, 0x83, 0x8e, 0x31, 0x00, 
	0x07, 0x12, 0x82, 0x23, 0x79, 0x14, 0x17, 0x87, 0x31, 
	0x0d, 0x0d, 0x0d, 0x3c, 0x94, 0x0d, 0x0d, 0x0e, 0x94, 
	0x9a, 0x0e, 0x83, 0x8e, 0x07, 0x04, 0x07, 0x00, 0x05, 
	0x12, 0x82, 0x39, 0x23, 0x4b, 0x14, 0x14, 0x17, 0x87, 
	0x31, 0x00, 0x05, 0x0d, 0x6c, 0x01, 0x01, 0x31, 0xbf, 
	0x0e, 0x83, 0x8e, 0x31, 0x00, 0x04, 0x12, 0x4b, 0x23, 
	0x39, 0x11, 0x13, 0x14, 0x14, 0x17, 0x87, 0x07, 0x04, 
	0x07, 0x0d, 0x0d, 0x0d, 0x66, 0x3c, 0x98, 0x99, 0xb1, 
	0xb1, 0x70, 0x9e, 0xc5, 0x83, 0x8e, 0x07, 0x08, 0x02, 
	0x01, 0x08, 0x07, 0x13, 0x13, 0x13, 0x88, 0x88, 0x13, 
	0x13, 0x13, 0x88, 0x88, 0x17, 0x87, 0x9c, 0x31, 0x00, 
	0x04, 0x0e, 0x77, 0x98, 0x01, 0x98, 0x0f, 0x83, 0x83, 
	0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x74, 0x74, 0x88, 
	0x23, 0x22, 0x88, 0x17, 0x17, 0x87, 0x9c, 0x31, 0x0e, 
	0x0e, 0x0e, 0x9d, 0x1d, 0x01, 0x98, 0xa1, 0x8a, 0x8a, 
	0x83, 0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x74, 0x74, 
	0x13, 0x13, 0x13, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x31, 
	0x0e, 0x0e, 0x0e, 0xbc, 0x95, 0x0e, 0x0e, 0x95, 0x01, 
	0xc5, 0x83, 0x8e, 0x9b, 0x31, 0x00, 0x05, 0x13, 0x39, 
	0x39, 0x82, 0x14, 0x7f, 0x7f, 0x87, 0x9c, 0x31, 0x0e, 
	0x0e, 0x0e, 0x94, 0x01, 0x95, 0x99, 0x31, 0x98, 0x8a, 
	0x83, 0x8e, 0x9b, 0x31, 0x00, 0x05, 0x13, 0x21, 0x23, 
	0x21, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x31, 0x0e, 0x0e, 
	0x0e, 0x8a, 0x01, 0x90, 0x0e, 0x99, 0x01, 0x94, 0x83, 
	0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x8b, 0x22, 0x7e, 
	0x13, 0x7d, 0x23, 0x88, 0x17, 0x87, 0x9c, 0x31, 0x00, 
	0x05, 0x0e, 0x94, 0x01, 0x77, 0x0e, 0x83, 0x83, 0x8e, 
	0x9b, 0x31, 0x13, 0x13, 0x13, 0x39, 0xc2, 0xa0, 0x80, 
	0x80, 0x7d, 0x7e, 0x17, 0x87, 0x9c, 0x07, 0x04, 0x07, 
	0x00, 0x04, 0x0e, 0x31, 0x3c, 0x9d, 0x92, 0x31, 0xa2, 
	0x83, 0x8e, 0x9b, 0x31, 0x00, 0x04, 0x13, 0x74, 0x74, 
	0x13, 0x13, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x31, 0x0e, 
	0x0e, 0x0e, 0x95, 0x01, 0xa3, 0x0e, 0x92, 0x31, 0x62, 
	0x83, 0x8e, 0x9b, 0x31, 0x13, 0x13, 0x13, 0x80, 0x7e, 
	0x13, 0x82, 0x39, 0x21, 0x17, 0x17, 0x87, 0x9c, 0x31, 
	0x0e, 0x0e, 0x0e, 0x97, 0x01, 0x70, 0x0e, 0x70, 0x01, 
	0x9f, 0x83, 0x8e, 0x9b, 0x07, 0x04, 0x07, 0x00, 0x06, 
	0x13, 0x11, 0x39, 0x4b, 0x17, 0x17, 0x87, 0x9c, 0x31, 
	0x00, 0x06, 0x0e, 0x6c, 0x31, 0xbf, 0x83, 0x83, 0x8e, 
	0x9b, 0x31, 0x00, 0x04, 0x13, 0x4b, 0x39, 0x11, 0x13, 
	0x14, 0x17, 0x17, 0x87, 0x9c, 0x07, 0x04, 0x07, 0x0d, 
	0x0d, 0x0d, 0xbc, 0x01, 0xb9, 0x89, 0x89, 0x89, 0x31, 
	0x9e, 0xa9, 0x8e, 0x8e, 0x07, 0x08, 0x02, 0x01, 0x08, 
	0x07, 0x00, 0x08, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 
	0x31, 0x00, 0x08, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 
	0x31, 0x14, 0x14, 0x14, 0x74, 0x74, 0x14, 0x14, 0x14, 
	0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x08, 0x0e, 
	0x8a, 0x8a, 0x8e, 0x9b, 0x9b, 0x31, 0x14, 0x14, 0x14, 
	0x88, 0x88, 0x14, 0x14, 0x14, 0x17, 0x17, 0x87, 0x9c, 
	0x9c, 0x31, 0x0e, 0x0e, 0x0e, 0x0f, 0x31, 0x01, 0x01, 
	0x31, 0xa9, 0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x05, 
	0x14, 0x3e, 0x33, 0x23, 0x23, 0x23, 0x96, 0x9c, 0x9c, 
	0x31, 0x0e, 0x0e, 0x0e, 0x91, 0x1d, 0x01, 0x98, 0xc6, 
	0xa2, 0xa2, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x05, 0x14, 
	0x80, 0x74, 0x80, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 
	0x0e, 0x0e, 0x0e, 0xa3, 0x8a, 0x0e, 0x0e, 0x91, 0x8a, 
	0xa4, 0x8e, 0x9b, 0x9b, 0x31, 0x14, 0x14, 0x7f, 0x1f, 
	0x8b, 0x14, 0x14, 0x14, 0x8c, 0x74, 0x96, 0x9c, 0x9c, 
	0x31, 0x00, 0x05, 0x0e, 0x90, 0x01, 0x91, 0x83, 0x83, 
	0x8e, 0x9b, 0x9b, 0x31, 0x14, 0x14, 0x14, 0x00, 0x07, 
	0x74, 0x87, 0x9c, 0x9c, 0x07, 0x04, 0x07, 0x00, 0x04, 
	0x0e, 0x91, 0x9a, 0x01, 0x9e, 0xa2, 0x92, 0x8e, 0x9b, 
	0x9b, 0x31, 0x00, 0x04, 0x14, 0x74, 0x79, 0x14, 0x14, 
	0x17, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x04, 0x0e, 
	0xa9, 0x98, 0x01, 0x9e, 0x94, 0x92, 0x8e, 0x9b, 0x9b, 
	0x31, 0x14, 0x14, 0x14, 0x79, 0x3b, 0x23, 0x22, 0x88, 
	0x7f, 0x17, 0x87, 0x9c, 0x9c, 0x31, 0x00, 0x04, 0x0e, 
	0xa9, 0x98, 0x01, 0x98, 0xa9, 0x83, 0x8e, 0x9b, 0x9b, 
	0x07, 0x04, 0x07, 0x00, 0x07, 0x14, 0x96, 0x8b, 0x17, 
	0x87, 0x9c, 0x9c, 0x31, 0x00, 0x07, 0x0e, 0xbf, 0x83, 
	0x83, 0x8e, 0x9b, 0x9b, 0x31, 0x00, 0x04, 0x14, 0x8b, 
	0x96, 0x14, 0x14, 0x17, 0x17, 0x87, 0x9c, 0x9c, 0x07, 
	0x04, 0x07, 0x00, 0x04, 0x0e, 0x77, 0xb9, 0xbc, 0x9d, 
	0xbf, 0xbf, 0xc7, 0x8e, 0x8e, 0xc8, 0x07, 0x08, 0x02, 
	0x01, 0x08, 0x07, 0x00, 0x08, 0x17, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 
	0x9b, 0xa5, 0x31, 0x17, 0x17, 0x17, 0x74, 0x74, 0x17, 
	0x17, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 
	0x08, 0x83, 0x8a, 0x8a, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 
	0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 
	0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 
	0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 
	0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 
	0x05, 0x83, 0x94, 0x94, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 
	0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 0x9c, 0x9c, 
	0xa6, 0x07, 0x04, 0x07, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x07, 0x04, 0x07, 0x00, 0x08, 0x17, 
	0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x31, 0x00, 0x08, 0x83, 
	0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x31, 0x00, 0x08, 0x17, 
	0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x07, 0x04, 0x07, 0x00, 
	0x04, 0xb0, 0x83, 0xa3, 0xb9, 0xa3, 0x83, 0x83, 0x8e, 
	0x8e, 0xc8, 0xa5, 0x07, 0x08, 0x02, 0x01, 0x08, 0x06, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1d, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1d, 
	0x87, 0x87, 0x87, 0xc9, 0xc9, 0x87, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0xca, 
	0xca, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 
	0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 
	0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 
	0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x8e, 0x8e, 0x8e, 0xae, 
	0x07, 0x01, 0xa7, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 
	0x1d, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 
	0x06, 0x04, 0x06, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 
	0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 
	0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 
	0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 
	0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 
	0xa5, 0xac, 0x06, 0x04, 0x06, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x1d, 0x00, 0x08, 0x8e, 0x9b, 
	0x9b, 0xa5, 0xa5, 0xac, 0x1d, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x06, 0x04, 0x06, 0x00, 0x06, 
	0x83, 0x06, 0xcb, 0xc7, 0x8e, 0xc8, 0xc8, 0xa5, 0xa5, 
	0x06, 0x08, 0x02, 0x01, 0x15, 0x18, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x9b, 0x9b, 0x9b, 
	0x89, 0x9a, 0xae, 0x9b, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x19, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x1a, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 
	0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 
	0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 
	0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 
	0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 
	0xa5, 0xac, 0xac, 0x18, 0x1a, 0x18, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x19, 0x00, 0x08, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x19, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x18, 0x1a, 0x18, 0x00, 
	0x07, 0x8e, 0x04, 0xc8, 0xc8, 0xc8, 0xa5, 0xac, 0xac, 
	0x18, 0x15, 0x02, 0x01, 0x09, 0x04, 0x0a, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0a, 0x04, 0x15, 0x04, 0x0a, 
	0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 
	0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 
	0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 0x05, 0x0f, 
	0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 0x05, 0x0f, 
	0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0a, 0x04, 0x15, 
	0x04, 0x0a, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0f, 
	0x05, 0x0f, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0f, 
	0x05, 0x0f, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0a, 
	0x04, 0x15, 0x04, 0x0a, 0x00, 0x08, 0xc8, 0xa5, 0xa5, 
	0xac, 0xac, 0x0a, 0x04, 0x09, 0x02, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0x56, 0x01, 
	0x00, 0x00 
};

// *************************************************************************
//									 LANDSCAPE
// *************************************************************************

// Toolbar

unsigned char item_toolbar_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0xe7, 0x63, 0x18, 
	0xe7, 0x5a, 0x18, 
	0xde, 0x52, 0x18, 
	0xde, 0x4a, 0x18, 
	0xde, 0x42, 0x10, 
	0x9c, 0x31, 0x10, 
	0xe7, 0x39, 0x18, 
	0x94, 0x21, 0x10, 
	0x52, 0x21, 0x08, 
	0xf7, 0x84, 0x18, 
	0xef, 0x7b, 0x10, 
	0xde, 0x39, 0x10, 
	0xd6, 0x31, 0x10, 
	0xad, 0x29, 0x10, 
	0x42, 0x10, 0x00, 
	0x4a, 0x18, 0x00, 
	0xde, 0x5a, 0x08, 
	0xce, 0x6b, 0x10, 
	0xe7, 0x6b, 0x10, 
	0xd6, 0x6b, 0x18, 
	0xef, 0x5a, 0x18, 
	0xce, 0x42, 0x10, 
	0xa5, 0x31, 0x10, 
	0x8c, 0x31, 0x08, 
	0xd6, 0x4a, 0x10, 
	0xbd, 0x39, 0x10, 
	0xad, 0x42, 0x10, 
	0xce, 0x31, 0x10, 
	0xb5, 0x29, 0x10, 
	0x8c, 0x21, 0x08, 
	0x31, 0x08, 0x00, 
	0xde, 0x6b, 0x10, 
	0xce, 0x5a, 0x08, 
	0xad, 0x4a, 0x08, 
	0xc6, 0x5a, 0x08, 
	0xb5, 0x52, 0x08, 
	0xde, 0x6b, 0x08, 
	0xe7, 0x63, 0x10, 
	0xa5, 0x5a, 0x10, 
	0xc6, 0x6b, 0x18, 
	0xff, 0x52, 0x18, 
	0xf7, 0x42, 0x18, 
	0xef, 0x39, 0x18, 
	0x7b, 0x21, 0x08, 
	0x5a, 0x18, 0x08, 
	0xc6, 0x31, 0x18, 
	0x42, 0x18, 0x00, 
	0xde, 0x63, 0x08, 
	0xd6, 0x5a, 0x08, 
	0xce, 0x52, 0x08, 
	0x5a, 0x29, 0x00, 
	0xce, 0x63, 0x08, 
	0xd6, 0x52, 0x08, 
	0xbd, 0x4a, 0x08, 
	0x63, 0x29, 0x00, 
	0xef, 0x6b, 0x10, 
	0x7b, 0x42, 0x08, 
	0xe7, 0x7b, 0x21, 
	0xad, 0x5a, 0x18, 
	0xff, 0x4a, 0x18, 
	0xff, 0x42, 0x18, 
	0xbd, 0x31, 0x10, 
	0x9c, 0x29, 0x10, 
	0x6b, 0x18, 0x08, 
	0x73, 0x21, 0x08, 
	0xff, 0x63, 0x18, 
	0xc6, 0x31, 0x10, 
	0xa5, 0x29, 0x10, 
	0x84, 0x21, 0x08, 
	0x6b, 0x21, 0x08, 
	0xe7, 0x63, 0x08, 
	0xf7, 0x63, 0x08, 
	0xef, 0x63, 0x08, 
	0xe7, 0x5a, 0x08, 
	0x8c, 0x39, 0x08, 
	0x31, 0x10, 0x00, 
	0x7b, 0x31, 0x00, 
	0x39, 0x18, 0x00, 
	0xef, 0x63, 0x10, 
	0xe7, 0x73, 0x10, 
	0xef, 0x73, 0x18, 
	0xe7, 0x7b, 0x29, 
	0xd6, 0x39, 0x10, 
	0x73, 0x18, 0x08, 
	0x52, 0x18, 0x08, 
	0xc6, 0x42, 0x10, 
	0xb5, 0x4a, 0x08, 
	0xc6, 0x5a, 0x10, 
	0xbd, 0x5a, 0x10, 
	0xc6, 0x63, 0x10, 
	0xc6, 0x4a, 0x08, 
	0x52, 0x21, 0x00, 
	0x29, 0x10, 0x00, 
	0xad, 0x42, 0x08, 
	0x4a, 0x21, 0x00, 
	0xf7, 0x73, 0x18, 
	0xff, 0x84, 0x29, 
	0xde, 0x73, 0x29, 
	0xff, 0x5a, 0x18, 
	0xb5, 0x31, 0x10, 
	0xef, 0x42, 0x18, 
	0x52, 0x10, 0x08, 
	0x4a, 0x10, 0x08, 
	0x8c, 0x29, 0x10, 
	0xd6, 0x52, 0x18, 
	0x84, 0x31, 0x00, 
	0x6b, 0x31, 0x00, 
	0xa5, 0x42, 0x08, 
	0x9c, 0x42, 0x08, 
	0xd6, 0x73, 0x10, 
	0x73, 0x29, 0x00, 
	0x7b, 0x39, 0x08, 
	0xff, 0x73, 0x10, 
	0xc6, 0x52, 0x08, 
	0xf7, 0x7b, 0x21, 
	0xff, 0x8c, 0x31, 
	0xc6, 0x6b, 0x21, 
	0x52, 0x29, 0x00, 
	0x63, 0x18, 0x08, 
	0x39, 0x10, 0x00, 
	0xef, 0x5a, 0x08, 
	0x84, 0x39, 0x00, 
	0x5a, 0x21, 0x00, 
	0x73, 0x39, 0x08, 
	0x8c, 0x39, 0x00, 
	0xef, 0x73, 0x10, 
	0xa5, 0x52, 0x18, 
	0x4a, 0x29, 0x00, 
	0xff, 0x63, 0x08, 
	0xbd, 0x63, 0x10, 
	0xf7, 0x6b, 0x10, 
	0x42, 0x21, 0x00, 
	0xf7, 0x39, 0x18, 
	0xf7, 0x63, 0x18, 
	0x94, 0x39, 0x08, 
	0x6b, 0x29, 0x00, 
	0xff, 0x6b, 0x10, 
	0xce, 0x63, 0x18, 
	0x63, 0x21, 0x08, 
	0x73, 0x31, 0x00, 
	0x63, 0x31, 0x08, 
	0xa5, 0x4a, 0x08, 
	0xef, 0x4a, 0x18, 
	0xb5, 0x52, 0x10, 
	0xe7, 0x42, 0x18, 
	0x31, 0x18, 0x00, 
	0x84, 0x42, 0x08, 
	0xd6, 0x6b, 0x21, 
	0x94, 0x31, 0x10, 
	0x73, 0x29, 0x08, 
	0x8c, 0x42, 0x08, 
	0xbd, 0x52, 0x08, 
	0xbd, 0x5a, 0x18, 
	0x7b, 0x29, 0x00, 
	0xde, 0x73, 0x21, 
	0x9c, 0x21, 0x10, 
	0x9c, 0x4a, 0x10, 
	0xef, 0x7b, 0x29, 
	0xe7, 0x42, 0x21, 
	0xd6, 0x42, 0x10, 
	0xce, 0x42, 0x21, 
	0x94, 0x29, 0x18, 
	0xce, 0x39, 0x10, 
	0x63, 0x21, 0x00, 
	0xe7, 0x52, 0x18, 
	0xe7, 0x4a, 0x18, 
	0xa5, 0x42, 0x10, 
	0x94, 0x39, 0x00, 
	0xc6, 0x39, 0x10, 
	0x9c, 0x4a, 0x08, 
	0x52, 0x31, 0x00

};
unsigned char item_toolbar[] = { 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0x71, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 
	0x00, 0xff, 0x01, 0x00, 0x3b, 0x01, 0x00, 0x04, 0x08, 
	0x09, 0x0a, 0x00, 0x46, 0x01, 0x0b, 0x0c, 0x0b, 0x00, 
	0xf1, 0x01, 0x08, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x00, 
	0x36, 0x01, 0x12, 0x13, 0x00, 0x0e, 0x01, 0x14, 0x12, 
	0x15, 0x00, 0xc6, 0x01, 0x16, 0x17, 0x18, 0x19, 0x00, 
	0x1e, 0x01, 0x04, 0x1a, 0x17, 0x1b, 0x1c, 0x00, 0x04, 
	0x01, 0x08, 0x1d, 0x1e, 0x1f, 0x20, 0x11, 0x00, 0x1d, 
	0x01, 0x21, 0x22, 0x22, 0x23, 0x01, 0x01, 0x00, 0x04, 
	0x24, 0x25, 0x00, 0x0d, 0x01, 0x26, 0x27, 0x28, 0x00, 
	0x0d, 0x01, 0x0c, 0x12, 0x02, 0x29, 0x00, 0xc4, 0x01, 
	0x2a, 0x2b, 0x2c, 0x1d, 0x0f, 0x2d, 0x2e, 0x00, 0x1b, 
	0x01, 0x2b, 0x2c, 0x08, 0x08, 0x0d, 0x2f, 0x0f, 0x2d, 
	0x01, 0x01, 0x01, 0x08, 0x2f, 0x0f, 0x1f, 0x20, 0x30, 
	0x00, 0x1b, 0x01, 0x31, 0x32, 0x12, 0x12, 0x33, 0x34, 
	0x01, 0x35, 0x32, 0x36, 0x36, 0x37, 0x38, 0x00, 0x0d, 
	0x01, 0x12, 0x39, 0x3a, 0x00, 0x0d, 0x01, 0x31, 0x27, 
	0x3b, 0x3c, 0x00, 0xc3, 0x01, 0x3d, 0x3e, 0x2c, 0x08, 
	0x3f, 0x40, 0x1f, 0x41, 0x42, 0x00, 0x18, 0x01, 0x43, 
	0x3e, 0x2b, 0x2c, 0x08, 0x0d, 0x0e, 0x44, 0x45, 0x46, 
	0x47, 0x01, 0x01, 0x08, 0x1d, 0x0f, 0x1f, 0x20, 0x30, 
	0x00, 0x08, 0x01, 0x22, 0x25, 0x00, 0x10, 0x01, 0x48, 
	0x49, 0x4a, 0x4b, 0x12, 0x4c, 0x4d, 0x01, 0x35, 0x12, 
	0x12, 0x33, 0x4e, 0x4f, 0x00, 0x0c, 0x01, 0x31, 0x50, 
	0x27, 0x34, 0x00, 0x0c, 0x01, 0x51, 0x12, 0x52, 0x53, 
	0x00, 0xc3, 0x01, 0x2a, 0x2b, 0x54, 0x3f, 0x3f, 0x0f, 
	0x1f, 0x2d, 0x55, 0x2d, 0x00, 0x18, 0x01, 0x3e, 0x2c, 
	0x1d, 0x3f, 0x1e, 0x1e, 0x1e, 0x0f, 0x09, 0x41, 0x2e, 
	0x01, 0x01, 0x08, 0x1d, 0x0f, 0x46, 0x20, 0x56, 0x1b, 
	0x57, 0x1b, 0x01, 0x01, 0x01, 0x48, 0x4a, 0x12, 0x58, 
	0x4c, 0x00, 0x06, 0x01, 0x21, 0x35, 0x59, 0x24, 0x5a, 
	0x5b, 0x01, 0x01, 0x14, 0x4a, 0x49, 0x4b, 0x5c, 0x23, 
	0x5d, 0x5e, 0x01, 0x35, 0x12, 0x12, 0x5f, 0x5d, 0x60, 
	0x00, 0x0b, 0x01, 0x51, 0x4b, 0x61, 0x59, 0x5d, 0x23, 
	0x00, 0x0a, 0x01, 0x0b, 0x12, 0x02, 0x62, 0x63, 0x00, 
	0xbb, 0x01, 0x64, 0x3d, 0x08, 0x0e, 0x3f, 0x09, 0x01, 
	0x01, 0x2b, 0x0e, 0x3f, 0x3f, 0x3f, 0x65, 0x09, 0x41, 
	0x41, 0x2d, 0x07, 0x01, 0x01, 0x01, 0x3d, 0x66, 0x2c, 
	0x08, 0x0e, 0x65, 0x09, 0x18, 0x00, 0x04, 0x08, 0x2c, 
	0x3f, 0x42, 0x00, 0x04, 0x01, 0x2a, 0x2b, 0x2f, 0x1e, 
	0x1e, 0x00, 0x04, 0x0f, 0x40, 0x67, 0x68, 0x69, 0x6a, 
	0x08, 0x1d, 0x0f, 0x1f, 0x68, 0x0f, 0x0d, 0x0e, 0x46, 
	0x01, 0x0c, 0x4a, 0x49, 0x4a, 0x12, 0x5f, 0x6b, 0x6c, 
	0x01, 0x01, 0x01, 0x0c, 0x48, 0x4b, 0x32, 0x36, 0x33, 
	0x5c, 0x6d, 0x6e, 0x6f, 0x31, 0x4b, 0x4a, 0x37, 0x6d, 
	0x6e, 0x5d, 0x5e, 0x01, 0x22, 0x12, 0x12, 0x6d, 0x5d, 
	0x70, 0x71, 0x00, 0x0a, 0x01, 0x12, 0x39, 0x72, 0x23, 
	0x60, 0x73, 0x00, 0x0a, 0x01, 0x27, 0x12, 0x74, 0x75, 
	0x76, 0x77, 0x00, 0xb9, 0x01, 0x3e, 0x3e, 0x2c, 0x0d, 
	0x1d, 0x3f, 0x0f, 0x09, 0x54, 0x08, 0x00, 0x05, 0x3f, 
	0x45, 0x55, 0x78, 0x41, 0x69, 0x01, 0x2a, 0x3e, 0x2b, 
	0x08, 0x08, 0x0d, 0x1d, 0x1e, 0x40, 0x0f, 0x08, 0x2c, 
	0x08, 0x08, 0x0f, 0x2e, 0x41, 0x00, 0x04, 0x01, 0x2b, 
	0x08, 0x1e, 0x1e, 0x0f, 0x46, 0x41, 0x45, 0x0f, 0x45, 
	0x67, 0x1f, 0x1d, 0x08, 0x08, 0x1d, 0x0f, 0x40, 0x45, 
	0x0e, 0x1d, 0x1f, 0x79, 0x6d, 0x49, 0x49, 0x7a, 0x33, 
	0x5f, 0x6e, 0x4e, 0x38, 0x6c, 0x01, 0x01, 0x4a, 0x49, 
	0x4a, 0x12, 0x33, 0x33, 0x37, 0x6d, 0x7b, 0x7b, 0x25, 
	0x33, 0x73, 0x6d, 0x6d, 0x6e, 0x7c, 0x5e, 0x01, 0x22, 
	0x12, 0x12, 0x6d, 0x5d, 0x7b, 0x4c, 0x7d, 0x00, 0x08, 
	0x01, 0x21, 0x27, 0x72, 0x61, 0x4c, 0x30, 0x12, 0x7e, 
	0x00, 0x08, 0x01, 0x7f, 0x12, 0x52, 0x75, 0x75, 0x80, 
	0x81, 0x00, 0xb8, 0x01, 0x3e, 0x2b, 0x54, 0x2f, 0x44, 
	0x3f, 0x0f, 0x45, 0x45, 0x0d, 0x0e, 0x00, 0x05, 0x3f, 
	0x1e, 0x2d, 0x78, 0x78, 0x09, 0x54, 0x3e, 0x2c, 0x1d, 
	0x2f, 0x3f, 0x3f, 0x3f, 0x45, 0x1f, 0x09, 0x0e, 0x2f, 
	0x44, 0x65, 0x41, 0x68, 0x41, 0x00, 0x04, 0x01, 0x2c, 
	0x1d, 0x1e, 0x1e, 0x40, 0x2e, 0x42, 0x1e, 0x1e, 0x0f, 
	0x55, 0x2f, 0x54, 0x08, 0x2c, 0x1d, 0x0f, 0x0f, 0x1e, 
	0x1e, 0x0f, 0x67, 0x79, 0x37, 0x82, 0x4b, 0x37, 0x6d, 
	0x6e, 0x6d, 0x4c, 0x7c, 0x7c, 0x83, 0x4a, 0x49, 0x49, 
	0x32, 0x58, 0x5f, 0x5f, 0x6d, 0x6e, 0x4e, 0x38, 0x71, 
	0x5f, 0x5f, 0x6d, 0x6d, 0x6e, 0x7c, 0x5e, 0x01, 0x33, 
	0x12, 0x36, 0x6d, 0x5d, 0x7e, 0x5f, 0x38, 0x00, 0x08, 
	0x01, 0x12, 0x84, 0x72, 0x39, 0x6c, 0x30, 0x12, 0x37, 
	0x34, 0x00, 0x07, 0x01, 0x31, 0x27, 0x62, 0x75, 0x75, 
	0x71, 0x85, 0x00, 0xb8, 0x01, 0x08, 0x2f, 0x00, 0x04, 
	0x3f, 0x1e, 0x45, 0x45, 0x1d, 0x2f, 0x00, 0x04, 0x3f, 
	0x65, 0x65, 0x09, 0x2e, 0x2e, 0x40, 0x86, 0x2c, 0x2f, 
	0x00, 0x04, 0x65, 0x1e, 0x0f, 0x2d, 0x55, 0x44, 0x3f, 
	0x65, 0x0f, 0x78, 0x68, 0x55, 0x01, 0x01, 0x01, 0x87, 
	0x08, 0x3f, 0x1e, 0x0f, 0x46, 0x68, 0x1f, 0x1d, 0x1e, 
	0x0f, 0x2d, 0x2f, 0x3f, 0x3f, 0x1e, 0x00, 0x06, 0x0f, 
	0x2e, 0x56, 0x36, 0x4b, 0x58, 0x6d, 0x88, 0x4e, 0x37, 
	0x6d, 0x89, 0x30, 0x7b, 0x4a, 0x49, 0x36, 0x00, 0x06, 
	0x6d, 0x7e, 0x60, 0x5d, 0x37, 0x36, 0x73, 0x6d, 0x6e, 
	0x38, 0x5e, 0x01, 0x33, 0x12, 0x36, 0x6d, 0x5d, 0x7e, 
	0x33, 0x4e, 0x38, 0x00, 0x06, 0x01, 0x12, 0x50, 0x8a, 
	0x61, 0x73, 0x38, 0x30, 0x12, 0x12, 0x70, 0x7c, 0x00, 
	0x05, 0x01, 0x14, 0x12, 0x74, 0x75, 0x75, 0x8b, 0x89, 
	0x85, 0x00, 0xb8, 0x01, 0x44, 0x00, 0x06, 0x3f, 0x1e, 
	0x45, 0x3f, 0x44, 0x00, 0x04, 0x3f, 0x65, 0x65, 0x45, 
	0x2e, 0x2e, 0x45, 0x2b, 0x1d, 0x65, 0x65, 0x45, 0x46, 
	0x40, 0x1e, 0x1e, 0x46, 0x78, 0x1e, 0x3f, 0x65, 0x0f, 
	0x2e, 0x68, 0x2d, 0x01, 0x01, 0x01, 0x16, 0x08, 0x3f, 
	0x1e, 0x0f, 0x78, 0x68, 0x45, 0x08, 0x65, 0x0f, 0x2d, 
	0x3f, 0x00, 0x09, 0x0f, 0x78, 0x8c, 0x12, 0x5c, 0x6d, 
	0x6d, 0x8d, 0x88, 0x37, 0x6d, 0x8d, 0x4f, 0x4e, 0x4a, 
	0x4b, 0x5f, 0x6d, 0x6d, 0x6b, 0x4e, 0x6e, 0x6d, 0x6e, 
	0x30, 0x4f, 0x73, 0x7a, 0x33, 0x6d, 0x6e, 0x38, 0x5e, 
	0x01, 0x33, 0x12, 0x33, 0x6d, 0x5d, 0x88, 0x36, 0x88, 
	0x38, 0x8e, 0x00, 0x04, 0x01, 0x51, 0x48, 0x84, 0x8a, 
	0x27, 0x6d, 0x38, 0x30, 0x12, 0x12, 0x88, 0x38, 0x6c, 
	0x00, 0x04, 0x01, 0x12, 0x14, 0x62, 0x75, 0x53, 0x8f, 
	0x89, 0x85, 0x00, 0xb8, 0x01, 0x00, 0x08, 0x3f, 0x0f, 
	0x45, 0x3f, 0x3f, 0x3f, 0x00, 0x04, 0x65, 0x0f, 0x78, 
	0x2e, 0x1e, 0x08, 0x3f, 0x65, 0x65, 0x09, 0x2e, 0x1f, 
	0x1e, 0x65, 0x09, 0x2e, 0x0f, 0x3f, 0x65, 0x0f, 0x2e, 
	0x68, 0x2d, 0x01, 0x01, 0x01, 0x90, 0x08, 0x65, 0x1e, 
	0x45, 0x68, 0x68, 0x3f, 0x08, 0x65, 0x0f, 0x2d, 0x3f, 
	0x00, 0x09, 0x0f, 0x41, 0x47, 0x32, 0x6d, 0x6d, 0x88, 
	0x7c, 0x58, 0x37, 0x6d, 0x4e, 0x4d, 0x4c, 0x4a, 0x73, 
	0x6d, 0x6d, 0x6d, 0x5d, 0x89, 0x6d, 0x6d, 0x6d, 0x60, 
	0x4d, 0x33, 0x4b, 0x37, 0x6d, 0x6e, 0x89, 0x5e, 0x01, 
	0x33, 0x12, 0x33, 0x6e, 0x5d, 0x6e, 0x36, 0x6d, 0x6b, 
	0x38, 0x7d, 0x01, 0x01, 0x01, 0x12, 0x84, 0x8a, 0x39, 
	0x58, 0x6e, 0x38, 0x30, 0x12, 0x12, 0x6e, 0x6b, 0x7c, 
	0x7d, 0x01, 0x01, 0x31, 0x27, 0x74, 0x75, 0x75, 0x91, 
	0x88, 0x89, 0x4f, 0x00, 0xb8, 0x01, 0x00, 0x05, 0x3f, 
	0x65, 0x3f, 0x3f, 0x65, 0x45, 0x65, 0x3f, 0x00, 0x05, 
	0x65, 0x1e, 0x55, 0x2e, 0x3f, 0x0d, 0x65, 0x65, 0x1e, 
	0x09, 0x2e, 0x1f, 0x3f, 0x65, 0x45, 0x2e, 0x45, 0x3f, 
	0x65, 0x45, 0x67, 0x68, 0x46, 0x01, 0x01, 0x01, 0x92, 
	0x0d, 0x65, 0x1e, 0x09, 0x10, 0x10, 0x0e, 0x08, 0x1e, 
	0x0f, 0x2d, 0x3f, 0x00, 0x09, 0x0f, 0x55, 0x47, 0x33, 
	0x6d, 0x6d, 0x6b, 0x5d, 0x33, 0x37, 0x6d, 0x4e, 0x4d, 
	0x5f, 0x4a, 0x58, 0x6d, 0x6d, 0x6e, 0x60, 0x8d, 0x5c, 
	0x6d, 0x6d, 0x5d, 0x93, 0x33, 0x4b, 0x23, 0x6d, 0x6e, 
	0x70, 0x5e, 0x01, 0x36, 0x12, 0x33, 0x6e, 0x5d, 0x6e, 
	0x33, 0x6d, 0x6e, 0x4e, 0x38, 0x94, 0x01, 0x31, 0x27, 
	0x8a, 0x8a, 0x22, 0x6e, 0x6e, 0x89, 0x30, 0x12, 0x12, 
	0x6e, 0x6e, 0x8d, 0x7c, 0x94, 0x21, 0x12, 0x52, 0x62, 
	0x75, 0x95, 0x6e, 0x88, 0x70, 0x4f, 0x00, 0xb8, 0x01, 
	0x3f, 0x3f, 0x0f, 0x46, 0x78, 0x67, 0x2d, 0x1e, 0x65, 
	0x0f, 0x1e, 0x65, 0x65, 0x65, 0x0f, 0x2d, 0x1f, 0x1e, 
	0x46, 0x2e, 0x65, 0x1d, 0x65, 0x65, 0x1e, 0x09, 0x2e, 
	0x1f, 0x2f, 0x65, 0x0f, 0x56, 0x45, 0x3f, 0x1e, 0x45, 
	0x68, 0x68, 0x40, 0x44, 0x09, 0x96, 0x08, 0x54, 0x1e, 
	0x0f, 0x46, 0x10, 0x68, 0x08, 0x0d, 0x1e, 0x45, 0x2d, 
	0x2f, 0x00, 0x09, 0x0f, 0x2d, 0x97, 0x5c, 0x6d, 0x6d, 
	0x4e, 0x7c, 0x36, 0x58, 0x6d, 0x8d, 0x4d, 0x58, 0x12, 
	0x6d, 0x6d, 0x6d, 0x6e, 0x30, 0x4e, 0x36, 0x5f, 0x6d, 
	0x7c, 0x30, 0x36, 0x12, 0x5f, 0x6d, 0x6e, 0x8d, 0x5e, 
	0x01, 0x36, 0x12, 0x73, 0x6e, 0x5d, 0x6d, 0x33, 0x6d, 
	0x6e, 0x88, 0x89, 0x38, 0x98, 0x12, 0x84, 0x8a, 0x50, 
	0x6d, 0x6e, 0x6e, 0x89, 0x30, 0x12, 0x32, 0x6e, 0x6e, 
	0x88, 0x89, 0x34, 0x88, 0x27, 0x62, 0x62, 0x53, 0x23, 
	0x88, 0x88, 0x70, 0x93, 0x00, 0xb8, 0x01, 0x3f, 0x3f, 
	0x40, 0x78, 0x67, 0x68, 0x2d, 0x65, 0x65, 0x1e, 0x1e, 
	0x65, 0x65, 0x65, 0x09, 0x78, 0x40, 0x65, 0x09, 0x78, 
	0x1e, 0x2f, 0x65, 0x65, 0x1e, 0x1f, 0x2e, 0x46, 0x1d, 
	0x65, 0x45, 0x2e, 0x45, 0x3f, 0x1e, 0x45, 0x68, 0x67, 
	0x54, 0x54, 0x3f, 0x3f, 0x08, 0x1d, 0x1e, 0x0f, 0x46, 
	0x10, 0x2e, 0x08, 0x0e, 0x1e, 0x09, 0x46, 0x2f, 0x00, 
	0x09, 0x0f, 0x1f, 0x97, 0x37, 0x6d, 0x6d, 0x4c, 0x89, 
	0x33, 0x6e, 0x4c, 0x38, 0x4d, 0x73, 0x33, 0x6d, 0x6d, 
	0x6d, 0x88, 0x30, 0x4e, 0x36, 0x5f, 0x6e, 0x5d, 0x38, 
	0x36, 0x33, 0x6d, 0x6d, 0x6e, 0x4e, 0x5e, 0x01, 0x36, 
	0x12, 0x5c, 0x6e, 0x60, 0x6d, 0x33, 0x6d, 0x6e, 0x6e, 
	0x88, 0x89, 0x38, 0x37, 0x8a, 0x84, 0x99, 0x6e, 0x6e, 
	0x6e, 0x8d, 0x11, 0x12, 0x36, 0x6e, 0x6e, 0x6e, 0x7e, 
	0x38, 0x38, 0x95, 0x62, 0x62, 0x9a, 0x88, 0x88, 0x88, 
	0x8d, 0x93, 0x00, 0xb8, 0x01, 0x3f, 0x3f, 0x40, 0x41, 
	0x41, 0x09, 0x0d, 0x44, 0x3f, 0x1e, 0x00, 0x04, 0x65, 
	0x46, 0x78, 0x40, 0x3f, 0x40, 0x78, 0x1e, 0x44, 0x65, 
	0x65, 0x1e, 0x1f, 0x56, 0x46, 0x1d, 0x45, 0x2d, 0x78, 
	0x0f, 0x44, 0x1e, 0x40, 0x68, 0x2d, 0x2b, 0x54, 0x1e, 
	0x0f, 0x1d, 0x1d, 0x0f, 0x0f, 0x09, 0x68, 0x40, 0x08, 
	0x1d, 0x0f, 0x46, 0x1f, 0x2f, 0x00, 0x07, 0x0f, 0x45, 
	0x40, 0x2d, 0x9b, 0x58, 0x6d, 0x6d, 0x6e, 0x4e, 0x4e, 
	0x60, 0x30, 0x30, 0x30, 0x36, 0x73, 0x6d, 0x6d, 0x6d, 
	0x7e, 0x4f, 0x6b, 0x36, 0x5f, 0x4e, 0x60, 0x6b, 0x36, 
	0x5c, 0x6d, 0x6e, 0x6e, 0x4e, 0x4d, 0x01, 0x36, 0x12, 
	0x37, 0x88, 0x11, 0x58, 0x33, 0x00, 0x04, 0x6e, 0x7b, 
	0x38, 0x6d, 0x84, 0x12, 0x6d, 0x6e, 0x6e, 0x6e, 0x8d, 
	0x11, 0x32, 0x33, 0x00, 0x04, 0x6e, 0x6b, 0x34, 0x9a, 
	0x62, 0x9c, 0x6e, 0x88, 0x88, 0x88, 0x4e, 0x4d, 0x00, 
	0xb8, 0x01, 0x44, 0x3f, 0x40, 0x41, 0x41, 0x0f, 0x2c, 
	0x54, 0x65, 0x0f, 0x1e, 0x65, 0x65, 0x1e, 0x2d, 0x78, 
	0x45, 0x2f, 0x45, 0x41, 0x0f, 0x3f, 0x65, 0x65, 0x1e, 
	0x46, 0x56, 0x46, 0x44, 0x41, 0x2e, 0x42, 0x44, 0x44, 
	0x1e, 0x9d, 0x67, 0x3f, 0x2c, 0x3f, 0x2d, 0x41, 0x2f, 
	0x2f, 0x0f, 0x0f, 0x40, 0x40, 0x54, 0x08, 0x2f, 0x0f, 
	0x42, 0x69, 0x2f, 0x0f, 0x0f, 0x45, 0x45, 0x0f, 0x45, 
	0x42, 0x2e, 0x68, 0x56, 0x58, 0x58, 0x6d, 0x6d, 0x6d, 
	0x7e, 0x38, 0x7c, 0x60, 0x7d, 0x99, 0x4b, 0x37, 0x6d, 
	0x6d, 0x6d, 0x6b, 0x4f, 0x4c, 0x36, 0x8d, 0x60, 0x6c, 
	0x58, 0x32, 0x5c, 0x6d, 0x6e, 0x6e, 0x4e, 0x4d, 0x01, 
	0x36, 0x12, 0x37, 0x4e, 0x5d, 0x73, 0x73, 0x00, 0x05, 
	0x6e, 0x6b, 0x88, 0x27, 0x23, 0x00, 0x04, 0x6e, 0x4e, 
	0x60, 0x32, 0x73, 0x00, 0x04, 0x6e, 0x88, 0x4e, 0x9e, 
	0x9f, 0x23, 0x00, 0x04, 0x88, 0x4e, 0x4d, 0x00, 0xb8, 
	0x01, 0x44, 0x3f, 0x09, 0x41, 0x41, 0x0f, 0x0d, 0x3f, 
	0x65, 0x40, 0x0f, 0x65, 0x65, 0x0f, 0x55, 0x78, 0x0f, 
	0x2f, 0x0f, 0x55, 0x0f, 0x3f, 0x65, 0x65, 0x1e, 0x46, 
	0x56, 0x46, 0x45, 0x2e, 0x8c, 0x01, 0x54, 0x44, 0x1e, 
	0x09, 0x41, 0x08, 0x44, 0x1f, 0x78, 0x45, 0x08, 0x44, 
	0x0f, 0x0f, 0x0f, 0x1e, 0x3f, 0x3f, 0x1e, 0x0f, 0x41, 
	0x09, 0x1e, 0x46, 0x41, 0x78, 0x0f, 0x0f, 0x09, 0x79, 
	0x10, 0x01, 0x6d, 0x33, 0x58, 0x00, 0x04, 0x6d, 0x4e, 
	0x89, 0x89, 0x4c, 0x32, 0x12, 0x58, 0x6d, 0x6d, 0x6d, 
	0x4e, 0x4f, 0x4c, 0x5f, 0x5d, 0x01, 0x01, 0x22, 0x32, 
	0x73, 0x6d, 0x6e, 0x6e, 0x6b, 0x4d, 0x01, 0x36, 0x12, 
	0x37, 0x38, 0x38, 0x33, 0x73, 0x00, 0x05, 0x6e, 0x88, 
	0x6e, 0x99, 0x00, 0x05, 0x6e, 0x4e, 0x60, 0x36, 0x5c, 
	0x00, 0x04, 0x6e, 0x88, 0x88, 0x98, 0x8b, 0x6e, 0x00, 
	0x04, 0x88, 0x4e, 0x5e, 0x00, 0xb8, 0x01, 0x44, 0x65, 
	0x40, 0x41, 0x69, 0xa0, 0x54, 0x65, 0x1e, 0x46, 0x0f, 
	0x65, 0x65, 0x45, 0x41, 0x78, 0x1e, 0x44, 0x1e, 0x46, 
	0x45, 0x3f, 0x65, 0x65, 0x1e, 0x2d, 0x56, 0x42, 0x2d, 
	0x01, 0x01, 0x01, 0x0d, 0x44, 0x1e, 0x09, 0x45, 0x1d, 
	0x09, 0x55, 0x07, 0xa1, 0x08, 0x3f, 0x0f, 0x0f, 0x0f, 
	0x45, 0x45, 0x45, 0x0f, 0x45, 0x2e, 0x2d, 0x68, 0x10, 
	0x56, 0x0f, 0x1d, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 
	0x58, 0x5f, 0x00, 0x04, 0x6d, 0x6e, 0x4e, 0x89, 0x6b, 
	0x33, 0x12, 0x23, 0x6d, 0x6d, 0x6d, 0x70, 0x4d, 0x6b, 
	0x71, 0x01, 0x01, 0x01, 0x22, 0x32, 0x5c, 0x6d, 0x6e, 
	0x6e, 0x6b, 0x4f, 0x01, 0x36, 0x12, 0x58, 0x60, 0x70, 
	0x32, 0x5c, 0x00, 0x0d, 0x6e, 0x6b, 0x60, 0x36, 0x37, 
	0x00, 0x05, 0x6e, 0x88, 0x88, 0x6e, 0x00, 0x05, 0x88, 
	0x6b, 0x4d, 0x00, 0xb8, 0x01, 0x44, 0x65, 0x40, 0x41, 
	0xa2, 0x2b, 0x0d, 0x65, 0x0f, 0x55, 0x0f, 0x65, 0x65, 
	0x40, 0x78, 0x78, 0x1e, 0x44, 0x65, 0x1f, 0x45, 0x65, 
	0x65, 0x65, 0x0f, 0x2d, 0x56, 0x78, 0x69, 0x01, 0x01, 
	0x01, 0x0d, 0x44, 0x1e, 0x09, 0x3f, 0x45, 0x09, 0x1e, 
	0x40, 0x44, 0x0d, 0x65, 0x0f, 0x0f, 0x0f, 0x2d, 0x2e, 
	0x2e, 0x78, 0x78, 0x68, 0x68, 0x01, 0x01, 0x01, 0x0d, 
	0x1d, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x6d, 0x6e, 
	0x6e, 0x00, 0x04, 0x6d, 0x88, 0x70, 0x89, 0x73, 0x36, 
	0x5f, 0x6d, 0x6d, 0x6d, 0x89, 0x4d, 0x71, 0x00, 0x04, 
	0x01, 0x22, 0x32, 0x5c, 0x6d, 0x6e, 0x6e, 0x7b, 0x4f, 
	0x01, 0x36, 0x12, 0x5f, 0x30, 0x4e, 0x12, 0x37, 0x00, 
	0x0d, 0x6e, 0x6b, 0x60, 0x36, 0x58, 0x00, 0x04, 0x6e, 
	0x00, 0x09, 0x88, 0x6b, 0x4d, 0x00, 0xb8, 0x01, 0x44, 
	0x65, 0x40, 0xa3, 0x2b, 0x08, 0x3f, 0x65, 0x40, 0x78, 
	0x0f, 0x65, 0x65, 0x09, 0x2e, 0x78, 0x65, 0x44, 0x65, 
	0x09, 0x45, 0x65, 0x65, 0x65, 0x0f, 0x2d, 0x56, 0x41, 
	0x65, 0x01, 0x01, 0x01, 0x0d, 0x44, 0x1e, 0x0f, 0x1e, 
	0x45, 0x2f, 0x44, 0x0f, 0x65, 0x2f, 0x1e, 0x0f, 0x0f, 
	0x0f, 0x78, 0x68, 0x2d, 0x46, 0x2e, 0x68, 0x56, 0x01, 
	0x01, 0x01, 0x08, 0x44, 0x0f, 0x09, 0x79, 0x10, 0x01, 
	0x01, 0x01, 0x7b, 0x6b, 0x88, 0x00, 0x04, 0x6d, 0x7b, 
	0x7c, 0x6d, 0x33, 0x6d, 0x6d, 0x6d, 0x6e, 0x38, 0x4d, 
	0x00, 0x05, 0x01, 0x22, 0x32, 0x5c, 0x6d, 0x6e, 0x6e, 
	0x7e, 0x4f, 0x01, 0x36, 0x32, 0x6d, 0x30, 0x4e, 0x12, 
	0x37, 0x00, 0x0d, 0x6e, 0x7e, 0x60, 0x36, 0x58, 0x6e, 
	0x6e, 0x6e, 0x00, 0x0a, 0x88, 0x6b, 0x4d, 0x00, 0xb8, 
	0x01, 0x44, 0x65, 0x0f, 0x2f, 0x54, 0x3f, 0x65, 0x1e, 
	0x2d, 0x78, 0x45, 0x65, 0x65, 0x09, 0x2e, 0x41, 0x3f, 
	0x44, 0x65, 0x09, 0x09, 0x65, 0x65, 0x65, 0x0f, 0x42, 
	0x56, 0x41, 0x65, 0x01, 0x01, 0x01, 0x06, 0x44, 0x1e, 
	0x0f, 0x0f, 0x1e, 0x3f, 0x1e, 0x40, 0x40, 0x44, 0x1e, 
	0x0f, 0x0f, 0x40, 0x67, 0x2d, 0x54, 0x0d, 0x65, 0x40, 
	0x41, 0x01, 0x01, 0x01, 0x08, 0x44, 0x0f, 0x09, 0x79, 
	0x10, 0x01, 0x01, 0x01, 0x88, 0x4e, 0x4e, 0x88, 0x6d, 
	0x6d, 0x6d, 0x6e, 0x7c, 0x6b, 0x73, 0x6d, 0x6d, 0x6d, 
	0x6e, 0x7c, 0x93, 0x00, 0x05, 0x01, 0x22, 0x32, 0x73, 
	0x6d, 0x6e, 0x6e, 0x7e, 0x30, 0x01, 0x36, 0x32, 0x6d, 
	0x30, 0x6b, 0x12, 0x58, 0x00, 0x0a, 0x6e, 0x6d, 0x6d, 
	0x6e, 0x4c, 0x60, 0x36, 0x5f, 0x6e, 0x6e, 0x6e, 0x00, 
	0x07, 0x88, 0x6d, 0x6e, 0x88, 0x6b, 0x4f, 0x00, 0xb8, 
	0x01, 0x44, 0x3f, 0x65, 0x3f, 0x65, 0x65, 0x1e, 0x1f, 
	0x78, 0x41, 0x0f, 0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 
	0x44, 0x65, 0x40, 0x1f, 0x65, 0x1e, 0x1e, 0x0f, 0x55, 
	0x56, 0x55, 0x3f, 0x01, 0x01, 0x01, 0x54, 0x44, 0x00, 
	0x06, 0x0f, 0x09, 0x2d, 0x1e, 0x65, 0x0f, 0x0f, 0x2d, 
	0x2e, 0x3f, 0x2c, 0x54, 0x44, 0x1e, 0x1f, 0x8c, 0x01, 
	0x01, 0x08, 0x44, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 
	0x01, 0x33, 0x37, 0x6e, 0x6b, 0x4c, 0x6d, 0x6d, 0x6d, 
	0x89, 0x38, 0x73, 0x6d, 0x6d, 0x6d, 0x6e, 0x60, 0x4f, 
	0x00, 0x05, 0x01, 0x73, 0x32, 0x73, 0x6d, 0x6e, 0x6e, 
	0x4c, 0x30, 0x01, 0x36, 0x36, 0x6e, 0x30, 0x4c, 0x12, 
	0x58, 0x6e, 0x88, 0x00, 0x08, 0x6e, 0x5f, 0x6d, 0x6e, 
	0x88, 0x5d, 0x33, 0x5f, 0x6e, 0x00, 0x09, 0x88, 0x37, 
	0x88, 0x88, 0x6b, 0x4f, 0x00, 0xb8, 0x01, 0x2f, 0x3f, 
	0x65, 0x65, 0x1e, 0x0f, 0x46, 0x78, 0x78, 0x46, 0x44, 
	0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 0x44, 0x65, 0x69, 
	0x46, 0x65, 0x1e, 0x1e, 0x0f, 0x55, 0x56, 0x55, 0x65, 
	0x01, 0xa4, 0x1d, 0x54, 0x44, 0x0f, 0x0f, 0x2d, 0x46, 
	0x45, 0x0f, 0x45, 0x41, 0x09, 0x3f, 0x0f, 0x0f, 0x55, 
	0x56, 0x3f, 0x1d, 0x3f, 0x65, 0x40, 0x42, 0x41, 0x01, 
	0x16, 0x08, 0x3f, 0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 
	0x01, 0x36, 0x32, 0x36, 0x58, 0x4c, 0x88, 0x6d, 0x6d, 
	0x70, 0x60, 0x73, 0x5f, 0x6d, 0x6d, 0x88, 0x30, 0x4f, 
	0x01, 0x99, 0x58, 0x58, 0x58, 0x73, 0x36, 0x73, 0x6d, 
	0x6e, 0x6e, 0x88, 0x30, 0x01, 0x36, 0x36, 0x88, 0x30, 
	0x88, 0x12, 0x5f, 0x6e, 0x6b, 0x4c, 0x00, 0x07, 0x6e, 
	0x5c, 0x6d, 0x6e, 0x88, 0x5d, 0x33, 0x6d, 0x6e, 0x4e, 
	0x6e, 0x00, 0x06, 0x88, 0x6d, 0x73, 0x88, 0x88, 0x6b, 
	0x4f, 0x00, 0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x1e, 0x09, 
	0x41, 0x2e, 0x2e, 0x01, 0x01, 0x01, 0x3f, 0x65, 0x09, 
	0x78, 0x41, 0x1e, 0x2f, 0x1e, 0x46, 0x46, 0x65, 0x1e, 
	0x1e, 0x0f, 0x41, 0x56, 0x55, 0x65, 0x66, 0x08, 0x08, 
	0x0e, 0x44, 0x0f, 0x45, 0x56, 0x67, 0x2d, 0x45, 0x45, 
	0x41, 0x2d, 0x3f, 0x0f, 0x0f, 0x46, 0x67, 0x65, 0x3f, 
	0x0f, 0x0f, 0x09, 0x78, 0x67, 0x01, 0x16, 0x08, 0x3f, 
	0x0f, 0x09, 0x79, 0x10, 0x01, 0x01, 0x01, 0x36, 0x73, 
	0x5c, 0x58, 0x6b, 0x4c, 0x6d, 0x6d, 0x70, 0x60, 0x73, 
	0x5f, 0x6d, 0x6d, 0x88, 0x4f, 0x4f, 0x35, 0x12, 0x36, 
	0x36, 0x37, 0x6e, 0x33, 0x73, 0x6d, 0x6e, 0x6e, 0x88, 
	0x11, 0x01, 0x36, 0x36, 0x4c, 0x30, 0x6e, 0x12, 0x5f, 
	0x6e, 0x8d, 0x6b, 0x00, 0x06, 0x6e, 0x6d, 0x73, 0x6d, 
	0x6e, 0x88, 0x5d, 0x33, 0x6d, 0x88, 0x38, 0x6e, 0x6e, 
	0x00, 0x05, 0x88, 0x58, 0x33, 0x88, 0x88, 0x6b, 0x4f, 
	0x00, 0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x1e, 0x46, 0x41, 
	0x41, 0x00, 0x04, 0x01, 0x44, 0x65, 0x09, 0x78, 0x41, 
	0x1e, 0x2f, 0x1e, 0x2d, 0x46, 0x65, 0x1e, 0x1e, 0x0f, 
	0x55, 0x56, 0x41, 0x2f, 0x2c, 0x08, 0x40, 0x09, 0x2f, 
	0x0f, 0x45, 0x56, 0x56, 0x0f, 0x3f, 0x0f, 0x55, 0x78, 
	0x1e, 0x0f, 0x0f, 0x40, 0x68, 0x0f, 0x3f, 0x0f, 0x0f, 
	0x40, 0x68, 0x79, 0x01, 0x03, 0x08, 0x65, 0x0f, 0x09, 
	0x79, 0x10, 0x01, 0x01, 0x01, 0x36, 0x58, 0x6d, 0x6e, 
	0x38, 0x7e, 0x37, 0x6d, 0x89, 0x60, 0x33, 0x5f, 0x6d, 
	0x6d, 0x88, 0x30, 0x4f, 0x73, 0x4a, 0x12, 0x5c, 0xa5, 
	0x4e, 0x36, 0x73, 0x6d, 0x6e, 0x6e, 0x88, 0x60, 0x01, 
	0x36, 0x33, 0x4c, 0x30, 0x6d, 0x12, 0x5f, 0x6e, 0x38, 
	0x70, 0x00, 0x05, 0x6e, 0x88, 0x6d, 0x33, 0x6e, 0x6e, 
	0x88, 0x7c, 0x73, 0x6d, 0x88, 0x60, 0x88, 0x6e, 0x00, 
	0x05, 0x88, 0x73, 0x73, 0x88, 0x88, 0x4c, 0x30, 0x00, 
	0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x1e, 0x09, 0x41, 0x41, 
	0x00, 0x04, 0x01, 0x3f, 0x65, 0x09, 0x78, 0x41, 0x1e, 
	0x2f, 0x0f, 0x55, 0x2d, 0x1e, 0x1e, 0x1e, 0x0f, 0x2d, 
	0x2e, 0x41, 0x0e, 0x08, 0x1e, 0x56, 0x09, 0x2f, 0x0f, 
	0x45, 0x56, 0x56, 0x44, 0x44, 0x0f, 0x2d, 0x56, 0x40, 
	0x0f, 0x0f, 0x45, 0x68, 0x1e, 0x3f, 0x0f, 0x0f, 0x40, 
	0x68, 0x68, 0x01, 0xa6, 0x08, 0x65, 0x0f, 0x09, 0x10, 
	0x10, 0x01, 0x01, 0x01, 0x36, 0x58, 0x6d, 0x6d, 0x38, 
	0x7e, 0x37, 0x6e, 0x7c, 0x7c, 0x73, 0x5f, 0x6d, 0x6d, 
	0x88, 0x60, 0x30, 0x73, 0x4a, 0x36, 0x4e, 0x4d, 0x4c, 
	0x36, 0x73, 0x6d, 0x6e, 0x6e, 0x88, 0x5d, 0x01, 0x36, 
	0x33, 0x6b, 0x30, 0x5f, 0x12, 0x6d, 0x6e, 0x5d, 0x38, 
	0x00, 0x05, 0x6e, 0x7e, 0x5f, 0x33, 0x6e, 0x6e, 0x6e, 
	0x7c, 0x73, 0x6d, 0x4c, 0x11, 0x6b, 0x6e, 0x6e, 0x00, 
	0x04, 0x88, 0x36, 0x5c, 0x88, 0x88, 0x4c, 0x30, 0x00, 
	0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x65, 0x1f, 0x78, 0x41, 
	0x00, 0x04, 0x01, 0x3f, 0x65, 0x40, 0x78, 0x41, 0x0f, 
	0x2f, 0x0f, 0x41, 0x41, 0x45, 0x1e, 0x1e, 0x1e, 0x09, 
	0x78, 0x2d, 0x0d, 0x0e, 0x1f, 0x68, 0x09, 0x2f, 0x0f, 
	0x45, 0x56, 0x67, 0x3f, 0x2f, 0x0f, 0x46, 0x68, 0x46, 
	0x0f, 0x0f, 0x45, 0x78, 0x3f, 0x0f, 0x0f, 0x0f, 0x46, 
	0x68, 0x8c, 0x01, 0xa7, 0x08, 0x1e, 0x0f, 0x09, 0x10, 
	0x10, 0x01, 0x01, 0x01, 0x36, 0x58, 0x6d, 0x6d, 0x38, 
	0x88, 0x37, 0x88, 0x30, 0x7c, 0x58, 0x5f, 0x6d, 0x6d, 
	0x6e, 0x38, 0x60, 0x73, 0x4a, 0x5f, 0x7c, 0x4f, 0x6e, 
	0x33, 0x37, 0x6d, 0x6e, 0x6e, 0x6e, 0x38, 0x38, 0x12, 
	0x33, 0x4e, 0x30, 0x5f, 0x32, 0x6d, 0x6e, 0x60, 0x60, 
	0x88, 0x6e, 0x6e, 0x6e, 0x88, 0x6b, 0x37, 0x73, 0x6e, 
	0x6e, 0x6e, 0x38, 0x5c, 0x6e, 0x4c, 0x30, 0x70, 0x6e, 
	0x6e, 0x00, 0x04, 0x88, 0x12, 0x37, 0x88, 0x88, 0x4c, 
	0x30, 0x00, 0xb8, 0x01, 0x2f, 0x3f, 0x65, 0x65, 0x46, 
	0x78, 0x41, 0x00, 0x04, 0x01, 0x3f, 0x65, 0x45, 0x55, 
	0x41, 0x65, 0x1d, 0x45, 0x78, 0x78, 0x1f, 0x0f, 0x1e, 
	0x1e, 0x45, 0x2d, 0x1f, 0x0d, 0x3f, 0x2d, 0x68, 0x09, 
	0x2f, 0x0f, 0x45, 0x56, 0x67, 0x3f, 0x0e, 0x0f, 0x09, 
	0x68, 0x55, 0x0f, 0x0f, 0x0f, 0x42, 0x1e, 0x0f, 0x0f, 
	0x45, 0x55, 0x67, 0x01, 0x01, 0xa7, 0x08, 0x0f, 0x0f, 
	0x09, 0x10, 0x79, 0x01, 0x01, 0x01, 0x36, 0x58, 0x6d, 
	0x6d, 0x38, 0x6e, 0x58, 0x7b, 0x4f, 0x8e, 0x00, 0x04, 
	0x6d, 0x6e, 0x4e, 0x7c, 0x33, 0x12, 0x88, 0x60, 0x01, 
	0x01, 0x99, 0x37, 0x6d, 0x6e, 0x6e, 0x6e, 0x6b, 0x6b, 
	0x4b, 0x37, 0x4e, 0x30, 0x58, 0x32, 0x6e, 0x6e, 0x30, 
	0x30, 0x4c, 0x6e, 0x6e, 0x6e, 0x88, 0x4e, 0x33, 0x5c, 
	0x6e, 0x6e, 0x6e, 0x89, 0x37, 0x6e, 0x6b, 0x4f, 0x7c, 
	0x6e, 0x6e, 0x6e, 0x88, 0x6b, 0x6d, 0x12, 0x58, 0x88, 
	0x88, 0x4c, 0x30, 0x00, 0xb8, 0x01, 0xa4, 0x3f, 0x65, 
	0x65, 0x46, 0x78, 0x41, 0x00, 0x04, 0x01, 0x65, 0x0f, 
	0x0f, 0x09, 0x40, 0x2c, 0x1d, 0x09, 0x2e, 0x2e, 0x1f, 
	0x09, 0x45, 0x0f, 0x0f, 0x40, 0x1f, 0x1d, 0x0f, 0x41, 
	0x67, 0x45, 0x2f, 0x0f, 0x45, 0x67, 0x67, 0x1d, 0x0d, 
	0x0f, 0x40, 0x68, 0x56, 0x1f, 0x45, 0x0f, 0x45, 0x65, 
	0x0f, 0x0f, 0x1f, 0x67, 0x8c, 0x01, 0x01, 0x92, 0x0d, 
	0x0f, 0x0f, 0x09, 0x10, 0x79, 0x01, 0x01, 0x01, 0x33, 
	0x58, 0x6d, 0x6d, 0x89, 0x58, 0x5f, 0x89, 0x4f, 0x01, 
	0x01, 0x88, 0x88, 0x6e, 0x6e, 0x6e, 0x70, 0x5c, 0x37, 
	0x6b, 0x30, 0x01, 0x01, 0x73, 0x37, 0x6d, 0x00, 0x05, 
	0x6e, 0x58, 0x6e, 0x89, 0x30, 0x33, 0x36, 0x6e, 0x6e, 
	0x4f, 0x34, 0x01, 0x6e, 0x6e, 0x6e, 0x4e, 0x7e, 0x32, 
	0x37, 0x6e, 0x88, 0x88, 0x89, 0x37, 0x6e, 0x4e, 0x4f, 
	0x01, 0x4c, 0x6e, 0x6e, 0x88, 0x8d, 0x37, 0x12, 0x5f, 
	0x88, 0x88, 0x4c, 0x11, 0x00, 0xb8, 0x01, 0xa4, 0x3f, 
	0x65, 0x0f, 0x55, 0x78, 0x55, 0x00, 0x05, 0x01, 0x45, 
	0x1e, 0x0f, 0x3f, 0x0e, 0x1e, 0x46, 0x2e, 0x78, 0x01, 
	0xa8, 0x1f, 0x0f, 0x0f, 0x0f, 0x45, 0x3f, 0x40, 0x78, 
	0x2e, 0x0f, 0x1d, 0x0f, 0x45, 0x67, 0x56, 0x08, 0x54, 
	0x0f, 0x45, 0x67, 0x68, 0x42, 0x40, 0x45, 0x0f, 0x0f, 
	0x0f, 0x45, 0x78, 0x67, 0x01, 0x01, 0x01, 0x92, 0x0d, 
	0x0f, 0x0f, 0x09, 0x10, 0x79, 0x01, 0x01, 0x01, 0x33, 
	0x58, 0x6d, 0x6d, 0xa9, 0x37, 0x6e, 0x7c, 0x00, 0x04, 
	0x01, 0x4c, 0x88, 0x6e, 0x6e, 0x4c, 0x58, 0x6d, 0x38, 
	0x30, 0x01, 0x01, 0x01, 0x5f, 0x6d, 0x00, 0x06, 0x6e, 
	0x88, 0x5d, 0x38, 0x32, 0x36, 0x6e, 0x88, 0x4f, 0x8e, 
	0x01, 0x8f, 0x6e, 0x88, 0x38, 0x5f, 0x12, 0x37, 0x6e, 
	0x88, 0x88, 0x8d, 0x58, 0x6e, 0x4e, 0x4d, 0x01, 0x01, 
	0x6e, 0x6e, 0x88, 0x8d, 0x33, 0x12, 0x5f, 0x88, 0x88, 
	0x4c, 0x60, 0x00, 0xb8, 0x01, 0x17, 0x3f, 0x45, 0x2d, 
	0x2e, 0x78, 0x00, 0x06, 0x01, 0x07, 0x45, 0x0f, 0x1e, 
	0x1e, 0x40, 0x78, 0x2e, 0x96, 0x01, 0x01, 0x9e, 0x09, 
	0x00, 0x04, 0x0f, 0x42, 0x2e, 0x97, 0xaa, 0x1d, 0x0f, 
	0x40, 0x68, 0x78, 0x2c, 0x2f, 0x45, 0x1f, 0x67, 0x68, 
	0x47, 0x18, 0x40, 0x45, 0x0f, 0x45, 0x46, 0x67, 0x00, 
	0x04, 0x01, 0x08, 0x0d, 0x0f, 0x0f, 0x09, 0x10, 0x79, 
	0x01, 0x01, 0x01, 0x58, 0x00, 0x04, 0x6d, 0x6e, 0x4e, 
	0x60, 0x00, 0x04, 0x01, 0xab, 0x4c, 0x88, 0x6e, 0x6e, 
	0x6e, 0x6b, 0x60, 0x00, 0x04, 0x01, 0x8f, 0x88, 0x88, 
	0x6e, 0x6e, 0x6e, 0x88, 0x7e, 0x38, 0x01, 0x6d, 0x33, 
	0x37, 0x88, 0x88, 0x4d, 0x01, 0x01, 0x01, 0x6e, 0x88, 
	0x38, 0x33, 0x12, 0x58, 0x88, 0x88, 0x4c, 0x89, 0x6d, 
	0x88, 0x8d, 0x4d, 0x01, 0x01, 0x98, 0x6e, 0x7e, 0x6b, 
	0x32, 0x36, 0x6d, 0x88, 0x4c, 0x6b, 0x60, 0x00, 0xb8, 
	0x01, 0x6a, 0x45, 0x41, 0x2e, 0x8c, 0x00, 0x08, 0x01, 
	0x2d, 0x2d, 0x46, 0x2d, 0x78, 0x2e, 0x97, 0x00, 0x04, 
	0x01, 0x96, 0x2d, 0x46, 0x2d, 0x41, 0x56, 0x8c, 0x01, 
	0x01, 0x3f, 0x2d, 0x2e, 0x68, 0x1f, 0x0d, 0x09, 0x2e, 
	0x68, 0x56, 0x01, 0x01, 0x01, 0x96, 0x2d, 0x2d, 0x42, 
	0x2e, 0x2e, 0x00, 0x04, 0x01, 0x0d, 0x44, 0x2d, 0x42, 
	0x78, 0x79, 0x79, 0x00, 0x04, 0x01, 0x6b, 0x4e, 0x8d, 
	0x70, 0x38, 0x60, 0x00, 0x06, 0x01, 0x98, 0x8d, 0x70, 
	0x8d, 0x89, 0x5d, 0x00, 0x06, 0x01, 0x7b, 0x70, 0x70, 
	0x8d, 0x89, 0x7c, 0x60, 0x01, 0x01, 0x01, 0x4c, 0x38, 
	0x38, 0x70, 0x5e, 0x00, 0x04, 0x01, 0x88, 0x4e, 0x36, 
	0x36, 0x6b, 0x38, 0x5d, 0x60, 0x30, 0x7c, 0x38, 0x7c, 
	0x4d, 0x01, 0x01, 0x01, 0x4c, 0x7e, 0x6d, 0x12, 0x5c, 
	0x8d, 0x7c, 0x5d, 0x60, 0x85, 0x00, 0xb9, 0x01, 0x46, 
	0x2e, 0x97, 0x00, 0x0b, 0x01, 0x11, 0x30, 0x0a, 0x00, 
	0x08, 0x01, 0x0a, 0x30, 0x0a, 0x00, 0x04, 0x01, 0x2d, 
	0x56, 0x01, 0x9e, 0xa4, 0x46, 0x56, 0x00, 0x08, 0x01, 
	0x68, 0x11, 0x00, 0x06, 0x01, 0x65, 0x78, 0x00, 0x04, 
	0x30, 0x00, 0x06, 0x01, 0x77, 0x85, 0x85, 0x77, 0x00, 
	0x15, 0x01, 0x60, 0x85, 0x85, 0x00, 0x07, 0x01, 0x6c, 
	0x7c, 0x4f, 0x00, 0x04, 0x01, 0xab, 0x6e, 0x73, 0x6b, 
	0x60, 0x60, 0x34, 0x3a, 0x28, 0x94, 0x38, 0x5d, 0x4f, 
	0x00, 0x04, 0x01, 0x88, 0x5c, 0x58, 0x8e, 0x81, 0xac, 
	0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 0x00, 0xff, 0x01, 
	0x00, 0xc9, 0x01, 0x00, 0x00 
};

// Keyboard

unsigned char item_keyboard_colors[] = { 
	0xff, 0xff, 0xff, 
	0xff, 0xc6, 0x21, 
	0xf7, 0xbd, 0x18, 
	0xce, 0x9c, 0x18, 
	0x9c, 0x7b, 0x10, 
	0x84, 0x63, 0x10, 
	0x7b, 0x63, 0x10, 
	0xe7, 0xb5, 0x18, 
	0xff, 0xbd, 0x21, 
	0x73, 0x5a, 0x10, 
	0xef, 0xbd, 0x42, 
	0xe7, 0xb5, 0x39, 
	0xe7, 0xb5, 0x31, 
	0xde, 0xad, 0x29, 
	0x6b, 0x52, 0x10, 
	0xef, 0x9c, 0x42, 
	0xe7, 0x94, 0x39, 
	0xe7, 0x8c, 0x31, 
	0xde, 0x8c, 0x29, 
	0xde, 0x84, 0x29, 
	0xef, 0xb5, 0x18, 
	0xe7, 0x94, 0x31, 
	0xde, 0x84, 0x21, 
	0x9c, 0x73, 0x10, 
	0x52, 0x39, 0x08, 
	0xde, 0xa5, 0x18, 
	0xef, 0x9c, 0x4a, 
	0xf7, 0xc6, 0x4a, 
	0x31, 0x21, 0x08, 
	0xf7, 0xa5, 0x4a, 
	0xf7, 0xd6, 0xb5, 
	0xef, 0xbd, 0x84, 
	0xf7, 0xe7, 0xce, 
	0xff, 0xf7, 0xef, 
	0xff, 0xff, 0xff, 
	0xf7, 0xce, 0xad, 
	0x63, 0x52, 0x18, 
	0x39, 0x31, 0x10, 
	0xf7, 0xd6, 0xad, 
	0x9c, 0x7b, 0x31, 
	0xff, 0xe7, 0xce, 
	0xef, 0xa5, 0x52, 
	0xbd, 0x94, 0x39, 
	0xb5, 0x94, 0x31, 
	0xd6, 0xad, 0x39, 
	0xf7, 0xbd, 0x7b, 
	0xf7, 0xb5, 0x73, 
	0xf7, 0xce, 0x52, 
	0x29, 0x21, 0x08, 
	0xf7, 0xa5, 0x52, 
	0xff, 0xe7, 0xd6, 
	0xf7, 0xce, 0x9c, 
	0xf7, 0xce, 0xa5, 
	0xef, 0xa5, 0x5a, 
	0x00, 0x00, 0x00, 
	0x7b, 0x63, 0x29, 
	0xf7, 0xb5, 0x6b, 
	0xff, 0xef, 0xde, 
	0xf7, 0xbd, 0x84, 
	0xff, 0xef, 0xe7, 
	0x42, 0x31, 0x10, 
	0x73, 0x5a, 0x21, 
	0xe7, 0x9c, 0x4a, 
	0xd6, 0xad, 0x42, 
	0x10, 0x10, 0x08, 
	0xef, 0xad, 0x6b, 
	0xff, 0xce, 0x5a, 
	0xf7, 0xad, 0x5a, 
	0x7b, 0x6b, 0x29, 
	0xff, 0xe7, 0xc6, 
	0xf7, 0xd6, 0xa5, 
	0xc6, 0xa5, 0x42, 
	0xe7, 0xbd, 0x52, 
	0x8e, 0x71, 0x2d, 
	0xef, 0xb5, 0x6b, 
	0xef, 0xc6, 0x94, 
	0x31, 0x29, 0x10, 
	0xff, 0xd6, 0x5a, 
	0xd6, 0xad, 0x4a, 
	0x7b, 0x63, 0x21, 
	0xce, 0xa5, 0x39, 
	0xff, 0xef, 0xd6, 
	0xf7, 0xc6, 0x8c, 
	0xef, 0xad, 0x63, 
	0xde, 0xb5, 0x4a, 
	0xad, 0x8c, 0x31, 
	0xff, 0xb5, 0x63, 
	0xf7, 0xc6, 0x94, 
	0x84, 0x6b, 0x21, 
	0xad, 0x8c, 0x29, 
	0xbd, 0x9c, 0x42, 
	0xc6, 0x9c, 0x31, 
	0xff, 0xb5, 0x6b, 
	0xff, 0xbd, 0x84, 
	0xbd, 0x9c, 0x39, 
	0xa5, 0x84, 0x29, 
	0xf7, 0xc6, 0x9c, 
	0x94, 0x7b, 0x2d, 
	0x21, 0x18, 0x08, 
	0xf7, 0xad, 0x63, 
	0xff, 0xde, 0xb5, 
	0x73, 0x5a, 0x29, 
	0xce, 0xa5, 0x31, 
	0xf7, 0xde, 0xbd, 
	0xef, 0xb5, 0x7b, 
	0x4a, 0x39, 0x18, 
	0x6b, 0x5a, 0x21, 
	0x52, 0x42, 0x18, 
	0x4a, 0x39, 0x10, 
	0xff, 0xbd, 0x73, 
	0xa5, 0x84, 0x31, 
	0x9c, 0x7b, 0x29, 
	0x94, 0x73, 0x21, 
	0xff, 0xde, 0xbd, 
	0xe7, 0xbd, 0x4a, 
	0xde, 0xb5, 0x39, 
	0xf7, 0xde, 0xc6, 
	0x42, 0x39, 0x10, 
	0xff, 0xde, 0xc6, 
	0x73, 0x5a, 0x18, 
	0xd6, 0xad, 0x31, 
	0xef, 0xb5, 0x73, 
	0x6b, 0x52, 0x21, 
	0x5a, 0x4a, 0x18, 
	0xff, 0xf7, 0xe7, 
	0xe7, 0xa5, 0x5a, 
	0xe7, 0x9c, 0x52, 
	0xde, 0x8c, 0x31, 
	0xe7, 0xa5, 0x63, 
	0x08, 0x08, 0x00, 
	0xe7, 0x94, 0x42, 
	0xd6, 0xa5, 0x21, 
	0xad, 0x84, 0x29, 
	0xbd, 0x94, 0x31, 
	0xe7, 0x9c, 0x42, 
	0xd6, 0x7b, 0x18, 
	0xef, 0xce, 0xa5, 
	0x31, 0x29, 0x08, 
	0x39, 0x29, 0x08, 
	0xe7, 0xad, 0x6b, 
	0xef, 0xbd, 0x8c, 
	0x63, 0x52, 0x10, 
	0xd6, 0xa5, 0x18, 
	0xb5, 0x8c, 0x29, 
	0xa5, 0x84, 0x21, 
	0xc6, 0x94, 0x21, 
	0xc6, 0x9c, 0x21, 
	0x8c, 0x6b, 0x18, 
	0x52, 0x42, 0x10, 
	0x9c, 0x7b, 0x21, 
	0xde, 0x94, 0x39, 
	0xbd, 0x94, 0x21, 
	0x18, 0x18, 0x08, 
	0x8c, 0x6d, 0x20, 
	0x42, 0x31, 0x08, 
	0xd6, 0x9c, 0x10, 
	0xd6, 0x73, 0x10, 
	0xce, 0xa5, 0x29, 
	0x10, 0x10, 0x00, 
	0xb5, 0x8c, 0x18, 
	0xef, 0xad, 0x73, 
	0xb5, 0x8c, 0x21, 
	0x5a, 0x4a, 0x10, 
	0x84, 0x63, 0x18, 
	0x8c, 0x6b, 0x10, 
	0xce, 0x9c, 0x08, 
	0xce, 0x73, 0x08, 
	0xbd, 0x94, 0x18, 
	0x63, 0x4a, 0x10, 
	0x9c, 0x7b, 0x18, 
	0xa5, 0x7b, 0x18, 
	0xad, 0x84, 0x10, 
	0xce, 0x94, 0x00, 
	0xce, 0x6b, 0x00, 
	0xa5, 0x7b, 0x10, 
	0xe7, 0xbd, 0x39, 
	0xde, 0xad, 0x21, 
	0xbd, 0x94, 0x29, 
	0xff, 0xd6, 0xad, 
	0xa5, 0x8c, 0x39, 
	0xff, 0xbd, 0x7b, 
	0xce, 0xad, 0x42, 
	0xa5, 0x84, 0x39, 
	0xc6, 0x9c, 0x39, 
	0xbd, 0x9c, 0x31, 
	0x18, 0x10, 0x00, 
	0xef, 0xad, 0x5a, 
	0xff, 0xd6, 0xb5, 
	0x7b, 0x63, 0x18, 
	0xef, 0xbd, 0x7b, 
	0xe7, 0xb5, 0x42, 
	0xce, 0x9c, 0x21, 
	0xd6, 0xa5, 0x31, 
	0x6b, 0x52, 0x18, 
	0xff, 0xf7, 0xf7, 
	0xde, 0xad, 0x39, 
	0x63, 0x4a, 0x18, 
	0xad, 0x84, 0x18, 
	0xad, 0x84, 0x21, 
	0xc6, 0x94, 0x18, 
	0xce, 0x9c, 0x10, 
	0xef, 0xce, 0x9c, 
	0x5a, 0x42, 0x08, 
	0x4a, 0x39, 0x08

};
unsigned char item_keyboard[] = { 
	0x01, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 
	0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 
	0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 
	0x07, 0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 
	0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 
	0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 
	0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 0x07, 
	0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 
	0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 
	0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 
	0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 
	0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 
	0x07, 0x06, 0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 
	0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x08, 0x02, 
	0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 
	0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 
	0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 
	0x05, 0x04, 0x03, 0x07, 0x03, 0x04, 0x05, 0x00, 0x07, 
	0x06, 0x05, 0x04, 0x03, 0x02, 0x00, 0x0f, 0x01, 0x02, 
	0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 
	0x02, 0x00, 0x0f, 0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 
	0x08, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x01, 0x01, 
	0x08, 0x03, 0x09, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0f, 0x10, 
	0x11, 0x11, 0x12, 0x13, 0x0e, 0x04, 0x0e, 0x00, 0x06, 
	0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x04, 0x0e, 
	0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 
	0x04, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 
	0x0d, 0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 
	0x11, 0x12, 0x13, 0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0a, 
	0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x04, 0x0e, 0x00, 
	0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x04, 
	0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 
	0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 
	0x12, 0x13, 0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 
	0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x04, 0x0e, 0x00, 0x06, 
	0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x04, 0x0e, 
	0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x09, 
	0x03, 0x14, 0x03, 0x09, 0x00, 0x06, 0x0f, 0x10, 0x11, 
	0x11, 0x12, 0x13, 0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0a, 
	0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x04, 0x0e, 0x00, 
	0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x04, 
	0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 
	0x0e, 0x04, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 
	0x12, 0x13, 0x09, 0x03, 0x08, 0x00, 0x0d, 0x01, 0x08, 
	0x03, 0x09, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 
	0x13, 0x09, 0x03, 0x08, 0x00, 0x0d, 0x01, 0x08, 0x03, 
	0x09, 0x00, 0x06, 0x0f, 0x10, 0x15, 0x15, 0x11, 0x13, 
	0x16, 0x09, 0x03, 0x08, 0x01, 0x01, 0x14, 0x17, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x17, 0x19, 
	0x17, 0x00, 0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 
	0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 
	0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x17, 0x14, 0x00, 0x0d, 0x01, 0x14, 0x17, 0x00, 0x08, 
	0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x17, 0x14, 0x00, 
	0x0d, 0x01, 0x14, 0x17, 0x0f, 0x00, 0x05, 0x1a, 0x0f, 
	0x0f, 0x10, 0x15, 0x11, 0x11, 0x13, 0x16, 0x17, 0x14, 
	0x01, 0x01, 0x07, 0x05, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x1d, 
	0x1d, 0x1e, 0x1e, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 
	0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x05, 
	0x1d, 0x0f, 0x0f, 0x1f, 0x20, 0x11, 0x12, 0x13, 0x1c, 
	0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x04, 0x1d, 0x1e, 0x21, 
	0x22, 0x22, 0x23, 0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 
	0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x1c, 0x0f, 0x1d, 0x1d, 0x1e, 0x1e, 0x1d, 0x0f, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 
	0x1b, 0x0a, 0x24, 0x25, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 
	0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x20, 0x26, 0x10, 0x11, 
	0x12, 0x13, 0x1c, 0x0a, 0x1b, 0x1b, 0x27, 0x25, 0x1b, 
	0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 
	0x1d, 0x1d, 0x1d, 0x1e, 0x28, 0x20, 0x20, 0x26, 0x10, 
	0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x05, 0x03, 0x05, 
	0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x29, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x1c, 0x0a, 0x00, 0x04, 0x1b, 0x2a, 0x2b, 
	0x2c, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 
	0x04, 0x1d, 0x2d, 0x2e, 0x29, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x05, 0x1d, 
	0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x05, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x05, 0x0f, 0x00, 0x05, 0x1d, 
	0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x05, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x05, 0x1a, 0x00, 0x05, 0x1d, 
	0x1a, 0x0f, 0x0f, 0x10, 0x15, 0x11, 0x13, 0x16, 0x05, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x1b, 0x00, 0x05, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x31, 0x32, 0x32, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 
	0x05, 0x31, 0x1d, 0x0f, 0x33, 0x22, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x34, 
	0x22, 0x2e, 0x0f, 0x29, 0x35, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x32, 0x32, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x00, 0x05, 0x2f, 0x1b, 0x25, 0x36, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x22, 0x20, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x2f, 0x37, 
	0x36, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x31, 0x31, 0x38, 0x2d, 0x2d, 0x39, 
	0x20, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x05, 
	0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x06, 
	0x03, 0x06, 0x1d, 0x31, 0x31, 0x31, 0x3a, 0x26, 0x3b, 
	0x20, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x2f, 0x27, 0x36, 0x3c, 0x30, 0x36, 0x3d, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x22, 0x39, 
	0x28, 0x22, 0x32, 0x3e, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x00, 0x05, 0x2f, 0x3f, 0x40, 0x3d, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x32, 0x00, 0x04, 
	0x22, 0x41, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x1a, 
	0x0f, 0x10, 0x15, 0x11, 0x13, 0x16, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0x32, 0x32, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 
	0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 0x33, 
	0x22, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 
	0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x43, 0x32, 0x32, 0x1d, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 
	0x42, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x43, 0x32, 0x32, 0x31, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x42, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x44, 0x36, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 0x43, 
	0x31, 0x1d, 0x20, 0x20, 0x10, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 0x31, 
	0x43, 0x45, 0x32, 0x46, 0x39, 0x20, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x47, 0x48, 0x2f, 
	0x1b, 0x49, 0x36, 0x2b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0x43, 0x38, 0x31, 0x1d, 0x4a, 0x22, 0x4b, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 
	0x2f, 0x4c, 0x36, 0x3d, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x43, 0x32, 0x33, 0x2d, 0x2e, 0x4a, 
	0x3e, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 0x0d, 0x01, 
	0x07, 0x06, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 
	0x0d, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x00, 0x04, 0x43, 
	0x38, 0x1a, 0x0f, 0x10, 0x15, 0x11, 0x13, 0x16, 0x06, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x1b, 0x2f, 0x42, 0x4d, 
	0x4e, 0x49, 0x37, 0x4f, 0x50, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x51, 0x32, 0x31, 0x52, 0x34, 
	0x53, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 
	0x4d, 0x54, 0x49, 0x37, 0x4f, 0x55, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x56, 0x57, 0x34, 
	0x4a, 0x33, 0x22, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x4d, 0x42, 0x47, 0x37, 0x58, 0x50, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x32, 0x32, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x4d, 0x48, 0x27, 0x37, 0x2c, 0x50, 0x59, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x51, 0x32, 
	0x31, 0x52, 0x34, 0x53, 0x10, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x4d, 0x4e, 0x5a, 0x2a, 0x2b, 0x5b, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x5c, 
	0x5d, 0x2d, 0x2d, 0x2e, 0x29, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x42, 0x44, 0x36, 0x2f, 0x1b, 0x0a, 
	0x5b, 0x59, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 
	0x56, 0x43, 0x31, 0x1d, 0x20, 0x20, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x2f, 0x48, 0x5a, 0x42, 0x49, 0x5e, 
	0x0a, 0x5f, 0x4f, 0x0c, 0x0d, 0x0d, 0x06, 0x03, 0x06, 
	0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 0x28, 0x20, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x4d, 
	0x42, 0x2f, 0x1b, 0x0a, 0x36, 0x3d, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 0x1d, 0x0f, 
	0x22, 0x60, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 
	0x4d, 0x42, 0x61, 0x62, 0x30, 0x3d, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x32, 0x2d, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 
	0x0d, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 0x56, 0x43, 
	0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 
	0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 
	0x56, 0x63, 0x64, 0x32, 0x29, 0x0f, 0x10, 0x15, 0x11, 
	0x13, 0x16, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x1b, 
	0x2f, 0x42, 0x5a, 0x62, 0x65, 0x37, 0x4c, 0x40, 0x66, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x32, 0x32, 
	0x32, 0x67, 0x23, 0x22, 0x68, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x61, 0x36, 0x69, 0x37, 0x6a, 0x62, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 
	0x3b, 0x39, 0x34, 0x32, 0x32, 0x22, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x42, 0x42, 0x6b, 0x62, 0x37, 0x6c, 
	0x40, 0x5b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x00, 
	0x07, 0x22, 0x60, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x48, 0x30, 0x30, 0x37, 0x4c, 0x4c, 0x36, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x32, 0x32, 0x32, 
	0x3b, 0x39, 0x22, 0x1f, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x42, 0x6a, 0x3c, 0x25, 0x40, 0x25, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x6d, 0x32, 
	0x32, 0x28, 0x22, 0x33, 0x10, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x44, 0x36, 0x2f, 0x1b, 0x6e, 0x36, 
	0x6f, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 
	0x43, 0x31, 0x1d, 0x20, 0x20, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x5a, 0x36, 0x6a, 0x40, 0x40, 0x61, 
	0x62, 0x36, 0x70, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 
	0x31, 0x43, 0x43, 0x43, 0x31, 0x28, 0x20, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 
	0x2f, 0x1b, 0x2c, 0x36, 0x70, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 0x4a, 0x22, 
	0x29, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 
	0x54, 0x40, 0x5e, 0x25, 0x3d, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x43, 0x32, 0x2d, 0x1d, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 
	0x43, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 0x63, 
	0x71, 0x3b, 0x2d, 0x1a, 0x0f, 0x10, 0x15, 0x11, 0x13, 
	0x16, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x1b, 0x2f, 
	0x2f, 0x72, 0x2f, 0x2f, 0x1b, 0x73, 0x36, 0x3d, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x32, 0x22, 0x2e, 
	0x1d, 0x0f, 0x34, 0x21, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x47, 0x36, 0x61, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x46, 0x21, 
	0x63, 0x1d, 0x0f, 0x74, 0x22, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x2f, 0x37, 0x40, 0x72, 0x1b, 0x0a, 0x30, 
	0x75, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 
	0x32, 0x32, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x2f, 0x37, 0x40, 0x72, 0x1b, 0x0a, 
	0x75, 0x36, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 
	0x32, 0x22, 0x76, 0x1d, 0x0f, 0x3b, 0x20, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x25, 0x25, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 
	0x1d, 0x22, 0x33, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x2f, 0x37, 0x36, 0x2f, 0x50, 0x40, 0x6f, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 
	0x20, 0x20, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x5a, 0x36, 0x6b, 0x2f, 0x36, 0x30, 0x0a, 0x25, 0x77, 
	0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 0x00, 0x05, 0x31, 
	0x28, 0x20, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x00, 0x05, 0x2f, 0x1b, 0x24, 0x40, 0x78, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x38, 0x46, 0x67, 
	0x32, 0x79, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x2f, 0x2f, 0x4c, 0x7a, 0x1b, 0x25, 0x3d, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x32, 0x22, 
	0x3b, 0x1e, 0x29, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x1d, 0x00, 0x04, 0x31, 
	0x76, 0x39, 0x29, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 
	0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 
	0x64, 0x3b, 0x3a, 0x1d, 0x1a, 0x0f, 0x10, 0x15, 0x11, 
	0x13, 0x16, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x0a, 
	0x00, 0x04, 0x1b, 0x54, 0x2b, 0x55, 0x36, 0x3d, 0x0c, 
	0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x28, 0x28, 0x1d, 
	0x0f, 0x0f, 0x4a, 0x22, 0x53, 0x12, 0x13, 0x30, 0x0a, 
	0x1b, 0x7b, 0x62, 0x1b, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x39, 0x67, 
	0x1d, 0x0f, 0x0f, 0x33, 0x22, 0x11, 0x12, 0x13, 0x30, 
	0x0a, 0x1b, 0x1b, 0x62, 0x69, 0x1b, 0x0a, 0x0a, 0x3d, 
	0x40, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x1d, 
	0x28, 0x28, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x0a, 0x1b, 0x1b, 0x62, 0x7b, 0x1b, 0x0a, 0x0a, 
	0x3d, 0x36, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 
	0x28, 0x39, 0x1d, 0x0f, 0x0f, 0x20, 0x20, 0x11, 0x12, 
	0x13, 0x30, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x25, 0x25, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x00, 0x05, 0x1d, 
	0x0f, 0x22, 0x33, 0x10, 0x11, 0x12, 0x13, 0x30, 0x0a, 
	0x1b, 0x1b, 0x37, 0x36, 0x50, 0x40, 0x6b, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 
	0x20, 0x20, 0x10, 0x11, 0x12, 0x13, 0x30, 0x0a, 0x1b, 
	0x2a, 0x36, 0x54, 0x1b, 0x36, 0x5f, 0x0a, 0x25, 0x77, 
	0x0d, 0x0d, 0x06, 0x03, 0x06, 0x0f, 0x00, 0x05, 0x1d, 
	0x20, 0x20, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x0a, 
	0x00, 0x05, 0x1b, 0x6e, 0x40, 0x5b, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x1d, 0x63, 0x34, 0x1e, 
	0x21, 0x26, 0x10, 0x11, 0x12, 0x13, 0x30, 0x0a, 0x1b, 
	0x1b, 0x49, 0x62, 0x54, 0x0a, 0x25, 0x3d, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x0f, 0x00, 0x05, 0x1d, 0x2d, 0x39, 
	0x39, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x0f, 0x1d, 0x1d, 0x1d, 0x74, 0x22, 
	0x22, 0x39, 0x29, 0x10, 0x11, 0x12, 0x13, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x1a, 0x43, 0x28, 0x7c, 
	0x57, 0x38, 0x41, 0x53, 0x53, 0x35, 0x7d, 0x7e, 0x7f, 
	0x16, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x0a, 0x0a, 
	0x0a, 0x73, 0x7b, 0x36, 0x30, 0x25, 0x36, 0x77, 0x0d, 
	0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 0x0f, 
	0x0f, 0x0f, 0x41, 0x22, 0x80, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x25, 0x25, 0x00, 0x04, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x22, 0x34, 0x0f, 
	0x0f, 0x0f, 0x60, 0x22, 0x12, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x0a, 0x36, 0x62, 0x25, 0x25, 0x25, 0x62, 0x36, 
	0x0d, 0x0d, 0x0d, 0x30, 0x00, 0x04, 0x0f, 0x20, 0x20, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x0a, 0x36, 0x4f, 0x0a, 0x0a, 0x0a, 0x3d, 0x36, 
	0x0d, 0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 
	0x0f, 0x0f, 0x0f, 0x20, 0x20, 0x12, 0x12, 0x13, 0x30, 
	0x00, 0x07, 0x0a, 0x25, 0x25, 0x0c, 0x0d, 0x0d, 0x0d, 
	0x30, 0x00, 0x07, 0x0f, 0x22, 0x60, 0x11, 0x12, 0x12, 
	0x13, 0x30, 0x0a, 0x0a, 0x0a, 0x4f, 0x36, 0x25, 0x81, 
	0x2c, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x30, 0x00, 0x07, 
	0x0f, 0x20, 0x20, 0x11, 0x12, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x2b, 0x36, 0x0a, 0x0a, 0x36, 0x55, 0x0b, 0x25, 
	0x77, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x00, 0x06, 0x0f, 
	0x20, 0x20, 0x10, 0x11, 0x12, 0x12, 0x13, 0x30, 0x00, 
	0x05, 0x0a, 0x6e, 0x40, 0x5b, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x0d, 0x30, 0x00, 0x07, 0x0f, 0x53, 0x22, 0x4b, 0x12, 
	0x12, 0x13, 0x30, 0x0a, 0x0a, 0x2c, 0x40, 0x5e, 0x0a, 
	0x0a, 0x25, 0x3d, 0x0c, 0x0d, 0x0d, 0x0d, 0x30, 0x00, 
	0x07, 0x0f, 0x29, 0x22, 0x68, 0x12, 0x12, 0x13, 0x06, 
	0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 0x0f, 0x0f, 0x0f, 
	0x67, 0x00, 0x04, 0x22, 0x39, 0x82, 0x12, 0x12, 0x13, 
	0x06, 0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 0x0f, 0x33, 
	0x22, 0x21, 0x00, 0x04, 0x32, 0x20, 0x20, 0x20, 0x74, 
	0x3e, 0x16, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x0a, 
	0x0a, 0x0a, 0x4c, 0x62, 0x50, 0x0a, 0x0b, 0x36, 0x77, 
	0x0d, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 
	0x0f, 0x0f, 0x10, 0x53, 0x22, 0x7e, 0x13, 0x16, 0x30, 
	0x0a, 0x0a, 0x25, 0x30, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0c, 0x0d, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 0x22, 
	0x33, 0x0f, 0x0f, 0x10, 0x4b, 0x22, 0x12, 0x13, 0x16, 
	0x30, 0x0a, 0x0a, 0x0a, 0x36, 0x7b, 0x55, 0x55, 0x59, 
	0x84, 0x84, 0x0d, 0x0d, 0x83, 0x30, 0x00, 0x04, 0x0f, 
	0x20, 0x20, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 
	0x30, 0x0a, 0x0a, 0x0a, 0x36, 0x3d, 0x0a, 0x0a, 0x0b, 
	0x77, 0x36, 0x0d, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 
	0x20, 0x20, 0x0f, 0x0f, 0x10, 0x20, 0x20, 0x12, 0x13, 
	0x16, 0x30, 0x00, 0x07, 0x0a, 0x25, 0x25, 0x0c, 0x0d, 
	0x0d, 0x83, 0x30, 0x00, 0x07, 0x0f, 0x22, 0x4b, 0x11, 
	0x12, 0x13, 0x16, 0x30, 0x0a, 0x0a, 0x0a, 0x3d, 0x36, 
	0x5b, 0x40, 0x30, 0x66, 0x0c, 0x0d, 0x0d, 0x83, 0x30, 
	0x00, 0x07, 0x0f, 0x20, 0x20, 0x11, 0x12, 0x13, 0x16, 
	0x30, 0x0a, 0x0a, 0x55, 0x36, 0x0a, 0x0a, 0x36, 0x59, 
	0x0c, 0x25, 0x77, 0x0d, 0x83, 0x06, 0x03, 0x06, 0x00, 
	0x06, 0x0f, 0x20, 0x20, 0x11, 0x11, 0x12, 0x13, 0x16, 
	0x30, 0x00, 0x04, 0x0a, 0x85, 0x36, 0x85, 0x0b, 0x0c, 
	0x0c, 0x0d, 0x0d, 0x83, 0x30, 0x00, 0x07, 0x0f, 0x10, 
	0x20, 0x20, 0x12, 0x13, 0x16, 0x30, 0x0a, 0x0a, 0x55, 
	0x00, 0x07, 0x36, 0x0d, 0x0d, 0x83, 0x30, 0x00, 0x07, 
	0x0f, 0x10, 0x22, 0x4b, 0x12, 0x13, 0x16, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x0f, 0x0f, 0x67, 0x00, 
	0x06, 0x22, 0x39, 0x10, 0x13, 0x16, 0x06, 0x07, 0x00, 
	0x0d, 0x01, 0x07, 0x06, 0x0f, 0x0f, 0x60, 0x21, 0x57, 
	0x1a, 0x1a, 0x86, 0x82, 0x82, 0x10, 0x7f, 0x16, 0x87, 
	0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x0b, 0x0b, 0x0b, 
	0x36, 0x3d, 0x0b, 0x0b, 0x0c, 0x36, 0x77, 0x0d, 0x83, 
	0x83, 0x30, 0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 
	0x11, 0x88, 0x21, 0x13, 0x16, 0x16, 0x30, 0x0b, 0x0b, 
	0x4f, 0x36, 0x66, 0x0b, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 
	0x83, 0x83, 0x30, 0x10, 0x10, 0x10, 0x39, 0x1e, 0x10, 
	0x10, 0x11, 0x20, 0x22, 0x13, 0x16, 0x16, 0x30, 0x0b, 
	0x0b, 0x0b, 0x75, 0x30, 0x0b, 0x0b, 0x0c, 0x0c, 0x0d, 
	0x0d, 0x83, 0x83, 0x30, 0x00, 0x04, 0x10, 0x20, 0x20, 
	0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 0x16, 0x30, 0x0b, 
	0x0b, 0x0b, 0x30, 0x30, 0x0b, 0x0b, 0x0c, 0x89, 0x36, 
	0x0d, 0x83, 0x83, 0x30, 0x10, 0x10, 0x10, 0x20, 0x20, 
	0x10, 0x10, 0x11, 0x20, 0x74, 0x13, 0x16, 0x16, 0x30, 
	0x00, 0x07, 0x0b, 0x25, 0x25, 0x0d, 0x0d, 0x83, 0x83, 
	0x30, 0x00, 0x07, 0x10, 0x22, 0x4b, 0x12, 0x13, 0x16, 
	0x16, 0x30, 0x0b, 0x0b, 0x0b, 0x3d, 0x36, 0x0b, 0x5f, 
	0x36, 0x6c, 0x0d, 0x0d, 0x83, 0x83, 0x30, 0x00, 0x07, 
	0x10, 0x20, 0x20, 0x12, 0x13, 0x16, 0x16, 0x30, 0x0b, 
	0x0b, 0x59, 0x36, 0x0b, 0x0b, 0x36, 0x84, 0x0c, 0x8a, 
	0x0e, 0x83, 0x83, 0x06, 0x03, 0x06, 0x00, 0x06, 0x10, 
	0x20, 0x20, 0x11, 0x12, 0x13, 0x16, 0x16, 0x30, 0x0b, 
	0x0b, 0x0b, 0x78, 0x40, 0x3d, 0x0b, 0x0c, 0x0c, 0x0d, 
	0x0d, 0x83, 0x83, 0x30, 0x00, 0x07, 0x10, 0x11, 0x3b, 
	0x67, 0x13, 0x16, 0x16, 0x30, 0x00, 0x07, 0x0b, 0x25, 
	0x77, 0x0d, 0x0d, 0x83, 0x83, 0x30, 0x00, 0x07, 0x10, 
	0x3e, 0x22, 0x68, 0x13, 0x16, 0x16, 0x06, 0x07, 0x00, 
	0x0d, 0x01, 0x07, 0x06, 0x10, 0x53, 0x00, 0x05, 0x60, 
	0x4b, 0x4b, 0x4b, 0x8b, 0x16, 0x16, 0x06, 0x07, 0x00, 
	0x0d, 0x01, 0x07, 0x06, 0x10, 0x10, 0x10, 0x8c, 0x7c, 
	0x8c, 0x10, 0x15, 0x15, 0x11, 0x13, 0x16, 0x16, 0x87, 
	0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x0c, 0x0c, 0x0c, 
	0x62, 0x30, 0x66, 0x66, 0x6c, 0x36, 0x8d, 0x0d, 0x83, 
	0x8e, 0x30, 0x11, 0x11, 0x11, 0x20, 0x22, 0x1f, 0x11, 
	0x7e, 0x21, 0x4b, 0x13, 0x16, 0x87, 0x30, 0x0c, 0x0c, 
	0x66, 0x30, 0x30, 0x8f, 0x0c, 0x0d, 0x90, 0x91, 0x0d, 
	0x83, 0x8e, 0x30, 0x11, 0x11, 0x11, 0x4b, 0x21, 0x7e, 
	0x82, 0x1e, 0x20, 0x22, 0x13, 0x16, 0x87, 0x30, 0x0c, 
	0x0c, 0x0c, 0x8f, 0x36, 0x6c, 0x66, 0x0d, 0x92, 0x93, 
	0x0d, 0x83, 0x8e, 0x30, 0x00, 0x04, 0x11, 0x20, 0x20, 
	0x11, 0x12, 0x12, 0x13, 0x13, 0x16, 0x87, 0x30, 0x0c, 
	0x0c, 0x0c, 0x90, 0x36, 0x77, 0x84, 0x3c, 0x3c, 0x36, 
	0x0d, 0x83, 0x8e, 0x30, 0x11, 0x11, 0x11, 0x20, 0x20, 
	0x11, 0x11, 0x12, 0x74, 0x74, 0x13, 0x16, 0x87, 0x30, 
	0x00, 0x07, 0x0c, 0x8a, 0x8a, 0x0d, 0x0d, 0x83, 0x8e, 
	0x30, 0x00, 0x07, 0x11, 0x22, 0x4b, 0x13, 0x13, 0x16, 
	0x87, 0x30, 0x0c, 0x0c, 0x0c, 0x77, 0x36, 0x0c, 0x0c, 
	0x70, 0x36, 0x6c, 0x0d, 0x83, 0x8e, 0x30, 0x00, 0x07, 
	0x11, 0x74, 0x74, 0x13, 0x13, 0x16, 0x87, 0x30, 0x0c, 
	0x0c, 0x84, 0x36, 0x0c, 0x0c, 0x36, 0x90, 0x0d, 0x8a, 
	0x0e, 0x83, 0x8e, 0x06, 0x03, 0x06, 0x11, 0x11, 0x11, 
	0x7e, 0x53, 0x53, 0x39, 0x39, 0x80, 0x7d, 0x3e, 0x16, 
	0x87, 0x30, 0x0c, 0x0c, 0x0c, 0x94, 0x36, 0x95, 0x84, 
	0x90, 0x90, 0x91, 0x0d, 0x83, 0x8e, 0x30, 0x11, 0x11, 
	0x11, 0x3e, 0x41, 0x11, 0x82, 0x88, 0x22, 0x7e, 0x13, 
	0x16, 0x87, 0x30, 0x00, 0x07, 0x0c, 0x8a, 0x77, 0x0d, 
	0x0d, 0x83, 0x8e, 0x30, 0x00, 0x04, 0x11, 0x41, 0x11, 
	0x82, 0x39, 0x3b, 0x96, 0x13, 0x16, 0x87, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x00, 0x07, 0x11, 0x12, 
	0x12, 0x13, 0x13, 0x16, 0x87, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x15, 0x15, 0x15, 0x10, 0x1f, 0x3b, 
	0x1f, 0x11, 0x11, 0x13, 0x13, 0x16, 0x87, 0x87, 0x06, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x0d, 0x0d, 0x0d, 0x97, 
	0x30, 0x36, 0x98, 0x99, 0x70, 0x36, 0x9a, 0x8e, 0x9b, 
	0x30, 0x12, 0x12, 0x12, 0x88, 0x68, 0x4b, 0x21, 0x21, 
	0x88, 0x16, 0x16, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 
	0x9d, 0x94, 0x9e, 0x36, 0x36, 0x8a, 0x9f, 0x83, 0x8e, 
	0x9b, 0x30, 0x00, 0x04, 0x12, 0x88, 0x22, 0x21, 0xa0, 
	0x79, 0x74, 0x16, 0x87, 0x9c, 0x30, 0x00, 0x04, 0x0d, 
	0xa1, 0x3c, 0x36, 0x36, 0x98, 0x9a, 0x83, 0x8e, 0x9b, 
	0x30, 0x00, 0x04, 0x12, 0x88, 0x88, 0x12, 0x12, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x30, 0x00, 0x04, 0x0d, 0x95, 
	0x8a, 0x3c, 0xa1, 0x0e, 0x36, 0x83, 0x8e, 0x9b, 0x30, 
	0x12, 0x12, 0x12, 0x88, 0x88, 0x12, 0x12, 0x12, 0x88, 
	0x88, 0x16, 0x87, 0x9c, 0x30, 0x00, 0x07, 0x0d, 0xa2, 
	0xa2, 0x83, 0x83, 0x8e, 0x9b, 0x30, 0x00, 0x07, 0x12, 
	0x22, 0x4b, 0x16, 0x16, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 
	0x0d, 0x99, 0x8a, 0x0d, 0x0d, 0x0d, 0xa3, 0x8a, 0x06, 
	0x8e, 0x9b, 0x30, 0x00, 0x07, 0x12, 0x88, 0x88, 0x16, 
	0x16, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x97, 0x8a, 0x0d, 
	0x0d, 0x8a, 0x97, 0x0d, 0xa2, 0xa4, 0x8e, 0x9b, 0x06, 
	0x03, 0x06, 0x12, 0x12, 0x12, 0x88, 0x00, 0x06, 0x74, 
	0x88, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0xa2, 0x00, 
	0x05, 0x8a, 0xa4, 0x83, 0x8e, 0x9b, 0x30, 0x12, 0x12, 
	0x12, 0x7e, 0x3b, 0x22, 0x22, 0x39, 0x80, 0x16, 0x16, 
	0x87, 0x9c, 0x30, 0x00, 0x07, 0x0d, 0xa2, 0x93, 0x83, 
	0x83, 0x8e, 0x9b, 0x30, 0x00, 0x04, 0x12, 0x39, 0x22, 
	0x22, 0x67, 0x82, 0x16, 0x16, 0x87, 0x9c, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x00, 0x08, 0x12, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x06, 0x07, 0x00, 0x0d, 0x01, 
	0x07, 0x06, 0x00, 0x05, 0x11, 0x1f, 0x67, 0x82, 0x13, 
	0x16, 0x16, 0x87, 0x87, 0x87, 0x06, 0x07, 0x01, 0x01, 
	0x07, 0x06, 0x00, 0x08, 0x0d, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x08, 0x13, 0x16, 0x16, 0x87, 0x9c, 
	0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x08, 0x13, 0x16, 0x16, 0x87, 0x9c, 
	0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x08, 0x13, 0x16, 0x16, 0x87, 0x9c, 
	0x9c, 0x30, 0x00, 0x08, 0x0d, 0x94, 0x8a, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x08, 0x13, 0x16, 0x16, 0x87, 0x9c, 
	0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 0x83, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x06, 0x13, 0x96, 0x22, 0x8b, 0x16, 
	0x87, 0x9c, 0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 0x83, 
	0x8e, 0x9b, 0x9b, 0x30, 0x00, 0x08, 0x13, 0x16, 0x16, 
	0x87, 0x9c, 0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 0x83, 
	0x8e, 0x9b, 0x9b, 0x06, 0x03, 0x06, 0x00, 0x08, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x9c, 0x30, 0x00, 0x08, 0x0d, 
	0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x30, 0x00, 0x08, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x9c, 0x30, 0x00, 0x08, 0x0d, 
	0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x30, 0x00, 0x08, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x9c, 0x06, 0x07, 0x00, 0x0d, 
	0x01, 0x07, 0x06, 0x00, 0x08, 0x13, 0x16, 0x16, 0x87, 
	0x9c, 0x9c, 0x06, 0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 
	0x00, 0x06, 0x13, 0x7f, 0x13, 0x16, 0x16, 0x87, 0x87, 
	0x87, 0x9c, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x83, 
	0x83, 0x83, 0xa7, 0xa8, 0xa9, 0xaa, 0x0e, 0x36, 0xab, 
	0x9b, 0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 
	0x9c, 0x9c, 0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 
	0x9b, 0x9b, 0xa5, 0x30, 0x16, 0x16, 0x16, 0x1f, 0x80, 
	0x7e, 0x1e, 0x21, 0x13, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 
	0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 
	0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 
	0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x06, 
	0x03, 0x06, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 
	0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 
	0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 
	0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 
	0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 
	0xa6, 0x06, 0x07, 0x00, 0x0d, 0x01, 0x07, 0x06, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x06, 0x07, 
	0x00, 0x0d, 0x01, 0x07, 0x06, 0x00, 0x08, 0x16, 0x00, 
	0x04, 0x87, 0x9c, 0xa6, 0x06, 0x07, 0x01, 0x01, 0x07, 
	0x05, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 
	0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 
	0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 
	0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 
	0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 
	0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 
	0x1c, 0x8e, 0x8e, 0x8e, 0xa7, 0x0e, 0x8a, 0x8a, 0x18, 
	0xae, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 0x87, 
	0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 0x8e, 
	0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 0x87, 0x87, 0x87, 
	0x8b, 0x1e, 0x74, 0x88, 0x96, 0x9c, 0x9c, 0xa6, 0xa6, 
	0xad, 0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 
	0xac, 0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 
	0xad, 0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 
	0xac, 0x05, 0x03, 0x05, 0x00, 0x08, 0x87, 0x9c, 0x9c, 
	0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 
	0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 
	0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 
	0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 0x87, 0x9c, 0x9c, 
	0xa6, 0xa6, 0xad, 0x05, 0x07, 0x00, 0x0d, 0x01, 0x07, 
	0x05, 0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 
	0x05, 0x07, 0x00, 0x0d, 0x01, 0x07, 0x05, 0x00, 0x0a, 
	0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0x05, 0x07, 0x01, 0x01, 
	0x14, 0x17, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 
	0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 
	0xac, 0x17, 0x19, 0x17, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 
	0xa6, 0xad, 0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 
	0xa5, 0xac, 0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 
	0xa6, 0xad, 0xad, 0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 
	0xa5, 0xac, 0xac, 0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 
	0xa6, 0xad, 0xad, 0x17, 0x14, 0x00, 0x0d, 0x01, 0x14, 
	0x17, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x17, 0x14, 0x00, 0x0d, 0x01, 0x14, 0x17, 0x00, 0x08, 
	0x87, 0x9c, 0x9c, 0x9c, 0xa6, 0xad, 0xad, 0x17, 0x14, 
	0x01, 0x01, 0x08, 0x03, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa6, 0xad, 
	0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 0xa5, 0xac, 
	0xac, 0xac, 0x0e, 0x03, 0x14, 0x03, 0x0e, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0e, 0x17, 0x0e, 0x00, 0x08, 
	0xa5, 0xac, 0xac, 0xac, 0x0e, 0x17, 0x0e, 0x00, 0x08, 
	0xa6, 0xad, 0xad, 0xad, 0x0e, 0x03, 0x08, 0x01, 0x08, 
	0x14, 0x00, 0x09, 0x07, 0x14, 0x14, 0x03, 0x0e, 0x00, 
	0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 0x03, 0x14, 0x14, 
	0x00, 0x09, 0x07, 0x14, 0x08, 0x01, 0x08, 0x03, 0x0e, 
	0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xad, 0xad, 0x0e, 0x03, 
	0x08, 0x01, 0x01, 0x08, 0x07, 0x04, 0x18, 0x1c, 0x00, 
	0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 
	0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 
	0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 
	0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 
	0x17, 0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 
	0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 
	0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 
	0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 0x30, 
	0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 
	0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 
	0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 
	0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 
	0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 
	0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 0x04, 0x07, 
	0x08, 0x07, 0x04, 0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 
	0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 0x30, 
	0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 0x07, 
	0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 0x00, 
	0x07, 0x30, 0x1c, 0x18, 0x17, 0x03, 0x17, 0x18, 0x1c, 
	0x00, 0x07, 0x30, 0x1c, 0x18, 0x04, 0x07, 0x08, 0x02, 
	0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 0x04, 0x03, 
	0x8e, 0x04, 0x18, 0x1c, 0x00, 0x07, 0x30, 0x1c, 0x18, 
	0x04, 0x8e, 0x03, 0x04, 0x05, 0x00, 0x07, 0x06, 0x05, 
	0x04, 0x03, 0x02, 0x08, 0x07, 0x04, 0x18, 0x1c, 0x00, 
	0x08, 0x30, 0x1c, 0x18, 0x04, 0x07, 0x08, 0x01, 0x01, 
	0x08, 0x03, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 
	0x12, 0x13, 0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 
	0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x17, 0x0e, 0x00, 0x06, 
	0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x17, 0x0e, 
	0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 
	0x17, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 
	0x13, 0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 
	0x0c, 0x0d, 0x0d, 0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0f, 
	0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x17, 0x0e, 0x00, 
	0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x17, 
	0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 
	0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0f, 0x10, 
	0x11, 0x11, 0x12, 0x13, 0x0e, 0x17, 0x0e, 0x00, 0x06, 
	0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x17, 0x0e, 
	0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 
	0x03, 0x14, 0x03, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 
	0x0c, 0x0d, 0x0d, 0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0f, 
	0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x17, 0x0e, 0x00, 
	0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 0x17, 
	0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 
	0x0e, 0x17, 0x0e, 0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 
	0x0d, 0x0d, 0x0e, 0x03, 0x14, 0x03, 0x09, 0x00, 0x06, 
	0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x0e, 0x04, 0x0e, 
	0x00, 0x06, 0x0a, 0x0b, 0x0c, 0x0c, 0x0d, 0x0d, 0x0e, 
	0x04, 0x0e, 0x00, 0x06, 0x0f, 0x10, 0x11, 0x11, 0x12, 
	0x13, 0x09, 0x03, 0x14, 0x03, 0x0e, 0x00, 0x06, 0x0a, 
	0xaf, 0x0c, 0x0c, 0x0c, 0x0d, 0xb0, 0x0e, 0x03, 0x08, 
	0x01, 0x01, 0x14, 0x17, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 0x10, 0x11, 
	0x12, 0x12, 0x13, 0x17, 0x19, 0x17, 0x00, 0x08, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 
	0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 0x08, 0x0f, 
	0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 0x08, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x17, 0x19, 0x17, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x18, 0x00, 
	0x08, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x18, 0x00, 
	0x08, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x17, 0x19, 
	0x17, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0xaf, 0x0c, 
	0x0c, 0x0c, 0x0d, 0xb0, 0x17, 0x14, 0x01, 0x01, 0x07, 
	0x05, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 
	0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 
	0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x1c, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 
	0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x1c, 0x0a, 0x00, 
	0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x1c, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x05, 0x03, 0x05, 0x0a, 0x00, 0x05, 
	0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 
	0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x1c, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 
	0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x1c, 0x0f, 0x00, 0x05, 
	0x1d, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x1c, 
	0x0a, 0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x05, 0x03, 0x05, 0x0f, 0x00, 0x05, 0x1d, 
	0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x1c, 0x0a, 
	0x00, 0x05, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x1c, 0x0f, 0x00, 0x05, 0x1d, 0x0f, 0x0f, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x05, 0x03, 0x05, 0x00, 0x07, 
	0x1b, 0x0a, 0x0a, 0xaf, 0x0c, 0x0c, 0x0d, 0xb0, 0x05, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x1d, 0x00, 0x05, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x0f, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x00, 0x05, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x0f, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x00, 0x05, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x03, 
	0x06, 0x1b, 0x00, 0x05, 0x2f, 0x3f, 0x2b, 0x5b, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 
	0x04, 0x2f, 0x72, 0x2a, 0x2b, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x00, 0x04, 0x31, 0x38, 0x2d, 0x29, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x04, 
	0x2f, 0x4e, 0x2a, 0x2c, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x06, 0x03, 0x06, 0x1d, 0x00, 0x05, 0x31, 0x1d, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x00, 0x05, 
	0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x00, 0x05, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x06, 0x03, 0x06, 0x1b, 0x00, 0x05, 0x2f, 
	0x1b, 0x1b, 0x0a, 0x0b, 0xb1, 0x0d, 0x0d, 0xb0, 0x06, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 0x43, 
	0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 0x1b, 0x0a, 
	0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 
	0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 0x1b, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 
	0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 
	0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 
	0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 
	0x42, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x03, 0x06, 
	0x1b, 0x2f, 0x42, 0x42, 0x48, 0x69, 0x40, 0x25, 0x62, 
	0x25, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0xb2, 
	0x00, 0x06, 0x22, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x42, 0xb3, 0x40, 0x25, 0x62, 0x40, 0x5b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 0x28, 0x21, 
	0x28, 0x22, 0x26, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x42, 0x6a, 0x40, 0x25, 0x40, 0x24, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 0x31, 0x43, 
	0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 0x1b, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 
	0x43, 0x43, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x06, 0x03, 0x06, 0x1b, 0x2f, 0x42, 0x42, 
	0x42, 0x2f, 0x1b, 0x1b, 0x0a, 0x5b, 0x62, 0xb1, 0x0d, 
	0xb0, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x1d, 0x31, 
	0x43, 0xb4, 0x6d, 0x31, 0x52, 0x34, 0x53, 0x10, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x4d, 0x48, 0x27, 
	0x37, 0x61, 0x2c, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0xb4, 0x6d, 0x31, 0x52, 0x34, 0x53, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x4d, 0x54, 
	0x49, 0x37, 0x2c, 0x50, 0x5b, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 0x1d, 0x0f, 0x0f, 
	0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x4d, 
	0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x43, 0x56, 0x43, 0x32, 0x52, 0x0f, 
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 
	0x4d, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 0x1d, 
	0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x4d, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x4d, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0x43, 
	0x31, 0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 
	0x03, 0x06, 0x1b, 0x2f, 0x42, 0x4d, 0x69, 0x30, 0x54, 
	0x0a, 0x0a, 0x78, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 
	0x43, 0x6d, 0x5d, 0x2d, 0x2d, 0x2e, 0x67, 0x32, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x48, 0x36, 0xb5, 
	0x1b, 0x0a, 0x4c, 0x75, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0xb2, 0x7c, 0x63, 0x1d, 0x4a, 0x22, 0x53, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0xb6, 0x40, 
	0xb5, 0x1b, 0xb7, 0x40, 0x70, 0x0c, 0x0d, 0x0d, 0x06, 
	0x03, 0x06, 0x1d, 0x31, 0x43, 0x56, 0x43, 0x31, 0x1d, 
	0x0f, 0x53, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x42, 0x4d, 0x42, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x56, 0xb4, 0x31, 
	0x1d, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x03, 
	0x06, 0x1b, 0x2f, 0x42, 0x4d, 0x42, 0x2f, 0x1b, 0x1b, 
	0x0a, 0xb8, 0xb9, 0xb1, 0x0d, 0xb0, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x1d, 0x31, 0x43, 0x32, 0x32, 0x32, 
	0x3b, 0x39, 0x22, 0x1f, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x4e, 0x40, 0x4c, 0x37, 0x4c, 0x40, 0x5b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x32, 0x32, 
	0x76, 0x67, 0x23, 0x22, 0x68, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x4e, 0x40, 0x69, 0x37, 0x30, 0x30, 
	0x25, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x6d, 
	0x6d, 0x31, 0x2e, 0x34, 0x33, 0x3e, 0x11, 0x12, 0x13, 
	0x30, 0x1b, 0x2f, 0x42, 0x42, 0x48, 0x49, 0x37, 0x4f, 
	0x55, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 
	0x43, 0x43, 0x22, 0x34, 0x0f, 0x0f, 0x10, 0x11, 0x12, 
	0x13, 0x30, 0x1b, 0x2f, 0x42, 0x4e, 0x4e, 0x2f, 0x1b, 
	0x0a, 0x5b, 0x5b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 
	0x38, 0x5d, 0x56, 0x31, 0x1d, 0x0f, 0x29, 0x41, 0x3e, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x5a, 0x54, 0x42, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x78, 0x84, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x56, 0x5d, 0x6d, 0x31, 0x1d, 0x0f, 0x29, 0x41, 
	0x82, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x54, 0x5a, 0x48, 
	0x2f, 0x1b, 0x0a, 0x0a, 0x5b, 0x5b, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x43, 0x6d, 0x5d, 0x2d, 0x2d, 0x2e, 0x4a, 
	0x35, 0x11, 0x12, 0x13, 0x06, 0x03, 0x06, 0x1b, 0x2f, 
	0x42, 0x4e, 0x36, 0x47, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x43, 0x43, 0x31, 
	0x1d, 0xba, 0x21, 0x29, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x42, 0x5a, 0x36, 0x72, 0x1b, 0x0a, 0x3d, 0x75, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x43, 0x21, 0xbb, 
	0x31, 0x1d, 0x0f, 0x39, 0x74, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x2f, 0x42, 0x30, 0x65, 0x2f, 0x1b, 0x0a, 0x6a, 
	0x30, 0x0c, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 0x31, 
	0x43, 0x43, 0x43, 0x31, 0x1d, 0x67, 0x33, 0x10, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x42, 0x42, 0x42, 0x2f, 
	0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x43, 0x43, 0xb2, 0x76, 0x1d, 0x0f, 0x0f, 0x10, 
	0x11, 0x12, 0x13, 0x06, 0x03, 0x06, 0x1b, 0x2f, 0x42, 
	0x42, 0x42, 0x2f, 0x1b, 0x1b, 0x0a, 0xb8, 0xb9, 0xb1, 
	0x0d, 0xb0, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x1d, 
	0x31, 0x31, 0x32, 0x22, 0x76, 0x1d, 0x0f, 0x3b, 0x20, 
	0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x2f, 0x4c, 0x4c, 
	0x2f, 0x1b, 0x0a, 0x4c, 0x89, 0x0c, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x31, 0x32, 0x22, 0x2e, 0x1d, 0x0f, 0x34, 
	0x21, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x2f, 0x4c, 
	0x4c, 0x2f, 0x1b, 0x73, 0x62, 0x25, 0x0c, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x31, 0x32, 0x32, 0x76, 0x51, 0x34, 
	0x3b, 0x41, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x2f, 
	0x4e, 0x40, 0x69, 0x37, 0x6a, 0x30, 0x0b, 0x0c, 0x0d, 
	0x0d, 0x30, 0x1d, 0x31, 0x31, 0x00, 0x07, 0x22, 0x11, 
	0x12, 0x13, 0x30, 0x1b, 0x2f, 0x2f, 0x3c, 0x3c, 0x2f, 
	0x1b, 0x0a, 0x25, 0x25, 0x0c, 0x0d, 0x0d, 0x30, 0x1d, 
	0x31, 0x38, 0x22, 0x34, 0x31, 0x1d, 0x0f, 0x1f, 0x22, 
	0x7e, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x62, 0x37, 0x2f, 
	0x4e, 0x37, 0xb7, 0x0a, 0x59, 0x30, 0x0d, 0x0d, 0x30, 
	0x1d, 0x31, 0x31, 0x28, 0x22, 0x38, 0x1d, 0x0f, 0x32, 
	0x32, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 0x4e, 0x36, 
	0x49, 0x2f, 0x1b, 0x0a, 0x50, 0x36, 0x5b, 0x0d, 0x0d, 
	0x30, 0x1d, 0x31, 0x31, 0xbb, 0x32, 0x32, 0x28, 0x20, 
	0x22, 0x20, 0x11, 0x12, 0x13, 0x06, 0x03, 0x06, 0x1b, 
	0x2f, 0x2f, 0x37, 0x40, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x1d, 0x00, 0x05, 0x31, 0x1d, 
	0x74, 0x33, 0x10, 0x11, 0x12, 0x13, 0x30, 0x1b, 0x2f, 
	0x2f, 0x72, 0x40, 0x6b, 0x54, 0x73, 0x40, 0x5f, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x22, 0x46, 0x31, 
	0x1d, 0x0f, 0x20, 0x3b, 0x11, 0x12, 0x13, 0x30, 0x1b, 
	0x2f, 0x72, 0x36, 0x27, 0x2f, 0x1b, 0x0a, 0x61, 0x36, 
	0x66, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x1d, 0x00, 0x05, 
	0x31, 0x74, 0x22, 0x33, 0x10, 0x11, 0x12, 0x13, 0x30, 
	0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x0a, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0d, 0x30, 0x1d, 0x31, 0x31, 0x31, 0x46, 0x22, 
	0x74, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x06, 0x03, 
	0x06, 0x1b, 0x00, 0x05, 0x2f, 0x1b, 0x1b, 0x0a, 0xb8, 
	0xb9, 0xb1, 0x0d, 0xb0, 0x06, 0x07, 0x01, 0x01, 0x07, 
	0x06, 0x0f, 0x1d, 0x1d, 0x28, 0x39, 0x1d, 0x0f, 0x0f, 
	0x20, 0x20, 0x11, 0x12, 0x13, 0x30, 0x0a, 0x1b, 0x3f, 
	0x36, 0x27, 0x1b, 0x0a, 0x0a, 0x61, 0x36, 0x5b, 0x0d, 
	0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x28, 0x28, 0x1d, 0x0f, 
	0x0f, 0x4a, 0x22, 0x53, 0x12, 0x13, 0x30, 0x0a, 0x1b, 
	0x54, 0x36, 0x27, 0x1b, 0x0a, 0x0a, 0x25, 0x25, 0x0c, 
	0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x28, 0x22, 0x34, 
	0x0f, 0x0f, 0x20, 0x41, 0x11, 0x12, 0x13, 0x30, 0x0a, 
	0x1b, 0x1b, 0x37, 0x30, 0x1b, 0x0a, 0x0a, 0x0a, 0x0b, 
	0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x00, 0x04, 0x1d, 0x22, 
	0x34, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x30, 0x0a, 
	0x1b, 0x1b, 0x25, 0x25, 0x1b, 0x0a, 0x0a, 0x25, 0x25, 
	0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x39, 0x39, 
	0x1d, 0x0f, 0x0f, 0x74, 0x39, 0x11, 0x12, 0x13, 0x30, 
	0x0a, 0x1b, 0x69, 0x69, 0x1b, 0x27, 0x36, 0x6a, 0x0a, 
	0x3d, 0x94, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 0x43, 
	0x3b, 0x3b, 0x29, 0x52, 0x21, 0x3e, 0x11, 0x12, 0x13, 
	0x30, 0x0a, 0x1b, 0x1b, 0x4c, 0x62, 0x1b, 0x0a, 0x0a, 
	0x7b, 0x89, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x00, 0x05, 
	0x1d, 0x0f, 0x26, 0x21, 0x35, 0x11, 0x12, 0x13, 0x06, 
	0x03, 0x06, 0x0a, 0x1b, 0x1b, 0x25, 0x25, 0x6e, 0x40, 
	0x36, 0x75, 0x78, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x00, 
	0x05, 0x1d, 0x4a, 0x21, 0x29, 0x10, 0x11, 0x12, 0x13, 
	0x30, 0x0a, 0x1b, 0x1b, 0x1b, 0x50, 0x40, 0x62, 0x30, 
	0x6f, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 0x1d, 
	0x3b, 0x51, 0x1d, 0x0f, 0x0f, 0x3b, 0x22, 0x11, 0x12, 
	0x13, 0x30, 0x0a, 0x1b, 0x2a, 0x36, 0x2a, 0x1b, 0x0a, 
	0x0a, 0x55, 0x36, 0x84, 0x0d, 0x0d, 0x06, 0x03, 0x06, 
	0x0f, 0x00, 0x04, 0x1d, 0x74, 0x22, 0x22, 0x33, 0x10, 
	0x11, 0x12, 0x13, 0x30, 0x0a, 0x00, 0x05, 0x1b, 0x0a, 
	0x0a, 0x0a, 0x0b, 0x0c, 0x0d, 0x0d, 0x30, 0x0f, 0x1d, 
	0x1d, 0x1d, 0x34, 0x22, 0x22, 0x67, 0x0f, 0x10, 0x11, 
	0x12, 0x13, 0x06, 0x03, 0x06, 0x00, 0x07, 0x1b, 0x0a, 
	0x0a, 0xb8, 0xb9, 0xb1, 0x0d, 0xb0, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 0x0f, 
	0x0f, 0x0f, 0x20, 0x20, 0x12, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x2b, 0x36, 0x2b, 0x0a, 0x0a, 0x0a, 0x59, 0x36, 
	0x90, 0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 
	0x0f, 0x0f, 0x0f, 0x41, 0x22, 0x80, 0x12, 0x13, 0x30, 
	0x0a, 0x0a, 0x2b, 0x36, 0x2b, 0x0a, 0x0a, 0x0a, 0x25, 
	0x25, 0x0d, 0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 
	0x39, 0x0f, 0x0f, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 
	0x30, 0x0a, 0x0a, 0x0a, 0x61, 0x36, 0x4f, 0x50, 0x0a, 
	0x0b, 0x0c, 0x0d, 0x0d, 0x0d, 0x30, 0x00, 0x05, 0x0f, 
	0x22, 0x33, 0x0f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x30, 
	0x0a, 0x0a, 0x0a, 0x25, 0x25, 0x0a, 0x0a, 0x0a, 0x25, 
	0x25, 0x0d, 0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x52, 
	0x22, 0x53, 0x0f, 0x29, 0x22, 0x68, 0x12, 0x12, 0x13, 
	0x30, 0x0a, 0x0a, 0x4f, 0x30, 0x0a, 0x7b, 0x24, 0x25, 
	0x0b, 0x94, 0xbc, 0x0d, 0x0d, 0x30, 0x00, 0x04, 0x0f, 
	0x4a, 0x22, 0x74, 0x21, 0x79, 0x11, 0x12, 0x12, 0x13, 
	0x30, 0x0a, 0x0a, 0x0a, 0x55, 0x36, 0x61, 0x0a, 0x2c, 
	0x36, 0x90, 0x0d, 0x0d, 0x0d, 0x30, 0x00, 0x06, 0x0f, 
	0xbd, 0x22, 0x79, 0x11, 0x12, 0x12, 0x13, 0x06, 0x03, 
	0x06, 0x0a, 0x0a, 0x0a, 0x25, 0x40, 0x6b, 0x2c, 0x50, 
	0x62, 0x89, 0x0d, 0x0d, 0x0d, 0x30, 0x00, 0x06, 0x0f, 
	0x39, 0x1f, 0x10, 0x11, 0x12, 0x12, 0x13, 0x30, 0x00, 
	0x04, 0x0a, 0x24, 0x40, 0x4c, 0x36, 0x89, 0x66, 0x0d, 
	0x0d, 0x0d, 0x30, 0x0f, 0x0f, 0x0f, 0x2d, 0x22, 0x34, 
	0x4a, 0x74, 0x32, 0x22, 0x12, 0x12, 0x13, 0x30, 0x0a, 
	0x0a, 0x2b, 0x36, 0x2b, 0x0a, 0x0a, 0x0a, 0x59, 0x36, 
	0x90, 0x0d, 0x0d, 0x06, 0x03, 0x06, 0x00, 0x04, 0x0f, 
	0x67, 0x22, 0x22, 0x22, 0x60, 0x11, 0x12, 0x12, 0x13, 
	0x30, 0x0a, 0x0a, 0x5e, 0x4f, 0x4f, 0x4f, 0x3d, 0x3d, 
	0x3d, 0x77, 0x77, 0x70, 0x0d, 0x30, 0x00, 0x04, 0x0f, 
	0x34, 0x22, 0x22, 0x22, 0x67, 0x11, 0x12, 0x12, 0x13, 
	0x06, 0x03, 0x06, 0x0a, 0x00, 0x05, 0x1b, 0xbe, 0xb8, 
	0xaf, 0xb1, 0xb9, 0xb1, 0x0d, 0xb0, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 0x0f, 
	0x0f, 0x10, 0x20, 0x20, 0x12, 0x13, 0x16, 0x30, 0x0a, 
	0x0a, 0x55, 0x36, 0x55, 0x0a, 0x0a, 0x0b, 0x84, 0x36, 
	0x90, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 0x20, 
	0x0f, 0x0f, 0x10, 0x53, 0x22, 0x7e, 0x13, 0x16, 0x30, 
	0x0a, 0x0a, 0x55, 0x36, 0x55, 0x0a, 0x0a, 0x0b, 0x25, 
	0x25, 0x0d, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 0x20, 
	0x20, 0x0f, 0x0f, 0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 
	0x30, 0x00, 0x04, 0x0a, 0x24, 0x40, 0x36, 0x75, 0x8f, 
	0x0c, 0x0d, 0x0d, 0x83, 0x30, 0x00, 0x05, 0x0f, 0x22, 
	0x33, 0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 0x30, 0x0a, 
	0x0a, 0x0a, 0x25, 0x25, 0x0a, 0x0a, 0x0b, 0x25, 0x25, 
	0x0d, 0x0d, 0x83, 0x30, 0x0f, 0x0f, 0x0f, 0x29, 0x21, 
	0x1e, 0x0f, 0x4b, 0x21, 0x82, 0x12, 0x13, 0x16, 0x30, 
	0x0a, 0x0a, 0x5f, 0x36, 0x0a, 0x62, 0x5b, 0x36, 0x0c, 
	0x30, 0x90, 0x0d, 0x83, 0x30, 0x00, 0x05, 0x0f, 0x34, 
	0x22, 0x20, 0x11, 0x11, 0x12, 0x13, 0x16, 0x30, 0x00, 
	0x04, 0x0a, 0x62, 0x4c, 0x0a, 0x3d, 0x62, 0x0c, 0x0d, 
	0x0d, 0x83, 0x30, 0x00, 0x05, 0x0f, 0x53, 0x22, 0x68, 
	0x11, 0x11, 0x12, 0x13, 0x16, 0x06, 0x03, 0x06, 0x0a, 
	0x0a, 0x0a, 0x25, 0x36, 0x2c, 0x0a, 0x0b, 0x70, 0x36, 
	0x97, 0x0d, 0x83, 0x30, 0x00, 0x05, 0x0f, 0x1f, 0x3b, 
	0x10, 0x11, 0x11, 0x12, 0x13, 0x16, 0x30, 0x0a, 0x0a, 
	0x0a, 0x61, 0x36, 0x5b, 0x0a, 0x5f, 0x9e, 0x30, 0x0d, 
	0x0d, 0x83, 0x30, 0x00, 0x04, 0x0f, 0x79, 0x74, 0x20, 
	0x79, 0x4b, 0x21, 0x12, 0x13, 0x16, 0x30, 0x0a, 0x0a, 
	0x55, 0x36, 0x55, 0x0a, 0x0a, 0x0b, 0x84, 0x36, 0x90, 
	0x0d, 0x83, 0x06, 0x03, 0x06, 0x0f, 0x0f, 0x0f, 0x29, 
	0x39, 0x22, 0x22, 0x22, 0x4b, 0x11, 0x12, 0x13, 0x16, 
	0x30, 0x0a, 0x0a, 0x0a, 0x6b, 0x00, 0x06, 0x36, 0x30, 
	0xbf, 0x83, 0x30, 0x00, 0x04, 0x0f, 0x33, 0x22, 0x22, 
	0x22, 0x39, 0x82, 0x12, 0x13, 0x16, 0x06, 0x03, 0x06, 
	0x00, 0x05, 0x0a, 0x73, 0x24, 0x25, 0xc0, 0xb1, 0xb9, 
	0xa1, 0xb0, 0x83, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 
	0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x11, 0x20, 
	0x74, 0x13, 0x16, 0x16, 0x30, 0x0b, 0x0b, 0x0b, 0x40, 
	0xc1, 0x0b, 0x0b, 0x0c, 0xc1, 0x9e, 0x0d, 0x83, 0x83, 
	0x30, 0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x11, 
	0x88, 0x21, 0x13, 0x16, 0x16, 0x30, 0x0b, 0x0b, 0x78, 
	0x36, 0x70, 0x0b, 0x0b, 0x66, 0x62, 0x8a, 0x0d, 0x83, 
	0x83, 0x30, 0x10, 0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 
	0x11, 0x11, 0x12, 0x13, 0x16, 0x16, 0x30, 0x00, 0x06, 
	0x0b, 0x5f, 0x89, 0x36, 0xa1, 0x0d, 0x83, 0x83, 0x30, 
	0x00, 0x05, 0x10, 0x22, 0x60, 0x11, 0x11, 0x12, 0x13, 
	0x16, 0x16, 0x30, 0x0b, 0x0b, 0x0b, 0x25, 0x25, 0x0b, 
	0x0b, 0x0c, 0x25, 0x8a, 0x0d, 0x83, 0x83, 0x30, 0x00, 
	0x04, 0x10, 0x34, 0x21, 0x10, 0x39, 0x88, 0x12, 0x13, 
	0x16, 0x16, 0x30, 0x0b, 0x0b, 0x66, 0x36, 0x6f, 0x30, 
	0x0b, 0x30, 0x84, 0x36, 0x0d, 0x83, 0x83, 0x30, 0x00, 
	0x04, 0x10, 0x3e, 0x39, 0xc2, 0x21, 0x7e, 0x12, 0x13, 
	0x16, 0x16, 0x30, 0x00, 0x04, 0x0b, 0x4f, 0x36, 0x59, 
	0x9e, 0x70, 0x0d, 0x0d, 0x83, 0x83, 0x30, 0x00, 0x04, 
	0x10, 0x35, 0x21, 0x67, 0x11, 0x11, 0x12, 0x13, 0x16, 
	0x16, 0x06, 0x03, 0x06, 0x0b, 0x0b, 0x0b, 0xc1, 0x36, 
	0x0b, 0x0b, 0x0c, 0x84, 0x36, 0x90, 0x83, 0x83, 0x30, 
	0x00, 0x05, 0x10, 0x3b, 0x60, 0x11, 0x11, 0x12, 0x13, 
	0x16, 0x16, 0x30, 0x0b, 0x0b, 0x0b, 0x25, 0x25, 0x0b, 
	0x0b, 0x0c, 0x58, 0x36, 0x90, 0x83, 0x83, 0x30, 0x00, 
	0x07, 0x10, 0x11, 0x20, 0x67, 0x13, 0x16, 0x16, 0x30, 
	0x0b, 0x0b, 0x0b, 0x36, 0x4f, 0x0b, 0x0b, 0x0c, 0xbc, 
	0x36, 0x0d, 0x83, 0x83, 0x06, 0x03, 0x06, 0x00, 0x04, 
	0x10, 0x3e, 0x39, 0x22, 0x22, 0x4b, 0x12, 0x13, 0x16, 
	0x16, 0x30, 0x00, 0x04, 0x0b, 0x94, 0x00, 0x04, 0x36, 
	0x30, 0xbf, 0x83, 0x83, 0x30, 0x00, 0x04, 0x10, 0x60, 
	0x22, 0x22, 0x39, 0x82, 0x12, 0x13, 0x16, 0x16, 0x06, 
	0x03, 0x06, 0x00, 0x04, 0xaf, 0xc3, 0xc4, 0x62, 0x84, 
	0x0c, 0xb1, 0xb9, 0xa1, 0xb0, 0x83, 0x06, 0x07, 0x01, 
	0x01, 0x07, 0x06, 0x11, 0x11, 0x11, 0x20, 0x20, 0x11, 
	0x11, 0x12, 0x74, 0x74, 0x13, 0x16, 0x87, 0x30, 0x0c, 
	0x0c, 0x0c, 0x77, 0x9e, 0x8f, 0x0c, 0xa1, 0x9e, 0x0e, 
	0x0d, 0x83, 0x8e, 0x30, 0x11, 0x11, 0x11, 0x20, 0x22, 
	0x1f, 0x11, 0x7e, 0x21, 0x4b, 0x13, 0x16, 0x87, 0x30, 
	0x0c, 0x0c, 0x0c, 0x89, 0x30, 0x66, 0x5b, 0x94, 0x98, 
	0x8a, 0x0d, 0x83, 0x8e, 0x30, 0x11, 0x11, 0x11, 0x20, 
	0x20, 0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0x16, 0x87, 
	0x30, 0x00, 0x07, 0x0c, 0x0d, 0x30, 0x0e, 0x0d, 0x83, 
	0x8e, 0x30, 0x00, 0x05, 0x11, 0x22, 0x4b, 0x12, 0x12, 
	0x13, 0x13, 0x16, 0x87, 0x30, 0x0c, 0x0c, 0x0c, 0x25, 
	0x25, 0x0c, 0x0c, 0x97, 0x9e, 0x8a, 0x0d, 0x83, 0x8e, 
	0x30, 0x00, 0x04, 0x11, 0x3e, 0x22, 0x4b, 0x22, 0x82, 
	0x13, 0x13, 0x16, 0x87, 0x30, 0x0c, 0x0c, 0x0c, 0x9e, 
	0x25, 0x77, 0x0c, 0x8d, 0x6c, 0x30, 0x0d, 0x83, 0x8e, 
	0x30, 0x00, 0x04, 0x11, 0x67, 0x39, 0x82, 0x21, 0x39, 
	0x13, 0x13, 0x16, 0x87, 0x30, 0x00, 0x04, 0x0c, 0x66, 
	0x9e, 0x81, 0x9e, 0x9d, 0x0d, 0x0d, 0x83, 0x8e, 0x30, 
	0x11, 0x11, 0x11, 0x82, 0x39, 0x20, 0x11, 0x12, 0x12, 
	0x13, 0x13, 0x16, 0x87, 0x06, 0x03, 0x06, 0x0c, 0x0c, 
	0x0c, 0x70, 0x36, 0x5b, 0x0c, 0x0d, 0x99, 0x36, 0x91, 
	0x83, 0x8e, 0x30, 0x00, 0x04, 0x11, 0x68, 0x22, 0x3e, 
	0x12, 0x12, 0x13, 0x13, 0x16, 0x87, 0x30, 0x0c, 0x0c, 
	0x0c, 0x25, 0x30, 0x0c, 0x0c, 0x0d, 0x90, 0x36, 0xa1, 
	0x83, 0x8e, 0x30, 0x00, 0x07, 0x11, 0x82, 0x22, 0x79, 
	0x13, 0x16, 0x87, 0x30, 0x0c, 0x0c, 0x0c, 0x3c, 0x94, 
	0x0c, 0x0c, 0x0d, 0x94, 0x9a, 0x0d, 0x83, 0x8e, 0x06, 
	0x03, 0x06, 0x00, 0x05, 0x11, 0x82, 0x39, 0x22, 0x4b, 
	0x13, 0x13, 0x16, 0x87, 0x30, 0x00, 0x05, 0x0c, 0x6c, 
	0x36, 0x36, 0x30, 0xbf, 0x0d, 0x83, 0x8e, 0x30, 0x00, 
	0x04, 0x11, 0x4b, 0x22, 0x39, 0x10, 0x12, 0x13, 0x13, 
	0x16, 0x87, 0x06, 0x03, 0x06, 0x0c, 0x0c, 0x0c, 0x66, 
	0x3c, 0x98, 0x99, 0xb1, 0xb1, 0x70, 0x9e, 0xc5, 0x83, 
	0x8e, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x12, 0x12, 
	0x12, 0x88, 0x88, 0x12, 0x12, 0x12, 0x88, 0x88, 0x16, 
	0x87, 0x9c, 0x30, 0x00, 0x04, 0x0d, 0x77, 0x98, 0x36, 
	0x98, 0x0e, 0x83, 0x83, 0x8e, 0x9b, 0x30, 0x12, 0x12, 
	0x12, 0x74, 0x74, 0x88, 0x22, 0x21, 0x88, 0x16, 0x16, 
	0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x9d, 0x1c, 0x36, 
	0x98, 0xa1, 0x8a, 0x8a, 0x83, 0x8e, 0x9b, 0x30, 0x12, 
	0x12, 0x12, 0x74, 0x74, 0x12, 0x12, 0x12, 0x13, 0x16, 
	0x16, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0xbc, 0x95, 
	0x0d, 0x0d, 0x95, 0x36, 0xc5, 0x83, 0x8e, 0x9b, 0x30, 
	0x00, 0x05, 0x12, 0x39, 0x39, 0x82, 0x13, 0x7f, 0x7f, 
	0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x94, 0x36, 0x95, 
	0x99, 0x30, 0x98, 0x8a, 0x83, 0x8e, 0x9b, 0x30, 0x00, 
	0x05, 0x12, 0x20, 0x22, 0x20, 0x13, 0x16, 0x16, 0x87, 
	0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x8a, 0x36, 0x90, 0x0d, 
	0x99, 0x36, 0x94, 0x83, 0x8e, 0x9b, 0x30, 0x12, 0x12, 
	0x12, 0x8b, 0x21, 0x7e, 0x12, 0x7d, 0x22, 0x88, 0x16, 
	0x87, 0x9c, 0x30, 0x00, 0x05, 0x0d, 0x94, 0x36, 0x77, 
	0x0d, 0x83, 0x83, 0x8e, 0x9b, 0x30, 0x12, 0x12, 0x12, 
	0x39, 0xc2, 0xa0, 0x80, 0x80, 0x7d, 0x7e, 0x16, 0x87, 
	0x9c, 0x06, 0x03, 0x06, 0x00, 0x04, 0x0d, 0x30, 0x3c, 
	0x9d, 0x92, 0x30, 0xa2, 0x83, 0x8e, 0x9b, 0x30, 0x00, 
	0x04, 0x12, 0x74, 0x74, 0x12, 0x12, 0x13, 0x16, 0x16, 
	0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x95, 0x36, 0xa3, 
	0x0d, 0x92, 0x30, 0x62, 0x83, 0x8e, 0x9b, 0x30, 0x12, 
	0x12, 0x12, 0x80, 0x7e, 0x12, 0x82, 0x39, 0x20, 0x16, 
	0x16, 0x87, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x97, 0x36, 
	0x70, 0x0d, 0x70, 0x36, 0x9f, 0x83, 0x8e, 0x9b, 0x06, 
	0x03, 0x06, 0x00, 0x06, 0x12, 0x10, 0x39, 0x4b, 0x16, 
	0x16, 0x87, 0x9c, 0x30, 0x00, 0x06, 0x0d, 0x6c, 0x30, 
	0xbf, 0x83, 0x83, 0x8e, 0x9b, 0x30, 0x00, 0x04, 0x12, 
	0x4b, 0x39, 0x10, 0x12, 0x13, 0x16, 0x16, 0x87, 0x9c, 
	0x06, 0x03, 0x06, 0x0c, 0x0c, 0x0c, 0xbc, 0x36, 0xb9, 
	0x89, 0x89, 0x89, 0x30, 0x9e, 0xa9, 0x8e, 0x8e, 0x06, 
	0x07, 0x01, 0x01, 0x07, 0x06, 0x00, 0x08, 0x13, 0x16, 
	0x16, 0x87, 0x9c, 0x9c, 0x30, 0x00, 0x08, 0x0d, 0x83, 
	0x83, 0x8e, 0x9b, 0x9b, 0x30, 0x13, 0x13, 0x13, 0x74, 
	0x74, 0x13, 0x13, 0x13, 0x16, 0x16, 0x87, 0x9c, 0x9c, 
	0x30, 0x00, 0x08, 0x0d, 0x8a, 0x8a, 0x8e, 0x9b, 0x9b, 
	0x30, 0x13, 0x13, 0x13, 0x88, 0x88, 0x13, 0x13, 0x13, 
	0x16, 0x16, 0x87, 0x9c, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 
	0x0e, 0x30, 0x36, 0x36, 0x30, 0xa9, 0x83, 0x8e, 0x9b, 
	0x9b, 0x30, 0x00, 0x05, 0x13, 0x3e, 0x32, 0x22, 0x22, 
	0x22, 0x96, 0x9c, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0x91, 
	0x1c, 0x36, 0x98, 0xc6, 0xa2, 0xa2, 0x8e, 0x9b, 0x9b, 
	0x30, 0x00, 0x05, 0x13, 0x80, 0x74, 0x80, 0x16, 0x16, 
	0x87, 0x9c, 0x9c, 0x30, 0x0d, 0x0d, 0x0d, 0xa3, 0x8a, 
	0x0d, 0x0d, 0x91, 0x8a, 0xa4, 0x8e, 0x9b, 0x9b, 0x30, 
	0x13, 0x13, 0x7f, 0x1e, 0x8b, 0x13, 0x13, 0x13, 0x8c, 
	0x74, 0x96, 0x9c, 0x9c, 0x30, 0x00, 0x05, 0x0d, 0x90, 
	0x36, 0x91, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x30, 0x13, 
	0x13, 0x13, 0x00, 0x07, 0x74, 0x87, 0x9c, 0x9c, 0x06, 
	0x03, 0x06, 0x00, 0x04, 0x0d, 0x91, 0x9a, 0x36, 0x9e, 
	0xa2, 0x92, 0x8e, 0x9b, 0x9b, 0x30, 0x00, 0x04, 0x13, 
	0x74, 0x79, 0x13, 0x13, 0x16, 0x16, 0x87, 0x9c, 0x9c, 
	0x30, 0x00, 0x04, 0x0d, 0xa9, 0x98, 0x36, 0x9e, 0x94, 
	0x92, 0x8e, 0x9b, 0x9b, 0x30, 0x13, 0x13, 0x13, 0x79, 
	0x3b, 0x22, 0x21, 0x88, 0x7f, 0x16, 0x87, 0x9c, 0x9c, 
	0x30, 0x00, 0x04, 0x0d, 0xa9, 0x98, 0x36, 0x98, 0xa9, 
	0x83, 0x8e, 0x9b, 0x9b, 0x06, 0x03, 0x06, 0x00, 0x07, 
	0x13, 0x96, 0x8b, 0x16, 0x87, 0x9c, 0x9c, 0x30, 0x00, 
	0x07, 0x0d, 0xbf, 0x83, 0x83, 0x8e, 0x9b, 0x9b, 0x30, 
	0x00, 0x04, 0x13, 0x8b, 0x96, 0x13, 0x13, 0x16, 0x16, 
	0x87, 0x9c, 0x9c, 0x06, 0x03, 0x06, 0x00, 0x04, 0x0d, 
	0x77, 0xb9, 0xbc, 0x9d, 0xbf, 0xbf, 0xc7, 0x8e, 0x8e, 
	0xc8, 0x06, 0x07, 0x01, 0x01, 0x07, 0x06, 0x00, 0x08, 
	0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x00, 0x08, 
	0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x16, 0x16, 
	0x16, 0x74, 0x74, 0x16, 0x16, 0x16, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x30, 0x00, 0x08, 0x83, 0x8a, 0x8a, 0x9b, 
	0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 
	0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 
	0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 
	0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 
	0x9c, 0xa6, 0x30, 0x00, 0x05, 0x83, 0x94, 0x94, 0x83, 
	0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 0x08, 0x16, 
	0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x06, 0x03, 0x06, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x30, 0x00, 
	0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0x30, 0x00, 
	0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 0x06, 0x03, 
	0x06, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 
	0x30, 0x00, 0x08, 0x83, 0x8e, 0x8e, 0x9b, 0x9b, 0xa5, 
	0x30, 0x00, 0x08, 0x16, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 
	0x06, 0x03, 0x06, 0x00, 0x04, 0xb0, 0x83, 0xa3, 0xb9, 
	0xa3, 0x83, 0x83, 0x8e, 0x8e, 0xc8, 0xa5, 0x06, 0x07, 
	0x01, 0x01, 0x07, 0x05, 0x00, 0x08, 0x87, 0x9c, 0x9c, 
	0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 0x8e, 0x9b, 0x9b, 
	0xa5, 0xa5, 0xac, 0x1c, 0x87, 0x87, 0x87, 0xc9, 0xc9, 
	0x87, 0x87, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x00, 0x08, 0x8e, 0xca, 0xca, 0xa5, 0xa5, 0xac, 0x1c, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x8e, 0x8e, 0x8e, 0xae, 0x06, 0x36, 0xa7, 0x8e, 0x9b, 
	0x9b, 0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 0x87, 0x9c, 
	0x9c, 0xa6, 0xa6, 0xad, 0x05, 0x03, 0x05, 0x00, 0x08, 
	0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 
	0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 
	0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 0x00, 0x08, 
	0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 0x00, 0x08, 
	0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x05, 0x03, 0x05, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x1c, 
	0x00, 0x08, 0x8e, 0x9b, 0x9b, 0xa5, 0xa5, 0xac, 0x1c, 
	0x00, 0x08, 0x87, 0x9c, 0x9c, 0xa6, 0xa6, 0xad, 0x05, 
	0x03, 0x05, 0x00, 0x06, 0x83, 0x05, 0xcb, 0xc7, 0x8e, 
	0xc8, 0xc8, 0xa5, 0xa5, 0x05, 0x07, 0x01, 0x01, 0x14, 
	0x17, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x9b, 0x9b, 0x9b, 0x89, 0x9a, 0xae, 0x9b, 0x9b, 
	0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x18, 0x00, 0x08, 0x9c, 
	0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x17, 0x19, 0x17, 0x00, 
	0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x18, 0x00, 
	0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x18, 0x00, 
	0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x18, 0x00, 
	0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 0x18, 0x00, 
	0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 0x17, 0x19, 
	0x17, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x18, 0x00, 0x08, 0x9b, 0xa5, 0xa5, 0xa5, 0xac, 0xac, 
	0x18, 0x00, 0x08, 0x9c, 0xa6, 0xa6, 0xa6, 0xad, 0xad, 
	0x17, 0x19, 0x17, 0x00, 0x07, 0x8e, 0x03, 0xc8, 0xc8, 
	0xc8, 0xa5, 0xac, 0xac, 0x17, 0x14, 0x01, 0x01, 0x08, 
	0x03, 0x09, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 0xac, 0x0e, 
	0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 0xad, 0x09, 
	0x03, 0x14, 0x03, 0x09, 0x00, 0x08, 0xa5, 0xac, 0xac, 
	0xac, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 
	0xad, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 
	0xac, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa6, 0xad, 0xad, 
	0xad, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa5, 0xac, 0xac, 
	0xac, 0x09, 0x03, 0x14, 0x03, 0x09, 0x00, 0x08, 0xa6, 
	0xad, 0xad, 0xad, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa5, 
	0xac, 0xac, 0xac, 0x0e, 0x04, 0x0e, 0x00, 0x08, 0xa6, 
	0xad, 0xad, 0xad, 0x09, 0x03, 0x14, 0x03, 0x09, 0x00, 
	0x08, 0xc8, 0xa5, 0xa5, 0xac, 0xac, 0x09, 0x03, 0x08, 
	0x01, 0x00, 0x00 
};

// *************************************************************************
//								STATIC ICONS
// *************************************************************************

// File menu

unsigned char item_disk_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0x93, 0x7d, 0x2d, 
	0x7b, 0x68, 0x25, 
	0xc1, 0xaf, 0x6b, 
	0xa3, 0x94, 0x59, 
	0x05, 0x04, 0x00, 
	0x55, 0x48, 0x15, 
	0xa0, 0x87, 0x2f, 
	0xa3, 0x8b, 0x33, 
	0xdf, 0xcc, 0x88, 
	0xe4, 0xd0, 0x89, 
	0xc7, 0xaf, 0x62, 
	0xab, 0x9a, 0x51, 
	0x16, 0x10, 0x01, 
	0x0a, 0x09, 0x00, 
	0x7a, 0x67, 0x24, 
	0xac, 0x93, 0x3b, 
	0xb0, 0x97, 0x3f, 
	0xf1, 0xdc, 0x94, 
	0xd9, 0xc2, 0x73, 
	0xdb, 0xc3, 0x6a, 
	0xca, 0xb2, 0x54, 
	0xaa, 0x99, 0x4e, 
	0x90, 0x79, 0x2a, 
	0x9d, 0x84, 0x2d, 
	0xe2, 0xcc, 0x72, 
	0xf3, 0xda, 0x77, 
	0xe3, 0xcc, 0x69, 
	0xe3, 0xca, 0x62, 
	0xdb, 0xc3, 0x64, 
	0xc8, 0xad, 0x59, 
	0xa1, 0x90, 0x53, 
	0x75, 0x62, 0x21, 
	0x8d, 0x76, 0x28, 
	0x96, 0x7e, 0x2a, 
	0xde, 0xc5, 0x5a, 
	0xe7, 0xd1, 0x64, 
	0xe5, 0xcb, 0x5e, 
	0xd2, 0xb8, 0x69, 
	0xbd, 0xa9, 0x62, 
	0x9c, 0x8c, 0x53, 
	0x8a, 0x74, 0x26, 
	0x09, 0x09, 0x04, 
	0xd4, 0xbb, 0x64, 
	0xe0, 0xc5, 0x5e, 
	0xe3, 0xc7, 0x64, 
	0xd6, 0xc0, 0x67, 
	0xcd, 0xb3, 0x64, 
	0xbd, 0xa9, 0x5b, 
	0x9d, 0x8d, 0x4e, 
	0x72, 0x60, 0x1e, 
	0xd0, 0xba, 0x72, 
	0xd3, 0xb8, 0x51, 
	0xd1, 0xb5, 0x59, 
	0xe0, 0xc7, 0x6e, 
	0x8f, 0x78, 0x25, 
	0x88, 0x71, 0x23, 
	0xc4, 0xb0, 0x65, 
	0xd4, 0xba, 0x5c, 
	0xc4, 0xae, 0x5b, 
	0x98, 0x7f, 0x23, 
	0x84, 0x6e, 0x21, 
	0x8e, 0x76, 0x24, 
	0x93, 0x7a, 0x24, 
	0x86, 0x70, 0x21, 
	0x71, 0x5e, 0x1d, 
	0xba, 0xa5, 0x5d, 
	0xb6, 0xa1, 0x5a, 
	0xbf, 0xa8, 0x52, 
	0xc3, 0xac, 0x52, 
	0xc5, 0xac, 0x4b, 
	0x5a, 0x4b, 0x16, 
	0x75, 0x61, 0x1d, 
	0x89, 0x71, 0x1d, 
	0x6d, 0x61, 0x35, 
	0x77, 0x69, 0x3a, 
	0x83, 0x74, 0x40, 
	0x94, 0x84, 0x48, 
	0xb1, 0x9e, 0x53, 
	0xb8, 0xa4, 0x52, 
	0xc5, 0xab, 0x47, 
	0x34, 0x2b, 0x0d, 
	0x7a, 0x65, 0x1d, 
	0x84, 0x6c, 0x1d, 
	0x89, 0x70, 0x1b, 
	0x8c, 0x74, 0x1e, 
	0x66, 0x54, 0x18, 
	0x16, 0x14, 0x0b, 
	0x38, 0x31, 0x1b, 
	0x63, 0x56, 0x2e, 
	0x89, 0x78, 0x40, 
	0xb6, 0xa1, 0x4f, 
	0xbb, 0xa3, 0x4d, 
	0xc1, 0xa7, 0x4a, 
	0xbf, 0xa5, 0x4b, 
	0xb3, 0x9c, 0x46, 
	0xc2, 0xc2, 0xc2, 
	0x4e, 0x4e, 0x4e, 
	0x57, 0x4c, 0x23, 
	0x81, 0x69, 0x15, 
	0x83, 0x6d, 0x20, 
	0x23, 0x1d, 0x08, 
	0x3d, 0x36, 0x1a, 
	0x6f, 0x62, 0x2f, 
	0xac, 0x97, 0x48, 
	0xa8, 0x93, 0x42, 
	0xb8, 0xa1, 0x47, 
	0xb8, 0xa0, 0x48, 
	0xb6, 0x9f, 0x49, 
	0xaf, 0x99, 0x47, 
	0xff, 0xff, 0xff, 
	0x85, 0x6d, 0x19, 
	0x6f, 0x5c, 0x1b, 
	0x11, 0x4d, 0x81, 
	0x26, 0x71, 0xa5, 
	0x26, 0x6e, 0xa4, 
	0x1c, 0x5e, 0x94, 
	0x0b, 0x3d, 0x69, 
	0x45, 0x3d, 0x1d, 
	0xaa, 0x95, 0x49, 
	0xac, 0x97, 0x47, 
	0xaa, 0x94, 0x45, 
	0xa8, 0x93, 0x45, 
	0x28, 0x79, 0xa9, 
	0x35, 0x81, 0xb4, 
	0x3e, 0x87, 0xb9, 
	0x33, 0x7b, 0xaf, 
	0x21, 0x65, 0x9e, 
	0x21, 0x61, 0x9c, 
	0x1e, 0x5b, 0x98, 
	0x15, 0x4e, 0x8a, 
	0x44, 0x3b, 0x1e, 
	0x99, 0x84, 0x39, 
	0xa2, 0x8d, 0x41, 
	0x9e, 0x89, 0x3d, 
	0x32, 0x29, 0x0a, 
	0x81, 0x69, 0x19, 
	0x2d, 0x80, 0xb0, 
	0x3b, 0x89, 0xbb, 
	0x65, 0xa5, 0xd0, 
	0x58, 0x9d, 0xcc, 
	0x4a, 0x8f, 0xc2, 
	0x2f, 0x71, 0xaa, 
	0x1d, 0x58, 0x96, 
	0x19, 0x51, 0x82, 
	0x0e, 0x42, 0x85, 
	0x7a, 0x6a, 0x31, 
	0x95, 0x7f, 0x35, 
	0x9d, 0x87, 0x3c, 
	0xa1, 0x8b, 0x40, 
	0x88, 0x6f, 0x1b, 
	0x59, 0x49, 0x12, 
	0x7f, 0x69, 0x1e, 
	0x0e, 0x62, 0x91, 
	0x4b, 0x98, 0xcb, 
	0xd1, 0xf0, 0xfe, 
	0x93, 0xda, 0xfe, 
	0x56, 0x9a, 0xd0, 
	0x38, 0x78, 0xb2, 
	0x28, 0x65, 0xa2, 
	0x1c, 0x54, 0x94, 
	0x1c, 0x55, 0x7d, 
	0x2a, 0x55, 0x76, 
	0x13, 0x24, 0x3e, 
	0x8b, 0x75, 0x2b, 
	0x99, 0x83, 0x37, 
	0x95, 0x7f, 0x32, 
	0x30, 0x27, 0x09, 
	0x70, 0x5c, 0x16, 
	0x3e, 0x89, 0xbd, 
	0x52, 0x9d, 0xd1, 
	0x7c, 0xc3, 0xfa, 
	0x6e, 0xb2, 0xeb, 
	0x51, 0x92, 0xcc, 
	0x39, 0x77, 0xb2, 
	0x20, 0x5e, 0x9b, 
	0x1b, 0x52, 0x93, 
	0x2b, 0x55, 0x70, 
	0x32, 0x55, 0x67, 
	0x13, 0x29, 0x4e, 
	0x23, 0x1e, 0x0e, 
	0x7c, 0x67, 0x1e, 
	0x91, 0x7a, 0x2d, 
	0x63, 0x51, 0x12, 
	0x80, 0x6b, 0x23, 
	0x2a, 0x77, 0xaa, 
	0x45, 0x88, 0xc1, 
	0x44, 0x84, 0xbf, 
	0x3a, 0x78, 0xb4, 
	0x2c, 0x67, 0xa4, 
	0x1c, 0x53, 0x81, 
	0x2f, 0x56, 0x69, 
	0x31, 0x52, 0x65, 
	0x11, 0x32, 0x6b, 
	0x05, 0x0d, 0x1c, 
	0x0e, 0x0c, 0x05, 
	0x75, 0x61, 0x1a, 
	0x2e, 0x25, 0x07, 
	0x6e, 0x5a, 0x13, 
	0x27, 0x74, 0xa7, 
	0x2a, 0x6d, 0xa6, 
	0x2d, 0x6c, 0xa7, 
	0x21, 0x5a, 0x99, 
	0x23, 0x53, 0x8c, 
	0x18, 0x57, 0x77, 
	0x2b, 0x54, 0x68, 
	0x2f, 0x4f, 0x6d, 
	0x0c, 0x34, 0x7f, 
	0x7c, 0x64, 0x13, 
	0x54, 0x44, 0x0d, 
	0x0a, 0x55, 0x89, 
	0x24, 0x6d, 0xa2, 
	0x1f, 0x5d, 0x99, 
	0x1c, 0x53, 0x94, 
	0x16, 0x5a, 0x73, 
	0x13, 0x5c, 0x6a, 
	0x23, 0x4d, 0x6a, 
	0x20, 0x38, 0x6a, 
	0x02, 0x26, 0x70, 
	0x53, 0x44, 0x13, 
	0x76, 0x5f, 0x11, 
	0x5d, 0x4d, 0x15, 
	0x07, 0x4d, 0x84, 
	0x17, 0x62, 0x84, 
	0x15, 0x60, 0x7d, 
	0x13, 0x63, 0x71, 
	0x11, 0x5e, 0x6c, 
	0x0b, 0x52, 0x6d, 
	0x13, 0x43, 0x64, 
	0x17, 0x33, 0x6d, 
	0x1f, 0x1a, 0x09, 
	0x32, 0x2a, 0x0c, 
	0x6e, 0x5b, 0x18, 
	0x6a, 0x55, 0x0d, 
	0x44, 0x38, 0x0e, 
	0x17, 0x55, 0x92, 
	0x16, 0x50, 0x8f, 
	0x0f, 0x51, 0x7a, 
	0x0a, 0x4a, 0x75, 
	0x05, 0x43, 0x6f, 
	0x02, 0x32, 0x6e, 
	0x05, 0x2d, 0x77, 
	0x3d, 0x32, 0x0e, 
	0x4d, 0x3f, 0x0f, 
	0x67, 0x55, 0x14, 
	0x79, 0x62, 0x13, 
	0x54, 0x45, 0x12, 
	0x02, 0x38, 0x77, 
	0x08, 0x3c, 0x7e, 
	0x03, 0x32, 0x76, 
	0x02, 0x2c, 0x72, 
	0x7e, 0x68, 0x19, 
	0x50, 0x41, 0x0f, 
	0x2d, 0x25, 0x09

};
unsigned char item_disk[] = { 
	0x00, 0xb0, 0x01, 0x02, 0x03, 0x00, 0x14, 0x01, 0x04, 
	0x05, 0x06, 0x06, 0x06, 0x00, 0x04, 0x01, 0x07, 0x08, 
	0x09, 0x09, 0x03, 0x00, 0x12, 0x01, 0x0a, 0x0b, 0x0c, 
	0x0d, 0x0e, 0x0f, 0x01, 0x01, 0x01, 0x10, 0x08, 0x09, 
	0x11, 0x12, 0x08, 0x10, 0x00, 0x0f, 0x01, 0x06, 0x13, 
	0x14, 0x15, 0x15, 0x16, 0x17, 0x0f, 0x01, 0x01, 0x18, 
	0x00, 0x06, 0x19, 0x00, 0x0f, 0x01, 0x06, 0x14, 0x1a, 
	0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x01, 0x01, 0x21, 
	0x22, 0x23, 0x19, 0x19, 0x07, 0x00, 0x0f, 0x01, 0x06, 
	0x14, 0x1c, 0x24, 0x25, 0x26, 0x25, 0x1e, 0x27, 0x28, 
	0x29, 0x01, 0x01, 0x21, 0x2a, 0x2a, 0x21, 0x00, 0x0f, 
	0x01, 0x2b, 0x27, 0x2c, 0x2d, 0x24, 0x26, 0x1d, 0x2e, 
	0x2f, 0x27, 0x30, 0x31, 0x32, 0x06, 0x01, 0x33, 0x2a, 
	0x2a, 0x07, 0x00, 0x0e, 0x01, 0x34, 0x30, 0x1e, 0x35, 
	0x1d, 0x35, 0x1e, 0x36, 0x37, 0x15, 0x2c, 0x0c, 0x31, 
	0x32, 0x01, 0x01, 0x38, 0x23, 0x39, 0x33, 0x00, 0x0c, 
	0x01, 0x28, 0x3a, 0x1f, 0x3b, 0x3b, 0x36, 0x3b, 0x36, 
	0x16, 0x3b, 0x36, 0x16, 0x1f, 0x3c, 0x3d, 0x01, 0x3e, 
	0x3f, 0x40, 0x40, 0x41, 0x42, 0x00, 0x0a, 0x01, 0x43, 
	0x44, 0x43, 0x3c, 0x45, 0x1f, 0x46, 0x46, 0x3b, 0x16, 
	0x35, 0x47, 0x36, 0x46, 0x3d, 0x06, 0x48, 0x49, 0x41, 
	0x4a, 0x40, 0x40, 0x40, 0x07, 0x00, 0x08, 0x01, 0x4b, 
	0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x45, 0x46, 0x46, 0x47, 
	0x51, 0x47, 0x47, 0x45, 0x3d, 0x06, 0x01, 0x52, 0x53, 
	0x54, 0x55, 0x38, 0x56, 0x57, 0x00, 0x0b, 0x01, 0x58, 
	0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x46, 0x5e, 0x5e, 0x5f, 
	0x60, 0x3d, 0x06, 0x61, 0x62, 0x01, 0x63, 0x41, 0x64, 
	0x65, 0x66, 0x00, 0x0d, 0x01, 0x2b, 0x67, 0x68, 0x69, 
	0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x40, 0x06, 0x6f, 0x6f, 
	0x6f, 0x01, 0x70, 0x4a, 0x71, 0x00, 0x09, 0x01, 0x72, 
	0x73, 0x74, 0x75, 0x72, 0x76, 0x01, 0x01, 0x77, 0x78, 
	0x79, 0x7a, 0x7a, 0x7b, 0x56, 0x01, 0x6f, 0x6f, 0x61, 
	0x01, 0x70, 0x39, 0x00, 0x09, 0x01, 0x7c, 0x7d, 0x7e, 
	0x7f, 0x80, 0x81, 0x82, 0x83, 0x01, 0x01, 0x84, 0x85, 
	0x86, 0x86, 0x87, 0x4a, 0x01, 0x6f, 0x6f, 0x62, 0x88, 
	0x89, 0x33, 0x00, 0x08, 0x01, 0x8a, 0x8b, 0x8c, 0x8d, 
	0x8e, 0x8f, 0x81, 0x90, 0x91, 0x92, 0x01, 0x01, 0x93, 
	0x94, 0x95, 0x96, 0x97, 0x01, 0x6f, 0x61, 0x01, 0x98, 
	0x99, 0x00, 0x08, 0x01, 0x9a, 0x7c, 0x9b, 0x9c, 0x9d, 
	0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0x01, 0x63, 
	0xa5, 0xa6, 0xa7, 0x70, 0x01, 0x6f, 0x62, 0xa8, 0xa9, 
	0x57, 0x00, 0x08, 0x01, 0x7c, 0xaa, 0xab, 0xac, 0xad, 
	0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0x01, 0xb5, 
	0xb6, 0xa7, 0xb7, 0x64, 0x01, 0x61, 0x01, 0xb8, 0xb9, 
	0x00, 0x09, 0x01, 0x7c, 0xba, 0xaa, 0xbb, 0xbc, 0xbd, 
	0xbe, 0xa1, 0xbf, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 
	0x22, 0xb7, 0x64, 0x01, 0x62, 0xc6, 0xc7, 0x57, 0x00, 
	0x09, 0x01, 0xc8, 0x74, 0x74, 0xc9, 0xca, 0xa0, 0xcb, 
	0xcc, 0xcd, 0xce, 0xcf, 0xd0, 0x01, 0x2b, 0x48, 0x39, 
	0x3e, 0xd1, 0x01, 0x01, 0xd2, 0x57, 0x00, 0x0a, 0x01, 
	0xd3, 0xd4, 0x80, 0x81, 0xd5, 0x90, 0xd6, 0xd7, 0xd8, 
	0xd9, 0xda, 0xdb, 0x01, 0xc4, 0xdc, 0xc5, 0x39, 0xdd, 
	0x01, 0xc6, 0xde, 0x57, 0x00, 0x0b, 0x01, 0xdf, 0x80, 
	0xb0, 0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0x01, 
	0x01, 0xe7, 0xe8, 0xe9, 0x89, 0xea, 0x01, 0xeb, 0x57, 
	0x00, 0x0d, 0x01, 0xec, 0xed, 0x83, 0xee, 0xef, 0xf0, 
	0xf1, 0xf2, 0x00, 0x04, 0x01, 0xf3, 0xf4, 0xf5, 0xf6, 
	0x01, 0xf7, 0x07, 0x00, 0x0e, 0x01, 0xf8, 0xf9, 0xfa, 
	0xfb, 0xfb, 0xdb, 0x00, 0x07, 0x01, 0xeb, 0xfc, 0x07, 
	0xfd, 0xfe, 0x00, 0x1d, 0x01, 0x07, 0x07, 0x00, 0x49, 
	0x01, 0x00, 0x00 
};

// Skip

unsigned char item_skip_colors[] = { 
	0xff, 0xff, 0xff, 
	0x04, 0x02, 0x04, 
	0xa4, 0xa6, 0xa4, 
	0x1c, 0x1a, 0x1c, 
	0x1c, 0x1e, 0x1c, 
	0x14, 0x16, 0x14, 
	0x9c, 0x9a, 0x9c, 
	0x94, 0x92, 0x94, 
	0x9c, 0x9e, 0x9c, 
	0x94, 0x96, 0x94, 
	0x8c, 0x8e, 0x8c, 
	0xdc, 0xda, 0xdc, 
	0xac, 0xae, 0xac, 
	0xac, 0xfe, 0x04, 
	0xbc, 0xba, 0xbc, 
	0x3c, 0x3a, 0x3c, 
	0x9c, 0xe6, 0x0c, 
	0x8c, 0x8a, 0x8c, 
	0x74, 0xae, 0x04, 
	0x8c, 0xce, 0x0c, 
	0x9c, 0xe2, 0x0c, 
	0x84, 0x86, 0x84, 
	0xfc, 0xd6, 0x8c, 
	0xfc, 0xd2, 0x8c, 
	0x74, 0xaa, 0x0c, 
	0x8c, 0xc6, 0x0c, 
	0x9c, 0xde, 0x0c, 
	0xa4, 0xa2, 0xa4, 
	0x7c, 0x7e, 0x7c, 
	0x64, 0x66, 0x64, 
	0xf4, 0xb2, 0x1c, 
	0xf4, 0xba, 0x44, 
	0x74, 0xa6, 0x0c, 
	0x94, 0xd6, 0x14, 
	0xfc, 0xb2, 0x24, 
	0xf4, 0xaa, 0x1c, 
	0xf4, 0xa6, 0x14, 
	0x6c, 0x9e, 0x14, 
	0x84, 0xc2, 0x04, 
	0x94, 0xce, 0x14, 
	0x94, 0xd2, 0x14, 
	0xcc, 0xca, 0xcc, 
	0xfc, 0xb6, 0x24, 
	0xec, 0xa6, 0x14, 
	0xdc, 0x92, 0x04, 
	0xec, 0xae, 0x3c, 
	0x74, 0xa2, 0x0c, 
	0x84, 0xba, 0x14, 
	0x8c, 0xca, 0x14, 
	0xa4, 0xfa, 0x04, 
	0xf4, 0xae, 0x1c, 
	0xec, 0x9e, 0x0c, 
	0xdc, 0x96, 0x04, 
	0xec, 0xaa, 0x3c, 
	0xa4, 0xee, 0x04, 
	0x74, 0x72, 0x74, 
	0xc4, 0xc2, 0xc4, 
	0xe4, 0x9e, 0x0c, 
	0xdc, 0x8e, 0x04, 
	0xd4, 0x8a, 0x04, 
	0xcc, 0x82, 0x04, 
	0xdc, 0xa2, 0x3c, 
	0xfc, 0xce, 0x84, 
	0x94, 0xda, 0x04, 
	0x5c, 0x5a, 0x5c, 
	0xec, 0xa2, 0x0c, 
	0xe4, 0x9a, 0x04, 
	0xcc, 0x7e, 0x04, 
	0xc4, 0x7a, 0x04, 
	0xd4, 0x92, 0x24, 
	0x24, 0x22, 0x24, 
	0x2c, 0x2a, 0x2c, 
	0xb4, 0xb2, 0xb4, 
	0xd4, 0x8e, 0x04, 
	0xbc, 0x76, 0x04, 
	0xf4, 0xc6, 0x7c, 
	0x54, 0x56, 0x54, 
	0x2c, 0x2e, 0x2c, 
	0x34, 0x32, 0x34, 
	0xd4, 0x86, 0x04, 
	0xc4, 0x7e, 0x04, 
	0xbc, 0x72, 0x04, 
	0xec, 0xbe, 0x6c, 
	0x64, 0x9a, 0x04, 
	0x6c, 0x6e, 0x6c, 
	0xac, 0xaa, 0xac, 
	0xcc, 0x86, 0x04, 
	0xe4, 0xb2, 0x5c, 
	0x4c, 0x4a, 0x4c, 
	0xdc, 0xa6, 0x4c, 
	0x6c, 0x6a, 0x6c, 
	0x5c, 0x5e, 0x5c, 
	0x0c, 0x0e, 0x0c, 
	0x84, 0x82, 0x84, 
	0x14, 0x12, 0x14, 
	0x64, 0x62, 0x64, 
	0x34, 0x36, 0x34, 
	0x74, 0x76, 0x74, 
	0x7c, 0x7a, 0x7c

};
unsigned char item_skip[] = { 
	0x00, 0x4a, 0x01, 0x02, 0x00, 0x1f, 0x01, 0x03, 0x02, 
	0x04, 0x00, 0x1d, 0x01, 0x05, 0x03, 0x05, 0x06, 0x07, 
	0x00, 0x1b, 0x01, 0x02, 0x03, 0x03, 0x08, 0x09, 0x08, 
	0x0a, 0x00, 0x19, 0x01, 0x0b, 0x0c, 0x05, 0x06, 0x08, 
	0x06, 0x06, 0x08, 0x0a, 0x00, 0x13, 0x01, 0x0d, 0x0d, 
	0x01, 0x01, 0x05, 0x0e, 0x05, 0x0f, 0x0f, 0x08, 0x06, 
	0x08, 0x06, 0x08, 0x0a, 0x00, 0x11, 0x01, 0x10, 0x10, 
	0x0d, 0x0d, 0x01, 0x01, 0x05, 0x0c, 0x07, 0x0f, 0x0f, 
	0x09, 0x06, 0x06, 0x08, 0x09, 0x11, 0x00, 0x0f, 0x01, 
	0x12, 0x13, 0x14, 0x14, 0x0d, 0x0d, 0x01, 0x01, 0x08, 
	0x02, 0x0a, 0x0f, 0x0f, 0x0a, 0x0a, 0x07, 0x15, 0x03, 
	0x02, 0x00, 0x0b, 0x01, 0x16, 0x17, 0x01, 0x01, 0x18, 
	0x19, 0x1a, 0x1a, 0x0d, 0x0d, 0x01, 0x01, 0x08, 0x1b, 
	0x15, 0x0f, 0x0f, 0x1c, 0x1d, 0x03, 0x03, 0x02, 0x00, 
	0x0a, 0x01, 0x1e, 0x1f, 0x17, 0x17, 0x01, 0x01, 0x20, 
	0x19, 0x21, 0x21, 0x0d, 0x0d, 0x01, 0x01, 0x09, 0x06, 
	0x15, 0x0f, 0x0f, 0x05, 0x04, 0x03, 0x00, 0x0a, 0x01, 
	0x22, 0x23, 0x24, 0x1f, 0x16, 0x17, 0x01, 0x01, 0x25, 
	0x26, 0x27, 0x28, 0x0d, 0x0d, 0x01, 0x07, 0x09, 0x06, 
	0x11, 0x05, 0x29, 0x05, 0x00, 0x0a, 0x01, 0x2a, 0x1e, 
	0x24, 0x2b, 0x2c, 0x2d, 0x17, 0x16, 0x01, 0x01, 0x2e, 
	0x2f, 0x30, 0x31, 0x01, 0x1c, 0x15, 0x07, 0x08, 0x03, 
	0x0b, 0x0e, 0x00, 0x0a, 0x01, 0x32, 0x23, 0x2b, 0x33, 
	0x34, 0x2c, 0x2c, 0x35, 0x16, 0x17, 0x01, 0x01, 0x30, 
	0x36, 0x01, 0x37, 0x1c, 0x11, 0x0a, 0x03, 0x05, 0x38, 
	0x00, 0x0a, 0x01, 0x32, 0x2b, 0x33, 0x39, 0x2c, 0x2c, 
	0x3a, 0x3b, 0x3c, 0x3d, 0x17, 0x3e, 0x01, 0x3f, 0x01, 
	0x40, 0x37, 0x1c, 0x0a, 0x03, 0x05, 0x03, 0x00, 0x0a, 
	0x01, 0x2b, 0x41, 0x42, 0x42, 0x2c, 0x3a, 0x3b, 0x3c, 
	0x43, 0x44, 0x45, 0x3e, 0x01, 0x26, 0x01, 0x46, 0x47, 
	0x1d, 0x11, 0x05, 0x48, 0x05, 0x00, 0x0c, 0x01, 0x34, 
	0x34, 0x2c, 0x3a, 0x49, 0x3c, 0x43, 0x4a, 0x43, 0x4b, 
	0x01, 0x12, 0x01, 0x4c, 0x1d, 0x4d, 0x4e, 0x05, 0x0c, 
	0x48, 0x00, 0x0e, 0x01, 0x3a, 0x49, 0x4f, 0x50, 0x43, 
	0x51, 0x44, 0x52, 0x01, 0x53, 0x01, 0x4c, 0x1d, 0x54, 
	0x11, 0x03, 0x05, 0x55, 0x00, 0x10, 0x01, 0x56, 0x50, 
	0x44, 0x51, 0x51, 0x57, 0x01, 0x01, 0x58, 0x4c, 0x1d, 
	0x37, 0x11, 0x05, 0x03, 0x05, 0x00, 0x12, 0x01, 0x50, 
	0x51, 0x51, 0x59, 0x01, 0x4d, 0x58, 0x40, 0x5a, 0x1c, 
	0x09, 0x05, 0x55, 0x05, 0x00, 0x10, 0x01, 0x5b, 0x5c, 
	0x01, 0x01, 0x51, 0x45, 0x01, 0x04, 0x46, 0x58, 0x1d, 
	0x5d, 0x09, 0x03, 0x02, 0x02, 0x00, 0x10, 0x01, 0x5d, 
	0x1c, 0x5e, 0x5b, 0x01, 0x01, 0x4c, 0x40, 0x58, 0x47, 
	0x4e, 0x5b, 0x07, 0x05, 0x03, 0x09, 0x00, 0x12, 0x01, 
	0x5c, 0x54, 0x1d, 0x5f, 0x5f, 0x1d, 0x5a, 0x54, 0x5b, 
	0x60, 0x0f, 0x05, 0x03, 0x03, 0x00, 0x14, 0x01, 0x4c, 
	0x54, 0x54, 0x54, 0x61, 0x61, 0x1c, 0x5d, 0x5d, 0x03, 
	0x09, 0x05, 0x00, 0x16, 0x01, 0x40, 0x61, 0x62, 0x1c, 
	0x1c, 0x0a, 0x0a, 0x03, 0x02, 0x02, 0x00, 0x18, 0x01, 
	0x5f, 0x1c, 0x09, 0x06, 0x07, 0x05, 0x03, 0x09, 0x00, 
	0x1a, 0x01, 0x54, 0x07, 0x09, 0x03, 0x03, 0x03, 0x00, 
	0x1c, 0x01, 0x54, 0x03, 0x0a, 0x04, 0x00, 0x1e, 0x01, 
	0x0a, 0x0a, 0x00, 0x46, 0x01, 0x00, 0x00 
};

// *************************************************************************
//								DYNAMIC ICONS
// *************************************************************************

// Sound

unsigned char item_soundOff_colors[] = { 
	0xff, 0xff, 0xff, 
	0x04, 0x02, 0x04, 
	0xac, 0xae, 0xac, 
	0xe4, 0xe2, 0xdc, 
	0xe4, 0xde, 0xdc, 
	0xac, 0xaa, 0xa4, 
	0xf4, 0xee, 0xec, 
	0xf4, 0xf6, 0xf4, 
	0xec, 0xee, 0xec, 
	0xdc, 0xda, 0xd4, 
	0xa4, 0xa6, 0xa4, 
	0xf4, 0xf2, 0xec, 
	0xdc, 0xd6, 0xd4, 
	0x9c, 0x9e, 0x9c, 
	0xac, 0xaa, 0x9c, 
	0xd4, 0xd2, 0xcc, 
	0xdc, 0xde, 0xd4, 
	0xcc, 0xce, 0xc4, 
	0x9c, 0x9a, 0x94, 
	0x74, 0x72, 0x5c, 
	0xcc, 0xca, 0xc4, 
	0xc4, 0xc6, 0xbc, 
	0x94, 0x96, 0x94, 
	0xec, 0xea, 0xe4, 
	0x6c, 0x6a, 0x54, 
	0xa4, 0xa2, 0x94, 
	0xcc, 0xc6, 0xbc, 
	0xc4, 0xc2, 0xbc, 
	0xbc, 0xbe, 0xb4, 
	0x94, 0x92, 0x8c, 
	0x6c, 0x66, 0x54, 
	0x64, 0x62, 0x54, 
	0x6c, 0x62, 0x4c, 
	0x9c, 0x9e, 0x8c, 
	0xc4, 0xc2, 0xb4, 
	0xbc, 0xba, 0xb4, 
	0x8c, 0x8a, 0x84, 
	0xd4, 0xd6, 0xcc, 
	0x64, 0x5e, 0x4c, 
	0xb4, 0xb6, 0xac, 
	0x9c, 0x9a, 0x8c, 
	0xbc, 0xb6, 0xac, 
	0x54, 0x56, 0x44, 
	0x5c, 0x56, 0x44, 
	0xb4, 0xb2, 0xac, 
	0x5c, 0x5a, 0x44, 
	0x44, 0x46, 0x44, 
	0x54, 0x52, 0x3c, 
	0xbc, 0xba, 0xac, 
	0x5c, 0x5a, 0x4c, 
	0xac, 0xae, 0xa4, 
	0xb4, 0xb2, 0xa4, 
	0x4c, 0x4a, 0x4c, 
	0x1c, 0x1a, 0x14, 
	0x44, 0x42, 0x34, 
	0xa4, 0xa2, 0x9c, 
	0x54, 0x52, 0x44, 
	0xb4, 0xb6, 0xb4, 
	0x2c, 0x2e, 0x2c, 
	0x2c, 0x2a, 0x24, 
	0x84, 0x82, 0x7c, 
	0x4c, 0x4a, 0x3c, 
	0x54, 0x4e, 0x3c, 
	0xb4, 0xae, 0xa4, 
	0x74, 0x76, 0x74, 
	0x3c, 0x3a, 0x2c, 
	0xac, 0xa6, 0x9c, 
	0x9c, 0x9e, 0x94, 
	0x94, 0x92, 0x94, 
	0x64, 0x5e, 0x54, 
	0x4c, 0x4e, 0x44, 
	0x6c, 0x66, 0x5c, 
	0x94, 0x92, 0x84, 
	0x6c, 0x6a, 0x64, 
	0x64, 0x66, 0x64, 
	0x64, 0x62, 0x5c, 
	0x8c, 0x8a, 0x7c, 
	0x84, 0x86, 0x84, 
	0x74, 0x72, 0x6c, 
	0x6c, 0x6e, 0x6c, 
	0x9c, 0x96, 0x8c, 
	0x84, 0x82, 0x74, 
	0x7c, 0x7a, 0x74, 
	0x6c, 0x6e, 0x64, 
	0xa4, 0xa6, 0x9c, 
	0x84, 0x86, 0x7c, 
	0x7c, 0x7a, 0x6c, 
	0x64, 0x62, 0x64, 
	0x5c, 0x5a, 0x54, 
	0xa4, 0x9e, 0x94, 
	0x74, 0x72, 0x64, 
	0x54, 0x56, 0x54, 
	0x3c, 0x3e, 0x3c, 
	0x84, 0x7e, 0x7c, 
	0xf4, 0xf2, 0xf4, 
	0xac, 0xaa, 0xac, 
	0x94, 0x96, 0x8c, 
	0x94, 0x8e, 0x84, 
	0x8c, 0x8e, 0x84, 
	0x34, 0x32, 0x34, 
	0x54, 0x56, 0x4c, 
	0x74, 0x76, 0x6c, 
	0x34, 0x36, 0x2c

};
unsigned char item_soundOff[] = { 
	0x00, 0x4b, 0x01, 0x02, 0x00, 0x1f, 0x01, 0x03, 0x04, 
	0x05, 0x00, 0x1d, 0x01, 0x06, 0x07, 0x08, 0x09, 0x0a, 
	0x00, 0x1b, 0x01, 0x0b, 0x0b, 0x0b, 0x03, 0x03, 0x0c, 
	0x0d, 0x00, 0x19, 0x01, 0x0b, 0x07, 0x0e, 0x0f, 0x10, 
	0x0c, 0x03, 0x11, 0x12, 0x00, 0x17, 0x01, 0x0b, 0x08, 
	0x13, 0x13, 0x0e, 0x11, 0x11, 0x0f, 0x14, 0x15, 0x16, 
	0x00, 0x15, 0x01, 0x17, 0x06, 0x18, 0x11, 0x18, 0x18, 
	0x19, 0x09, 0x14, 0x1a, 0x1b, 0x1c, 0x1d, 0x00, 0x13, 
	0x01, 0x04, 0x09, 0x18, 0x1e, 0x1a, 0x15, 0x1f, 0x20, 
	0x21, 0x1b, 0x1b, 0x22, 0x23, 0x23, 0x24, 0x00, 0x11, 
	0x01, 0x25, 0x14, 0x26, 0x27, 0x26, 0x26, 0x1c, 0x1b, 
	0x26, 0x26, 0x28, 0x23, 0x23, 0x29, 0x27, 0x00, 0x13, 
	0x01, 0x2a, 0x2b, 0x2c, 0x2c, 0x26, 0x26, 0x1c, 0x1c, 
	0x2d, 0x2d, 0x29, 0x27, 0x2c, 0x00, 0x11, 0x01, 0x0d, 
	0x2e, 0x01, 0x16, 0x2f, 0x2a, 0x2c, 0x30, 0x31, 0x2d, 
	0x23, 0x2b, 0x29, 0x32, 0x33, 0x00, 0x10, 0x01, 0x0d, 
	0x34, 0x01, 0x35, 0x36, 0x16, 0x37, 0x2b, 0x2b, 0x23, 
	0x27, 0x2b, 0x38, 0x2c, 0x33, 0x32, 0x00, 0x0f, 0x01, 
	0x39, 0x2e, 0x01, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x32, 
	0x33, 0x2b, 0x2b, 0x27, 0x2f, 0x32, 0x3f, 0x19, 0x00, 
	0x0f, 0x01, 0x1d, 0x01, 0x40, 0x34, 0x41, 0x36, 0x1d, 
	0x37, 0x2a, 0x2b, 0x27, 0x33, 0x38, 0x38, 0x42, 0x05, 
	0x43, 0x00, 0x0f, 0x01, 0x44, 0x01, 0x40, 0x45, 0x46, 
	0x47, 0x3d, 0x2f, 0x3f, 0x2c, 0x38, 0x38, 0x3f, 0x3e, 
	0x32, 0x43, 0x48, 0x00, 0x0f, 0x01, 0x1d, 0x01, 0x49, 
	0x4a, 0x4b, 0x1d, 0x12, 0x3c, 0x38, 0x38, 0x33, 0x2c, 
	0x3e, 0x3d, 0x42, 0x19, 0x4c, 0x00, 0x0f, 0x01, 0x4d, 
	0x01, 0x49, 0x4e, 0x4f, 0x1d, 0x43, 0x05, 0x32, 0x4c, 
	0x3e, 0x3e, 0x32, 0x3d, 0x50, 0x12, 0x51, 0x00, 0x0f, 
	0x01, 0x52, 0x01, 0x4a, 0x53, 0x3c, 0x1d, 0x54, 0x0e, 
	0x3f, 0x3f, 0x32, 0x55, 0x3d, 0x36, 0x28, 0x28, 0x56, 
	0x00, 0x0f, 0x01, 0x57, 0x01, 0x58, 0x4a, 0x56, 0x1d, 
	0x37, 0x0e, 0x05, 0x32, 0x0e, 0x0e, 0x59, 0x56, 0x19, 
	0x48, 0x5a, 0x00, 0x0f, 0x01, 0x5b, 0x01, 0x5c, 0x4b, 
	0x5d, 0x1d, 0x12, 0x54, 0x05, 0x42, 0x54, 0x19, 0x19, 
	0x28, 0x59, 0x55, 0x47, 0x00, 0x0c, 0x01, 0x1d, 0x44, 
	0x5b, 0x5c, 0x01, 0x01, 0x5c, 0x4e, 0x24, 0x59, 0x37, 
	0x0e, 0x19, 0x59, 0x19, 0x59, 0x1d, 0x48, 0x4c, 0x1f, 
	0x00, 0x0b, 0x01, 0x4d, 0x5e, 0x5f, 0x4f, 0x5c, 0x00, 
	0x04, 0x01, 0x47, 0x60, 0x19, 0x19, 0x37, 0x59, 0x43, 
	0x28, 0x61, 0x48, 0x4c, 0x45, 0x00, 0x0b, 0x01, 0x4d, 
	0x5f, 0x5f, 0x4f, 0x3a, 0x00, 0x06, 0x01, 0x53, 0x54, 
	0x19, 0x59, 0x28, 0x48, 0x62, 0x51, 0x51, 0x45, 0x00, 
	0x0b, 0x01, 0x5b, 0x4f, 0x4f, 0x63, 0x63, 0x00, 0x08, 
	0x01, 0x53, 0x28, 0x21, 0x61, 0x51, 0x61, 0x51, 0x64, 
	0x00, 0x0c, 0x01, 0x5c, 0x63, 0x3a, 0x00, 0x0b, 0x01, 
	0x53, 0x62, 0x48, 0x51, 0x51, 0x3d, 0x00, 0x1c, 0x01, 
	0x3d, 0x56, 0x65, 0x3d, 0x00, 0x1e, 0x01, 0x3d, 0x66, 
	0x00, 0x1e, 0x01, 0x3b, 0x00, 0x47, 0x01, 0x00, 0x00
 
};

unsigned char item_soundOn_colors[] = { 
	0xff, 0xff, 0xff, 
	0x04, 0x02, 0x04, 
	0xac, 0xae, 0xac, 
	0xe4, 0xe2, 0xdc, 
	0xe4, 0xde, 0xdc, 
	0xac, 0xaa, 0xa4, 
	0xf4, 0xee, 0xec, 
	0xf4, 0xf6, 0xf4, 
	0xec, 0xee, 0xec, 
	0xdc, 0xda, 0xd4, 
	0xa4, 0xa6, 0xa4, 
	0xf4, 0xf2, 0xec, 
	0xdc, 0xd6, 0xd4, 
	0x9c, 0x9e, 0x9c, 
	0xac, 0xaa, 0x9c, 
	0xd4, 0xd2, 0xcc, 
	0xdc, 0xde, 0xd4, 
	0xcc, 0xce, 0xc4, 
	0x9c, 0x9a, 0x94, 
	0x74, 0x72, 0x5c, 
	0xcc, 0xca, 0xc4, 
	0xc4, 0xc6, 0xbc, 
	0x94, 0x96, 0x94, 
	0xec, 0xea, 0xe4, 
	0x6c, 0x6a, 0x54, 
	0xa4, 0xa2, 0x94, 
	0xcc, 0xc6, 0xbc, 
	0xc4, 0xc2, 0xbc, 
	0xbc, 0xbe, 0xb4, 
	0x94, 0x92, 0x8c, 
	0x6c, 0x66, 0x54, 
	0x64, 0x62, 0x54, 
	0x6c, 0x62, 0x4c, 
	0x9c, 0x9e, 0x8c, 
	0xc4, 0xc2, 0xb4, 
	0xbc, 0xba, 0xb4, 
	0x8c, 0x8a, 0x84, 
	0xd4, 0xd6, 0xcc, 
	0x64, 0x5e, 0x4c, 
	0xb4, 0xb6, 0xac, 
	0x9c, 0x9a, 0x8c, 
	0xbc, 0xb6, 0xac, 
	0x54, 0x56, 0x44, 
	0x5c, 0x56, 0x44, 
	0xb4, 0xb2, 0xac, 
	0x5c, 0x5a, 0x44, 
	0x44, 0x46, 0x44, 
	0x54, 0x52, 0x3c, 
	0xbc, 0xba, 0xac, 
	0x5c, 0x5a, 0x4c, 
	0xac, 0xae, 0xa4, 
	0xb4, 0xb2, 0xa4, 
	0x4c, 0x4a, 0x4c, 
	0x1c, 0x1a, 0x14, 
	0x44, 0x42, 0x34, 
	0xa4, 0xa2, 0x9c, 
	0x54, 0x52, 0x44, 
	0xb4, 0xb6, 0xb4, 
	0x2c, 0x2e, 0x2c, 
	0x2c, 0x2a, 0x24, 
	0x84, 0x82, 0x7c, 
	0x4c, 0x4a, 0x3c, 
	0x54, 0x4e, 0x3c, 
	0xb4, 0xae, 0xa4, 
	0x74, 0x76, 0x74, 
	0x3c, 0x3a, 0x2c, 
	0xac, 0xa6, 0x9c, 
	0x9c, 0x9e, 0x94, 
	0x94, 0x92, 0x94, 
	0x64, 0x5e, 0x54, 
	0x4c, 0x4e, 0x44, 
	0x6c, 0x66, 0x5c, 
	0x94, 0x92, 0x84, 
	0x6c, 0x6a, 0x64, 
	0x64, 0x66, 0x64, 
	0x64, 0x62, 0x5c, 
	0x8c, 0x8a, 0x7c, 
	0x84, 0x86, 0x84, 
	0x74, 0x72, 0x6c, 
	0x6c, 0x6e, 0x6c, 
	0x9c, 0x96, 0x8c, 
	0x84, 0x82, 0x74, 
	0x7c, 0x7a, 0x7c, 
	0x6c, 0x6e, 0x64, 
	0xa4, 0xa6, 0x9c, 
	0x84, 0x86, 0x7c, 
	0x7c, 0x7a, 0x6c, 
	0x5c, 0x5a, 0x54, 
	0xa4, 0x9e, 0x94, 
	0x74, 0x72, 0x64, 
	0x54, 0x56, 0x54, 
	0x3c, 0x3e, 0x3c, 
	0x84, 0x7e, 0x7c, 
	0xfc, 0x6a, 0x6c, 
	0xbc, 0x02, 0x04, 
	0xfc, 0x02, 0x04, 
	0x94, 0x96, 0x8c, 
	0x94, 0x8e, 0x84, 
	0x8c, 0x8e, 0x84, 
	0x54, 0x56, 0x4c, 
	0x74, 0x76, 0x6c, 
	0x34, 0x36, 0x2c

};
unsigned char item_soundOn[] = { 
	0x00, 0x4b, 0x01, 0x02, 0x00, 0x1f, 0x01, 0x03, 0x04, 
	0x05, 0x00, 0x1d, 0x01, 0x06, 0x07, 0x08, 0x09, 0x0a, 
	0x00, 0x1b, 0x01, 0x0b, 0x0b, 0x0b, 0x03, 0x03, 0x0c, 
	0x0d, 0x00, 0x19, 0x01, 0x0b, 0x07, 0x0e, 0x0f, 0x10, 
	0x0c, 0x03, 0x11, 0x12, 0x00, 0x17, 0x01, 0x0b, 0x08, 
	0x13, 0x13, 0x0e, 0x11, 0x11, 0x0f, 0x14, 0x15, 0x16, 
	0x00, 0x15, 0x01, 0x17, 0x06, 0x18, 0x11, 0x18, 0x18, 
	0x19, 0x09, 0x14, 0x1a, 0x1b, 0x1c, 0x1d, 0x00, 0x13, 
	0x01, 0x04, 0x09, 0x18, 0x1e, 0x1a, 0x15, 0x1f, 0x20, 
	0x21, 0x1b, 0x1b, 0x22, 0x23, 0x23, 0x24, 0x00, 0x11, 
	0x01, 0x25, 0x14, 0x26, 0x27, 0x26, 0x26, 0x1c, 0x1b, 
	0x26, 0x26, 0x28, 0x23, 0x23, 0x29, 0x27, 0x00, 0x13, 
	0x01, 0x2a, 0x2b, 0x2c, 0x2c, 0x26, 0x26, 0x1c, 0x1c, 
	0x2d, 0x2d, 0x29, 0x27, 0x2c, 0x00, 0x11, 0x01, 0x0d, 
	0x2e, 0x01, 0x16, 0x2f, 0x2a, 0x2c, 0x30, 0x31, 0x2d, 
	0x23, 0x2b, 0x29, 0x32, 0x33, 0x00, 0x10, 0x01, 0x0d, 
	0x34, 0x01, 0x35, 0x36, 0x16, 0x37, 0x2b, 0x2b, 0x23, 
	0x27, 0x2b, 0x38, 0x2c, 0x33, 0x32, 0x00, 0x0f, 0x01, 
	0x39, 0x2e, 0x01, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x32, 
	0x33, 0x2b, 0x2b, 0x27, 0x2f, 0x32, 0x3f, 0x19, 0x00, 
	0x0f, 0x01, 0x1d, 0x01, 0x40, 0x34, 0x41, 0x36, 0x1d, 
	0x37, 0x2a, 0x2b, 0x27, 0x33, 0x38, 0x38, 0x42, 0x05, 
	0x43, 0x00, 0x0f, 0x01, 0x44, 0x01, 0x40, 0x45, 0x46, 
	0x47, 0x3d, 0x2f, 0x3f, 0x2c, 0x38, 0x38, 0x3f, 0x3e, 
	0x32, 0x43, 0x48, 0x00, 0x0f, 0x01, 0x1d, 0x01, 0x49, 
	0x4a, 0x4b, 0x1d, 0x12, 0x3c, 0x38, 0x38, 0x33, 0x2c, 
	0x3e, 0x3d, 0x42, 0x19, 0x4c, 0x00, 0x0f, 0x01, 0x4d, 
	0x01, 0x49, 0x4e, 0x4f, 0x1d, 0x43, 0x05, 0x32, 0x4c, 
	0x3e, 0x3e, 0x32, 0x3d, 0x50, 0x12, 0x51, 0x00, 0x0f, 
	0x01, 0x52, 0x01, 0x4a, 0x53, 0x3c, 0x1d, 0x54, 0x0e, 
	0x3f, 0x3f, 0x32, 0x55, 0x3d, 0x36, 0x28, 0x28, 0x56, 
	0x00, 0x0f, 0x01, 0x4b, 0x01, 0x57, 0x4a, 0x56, 0x1d, 
	0x37, 0x0e, 0x05, 0x32, 0x0e, 0x0e, 0x58, 0x56, 0x19, 
	0x48, 0x59, 0x00, 0x0f, 0x01, 0x5a, 0x01, 0x5b, 0x4b, 
	0x5c, 0x1d, 0x12, 0x54, 0x05, 0x42, 0x54, 0x19, 0x19, 
	0x28, 0x58, 0x55, 0x47, 0x00, 0x0b, 0x01, 0x5d, 0x01, 
	0x01, 0x01, 0x5d, 0x01, 0x01, 0x5b, 0x4e, 0x24, 0x58, 
	0x37, 0x0e, 0x19, 0x58, 0x19, 0x58, 0x1d, 0x48, 0x4c, 
	0x1f, 0x00, 0x0a, 0x01, 0x5e, 0x5f, 0x5d, 0x01, 0x5e, 
	0x5f, 0x5d, 0x01, 0x01, 0x01, 0x47, 0x60, 0x19, 0x19, 
	0x37, 0x58, 0x43, 0x28, 0x61, 0x48, 0x4c, 0x45, 0x00, 
	0x0b, 0x01, 0x5e, 0x5f, 0x5e, 0x5f, 0x5d, 0x00, 0x06, 
	0x01, 0x53, 0x54, 0x19, 0x58, 0x28, 0x48, 0x62, 0x51, 
	0x51, 0x45, 0x00, 0x0c, 0x01, 0x5e, 0x5f, 0x5d, 0x00, 
	0x09, 0x01, 0x53, 0x28, 0x21, 0x61, 0x51, 0x61, 0x51, 
	0x63, 0x00, 0x0b, 0x01, 0x5e, 0x5f, 0x5f, 0x5f, 0x5d, 
	0x00, 0x0a, 0x01, 0x53, 0x62, 0x48, 0x51, 0x51, 0x3d, 
	0x00, 0x0a, 0x01, 0x5e, 0x5f, 0x5d, 0x01, 0x5e, 0x5f, 
	0x5d, 0x00, 0x0b, 0x01, 0x3d, 0x56, 0x64, 0x3d, 0x00, 
	0x0b, 0x01, 0x5d, 0x01, 0x01, 0x01, 0x5d, 0x00, 0x0e, 
	0x01, 0x3d, 0x65, 0x00, 0x1e, 0x01, 0x3b, 0x00, 0x47, 
	0x01, 0x00, 0x00 
};

// Display mode

unsigned char item_monkeyPortrait_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0x04, 0x02, 0x04, 
	0x14, 0x16, 0x14, 
	0x64, 0x66, 0x64, 
	0x1c, 0x16, 0x1c, 
	0x1c, 0x1a, 0x1c, 
	0x3c, 0x3e, 0x3c, 
	0x34, 0x36, 0x34, 
	0x34, 0x32, 0x34, 
	0x6c, 0x6a, 0x6c, 
	0xb4, 0xb2, 0xb4, 
	0x4c, 0x4e, 0x4c, 
	0x94, 0x92, 0x94, 
	0x94, 0x96, 0x94, 
	0x7c, 0x7e, 0x7c, 
	0x9c, 0x9e, 0x9c, 
	0x0c, 0x0a, 0x0c, 
	0x44, 0x46, 0x44, 
	0x5c, 0x5a, 0x5c, 
	0x74, 0x76, 0x74, 
	0xc4, 0xc2, 0xc4, 
	0x84, 0x82, 0x84, 
	0x9c, 0x9a, 0x9c, 
	0x74, 0x72, 0x74, 
	0x24, 0x26, 0x24, 
	0xa4, 0xa6, 0xa4, 
	0x3c, 0x3a, 0x3c, 
	0x8c, 0x8e, 0x8c, 
	0x2c, 0x7e, 0xb4, 
	0xbc, 0xbe, 0xbc, 
	0x6c, 0x6e, 0x6c, 
	0x1c, 0x1e, 0x1c, 
	0x2c, 0x5e, 0x7c, 
	0xac, 0xaa, 0xac, 
	0x5c, 0x5e, 0x5c, 
	0xa4, 0xa2, 0xa4, 
	0xd4, 0xd6, 0xd4, 
	0xac, 0xae, 0xac, 
	0xec, 0xee, 0xec, 
	0xe4, 0xe6, 0xe4, 
	0xfc, 0xfa, 0xfc, 
	0x0e, 0x16, 0x00, 
	0x1c, 0x0a, 0x0c, 
	0x24, 0x06, 0x04, 
	0xcc, 0xce, 0xcc, 
	0xf4, 0xf2, 0xf4, 
	0xdc, 0xde, 0xdc, 
	0xe4, 0xe2, 0xe4, 
	0x14, 0x0e, 0x04, 
	0x34, 0x26, 0x14, 
	0xbc, 0xba, 0xbc, 
	0x0c, 0x06, 0x0c, 
	0x04, 0x06, 0x04, 
	0x8c, 0x8a, 0x8c, 
	0x2c, 0x2e, 0x2c

};
unsigned char item_monkeyPortrait[] = { 
	0x00, 0x23, 0x01, 0x00, 0x0c, 0x02, 0x03, 0x03, 0x03, 
	0x00, 0x09, 0x02, 0x00, 0x08, 0x01, 0x00, 0x07, 0x02, 
	0x04, 0x04, 0x05, 0x03, 0x06, 0x07, 0x08, 0x09, 0x03, 
	0x05, 0x00, 0x07, 0x02, 0x00, 0x08, 0x01, 0x00, 0x04, 
	0x02, 0x04, 0x0a, 0x04, 0x0b, 0x0a, 0x0c, 0x04, 0x0d, 
	0x0e, 0x0f, 0x09, 0x08, 0x09, 0x04, 0x0a, 0x04, 0x0a, 
	0x02, 0x02, 0x02, 0x00, 0x08, 0x01, 0x02, 0x02, 0x0a, 
	0x0a, 0x0b, 0x10, 0x10, 0x0f, 0x11, 0x12, 0x13, 0x14, 
	0x15, 0x0b, 0x16, 0x04, 0x0a, 0x10, 0x10, 0x0b, 0x0b, 
	0x0a, 0x0a, 0x02, 0x00, 0x08, 0x01, 0x02, 0x02, 0x17, 
	0x0b, 0x10, 0x18, 0x18, 0x19, 0x02, 0x09, 0x09, 0x08, 
	0x04, 0x10, 0x0b, 0x1a, 0x0d, 0x1b, 0x1c, 0x10, 0x17, 
	0x0b, 0x10, 0x02, 0x00, 0x08, 0x01, 0x02, 0x02, 0x1b, 
	0x10, 0x1a, 0x0d, 0x0e, 0x02, 0x02, 0x08, 0x1d, 0x09, 
	0x09, 0x1e, 0x0f, 0x0b, 0x1c, 0x02, 0x1a, 0x1a, 0x1c, 
	0x10, 0x08, 0x02, 0x00, 0x08, 0x01, 0x02, 0x02, 0x02, 
	0x08, 0x17, 0x17, 0x0b, 0x1f, 0x20, 0x09, 0x21, 0x08, 
	0x09, 0x22, 0x23, 0x0b, 0x1c, 0x18, 0x0b, 0x10, 0x1c, 
	0x0d, 0x02, 0x02, 0x00, 0x08, 0x01, 0x00, 0x04, 0x02, 
	0x09, 0x0d, 0x10, 0x17, 0x24, 0x07, 0x09, 0x08, 0x10, 
	0x25, 0x26, 0x0b, 0x18, 0x0b, 0x10, 0x1c, 0x1c, 0x09, 
	0x02, 0x02, 0x00, 0x08, 0x01, 0x00, 0x05, 0x02, 0x1f, 
	0x1c, 0x0d, 0x14, 0x12, 0x08, 0x10, 0x27, 0x28, 0x25, 
	0x0f, 0x0f, 0x17, 0x1c, 0x0d, 0x09, 0x02, 0x02, 0x02, 
	0x00, 0x08, 0x01, 0x00, 0x05, 0x02, 0x06, 0x0d, 0x1c, 
	0x1c, 0x1c, 0x1a, 0x25, 0x29, 0x27, 0x1e, 0x0e, 0x1c, 
	0x0d, 0x1c, 0x1f, 0x00, 0x04, 0x02, 0x00, 0x08, 0x01, 
	0x2a, 0x2a, 0x2a, 0x2b, 0x2c, 0x2b, 0x1f, 0x1c, 0x0b, 
	0x2d, 0x2e, 0x2e, 0x29, 0x29, 0x28, 0x2d, 0x22, 0x1c, 
	0x0d, 0x06, 0x00, 0x04, 0x02, 0x00, 0x08, 0x01, 0x00, 
	0x07, 0x2a, 0x0d, 0x0b, 0x27, 0x00, 0x05, 0x29, 0x25, 
	0x0b, 0x1c, 0x18, 0x00, 0x05, 0x02, 0x00, 0x08, 0x01, 
	0x00, 0x07, 0x2a, 0x1c, 0x0b, 0x00, 0x06, 0x29, 0x25, 
	0x0b, 0x1c, 0x23, 0x00, 0x04, 0x02, 0x2a, 0x00, 0x08, 
	0x01, 0x00, 0x08, 0x2a, 0x17, 0x2f, 0x00, 0x04, 0x29, 
	0x30, 0x1e, 0x0b, 0x0d, 0x2a, 0x31, 0x02, 0x02, 0x2a, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x08, 0x2a, 0x1c, 0x2f, 
	0x00, 0x04, 0x29, 0x25, 0x0b, 0x0e, 0x1c, 0x2a, 0x2a, 
	0x02, 0x2a, 0x2a, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x09, 
	0x2a, 0x1e, 0x2f, 0x29, 0x29, 0x29, 0x25, 0x0b, 0x0d, 
	0x2a, 0x2a, 0x2a, 0x02, 0x2a, 0x2a, 0x2a, 0x00, 0x08, 
	0x01, 0x00, 0x09, 0x2a, 0x0b, 0x25, 0x29, 0x29, 0x29, 
	0x2f, 0x0b, 0x1c, 0x2a, 0x2a, 0x2a, 0x02, 0x2a, 0x2a, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x09, 0x2a, 0x0b, 0x25, 
	0x29, 0x29, 0x2f, 0x25, 0x0b, 0x1c, 0x2a, 0x2a, 0x2a, 
	0x32, 0x2a, 0x2a, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x09, 
	0x2a, 0x17, 0x33, 0x2f, 0x29, 0x2f, 0x25, 0x0b, 0x0d, 
	0x00, 0x07, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x09, 0x2a, 
	0x1c, 0x0b, 0x2f, 0x2f, 0x25, 0x33, 0x0e, 0x1c, 0x00, 
	0x07, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x09, 0x2a, 0x0d, 
	0x0e, 0x33, 0x25, 0x33, 0x0e, 0x1c, 0x0d, 0x00, 0x07, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x08, 0x2a, 0x0e, 0x1c, 
	0x1c, 0x0b, 0x25, 0x0b, 0x1c, 0x0d, 0x26, 0x00, 0x07, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x07, 0x2a, 0x0e, 0x0b, 
	0x1c, 0x0d, 0x0b, 0x33, 0x0b, 0x1c, 0x1c, 0x0b, 0x0e, 
	0x00, 0x06, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x06, 0x2a, 
	0x0e, 0x0b, 0x0b, 0x26, 0x1c, 0x0e, 0x0a, 0x0a, 0x0d, 
	0x26, 0x0b, 0x0b, 0x0e, 0x00, 0x05, 0x2a, 0x00, 0x08, 
	0x01, 0x00, 0x05, 0x2a, 0x10, 0x0b, 0x0b, 0x0e, 0x0e, 
	0x04, 0x34, 0x35, 0x02, 0x04, 0x0a, 0x0b, 0x0b, 0x0b, 
	0x10, 0x00, 0x04, 0x2a, 0x00, 0x08, 0x01, 0x00, 0x05, 
	0x2a, 0x0b, 0x0b, 0x04, 0x04, 0x04, 0x2a, 0x2a, 0x02, 
	0x02, 0x35, 0x23, 0x0a, 0x04, 0x0d, 0x00, 0x05, 0x2a, 
	0x00, 0x08, 0x01, 0x00, 0x07, 0x2a, 0x36, 0x36, 0x36, 
	0x0f, 0x00, 0x04, 0x02, 0x36, 0x36, 0x36, 0x00, 0x06, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x08, 0x2a, 0x1c, 0x1b, 
	0x07, 0x00, 0x04, 0x02, 0x1b, 0x07, 0x1b, 0x00, 0x06, 
	0x2a, 0x00, 0x08, 0x01, 0x00, 0x05, 0x2a, 0x37, 0x09, 
	0x37, 0x1b, 0x09, 0x09, 0x37, 0x02, 0x02, 0x37, 0x09, 
	0x09, 0x09, 0x37, 0x09, 0x37, 0x2a, 0x2a, 0x2a, 0x00, 
	0x45, 0x01, 0x00, 0x00 
};

unsigned char item_monkeyLandscape_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0x0e, 0x16, 0x00, 
	0x04, 0x02, 0x04, 
	0x3c, 0x3a, 0x3c, 
	0x9c, 0x9a, 0x9c, 
	0x6c, 0x6a, 0x6c, 
	0x1c, 0x0a, 0x0c, 
	0x34, 0x36, 0x34, 
	0x9c, 0x9e, 0x9c, 
	0xb4, 0xb2, 0xb4, 
	0x24, 0x06, 0x04, 
	0x34, 0x32, 0x34, 
	0xa4, 0xa6, 0xa4, 
	0x64, 0x66, 0x64, 
	0x2c, 0x2e, 0x2c, 
	0x1c, 0x1a, 0x1c, 
	0x6c, 0x6e, 0x6c, 
	0x94, 0x92, 0x94, 
	0x74, 0x72, 0x74, 
	0x94, 0x96, 0x94, 
	0x8c, 0x8e, 0x8c, 
	0x8c, 0x8a, 0x8c, 
	0x24, 0x26, 0x24, 
	0x7c, 0x7e, 0x7c, 
	0x74, 0x76, 0x74, 
	0xa4, 0xa2, 0xa4, 
	0x1c, 0x1e, 0x1c, 
	0x0c, 0x0a, 0x0c, 
	0xac, 0xae, 0xac, 
	0xbc, 0xbe, 0xbc, 
	0xdc, 0xde, 0xdc, 
	0xfc, 0xfa, 0xfc, 
	0xec, 0xee, 0xec, 
	0xcc, 0xce, 0xcc, 
	0x44, 0x46, 0x44, 
	0x3c, 0x3e, 0x3c, 
	0x4c, 0x4e, 0x4c, 
	0x1c, 0x16, 0x1c, 
	0xbc, 0xba, 0xbc, 
	0xd4, 0xd6, 0xd4, 
	0xf4, 0xf2, 0xf4, 
	0x2c, 0x5e, 0x7c, 
	0x2c, 0x7e, 0xb4, 
	0x5c, 0x5a, 0x5c, 
	0x14, 0x16, 0x14, 
	0x0c, 0x06, 0x0c, 
	0x04, 0x06, 0x04, 
	0xc4, 0xc2, 0xc4, 
	0xe4, 0xe6, 0xe4, 
	0xac, 0xaa, 0xac, 
	0xe4, 0xe2, 0xe4, 
	0x5c, 0x5e, 0x5c, 
	0x84, 0x82, 0x84, 
	0x14, 0x0e, 0x04, 
	0x34, 0x26, 0x14

};
unsigned char item_monkeyLandscape[] = { 
	0x00, 0x62, 0x01, 0x00, 0x13, 0x02, 0x00, 0x0a, 0x03, 
	0x01, 0x01, 0x01, 0x00, 0x13, 0x02, 0x00, 0x0a, 0x03, 
	0x01, 0x01, 0x01, 0x00, 0x13, 0x02, 0x00, 0x04, 0x03, 
	0x04, 0x05, 0x06, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 
	0x00, 0x12, 0x02, 0x07, 0x03, 0x03, 0x03, 0x08, 0x09, 
	0x0a, 0x06, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x00, 
	0x12, 0x02, 0x0b, 0x03, 0x03, 0x0c, 0x05, 0x0d, 0x09, 
	0x0a, 0x0e, 0x03, 0x03, 0x01, 0x01, 0x01, 0x0f, 0x02, 
	0x02, 0x0a, 0x09, 0x00, 0x0d, 0x02, 0x07, 0x10, 0x11, 
	0x12, 0x05, 0x12, 0x13, 0x09, 0x06, 0x03, 0x03, 0x01, 
	0x01, 0x01, 0x0c, 0x02, 0x02, 0x0a, 0x0a, 0x14, 0x00, 
	0x0c, 0x02, 0x11, 0x12, 0x15, 0x09, 0x0a, 0x14, 0x13, 
	0x09, 0x0e, 0x03, 0x03, 0x01, 0x01, 0x01, 0x0f, 0x02, 
	0x16, 0x0e, 0x0a, 0x0a, 0x14, 0x00, 0x09, 0x02, 0x15, 
	0x12, 0x15, 0x15, 0x12, 0x05, 0x11, 0x03, 0x17, 0x18, 
	0x0a, 0x0e, 0x03, 0x01, 0x01, 0x01, 0x04, 0x15, 0x16, 
	0x0e, 0x14, 0x0a, 0x0a, 0x14, 0x00, 0x06, 0x02, 0x15, 
	0x05, 0x0a, 0x0a, 0x0a, 0x15, 0x19, 0x1a, 0x1b, 0x03, 
	0x03, 0x1c, 0x06, 0x0e, 0x03, 0x01, 0x01, 0x01, 0x0c, 
	0x04, 0x16, 0x0e, 0x14, 0x1d, 0x15, 0x15, 0x12, 0x15, 
	0x05, 0x0a, 0x0a, 0x1e, 0x1f, 0x1f, 0x20, 0x21, 0x22, 
	0x15, 0x23, 0x24, 0x0c, 0x08, 0x0c, 0x23, 0x25, 0x26, 
	0x03, 0x01, 0x01, 0x01, 0x0c, 0x24, 0x18, 0x02, 0x0e, 
	0x15, 0x12, 0x15, 0x14, 0x0a, 0x27, 0x28, 0x28, 0x1f, 
	0x00, 0x04, 0x20, 0x29, 0x0d, 0x08, 0x0c, 0x2a, 0x2b, 
	0x0c, 0x2c, 0x0e, 0x2d, 0x03, 0x01, 0x01, 0x01, 0x0f, 
	0x03, 0x03, 0x02, 0x2e, 0x14, 0x0a, 0x0a, 0x27, 0x1f, 
	0x1f, 0x00, 0x07, 0x20, 0x29, 0x28, 0x09, 0x08, 0x08, 
	0x0c, 0x08, 0x19, 0x12, 0x10, 0x03, 0x01, 0x01, 0x01, 
	0x00, 0x04, 0x03, 0x2f, 0x06, 0x27, 0x28, 0x28, 0x1f, 
	0x00, 0x0a, 0x20, 0x21, 0x09, 0x0c, 0x0c, 0x0e, 0x30, 
	0x14, 0x24, 0x2d, 0x01, 0x01, 0x01, 0x00, 0x05, 0x03, 
	0x06, 0x0a, 0x0a, 0x27, 0x28, 0x1f, 0x1f, 0x00, 0x07, 
	0x20, 0x21, 0x31, 0x28, 0x32, 0x1e, 0x09, 0x0a, 0x18, 
	0x08, 0x2d, 0x01, 0x01, 0x01, 0x0f, 0x03, 0x03, 0x2f, 
	0x0e, 0x12, 0x15, 0x15, 0x14, 0x27, 0x28, 0x28, 0x1f, 
	0x28, 0x28, 0x33, 0x20, 0x20, 0x31, 0x1e, 0x28, 0x1d, 
	0x34, 0x18, 0x0a, 0x35, 0x0c, 0x0c, 0x2d, 0x01, 0x01, 
	0x01, 0x0c, 0x04, 0x16, 0x34, 0x06, 0x1d, 0x15, 0x12, 
	0x15, 0x14, 0x00, 0x05, 0x0a, 0x1e, 0x28, 0x28, 0x22, 
	0x14, 0x18, 0x0a, 0x0a, 0x0a, 0x0d, 0x0e, 0x08, 0x2d, 
	0x03, 0x01, 0x01, 0x01, 0x0c, 0x24, 0x16, 0x06, 0x0a, 
	0x0a, 0x0a, 0x1d, 0x12, 0x15, 0x12, 0x15, 0x15, 0x12, 
	0x14, 0x0a, 0x0a, 0x0a, 0x32, 0x15, 0x18, 0x13, 0x15, 
	0x15, 0x12, 0x06, 0x0c, 0x26, 0x03, 0x01, 0x01, 0x01, 
	0x0c, 0x04, 0x16, 0x0e, 0x0a, 0x0a, 0x14, 0x00, 0x07, 
	0x02, 0x15, 0x12, 0x15, 0x15, 0x15, 0x12, 0x05, 0x0a, 
	0x13, 0x03, 0x04, 0x09, 0x0e, 0x03, 0x03, 0x01, 0x01, 
	0x01, 0x0f, 0x02, 0x02, 0x12, 0x0a, 0x14, 0x00, 0x0a, 
	0x02, 0x34, 0x13, 0x12, 0x15, 0x15, 0x09, 0x0a, 0x0d, 
	0x15, 0x09, 0x06, 0x03, 0x03, 0x01, 0x01, 0x01, 0x0c, 
	0x02, 0x02, 0x02, 0x09, 0x00, 0x0a, 0x02, 0x36, 0x03, 
	0x03, 0x10, 0x11, 0x12, 0x15, 0x09, 0x0d, 0x09, 0x0a, 
	0x0e, 0x03, 0x03, 0x01, 0x01, 0x01, 0x0f, 0x00, 0x0a, 
	0x02, 0x37, 0x00, 0x08, 0x03, 0x0c, 0x15, 0x15, 0x15, 
	0x05, 0x0a, 0x06, 0x03, 0x03, 0x01, 0x01, 0x01, 0x00, 
	0x0f, 0x02, 0x00, 0x06, 0x03, 0x0c, 0x12, 0x09, 0x0a, 
	0x06, 0x03, 0x03, 0x03, 0x01, 0x01, 0x01, 0x00, 0x10, 
	0x02, 0x00, 0x07, 0x03, 0x08, 0x09, 0x06, 0x03, 0x03, 
	0x03, 0x01, 0x01, 0x01, 0x00, 0x11, 0x02, 0x00, 0x0c, 
	0x03, 0x00, 0xa1, 0x01, 0x00, 0x00 
};


// *************************************************************************
//									STARTUP
// *************************************************************************

int item_startup_colors_size = 212;

unsigned char item_startup_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0xff, 0xc6, 0x21, 
	0xff, 0x94, 0x21, 
	0xf7, 0xb5, 0x21, 
	0xe7, 0x94, 0x18, 
	0xe7, 0x8c, 0x18, 
	0xde, 0x7b, 0x18, 
	0xd6, 0x63, 0x18, 
	0xce, 0x4a, 0x18, 
	0xbd, 0x39, 0x10, 
	0xd0, 0x71, 0x17, 
	0xff, 0xad, 0x21, 
	0xd6, 0x42, 0x10, 
	0xd6, 0x39, 0x10, 
	0xde, 0x39, 0x18, 
	0xe7, 0x39, 0x18, 
	0x5e, 0x16, 0x06, 
	0xbd, 0x6b, 0x18, 
	0xff, 0xa5, 0x21, 
	0x73, 0x18, 0x08, 
	0x31, 0x08, 0x00, 
	0xf7, 0xad, 0x18, 
	0xf7, 0x9c, 0x18, 
	0xff, 0xbd, 0x21, 
	0xf7, 0x8c, 0x18, 
	0xf7, 0x84, 0x18, 
	0xff, 0xb5, 0x21, 
	0x84, 0x29, 0x08, 
	0xe4, 0x75, 0x10, 
	0xde, 0x5a, 0x08, 
	0xda, 0x72, 0x15, 
	0xe7, 0x6b, 0x08, 
	0xe7, 0x84, 0x18, 
	0xef, 0x84, 0x18, 
	0xef, 0xa5, 0x18, 
	0xc6, 0x31, 0x10, 
	0xbd, 0x31, 0x10, 
	0xad, 0x29, 0x10, 
	0x39, 0x10, 0x00, 
	0xff, 0x8c, 0x21, 
	0xd2, 0x6b, 0x0c, 
	0xef, 0xad, 0x18, 
	0xe7, 0xa5, 0x18, 
	0xde, 0x9c, 0x18, 
	0xd6, 0x84, 0x10, 
	0xef, 0x94, 0x18, 
	0xad, 0x5a, 0x10, 
	0xef, 0x7b, 0x18, 
	0xe7, 0x6b, 0x18, 
	0xff, 0x84, 0x18, 
	0xef, 0x6b, 0x18, 
	0xde, 0x52, 0x18, 
	0xc6, 0x39, 0x10, 
	0x9c, 0x29, 0x10, 
	0x7b, 0x21, 0x08, 
	0x73, 0x21, 0x08, 
	0xb5, 0x5a, 0x10, 
	0xde, 0x63, 0x18, 
	0xce, 0x42, 0x10, 
	0x90, 0x28, 0x0d, 
	0x9d, 0x4a, 0x0a, 
	0xce, 0x8c, 0x18, 
	0xc6, 0x5a, 0x10, 
	0xbd, 0x52, 0x0c, 
	0xc6, 0x52, 0x08, 
	0xd6, 0x52, 0x08, 
	0xef, 0xb5, 0x18, 
	0xe7, 0x9c, 0x18, 
	0xb5, 0x5a, 0x08, 
	0xb5, 0x4a, 0x08, 
	0xc6, 0x4a, 0x08, 
	0xde, 0xa5, 0x18, 
	0xda, 0x5e, 0x0c, 
	0xf7, 0x6b, 0x10, 
	0x80, 0x45, 0x09, 
	0xe7, 0x5e, 0x10, 
	0xef, 0x7b, 0x29, 
	0xa4, 0x57, 0x0d, 
	0xff, 0x4a, 0x1b, 
	0xff, 0x42, 0x18, 
	0xf7, 0x42, 0x18, 
	0x6b, 0x18, 0x08, 
	0x52, 0x18, 0x08, 
	0x83, 0x39, 0x08, 
	0xf9, 0x6d, 0x15, 
	0xef, 0x42, 0x18, 
	0xef, 0x39, 0x18, 
	0xce, 0x31, 0x10, 
	0x85, 0x53, 0x09, 
	0xb9, 0x67, 0x10, 
	0xce, 0x5a, 0x08, 
	0xce, 0x52, 0x08, 
	0xe7, 0x5a, 0x08, 
	0x42, 0x18, 0x00, 
	0xe7, 0xad, 0x18, 
	0xde, 0x86, 0x12, 
	0xd6, 0x5a, 0x08, 
	0x52, 0x21, 0x00, 
	0xd6, 0x9c, 0x18, 
	0xef, 0x7b, 0x10, 
	0x59, 0x2b, 0x05, 
	0xf7, 0x7b, 0x21, 
	0x94, 0x58, 0x0c, 
	0xff, 0x6b, 0x18, 
	0x52, 0x10, 0x08, 
	0x8f, 0x45, 0x0b, 
	0xef, 0x8c, 0x18, 
	0xef, 0x63, 0x08, 
	0x77, 0x29, 0x00, 
	0x31, 0x18, 0x00, 
	0x7b, 0x31, 0x00, 
	0x29, 0x10, 0x00, 
	0xf7, 0xa5, 0x18, 
	0xe7, 0x63, 0x18, 
	0xff, 0x8c, 0x31, 
	0xad, 0x5a, 0x18, 
	0xff, 0x7b, 0x18, 
	0xa5, 0x42, 0x00, 
	0x8c, 0x39, 0x00, 
	0xad, 0x63, 0x10, 
	0xf7, 0x63, 0x08, 
	0x31, 0x10, 0x00, 
	0xaa, 0x4a, 0x0b, 
	0xf1, 0x65, 0x12, 
	0xff, 0x73, 0x14, 
	0xff, 0x84, 0x29, 
	0xce, 0x63, 0x18, 
	0xb9, 0x4c, 0x0e, 
	0x9c, 0x31, 0x10, 
	0xd6, 0x5a, 0x18, 
	0xce, 0x5a, 0x18, 
	0xc6, 0x52, 0x10, 
	0xbd, 0x5a, 0x18, 
	0xe4, 0x75, 0x1b, 
	0xd6, 0x52, 0x18, 
	0xb5, 0x29, 0x10, 
	0xad, 0x42, 0x00, 
	0x84, 0x31, 0x00, 
	0xce, 0x63, 0x10, 
	0xc1, 0x5a, 0x08, 
	0xff, 0x63, 0x08, 
	0xbd, 0x4a, 0x00, 
	0x69, 0x25, 0x02, 
	0xc3, 0x89, 0x10, 
	0xef, 0x73, 0x10, 
	0x63, 0x31, 0x06, 
	0xf7, 0x52, 0x18, 
	0xc6, 0x7b, 0x14, 
	0xe7, 0x4a, 0x18, 
	0x94, 0x3b, 0x0a, 
	0xce, 0x39, 0x10, 
	0xd6, 0x31, 0x10, 
	0x9c, 0x42, 0x00, 
	0x5e, 0x21, 0x04, 
	0xc6, 0x63, 0x08, 
	0x6f, 0x36, 0x06, 
	0x7b, 0x2d, 0x08, 
	0x4a, 0x10, 0x08, 
	0xde, 0x5a, 0x18, 
	0xff, 0x5a, 0x18, 
	0x3f, 0x10, 0x00, 
	0xbd, 0x42, 0x10, 
	0xc6, 0x73, 0x18, 
	0xce, 0x9c, 0x18, 
	0x5a, 0x21, 0x00, 
	0xbd, 0x7f, 0x10, 
	0xf7, 0x84, 0x29, 
	0xef, 0x84, 0x29, 
	0xb5, 0x84, 0x10, 
	0xef, 0x73, 0x18, 
	0xb2, 0x78, 0x10, 
	0x94, 0x39, 0x00, 
	0xb5, 0x31, 0x18, 
	0xad, 0x73, 0x10, 
	0xd2, 0x90, 0x18, 
	0xef, 0x8c, 0x10, 
	0x4e, 0x1c, 0x00, 
	0x9f, 0x66, 0x0f, 
	0xf3, 0x5a, 0x18, 
	0xa5, 0x39, 0x00, 
	0x4a, 0x18, 0x00, 
	0xef, 0x5a, 0x08, 
	0xde, 0x42, 0x18, 
	0xef, 0x4a, 0x1b, 
	0x9c, 0x21, 0x10, 
	0xef, 0x9c, 0x18, 
	0xe7, 0x42, 0x18, 
	0x9c, 0x39, 0x00, 
	0xc6, 0x5a, 0x18, 
	0xe7, 0x7b, 0x21, 
	0xce, 0x5a, 0x10, 
	0xce, 0x52, 0x10, 
	0xce, 0x42, 0x29, 
	0x5a, 0x10, 0x08, 
	0xa0, 0x2d, 0x18, 
	0xff, 0x52, 0x29, 
	0x4a, 0x18, 0x08, 
	0xde, 0x52, 0x31, 
	0x9c, 0x39, 0x10, 
	0xdb, 0x94, 0x15, 
	0xde, 0x4a, 0x18, 
	0xad, 0x6b, 0x10, 
	0xb5, 0x63, 0x10, 
	0xa5, 0x39, 0x10, 
	0xf7, 0x39, 0x18, 
	0xc6, 0x4a, 0x10, 
	0xc6, 0x73, 0x10, 
	0xb5, 0x39, 0x10, 
	0xce, 0x52, 0x18, 
	0xad, 0x31, 0x10, 
	0x29, 0x08, 0x00, 
	0xc6, 0x42, 0x10

};
unsigned char item_startup[] = { 
	0x00, 0xdd, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 
	0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 
	0x28, 0x03, 0x00, 0x18, 0x02, 0x04, 0x04, 0x05, 0x06, 
	0x07, 0x08, 0x08, 0x09, 0x0a, 0x0b, 0x00, 0x06, 0x02, 
	0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 
	0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x17, 0x02, 0x0c, 0x0d, 0x0e, 0x0f, 0x0f, 0x10, 0x10, 
	0x10, 0x0f, 0x11, 0x12, 0x00, 0x06, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 0x01, 
	0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x17, 0x02, 
	0x13, 0x00, 0x07, 0x10, 0x14, 0x15, 0x12, 0x00, 0x06, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x1f, 0x02, 0x16, 0x17, 
	0x18, 0x00, 0x06, 0x02, 0x00, 0x0f, 0x03, 0x19, 0x1a, 
	0x19, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 
	0x00, 0x28, 0x03, 0x00, 0x17, 0x02, 0x1b, 0x00, 0x06, 
	0x10, 0x1c, 0x15, 0x15, 0x12, 0x00, 0x06, 0x02, 0x00, 
	0x28, 0x03, 0x00, 0x1e, 0x02, 0x18, 0x1d, 0x1e, 0x1f, 
	0x00, 0x06, 0x02, 0x00, 0x0f, 0x03, 0x20, 0x1e, 0x1e, 
	0x21, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 
	0x00, 0x05, 0x03, 0x22, 0x19, 0x00, 0x21, 0x03, 0x00, 
	0x0c, 0x02, 0x18, 0x18, 0x18, 0x23, 0x04, 0x18, 0x00, 
	0x05, 0x02, 0x1b, 0x10, 0x10, 0x0f, 0x24, 0x25, 0x26, 
	0x27, 0x15, 0x15, 0x12, 0x00, 0x06, 0x02, 0x00, 0x25, 
	0x03, 0x28, 0x21, 0x29, 0x05, 0x02, 0x02, 0x02, 0x18, 
	0x18, 0x2a, 0x2b, 0x2c, 0x2d, 0x2b, 0x00, 0x13, 0x02, 
	0x2e, 0x1e, 0x1e, 0x2f, 0x00, 0x06, 0x02, 0x00, 0x0e, 
	0x03, 0x30, 0x1e, 0x1e, 0x31, 0x12, 0x00, 0x0a, 0x03, 
	0x01, 0x01, 0x00, 0x1d, 0x02, 0x03, 0x32, 0x33, 0x34, 
	0x35, 0x36, 0x37, 0x38, 0x39, 0x28, 0x00, 0x1e, 0x03, 
	0x00, 0x09, 0x02, 0x16, 0x07, 0x3a, 0x3b, 0x24, 0x24, 
	0x25, 0x26, 0x3c, 0x3d, 0x3e, 0x18, 0x02, 0x02, 0x1b, 
	0x10, 0x10, 0x0e, 0x26, 0x26, 0x36, 0x27, 0x15, 0x15, 
	0x12, 0x00, 0x06, 0x02, 0x00, 0x22, 0x03, 0x22, 0x1f, 
	0x3f, 0x40, 0x41, 0x42, 0x3d, 0x43, 0x44, 0x45, 0x00, 
	0x04, 0x46, 0x47, 0x47, 0x46, 0x48, 0x00, 0x11, 0x02, 
	0x04, 0x49, 0x1e, 0x4a, 0x4b, 0x00, 0x06, 0x02, 0x00, 
	0x0d, 0x03, 0x19, 0x1e, 0x1e, 0x4c, 0x4d, 0x4e, 0x00, 
	0x0a, 0x03, 0x01, 0x01, 0x00, 0x1c, 0x02, 0x03, 0x4f, 
	0x50, 0x51, 0x10, 0x0f, 0x25, 0x36, 0x52, 0x53, 0x54, 
	0x19, 0x00, 0x1d, 0x03, 0x00, 0x07, 0x02, 0x1b, 0x55, 
	0x56, 0x57, 0x57, 0x10, 0x10, 0x10, 0x0e, 0x58, 0x24, 
	0x36, 0x11, 0x59, 0x18, 0x02, 0x1b, 0x10, 0x10, 0x0e, 
	0x26, 0x26, 0x36, 0x27, 0x15, 0x15, 0x5a, 0x00, 0x06, 
	0x02, 0x00, 0x20, 0x03, 0x1d, 0x5b, 0x41, 0x5c, 0x1e, 
	0x5d, 0x5d, 0x5c, 0x5e, 0x5f, 0x60, 0x41, 0x61, 0x00, 
	0x04, 0x42, 0x5c, 0x62, 0x63, 0x00, 0x11, 0x02, 0x64, 
	0x61, 0x4c, 0x55, 0x65, 0x00, 0x06, 0x02, 0x00, 0x0d, 
	0x03, 0x20, 0x1e, 0x1e, 0x66, 0x0b, 0x67, 0x00, 0x0a, 
	0x03, 0x01, 0x01, 0x00, 0x1a, 0x02, 0x18, 0x68, 0x50, 
	0x50, 0x50, 0x51, 0x10, 0x24, 0x25, 0x26, 0x3c, 0x69, 
	0x69, 0x6a, 0x00, 0x1d, 0x03, 0x00, 0x06, 0x02, 0x03, 
	0x4f, 0x50, 0x51, 0x57, 0x57, 0x10, 0x10, 0x10, 0x0e, 
	0x58, 0x25, 0x36, 0x3c, 0x53, 0x67, 0x02, 0x1b, 0x10, 
	0x10, 0x0e, 0x26, 0x26, 0x36, 0x27, 0x15, 0x15, 0x5a, 
	0x00, 0x06, 0x02, 0x00, 0x05, 0x03, 0x6b, 0x22, 0x28, 
	0x00, 0x17, 0x03, 0x20, 0x1e, 0x6c, 0x00, 0x05, 0x5d, 
	0x6d, 0x6e, 0x5f, 0x2d, 0x41, 0x5d, 0x1e, 0x42, 0x42, 
	0x42, 0x6f, 0x70, 0x63, 0x00, 0x10, 0x02, 0x71, 0x1e, 
	0x1e, 0x55, 0x72, 0x5e, 0x2c, 0x00, 0x05, 0x02, 0x00, 
	0x0c, 0x03, 0x22, 0x1e, 0x1e, 0x33, 0x73, 0x74, 0x67, 
	0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x19, 0x02, 0x18, 
	0x75, 0x50, 0x50, 0x50, 0x51, 0x57, 0x0f, 0x25, 0x26, 
	0x36, 0x3c, 0x37, 0x52, 0x52, 0x0b, 0x00, 0x1b, 0x03, 
	0x28, 0x00, 0x05, 0x02, 0x13, 0x4f, 0x50, 0x50, 0x51, 
	0x57, 0x57, 0x10, 0x0f, 0x0f, 0x58, 0x24, 0x26, 0x3c, 
	0x37, 0x14, 0x52, 0x2b, 0x1b, 0x10, 0x10, 0x0f, 0x26, 
	0x26, 0x36, 0x27, 0x15, 0x15, 0x5a, 0x00, 0x06, 0x02, 
	0x03, 0x03, 0x03, 0x1d, 0x5b, 0x47, 0x76, 0x77, 0x78, 
	0x00, 0x15, 0x03, 0x1d, 0x5d, 0x79, 0x79, 0x6c, 0x5d, 
	0x5d, 0x5d, 0x46, 0x7a, 0x70, 0x48, 0x2d, 0x5c, 0x5d, 
	0x5d, 0x1e, 0x5c, 0x7b, 0x7a, 0x70, 0x63, 0x00, 0x0f, 
	0x02, 0x18, 0x20, 0x1e, 0x7c, 0x7d, 0x3f, 0x7a, 0x7b, 
	0x2b, 0x00, 0x04, 0x02, 0x00, 0x0c, 0x03, 0x1e, 0x1e, 
	0x1e, 0x7e, 0x73, 0x6a, 0x67, 0x00, 0x0a, 0x03, 0x01, 
	0x01, 0x00, 0x10, 0x02, 0x18, 0x16, 0x21, 0x7f, 0x80, 
	0x5a, 0x3e, 0x04, 0x02, 0x03, 0x50, 0x50, 0x50, 0x0f, 
	0x24, 0x25, 0x25, 0x26, 0x3c, 0x3c, 0x37, 0x37, 0x38, 
	0x38, 0x81, 0x00, 0x07, 0x03, 0x30, 0x3a, 0x82, 0x83, 
	0x84, 0x80, 0x85, 0x07, 0x03, 0x03, 0x03, 0x19, 0x30, 
	0x86, 0x3a, 0x82, 0x82, 0x09, 0x3b, 0x0a, 0x87, 0x00, 
	0x04, 0x02, 0x18, 0x4f, 0x50, 0x50, 0x51, 0x0f, 0x24, 
	0x25, 0x00, 0x05, 0x88, 0x36, 0x37, 0x52, 0x11, 0x52, 
	0x5a, 0x1b, 0x10, 0x10, 0x0f, 0x26, 0x26, 0x36, 0x27, 
	0x15, 0x15, 0x81, 0x00, 0x04, 0x80, 0x04, 0x02, 0x03, 
	0x22, 0x49, 0x5d, 0x6c, 0x1e, 0x41, 0x89, 0x8a, 0x4b, 
	0x00, 0x08, 0x03, 0x22, 0x1f, 0x8b, 0x8b, 0x8c, 0x39, 
	0x5a, 0x1f, 0x03, 0x03, 0x03, 0x19, 0x61, 0x79, 0x8d, 
	0x79, 0x79, 0x5d, 0x5c, 0x8e, 0x8f, 0x70, 0x70, 0x48, 
	0x0b, 0x5c, 0x5d, 0x5d, 0x1e, 0x76, 0x6d, 0x70, 0x27, 
	0x90, 0x00, 0x0f, 0x02, 0x2e, 0x61, 0x4c, 0x7d, 0x7d, 
	0x3d, 0x70, 0x5c, 0x4b, 0x04, 0x02, 0x02, 0x02, 0x00, 
	0x0b, 0x03, 0x91, 0x1e, 0x1e, 0x66, 0x73, 0x73, 0x92, 
	0x6a, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x0e, 0x02, 
	0x0c, 0x75, 0x93, 0x57, 0x0f, 0x24, 0x36, 0x37, 0x14, 
	0x38, 0x94, 0x93, 0x50, 0x51, 0x58, 0x00, 0x05, 0x25, 
	0x36, 0x37, 0x37, 0x14, 0x14, 0x3c, 0x3c, 0x07, 0x03, 
	0x03, 0x03, 0x28, 0x68, 0x95, 0x0f, 0x10, 0x10, 0x0f, 
	0x58, 0x26, 0x3c, 0x52, 0x96, 0x87, 0x97, 0x58, 0x0f, 
	0x0f, 0x10, 0x10, 0x57, 0x57, 0x36, 0x36, 0x82, 0x00, 
	0x04, 0x02, 0x28, 0x50, 0x50, 0x51, 0x25, 0x00, 0x08, 
	0x88, 0x26, 0x38, 0x11, 0x69, 0x69, 0x80, 0x1b, 0x10, 
	0x10, 0x0f, 0x26, 0x26, 0x36, 0x27, 0x15, 0x11, 0x98, 
	0x0f, 0x0f, 0x0e, 0x1c, 0x23, 0x18, 0x1d, 0x5d, 0x79, 
	0x79, 0x6c, 0x5d, 0x47, 0x76, 0x77, 0x8f, 0x4e, 0x00, 
	0x05, 0x03, 0x22, 0x49, 0x00, 0x05, 0x5c, 0x41, 0x8e, 
	0x99, 0x6a, 0x0b, 0x03, 0x30, 0x1e, 0x79, 0x79, 0x79, 
	0x42, 0x76, 0x76, 0x76, 0x9a, 0x70, 0x70, 0x63, 0x9b, 
	0x42, 0x5d, 0x5d, 0x1e, 0x76, 0x6d, 0x70, 0x8f, 0x9c, 
	0x2b, 0x00, 0x0d, 0x02, 0x04, 0x49, 0x1e, 0x55, 0x7d, 
	0x7d, 0x9d, 0x70, 0x1e, 0x6f, 0x67, 0x18, 0x02, 0x02, 
	0x00, 0x0a, 0x03, 0x1a, 0x1e, 0x1e, 0x31, 0x73, 0x73, 
	0x73, 0x5e, 0x9c, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 
	0x0c, 0x02, 0x18, 0x32, 0x50, 0x50, 0x51, 0x57, 0x0f, 
	0x98, 0x24, 0x26, 0x37, 0x52, 0x3c, 0x51, 0x50, 0x0e, 
	0x00, 0x06, 0x25, 0x88, 0x38, 0x52, 0x52, 0x52, 0x1c, 
	0x3c, 0x80, 0x03, 0x03, 0x68, 0x4f, 0x51, 0x51, 0x57, 
	0x57, 0x57, 0x0f, 0x98, 0x24, 0x88, 0x3c, 0x3c, 0x00, 
	0x08, 0x57, 0x36, 0x9e, 0x36, 0x9f, 0x00, 0x04, 0x02, 
	0xa0, 0x51, 0x51, 0x24, 0x00, 0x0a, 0x88, 0x3c, 0xa1, 
	0xa1, 0xa1, 0x3c, 0xa2, 0x0f, 0x0f, 0x0f, 0x26, 0x26, 
	0x36, 0x27, 0x11, 0x98, 0x0f, 0x0f, 0x0f, 0x3c, 0xa1, 
	0x05, 0x1d, 0x6c, 0x79, 0x79, 0x79, 0x6c, 0x5d, 0x8e, 
	0x96, 0x6f, 0x8f, 0x8f, 0x07, 0x03, 0x03, 0x03, 0x1d, 
	0x1e, 0x6c, 0x6c, 0x5d, 0x1e, 0x61, 0x61, 0x5c, 0x47, 
	0x46, 0x99, 0x77, 0xa3, 0x1f, 0x61, 0x5d, 0x6c, 0x5d, 
	0x00, 0x04, 0x76, 0x8f, 0x70, 0x70, 0xa4, 0x9b, 0x42, 
	0x5d, 0x5d, 0x61, 0x76, 0x6d, 0x70, 0x96, 0x8f, 0x4b, 
	0x04, 0x00, 0x0c, 0x02, 0x1d, 0x61, 0x4c, 0x7d, 0x7d, 
	0x7d, 0x62, 0x70, 0x5d, 0x46, 0xa5, 0xa6, 0x02, 0x02, 
	0x00, 0x0a, 0x03, 0x20, 0x1e, 0x1e, 0xa7, 0x73, 0x73, 
	0xa8, 0x7a, 0x9c, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 
	0x0b, 0x02, 0x13, 0xa0, 0x50, 0x50, 0x50, 0x51, 0x10, 
	0x0f, 0x58, 0x25, 0x25, 0x26, 0x37, 0x25, 0x51, 0x57, 
	0x00, 0x08, 0x25, 0x1c, 0x52, 0x52, 0x52, 0x38, 0x3c, 
	0x36, 0x19, 0xa0, 0x50, 0x50, 0x51, 0x51, 0x57, 0x57, 
	0x57, 0x0f, 0x58, 0x25, 0x26, 0x36, 0x26, 0x0f, 0x00, 
	0x06, 0x57, 0x36, 0x9e, 0x9e, 0x26, 0x3a, 0x02, 0x02, 
	0x02, 0x0c, 0x51, 0x51, 0x57, 0x00, 0x04, 0x88, 0x26, 
	0x37, 0x52, 0x36, 0x26, 0x88, 0x88, 0x36, 0xa1, 0x9e, 
	0x36, 0x0e, 0x10, 0x10, 0x0f, 0x0f, 0x26, 0x26, 0x36, 
	0x11, 0x58, 0x0f, 0x0f, 0x0f, 0x36, 0x7a, 0x27, 0x5c, 
	0x00, 0x04, 0x79, 0x6c, 0x41, 0x7b, 0x76, 0x77, 0x8f, 
	0x8f, 0x9a, 0x4b, 0x03, 0x03, 0x64, 0x5d, 0x79, 0x79, 
	0x6c, 0x5d, 0x1e, 0x61, 0x61, 0x5c, 0x47, 0x89, 0x99, 
	0x54, 0x6f, 0x5a, 0x5c, 0x61, 0x1e, 0x41, 0x00, 0x04, 
	0x76, 0x8f, 0x70, 0x70, 0xa9, 0x8c, 0x42, 0x5d, 0x5d, 
	0x42, 0x99, 0x6d, 0x70, 0x76, 0x77, 0x9a, 0x67, 0x18, 
	0x00, 0x0a, 0x02, 0x71, 0x61, 0x1e, 0x55, 0x7d, 0x7d, 
	0x55, 0x6e, 0x70, 0x5d, 0x1e, 0x8f, 0x92, 0x63, 0x02, 
	0x00, 0x09, 0x03, 0x30, 0x1e, 0x1e, 0xaa, 0x73, 0x73, 
	0x73, 0xa3, 0x70, 0x9c, 0x00, 0x0a, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x28, 0x4f, 0x50, 0x50, 0x50, 0x57, 
	0x0f, 0x58, 0x58, 0x25, 0x25, 0x26, 0x36, 0x36, 0x0f, 
	0x57, 0x98, 0x00, 0x08, 0x25, 0x26, 0x00, 0x04, 0x52, 
	0x3c, 0x3c, 0x95, 0x50, 0x50, 0x50, 0x51, 0x0f, 0x0f, 
	0x98, 0x58, 0x24, 0x24, 0x88, 0x36, 0x36, 0x3c, 0x98, 
	0x0f, 0x10, 0x0f, 0x0f, 0x0e, 0x36, 0x9e, 0x9e, 0x9e, 
	0x26, 0x31, 0x02, 0x02, 0x02, 0x28, 0x51, 0x51, 0x0f, 
	0x00, 0x04, 0x88, 0x3c, 0x69, 0x69, 0x3c, 0x26, 0x88, 
	0x26, 0x26, 0x9e, 0x26, 0x98, 0x0f, 0x10, 0x57, 0x10, 
	0x0f, 0x26, 0x26, 0x26, 0x88, 0x24, 0x24, 0x25, 0x88, 
	0xa1, 0x7a, 0x27, 0x5d, 0x8d, 0x8d, 0x79, 0x1e, 0x46, 
	0x00, 0x04, 0x76, 0x6f, 0x9a, 0xa5, 0xa5, 0x07, 0x1a, 
	0x5d, 0x8d, 0x79, 0x79, 0x6c, 0x5d, 0x5c, 0x47, 0x8e, 
	0x46, 0x46, 0x76, 0x77, 0x6f, 0x8f, 0x9c, 0x7b, 0x8e, 
	0x46, 0x7b, 0x00, 0x04, 0x76, 0x6d, 0x70, 0x70, 0xa9, 
	0x8c, 0x61, 0x5d, 0x5d, 0x5c, 0x99, 0x6d, 0x70, 0x89, 
	0x8e, 0x9a, 0x9a, 0xab, 0x18, 0x00, 0x08, 0x02, 0x18, 
	0x20, 0x1e, 0x7c, 0x7d, 0x7d, 0x7d, 0x08, 0x70, 0x70, 
	0x5d, 0x5d, 0xac, 0xa5, 0x9c, 0x43, 0x00, 0x08, 0x03, 
	0x19, 0x1e, 0x1e, 0x4c, 0x00, 0x04, 0x73, 0x74, 0x70, 
	0x9c, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 
	0x13, 0x4f, 0x50, 0x50, 0x51, 0x58, 0x00, 0x05, 0x25, 
	0x26, 0x36, 0x36, 0x36, 0x58, 0x10, 0x24, 0x00, 0x08, 
	0x25, 0x88, 0x38, 0x52, 0x52, 0x11, 0x3c, 0x88, 0x51, 
	0x50, 0x50, 0x0f, 0x25, 0x00, 0x06, 0xad, 0x26, 0x3c, 
	0x37, 0x37, 0x25, 0x0f, 0x25, 0x88, 0x88, 0x88, 0x37, 
	0x9e, 0x9e, 0x9e, 0x26, 0x31, 0x02, 0x02, 0x02, 0x1a, 
	0x10, 0x57, 0x24, 0x00, 0x04, 0x88, 0x52, 0x9e, 0x52, 
	0x25, 0x25, 0x26, 0x26, 0x26, 0x11, 0x98, 0x58, 0x0f, 
	0x10, 0x57, 0x57, 0x0f, 0x00, 0x07, 0x26, 0x36, 0x27, 
	0x7a, 0xa5, 0x79, 0x8d, 0x8d, 0x5c, 0x76, 0x76, 0x76, 
	0xac, 0x96, 0x76, 0x99, 0xa5, 0xa5, 0x62, 0x67, 0x49, 
	0x79, 0x79, 0x8d, 0x79, 0x5c, 0x00, 0x07, 0x76, 0x96, 
	0x6d, 0x9a, 0x62, 0x6a, 0x76, 0x7b, 0x7b, 0x00, 0x04, 
	0x76, 0x6f, 0x70, 0x70, 0xae, 0x40, 0x1e, 0x5d, 0x5d, 
	0x5c, 0x99, 0x6d, 0x70, 0x46, 0x1e, 0x6d, 0x9a, 0x8f, 
	0xaf, 0x00, 0x08, 0x02, 0xb0, 0x61, 0x4c, 0x00, 0x04, 
	0x7d, 0x7b, 0x70, 0x70, 0x1e, 0x5d, 0x41, 0xa5, 0xa5, 
	0x59, 0x00, 0x08, 0x03, 0x20, 0x1e, 0x1e, 0x66, 0x73, 
	0x73, 0x73, 0xa8, 0x9d, 0x70, 0x92, 0x00, 0x0a, 0x03, 
	0x01, 0x01, 0x00, 0x09, 0x02, 0x55, 0x51, 0x50, 0x0f, 
	0x00, 0x07, 0x25, 0x88, 0x26, 0x36, 0x36, 0x24, 0x10, 
	0x00, 0x0a, 0x25, 0x3c, 0x11, 0x11, 0x11, 0x37, 0x0f, 
	0x50, 0x50, 0x0e, 0x00, 0x07, 0xad, 0x88, 0x88, 0x36, 
	0x14, 0x52, 0x26, 0x0f, 0x25, 0x88, 0x88, 0x88, 0x37, 
	0x9e, 0x9e, 0x69, 0x88, 0xaa, 0x02, 0x02, 0x02, 0x33, 
	0x10, 0x10, 0x25, 0x88, 0x88, 0x88, 0x26, 0x69, 0x9e, 
	0x52, 0x58, 0x58, 0x88, 0x26, 0x26, 0x11, 0x98, 0x25, 
	0x25, 0x24, 0x25, 0x88, 0x00, 0x09, 0x26, 0xa1, 0x7a, 
	0x9d, 0x79, 0x79, 0x42, 0x76, 0x76, 0x76, 0x96, 0x9a, 
	0x5c, 0x76, 0x76, 0x6f, 0xb1, 0x5e, 0x9a, 0x5d, 0x79, 
	0x79, 0x79, 0x41, 0x00, 0x09, 0x76, 0x6f, 0xb1, 0x5e, 
	0x8f, 0x41, 0x5c, 0x42, 0x5c, 0x76, 0x76, 0x76, 0x6f, 
	0x70, 0x70, 0xb2, 0x46, 0x1e, 0x5d, 0x5d, 0x41, 0x99, 
	0x6d, 0x70, 0x46, 0x1e, 0x99, 0x9a, 0x9a, 0x9c, 0x2b, 
	0x00, 0x06, 0x02, 0x04, 0x1e, 0x1e, 0x4a, 0x7d, 0x7d, 
	0x7d, 0x49, 0x96, 0x70, 0x70, 0x1e, 0x5d, 0x1e, 0x6d, 
	0xa5, 0xa5, 0x2f, 0x00, 0x06, 0x03, 0x22, 0x1e, 0x1e, 
	0x33, 0x00, 0x04, 0x73, 0x39, 0x6d, 0x70, 0x92, 0x00, 
	0x0a, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x95, 0x57, 
	0x0f, 0x00, 0x09, 0x25, 0x88, 0x26, 0x36, 0x88, 0x0f, 
	0x00, 0x0a, 0x25, 0x36, 0x11, 0x11, 0x11, 0x37, 0x51, 
	0x51, 0x10, 0x25, 0x00, 0x06, 0xad, 0x00, 0x04, 0x88, 
	0x11, 0x53, 0x3c, 0x0f, 0x25, 0x88, 0x88, 0x88, 0x14, 
	0x9e, 0x9e, 0x69, 0x88, 0x30, 0x02, 0x02, 0x02, 0xb3, 
	0x10, 0x10, 0x00, 0x04, 0x88, 0x3c, 0x9e, 0x9e, 0x37, 
	0x0f, 0x0f, 0x88, 0x26, 0x26, 0x11, 0x58, 0x00, 0x0e, 
	0x26, 0x9e, 0x7a, 0xb4, 0x79, 0x5d, 0x7b, 0x76, 0x76, 
	0x76, 0x8f, 0x6f, 0x42, 0x76, 0x76, 0x96, 0x5e, 0x5e, 
	0xb5, 0x5d, 0x79, 0x79, 0x1e, 0x00, 0x0a, 0x76, 0x96, 
	0x5e, 0x6e, 0x5e, 0x1e, 0x6c, 0xb6, 0x42, 0x76, 0x76, 
	0x76, 0x8a, 0x70, 0x70, 0x67, 0x46, 0x1e, 0x1e, 0x1e, 
	0x47, 0x99, 0x6d, 0x70, 0x46, 0x1e, 0x8e, 0x8f, 0x9a, 
	0x9a, 0x4b, 0x04, 0x00, 0x05, 0x02, 0x1d, 0x61, 0x6c, 
	0x7d, 0x7d, 0x7d, 0x33, 0x76, 0x96, 0x7a, 0x70, 0x1e, 
	0x5d, 0x5d, 0x99, 0x9a, 0xa5, 0x9a, 0x0b, 0x00, 0x05, 
	0x03, 0x1e, 0x1e, 0x4c, 0x7e, 0x73, 0x73, 0x73, 0x86, 
	0x96, 0x6f, 0x70, 0x65, 0x00, 0x0a, 0x03, 0x01, 0x01, 
	0x00, 0x09, 0x02, 0xb7, 0x0f, 0x00, 0x0b, 0x25, 0x88, 
	0x26, 0x36, 0x58, 0x00, 0x0a, 0x25, 0x26, 0x11, 0x11, 
	0x11, 0x1c, 0x57, 0x51, 0x24, 0x00, 0x04, 0xad, 0x1c, 
	0x9e, 0x37, 0x00, 0x04, 0x88, 0x14, 0x69, 0x37, 0x0f, 
	0x25, 0x88, 0x88, 0x88, 0x52, 0x9e, 0x9e, 0x69, 0x25, 
	0x22, 0x02, 0x02, 0x18, 0xb8, 0x10, 0x10, 0x00, 0x04, 
	0x88, 0x52, 0x9e, 0x9e, 0xb9, 0x10, 0x10, 0x88, 0x26, 
	0x26, 0x11, 0x58, 0x00, 0x0e, 0x26, 0x69, 0x7a, 0x46, 
	0x6c, 0x8e, 0x76, 0x76, 0x76, 0x96, 0xb5, 0x99, 0x42, 
	0x76, 0x76, 0x76, 0x5e, 0x70, 0x5e, 0x6c, 0x79, 0x6c, 
	0x89, 0x00, 0x04, 0x76, 0x8f, 0xb5, 0x54, 0x00, 0x04, 
	0x76, 0xb5, 0x7a, 0x7a, 0x42, 0x6c, 0x6c, 0x41, 0x76, 
	0x76, 0x76, 0x54, 0x70, 0x70, 0x59, 0x46, 0x1e, 0x1e, 
	0x1e, 0x47, 0x99, 0x6d, 0x70, 0x47, 0x1e, 0x47, 0x96, 
	0x8f, 0x9a, 0x9a, 0x67, 0x18, 0x02, 0x02, 0x02, 0xba, 
	0x61, 0x1e, 0x55, 0x7d, 0x7d, 0x7d, 0x40, 0x99, 0x96, 
	0x7a, 0x70, 0x1e, 0x5d, 0x1e, 0x76, 0x8a, 0xa5, 0xa5, 
	0x92, 0x21, 0x03, 0x03, 0x03, 0x91, 0x1e, 0x1e, 0x66, 
	0x73, 0x73, 0x73, 0xa7, 0x3d, 0x96, 0x6f, 0x70, 0x65, 
	0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0xb7, 
	0x98, 0x00, 0x0c, 0x25, 0x88, 0x1c, 0x24, 0x00, 0x0a, 
	0x25, 0x88, 0x52, 0x11, 0x11, 0x3c, 0x57, 0x10, 0x00, 
	0x05, 0xad, 0x37, 0x69, 0x14, 0x26, 0x88, 0x88, 0x88, 
	0x1c, 0x69, 0x14, 0x0f, 0x25, 0x88, 0x88, 0x88, 0x52, 
	0x9e, 0x9e, 0x11, 0x25, 0x19, 0x18, 0x18, 0x18, 0xbb, 
	0x10, 0x0f, 0x88, 0x88, 0x88, 0x26, 0x9e, 0x9e, 0x9e, 
	0x88, 0x10, 0x10, 0x88, 0x26, 0x26, 0x11, 0x58, 0x00, 
	0x0e, 0x26, 0x53, 0x7a, 0x47, 0x5d, 0x00, 0x04, 0x76, 
	0x8f, 0xb5, 0x47, 0x42, 0x76, 0x76, 0x76, 0x27, 0x70, 
	0x9a, 0x6c, 0x6c, 0x42, 0x00, 0x05, 0x76, 0x5e, 0xb1, 
	0x96, 0x00, 0x04, 0x76, 0xb1, 0x70, 0x27, 0x1e, 0x6c, 
	0x6c, 0x46, 0x76, 0x76, 0x76, 0x77, 0x70, 0x70, 0x9c, 
	0x46, 0x1e, 0x1e, 0x1e, 0x46, 0x99, 0x6d, 0x70, 0x47, 
	0x1e, 0x46, 0x99, 0x77, 0x9a, 0x9a, 0x9a, 0xab, 0x02, 
	0x02, 0x18, 0x49, 0x61, 0x7c, 0x68, 0x7d, 0x7d, 0x4c, 
	0x99, 0x99, 0x96, 0x27, 0x70, 0x1e, 0x5d, 0x1e, 0x76, 
	0xbc, 0x6d, 0xa5, 0xa5, 0x4b, 0x19, 0x03, 0x1a, 0x1e, 
	0x1e, 0x31, 0x7e, 0x73, 0x73, 0x73, 0xbd, 0x96, 0x96, 
	0x6f, 0x70, 0x62, 0x00, 0x0a, 0x03, 0x01, 0x01, 0x00, 
	0x09, 0x02, 0x9f, 0x58, 0x00, 0x0d, 0x25, 0x3c, 0x88, 
	0x00, 0x0b, 0x25, 0x38, 0x11, 0x11, 0x36, 0x57, 0x0f, 
	0x00, 0x04, 0xad, 0x88, 0x14, 0x53, 0x14, 0x25, 0x88, 
	0x88, 0x88, 0x3c, 0x69, 0x52, 0x0f, 0x25, 0x88, 0x88, 
	0x88, 0x11, 0x9e, 0x9e, 0x11, 0x25, 0xbe, 0x3e, 0x18, 
	0x1b, 0x10, 0x10, 0x98, 0x88, 0x88, 0x88, 0x36, 0xa1, 
	0xa1, 0x9e, 0x24, 0x10, 0x10, 0x26, 0x26, 0x26, 0x11, 
	0x58, 0x00, 0x0e, 0x26, 0x11, 0x7a, 0x47, 0x42, 0x00, 
	0x04, 0x76, 0xb5, 0x62, 0x5d, 0x1e, 0x76, 0x76, 0x76, 
	0x27, 0x70, 0x6f, 0x6c, 0x6c, 0x8e, 0x00, 0x04, 0x76, 
	0x99, 0x6e, 0x5e, 0x8e, 0x47, 0x76, 0x76, 0x76, 0xa5, 
	0x70, 0x5e, 0x1e, 0x6c, 0x5d, 0x00, 0x04, 0x76, 0xac, 
	0x70, 0x70, 0x92, 0x47, 0x1e, 0x1e, 0x1e, 0x46, 0x99, 
	0x8f, 0x70, 0x47, 0x1e, 0x46, 0x99, 0x99, 0x6f, 0x9a, 
	0x9a, 0x92, 0x63, 0x02, 0x21, 0x61, 0x4c, 0x55, 0x68, 
	0x7d, 0x55, 0x7b, 0x99, 0x99, 0xbc, 0x5e, 0x70, 0x1e, 
	0x1e, 0x1e, 0x99, 0x99, 0x96, 0x8f, 0xa5, 0xa5, 0x67, 
	0x03, 0x4c, 0x1e, 0x1e, 0xa7, 0x7e, 0x73, 0x73, 0xbe, 
	0x99, 0x96, 0x96, 0x54, 0x70, 0x62, 0x00, 0x0a, 0x03, 
	0x01, 0x01, 0x00, 0x09, 0x02, 0x3a, 0x58, 0x00, 0x08, 
	0x25, 0x88, 0x00, 0x04, 0x25, 0x36, 0x26, 0x00, 0x07, 
	0x25, 0x88, 0x26, 0x25, 0xad, 0x3c, 0x11, 0x11, 0x26, 
	0x57, 0x24, 0xad, 0xad, 0xad, 0x88, 0x88, 0x52, 0x53, 
	0x11, 0x24, 0x25, 0x88, 0x88, 0x36, 0x69, 0x11, 0x0f, 
	0x25, 0x88, 0x88, 0x88, 0x11, 0x9e, 0x9e, 0x52, 0x24, 
	0x3c, 0x52, 0x54, 0x0b, 0x10, 0x10, 0x58, 0x88, 0x88, 
	0x88, 0x1c, 0xa1, 0xa1, 0x9e, 0x0f, 0x10, 0x0f, 0x26, 
	0x26, 0x26, 0x11, 0x58, 0x00, 0x0e, 0x26, 0x52, 0x27, 
	0x41, 0x5c, 0x76, 0x76, 0x76, 0x96, 0x6e, 0x8f, 0x5d, 
	0x5c, 0x76, 0x76, 0x76, 0x27, 0x70, 0x99, 0x6c, 0x5d, 
	0x00, 0x05, 0x76, 0x96, 0x7a, 0x5e, 0x41, 0x41, 0x89, 
	0x76, 0x76, 0x8f, 0x70, 0x5e, 0x5d, 0x6c, 0x1e, 0x00, 
	0x04, 0x76, 0x96, 0x7a, 0x70, 0x65, 0x47, 0x1e, 0x1e, 
	0x1e, 0x46, 0x99, 0x8f, 0x70, 0x47, 0x1e, 0x46, 0x99, 
	0x99, 0x99, 0x6d, 0x9a, 0x9a, 0x9c, 0x05, 0x61, 0x1e, 
	0x4a, 0x7d, 0x68, 0x7d, 0xbf, 0x00, 0x04, 0x99, 0x5e, 
	0x70, 0x1e, 0x1e, 0x1e, 0x99, 0x99, 0x99, 0x77, 0x9a, 
	0xa5, 0xa5, 0x2f, 0x1e, 0x1e, 0xaa, 0x7e, 0x73, 0x73, 
	0x73, 0x7b, 0x96, 0x96, 0x96, 0x54, 0x70, 0x5e, 0x6b, 
	0x00, 0x09, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x31, 
	0x58, 0x00, 0x04, 0x25, 0x36, 0x52, 0x9e, 0x9e, 0xa1, 
	0x52, 0x26, 0x25, 0x25, 0x88, 0x36, 0x00, 0x06, 0x25, 
	0x26, 0x52, 0x53, 0x26, 0xad, 0x36, 0x11, 0x11, 0x36, 
	0x10, 0x25, 0xad, 0xad, 0x88, 0x88, 0x88, 0x52, 0x53, 
	0x11, 0x58, 0x24, 0x88, 0x88, 0x26, 0x69, 0x11, 0x0f, 
	0x25, 0x88, 0x88, 0x88, 0x69, 0x9e, 0x9e, 0x14, 0x57, 
	0x25, 0x36, 0x37, 0x3c, 0x10, 0x10, 0x24, 0x88, 0x88, 
	0x88, 0x37, 0xa1, 0xa1, 0x9e, 0x10, 0x10, 0x98, 0x26, 
	0x26, 0xb9, 0x52, 0x0e, 0x00, 0x0e, 0x26, 0x38, 0x27, 
	0x5c, 0x47, 0x76, 0x76, 0x76, 0x77, 0x7a, 0x6f, 0x5d, 
	0x47, 0x76, 0x76, 0x99, 0x27, 0x70, 0x76, 0x5d, 0x42, 
	0x00, 0x05, 0x76, 0x77, 0x70, 0x5e, 0x42, 0x61, 0x46, 
	0x76, 0x76, 0x8f, 0x70, 0x62, 0x6c, 0x6c, 0x5c, 0x00, 
	0x04, 0x76, 0x96, 0x7a, 0x70, 0x62, 0x47, 0x1e, 0x1e, 
	0x1e, 0x89, 0x99, 0x8f, 0x70, 0x5c, 0x1e, 0x46, 0x99, 
	0x99, 0x99, 0xbc, 0x8f, 0x9a, 0x9a, 0x6f, 0x42, 0x7c, 
	0x55, 0x68, 0x68, 0x7c, 0x76, 0x00, 0x04, 0x99, 0x5e, 
	0x70, 0x1e, 0x1e, 0x61, 0x00, 0x04, 0x99, 0x54, 0xa5, 
	0xa5, 0x9a, 0x47, 0x4c, 0x7e, 0x7e, 0x73, 0x73, 0x7f, 
	0x00, 0x04, 0x96, 0x54, 0x70, 0x5e, 0x6b, 0x00, 0x09, 
	0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x31, 0x58, 0x24, 
	0x25, 0x25, 0x88, 0x52, 0x11, 0x9e, 0x27, 0x27, 0x11, 
	0x26, 0x25, 0x25, 0x88, 0x26, 0x00, 0x06, 0x25, 0x37, 
	0x11, 0x38, 0x25, 0xad, 0x26, 0x11, 0x11, 0x36, 0x0f, 
	0x25, 0x00, 0x05, 0x88, 0x52, 0x53, 0x53, 0x58, 0x58, 
	0x88, 0x88, 0x26, 0x9e, 0x53, 0x0e, 0x25, 0x88, 0x88, 
	0x26, 0x69, 0x9e, 0x9e, 0x26, 0x50, 0x00, 0x04, 0x25, 
	0x10, 0x10, 0x25, 0x88, 0x26, 0x26, 0x37, 0xa1, 0xa1, 
	0x11, 0x10, 0x10, 0x58, 0x26, 0x26, 0x1c, 0x14, 0x0e, 
	0x00, 0x0e, 0x26, 0x37, 0x27, 0x5c, 0x46, 0x76, 0x76, 
	0x76, 0x96, 0x5e, 0x77, 0x5d, 0x46, 0x76, 0x76, 0x99, 
	0x27, 0x70, 0x46, 0x5d, 0x41, 0x00, 0x05, 0x76, 0x54, 
	0x70, 0x5e, 0x61, 0x61, 0x46, 0x76, 0x76, 0x8f, 0x7a, 
	0x6d, 0x5d, 0x6c, 0x8e, 0x00, 0x04, 0x76, 0x99, 0x6e, 
	0x70, 0x62, 0x41, 0x1e, 0x1e, 0x1e, 0x76, 0x99, 0x8f, 
	0x70, 0x5c, 0x1e, 0x7b, 0x00, 0x04, 0x99, 0x96, 0x8f, 
	0x9a, 0x9a, 0x96, 0x55, 0x68, 0x68, 0x68, 0x46, 0x00, 
	0x05, 0x99, 0xb1, 0x70, 0x1e, 0x1e, 0x42, 0x00, 0x04, 
	0x99, 0xbc, 0x6f, 0xa5, 0xa5, 0x9c, 0x66, 0x7e, 0x7e, 
	0x73, 0x4d, 0x99, 0x00, 0x04, 0x96, 0x54, 0x70, 0x5e, 
	0x6b, 0x00, 0x09, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 
	0xbe, 0x58, 0x24, 0x25, 0x25, 0x88, 0x52, 0x52, 0x52, 
	0x53, 0x52, 0x36, 0x00, 0x04, 0x25, 0x26, 0x00, 0x06, 
	0x25, 0x52, 0x11, 0x38, 0x24, 0x25, 0x88, 0x52, 0x11, 
	0x36, 0x0f, 0xad, 0x00, 0x05, 0x88, 0x11, 0x53, 0x53, 
	0x58, 0x58, 0x88, 0x88, 0x3c, 0x53, 0x52, 0x0f, 0x25, 
	0x88, 0x88, 0x26, 0x9e, 0x9e, 0x69, 0x57, 0x50, 0x24, 
	0x25, 0x25, 0x25, 0x10, 0x10, 0x25, 0x88, 0x26, 0x26, 
	0x1c, 0xa1, 0x9e, 0x38, 0x10, 0x10, 0x24, 0x26, 0x26, 
	0x14, 0x37, 0x0e, 0x00, 0x0e, 0x26, 0x3c, 0x27, 0x5c, 
	0x46, 0x00, 0x04, 0x76, 0xa5, 0x54, 0x1e, 0x77, 0x6f, 
	0x8f, 0xa5, 0x6e, 0x70, 0x47, 0x5d, 0x8e, 0x00, 0x05, 
	0x76, 0x6f, 0x70, 0xb5, 0x61, 0x61, 0x46, 0x76, 0x99, 
	0xb1, 0x5e, 0x96, 0x1e, 0x1e, 0x89, 0x00, 0x04, 0x76, 
	0x99, 0x6e, 0x70, 0xb5, 0x41, 0x1e, 0x1e, 0x1e, 0x76, 
	0x99, 0xa5, 0x5e, 0x42, 0x1e, 0x76, 0x00, 0x05, 0x99, 
	0x77, 0x9a, 0x9a, 0x9d, 0x55, 0x68, 0x68, 0x49, 0x00, 
	0x06, 0x99, 0xb1, 0x70, 0x42, 0x1e, 0x5c, 0x00, 0x05, 
	0x99, 0x96, 0x8f, 0xa5, 0xa5, 0x1f, 0x7e, 0x7e, 0x73, 
	0x80, 0x00, 0x05, 0x96, 0x77, 0x70, 0x6e, 0x6b, 0x00, 
	0x09, 0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x6b, 0x58, 
	0x24, 0x25, 0x25, 0x88, 0x00, 0x04, 0x52, 0x98, 0x51, 
	0x0e, 0x25, 0x25, 0x25, 0x88, 0x00, 0x04, 0x25, 0xad, 
	0x88, 0x11, 0x11, 0x38, 0x58, 0x25, 0x88, 0x38, 0x11, 
	0x36, 0x0f, 0x00, 0x06, 0x88, 0x11, 0x53, 0x53, 0x24, 
	0x58, 0x88, 0x3c, 0x11, 0x11, 0x37, 0x0f, 0x24, 0x88, 
	0x88, 0x26, 0x9e, 0x9e, 0x3c, 0x50, 0x50, 0x24, 0x25, 
	0x25, 0x26, 0x24, 0x10, 0x88, 0x26, 0x26, 0x26, 0x3c, 
	0xa1, 0x11, 0x58, 0x10, 0x10, 0x25, 0x26, 0x26, 0x11, 
	0x1c, 0x0e, 0x00, 0x0d, 0x26, 0x36, 0x14, 0xa1, 0x42, 
	0x7b, 0x00, 0x04, 0x76, 0x54, 0x6d, 0x8f, 0x00, 0x05, 
	0x27, 0x5e, 0x5c, 0x5d, 0x46, 0x00, 0x05, 0x76, 0x8f, 
	0x70, 0xb1, 0x61, 0x61, 0x46, 0xbc, 0x9a, 0xb1, 0xb5, 
	0x40, 0x61, 0x61, 0x89, 0x76, 0x76, 0x76, 0x99, 0x99, 
	0x27, 0x70, 0x5e, 0x5c, 0x1e, 0x1e, 0x1e, 0x76, 0x99, 
	0x5e, 0x62, 0x1e, 0x1e, 0x76, 0x00, 0x06, 0x99, 0x6f, 
	0x9a, 0x8f, 0x7c, 0x68, 0x4a, 0x76, 0x00, 0x06, 0x99, 
	0x62, 0x70, 0x42, 0x1e, 0x5c, 0x00, 0x05, 0x99, 0x96, 
	0x96, 0x8f, 0xa5, 0x85, 0x7e, 0x73, 0x08, 0x00, 0x06, 
	0x96, 0x77, 0x70, 0x6e, 0x21, 0x00, 0x09, 0x03, 0x01, 
	0x01, 0x00, 0x09, 0x02, 0x6b, 0x58, 0x24, 0x25, 0x25, 
	0x88, 0x00, 0x04, 0x52, 0x10, 0x51, 0x51, 0x25, 0x25, 
	0x88, 0x26, 0x25, 0x25, 0x25, 0xad, 0xad, 0x26, 0x11, 
	0x11, 0x37, 0x0f, 0x24, 0xad, 0x1c, 0x11, 0x36, 0x0e, 
	0x00, 0x06, 0x88, 0x11, 0x53, 0x53, 0x25, 0x98, 0x1c, 
	0x11, 0x11, 0x11, 0x36, 0x0f, 0x24, 0x88, 0x88, 0x36, 
	0x9e, 0x9e, 0x0e, 0x50, 0x10, 0x88, 0x36, 0x52, 0x11, 
	0x24, 0x0f, 0x00, 0x04, 0x26, 0x36, 0x53, 0x24, 0x0f, 
	0x0f, 0x10, 0x88, 0x26, 0x26, 0x9e, 0x3c, 0x0e, 0x00, 
	0x09, 0x26, 0x36, 0x3c, 0x52, 0x69, 0x9e, 0x9e, 0x8a, 
	0x61, 0x00, 0x06, 0x76, 0x9a, 0x9a, 0xa5, 0xb5, 0x5e, 
	0x62, 0x9c, 0x41, 0x5d, 0x5d, 0x89, 0x00, 0x05, 0x76, 
	0x9a, 0x70, 0x62, 0x61, 0x61, 0x76, 0x62, 0xb1, 0xb1, 
	0x8f, 0x61, 0x61, 0x61, 0x89, 0x76, 0x76, 0x99, 0x99, 
	0x99, 0x5e, 0x70, 0x5e, 0x41, 0x1e, 0x1e, 0x1e, 0x99, 
	0x77, 0x70, 0x6d, 0x1e, 0x1e, 0x76, 0x00, 0x07, 0x99, 
	0x6d, 0x9a, 0x4c, 0x55, 0x41, 0x00, 0x07, 0x99, 0xa5, 
	0x70, 0x42, 0x1e, 0x41, 0x00, 0x04, 0x99, 0x96, 0x96, 
	0x96, 0x77, 0x9a, 0x3d, 0x7e, 0xa8, 0x3d, 0x00, 0x06, 
	0x96, 0x77, 0x70, 0x6e, 0x21, 0x00, 0x09, 0x03, 0x01, 
	0x01, 0x00, 0x09, 0x02, 0xba, 0x58, 0x24, 0x25, 0x25, 
	0x26, 0x00, 0x04, 0x52, 0x0f, 0x57, 0x0f, 0x25, 0x25, 
	0x88, 0x36, 0x25, 0x25, 0xad, 0xad, 0xad, 0x36, 0x11, 
	0x11, 0x37, 0x0f, 0x24, 0xad, 0x36, 0x11, 0x36, 0x58, 
	0x00, 0x06, 0x88, 0x53, 0x53, 0x53, 0x25, 0x25, 0x00, 
	0x04, 0x11, 0x24, 0x0f, 0x24, 0x88, 0x88, 0x36, 0x9e, 
	0x52, 0x51, 0x56, 0x88, 0x36, 0x11, 0x11, 0x1c, 0x10, 
	0x0f, 0x00, 0x04, 0x26, 0x36, 0x88, 0x00, 0x04, 0x0f, 
	0x88, 0x26, 0x26, 0xa1, 0x36, 0x0e, 0x00, 0x04, 0x26, 
	0x36, 0x3c, 0x26, 0x26, 0x26, 0x9e, 0xa1, 0x9e, 0x9e, 
	0x9e, 0x8f, 0x5c, 0x5c, 0x00, 0x06, 0x76, 0x77, 0x8f, 
	0x8f, 0x8f, 0x9a, 0x4b, 0x1f, 0x5d, 0x5d, 0x1e, 0x00, 
	0x06, 0x76, 0x62, 0x70, 0x9a, 0x61, 0x5c, 0xa5, 0xb1, 
	0xb1, 0x6a, 0x46, 0x61, 0x61, 0x61, 0x89, 0x76, 0x00, 
	0x04, 0x99, 0x5e, 0x70, 0x5e, 0x5c, 0x1e, 0x1e, 0x42, 
	0x99, 0x6d, 0x70, 0xac, 0x1e, 0x1e, 0x76, 0x00, 0x07, 
	0x99, 0x96, 0x8f, 0xc0, 0x4c, 0x00, 0x08, 0x99, 0x9a, 
	0x70, 0x5c, 0x1e, 0x47, 0x00, 0x04, 0x99, 0x00, 0x04, 
	0x96, 0x8a, 0x54, 0x7e, 0x85, 0x00, 0x08, 0x96, 0x7a, 
	0x70, 0x21, 0x00, 0x09, 0x03, 0x01, 0x01, 0x00, 0x09, 
	0x02, 0x71, 0x58, 0x24, 0x25, 0x25, 0x26, 0x52, 0x52, 
	0x52, 0x37, 0x0e, 0x0f, 0x25, 0x25, 0x25, 0x36, 0x3c, 
	0x25, 0x00, 0x04, 0xad, 0x3c, 0x11, 0x11, 0x1c, 0x0f, 
	0x24, 0x88, 0x26, 0x11, 0x36, 0x58, 0x00, 0x05, 0x88, 
	0x26, 0x53, 0x53, 0x53, 0x25, 0x3c, 0x11, 0x11, 0x9d, 
	0x86, 0xb7, 0x0f, 0x24, 0x88, 0x88, 0x36, 0x9e, 0x88, 
	0x51, 0x25, 0x26, 0x52, 0x11, 0x3c, 0x0f, 0x10, 0x98, 
	0x00, 0x09, 0x26, 0x88, 0x26, 0x26, 0x3c, 0xa1, 0x36, 
	0x58, 0x37, 0x52, 0x69, 0xa1, 0x9e, 0x25, 0x26, 0x26, 
	0x26, 0xa1, 0x15, 0x27, 0x9a, 0x67, 0x41, 0x5c, 0x5c, 
	0x00, 0x07, 0x76, 0x8a, 0x8f, 0x8f, 0x8f, 0xa5, 0x7b, 
	0x5d, 0x5d, 0x42, 0x00, 0x06, 0x76, 0xb1, 0x70, 0x9a, 
	0x61, 0x77, 0xb1, 0x62, 0x5a, 0x03, 0x8c, 0x61, 0x61, 
	0x61, 0x89, 0x00, 0x05, 0x99, 0x5e, 0x70, 0x6e, 0x5c, 
	0x1e, 0x1e, 0x42, 0x99, 0x62, 0x70, 0x46, 0x1e, 0x61, 
	0x76, 0x00, 0x08, 0x99, 0xac, 0x46, 0x46, 0x00, 0x08, 
	0x99, 0x8f, 0x70, 0x5c, 0x1e, 0x46, 0x99, 0x99, 0x99, 
	0x00, 0x06, 0x96, 0x6f, 0x86, 0x00, 0x09, 0x96, 0x7a, 
	0x70, 0x21, 0x00, 0x09, 0x03, 0x01, 0x01, 0x00, 0x09, 
	0x02, 0x04, 0x97, 0x24, 0x25, 0x25, 0x26, 0x52, 0x52, 
	0x52, 0xc1, 0x10, 0x0f, 0x25, 0x25, 0x25, 0x3c, 0x1c, 
	0x25, 0x00, 0x04, 0xad, 0x37, 0x11, 0x11, 0x3c, 0x0f, 
	0x24, 0x88, 0x88, 0x52, 0x36, 0x24, 0x00, 0x05, 0x88, 
	0x26, 0x53, 0x53, 0x53, 0x26, 0x52, 0x11, 0x96, 0x6b, 
	0x28, 0xb7, 0x0f, 0x24, 0x88, 0x88, 0x3c, 0xc2, 0x56, 
	0x58, 0x26, 0x38, 0x11, 0x3c, 0x7f, 0x10, 0x10, 0x58, 
	0x00, 0x0c, 0x26, 0x37, 0xa1, 0x26, 0x52, 0xa1, 0xa1, 
	0xa1, 0x9e, 0x25, 0x0f, 0x26, 0x26, 0x26, 0xa1, 0x15, 
	0x15, 0x6a, 0x18, 0x3f, 0x8e, 0x46, 0x00, 0x08, 0x76, 
	0x6f, 0x8f, 0x8f, 0x8f, 0x89, 0x5d, 0x5d, 0x5c, 0x00, 
	0x06, 0x76, 0x5e, 0x70, 0x8f, 0x47, 0x62, 0x9c, 0x07, 
	0x03, 0x03, 0x3f, 0x61, 0x61, 0x61, 0x89, 0x00, 0x05, 
	0x99, 0x62, 0x70, 0x7a, 0x5c, 0x1e, 0x1e, 0x5c, 0x99, 
	0x5e, 0x7a, 0x41, 0x1e, 0x42, 0x00, 0x14, 0x99, 0x8f, 
	0x70, 0x5c, 0x1e, 0x46, 0x99, 0x99, 0x00, 0x08, 0x96, 
	0x99, 0x00, 0x09, 0x96, 0x7a, 0x70, 0x21, 0x00, 0x09, 
	0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x04, 0x97, 0x58, 
	0x25, 0x25, 0x88, 0x52, 0x52, 0xc3, 0xc4, 0x51, 0x10, 
	0x25, 0x25, 0xad, 0x38, 0x37, 0x25, 0xad, 0xad, 0xad, 
	0x88, 0x52, 0x11, 0x11, 0x3c, 0x0f, 0x24, 0x88, 0x88, 
	0x38, 0x36, 0x24, 0x00, 0x05, 0x88, 0x26, 0x53, 0x53, 
	0x53, 0x36, 0x11, 0x74, 0x03, 0x03, 0x03, 0xb7, 0x0f, 
	0x24, 0x88, 0x88, 0x3c, 0x36, 0x0f, 0x88, 0x1c, 0x14, 
	0x26, 0x37, 0x3c, 0x10, 0x10, 0x24, 0x00, 0x05, 0x26, 
	0x36, 0x37, 0x3c, 0x3c, 0x36, 0x26, 0x26, 0x52, 0xa1, 
	0x53, 0xa1, 0xa1, 0xc5, 0x65, 0x25, 0x10, 0x0f, 0x26, 
	0x26, 0x26, 0xa1, 0x15, 0x15, 0x96, 0x02, 0x2d, 0x7b, 
	0x89, 0x00, 0x08, 0x76, 0x99, 0x6d, 0x8f, 0x8f, 0x96, 
	0x5d, 0x5d, 0x47, 0x00, 0x05, 0x76, 0x99, 0x6e, 0x70, 
	0x8f, 0x6f, 0x6a, 0x19, 0x03, 0x03, 0x03, 0x3f, 0x61, 
	0x61, 0x61, 0x89, 0x00, 0x05, 0x99, 0x62, 0x70, 0x7a, 
	0x5c, 0x1e, 0x1e, 0x5c, 0x96, 0x7a, 0x6e, 0x42, 0x1e, 
	0x42, 0x00, 0x14, 0x99, 0x6d, 0x70, 0x5c, 0x1e, 0x46, 
	0x99, 0x00, 0x13, 0x96, 0x27, 0x70, 0x0b, 0x00, 0x09, 
	0x03, 0x01, 0x01, 0x00, 0x09, 0x02, 0x1b, 0x0e, 0x58, 
	0x25, 0x25, 0x88, 0x52, 0x52, 0xc6, 0x50, 0x50, 0x0f, 
	0x25, 0xad, 0x26, 0x11, 0x37, 0x25, 0xad, 0xad, 0xad, 
	0x88, 0x52, 0x11, 0x11, 0x36, 0x0f, 0x24, 0x88, 0x88, 
	0x37, 0x36, 0x25, 0x00, 0x05, 0x88, 0x36, 0x53, 0x53, 
	0x53, 0x14, 0x26, 0x30, 0x03, 0x03, 0x03, 0xb7, 0x0f, 
	0x24, 0x88, 0x88, 0x1c, 0x58, 0x88, 0x36, 0x1c, 0x24, 
	0x24, 0x26, 0x26, 0x10, 0x10, 0x25, 0x00, 0x05, 0x26, 
	0x37, 0x69, 0xa1, 0x27, 0x27, 0x27, 0x00, 0x04, 0xa1, 
	0x52, 0xaf, 0x04, 0x1b, 0xbb, 0x10, 0x0f, 0x26, 0x26, 
	0x26, 0x9e, 0x15, 0x15, 0x96, 0x02, 0x04, 0x7b, 0x96, 
	0x96, 0x99, 0x00, 0x07, 0x76, 0x96, 0x8f, 0x8f, 0x6d, 
	0x1e, 0x5d, 0x46, 0x00, 0x05, 0x76, 0x99, 0x7a, 0x70, 
	0x62, 0x5a, 0x00, 0x05, 0x03, 0x3f, 0x61, 0x61, 0x61, 
	0x89, 0x00, 0x05, 0x99, 0xa5, 0x70, 0x70, 0x5c, 0x1e, 
	0x1e, 0x41, 0x77, 0x7a, 0x6e, 0x42, 0x1e, 0x5c, 0x00, 
	0x14, 0x99, 0x6f, 0x70, 0x5c, 0x1e, 0x89, 0x00, 0x14, 
	0x96, 0x27, 0x70, 0xa3, 0x00, 0x09, 0x03, 0x01, 0x01, 
	0x00, 0x09, 0x02, 0x18, 0x0d, 0x58, 0x25, 0x25, 0x88, 
	0x14, 0xc3, 0x4f, 0x50, 0x57, 0x25, 0xad, 0xad, 0x36, 
	0x11, 0x37, 0x25, 0xad, 0xad, 0xad, 0x26, 0x11, 0x11, 
	0x11, 0x36, 0x0f, 0x24, 0x88, 0x88, 0x37, 0x36, 0x25, 
	0x00, 0x05, 0x88, 0x36, 0x53, 0x53, 0x53, 0x1c, 0x24, 
	0x66, 0x03, 0x03, 0x03, 0xb7, 0x0f, 0x24, 0x88, 0x88, 
	0x26, 0x88, 0x26, 0x3c, 0x24, 0x58, 0x24, 0x88, 0x26, 
	0x58, 0x58, 0x88, 0x00, 0x05, 0x26, 0x14, 0x9e, 0x9e, 
	0x11, 0x37, 0x11, 0xa1, 0x27, 0x27, 0xa1, 0xc7, 0x02, 
	0x02, 0x1b, 0x10, 0x10, 0x0e, 0x26, 0x26, 0x26, 0x9e, 
	0x15, 0x15, 0x96, 0x02, 0x02, 0xc8, 0x96, 0x6f, 0x9d, 
	0xac, 0x00, 0x07, 0x76, 0x6f, 0xa5, 0x9a, 0x42, 0x1e, 
	0x89, 0x00, 0x05, 0x76, 0xac, 0x70, 0x70, 0x92, 0x00, 
	0x06, 0x03, 0x8c, 0x61, 0x61, 0x61, 0x89, 0x00, 0x05, 
	0x99, 0x9a, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x47, 0x77, 
	0x7a, 0x5e, 0x1e, 0x1e, 0x5c, 0x00, 0x10, 0x99, 0xbc, 
	0x99, 0x99, 0x99, 0x6f, 0x70, 0x5c, 0x1e, 0x76, 0x00, 
	0x14, 0x96, 0x27, 0x70, 0xa3, 0x00, 0x09, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x87, 0x58, 0x25, 0x25, 0x88, 
	0x37, 0xb8, 0x51, 0x0f, 0x25, 0xad, 0xad, 0x88, 0x37, 
	0x11, 0x52, 0x25, 0xad, 0xad, 0xad, 0x36, 0x11, 0x11, 
	0x11, 0x26, 0x0f, 0x24, 0x88, 0x88, 0x3c, 0x3c, 0x00, 
	0x06, 0x88, 0x36, 0x53, 0x53, 0x53, 0x3c, 0x24, 0x1a, 
	0x03, 0x03, 0x03, 0xc9, 0x0f, 0x24, 0x88, 0x88, 0x26, 
	0x88, 0x26, 0x25, 0x0e, 0x58, 0x88, 0x26, 0x36, 0x88, 
	0x58, 0x25, 0x00, 0x05, 0x26, 0x11, 0x9e, 0x69, 0x26, 
	0x0f, 0x98, 0x26, 0x1c, 0x52, 0x9e, 0x6a, 0x18, 0x02, 
	0x0c, 0x10, 0x10, 0x98, 0x26, 0x26, 0x26, 0x9e, 0x15, 
	0x15, 0x96, 0x02, 0x02, 0x2a, 0x2f, 0x9d, 0x9d, 0x9d, 
	0x77, 0x00, 0x06, 0x76, 0x99, 0x9a, 0xb1, 0x89, 0x5c, 
	0x7b, 0x00, 0x05, 0x76, 0x8a, 0x70, 0x70, 0x4b, 0x00, 
	0x06, 0x03, 0x8c, 0x61, 0x61, 0x61, 0x46, 0x00, 0x05, 
	0x99, 0x8f, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x8e, 0x77, 
	0x70, 0x5e, 0x1e, 0x1e, 0x41, 0x00, 0x10, 0x99, 0x76, 
	0x99, 0x99, 0x99, 0x8a, 0x70, 0x5c, 0x1e, 0x76, 0x00, 
	0x0f, 0x96, 0x99, 0x99, 0x96, 0x96, 0x96, 0x5e, 0x70, 
	0xa3, 0x00, 0x09, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x87, 0x58, 0x25, 0x25, 0x88, 0xad, 0x0f, 0x25, 0x00, 
	0x04, 0xad, 0x26, 0x11, 0x11, 0x52, 0x24, 0x25, 0xad, 
	0x88, 0x36, 0x11, 0x11, 0x11, 0x36, 0x0e, 0x24, 0x88, 
	0x88, 0x3c, 0x37, 0x25, 0x00, 0x05, 0x88, 0x36, 0x53, 
	0x53, 0x53, 0x3c, 0x24, 0x1a, 0x03, 0x03, 0x03, 0xc9, 
	0x0f, 0x24, 0x00, 0x04, 0x88, 0x26, 0x88, 0x88, 0x88, 
	0x26, 0x36, 0x3c, 0x3c, 0x58, 0x25, 0x00, 0x04, 0x26, 
	0x3c, 0x69, 0x11, 0x24, 0x57, 0x57, 0x0e, 0x24, 0x24, 
	0x88, 0x38, 0xa1, 0xca, 0x02, 0x17, 0x10, 0x10, 0x58, 
	0x26, 0x26, 0x26, 0x9e, 0x15, 0x15, 0x96, 0x02, 0x02, 
	0x94, 0x76, 0x96, 0x6f, 0x9d, 0x9d, 0x54, 0x00, 0x06, 
	0x76, 0x6d, 0xb5, 0x77, 0x5c, 0x89, 0x00, 0x05, 0x76, 
	0x6f, 0x70, 0x70, 0x67, 0x00, 0x06, 0x03, 0x3f, 0x61, 
	0x61, 0x61, 0x46, 0x00, 0x05, 0x99, 0x8f, 0x70, 0x70, 
	0x5c, 0x1e, 0x1e, 0x46, 0x77, 0x70, 0xb1, 0x1e, 0x1e, 
	0x41, 0x00, 0x10, 0x99, 0x46, 0x99, 0x99, 0x99, 0x54, 
	0x70, 0x5c, 0x1e, 0x99, 0x00, 0x0f, 0x96, 0x46, 0x99, 
	0x96, 0x96, 0x96, 0x5e, 0x70, 0x5a, 0x00, 0x09, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x9f, 0x58, 0x00, 0x04, 
	0x25, 0x00, 0x05, 0xad, 0x26, 0x52, 0x11, 0x11, 0x38, 
	0x24, 0x25, 0x88, 0x88, 0x36, 0x11, 0x11, 0x11, 0x36, 
	0x0e, 0x24, 0x88, 0x88, 0x3c, 0x14, 0x25, 0x00, 0x05, 
	0x88, 0x3c, 0x53, 0x53, 0x53, 0x36, 0x24, 0x03, 0x03, 
	0x28, 0x1a, 0xc9, 0x0f, 0x58, 0x88, 0x88, 0x88, 0x00, 
	0x06, 0x26, 0x36, 0x37, 0x38, 0x25, 0x24, 0x00, 0x04, 
	0x26, 0x52, 0x9e, 0x37, 0x10, 0x57, 0x57, 0x58, 0x24, 
	0x24, 0x26, 0x3c, 0x52, 0x11, 0x2c, 0x17, 0x10, 0x10, 
	0x58, 0x26, 0x26, 0x26, 0x9e, 0x15, 0x15, 0x96, 0x02, 
	0x02, 0x1d, 0x42, 0x42, 0x5c, 0x89, 0x54, 0x9d, 0x6f, 
	0x99, 0x00, 0x04, 0x76, 0x77, 0x5e, 0x8f, 0x5c, 0x46, 
	0x00, 0x05, 0x76, 0x8f, 0x70, 0x70, 0x4e, 0x03, 0x19, 
	0x22, 0x21, 0x21, 0x07, 0x8c, 0x61, 0x61, 0x61, 0x46, 
	0x00, 0x05, 0x99, 0x8f, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 
	0x46, 0x54, 0x70, 0x62, 0x1e, 0x1e, 0x47, 0x00, 0x0f, 
	0x99, 0x89, 0x8e, 0x99, 0x99, 0x99, 0x77, 0x70, 0x5c, 
	0x1e, 0x99, 0x96, 0x96, 0xac, 0x00, 0x0c, 0x96, 0x5c, 
	0x00, 0x04, 0x96, 0x5e, 0x70, 0xcb, 0x00, 0x09, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x9f, 0x58, 0x25, 0x25, 
	0x00, 0x06, 0xad, 0x26, 0x14, 0x11, 0x11, 0x11, 0x3c, 
	0x58, 0x24, 0x88, 0x88, 0x36, 0x11, 0x11, 0x11, 0x36, 
	0x0e, 0x24, 0x88, 0x88, 0x1c, 0x52, 0x25, 0x00, 0x05, 
	0x88, 0x3c, 0x53, 0x53, 0x53, 0x36, 0x24, 0x04, 0x84, 
	0xad, 0xad, 0x58, 0x0f, 0x58, 0x88, 0x26, 0x26, 0x3c, 
	0x00, 0x06, 0x26, 0x37, 0x11, 0x36, 0x24, 0x00, 0x04, 
	0x26, 0x11, 0xa1, 0x37, 0x0f, 0x10, 0x0f, 0x24, 0x24, 
	0x25, 0x36, 0x37, 0x14, 0x52, 0x7b, 0x66, 0x0f, 0x0f, 
	0x24, 0x26, 0x26, 0x26, 0x9e, 0x15, 0x15, 0x54, 0x03, 
	0x03, 0x1d, 0x42, 0x42, 0x61, 0x61, 0x42, 0x89, 0x54, 
	0x54, 0x99, 0x76, 0x76, 0x76, 0x99, 0x6e, 0x62, 0x5c, 
	0x46, 0x00, 0x05, 0x76, 0x8f, 0x70, 0x70, 0x90, 0x29, 
	0x00, 0x06, 0x76, 0x61, 0x61, 0x61, 0x46, 0x00, 0x05, 
	0x99, 0x6d, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x89, 0x6f, 
	0x70, 0x9a, 0x1e, 0x1e, 0x47, 0x99, 0x99, 0x77, 0x77, 
	0x00, 0x0b, 0x99, 0x47, 0x46, 0x99, 0x99, 0x99, 0x77, 
	0x7a, 0x5c, 0x42, 0x99, 0x96, 0x96, 0x6f, 0xbc, 0x00, 
	0x0a, 0x96, 0x89, 0x5c, 0x00, 0x04, 0x96, 0xb1, 0x70, 
	0xa9, 0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x72, 0x58, 0x25, 0x00, 0x05, 0xad, 0x88, 0x3c, 0x00, 
	0x04, 0x11, 0x38, 0x3b, 0x58, 0x24, 0x88, 0x88, 0x36, 
	0x11, 0x11, 0x11, 0x36, 0x0e, 0x24, 0x88, 0x88, 0x37, 
	0x52, 0x24, 0x00, 0x05, 0x88, 0x3c, 0x53, 0x53, 0x53, 
	0x36, 0x25, 0x95, 0x00, 0x05, 0x0f, 0x58, 0x26, 0x26, 
	0x26, 0x11, 0x9e, 0x11, 0x3c, 0x26, 0x26, 0x26, 0x3c, 
	0x9e, 0x37, 0x58, 0x00, 0x04, 0x26, 0x52, 0x9e, 0x38, 
	0x0f, 0x24, 0x26, 0x26, 0x88, 0x26, 0x00, 0x04, 0x52, 
	0xcc, 0x66, 0x0f, 0x0f, 0x24, 0x26, 0x26, 0x26, 0x9e, 
	0x15, 0x15, 0x54, 0x03, 0x03, 0x1d, 0x42, 0x42, 0x61, 
	0x61, 0x42, 0x5c, 0x46, 0x77, 0x96, 0x76, 0x76, 0x76, 
	0x99, 0x6e, 0x62, 0x5c, 0x46, 0x00, 0x05, 0x76, 0xa5, 
	0x70, 0x70, 0x94, 0x5c, 0x41, 0x41, 0x41, 0x5c, 0x5c, 
	0x5c, 0x41, 0x61, 0x61, 0x46, 0x00, 0x05, 0x99, 0x6f, 
	0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x89, 0x6f, 0x70, 0x8f, 
	0x1e, 0x1e, 0x46, 0x99, 0x99, 0x8a, 0x6d, 0x00, 0x0a, 
	0x99, 0x76, 0x5c, 0x46, 0x99, 0x99, 0x99, 0x77, 0x7a, 
	0x5c, 0x42, 0xbc, 0x96, 0x96, 0x9a, 0x99, 0x00, 0x0a, 
	0x96, 0x41, 0x5c, 0x00, 0x04, 0x96, 0xb1, 0x70, 0xab, 
	0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x31, 
	0x58, 0x25, 0x00, 0x04, 0xad, 0x36, 0x11, 0x69, 0x69, 
	0x53, 0x11, 0x38, 0x08, 0x33, 0x58, 0x24, 0x88, 0x88, 
	0x26, 0x11, 0x11, 0x11, 0x36, 0x0e, 0x24, 0x88, 0x88, 
	0x14, 0x11, 0x24, 0x00, 0x05, 0x88, 0x1c, 0x53, 0x53, 
	0x53, 0x36, 0x25, 0x00, 0x04, 0x57, 0x10, 0x58, 0x58, 
	0x26, 0x26, 0x26, 0x11, 0x69, 0x9e, 0x11, 0x3c, 0x26, 
	0x26, 0x36, 0x9e, 0x52, 0x58, 0x88, 0x26, 0x26, 0x26, 
	0x37, 0x9e, 0x52, 0x0f, 0x24, 0x00, 0x04, 0x26, 0x37, 
	0x52, 0x69, 0x9e, 0xa2, 0xaa, 0x0f, 0x0f, 0x24, 0x26, 
	0x26, 0x26, 0x9e, 0x15, 0x15, 0x54, 0x03, 0x03, 0x1d, 
	0x42, 0x42, 0x41, 0x47, 0x47, 0x46, 0x99, 0x8f, 0x77, 
	0x76, 0x76, 0x76, 0xbc, 0x7a, 0x62, 0x5c, 0x8e, 0x00, 
	0x05, 0x76, 0xb1, 0x70, 0x70, 0x9b, 0x1e, 0x6c, 0x61, 
	0x42, 0x42, 0x42, 0x54, 0x76, 0x61, 0x61, 0x46, 0x00, 
	0x05, 0x99, 0x6f, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x76, 
	0x6d, 0x70, 0x6d, 0x1e, 0x1e, 0x46, 0x99, 0x99, 0x6f, 
	0xa5, 0x00, 0x0a, 0x99, 0x76, 0x61, 0x89, 0x99, 0x99, 
	0x96, 0x96, 0x7a, 0x5c, 0x5c, 0x96, 0x96, 0x96, 0x5e, 
	0x99, 0x99, 0x00, 0x08, 0x96, 0x76, 0x42, 0x41, 0x00, 
	0x04, 0x96, 0x62, 0x70, 0xae, 0x00, 0x09, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x31, 0x58, 0x24, 0xad, 0xad, 
	0xad, 0x88, 0x38, 0x52, 0x52, 0x52, 0x11, 0x3c, 0x25, 
	0xaa, 0xaa, 0x58, 0x24, 0x88, 0x88, 0x26, 0x11, 0x11, 
	0x11, 0x36, 0x0e, 0x24, 0x88, 0x88, 0x52, 0x11, 0x24, 
	0x00, 0x05, 0x88, 0x3c, 0x53, 0x53, 0x53, 0x1c, 0x0f, 
	0xcd, 0x57, 0x57, 0x10, 0x37, 0x88, 0x58, 0x26, 0x26, 
	0x26, 0x11, 0x53, 0x69, 0x3c, 0x88, 0x88, 0x26, 0x36, 
	0x9e, 0x53, 0x24, 0x88, 0x26, 0x26, 0x26, 0x3c, 0x9e, 
	0x11, 0x0f, 0x25, 0x00, 0x04, 0x26, 0x3c, 0xa1, 0x27, 
	0x27, 0xce, 0x33, 0x0f, 0x0f, 0x25, 0x26, 0x26, 0x26, 
	0x9e, 0x15, 0x15, 0x54, 0x03, 0x03, 0x64, 0x42, 0x42, 
	0x46, 0x76, 0x76, 0x76, 0xac, 0x5e, 0x77, 0x5c, 0x76, 
	0x76, 0x96, 0x7a, 0x62, 0x5c, 0x47, 0x00, 0x05, 0x76, 
	0xb1, 0x7a, 0x7a, 0x46, 0x6c, 0x6c, 0x1e, 0x42, 0x42, 
	0x77, 0x7a, 0x46, 0x61, 0x61, 0x46, 0x00, 0x05, 0x99, 
	0x8a, 0x70, 0x70, 0x5c, 0x1e, 0x1e, 0x76, 0x6d, 0x70, 
	0x6f, 0x1e, 0x1e, 0x46, 0x99, 0x99, 0x6d, 0x5e, 0x00, 
	0x09, 0x99, 0x96, 0x89, 0x1e, 0x89, 0x99, 0x99, 0x96, 
	0x96, 0x6e, 0x5c, 0x41, 0x96, 0x96, 0xac, 0x7a, 0x96, 
	0x99, 0x00, 0x08, 0x96, 0x46, 0x1e, 0x47, 0x00, 0x04, 
	0x96, 0xa5, 0x70, 0xae, 0x00, 0x09, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0xaa, 0x58, 0x24, 0xad, 0xad, 0xad, 
	0x88, 0x3c, 0x38, 0x38, 0x52, 0x37, 0x58, 0x98, 0x66, 
	0x30, 0x58, 0x24, 0x88, 0x88, 0x26, 0x11, 0x11, 0x11, 
	0x36, 0x0e, 0x24, 0x88, 0x26, 0x11, 0x11, 0x24, 0x00, 
	0x05, 0x88, 0x36, 0x53, 0x53, 0x53, 0x37, 0x57, 0x51, 
	0x57, 0x0f, 0x52, 0x9e, 0x88, 0x58, 0x26, 0x26, 0x26, 
	0x11, 0x53, 0x69, 0x24, 0x58, 0x25, 0x26, 0x26, 0x9e, 
	0x9e, 0x36, 0x00, 0x04, 0x26, 0x36, 0x9e, 0x11, 0x0f, 
	0x25, 0x00, 0x04, 0x26, 0x3c, 0x27, 0x27, 0xa1, 0x08, 
	0x33, 0x0f, 0x0f, 0x25, 0x26, 0x26, 0x26, 0x9e, 0x15, 
	0x15, 0x54, 0x03, 0x03, 0x30, 0x42, 0x42, 0x8e, 0x76, 
	0x76, 0x76, 0x99, 0x7a, 0x77, 0x61, 0x76, 0x76, 0x8a, 
	0x27, 0x9a, 0x5c, 0x41, 0x00, 0x05, 0x76, 0xa5, 0x7a, 
	0x7a, 0x76, 0x6c, 0x6c, 0x6c, 0x5c, 0x96, 0x7a, 0x7a, 
	0x41, 0x42, 0x61, 0x46, 0x00, 0x05, 0x99, 0x77, 0x70, 
	0x70, 0x5c, 0x1e, 0x1e, 0x99, 0x8f, 0x70, 0x54, 0x1e, 
	0x1e, 0x46, 0x99, 0x99, 0x8f, 0x70, 0x96, 0x00, 0x08, 
	0x99, 0x6f, 0x41, 0x1e, 0x76, 0x00, 0x04, 0x96, 0x6e, 
	0x5c, 0x41, 0x96, 0x96, 0x54, 0x70, 0x77, 0x99, 0x99, 
	0x00, 0x07, 0x96, 0x41, 0x1e, 0x46, 0x00, 0x04, 0x96, 
	0xa5, 0x70, 0x67, 0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x66, 0x58, 0x24, 0x00, 0x04, 0xad, 0x36, 
	0x52, 0x52, 0x52, 0x37, 0x98, 0x98, 0x19, 0x66, 0x24, 
	0x24, 0x88, 0x88, 0x26, 0x11, 0x11, 0x11, 0x3c, 0x0e, 
	0x24, 0x88, 0x26, 0x11, 0x11, 0x26, 0x00, 0x05, 0x88, 
	0x26, 0x53, 0x53, 0x11, 0x1c, 0x51, 0xcd, 0x58, 0x3c, 
	0x9e, 0x9e, 0x24, 0x58, 0x26, 0x26, 0x26, 0x11, 0x53, 
	0x69, 0x25, 0x58, 0x24, 0x26, 0x26, 0x11, 0x9e, 0x1c, 
	0x88, 0x00, 0x04, 0x26, 0x9e, 0x11, 0x10, 0x25, 0x00, 
	0x04, 0x26, 0x3c, 0xa1, 0xa1, 0x53, 0x30, 0x72, 0x0f, 
	0x0f, 0x25, 0x26, 0x26, 0x26, 0x69, 0x15, 0x15, 0x54, 
	0x03, 0x03, 0x30, 0x42, 0x42, 0x8e, 0x76, 0x76, 0x76, 
	0x99, 0x70, 0x96, 0x42, 0x76, 0x76, 0x8f, 0x27, 0x8f, 
	0x41, 0x40, 0x00, 0x05, 0x76, 0x8f, 0x7a, 0x6e, 0x76, 
	0x6c, 0x6c, 0x5d, 0x76, 0xb5, 0x7a, 0x27, 0x5c, 0x42, 
	0x42, 0x46, 0x00, 0x05, 0x99, 0x77, 0x7a, 0x7a, 0x41, 
	0x1e, 0x42, 0x99, 0x8f, 0x70, 0x77, 0x1e, 0x1e, 0x89, 
	0x99, 0x99, 0x9a, 0x70, 0x8a, 0x00, 0x07, 0x99, 0xbc, 
	0x6f, 0x5c, 0x1e, 0x99, 0x00, 0x04, 0x96, 0x5e, 0x5c, 
	0x47, 0x96, 0x96, 0x8a, 0x70, 0x6f, 0x99, 0x99, 0x00, 
	0x06, 0x96, 0x77, 0x5c, 0x1e, 0x46, 0x00, 0x04, 0x96, 
	0xa5, 0x70, 0x59, 0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x1a, 0x58, 0x24, 0x00, 0x04, 0xad, 0xb9, 
	0x52, 0x52, 0x52, 0x3c, 0x98, 0x0e, 0x28, 0x28, 0x35, 
	0x25, 0x88, 0x88, 0x26, 0x52, 0x11, 0x11, 0x3c, 0x0e, 
	0x24, 0x88, 0x36, 0x53, 0x53, 0x36, 0x00, 0x06, 0x88, 
	0x52, 0x11, 0x11, 0x36, 0x51, 0x57, 0x88, 0x37, 0x9e, 
	0x9e, 0x24, 0x58, 0x26, 0x26, 0x26, 0x11, 0x69, 0x9e, 
	0x88, 0x58, 0x24, 0x26, 0x26, 0x52, 0x9e, 0x52, 0x88, 
	0x00, 0x04, 0x26, 0x11, 0x11, 0x10, 0x88, 0x00, 0x04, 
	0x26, 0x14, 0x9e, 0x9e, 0x9d, 0x03, 0xb3, 0x0f, 0x0f, 
	0x88, 0x26, 0x26, 0x26, 0x53, 0x15, 0x15, 0x54, 0x03, 
	0x03, 0x30, 0x42, 0x42, 0x8e, 0x76, 0x76, 0x76, 0x99, 
	0x70, 0x99, 0x5c, 0x76, 0x76, 0xb1, 0x27, 0x8f, 0x8e, 
	0x8e, 0x00, 0x05, 0x76, 0x6f, 0x5e, 0x5e, 0x89, 0x6c, 
	0x6c, 0x41, 0x99, 0x6e, 0x7a, 0x62, 0x5c, 0x42, 0x42, 
	0x46, 0x00, 0x05, 0x99, 0xbc, 0x27, 0x6e, 0x41, 0x5d, 
	0x42, 0x99, 0x9a, 0x7a, 0x77, 0x1e, 0x1e, 0x76, 0x99, 
	0x99, 0xa5, 0x70, 0x8f, 0x00, 0x07, 0x99, 0x77, 0x54, 
	0x61, 0x61, 0x99, 0x00, 0x04, 0x96, 0x5e, 0x5c, 0x46, 
	0x96, 0x96, 0x6f, 0x70, 0x8f, 0x99, 0x99, 0x99, 0x00, 
	0x05, 0x96, 0x77, 0x42, 0x1e, 0x89, 0x00, 0x04, 0x96, 
	0x9a, 0x70, 0x59, 0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x1a, 0x97, 0x24, 0xad, 0xad, 0x88, 0x88, 
	0x3c, 0x52, 0x52, 0x52, 0x3c, 0x58, 0x97, 0x28, 0x03, 
	0x09, 0x25, 0x88, 0x88, 0x88, 0x38, 0x52, 0x11, 0x37, 
	0x0e, 0x24, 0x88, 0x3c, 0x53, 0x53, 0x37, 0x36, 0x26, 
	0x00, 0x04, 0x88, 0x37, 0x52, 0x52, 0x36, 0x51, 0x0f, 
	0x26, 0x52, 0x9e, 0x9e, 0x24, 0x58, 0x26, 0x26, 0x26, 
	0x11, 0x69, 0x9e, 0x26, 0x58, 0x24, 0x26, 0x26, 0x38, 
	0x9e, 0x9e, 0x00, 0x05, 0x26, 0x52, 0x52, 0x10, 0x00, 
	0x05, 0x26, 0x11, 0x9e, 0x9e, 0x74, 0x03, 0xb3, 0x0f, 
	0x0f, 0x88, 0x26, 0x26, 0x26, 0x53, 0x15, 0x15, 0x1c, 
	0x03, 0x03, 0x30, 0x42, 0x42, 0x47, 0x76, 0x76, 0x76, 
	0x99, 0x70, 0x99, 0x5c, 0x76, 0xbc, 0x5e, 0x27, 0x9a, 
	0x7b, 0x00, 0x06, 0x76, 0x96, 0x5e, 0xb1, 0x46, 0x6c, 
	0x6c, 0x76, 0x77, 0x7a, 0x7a, 0x59, 0x46, 0x47, 0x47, 
	0x46, 0x00, 0x06, 0x99, 0xa5, 0x62, 0x5c, 0x6c, 0x5c, 
	0x99, 0x9a, 0x70, 0x96, 0x1e, 0x1e, 0x76, 0x99, 0x99, 
	0xb1, 0x70, 0x62, 0x00, 0x07, 0x99, 0x8f, 0x76, 0x1e, 
	0x42, 0x99, 0x00, 0x04, 0x96, 0x5e, 0x5c, 0x46, 0x96, 
	0x96, 0x8f, 0x70, 0x62, 0x00, 0x04, 0x99, 0x96, 0x96, 
	0x96, 0x6f, 0x76, 0x1e, 0x1e, 0x76, 0x00, 0x04, 0x96, 
	0x8f, 0x70, 0x59, 0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x28, 0x97, 0x24, 0xad, 0x88, 0x88, 0x88, 
	0x3c, 0x52, 0x52, 0x52, 0x36, 0x24, 0x97, 0x28, 0x03, 
	0x3a, 0x25, 0x88, 0x88, 0x88, 0x3c, 0x52, 0x52, 0x36, 
	0x10, 0x58, 0x88, 0x3c, 0x53, 0x53, 0x52, 0x36, 0x26, 
	0x00, 0x04, 0x88, 0x26, 0x37, 0x37, 0x26, 0x51, 0x25, 
	0x26, 0x11, 0x9e, 0x69, 0x58, 0x58, 0x26, 0x26, 0x26, 
	0x11, 0x69, 0x9e, 0x88, 0x0f, 0x0e, 0x26, 0x26, 0x37, 
	0x9e, 0x9e, 0x3c, 0x00, 0x04, 0x26, 0x37, 0x37, 0x98, 
	0x00, 0x04, 0x26, 0x1c, 0x69, 0x69, 0x9a, 0x6b, 0x03, 
	0x95, 0x0f, 0x0f, 0x88, 0x26, 0x26, 0x26, 0x53, 0x15, 
	0x15, 0x1c, 0x03, 0x03, 0x30, 0x42, 0x42, 0x47, 0x00, 
	0x04, 0x76, 0x6e, 0x89, 0x5c, 0x76, 0x8a, 0x27, 0x27, 
	0x4b, 0x7b, 0x00, 0x06, 0x76, 0x99, 0x8f, 0xa5, 0x46, 
	0x79, 0x42, 0x99, 0x6d, 0x7a, 0x7a, 0x90, 0x8c, 0x47, 
	0x47, 0x46, 0x00, 0x06, 0x99, 0x54, 0x6d, 0x5c, 0x4a, 
	0x46, 0x99, 0xa5, 0x70, 0x99, 0x1e, 0x61, 0x76, 0x99, 
	0x99, 0xb5, 0x70, 0xb1, 0x96, 0x00, 0x05, 0x99, 0x96, 
	0x62, 0x47, 0x1e, 0x42, 0x99, 0x00, 0x04, 0x96, 0xb1, 
	0x5c, 0x46, 0x96, 0x96, 0x8f, 0x70, 0x5e, 0x96, 0x99, 
	0x99, 0x99, 0x96, 0x96, 0x96, 0x9a, 0x41, 0x1e, 0x1e, 
	0x99, 0x00, 0x04, 0x96, 0x8f, 0x70, 0x4b, 0x00, 0x09, 
	0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0x97, 0x24, 0x00, 
	0x04, 0x88, 0x3c, 0x52, 0x52, 0x52, 0x36, 0x58, 0xc9, 
	0x03, 0x03, 0xbe, 0x26, 0x26, 0x88, 0x88, 0x36, 0x38, 
	0x1c, 0x0f, 0x51, 0x58, 0x88, 0x38, 0x53, 0x53, 0x11, 
	0x36, 0x3c, 0x36, 0x26, 0x88, 0x88, 0x26, 0x3c, 0x37, 
	0x26, 0x10, 0x26, 0x26, 0x53, 0x69, 0x11, 0x58, 0x58, 
	0x26, 0x26, 0x26, 0x11, 0x9e, 0x9e, 0x25, 0x10, 0x0f, 
	0x26, 0x26, 0x3c, 0x9e, 0x9e, 0x52, 0x36, 0x36, 0x00, 
	0x04, 0x26, 0x24, 0x26, 0x26, 0x26, 0x36, 0xc2, 0x69, 
	0x69, 0xcb, 0x03, 0x03, 0x95, 0x0f, 0x0f, 0x00, 0x04, 
	0x26, 0x53, 0x15, 0x15, 0x1c, 0x03, 0x03, 0x22, 0x42, 
	0x42, 0x47, 0x00, 0x04, 0x76, 0x5e, 0x41, 0x47, 0x76, 
	0x8f, 0x27, 0x27, 0xa9, 0xcf, 0x99, 0x96, 0x96, 0x99, 
	0x76, 0x99, 0x99, 0x77, 0xa5, 0x46, 0x6c, 0x89, 0x99, 
	0x62, 0x27, 0x5e, 0x43, 0x2d, 0x47, 0x47, 0x8e, 0x00, 
	0x07, 0x99, 0x96, 0x8e, 0x41, 0x99, 0x99, 0x5e, 0x70, 
	0x46, 0x1e, 0x61, 0x76, 0x99, 0xbc, 0x5e, 0x70, 0x4b, 
	0x2f, 0x00, 0x05, 0x99, 0x6f, 0x9a, 0x5c, 0x1e, 0x5c, 
	0x00, 0x05, 0x96, 0x62, 0x5c, 0x89, 0x96, 0x96, 0xa5, 
	0x70, 0x65, 0x6f, 0x00, 0x04, 0x99, 0x96, 0x77, 0x8f, 
	0x42, 0x1e, 0x1e, 0x00, 0x05, 0x96, 0x8f, 0x70, 0x4b, 
	0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0x3b, 
	0x24, 0x00, 0x04, 0x88, 0x1c, 0x52, 0x52, 0x52, 0x36, 
	0x0f, 0x66, 0x03, 0x03, 0x03, 0xd0, 0x26, 0x88, 0x88, 
	0x88, 0x36, 0x25, 0x51, 0x10, 0x88, 0x26, 0x11, 0x53, 
	0x53, 0x14, 0x25, 0x1c, 0x1c, 0x26, 0x88, 0x88, 0x88, 
	0x26, 0x37, 0x26, 0x58, 0x26, 0x3c, 0x69, 0x69, 0x52, 
	0x98, 0x58, 0x88, 0x26, 0x26, 0x53, 0x9e, 0x9e, 0x0f, 
	0x57, 0x0f, 0x26, 0x26, 0x36, 0x9e, 0x9e, 0x9e, 0x3c, 
	0x36, 0x36, 0x00, 0x07, 0x26, 0x37, 0x69, 0x69, 0x9c, 
	0x03, 0x03, 0x03, 0x95, 0x0f, 0x0f, 0x00, 0x04, 0x26, 
	0x53, 0x15, 0x15, 0x1c, 0x03, 0x03, 0x1a, 0x5c, 0x42, 
	0x47, 0x00, 0x04, 0x76, 0xa5, 0x5d, 0x89, 0x99, 0xb1, 
	0x5e, 0x5e, 0x2a, 0x04, 0x3d, 0x77, 0x77, 0x96, 0x00, 
	0x04, 0x99, 0x8f, 0x99, 0x61, 0x99, 0xac, 0x5e, 0x5e, 
	0x59, 0x02, 0x04, 0x40, 0x46, 0x46, 0x76, 0x00, 0x0a, 
	0x99, 0x77, 0x6e, 0x5e, 0x42, 0x1e, 0x61, 0x99, 0x99, 
	0x96, 0x27, 0x70, 0x6a, 0x6b, 0x96, 0x00, 0x04, 0x99, 
	0xa5, 0x8a, 0x42, 0x1e, 0x41, 0x00, 0x05, 0x96, 0xa5, 
	0x5c, 0x76, 0x96, 0x96, 0xb1, 0x70, 0xb2, 0x67, 0x54, 
	0x99, 0x99, 0x99, 0x96, 0x8f, 0x54, 0x61, 0x1e, 0x61, 
	0x00, 0x05, 0x96, 0x8f, 0x70, 0x4b, 0x00, 0x09, 0x02, 
	0x01, 0x01, 0x00, 0x0b, 0x03, 0x3b, 0x24, 0x88, 0x88, 
	0x88, 0x26, 0x11, 0x11, 0x11, 0x52, 0x58, 0x33, 0x00, 
	0x04, 0x03, 0x3a, 0x26, 0x26, 0x88, 0x88, 0x88, 0x25, 
	0x24, 0x88, 0x88, 0x3c, 0x11, 0x53, 0x53, 0x36, 0x33, 
	0xa3, 0x1c, 0x3c, 0x00, 0x04, 0x26, 0x36, 0x98, 0x88, 
	0x26, 0x52, 0x53, 0x53, 0x37, 0x98, 0x98, 0x88, 0x26, 
	0x26, 0x53, 0x9e, 0x69, 0x10, 0x57, 0x58, 0x26, 0x26, 
	0x26, 0x9e, 0x9e, 0x9e, 0x14, 0x36, 0x36, 0x00, 0x06, 
	0x26, 0x36, 0x69, 0x69, 0x53, 0x0b, 0x03, 0x03, 0x03, 
	0xb7, 0x0f, 0x0f, 0x00, 0x04, 0x26, 0x53, 0x15, 0x15, 
	0x1c, 0x03, 0x03, 0x19, 0x41, 0x41, 0x40, 0x00, 0x05, 
	0x76, 0x46, 0x76, 0x77, 0x5e, 0x5e, 0x4b, 0x18, 0x02, 
	0x2b, 0x96, 0x77, 0x77, 0xbc, 0x99, 0x99, 0x99, 0x96, 
	0x46, 0x46, 0x99, 0x8f, 0x5e, 0x5e, 0xa4, 0x02, 0x02, 
	0xcf, 0x89, 0x89, 0x76, 0x00, 0x0a, 0x99, 0xa5, 0x5e, 
	0x8f, 0x1e, 0x1e, 0x42, 0x99, 0x99, 0x96, 0x7a, 0x70, 
	0x67, 0x03, 0x0b, 0x96, 0x99, 0x99, 0xac, 0x5e, 0x76, 
	0x1e, 0x1e, 0x41, 0x00, 0x05, 0x96, 0x9a, 0x41, 0x76, 
	0x96, 0x96, 0x5e, 0x70, 0xae, 0x2a, 0x9c, 0xbc, 0x99, 
	0x99, 0x99, 0x5e, 0x89, 0x1e, 0x1e, 0x5c, 0x00, 0x05, 
	0x96, 0x8f, 0x70, 0x9c, 0x00, 0x09, 0x02, 0x01, 0x01, 
	0x00, 0x0b, 0x03, 0xd1, 0x24, 0x88, 0x88, 0x36, 0x52, 
	0x11, 0x11, 0x11, 0x36, 0xaa, 0x00, 0x05, 0x03, 0x28, 
	0xcc, 0x3c, 0x26, 0x00, 0x05, 0x88, 0x26, 0x52, 0x11, 
	0x11, 0x52, 0xc9, 0x1b, 0x18, 0xcb, 0x1c, 0x3c, 0x00, 
	0x06, 0x26, 0x3c, 0x53, 0x53, 0x53, 0xd2, 0x0e, 0x58, 
	0x88, 0x26, 0x26, 0x69, 0x9e, 0x11, 0x57, 0x57, 0x25, 
	0x26, 0x26, 0x3c, 0x9e, 0x9e, 0x9e, 0x52, 0x36, 0x36, 
	0x36, 0x00, 0x05, 0x26, 0x52, 0x69, 0x69, 0x54, 0x00, 
	0x04, 0x03, 0xb7, 0x0f, 0x0f, 0x00, 0x04, 0x26, 0x53, 
	0x15, 0x15, 0x9d, 0x03, 0x03, 0x03, 0x8c, 0x46, 0x46, 
	0x00, 0x06, 0x76, 0x99, 0xa5, 0x5e, 0x5e, 0xaf, 0x02, 
	0x02, 0x02, 0xc8, 0x77, 0x77, 0x77, 0x00, 0x06, 0x99, 
	0x54, 0x5e, 0x5e, 0x59, 0x02, 0x02, 0x02, 0x23, 0x76, 
	0x99, 0x99, 0xbc, 0x00, 0x07, 0x99, 0x96, 0x8f, 0xc5, 
	0x5e, 0x46, 0x1e, 0x1e, 0x5c, 0xbc, 0x99, 0xac, 0x7a, 
	0x70, 0xb2, 0x03, 0x03, 0x4e, 0x99, 0x99, 0x77, 0xb5, 
	0x47, 0x1e, 0x1e, 0x47, 0x00, 0x05, 0x96, 0x9a, 0x41, 
	0x99, 0x96, 0x96, 0x5e, 0x70, 0xa9, 0x02, 0xa6, 0x6f, 
	0x99, 0x99, 0x99, 0xb5, 0x5c, 0x1e, 0x1e, 0x5c, 0x00, 
	0x05, 0x96, 0x6d, 0x70, 0x9c, 0x00, 0x09, 0x02, 0x01, 
	0x01, 0x00, 0x0b, 0x03, 0x3a, 0x25, 0x88, 0x3c, 0x00, 
	0x04, 0x11, 0x81, 0x1a, 0x00, 0x07, 0x03, 0x86, 0x1c, 
	0x37, 0x36, 0x88, 0x88, 0x88, 0x26, 0x14, 0x11, 0x11, 
	0x11, 0x7b, 0x0c, 0x02, 0x02, 0x18, 0x7b, 0x1c, 0x3c, 
	0x00, 0x04, 0x26, 0x3c, 0x11, 0x53, 0x53, 0x54, 0x30, 
	0x0e, 0x98, 0x26, 0x3c, 0x52, 0x9e, 0x9e, 0x38, 0x57, 
	0x10, 0x26, 0x37, 0x11, 0x00, 0x04, 0x9e, 0x9d, 0x86, 
	0x36, 0x36, 0x36, 0x26, 0x26, 0x26, 0x1c, 0x69, 0x69, 
	0x53, 0x07, 0x00, 0x04, 0x03, 0x0f, 0x0f, 0x0f, 0x00, 
	0x04, 0x26, 0x11, 0x15, 0x15, 0x38, 0x03, 0x03, 0x03, 
	0x0b, 0x99, 0x96, 0x96, 0x00, 0x04, 0x76, 0x96, 0x9a, 
	0xb5, 0xb5, 0x67, 0x18, 0x00, 0x04, 0x02, 0x94, 0x77, 
	0x77, 0x54, 0x96, 0x99, 0x99, 0x99, 0x6f, 0xb1, 0xb5, 
	0x65, 0x5f, 0x00, 0x04, 0x02, 0x94, 0x77, 0x54, 0x8a, 
	0x77, 0x00, 0x04, 0x99, 0x77, 0x8f, 0xb1, 0x5e, 0xc5, 
	0x78, 0x5c, 0x46, 0x54, 0x8f, 0x8f, 0x54, 0x77, 0x70, 
	0x70, 0x12, 0x03, 0x03, 0x22, 0x96, 0x99, 0x77, 0x9a, 
	0x5c, 0x1e, 0x1e, 0x46, 0x96, 0x96, 0x54, 0x6d, 0x8f, 
	0x5e, 0x9a, 0x8f, 0x6f, 0x77, 0x6e, 0x70, 0xa4, 0x02, 
	0x18, 0x59, 0x77, 0x99, 0x96, 0x8f, 0x42, 0x1e, 0x1e, 
	0x41, 0x96, 0x77, 0x54, 0x6d, 0x8f, 0xb5, 0x7a, 0x92, 
	0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0xaa, 
	0x25, 0x1c, 0x00, 0x04, 0x11, 0x7b, 0x00, 0x0a, 0x03, 
	0x2c, 0x38, 0xc2, 0x53, 0x53, 0x69, 0x9e, 0x69, 0x53, 
	0x53, 0x6a, 0x1b, 0x00, 0x04, 0x02, 0x04, 0xc7, 0x11, 
	0x69, 0x53, 0x53, 0x9e, 0x9e, 0x69, 0x53, 0x9d, 0x2a, 
	0x2e, 0x0e, 0x24, 0x11, 0x00, 0x04, 0x9e, 0x25, 0x57, 
	0x36, 0x00, 0x04, 0x9e, 0x53, 0x6a, 0x07, 0x03, 0x03, 
	0x7f, 0x37, 0x11, 0x53, 0x69, 0x69, 0x9e, 0x69, 0x53, 
	0x74, 0x00, 0x05, 0x03, 0x0f, 0x0f, 0x36, 0x69, 0x9e, 
	0xa1, 0x27, 0x15, 0x15, 0x15, 0x9d, 0x03, 0x03, 0x03, 
	0x28, 0x3d, 0x6f, 0x8f, 0x62, 0x62, 0xb5, 0x5e, 0x5e, 
	0x5e, 0xb5, 0x59, 0x04, 0x00, 0x05, 0x02, 0x18, 0x78, 
	0x6f, 0x8f, 0x62, 0xb1, 0xb1, 0x5e, 0x5e, 0x5e, 0x65, 
	0x48, 0x00, 0x05, 0x02, 0x18, 0x78, 0x6f, 0x8f, 0xa5, 
	0xb1, 0xb1, 0xb1, 0x27, 0x27, 0x27, 0x5e, 0x92, 0xa3, 
	0x03, 0x07, 0x6a, 0x9a, 0x62, 0x62, 0x62, 0xa5, 0x70, 
	0x70, 0xa3, 0x03, 0x03, 0x03, 0xa3, 0x96, 0x77, 0x54, 
	0x42, 0x1e, 0x5c, 0x8f, 0x27, 0x7a, 0x7a, 0x7a, 0x6e, 
	0x27, 0x62, 0xa5, 0xa5, 0xa5, 0x7a, 0x70, 0x48, 0x02, 
	0x02, 0x2b, 0x9c, 0x99, 0x77, 0xac, 0x61, 0x1e, 0x42, 
	0x9d, 0x5e, 0x7a, 0x7a, 0x7a, 0x6e, 0x6e, 0x65, 0xb2, 
	0x00, 0x09, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0x19, 
	0x25, 0x52, 0x11, 0x11, 0x38, 0x0b, 0x00, 0x0b, 0x03, 
	0x02, 0x2c, 0x54, 0xa1, 0x15, 0xd3, 0x27, 0x9e, 0x53, 
	0xca, 0x18, 0x00, 0x06, 0x02, 0x43, 0xb2, 0xc5, 0x27, 
	0x15, 0x15, 0xa1, 0x53, 0x67, 0x04, 0x02, 0x17, 0x98, 
	0x38, 0x9e, 0x9e, 0xc5, 0x4b, 0xd1, 0x57, 0x36, 0x9e, 
	0x9e, 0x9e, 0x92, 0x74, 0x6b, 0x00, 0x05, 0x03, 0x39, 
	0x11, 0xa1, 0x15, 0x15, 0xa1, 0x53, 0x74, 0x00, 0x05, 
	0x03, 0x28, 0x0f, 0x37, 0x00, 0x07, 0xd3, 0x15, 0x6a, 
	0x00, 0x04, 0x03, 0x6b, 0x6a, 0x62, 0x6e, 0x70, 0x70, 
	0x70, 0x6e, 0x65, 0xae, 0x18, 0x00, 0x07, 0x02, 0x18, 
	0xae, 0x65, 0x5e, 0x7a, 0x70, 0x7a, 0x5e, 0x59, 0x2a, 
	0x00, 0x07, 0x02, 0x18, 0xa6, 0x92, 0x5e, 0x27, 0x70, 
	0x7a, 0x7a, 0x5e, 0x9c, 0x78, 0x19, 0x00, 0x04, 0x03, 
	0x21, 0x4e, 0x65, 0x62, 0x62, 0x5e, 0x70, 0x0b, 0x00, 
	0x04, 0x03, 0x4e, 0x77, 0x76, 0x1e, 0x8e, 0xb1, 0x7a, 
	0x7a, 0x6e, 0x5e, 0x92, 0x59, 0x12, 0x67, 0x65, 0xa5, 
	0xa5, 0x5e, 0x6e, 0x5f, 0x02, 0x02, 0x02, 0xab, 0x54, 
	0x54, 0x46, 0x1e, 0x40, 0x62, 0x6e, 0x7a, 0x6e, 0x62, 
	0x9c, 0xb2, 0x63, 0x18, 0x00, 0x0a, 0x02, 0x01, 0x01, 
	0x00, 0x0c, 0x03, 0x0a, 0x11, 0x11, 0x54, 0x22, 0x00, 
	0x0c, 0x03, 0x02, 0x02, 0x18, 0x63, 0xca, 0x67, 0xb2, 
	0xa6, 0x5f, 0x00, 0x0a, 0x02, 0x5f, 0xa6, 0xb2, 0xb2, 
	0xa9, 0x2a, 0x02, 0x02, 0x02, 0x17, 0x26, 0x9e, 0x92, 
	0xca, 0x5f, 0x18, 0xb3, 0x26, 0x9e, 0xc5, 0x4b, 0x0b, 
	0x00, 0x09, 0x03, 0x6b, 0xcb, 0x67, 0x67, 0xcb, 0x6b, 
	0x00, 0x06, 0x03, 0x19, 0x96, 0x9c, 0x4b, 0x6a, 0x67, 
	0xcb, 0x12, 0xa3, 0x07, 0x6b, 0x28, 0x00, 0x06, 0x03, 
	0x63, 0xae, 0xb2, 0xb2, 0xa9, 0xa4, 0x04, 0x00, 0x0b, 
	0x02, 0x04, 0x90, 0xb2, 0xb2, 0xa9, 0x5f, 0x18, 0x00, 
	0x0a, 0x02, 0x04, 0x90, 0xb2, 0xb2, 0xae, 0xa3, 0x6b, 
	0x00, 0x09, 0x03, 0x6b, 0x2f, 0x92, 0x62, 0x7a, 0x21, 
	0x00, 0x04, 0x03, 0x6b, 0x3d, 0x47, 0x76, 0x62, 0x9c, 
	0x78, 0x0b, 0x6b, 0x19, 0x00, 0x04, 0x03, 0x21, 0x4e, 
	0x65, 0x62, 0x5e, 0x18, 0x00, 0x04, 0x02, 0x3e, 0x96, 
	0x5c, 0x96, 0x65, 0x59, 0xa9, 0x48, 0x04, 0x18, 0x00, 
	0x0e, 0x02, 0x01, 0x01, 0x00, 0x0c, 0x03, 0xa2, 0x11, 
	0x39, 0x00, 0x0e, 0x03, 0x00, 0x1c, 0x02, 0x23, 0x67, 
	0x3e, 0x18, 0x02, 0x02, 0x1b, 0xad, 0x8f, 0xb2, 0x5f, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x0d, 
	0x03, 0x19, 0x5a, 0x92, 0x19, 0x00, 0x05, 0x03, 0x19, 
	0x07, 0x0b, 0x00, 0x0c, 0x03, 0x6b, 0x2f, 0x9c, 0x00, 
	0x06, 0x02, 0x2a, 0xc8, 0x63, 0x18, 0x00, 0x13, 0x02, 
	0x01, 0x01, 0x00, 0x0c, 0x03, 0x7f, 0x1f, 0x00, 0x0f, 
	0x03, 0x00, 0x22, 0x02, 0x23, 0x3e, 0x04, 0x02, 0x02, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x1d, 0x02, 0x01, 0x01, 0x00, 0x1d, 0x03, 
	0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x28, 0x03, 0x00, 0x1d, 0x02, 0x01, 0x01, 0x00, 
	0x1d, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x1d, 0x02, 0x01, 
	0x01, 0x00, 0x1d, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x1d, 
	0x02, 0x01, 0x01, 0x00, 0x11, 0x03, 0x00, 0x0c, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x0b, 0x7f, 0x00, 0x12, 0x02, 
	0x01, 0x01, 0x00, 0x0f, 0x03, 0x00, 0x0e, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x0d, 0x7f, 0x00, 0x10, 0x02, 0x01, 
	0x01, 0x00, 0x0d, 0x03, 0x00, 0x10, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x0f, 0x7f, 0x00, 0x0e, 0x02, 0x01, 0x01, 
	0x00, 0x0c, 0x03, 0x00, 0x11, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x10, 0x7f, 0x00, 0x0d, 0x02, 0x01, 0x01, 0x00, 
	0x0c, 0x03, 0x00, 0x11, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x10, 0x7f, 0x00, 0x0d, 0x02, 0x01, 0x01, 0x00, 0x0b, 
	0x03, 0x00, 0x12, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x11, 
	0x7f, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 
	0x00, 0x12, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x11, 0x7f, 
	0x00, 0x0c, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x12, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 
	0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x12, 0x7f, 0x00, 
	0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 
	0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x0c, 0x7f, 0xbd, 0xbd, 0x83, 0x00, 0x19, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x0c, 0x7f, 0x85, 0x85, 
	0xbd, 0x00, 0x19, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x0c, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x19, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x0c, 0x7f, 0x85, 
	0x85, 0xbd, 0x00, 0x19, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 0x03, 0x01, 
	0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x0c, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x19, 
	0x7f, 0x00, 0x19, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0c, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x0c, 0x7f, 0x85, 0x85, 0xbd, 
	0x00, 0x19, 0x7f, 0x00, 0x19, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x0c, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 
	0x13, 0x7f, 0x00, 0x1e, 0xd1, 0x09, 0x00, 0x06, 0xce, 
	0xd1, 0xd1, 0xd1, 0x00, 0x06, 0x7f, 0xbd, 0xbd, 0x85, 
	0xbd, 0xbd, 0x7f, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 
	0xbd, 0xbd, 0x00, 0x08, 0x7f, 0xbd, 0xbd, 0x83, 0x00, 
	0x05, 0x7f, 0xbd, 0xbd, 0x85, 0x85, 0xce, 0xce, 0x00, 
	0x06, 0xd1, 0xce, 0xce, 0xce, 0xd1, 0xd1, 0x00, 0x04, 
	0xce, 0x00, 0x06, 0xd1, 0x00, 0x0a, 0xce, 0x00, 0x05, 
	0xd1, 0xce, 0xce, 0x00, 0x05, 0x7f, 0xbd, 0xbd, 0xbd, 
	0x00, 0x06, 0x7f, 0xbd, 0xbd, 0x7f, 0x7f, 0xbd, 0xbd, 
	0x85, 0x85, 0xbd, 0xbd, 0x00, 0x06, 0x7f, 0xbd, 0xbd, 
	0x85, 0x85, 0xbd, 0xbd, 0x00, 0x04, 0x7f, 0x00, 0x04, 
	0xd1, 0x00, 0x07, 0xce, 0x00, 0x07, 0xd1, 0x00, 0x0b, 
	0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 
	0x00, 0x1d, 0xd1, 0x00, 0x09, 0xce, 0xd1, 0xd1, 0x00, 
	0x05, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0xbd, 0x85, 0xbd, 
	0x85, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0xbd, 
	0x00, 0x06, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x05, 0x7f, 
	0xbd, 0x85, 0x85, 0xbd, 0xbd, 0xce, 0xce, 0xce, 0x00, 
	0x05, 0xd1, 0x00, 0x0a, 0xce, 0x00, 0x04, 0xd1, 0x00, 
	0x0c, 0xce, 0xd1, 0xd1, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x05, 0x7f, 0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 0x83, 
	0x85, 0x85, 0xbd, 0xbd, 0x00, 0x05, 0x85, 0xbd, 0x00, 
	0x05, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0xbd, 0x85, 0x85, 
	0xbd, 0x7f, 0x7f, 0x7f, 0xd1, 0xd1, 0xd1, 0x00, 0x09, 
	0xce, 0x00, 0x06, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x1e, 0xd1, 
	0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0xd1, 0x00, 
	0x04, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 
	0xbd, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 
	0xbd, 0x00, 0x06, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x04, 
	0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x04, 0xd1, 0x00, 0x05, 0xce, 0x09, 
	0xd1, 0x00, 0x04, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x09, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 
	0x7f, 0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 0x83, 0x00, 
	0x04, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 
	0x04, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 
	0x85, 0x85, 0xbd, 0x7f, 0x7f, 0xd1, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x0d, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 
	0x00, 0x0a, 0x02, 0x00, 0x13, 0x7f, 0x00, 0x24, 0xd1, 
	0xce, 0xce, 0xce, 0xd1, 0x00, 0x04, 0x7f, 0x85, 0x85, 
	0xbd, 0x00, 0x05, 0x7f, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 
	0x7f, 0xbd, 0x85, 0x85, 0x83, 0x00, 0x04, 0x7f, 0xbd, 
	0x85, 0x85, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 
	0x7f, 0x7f, 0x7f, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x04, 
	0xd1, 0x00, 0x04, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x09, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0x7f, 0xbd, 0x85, 
	0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 0x85, 0x85, 0xbd, 
	0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 
	0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 0xbd, 0x85, 0xbd, 
	0x7f, 0x7f, 0xd1, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0d, 
	0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 
	0x00, 0x13, 0x7f, 0x00, 0x24, 0xd1, 0xce, 0xce, 0xce, 
	0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x83, 0x00, 
	0x05, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 
	0x85, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 
	0x04, 0x7f, 0xbd, 0x85, 0x85, 0x00, 0x04, 0x7f, 0xd1, 
	0xd1, 0xce, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x09, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x05, 0x7f, 0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 
	0x83, 0x85, 0x85, 0xbd, 0x00, 0x0a, 0x7f, 0xbd, 0x85, 
	0xbd, 0x00, 0x05, 0x7f, 0xbd, 0x85, 0x85, 0x7f, 0x7f, 
	0xd1, 0xd1, 0x00, 0x04, 0xce, 0x00, 0x0c, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 0x02, 0x00, 0x13, 
	0x7f, 0x00, 0x20, 0xd1, 0x00, 0x07, 0xce, 0xd1, 0x7f, 
	0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x00, 0x06, 0x7f, 0x85, 
	0x85, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0x85, 0x00, 
	0x04, 0x7f, 0x85, 0x85, 0x83, 0x00, 0x04, 0x7f, 0xbd, 
	0x85, 0x00, 0x05, 0xbd, 0x00, 0x05, 0xce, 0xd1, 0xd1, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x09, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0x7f, 0xbd, 0x85, 
	0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 0x85, 0x83, 0x00, 
	0x0a, 0x7f, 0x85, 0x85, 0x00, 0x07, 0xbd, 0x85, 0x85, 
	0x83, 0x7f, 0xd1, 0xd1, 0xd1, 0x00, 0x05, 0xce, 0x00, 
	0x0a, 0xd1, 0x00, 0x0b, 0x03, 0x01, 0x01, 0x00, 0x0a, 
	0x02, 0x00, 0x13, 0x7f, 0x00, 0x1e, 0xd1, 0x00, 0x09, 
	0xce, 0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x00, 
	0x06, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x05, 0x7f, 0x85, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x05, 
	0x7f, 0x00, 0x07, 0x85, 0x00, 0x05, 0xce, 0xd1, 0xd1, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x09, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0x7f, 0xbd, 0x85, 
	0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 0x85, 0x83, 0x00, 
	0x09, 0x7f, 0x83, 0x00, 0x0b, 0x85, 0x83, 0x7f, 0x00, 
	0x04, 0xd1, 0x00, 0x07, 0xce, 0x00, 0x07, 0xd1, 0x00, 
	0x0b, 0x03, 0x01, 0x01, 0x00, 0x0b, 0x02, 0x00, 0x12, 
	0x7f, 0x00, 0x1d, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x04, 
	0xd1, 0xce, 0xce, 0xce, 0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 
	0x85, 0x85, 0x00, 0x06, 0x7f, 0x85, 0x85, 0xbd, 0x00, 
	0x05, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 
	0xbd, 0x00, 0x05, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x04, 
	0x83, 0x00, 0x08, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x09, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 
	0x7f, 0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 
	0x85, 0x83, 0x00, 0x09, 0x7f, 0x83, 0x85, 0x85, 0xbd, 
	0x00, 0x08, 0x83, 0x7f, 0x7f, 0x00, 0x07, 0xd1, 0x00, 
	0x05, 0xce, 0x00, 0x05, 0xd1, 0x00, 0x0c, 0x03, 0x01, 
	0x01, 0x00, 0x0b, 0x02, 0x00, 0x12, 0x7f, 0x00, 0x1d, 
	0xd1, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 
	0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x00, 0x06, 
	0x7f, 0x85, 0x85, 0xbd, 0x00, 0x05, 0x7f, 0xbd, 0x85, 
	0x85, 0x83, 0xbd, 0x85, 0xbd, 0x00, 0x06, 0x7f, 0xbd, 
	0x85, 0xbd, 0x00, 0x04, 0x7f, 0x00, 0x08, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x09, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x05, 0x7f, 0xbd, 0x85, 0x85, 0x00, 
	0x05, 0x7f, 0x83, 0x85, 0x85, 0x83, 0x00, 0x0a, 0x7f, 
	0x85, 0x85, 0xbd, 0x00, 0x0a, 0x7f, 0x00, 0x09, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0x00, 0x0c, 0x03, 
	0x01, 0x01, 0x00, 0x0c, 0x02, 0x00, 0x11, 0x7f, 0x00, 
	0x1c, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 
	0xce, 0xce, 0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 
	0xbd, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0x00, 
	0x06, 0x7f, 0xbd, 0x85, 0xbd, 0xbd, 0x85, 0xbd, 0x00, 
	0x06, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 
	0x00, 0x08, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x09, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x04, 0x7f, 
	0xbd, 0x85, 0x85, 0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 
	0x85, 0x83, 0x00, 0x0a, 0x7f, 0xbd, 0x85, 0x85, 0x00, 
	0x0a, 0x7f, 0x00, 0x0a, 0xd1, 0xce, 0xce, 0x00, 0x04, 
	0xd1, 0x00, 0x0d, 0x03, 0x01, 0x01, 0x00, 0x0c, 0x02, 
	0x00, 0x11, 0x7f, 0x00, 0x1c, 0xd1, 0x09, 0xce, 0xce, 
	0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 0xce, 0xd1, 0x00, 
	0x04, 0x7f, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 
	0x85, 0x85, 0x85, 0xbd, 0x00, 0x06, 0x7f, 0xbd, 0x00, 
	0x04, 0x85, 0x00, 0x08, 0x7f, 0xbd, 0x85, 0xbd, 0x83, 
	0x7f, 0x7f, 0x00, 0x08, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x07, 0xd1, 0xce, 
	0xce, 0x00, 0x0a, 0xd1, 0xce, 0xce, 0xbd, 0x7f, 0x7f, 
	0xbd, 0x00, 0x04, 0x85, 0x00, 0x05, 0x7f, 0x83, 0x85, 
	0x85, 0x83, 0x00, 0x0a, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 
	0x00, 0x09, 0x7f, 0xd1, 0xd1, 0xce, 0x00, 0x06, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x04, 0xd1, 0x00, 0x0d, 0x03, 
	0x01, 0x01, 0x00, 0x0d, 0x02, 0x00, 0x10, 0x7f, 0x00, 
	0x1d, 0xd1, 0x00, 0x0b, 0xce, 0x83, 0x7f, 0x7f, 0x7f, 
	0xbd, 0x85, 0x85, 0xbd, 0xbd, 0xbd, 0x85, 0xbd, 0x85, 
	0x85, 0xbd, 0x00, 0x07, 0x7f, 0x85, 0x85, 0x85, 0xbd, 
	0x00, 0x08, 0x7f, 0xbd, 0xbd, 0x85, 0x85, 0xbd, 0xbd, 
	0x00, 0x05, 0xce, 0xd1, 0xd1, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x07, 0xd1, 
	0x00, 0x08, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 0x00, 
	0x04, 0x85, 0xbd, 0xbd, 0x85, 0x85, 0x00, 0x05, 0x7f, 
	0x83, 0x85, 0x85, 0x83, 0x00, 0x0b, 0x7f, 0xbd, 0x85, 
	0x85, 0x85, 0x00, 0x05, 0xbd, 0x85, 0x83, 0x7f, 0xd1, 
	0xd1, 0x00, 0x0a, 0xce, 0xd1, 0xd1, 0xd1, 0x00, 0x0e, 
	0x03, 0x01, 0x01, 0x00, 0x0f, 0x02, 0x00, 0x0e, 0x7f, 
	0x00, 0x1e, 0xd1, 0x00, 0x06, 0xce, 0xd1, 0xce, 0xce, 
	0xce, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0x85, 0x85, 
	0xbd, 0xbd, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x07, 0x7f, 
	0xbd, 0x85, 0x85, 0x83, 0x00, 0x0a, 0x7f, 0xbd, 0x85, 
	0x85, 0x85, 0x00, 0x04, 0xce, 0x00, 0x04, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x08, 0xd1, 0x00, 0x07, 0xce, 0x00, 0x05, 0xd1, 0xce, 
	0x85, 0x85, 0x85, 0xbd, 0x7f, 0xbd, 0x85, 0x85, 0x00, 
	0x05, 0x7f, 0x83, 0x85, 0x85, 0x83, 0x00, 0x0c, 0x7f, 
	0x83, 0xbd, 0x00, 0x05, 0x85, 0xbd, 0xbd, 0x7f, 0x7f, 
	0xd1, 0xd1, 0x00, 0x08, 0xce, 0xd1, 0xd1, 0xd1, 0x00, 
	0x10, 0x03, 0x01, 0x01, 0x00, 0x11, 0x02, 0x00, 0x0c, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x07, 0x7f, 0x83, 0x83, 
	0x00, 0x1e, 0x7f, 0x83, 0x00, 0x28, 0xd1, 0x83, 0x83, 
	0x00, 0x1e, 0x7f, 0x83, 0x83, 0x83, 0x00, 0x05, 0x7f, 
	0x00, 0x0b, 0xd1, 0x00, 0x12, 0x03, 0x01, 0x01, 0x00, 
	0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 
	0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 
	0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 
	0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 
	0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 
	0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 0x01, 
	0x00, 0x11, 0x02, 0x00, 0x0c, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x0b, 0xd1, 0x00, 0x12, 0x03, 0x01, 0x01, 0x00, 
	0x0f, 0x03, 0x00, 0x0e, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x0d, 0x7f, 0x00, 0x10, 0x02, 0x01, 0x01, 0x00, 0x0d, 
	0x03, 0x00, 0x10, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x0f, 
	0x7f, 0x00, 0x0e, 0x02, 0x01, 0x01, 0x00, 0x0c, 0x03, 
	0x00, 0x11, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x10, 0x7f, 
	0x00, 0x0d, 0x02, 0x01, 0x01, 0x00, 0x0c, 0x03, 0x00, 
	0x11, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 
	0x28, 0x7f, 0x00, 0x1d, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x08, 0xd1, 0x00, 0x10, 0x7f, 0x00, 0x0d, 0x02, 0x01, 
	0x01, 0x00, 0x0b, 0x03, 0x00, 0x12, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x1d, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x08, 0xd1, 0x00, 0x11, 
	0x7f, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 
	0x00, 0x12, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x16, 0xd1, 
	0x00, 0x07, 0xce, 0x00, 0x06, 0xd1, 0x00, 0x05, 0xce, 
	0xbd, 0x00, 0x05, 0x7f, 0xbd, 0xbd, 0xbd, 0x7f, 0xbd, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 
	0x7f, 0xbd, 0xbd, 0xbd, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 
	0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x07, 0x7f, 0x00, 0x06, 
	0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xd1, 0xd1, 0x00, 
	0x05, 0xce, 0x00, 0x05, 0xd1, 0x00, 0x0b, 0xce, 0xd1, 
	0xd1, 0xd1, 0x7f, 0x7f, 0x7f, 0xbd, 0xbd, 0x85, 0x85, 
	0x85, 0xbd, 0xbd, 0xbd, 0x00, 0x06, 0x7f, 0x00, 0x0c, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x14, 0xd1, 0x00, 0x09, 0xce, 
	0x00, 0x05, 0xd1, 0x00, 0x06, 0xce, 0x85, 0x85, 0xbd, 
	0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0xbd, 0x85, 0x85, 
	0x85, 0xbd, 0xbd, 0x85, 0x85, 0x85, 0xbd, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0xbd, 0x85, 0x85, 0x85, 0xbd, 0xbd, 
	0x85, 0x85, 0x85, 0xbd, 0x00, 0x05, 0x7f, 0xbd, 0x00, 
	0x07, 0xce, 0x00, 0x05, 0xd1, 0x00, 0x0a, 0xce, 0x00, 
	0x04, 0xd1, 0x00, 0x0c, 0xce, 0xd1, 0xd1, 0x7f, 0x7f, 
	0xbd, 0x85, 0x85, 0x00, 0x04, 0xbd, 0x85, 0x85, 0x00, 
	0x07, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 
	0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x13, 
	0xd1, 0x00, 0x04, 0xce, 0x00, 0x05, 0xd1, 0x09, 0x00, 
	0x04, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x04, 0xd1, 0xbd, 
	0x85, 0x85, 0x83, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x85, 
	0xbd, 0xbd, 0x85, 0xbd, 0x85, 0xbd, 0xbd, 0x85, 0x85, 
	0x7f, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0x7f, 0xbd, 0x85, 
	0xbd, 0xbd, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x04, 0x7f, 
	0xbd, 0x85, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x04, 0xd1, 0x00, 0x05, 0xce, 0xd1, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x07, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x08, 0xd1, 0x7f, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x05, 
	0x7f, 0xbd, 0x00, 0x07, 0x7f, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 
	0x7f, 0x00, 0x13, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0a, 
	0xd1, 0x09, 0xce, 0xce, 0x00, 0x05, 0xd1, 0x7f, 0x85, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0xbd, 0x7f, 
	0x83, 0x85, 0x85, 0xbd, 0x7f, 0x83, 0x85, 0x85, 0x7f, 
	0x7f, 0xbd, 0x85, 0x85, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 
	0xbd, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 
	0x85, 0x85, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x04, 0xd1, 0x00, 0x04, 0xce, 0x00, 0x04, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x08, 0xd1, 0x7f, 0x83, 0x85, 0x85, 0x83, 0x00, 0x0d, 
	0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x0b, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x05, 0xd1, 0x7f, 0xbd, 0x85, 0x85, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 
	0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 
	0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 
	0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x05, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x08, 0xd1, 0x7f, 0x7f, 
	0x85, 0x85, 0xbd, 0x83, 0x00, 0x0c, 0x7f, 0x00, 0x0b, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x00, 0x13, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x0b, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 
	0x7f, 0xbd, 0x85, 0x85, 0x83, 0x7f, 0xbd, 0x85, 0xbd, 
	0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 0x83, 0x85, 
	0x85, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 
	0x7f, 0x85, 0x85, 0xbd, 0x00, 0x08, 0xce, 0x00, 0x04, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x08, 
	0xd1, 0x7f, 0x7f, 0xbd, 0x85, 0x85, 0x85, 0xbd, 0xbd, 
	0x00, 0x0a, 0x7f, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x00, 0x13, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0b, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x05, 0xd1, 0x7f, 0xbd, 0x85, 0x85, 
	0x83, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 
	0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 0xbd, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x85, 
	0x00, 0x08, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x08, 0xd1, 0x7f, 0x7f, 0x7f, 
	0xbd, 0xbd, 0x00, 0x04, 0x85, 0xbd, 0x00, 0x08, 0x7f, 
	0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0x00, 
	0x12, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x12, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x0b, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x05, 0xd1, 0x7f, 0xbd, 0x85, 0x85, 0x83, 0x7f, 0xbd, 
	0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 
	0x83, 0x85, 0x85, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 
	0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 
	0x7f, 0x7f, 0x83, 0x85, 0x85, 0xbd, 0x00, 0x0c, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x08, 0xd1, 
	0x00, 0x06, 0x7f, 0xbd, 0xbd, 0x85, 0x85, 0x85, 0x83, 
	0x00, 0x05, 0x7f, 0x00, 0x0c, 0x02, 0x01, 0x01, 0x00, 
	0x0b, 0x03, 0x00, 0x12, 0xd1, 0x00, 0x28, 0x7f, 0x00, 
	0x12, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0b, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x05, 0xd1, 0x7f, 0xbd, 0x85, 0x85, 
	0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 0x85, 
	0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 0xbd, 
	0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0x85, 0x85, 0xbd, 
	0x00, 0x0c, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 0xce, 
	0x00, 0x08, 0xd1, 0x00, 0x08, 0x7f, 0xbd, 0x85, 0x85, 
	0xbd, 0x00, 0x05, 0x7f, 0x00, 0x0c, 0x02, 0x01, 0x01, 
	0x00, 0x0c, 0x03, 0x00, 0x11, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x12, 0xd1, 0x00, 0x04, 0xce, 0x00, 0x0a, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x05, 0xd1, 0x7f, 0xbd, 0x85, 
	0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 
	0x85, 0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 
	0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 
	0x85, 0x00, 0x0c, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x05, 
	0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x08, 0xd1, 0x00, 0x09, 0x7f, 0xbd, 0x85, 
	0xbd, 0x00, 0x04, 0x7f, 0x00, 0x0d, 0x02, 0x01, 0x01, 
	0x00, 0x0c, 0x03, 0x00, 0x11, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x13, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x0b, 0xd1, 
	0xce, 0xce, 0xce, 0x00, 0x04, 0xd1, 0xbd, 0x85, 0x85, 
	0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x83, 
	0x85, 0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 
	0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 
	0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 
	0x85, 0xce, 0x00, 0x0b, 0xd1, 0xce, 0xce, 0xce, 0x00, 
	0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x06, 0xd1, 0xce, 
	0xce, 0xce, 0x00, 0x08, 0xd1, 0x7f, 0x83, 0xbd, 0x00, 
	0x06, 0x7f, 0x85, 0x85, 0xbd, 0x00, 0x04, 0x7f, 0x00, 
	0x0d, 0x02, 0x01, 0x01, 0x00, 0x0d, 0x03, 0x00, 0x10, 
	0xd1, 0x00, 0x28, 0x7f, 0x00, 0x14, 0xd1, 0x00, 0x09, 
	0xce, 0x00, 0x05, 0xd1, 0x00, 0x06, 0xce, 0x85, 0x85, 
	0xbd, 0x7f, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 
	0x83, 0x85, 0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 0x7f, 
	0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 
	0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 
	0x85, 0x00, 0x08, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x07, 
	0xd1, 0x00, 0x08, 0xce, 0xd1, 0xd1, 0x7f, 0xbd, 0x85, 
	0x85, 0x00, 0x04, 0xbd, 0x85, 0x85, 0xbd, 0x00, 0x04, 
	0x7f, 0x00, 0x0e, 0x02, 0x01, 0x01, 0x00, 0x0f, 0x03, 
	0x00, 0x0e, 0xd1, 0x00, 0x28, 0x7f, 0x00, 0x15, 0xd1, 
	0x00, 0x08, 0xce, 0x00, 0x06, 0xd1, 0x00, 0x05, 0xce, 
	0xbd, 0xbd, 0x00, 0x04, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 
	0x7f, 0x83, 0x85, 0x85, 0x7f, 0x7f, 0x83, 0x85, 0x85, 
	0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x7f, 0x7f, 0xbd, 0x85, 
	0xbd, 0x7f, 0x7f, 0xbd, 0x85, 0xbd, 0x00, 0x05, 0x7f, 
	0x83, 0x00, 0x08, 0xce, 0x00, 0x04, 0xd1, 0xce, 0xce, 
	0xce, 0x00, 0x05, 0xd1, 0xce, 0xce, 0xce, 0x00, 0x08, 
	0xd1, 0x00, 0x07, 0xce, 0xd1, 0xd1, 0x7f, 0x83, 0xbd, 
	0x00, 0x06, 0x85, 0xbd, 0x7f, 0x7f, 0x7f, 0x00, 0x10, 
	0x02, 0x01, 0x01, 0x00, 0x11, 0x03, 0x00, 0x0c, 0xd1, 
	0x00, 0x28, 0x7f, 0x00, 0x28, 0xd1, 0x00, 0x28, 0x7f, 
	0x00, 0x28, 0xd1, 0x00, 0x05, 0x7f, 0x83, 0x83, 0x83, 
	0x7f, 0x7f, 0x7f, 0x00, 0x12, 0x02, 0x01, 0x01, 0x00, 
	0x1d, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x1d, 0x02, 0x01, 
	0x01, 0x00, 0x1d, 0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x1d, 
	0x02, 0x01, 0x01, 0x00, 0x1d, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x23, 0x03, 0x31, 0x87, 0x03, 0x03, 0x03, 0x00, 
	0x09, 0x02, 0x16, 0x00, 0x1e, 0x02, 0x00, 0x28, 0x03, 
	0x00, 0x06, 0x02, 0x16, 0xba, 0x06, 0xba, 0x02, 0x02, 
	0x02, 0x05, 0x16, 0x00, 0x0e, 0x02, 0x01, 0x01, 0x00, 
	0x1d, 0x03, 0x00, 0x28, 0x02, 0x00, 0x21, 0x03, 0x1a, 
	0xd4, 0x25, 0x09, 0x03, 0x03, 0x03, 0x00, 0x08, 0x02, 
	0x04, 0xce, 0x06, 0x00, 0x05, 0x02, 0xd4, 0x00, 0x17, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x06, 0x02, 0x25, 0x25, 
	0x25, 0x07, 0x02, 0x02, 0x02, 0x07, 0xba, 0x00, 0x0e, 
	0x02, 0x01, 0x01, 0x00, 0x0d, 0x03, 0x1a, 0x1a, 0x00, 
	0x0e, 0x03, 0x00, 0x28, 0x02, 0x00, 0x21, 0x03, 0x30, 
	0x25, 0x25, 0x09, 0x03, 0x03, 0x03, 0x00, 0x08, 0x02, 
	0x7f, 0x25, 0x09, 0x00, 0x04, 0x02, 0x16, 0xce, 0x00, 
	0x17, 0x02, 0x00, 0x1e, 0x03, 0x1a, 0x30, 0x1a, 0x00, 
	0x07, 0x03, 0x00, 0x06, 0x02, 0x25, 0x25, 0x25, 0x07, 
	0x02, 0x02, 0x02, 0x07, 0xba, 0x00, 0x0e, 0x02, 0x01, 
	0x01, 0x00, 0x0b, 0x03, 0x28, 0x82, 0x25, 0x0a, 0x28, 
	0x00, 0x0c, 0x03, 0x28, 0xba, 0x04, 0x00, 0x26, 0x02, 
	0x00, 0x21, 0x03, 0x30, 0x25, 0x25, 0x09, 0x03, 0x03, 
	0x03, 0x00, 0x07, 0x02, 0x21, 0x25, 0x25, 0x25, 0x16, 
	0x02, 0x02, 0x02, 0x07, 0x1f, 0x00, 0x17, 0x02, 0x00, 
	0x1c, 0x03, 0x86, 0x0a, 0x25, 0x25, 0x25, 0x82, 0x00, 
	0x06, 0x03, 0x02, 0x02, 0x02, 0x06, 0x02, 0x02, 0x25, 
	0x25, 0x25, 0xba, 0x02, 0x02, 0x02, 0x07, 0xba, 0x00, 
	0x0e, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x28, 0xd4, 
	0x25, 0xd1, 0x82, 0x87, 0x03, 0x03, 0x03, 0x28, 0x3a, 
	0x09, 0x09, 0x3a, 0x03, 0x03, 0x03, 0x28, 0xd4, 0x25, 
	0x25, 0x05, 0x00, 0x04, 0x02, 0x04, 0x23, 0x00, 0x1f, 
	0x02, 0x00, 0x1d, 0x03, 0x30, 0x03, 0x03, 0x03, 0x28, 
	0x25, 0x25, 0x09, 0x03, 0x03, 0x03, 0x02, 0x16, 0xba, 
	0x00, 0x04, 0x02, 0xd4, 0x25, 0x25, 0x25, 0x08, 0x02, 
	0x02, 0x02, 0x83, 0xba, 0x00, 0x17, 0x02, 0x00, 0x1b, 
	0x03, 0x1a, 0x25, 0x25, 0x3a, 0xbe, 0x0a, 0x35, 0x03, 
	0x03, 0x03, 0x28, 0x31, 0x03, 0x02, 0x02, 0x23, 0x25, 
	0x04, 0x02, 0x25, 0x25, 0x25, 0xba, 0x02, 0x02, 0x02, 
	0x07, 0xba, 0x02, 0x04, 0x04, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x3a, 0x25, 0x35, 0x03, 0x3a, 
	0x25, 0x03, 0x03, 0x03, 0xd4, 0x25, 0x09, 0xd4, 0x25, 
	0x31, 0x03, 0x03, 0x87, 0x00, 0x04, 0x25, 0x07, 0x02, 
	0x02, 0x07, 0x0a, 0x07, 0x00, 0x1f, 0x02, 0x00, 0x1b, 
	0x03, 0x1a, 0xd4, 0x25, 0x35, 0x1a, 0x03, 0x03, 0x25, 
	0x25, 0x09, 0x03, 0x03, 0x03, 0x05, 0x25, 0x25, 0xce, 
	0x04, 0x02, 0x02, 0x06, 0x00, 0x04, 0x25, 0x04, 0x02, 
	0x02, 0x0a, 0x00, 0x18, 0x02, 0x00, 0x1b, 0x03, 0x3a, 
	0x25, 0x35, 0x03, 0x03, 0x87, 0x25, 0x03, 0x03, 0x1a, 
	0x0a, 0x25, 0x1a, 0x02, 0x02, 0x83, 0x08, 0x02, 0x02, 
	0x25, 0x25, 0x25, 0x16, 0x04, 0xba, 0x06, 0xd1, 0xce, 
	0x0a, 0x25, 0x07, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x03, 0x09, 0x25, 0x31, 0x03, 0x82, 0x25, 0x03, 
	0x03, 0xbe, 0x25, 0x25, 0x30, 0x28, 0x25, 0x3a, 0x03, 
	0x03, 0x0a, 0x25, 0x1f, 0x1f, 0x25, 0x25, 0x02, 0xba, 
	0x25, 0x25, 0x07, 0x02, 0x04, 0x07, 0xd1, 0x08, 0x04, 
	0x00, 0x19, 0x02, 0x00, 0x1a, 0x03, 0x1a, 0x00, 0x04, 
	0x25, 0x35, 0x28, 0x03, 0x25, 0x25, 0x09, 0x03, 0x03, 
	0x1a, 0x00, 0x04, 0x25, 0xd4, 0x04, 0x02, 0x02, 0xd4, 
	0x25, 0x25, 0x25, 0x07, 0x02, 0xba, 0x83, 0x00, 0x18, 
	0x02, 0x00, 0x1b, 0x03, 0x09, 0x25, 0x3a, 0x03, 0x03, 
	0x3a, 0x25, 0x03, 0x03, 0x3a, 0x25, 0x25, 0x3a, 0x02, 
	0x04, 0x25, 0x04, 0x02, 0x02, 0x07, 0x83, 0x0a, 0x02, 
	0xba, 0x00, 0x06, 0x25, 0x83, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x0a, 0x03, 0x25, 0x25, 0x30, 0x03, 0xd4, 
	0x25, 0x03, 0x03, 0x87, 0x25, 0x25, 0x30, 0x03, 0xd4, 
	0x09, 0x03, 0x1a, 0x25, 0x25, 0x04, 0x23, 0x25, 0x25, 
	0x02, 0xba, 0x25, 0x25, 0x07, 0x05, 0x0a, 0x25, 0x25, 
	0x25, 0x0a, 0x04, 0x00, 0x18, 0x02, 0x00, 0x1a, 0x03, 
	0x30, 0x00, 0x05, 0x25, 0x87, 0x03, 0x25, 0x25, 0x09, 
	0x03, 0x03, 0x3a, 0x25, 0x0a, 0x23, 0x25, 0x25, 0x07, 
	0x02, 0x02, 0x07, 0x25, 0x25, 0x25, 0xd4, 0x02, 0x1f, 
	0x07, 0x00, 0x18, 0x02, 0x00, 0x1b, 0x03, 0x35, 0x25, 
	0x1a, 0x03, 0x03, 0x87, 0x25, 0x03, 0x03, 0xbe, 0x25, 
	0x25, 0x09, 0x02, 0x1f, 0x08, 0x00, 0x07, 0x02, 0xba, 
	0x00, 0x06, 0x25, 0xd1, 0x00, 0x0b, 0x02, 0x01, 0x01, 
	0x00, 0x09, 0x03, 0x28, 0x25, 0x25, 0xbe, 0x1a, 0x09, 
	0x87, 0x03, 0x03, 0x35, 0x25, 0x25, 0x1a, 0x03, 0x09, 
	0x09, 0x03, 0x30, 0x25, 0x09, 0x02, 0x02, 0xd4, 0x25, 
	0x04, 0xba, 0x25, 0x25, 0x09, 0x00, 0x06, 0x25, 0x08, 
	0x00, 0x18, 0x02, 0x00, 0x1b, 0x03, 0x25, 0xd4, 0xbe, 
	0xbe, 0x25, 0x0a, 0x03, 0x25, 0x25, 0x09, 0x03, 0x03, 
	0x09, 0x25, 0x1f, 0x02, 0x09, 0x25, 0x07, 0x02, 0x02, 
	0x04, 0x0a, 0x25, 0x25, 0x25, 0x06, 0xce, 0x16, 0x00, 
	0x18, 0x02, 0x00, 0x1a, 0x03, 0x28, 0x25, 0x25, 0x03, 
	0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x28, 0x25, 0x25, 
	0x25, 0x16, 0x0a, 0x16, 0x00, 0x05, 0x02, 0x04, 0x1f, 
	0x21, 0x00, 0x06, 0x25, 0xd4, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x09, 0x03, 0x30, 0x25, 0x25, 0xd4, 0x00, 
	0x05, 0x03, 0x25, 0x25, 0x25, 0x03, 0x03, 0x3a, 0x28, 
	0x03, 0x3a, 0x25, 0x09, 0x02, 0x02, 0x08, 0x25, 0xba, 
	0xba, 0x00, 0x04, 0x25, 0x83, 0xba, 0xba, 0x25, 0x25, 
	0x0a, 0x00, 0x18, 0x02, 0x00, 0x1b, 0x03, 0x25, 0x3a, 
	0x03, 0x03, 0x09, 0x25, 0x03, 0x0a, 0x25, 0x3a, 0x03, 
	0x03, 0x09, 0x25, 0xba, 0x02, 0x06, 0x25, 0x08, 0x02, 
	0x02, 0x02, 0x1f, 0x25, 0x25, 0x25, 0xce, 0x0a, 0x00, 
	0x19, 0x02, 0x00, 0x1a, 0x03, 0x30, 0x25, 0x25, 0x03, 
	0x03, 0x03, 0x0a, 0x82, 0x03, 0x03, 0x03, 0xd4, 0x25, 
	0x25, 0x7f, 0x09, 0x00, 0x04, 0x02, 0x16, 0x1f, 0x0a, 
	0x25, 0x07, 0x00, 0x07, 0x25, 0x00, 0x0b, 0x02, 0x01, 
	0x01, 0x00, 0x09, 0x03, 0x30, 0x25, 0x25, 0x25, 0x31, 
	0x03, 0x03, 0x03, 0x30, 0x25, 0x25, 0x25, 0x00, 0x05, 
	0x03, 0x3a, 0x25, 0x3a, 0x02, 0x02, 0x07, 0x25, 0xba, 
	0xba, 0x25, 0x25, 0x25, 0x21, 0x02, 0x02, 0x02, 0xd4, 
	0x25, 0x25, 0x04, 0x00, 0x17, 0x02, 0x00, 0x1b, 0x03, 
	0x25, 0x3a, 0x03, 0x03, 0x09, 0x25, 0x03, 0x09, 0x25, 
	0x3a, 0x03, 0x03, 0x0a, 0x25, 0x16, 0x02, 0x04, 0x25, 
	0xd1, 0x02, 0x02, 0x02, 0x04, 0x00, 0x04, 0x25, 0x83, 
	0x00, 0x19, 0x02, 0x00, 0x1a, 0x03, 0x3a, 0x25, 0x25, 
	0x03, 0x03, 0x28, 0x25, 0xbe, 0x03, 0x03, 0x03, 0x82, 
	0x25, 0x25, 0x25, 0x05, 0x00, 0x04, 0x02, 0x08, 0x25, 
	0x25, 0x25, 0x05, 0x25, 0x25, 0x25, 0xd4, 0x08, 0x07, 
	0xba, 0x00, 0x0b, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x35, 0x25, 0x25, 0x25, 0x86, 0x03, 0x03, 0x31, 0x25, 
	0x25, 0x25, 0x00, 0x05, 0x03, 0x09, 0x25, 0x3a, 0x16, 
	0x07, 0xce, 0x25, 0xba, 0xba, 0x25, 0x25, 0x09, 0x00, 
	0x04, 0x02, 0xd1, 0x25, 0x25, 0xba, 0x00, 0x17, 0x02, 
	0x00, 0x1b, 0x03, 0x25, 0x3a, 0x03, 0x03, 0x09, 0x09, 
	0x03, 0x09, 0x25, 0x3a, 0x03, 0x03, 0x25, 0x25, 0x02, 
	0x02, 0x02, 0x25, 0xd1, 0x00, 0x04, 0x02, 0x83, 0x25, 
	0x25, 0x25, 0x07, 0x00, 0x19, 0x02, 0x00, 0x1a, 0x03, 
	0x87, 0x25, 0x25, 0x82, 0x3a, 0x87, 0x25, 0x1a, 0x03, 
	0x03, 0x03, 0xbe, 0x25, 0x25, 0x25, 0x05, 0x00, 0x04, 
	0x02, 0x07, 0x25, 0x25, 0x25, 0x16, 0x08, 0x07, 0x08, 
	0xba, 0x00, 0x0e, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 
	0x1a, 0x35, 0x25, 0x25, 0x25, 0xbe, 0x03, 0x3a, 0x25, 
	0x25, 0x25, 0x00, 0x06, 0x03, 0x1a, 0xd4, 0x00, 0x04, 
	0x25, 0xba, 0xba, 0x25, 0x25, 0x07, 0x00, 0x04, 0x02, 
	0x83, 0x25, 0x25, 0xba, 0x00, 0x17, 0x02, 0x00, 0x1b, 
	0x03, 0x25, 0x87, 0x03, 0x03, 0x09, 0x3a, 0x03, 0x09, 
	0x25, 0x3a, 0x03, 0x1a, 0x25, 0x25, 0x04, 0x06, 0x1f, 
	0x25, 0xd1, 0x00, 0x04, 0x02, 0x23, 0x25, 0x25, 0x25, 
	0x16, 0x00, 0x19, 0x02, 0x00, 0x1a, 0x03, 0x09, 0x25, 
	0x25, 0xd4, 0x09, 0x09, 0x09, 0x00, 0x04, 0x03, 0x28, 
	0x25, 0x25, 0x25, 0x1f, 0x00, 0x04, 0x02, 0x07, 0x25, 
	0x25, 0xd4, 0x02, 0x02, 0x02, 0x07, 0x05, 0x00, 0x0e, 
	0x02, 0x01, 0x01, 0x00, 0x0b, 0x03, 0x28, 0x09, 0x25, 
	0x25, 0x0a, 0x28, 0x3a, 0x25, 0x25, 0xd4, 0x00, 0x05, 
	0x03, 0x28, 0xd4, 0x25, 0xd4, 0x06, 0x07, 0x25, 0x04, 
	0xba, 0x25, 0x25, 0x07, 0x00, 0x04, 0x02, 0x07, 0x25, 
	0x25, 0xba, 0x00, 0x17, 0x02, 0x00, 0x1b, 0x03, 0x25, 
	0x09, 0x03, 0x1a, 0x25, 0x30, 0x03, 0x09, 0x25, 0x3a, 
	0x03, 0x03, 0x28, 0x21, 0x0a, 0x25, 0x25, 0x25, 0xd1, 
	0x00, 0x05, 0x02, 0xd4, 0x25, 0x0a, 0x00, 0x1a, 0x02, 
	0x00, 0x1a, 0x03, 0x09, 0x25, 0x25, 0x00, 0x09, 0x03, 
	0xd4, 0x25, 0x25, 0xce, 0x00, 0x04, 0x02, 0x07, 0x25, 
	0x25, 0xd1, 0x02, 0x02, 0x02, 0xd1, 0x07, 0x00, 0x0e, 
	0x02, 0x01, 0x01, 0x00, 0x0d, 0x03, 0xd1, 0x25, 0x25, 
	0x31, 0x3a, 0x25, 0x25, 0x09, 0x00, 0x05, 0x03, 0x82, 
	0x25, 0xd4, 0x04, 0x02, 0x07, 0x25, 0x02, 0xba, 0x25, 
	0x25, 0x83, 0x00, 0x04, 0x02, 0x07, 0x25, 0x25, 0xba, 
	0x00, 0x17, 0x02, 0x00, 0x1b, 0x03, 0x25, 0x25, 0x30, 
	0x0a, 0x35, 0x03, 0x03, 0x09, 0x25, 0x82, 0x03, 0x03, 
	0x86, 0x25, 0x25, 0x08, 0x04, 0x25, 0x1f, 0x00, 0x05, 
	0x02, 0x06, 0x25, 0x83, 0x00, 0x1a, 0x02, 0x00, 0x1a, 
	0x03, 0x09, 0x25, 0x35, 0x00, 0x09, 0x03, 0x35, 0x25, 
	0x25, 0x25, 0x04, 0x02, 0x02, 0x02, 0x07, 0x25, 0x25, 
	0xd1, 0x02, 0x02, 0x02, 0xd1, 0x07, 0x00, 0x0e, 0x02, 
	0x01, 0x01, 0x00, 0x0e, 0x03, 0xd4, 0x25, 0x3a, 0x30, 
	0x25, 0x25, 0x09, 0x00, 0x05, 0x03, 0x0a, 0x25, 0x30, 
	0x02, 0x02, 0x07, 0x25, 0x02, 0xba, 0x25, 0x25, 0xd1, 
	0x00, 0x04, 0x02, 0x07, 0x25, 0x25, 0xba, 0x00, 0x17, 
	0x02, 0x00, 0x1b, 0x03, 0x25, 0x25, 0x25, 0x0a, 0x1a, 
	0x03, 0x03, 0x3a, 0x25, 0x09, 0x03, 0x1a, 0x0a, 0x25, 
	0x05, 0x02, 0x02, 0x25, 0x07, 0x00, 0x05, 0x02, 0x04, 
	0x0a, 0x07, 0x00, 0x1a, 0x02, 0x00, 0x1a, 0x03, 0x82, 
	0x25, 0x09, 0x03, 0x03, 0x1a, 0x00, 0x05, 0x03, 0x1a, 
	0x0a, 0xd4, 0x25, 0x25, 0xba, 0x02, 0x02, 0x02, 0xba, 
	0x25, 0x25, 0xd1, 0x02, 0x02, 0x02, 0xd1, 0x07, 0x00, 
	0x0e, 0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x1a, 0x09, 
	0x3a, 0x03, 0x3a, 0x25, 0x3a, 0x30, 0x25, 0x25, 0x09, 
	0x00, 0x04, 0x03, 0x30, 0x25, 0x25, 0x03, 0x02, 0x02, 
	0x83, 0x25, 0x02, 0xba, 0x25, 0x25, 0xd1, 0x00, 0x04, 
	0x02, 0x1f, 0x25, 0x25, 0xba, 0x00, 0x17, 0x02, 0x00, 
	0x1b, 0x03, 0x25, 0x25, 0xd4, 0x1a, 0x03, 0x03, 0x03, 
	0x3a, 0x25, 0x09, 0x03, 0x3a, 0x25, 0x09, 0x02, 0x02, 
	0x02, 0x25, 0x07, 0x00, 0x06, 0x02, 0xd4, 0x16, 0x00, 
	0x1a, 0x02, 0x00, 0x1a, 0x03, 0x3a, 0x25, 0x09, 0x03, 
	0x03, 0x25, 0x0a, 0x1a, 0x03, 0x03, 0x03, 0x87, 0x87, 
	0x3a, 0x25, 0x25, 0x07, 0x02, 0x02, 0x02, 0xba, 0x25, 
	0x25, 0xd1, 0x02, 0x02, 0x02, 0xce, 0x08, 0x00, 0x0e, 
	0x02, 0x01, 0x01, 0x00, 0x0a, 0x03, 0x30, 0x25, 0x09, 
	0x03, 0x3a, 0x25, 0x1a, 0x03, 0x25, 0x25, 0x0a, 0x03, 
	0x03, 0x1a, 0x3a, 0x30, 0x25, 0x25, 0x03, 0x02, 0x04, 
	0x0a, 0x25, 0x02, 0xba, 0x25, 0x25, 0xd1, 0x00, 0x04, 
	0x02, 0xd1, 0x25, 0x25, 0xba, 0x00, 0x17, 0x02, 0x00, 
	0x1b, 0x03, 0x25, 0x25, 0x30, 0x00, 0x04, 0x03, 0x3a, 
	0x25, 0x09, 0x03, 0x09, 0x25, 0x07, 0x02, 0x02, 0x16, 
	0x25, 0x07, 0x00, 0x05, 0x02, 0x04, 0x0a, 0x00, 0x1b, 
	0x02, 0x00, 0x1a, 0x03, 0x1a, 0x25, 0x0a, 0x03, 0x03, 
	0x25, 0x25, 0x30, 0x03, 0x03, 0x03, 0x0a, 0xbe, 0x1a, 
	0x25, 0x25, 0xd1, 0x02, 0x02, 0x02, 0x16, 0x25, 0x25, 
	0xd1, 0x02, 0x02, 0x02, 0x25, 0xd1, 0x00, 0x0e, 0x02, 
	0x01, 0x01, 0x00, 0x0a, 0x03, 0x30, 0x25, 0x09, 0x03, 
	0x87, 0x0a, 0x03, 0x03, 0x87, 0x25, 0x25, 0x1a, 0x03, 
	0x87, 0x30, 0x30, 0x25, 0x25, 0x30, 0x04, 0xce, 0x25, 
	0x25, 0x04, 0xba, 0x25, 0x25, 0xd1, 0x00, 0x04, 0x02, 
	0xd1, 0x25, 0x25, 0xba, 0x00, 0x17, 0x02, 0x00, 0x1b, 
	0x03, 0x25, 0x25, 0x30, 0x00, 0x04, 0x03, 0x3a, 0x25, 
	0x09, 0x03, 0x09, 0x25, 0x07, 0x02, 0x02, 0x07, 0x25, 
	0x07, 0x00, 0x05, 0x02, 0x07, 0x08, 0x00, 0x1b, 0x02, 
	0x00, 0x1b, 0x03, 0x35, 0x25, 0x1a, 0x1a, 0x25, 0x25, 
	0x1a, 0x03, 0x03, 0xbe, 0x25, 0x28, 0x03, 0xd4, 0x25, 
	0x25, 0x00, 0x04, 0x02, 0x25, 0x25, 0xd1, 0x02, 0x02, 
	0x02, 0x25, 0xd1, 0x00, 0x0e, 0x02, 0x01, 0x01, 0x00, 
	0x0a, 0x02, 0xba, 0x25, 0xd1, 0x02, 0xd4, 0x83, 0x02, 
	0x02, 0x04, 0x0a, 0x25, 0x08, 0x04, 0x0a, 0x02, 0x02, 
	0xd4, 0x00, 0x04, 0x25, 0xd4, 0x25, 0x3a, 0x30, 0x25, 
	0x25, 0x35, 0x00, 0x04, 0x03, 0x09, 0x25, 0x25, 0x28, 
	0x00, 0x17, 0x03, 0x00, 0x1b, 0x02, 0x25, 0x25, 0xba, 
	0x00, 0x04, 0x02, 0x07, 0x25, 0xd1, 0x02, 0xd1, 0x25, 
	0xd4, 0x03, 0x31, 0x25, 0x25, 0x87, 0x00, 0x05, 0x03, 
	0x09, 0x31, 0x00, 0x1b, 0x03, 0x00, 0x1b, 0x02, 0x07, 
	0x25, 0xba, 0x07, 0x25, 0xd4, 0x02, 0x02, 0x02, 0x08, 
	0xd1, 0x02, 0x02, 0x87, 0x25, 0x25, 0x30, 0x03, 0x03, 
	0x03, 0x25, 0x25, 0x09, 0x03, 0x03, 0x03, 0x25, 0x09, 
	0x00, 0x0e, 0x03, 0x01, 0x01, 0x00, 0x0b, 0x02, 0x25, 
	0x25, 0xce, 0x25, 0x23, 0x02, 0x02, 0x02, 0x16, 0x0a, 
	0x25, 0x08, 0x05, 0x02, 0x02, 0x16, 0xd4, 0x25, 0x09, 
	0x3a, 0x03, 0xd4, 0x3a, 0x30, 0x25, 0x25, 0x25, 0x00, 
	0x04, 0x03, 0x0a, 0x25, 0x25, 0x00, 0x18, 0x03, 0x00, 
	0x1b, 0x02, 0x25, 0x25, 0xba, 0x00, 0x04, 0x02, 0x06, 
	0x25, 0x08, 0x02, 0x06, 0x00, 0x05, 0x25, 0xd4, 0x0a, 
	0x00, 0x05, 0x03, 0x0a, 0x28, 0x00, 0x1b, 0x03, 0x00, 
	0x1b, 0x02, 0x04, 0x0a, 0xce, 0xce, 0x25, 0x23, 0x02, 
	0x02, 0x02, 0x0a, 0x07, 0x02, 0x02, 0xbe, 0x25, 0x25, 
	0x31, 0x03, 0x03, 0x03, 0x25, 0x25, 0x09, 0x03, 0x03, 
	0x1a, 0x25, 0x35, 0x00, 0x0e, 0x03, 0x01, 0x01, 0x00, 
	0x0b, 0x02, 0xd1, 0x25, 0x0a, 0x07, 0x00, 0x05, 0x02, 
	0x04, 0x07, 0x23, 0x00, 0x06, 0x02, 0x03, 0x03, 0x03, 
	0x28, 0x00, 0x09, 0x03, 0x3a, 0x3a, 0x3a, 0x00, 0x18, 
	0x03, 0x00, 0x1b, 0x02, 0x25, 0x83, 0x00, 0x05, 0x02, 
	0xba, 0x0a, 0x04, 0x02, 0x02, 0x1f, 0x25, 0x35, 0x87, 
	0x1a, 0x30, 0x0a, 0x00, 0x04, 0x03, 0x1a, 0xd4, 0x00, 
	0x1c, 0x03, 0x00, 0x1c, 0x02, 0x05, 0x25, 0x25, 0x83, 
	0x02, 0x02, 0x02, 0x05, 0x25, 0x16, 0x02, 0x02, 0x03, 
	0x25, 0xd4, 0x00, 0x04, 0x03, 0x25, 0x25, 0xbe, 0x03, 
	0x03, 0x30, 0x25, 0x25, 0x00, 0x0e, 0x03, 0x01, 0x01, 
	0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x1b, 0x02, 
	0x21, 0x00, 0x06, 0x02, 0xba, 0x23, 0x00, 0x04, 0x02, 
	0x00, 0x05, 0x03, 0x28, 0x00, 0x04, 0x03, 0x3a, 0x82, 
	0x00, 0x1c, 0x03, 0x00, 0x1d, 0x02, 0x05, 0x07, 0x04, 
	0x02, 0x02, 0x02, 0x04, 0x06, 0x02, 0x02, 0x02, 0x03, 
	0x09, 0x1a, 0x00, 0x04, 0x03, 0x35, 0x30, 0x03, 0x03, 
	0x03, 0x1a, 0x3a, 0x31, 0x00, 0x0e, 0x03, 0x01, 0x01, 
	0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x0a, 0x03, 0x09, 0xbe, 0x00, 0x1c, 0x03, 0x00, 
	0x28, 0x02, 0x03, 0x1a, 0x00, 0x05, 0x03, 0x28, 0x00, 
	0x15, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x0a, 0x03, 0x0a, 0x28, 
	0x00, 0x1c, 0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 
	0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x09, 0x03, 0x1a, 0xd4, 0x00, 0x1d, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 0x01, 
	0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x09, 0x03, 0x3a, 0x82, 0x00, 0x1d, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 
	0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x09, 
	0x03, 0x09, 0x1a, 0x00, 0x1d, 0x03, 0x00, 0x28, 0x02, 
	0x00, 0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 
	0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 0x09, 0x03, 0x82, 
	0x00, 0x1e, 0x03, 0x00, 0x28, 0x02, 0x00, 0x1d, 0x03, 
	0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 0x03, 0x00, 
	0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 0x02, 0x00, 
	0x1d, 0x03, 0x01, 0x01, 0x00, 0x1d, 0x02, 0x00, 0x28, 
	0x03, 0x00, 0x28, 0x02, 0x00, 0x28, 0x03, 0x00, 0x28, 
	0x02, 0x00, 0x1d, 0x03, 0x00, 0xdd, 0x01, 0x00, 0x00
 
};

unsigned char item_bomb_colors[] = { 
	0xff, 0xff, 0xff, 
	0x00, 0x00, 0x00, 
	0x62, 0x62, 0x74, 
	0x56, 0x61, 0xc1, 
	0x70, 0x72, 0x94, 
	0x57, 0x56, 0x5c, 
	0x7b, 0x7f, 0xac, 
	0x43, 0x46, 0x68, 
	0x28, 0x41, 0xfe, 
	0x49, 0x51, 0x92, 
	0x40, 0x41, 0x4a, 
	0x4e, 0x59, 0xb2, 
	0x3d, 0x3c, 0x3d, 
	0x42, 0x41, 0x42, 
	0x48, 0x47, 0x48, 
	0x41, 0x47, 0x7e, 
	0x6c, 0x70, 0x9c, 
	0x50, 0x4f, 0x50, 
	0x16, 0x24, 0x90, 
	0x50, 0x5b, 0xb0, 
	0x60, 0x61, 0x71, 
	0x71, 0x74, 0x97, 
	0x56, 0x57, 0x67, 
	0x26, 0x3e, 0xf6, 
	0x14, 0x20, 0x7f, 
	0x3a, 0x3f, 0x6a, 
	0x42, 0x45, 0x64, 
	0x4a, 0x52, 0x96, 
	0x41, 0x43, 0x52, 
	0x25, 0x3c, 0xee, 
	0x67, 0x68, 0x80, 
	0x6a, 0x6c, 0x88, 
	0x3c, 0x3b, 0x3c, 
	0x49, 0x48, 0x49, 
	0x5b, 0x5b, 0x65, 
	0x6b, 0x6f, 0x98, 
	0x4e, 0x4d, 0x4e, 
	0x45, 0x4a, 0x78, 
	0x47, 0x4d, 0x82, 
	0x40, 0x41, 0x54, 
	0x4e, 0x59, 0xa8, 
	0x41, 0x40, 0x41, 
	0x44, 0x43, 0x44, 
	0x64, 0x65, 0x7a, 
	0x6d, 0x6f, 0x8e, 
	0x5f, 0x5f, 0x6e, 
	0x72, 0x75, 0x9a, 
	0x38, 0x37, 0x38, 
	0x4d, 0x4c, 0x4d, 
	0x44, 0x48, 0x70, 
	0x48, 0x4f, 0x8a, 
	0x41, 0x44, 0x60, 
	0x4b, 0x53, 0x9a, 
	0x3f, 0x3e, 0x3f, 
	0x46, 0x45, 0x46, 
	0x3b, 0x3a, 0x3b, 
	0x4a, 0x49, 0x4a, 
	0x6e, 0x70, 0x8f, 
	0x69, 0x6b, 0x85, 
	0x59, 0x59, 0x62, 
	0x78, 0x7c, 0xa6, 
	0x54, 0x53, 0x56, 
	0x7d, 0x82, 0xb2, 
	0x4a, 0x52, 0x8e, 
	0x48, 0x4f, 0x80, 
	0x3f, 0x40, 0x50, 
	0x4d, 0x57, 0xaa, 
	0x3e, 0x3e, 0x48, 
	0x3c, 0x3c, 0x40, 
	0x50, 0x5b, 0xba, 
	0x6f, 0x72, 0x92, 
	0x66, 0x67, 0x7a, 
	0x67, 0x69, 0x81, 
	0x6c, 0x6e, 0x8b, 
	0x74, 0x77, 0x9d, 
	0x37, 0x36, 0x37, 
	0x35, 0x34, 0x35, 
	0x32, 0x32, 0x32, 
	0x52, 0x51, 0x52, 
	0x4b, 0x53, 0x92, 
	0x45, 0x4a, 0x6c, 
	0x47, 0x4d, 0x7a, 
	0x49, 0x51, 0x88, 
	0x44, 0x48, 0x66, 
	0x4b, 0x54, 0x9e, 
	0x70, 0x73, 0x96, 
	0x66, 0x67, 0x78, 
	0x67, 0x68, 0x7d, 
	0x6a, 0x6c, 0x8e, 
	0x4b, 0x4a, 0x4b, 
	0x4c, 0x54, 0x96, 
	0x49, 0x4c, 0x6c, 
	0x46, 0x4b, 0x72, 
	0x4b, 0x54, 0x94, 
	0x50, 0x58, 0x9a, 
	0x35, 0x37, 0x4b, 
	0x38, 0x3c, 0x5c, 
	0x4f, 0x5a, 0xac, 
	0x5d, 0x5e, 0x6b, 
	0x64, 0x63, 0x6b, 
	0x62, 0x6d, 0xc8, 
	0x52, 0x5b, 0x9c, 
	0x4b, 0x4f, 0x6e, 
	0x45, 0x49, 0x6a, 
	0x41, 0x43, 0x5c, 
	0x40, 0x42, 0x4e, 
	0x26, 0x3d, 0xf2, 
	0x75, 0x78, 0x9f, 
	0x35, 0x45, 0xc5, 
	0x3d, 0x4b, 0xba, 
	0x65, 0x66, 0x7c, 
	0x63, 0x64, 0x77, 
	0x69, 0x6c, 0x8c, 
	0x3a, 0x39, 0x3a, 
	0x33, 0x33, 0x39, 
	0x1f, 0x32, 0xc5, 
	0x65, 0x70, 0xc9, 
	0x4d, 0x57, 0xa2, 
	0x46, 0x4c, 0x74, 
	0x45, 0x4a, 0x6e, 
	0x4b, 0x53, 0x90, 
	0x16, 0x23, 0x8c, 
	0x50, 0x5c, 0xb4, 
	0x52, 0x5b, 0xa6, 
	0x4b, 0x4f, 0x78, 
	0x69, 0x6b, 0x8a, 
	0x47, 0x46, 0x47, 
	0x63, 0x62, 0x67, 
	0x7c, 0x80, 0xaf, 
	0x4a, 0x52, 0x8c, 
	0x3f, 0x40, 0x46, 
	0x4f, 0x5a, 0xb6, 
	0x33, 0x33, 0x33, 
	0x51, 0x50, 0x51, 
	0x54, 0x5e, 0xa8, 
	0x4d, 0x52, 0x7a, 
	0x77, 0x7b, 0xa5, 
	0x33, 0x44, 0xc8, 
	0x3b, 0x4a, 0xbd, 
	0x68, 0x69, 0x82, 
	0x53, 0x5d, 0xae, 
	0x4c, 0x51, 0x80, 
	0x7a, 0x7e, 0xab, 
	0x31, 0x43, 0xca, 
	0x3a, 0x49, 0xbf, 
	0x50, 0x5b, 0xb2, 
	0x49, 0x50, 0x84, 
	0x54, 0x5f, 0xb6, 
	0x4d, 0x53, 0x88, 
	0x56, 0x62, 0xb8, 
	0x4f, 0x56, 0x8a, 
	0x7b, 0x7f, 0xae, 
	0x30, 0x42, 0xcc, 
	0x38, 0x48, 0xc1, 
	0x51, 0x5c, 0xb6, 
	0x55, 0x60, 0xba, 
	0x4e, 0x54, 0x8c, 
	0x57, 0x63, 0xbc, 
	0x50, 0x57, 0x8e, 
	0x7d, 0x81, 0xb1, 
	0x2f, 0x41, 0xcd, 
	0x87, 0x87, 0x96, 
	0xc1, 0xc0, 0xc1, 
	0x53, 0x5c, 0xaa, 
	0x37, 0x47, 0xc2, 
	0x51, 0x5d, 0xba, 
	0xb7, 0xb8, 0xc6, 
	0xff, 0xff, 0xff, 
	0x6f, 0x78, 0xc6, 
	0x56, 0x61, 0xbe, 
	0x42, 0x4e, 0xb4, 
	0x32, 0x43, 0xc9, 
	0x4e, 0x55, 0x90, 
	0x89, 0x89, 0x95, 
	0x50, 0x5a, 0xab, 
	0xb7, 0xb8, 0xc2, 
	0x67, 0x72, 0xc2, 
	0xb5, 0xb5, 0xc0, 
	0x65, 0x6f, 0xc0, 
	0x42, 0x4f, 0xb3, 
	0x52, 0x50, 0x52, 
	0x46, 0x51, 0xab, 
	0x4b, 0x51, 0x89, 
	0x82, 0x83, 0x98, 
	0x57, 0x60, 0xa8, 
	0xb1, 0xb2, 0xc6, 
	0x75, 0x7e, 0xc6, 
	0x51, 0x4f, 0x51, 
	0x46, 0x51, 0xa8, 
	0x40, 0x4d, 0xb6, 
	0x33, 0x44, 0xc7, 
	0x4b, 0x51, 0x86, 
	0x45, 0x44, 0x45, 
	0x50, 0x4e, 0x50, 
	0x47, 0x51, 0xa2, 
	0x48, 0x51, 0x9c, 
	0x4d, 0x51, 0x7a

};
unsigned char item_bomb[] = { 
	0x00, 0xa9, 0x01, 0x02, 0x03, 0x04, 0x00, 0x0d, 0x01, 
	0x05, 0x03, 0x06, 0x00, 0x2d, 0x01, 0x07, 0x08, 0x09, 
	0x00, 0x0d, 0x01, 0x0a, 0x08, 0x0b, 0x00, 0x2d, 0x01, 
	0x0c, 0x0d, 0x0e, 0x00, 0x0b, 0x01, 0x0f, 0x03, 0x10, 
	0x0d, 0x11, 0x00, 0x3b, 0x01, 0x12, 0x08, 0x13, 0x00, 
	0x31, 0x01, 0x14, 0x03, 0x15, 0x00, 0x07, 0x01, 0x16, 
	0x08, 0x17, 0x18, 0x19, 0x00, 0x31, 0x01, 0x1a, 0x08, 
	0x1b, 0x00, 0x07, 0x01, 0x1c, 0x08, 0x1d, 0x00, 0x29, 
	0x01, 0x1e, 0x03, 0x1f, 0x00, 0x07, 0x01, 0x20, 0x0d, 
	0x21, 0x00, 0x05, 0x01, 0x22, 0x03, 0x23, 0x0d, 0x24, 
	0x00, 0x29, 0x01, 0x25, 0x08, 0x26, 0x00, 0x0f, 0x01, 
	0x27, 0x08, 0x28, 0x00, 0x2b, 0x01, 0x29, 0x0d, 0x2a, 
	0x01, 0x2b, 0x03, 0x2c, 0x00, 0x05, 0x01, 0x2d, 0x03, 
	0x2e, 0x01, 0x01, 0x01, 0x2f, 0x0d, 0x30, 0x00, 0x2f, 
	0x01, 0x31, 0x08, 0x32, 0x00, 0x05, 0x01, 0x33, 0x08, 
	0x34, 0x00, 0x35, 0x01, 0x35, 0x0d, 0x36, 0x01, 0x02, 
	0x03, 0x04, 0x01, 0x37, 0x0d, 0x38, 0x00, 0x39, 0x01, 
	0x07, 0x08, 0x09, 0x00, 0x2b, 0x01, 0x39, 0x00, 0x09, 
	0x03, 0x3a, 0x00, 0x07, 0x01, 0x0c, 0x0d, 0x0e, 0x00, 
	0x09, 0x01, 0x3b, 0x03, 0x3c, 0x01, 0x05, 0x03, 0x06, 
	0x01, 0x3d, 0x03, 0x3e, 0x00, 0x17, 0x01, 0x3f, 0x00, 
	0x09, 0x08, 0x40, 0x00, 0x13, 0x01, 0x41, 0x08, 0x42, 
	0x01, 0x43, 0x08, 0x0b, 0x01, 0x44, 0x08, 0x45, 0x00, 
	0x15, 0x01, 0x46, 0x03, 0x47, 0x00, 0x09, 0x0d, 0x48, 
	0x03, 0x03, 0x03, 0x49, 0x00, 0x05, 0x01, 0x14, 0x00, 
	0x05, 0x03, 0x4a, 0x01, 0x01, 0x01, 0x4b, 0x0d, 0x24, 
	0x01, 0x4c, 0x0d, 0x11, 0x01, 0x4d, 0x0d, 0x4e, 0x00, 
	0x15, 0x01, 0x4f, 0x08, 0x50, 0x00, 0x09, 0x01, 0x51, 
	0x08, 0x08, 0x08, 0x52, 0x00, 0x05, 0x01, 0x53, 0x00, 
	0x05, 0x08, 0x54, 0x00, 0x21, 0x01, 0x55, 0x03, 0x56, 
	0x0d, 0x0c, 0x00, 0x09, 0x01, 0x29, 0x0d, 0x0d, 0x0d, 
	0x57, 0x00, 0x05, 0x03, 0x58, 0x00, 0x05, 0x0d, 0x59, 
	0x00, 0x21, 0x01, 0x5a, 0x08, 0x5b, 0x00, 0x0f, 0x01, 
	0x5c, 0x00, 0x05, 0x08, 0x5d, 0x00, 0x27, 0x01, 0x5e, 
	0x08, 0x5b, 0x00, 0x0f, 0x01, 0x5f, 0x00, 0x05, 0x18, 
	0x60, 0x00, 0x09, 0x01, 0x3b, 0x03, 0x3c, 0x00, 0x1b, 
	0x01, 0x5e, 0x08, 0x5b, 0x00, 0x1f, 0x01, 0x41, 0x08, 
	0x61, 0x00, 0x1b, 0x01, 0x5e, 0x08, 0x5b, 0x00, 0x13, 
	0x01, 0x02, 0x03, 0x04, 0x01, 0x01, 0x01, 0x62, 0x03, 
	0x4a, 0x01, 0x01, 0x01, 0x4b, 0x0d, 0x63, 0x03, 0x64, 
	0x00, 0x19, 0x01, 0x65, 0x08, 0x66, 0x00, 0x13, 0x01, 
	0x67, 0x08, 0x09, 0x01, 0x01, 0x01, 0x68, 0x08, 0x54, 
	0x00, 0x05, 0x01, 0x69, 0x08, 0x6a, 0x00, 0x13, 0x01, 
	0x6b, 0x00, 0x05, 0x03, 0x6c, 0x08, 0x6d, 0x00, 0x05, 
	0x03, 0x6e, 0x00, 0x0b, 0x01, 0x6f, 0x03, 0x70, 0x0d, 
	0x0e, 0x01, 0x01, 0x01, 0x71, 0x0d, 0x59, 0x00, 0x05, 
	0x01, 0x72, 0x18, 0x73, 0x08, 0x74, 0x00, 0x11, 0x01, 
	0x75, 0x00, 0x0d, 0x08, 0x76, 0x00, 0x0b, 0x01, 0x77, 
	0x08, 0x78, 0x00, 0x0f, 0x01, 0x79, 0x08, 0x7a, 0x00, 
	0x11, 0x01, 0x7b, 0x00, 0x0d, 0x08, 0x7c, 0x00, 0x09, 
	0x01, 0x2b, 0x03, 0x7d, 0x0d, 0x7e, 0x00, 0x05, 0x01, 
	0x62, 0x03, 0x4a, 0x00, 0x07, 0x01, 0x4c, 0x0d, 0x7f, 
	0x03, 0x80, 0x00, 0x0f, 0x01, 0x7b, 0x00, 0x0d, 0x08, 
	0x7c, 0x00, 0x09, 0x01, 0x31, 0x08, 0x81, 0x00, 0x07, 
	0x01, 0x68, 0x08, 0x54, 0x00, 0x09, 0x01, 0x82, 0x08, 
	0x83, 0x00, 0x0f, 0x01, 0x7b, 0x00, 0x0d, 0x08, 0x7c, 
	0x00, 0x09, 0x01, 0x35, 0x0d, 0x36, 0x00, 0x07, 0x01, 
	0x71, 0x0d, 0x59, 0x00, 0x09, 0x01, 0x84, 0x0d, 0x85, 
	0x00, 0x0f, 0x01, 0x86, 0x00, 0x0d, 0x08, 0x87, 0x00, 
	0x2d, 0x01, 0x88, 0x03, 0x03, 0x03, 0x89, 0x00, 0x0d, 
	0x08, 0x8a, 0x03, 0x03, 0x03, 0x8b, 0x00, 0x0f, 0x01, 
	0x62, 0x03, 0x4a, 0x00, 0x17, 0x01, 0x8c, 0x00, 0x15, 
	0x08, 0x8d, 0x00, 0x0f, 0x01, 0x68, 0x08, 0x54, 0x00, 
	0x13, 0x01, 0x8e, 0x03, 0x03, 0x03, 0x8f, 0x00, 0x15, 
	0x08, 0x90, 0x03, 0x03, 0x03, 0x1f, 0x00, 0x0b, 0x01, 
	0x71, 0x0d, 0x59, 0x00, 0x13, 0x01, 0x91, 0x00, 0x1d, 
	0x08, 0x92, 0x00, 0x21, 0x01, 0x93, 0x00, 0x1d, 0x08, 
	0x94, 0x00, 0x21, 0x01, 0x95, 0x00, 0x1d, 0x08, 0x96, 
	0x00, 0x1f, 0x01, 0x97, 0x03, 0x98, 0x00, 0x1d, 0x08, 
	0x99, 0x03, 0x49, 0x00, 0x1d, 0x01, 0x9a, 0x00, 0x21, 
	0x08, 0x52, 0x00, 0x1d, 0x01, 0x9b, 0x00, 0x21, 0x08, 
	0x9c, 0x00, 0x1d, 0x01, 0x9d, 0x00, 0x21, 0x08, 0x9e, 
	0x00, 0x1b, 0x01, 0x9f, 0x03, 0xa0, 0x00, 0x05, 0x08, 
	0xa1, 0xa2, 0xa3, 0x00, 0x19, 0x08, 0xa4, 0x03, 0x2c, 
	0x00, 0x19, 0x01, 0xa5, 0x00, 0x07, 0x08, 0xa6, 0xa7, 
	0xa8, 0x00, 0x1b, 0x08, 0x81, 0x00, 0x19, 0x01, 0xa9, 
	0x00, 0x07, 0x08, 0xaa, 0x03, 0xab, 0x00, 0x1b, 0x08, 
	0xac, 0x00, 0x19, 0x01, 0xa9, 0x00, 0x25, 0x08, 0xac, 
	0x00, 0x19, 0x01, 0xa9, 0x00, 0x05, 0x08, 0xad, 0xa2, 
	0xae, 0x00, 0x1d, 0x08, 0xac, 0x00, 0x19, 0x01, 0xa9, 
	0x00, 0x05, 0x08, 0xaf, 0xa7, 0xb0, 0x00, 0x1d, 0x08, 
	0xac, 0x00, 0x19, 0x01, 0xa9, 0x00, 0x05, 0x08, 0xb1, 
	0xa7, 0xb2, 0x00, 0x1d, 0x08, 0xac, 0x00, 0x19, 0x01, 
	0xa9, 0x00, 0x05, 0x08, 0xb1, 0xa7, 0xb2, 0x00, 0x1d, 
	0x08, 0xac, 0x00, 0x19, 0x01, 0xa9, 0x00, 0x05, 0x08, 
	0xb1, 0xa7, 0xb2, 0x00, 0x1d, 0x08, 0xac, 0x00, 0x19, 
	0x01, 0xa9, 0x00, 0x05, 0x08, 0xaf, 0xa7, 0xb0, 0x00, 
	0x1d, 0x08, 0xac, 0x00, 0x19, 0x01, 0xa9, 0x00, 0x05, 
	0x08, 0xb3, 0x03, 0x8f, 0x00, 0x1d, 0x08, 0xac, 0x00, 
	0x19, 0x01, 0xa9, 0x00, 0x25, 0x08, 0xac, 0x00, 0x19, 
	0x01, 0xa9, 0x00, 0x07, 0x08, 0xa1, 0xa2, 0xa3, 0x00, 
	0x1b, 0x08, 0xac, 0x00, 0x19, 0x01, 0xa5, 0x00, 0x07, 
	0x08, 0xa6, 0xa7, 0xa8, 0x00, 0x1b, 0x08, 0x81, 0x00, 
	0x19, 0x01, 0xb4, 0x0d, 0xb5, 0x00, 0x05, 0x08, 0xaa, 
	0x03, 0xab, 0x00, 0x19, 0x08, 0xb6, 0x0d, 0x36, 0x00, 
	0x1b, 0x01, 0x9d, 0x00, 0x21, 0x08, 0x9e, 0x00, 0x1d, 
	0x01, 0x9b, 0x00, 0x09, 0x08, 0xb7, 0xa2, 0xb8, 0x00, 
	0x15, 0x08, 0x9c, 0x00, 0x1d, 0x01, 0x9a, 0x00, 0x09, 
	0x08, 0xb9, 0xa7, 0xba, 0x00, 0x15, 0x08, 0x52, 0x00, 
	0x1d, 0x01, 0xbb, 0x0d, 0xbc, 0x00, 0x07, 0x08, 0xbd, 
	0x03, 0xbe, 0x00, 0x13, 0x08, 0xbf, 0x0d, 0xc0, 0x00, 
	0x1f, 0x01, 0x95, 0x00, 0x1d, 0x08, 0x96, 0x00, 0x21, 
	0x01, 0x93, 0x00, 0x1d, 0x08, 0x94, 0x00, 0x21, 0x01, 
	0x91, 0x00, 0x1d, 0x08, 0x92, 0x00, 0x21, 0x01, 0xc1, 
	0x0d, 0x0d, 0x0d, 0xc2, 0x00, 0x15, 0x08, 0x8d, 0x0d, 
	0x0d, 0x0d, 0x2a, 0x00, 0x25, 0x01, 0x8c, 0x00, 0x15, 
	0x08, 0x8d, 0x00, 0x29, 0x01, 0x30, 0x0d, 0x0d, 0x0d, 
	0xc3, 0x00, 0x0d, 0x08, 0xc4, 0x00, 0x04, 0x0d, 0x00, 
	0x2d, 0x01, 0x7b, 0x00, 0x0d, 0x08, 0x7c, 0x00, 0x31, 
	0x01, 0x59, 0x00, 0x0d, 0x0d, 0x35, 0x00, 0x24, 0x01, 
	0x00, 0x00 
};

#endif