#include <PalmOS.h>
#include "globals.h"

static const Int32	ENV_BITS	= 10;
static const Int32	ENV_LEN		= 1<<ENV_BITS;
static const float	ENV_STEP	= 128.f/ENV_LEN;

static void addFmopl_slot_array() {
	Int32 slot_array[32] =
	{
		 0, 2, 4, 1, 3, 5,-1,-1,
		 6, 8,10, 7, 9,11,-1,-1,
		12,14,16,13,15,17,-1,-1,
		-1,-1,-1,-1,-1,-1,-1,-1
	};
	
	writeRecord(slot_array, sizeof(slot_array), GBVARS_SLOTARRAY_INDEX , GBVARS_SCUMM);
}

static void addFmopl_ksl_tab() {
	#define DV (0.1875/2.0)
	#define KSL(x) (UInt32)(x/DV)
	UInt32 ksl_tab[8*16] =
	{
		/* OCT 0 */
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		/* OCT 1 */
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(0.750), KSL(1.125), KSL(1.500),
		 KSL(1.875), KSL(2.250), KSL(2.625), KSL(3.000),
		/* OCT 2 */
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(0.000),
		 KSL(0.000), KSL(1.125), KSL(1.875), KSL(2.625),
		 KSL(3.000), KSL(3.750), KSL(4.125), KSL(4.500),
		 KSL(4.875), KSL(5.250), KSL(5.625), KSL(6.000),
		/* OCT 3 */
		 KSL(0.000), KSL(0.000), KSL(0.000), KSL(1.875),
		 KSL(3.000), KSL(4.125), KSL(4.875), KSL(5.625),
		 KSL(6.000), KSL(6.750), KSL(7.125), KSL(7.500),
		 KSL(7.875), KSL(8.250), KSL(8.625), KSL(9.000),
		/* OCT 4 */
		 KSL(0.000), KSL(0.000), KSL(3.000), KSL(4.875),
		 KSL(6.000), KSL(7.125), KSL(7.875), KSL(8.625),
		 KSL(9.000), KSL(9.750),KSL(10.125),KSL(10.500),
		KSL(10.875),KSL(11.250),KSL(11.625),KSL(12.000),
		/* OCT 5 */
		 KSL(0.000), KSL(3.000), KSL(6.000), KSL(7.875),
		 KSL(9.000),KSL(10.125),KSL(10.875),KSL(11.625),
		KSL(12.000),KSL(12.750),KSL(13.125),KSL(13.500),
		KSL(13.875),KSL(14.250),KSL(14.625),KSL(15.000),
		/* OCT 6 */
		 KSL(0.000), KSL(6.000), KSL(9.000),KSL(10.875),
		KSL(12.000),KSL(13.125),KSL(13.875),KSL(14.625),
		KSL(15.000),KSL(15.750),KSL(16.125),KSL(16.500),
		KSL(16.875),KSL(17.250),KSL(17.625),KSL(18.000),
		/* OCT 7 */
		 KSL(0.000), KSL(9.000),KSL(12.000),KSL(13.875),
		KSL(15.000),KSL(16.125),KSL(16.875),KSL(17.625),
		KSL(18.000),KSL(18.750),KSL(19.125),KSL(19.500),
		KSL(19.875),KSL(20.250),KSL(20.625),KSL(21.000)
	};
	#undef DV
	#undef KSL
	
	writeRecord(ksl_tab, sizeof(ksl_tab), GBVARS_KSLTAB_INDEX , GBVARS_SCUMM);
}

static void addFmopl_sl_tab() {
	#define SC(db) (UInt32) ( db * (2.0/ENV_STEP) )

	UInt32 sl_tab[16]={
	 SC( 0),SC( 1),SC( 2),SC(3 ),SC(4 ),SC(5 ),SC(6 ),SC( 7),
	 SC( 8),SC( 9),SC(10),SC(11),SC(12),SC(13),SC(14),SC(31)
	};
	#undef SC

	writeRecord(sl_tab, sizeof(sl_tab), GBVARS_SLTAB_INDEX , GBVARS_SCUMM);
}

static void addFmopl_eg_inc() {
	#define RATE_STEPS (8)
	unsigned char eg_inc[15*RATE_STEPS]={

	/*cycle:0 1  2 3  4 5  6 7*/

	/* 0 */ 0,1, 0,1, 0,1, 0,1, /* rates 00..12 0 (increment by 0 or 1) */
	/* 1 */ 0,1, 0,1, 1,1, 0,1, /* rates 00..12 1 */
	/* 2 */ 0,1, 1,1, 0,1, 1,1, /* rates 00..12 2 */
	/* 3 */ 0,1, 1,1, 1,1, 1,1, /* rates 00..12 3 */

	/* 4 */ 1,1, 1,1, 1,1, 1,1, /* rate 13 0 (increment by 1) */
	/* 5 */ 1,1, 1,2, 1,1, 1,2, /* rate 13 1 */
	/* 6 */ 1,2, 1,2, 1,2, 1,2, /* rate 13 2 */
	/* 7 */ 1,2, 2,2, 1,2, 2,2, /* rate 13 3 */

	/* 8 */ 2,2, 2,2, 2,2, 2,2, /* rate 14 0 (increment by 2) */
	/* 9 */ 2,2, 2,4, 2,2, 2,4, /* rate 14 1 */
	/*10 */ 2,4, 2,4, 2,4, 2,4, /* rate 14 2 */
	/*11 */ 2,4, 4,4, 2,4, 4,4, /* rate 14 3 */

	/*12 */ 4,4, 4,4, 4,4, 4,4, /* rates 15 0, 15 1, 15 2, 15 3 (increment by 4) */
	/*13 */ 8,8, 8,8, 8,8, 8,8, /* rates 15 2, 15 3 for attack */
	/*14 */ 0,0, 0,0, 0,0, 0,0, /* infinity rates for attack and decay(s) */
	};
	writeRecord(eg_inc, sizeof(eg_inc), GBVARS_EGINC_INDEX , GBVARS_SCUMM);
}

static void addFmopl_eg_rate_select() {
	#define O(a) (a*RATE_STEPS)

	/*note that there is no O(13) in this table - it's directly in the code */
	unsigned char eg_rate_select[16+64+16]={	/* Envelope Generator rates (16 + 64 rates + 16 RKS) */
	/* 16 dummy (infinite time) rates */
	O(14),O(14),O(14),O(14),O(14),O(14),O(14),O(14),
	O(14),O(14),O(14),O(14),O(14),O(14),O(14),O(14),

	/* rates 00-12 */
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),
	O( 0),O( 1),O( 2),O( 3),

	/* rate 13 */
	O( 4),O( 5),O( 6),O( 7),

	/* rate 14 */
	O( 8),O( 9),O(10),O(11),

	/* rate 15 */
	O(12),O(12),O(12),O(12),

	/* 16 dummy rates (same as 15 3) */
	O(12),O(12),O(12),O(12),O(12),O(12),O(12),O(12),
	O(12),O(12),O(12),O(12),O(12),O(12),O(12),O(12),

	};
	#undef O

	writeRecord(eg_rate_select, sizeof(eg_rate_select), GBVARS_EGRATESELECT_INDEX , GBVARS_SCUMM);
}
static void addFmopl_eg_rate_shift() {
	#define O(a) (a*1)
	unsigned char eg_rate_shift[16+64+16]={	/* Envelope Generator counter shifts (16 + 64 rates + 16 RKS) */
	/* 16 infinite time rates */
	O(0),O(0),O(0),O(0),O(0),O(0),O(0),O(0),
	O(0),O(0),O(0),O(0),O(0),O(0),O(0),O(0),

	/* rates 00-12 */
	O(12),O(12),O(12),O(12),
	O(11),O(11),O(11),O(11),
	O(10),O(10),O(10),O(10),
	O( 9),O( 9),O( 9),O( 9),
	O( 8),O( 8),O( 8),O( 8),
	O( 7),O( 7),O( 7),O( 7),
	O( 6),O( 6),O( 6),O( 6),
	O( 5),O( 5),O( 5),O( 5),
	O( 4),O( 4),O( 4),O( 4),
	O( 3),O( 3),O( 3),O( 3),
	O( 2),O( 2),O( 2),O( 2),
	O( 1),O( 1),O( 1),O( 1),
	O( 0),O( 0),O( 0),O( 0),

	/* rate 13 */
	O( 0),O( 0),O( 0),O( 0),

	/* rate 14 */
	O( 0),O( 0),O( 0),O( 0),

	/* rate 15 */
	O( 0),O( 0),O( 0),O( 0),

	/* 16 dummy rates (same as 15 3) */
	O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),
	O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),O( 0),

	};
	#undef O

	writeRecord(eg_rate_shift, sizeof(eg_rate_shift), GBVARS_EGRATESHIFT_INDEX , GBVARS_SCUMM);
}

static void addFmopl_mul_tab() {
	#define ML(x) (UInt8)(x*2)
	UInt8 mul_tab[16]= {
	/* 1/2, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,10,12,12,15,15 */
	   ML(0.50), ML(1.00), ML(2.00), ML(3.00), ML(4.00), ML(5.00), ML(6.00), ML(7.00),
	   ML(8.00), ML(9.00),ML(10.00),ML(10.00),ML(12.00),ML(12.00),ML(15.00),ML(15.00)
	};
	#undef ML

	writeRecord(mul_tab, sizeof(mul_tab), GBVARS_MULTAB_INDEX , GBVARS_SCUMM);
}

static void addFmopl_lfo_am_table() {
	#define LFO_AM_TAB_ELEMENTS 210
	UInt8 lfo_am_table[LFO_AM_TAB_ELEMENTS] = {
	0,0,0,0,0,0,0,
	1,1,1,1,
	2,2,2,2,
	3,3,3,3,
	4,4,4,4,
	5,5,5,5,
	6,6,6,6,
	7,7,7,7,
	8,8,8,8,
	9,9,9,9,
	10,10,10,10,
	11,11,11,11,
	12,12,12,12,
	13,13,13,13,
	14,14,14,14,
	15,15,15,15,
	16,16,16,16,
	17,17,17,17,
	18,18,18,18,
	19,19,19,19,
	20,20,20,20,
	21,21,21,21,
	22,22,22,22,
	23,23,23,23,
	24,24,24,24,
	25,25,25,25,
	26,26,26,
	25,25,25,25,
	24,24,24,24,
	23,23,23,23,
	22,22,22,22,
	21,21,21,21,
	20,20,20,20,
	19,19,19,19,
	18,18,18,18,
	17,17,17,17,
	16,16,16,16,
	15,15,15,15,
	14,14,14,14,
	13,13,13,13,
	12,12,12,12,
	11,11,11,11,
	10,10,10,10,
	9,9,9,9,
	8,8,8,8,
	7,7,7,7,
	6,6,6,6,
	5,5,5,5,
	4,4,4,4,
	3,3,3,3,
	2,2,2,2,
	1,1,1,1
	};
	writeRecord(lfo_am_table, sizeof(lfo_am_table), GBVARS_LFOAMTABLE_INDEX , GBVARS_SCUMM);
}



static void addFmopl_lfo_pm_table() {
	Int8 lfo_pm_table[8*8*2] = {

	/* FNUM2/FNUM = 00 0xxxxxxx (0x0000) */
	0, 0, 0, 0, 0, 0, 0, 0,	/*LFO PM depth = 0*/
	0, 0, 0, 0, 0, 0, 0, 0,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 00 1xxxxxxx (0x0080) */
	0, 0, 0, 0, 0, 0, 0, 0,	/*LFO PM depth = 0*/
	1, 0, 0, 0,-1, 0, 0, 0,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 01 0xxxxxxx (0x0100) */
	1, 0, 0, 0,-1, 0, 0, 0,	/*LFO PM depth = 0*/
	2, 1, 0,-1,-2,-1, 0, 1,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 01 1xxxxxxx (0x0180) */
	1, 0, 0, 0,-1, 0, 0, 0,	/*LFO PM depth = 0*/
	3, 1, 0,-1,-3,-1, 0, 1,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 10 0xxxxxxx (0x0200) */
	2, 1, 0,-1,-2,-1, 0, 1,	/*LFO PM depth = 0*/
	4, 2, 0,-2,-4,-2, 0, 2,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 10 1xxxxxxx (0x0280) */
	2, 1, 0,-1,-2,-1, 0, 1,	/*LFO PM depth = 0*/
	5, 2, 0,-2,-5,-2, 0, 2,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 11 0xxxxxxx (0x0300) */
	3, 1, 0,-1,-3,-1, 0, 1,	/*LFO PM depth = 0*/
	6, 3, 0,-3,-6,-3, 0, 3,	/*LFO PM depth = 1*/

	/* FNUM2/FNUM = 11 1xxxxxxx (0x0380) */
	3, 1, 0,-1,-3,-1, 0, 1,	/*LFO PM depth = 0*/
	7, 3, 0,-3,-7,-3, 0, 3	/*LFO PM depth = 1*/
	};
	writeRecord(lfo_pm_table, sizeof(lfo_pm_table), GBVARS_LFOPMTABLE_INDEX , GBVARS_SCUMM);
}
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

void addFmpol() {
	addFmopl_slot_array();
	addFmopl_ksl_tab();
	addFmopl_sl_tab();
	addFmopl_eg_inc();
	addFmopl_eg_rate_select();
	addFmopl_eg_rate_shift();
	addFmopl_mul_tab();
	addFmopl_lfo_am_table();
}