#include <PalmOS.h>
#include "globals.h"
// $Header: /cvsroot/scummvm/scummvm/simon/simon.cpp,v 1.172 2003/04/02 05:27:59 kirben Exp $
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
typedef struct  {
	UInt32 VGA_DELAY_BASE;
	UInt32 TABLE_INDEX_BASE;
	UInt32 TEXT_INDEX_BASE;
	UInt32 NUM_VIDEO_OP_CODES;
	UInt32 VGA_MEM_SIZE;
	UInt32 TABLES_MEM_SIZE;
	UInt32 MUSIC_INDEX_BASE;
	UInt32 SOUND_INDEX_BASE;
/*
	const char *gme_filename;
	const char *wav_filename;
	const char *voc_filename;
	const char *mp3_filename;
	const char *voc_effects_filename;
	const char *mp3_effects_filename;
 	const char *gamepc_filename;
PALMOS */
	const Char gme_filename[12];
	const Char wav_filename[12];
	const Char voc_filename[12];
	const Char mp3_filename[12];
	const Char voc_effects_filename[12];
	const Char mp3_effects_filename[12];
 	const Char gamepc_filename[12];
} GameSpecificSettings;
///////////////////////////////////////////////////////////////////
static void addSimon_simon1_settings() {


	GameSpecificSettings simon1_settings = {
	1,										/* VGA_DELAY_BASE */
	1576 / 4,									/* TABLE_INDEX_BASE */
	1460 / 4,									/* TEXT_INDEX_BASE */
	64,										/* NUM_VIDEO_OP_CODES */
	1000000,									/* VGA_MEM_SIZE */
	50000,										/* TABLES_MEM_SIZE */
	1316 / 4,									/* MUSIC_INDEX_BASE */
	0,										/* SOUND_INDEX_BASE */
	"SIMON.GME",									/* gme_filename */
	"SIMON.WAV",									/* wav_filename */
	"SIMON.VOC",									/* voc_filename */
	"SIMON.MP3",									/* mp3_filename */
	"EFFECTS.VOC",									/* voc_effects_filename */
	"EFFECTS.MP3",									/* mp3_effects_filename */
	"GAMEPC",									/* gamepc_filename */
};

	writeRecord(&simon1_settings, sizeof(simon1_settings), GBVARS_SIMON1SETTINGS_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////
static void addSimon_simon1amiga_settings() {


	GameSpecificSettings simon1amiga_settings = {
	1,										/* VGA_DELAY_BASE */
	1576 / 4,									/* TABLE_INDEX_BASE */
	1460 / 4,									/* TEXT_INDEX_BASE */
	64,										/* NUM_VIDEO_OP_CODES */
	1000000,									/* VGA_MEM_SIZE */
	50000,										/* TABLES_MEM_SIZE */
	1316 / 4,									/* MUSIC_INDEX_BASE */
	0,										/* SOUND_INDEX_BASE */
	"",										/* gme_filename */
	"",										/* wav_filename */
	"",										/* voc_filename */
	"SIMON.MP3",									/* mp3_filename */
	"",										/* voc_effects_filename */
	"",										/* mp3_effects_filename */
	"gameamiga",									/* gamepc_filename */
};

	writeRecord(&simon1amiga_settings, sizeof(simon1amiga_settings), GBVARS_SIMON1AMIGASETTINGS_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////

static void addSimon_simon1demo_settings() {


	GameSpecificSettings simon1demo_settings = {
	1,										/* VGA_DELAY_BASE */
	1576 / 4,									/* TABLE_INDEX_BASE */
	1460 / 4,									/* TEXT_INDEX_BASE */
	64,										/* NUM_VIDEO_OP_CODES */
	1000000,									/* VGA_MEM_SIZE */
	50000,										/* TABLES_MEM_SIZE */
	1316 / 4,									/* MUSIC_INDEX_BASE */
	0,										/* SOUND_INDEX_BASE */
	"",										/* gme_filename */
	"",										/* wav_filename */
	"",										/* voc_filename */
	"",										/* mp3_filename */
	"",										/* voc_effects_filename */
	"",										/* mp3_effects_filename */
	"GDEMO",									/* gamepc_filename */
};

	writeRecord(&simon1demo_settings, sizeof(simon1demo_settings), GBVARS_SIMON1DEMOSETTINGS_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////
static void addSimon_simon2win_settings() {


	GameSpecificSettings simon2win_settings = {
	5,										/* VGA_DELAY_BASE */
	1580 / 4,									/* TABLE_INDEX_BASE */
	1500 / 4,									/* TEXT_INDEX_BASE */
	75,										/* NUM_VIDEO_OP_CODES */
	2000000,									/* VGA_MEM_SIZE */
	100000,										/* TABLES_MEM_SIZE */
	1128 / 4,									/* MUSIC_INDEX_BASE */
	1660 / 4,									/* SOUND_INDEX_BASE */
	"SIMON2.GME",									/* gme_filename */
	"SIMON2.WAV",									/* wav_filename */
	"SIMON2.VOC",									/* voc_filename */
	"SIMON2.MP3",									/* mp3_filename */
	"",										/* voc_effects_filename */
	"",										/* mp3_effects_filename */
	"GSPTR30",									/* gamepc_filename */
};

	writeRecord(&simon2win_settings, sizeof(simon2win_settings), GBVARS_SIMON2WINSETTINGS_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////
static void addSimon_simon2mac_settings() {


	GameSpecificSettings simon2mac_settings = {
	5,										/* VGA_DELAY_BASE */
	1580 / 4,									/* TABLE_INDEX_BASE */
	1500 / 4,									/* TEXT_INDEX_BASE */
	75,										/* NUM_VIDEO_OP_CODES */
	2000000,									/* VGA_MEM_SIZE */
	100000,										/* TABLES_MEM_SIZE */
	1128 / 4,									/* MUSIC_INDEX_BASE */
	1660 / 4,									/* SOUND_INDEX_BASE */
	"Simon2.gme",									/* gme_filename */
	"",										/* wav_filename */
	"",										/* voc_filename */
	"SIMON2.MP3",									/* mp3_filename */
	"",										/* voc_effects_filename */
	"",										/* mp3_effects_filename */
	"gsptr30",									/* gamepc_filename */
};

	writeRecord(&simon2mac_settings, sizeof(simon2mac_settings), GBVARS_SIMON2MACSETTINGS_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////
static void addSimon_simon2dos_settings() {


	GameSpecificSettings simon2dos_settings = {
	5,										/* VGA_DELAY_BASE */
	1580 / 4,									/* TABLE_INDEX_BASE */
	1500 / 4,									/* TEXT_INDEX_BASE */
	75,										/* NUM_VIDEO_OP_CODES */
	2000000,									/* VGA_MEM_SIZE */
	100000,										/* TABLES_MEM_SIZE */
	1128 / 4,									/* MUSIC_INDEX_BASE */
	1660 / 4,									/* SOUND_INDEX_BASE */
	"SIMON2.GME",									/* gme_filename */
	"",										/* wav_filename */
	"",										/* voc_filename */
	"",										/* mp3_filename */
	"",										/* voc_effects_filename */
	"",										/* mp3_effects_filename */
	"GAME32",									/* gamepc_filename */
};

	writeRecord(&simon2dos_settings, sizeof(simon2dos_settings), GBVARS_SIMON2DOSSETTINGS_INDEX, GBVARS_SIMON);
}





static void addSimon_hebrew_video_font() {

	char hebrew_video_font[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 176, 32, 112, 112, 32, 32, 0,
	32, 0, 48, 48, 96, 0, 0, 0,
	0, 0, 0, 144, 0, 96, 144, 144,
	104, 0, 0, 144, 0, 96, 144, 144,
	96, 0, 0, 144, 0, 144, 144, 144,
	96, 0, 0, 16, 40, 16, 42, 68,
	58, 0, 48, 48, 96, 0, 0, 0,
	0, 0, 0, 4, 8, 8, 8, 8,
	4, 0, 0, 32, 16, 16, 16, 16,
	32, 0, 0, 0, 20, 8, 62, 8,
	20, 0, 0, 112, 136, 240, 136, 136,
	240, 0, 0, 0, 0, 0, 0, 48,
	48, 96, 0, 0, 0, 240, 100, 0,
	178, 0, 9, 0, 176, 48, 48, 0,
	16, 32, 0, 120, 112, 64, 56, 0,
	112, 136, 152, 168, 200, 136, 112, 0,
	32, 96, 32, 32, 32, 32, 112, 0,
	112, 136, 8, 48, 64, 136, 248, 0,
	112, 136, 8, 48, 8, 136, 112, 0,
	16, 48, 80, 144, 248, 16, 56, 0,
	248, 128, 240, 8, 8, 136, 112, 0,
	48, 64, 128, 240, 136, 136, 112, 0,
	248, 136, 8, 16, 32, 32, 32, 0,
	112, 136, 136, 112, 136, 136, 112, 0,
	112, 136, 136, 120, 8, 16, 96, 0,
	0, 0, 48, 48, 0, 48, 48, 0,
	5, 5, 4, 6, 5, 3, 4, 5,
	6, 3, 5, 5, 4, 6, 5, 3,
	4, 6, 5, 6, 6, 6, 5, 5,
	5, 6, 5, 6, 6, 6, 6, 6,
	112, 136, 8, 16, 32, 0, 32, 0,
	0, 0, 144, 80, 160, 144, 144, 0,
	0, 0, 224, 32, 32, 32, 240, 0,
	0, 0, 224, 32, 96, 160, 160, 0,
	0, 0, 248, 16, 16, 16, 16, 0,
	0, 0, 240, 16, 16, 144, 144, 0,
	0, 0, 192, 64, 64, 64, 64, 0,
	0, 0, 224, 64, 32, 64, 64, 0,
	0, 0, 240, 144, 144, 144, 144, 0,
	0, 0, 184, 168, 136, 136, 112, 0,
	0, 0, 192, 64, 0, 0, 0, 0,
	0, 0, 240, 16, 16, 16, 16, 16,
	0, 0, 224, 16, 16, 16, 224, 0,
	128, 128, 224, 32, 32, 32, 192, 0,
	0, 0, 248, 72, 72, 72, 120, 0,
	0, 0, 176, 208, 144, 144, 176, 0,
	0, 0, 192, 64, 64, 64, 64, 64,
	0, 0, 96, 32, 32, 32, 224, 0,
	0, 0, 248, 72, 72, 72, 48, 0,
	0, 0, 80, 80, 80, 80, 224, 0,
	0, 0, 248, 72, 104, 8, 8, 8,
	0, 0, 248, 72, 104, 8, 248, 0,
	0, 0, 216, 72, 48, 16, 16, 16,
	0, 0, 144, 80, 32, 16, 240, 0,
	0, 0, 240, 16, 144, 160, 128, 128,
	0, 0, 240, 16, 16, 16, 16, 0,
	0, 0, 168, 168, 200, 136, 112, 0,
	0, 0, 240, 80, 80, 80, 208, 0,
	0, 14, 8, 8, 8, 8, 14, 0,
	0, 128, 64, 32, 16, 8, 4, 0,
	0, 112, 16, 16, 16, 16, 112, 0,
	0, 48, 72, 64, 72, 48, 16, 48,
	0, 80, 0, 96, 32, 40, 48, 0,
	32, 16, 0, 152, 144, 144, 232, 0,
	0, 0, 112, 8, 120, 136, 120, 0,
	192, 64, 80, 104, 72, 72, 112, 0,
	0, 0, 112, 136, 128, 136, 112, 0,
	24, 16, 80, 176, 144, 144, 112, 0,
	0, 0, 112, 136, 248, 128, 112, 0,
	48, 72, 64, 224, 64, 64, 224, 0,
	0, 0, 104, 144, 144, 112, 136, 112,
	192, 64, 80, 104, 72, 72, 200, 0,
	64, 0, 192, 64, 64, 64, 224, 0,
	8, 0, 8, 8, 8, 8, 136, 112,
	192, 64, 72, 80, 96, 80, 200, 0,
	192, 64, 64, 64, 64, 64, 224, 0,
	0, 0, 144, 216, 168, 136, 136, 0,
	0, 0, 240, 136, 136, 136, 136, 0,
	0, 0, 112, 136, 136, 136, 112, 0,
	0, 0, 176, 72, 72, 112, 64, 224,
	0, 0, 104, 144, 144, 112, 16, 56,
	0, 0, 176, 72, 72, 64, 224, 0,
	0, 0, 120, 128, 112, 8, 240, 0,
	64, 64, 240, 64, 64, 72, 48, 0,
	0, 0, 144, 144, 144, 144, 104, 0,
	0, 0, 136, 136, 136, 80, 32, 0,
	0, 0, 136, 136, 168, 216, 144, 0,
	0, 0, 136, 80, 32, 80, 136, 0,
	0, 0, 136, 136, 136, 112, 32, 192,
	0, 0, 248, 144, 32, 72, 248, 0,
	32, 80, 0, 96, 144, 144, 96, 0,
	0, 14, 8, 48, 8, 8, 14, 0,
	0, 8, 8, 8, 8, 8, 8, 0,
	0, 112, 16, 12, 16, 16, 112, 0,
	0, 0, 0, 0, 0, 0, 248, 0,
	139, 2, 178, 252, 8, 0, 176, 240,
	8, 0, 176, 32, 33, 34, 35, 36,
};
	writeRecord(hebrew_video_font, sizeof(hebrew_video_font), GBVARS_HEBREWVIDEOFONT_INDEX, GBVARS_SIMON);
}

static void addSimon_spanish_video_font() {

	char spanish_video_font[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	32, 112, 112, 32, 32, 0, 32, 0,
	48, 48, 96, 0, 0, 0, 0, 0,
	80, 0, 112, 8, 120, 136, 120, 0,
	80, 0, 112, 136, 136, 136, 112, 0,
	80, 0, 144, 144, 144, 144, 104, 0,
	0, 16, 40, 16, 42, 68, 58, 0,
	48, 48, 96, 0, 0, 0, 0, 0,
	0, 4, 8, 8, 8, 8, 4, 0,
	0, 32, 16, 16, 16, 16, 32, 0,
	0, 0, 20, 8, 62, 8, 20, 0,
	96, 144, 144, 160, 144, 144, 160, 128,
	0, 0, 0, 0, 0, 48, 48, 96,
	0, 0, 0, 240, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 48, 48, 0,
	32, 64, 0, 112, 248, 128, 112, 0, 
	112, 136, 152, 168, 200, 136, 112, 0,
	32, 96, 32, 32, 32, 32, 112, 0,
	112, 136, 8, 48, 64, 136, 248, 0,
	112, 136, 8, 48, 8, 136, 112, 0,
	16, 48, 80, 144, 248, 16, 56, 0,
	248, 128, 240, 8, 8, 136, 112, 0,
	48, 64, 128, 240, 136, 136, 112, 0,
	248, 136, 8, 16, 32, 32, 32, 0,
	112, 136, 136, 112, 136, 136, 112, 0,
	112, 136, 136, 120, 8, 16, 96, 0,
	0, 0, 48, 48, 0, 48, 48, 0,
	32, 64, 0, 112, 8, 248, 120, 0,  
	32, 64, 0, 192, 64, 64, 224, 0, 
	32, 64, 0, 112, 136, 136, 112, 0,  
	32, 64, 0, 144, 144, 144, 104, 0, 
	112, 136, 8, 16, 32, 0, 32, 0,
	80, 160, 0, 240, 136, 136, 136, 0, 
	112, 136, 136, 248, 136, 136, 136, 0,
	240, 72, 72, 112, 72, 72, 240, 0,
	48, 72, 128, 128, 128, 72, 48, 0,
	224, 80, 72, 72, 72, 80, 224, 0,
	248, 72, 64, 112, 64, 72, 248, 0,
	248, 72, 64, 112, 64, 64, 224, 0,
	48, 72, 128, 152, 136, 72, 56, 0,
	136, 136, 136, 248, 136, 136, 136, 0,
	248, 32, 32, 32, 32, 32, 248, 0,
	24, 8, 8, 8, 136, 136, 112, 0,
	200, 72, 80, 96, 80, 72, 200, 0,
	224, 64, 64, 64, 64, 72, 248, 0,
	136, 216, 168, 168, 136, 136, 136, 0,
	136, 200, 168, 152, 136, 136, 136, 0,
	112, 136, 136, 136, 136, 136, 112, 0,
	240, 72, 72, 112, 64, 64, 224, 0,
	112, 136, 136, 136, 136, 168, 112, 8,
	240, 72, 72, 112, 72, 72, 200, 0,
	112, 136, 128, 112, 8, 136, 112, 0,
	248, 168, 32, 32, 32, 32, 112, 0,
	136, 136, 136, 136, 136, 136, 120, 0,
	136, 136, 136, 80, 80, 32, 32, 0,
	136, 136, 136, 136, 168, 216, 136, 0,
	136, 136, 80, 32, 80, 136, 136, 0,
	136, 136, 136, 112, 32, 32, 112, 0,
	248, 136, 16, 32, 64, 136, 248, 0,
	0, 14, 8, 8, 8, 8, 14, 0,
	0, 128, 64, 32, 16, 8, 4, 0,
	0, 112, 16, 16, 16, 16, 112, 0,
	32, 0, 32, 64, 128, 136, 112, 0,
	32, 0, 32, 32, 112, 112, 32, 0,
	80, 0, 144, 144, 144, 144, 104, 0,
	0, 0, 112, 8, 120, 136, 120, 0,
	192, 64, 80, 104, 72, 72, 112, 0,
	0, 0, 112, 136, 128, 136, 112, 0,
	24, 16, 80, 176, 144, 144, 112, 0,
	0, 0, 112, 136, 248, 128, 112, 0,
	48, 72, 64, 224, 64, 64, 224, 0,
	0, 0, 104, 144, 144, 112, 136, 112,
	192, 64, 80, 104, 72, 72, 200, 0,
	64, 0, 192, 64, 64, 64, 224, 0,
	8, 0, 8, 8, 8, 8, 136, 112,
	192, 64, 72, 80, 96, 80, 200, 0,
	192, 64, 64, 64, 64, 64, 224, 0,
	0, 0, 144, 216, 168, 136, 136, 0,
	0, 0, 240, 136, 136, 136, 136, 0,
	0, 0, 112, 136, 136, 136, 112, 0,
	0, 0, 176, 72, 72, 112, 64, 224,
	0, 0, 104, 144, 144, 112, 16, 56,
	0, 0, 176, 72, 72, 64, 224, 0,
	0, 0, 120, 128, 112, 8, 240, 0,
	64, 64, 240, 64, 64, 72, 48, 0,
	0, 0, 144, 144, 144, 144, 104, 0,
	0, 0, 136, 136, 136, 80, 32, 0,
	0, 0, 136, 136, 168, 216, 144, 0,
	0, 0, 136, 80, 32, 80, 136, 0,
	0, 0, 136, 136, 136, 112, 32, 192,
	0, 0, 248, 144, 32, 72, 248, 0,
	32, 80, 0, 96, 144, 144, 96, 0,
	0, 14, 8, 48, 8, 8, 14, 0,
	0, 8, 8, 8, 8, 8, 8, 0,
	0, 112, 16, 12, 16, 16, 112, 0,
	0, 0, 0, 0, 0, 0, 248, 0,
	139, 2, 178, 252, 8, 0, 176, 240,
	8, 0, 176, 0, 16, 0, 176, 255,
};
	writeRecord(&spanish_video_font, sizeof(spanish_video_font), GBVARS_SPANISHVIDEOFONT_INDEX, GBVARS_SIMON);
}

static void addSimon_video_font() {

	char video_font[] = {
	0, 0, 0, 0, 0, 0, 0, 0,
	32, 112, 112, 32, 32, 0, 32, 0,
	48, 48, 96, 0, 0, 0, 0, 0,
	0, 144, 0, 96, 144, 144, 104, 0,
	0, 144, 0, 96, 144, 144, 96, 0,
	0, 144, 0, 144, 144, 144, 96, 0,
	0, 16, 40, 16, 42, 68, 58, 0,
	48, 48, 96, 0, 0, 0, 0, 0,
	0, 4, 8, 8, 8, 8, 4, 0,
	0, 32, 16, 16, 16, 16, 32, 0,
	0, 0, 20, 8, 62, 8, 20, 0,
	0, 112, 136, 240, 136, 136, 240, 0,
	0, 0, 0, 0, 0, 48, 48, 96,
	0, 0, 0, 240, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 48, 48, 0,
	16, 32, 0, 120, 112, 64, 56, 0,
	112, 136, 152, 168, 200, 136, 112, 0,
	32, 96, 32, 32, 32, 32, 112, 0,
	112, 136, 8, 48, 64, 136, 248, 0,
	112, 136, 8, 48, 8, 136, 112, 0,
	16, 48, 80, 144, 248, 16, 56, 0,
	248, 128, 240, 8, 8, 136, 112, 0,
	48, 64, 128, 240, 136, 136, 112, 0,
	248, 136, 8, 16, 32, 32, 32, 0,
	112, 136, 136, 112, 136, 136, 112, 0,
	112, 136, 136, 120, 8, 16, 96, 0,
	0, 0, 48, 48, 0, 48, 48, 0,
	32, 16, 0, 112, 8, 248, 120, 0,
	32, 80, 0, 144, 144, 144, 104, 0,
	80, 0, 144, 144, 144, 144, 104, 0,
	32, 80, 0, 112, 248, 128, 112, 0,
	112, 136, 8, 16, 32, 0, 32, 0,
	32, 80, 0, 192, 64, 64, 224, 0,
	112, 136, 136, 248, 136, 136, 136, 0,
	240, 72, 72, 112, 72, 72, 240, 0,
	48, 72, 128, 128, 128, 72, 48, 0,
	224, 80, 72, 72, 72, 80, 224, 0,
	248, 72, 64, 112, 64, 72, 248, 0,
	248, 72, 64, 112, 64, 64, 224, 0,
	48, 72, 128, 152, 136, 72, 56, 0,
	136, 136, 136, 248, 136, 136, 136, 0,
	248, 32, 32, 32, 32, 32, 248, 0,
	24, 8, 8, 8, 136, 136, 112, 0,
	200, 72, 80, 96, 80, 72, 200, 0,
	224, 64, 64, 64, 64, 72, 248, 0,
	136, 216, 168, 168, 136, 136, 136, 0,
	136, 200, 168, 152, 136, 136, 136, 0,
	112, 136, 136, 136, 136, 136, 112, 0,
	240, 72, 72, 112, 64, 64, 224, 0,
	112, 136, 136, 136, 136, 168, 112, 8,
	240, 72, 72, 112, 72, 72, 200, 0,
	112, 136, 128, 112, 8, 136, 112, 0,
	248, 168, 32, 32, 32, 32, 112, 0,
	136, 136, 136, 136, 136, 136, 120, 0,
	136, 136, 136, 80, 80, 32, 32, 0,
	136, 136, 136, 136, 168, 216, 136, 0,
	136, 136, 80, 32, 80, 136, 136, 0,
	136, 136, 136, 112, 32, 32, 112, 0,
	248, 136, 16, 32, 64, 136, 248, 0,
	0, 14, 8, 8, 8, 8, 14, 0,
	0, 128, 64, 32, 16, 8, 4, 0,
	0, 112, 16, 16, 16, 16, 112, 0,
	0, 48, 72, 64, 72, 48, 16, 48,
	0, 80, 0, 96, 32, 40, 48, 0,
	32, 16, 0, 152, 144, 144, 232, 0,
	0, 0, 112, 8, 120, 136, 120, 0,
	192, 64, 80, 104, 72, 72, 112, 0,
	0, 0, 112, 136, 128, 136, 112, 0,
	24, 16, 80, 176, 144, 144, 112, 0,
	0, 0, 112, 136, 248, 128, 112, 0,
	48, 72, 64, 224, 64, 64, 224, 0,
	0, 0, 104, 144, 144, 112, 136, 112,
	192, 64, 80, 104, 72, 72, 200, 0,
	64, 0, 192, 64, 64, 64, 224, 0,
	8, 0, 8, 8, 8, 8, 136, 112,
	192, 64, 72, 80, 96, 80, 200, 0,
	192, 64, 64, 64, 64, 64, 224, 0,
	0, 0, 144, 216, 168, 136, 136, 0,
	0, 0, 240, 136, 136, 136, 136, 0,
	0, 0, 112, 136, 136, 136, 112, 0,
	0, 0, 176, 72, 72, 112, 64, 224,
	0, 0, 104, 144, 144, 112, 16, 56,
	0, 0, 176, 72, 72, 64, 224, 0,
	0, 0, 120, 128, 112, 8, 240, 0,
	64, 64, 240, 64, 64, 72, 48, 0,
	0, 0, 144, 144, 144, 144, 104, 0,
	0, 0, 136, 136, 136, 80, 32, 0,
	0, 0, 136, 136, 168, 216, 144, 0,
	0, 0, 136, 80, 32, 80, 136, 0,
	0, 0, 136, 136, 136, 112, 32, 192,
	0, 0, 248, 144, 32, 72, 248, 0,
	32, 80, 0, 96, 144, 144, 96, 0,
	0, 14, 8, 48, 8, 8, 14, 0,
	0, 8, 8, 8, 8, 8, 8, 0,
	0, 112, 16, 12, 16, 16, 112, 0,
	0, 0, 0, 0, 0, 0, 248, 0,
	252, 252, 252, 252, 252, 252, 252, 252,
	240, 240, 240, 240, 240, 240, 240, 240,
};
	writeRecord(&video_font, sizeof(video_font), GBVARS_VIDEOFONT_INDEX, GBVARS_SIMON);
}
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

void addSimon() {
	addSimon_simon1_settings();
	addSimon_simon1amiga_settings();
	addSimon_simon1demo_settings();
	addSimon_simon2win_settings();
	addSimon_simon2mac_settings();
	addSimon_simon2dos_settings();
	addSimon_hebrew_video_font();
	addSimon_spanish_video_font();
	addSimon_video_font();
}
