#include <sentinel.h>

extern pthread_mutex_t th_mutex;
extern pthread_mutex_t local_mutex;
extern int tag;

int process_dns(u_char *);
u_char *gentcp(unsigned long, unsigned long, int, int, u_char, int *, int);

void dns_sniff(void *data)
{
  pcap_t *pd;
  unsigned char *pkt, filter[1024];
  struct in_addr addr;
  struct pcap_pkthdr pcap_h;
  struct host_info *host_info;

  host_info = (struct host_info *)data;
  addr.s_addr = host_info->ip_addr;

  memset(filter, 0, sizeof(filter));
  snprintf(filter, sizeof(filter), "udp dst port 53 and host %s", 
    host_info->ip);

  pd = pcap_init(filter, 1);

  for(;;) {
    usleep(100);
    pthread_mutex_lock(&local_mutex);
    if(tag)
      break;
    pthread_mutex_unlock(&local_mutex);

    pkt = (unsigned char *)pcap_next(pd, &pcap_h);
    if(!pkt)
      continue;

    if(process_dns(pkt)) {
      host_info->results = 1;
      pthread_mutex_lock(&local_mutex);
      tag = 2;
      pthread_mutex_unlock(&local_mutex);
      break;
    }
  }
  pcap_close(pd);
  pthread_exit(0);
}

int process_dns(u_char *pkt)
{
  struct libnet_ip_hdr *ip;
  struct libnet_udp_hdr *udp;
  struct libnet_dns_hdr *dns;
  char *data, names[512];
  int cnt;

  ip = (struct libnet_ip_hdr *)(pkt + netinit.offset);
  udp = (struct libnet_udp_hdr *)(pkt + netinit.offset + LIBNET_IP_H);
  dns = (struct libnet_dns_hdr *)(pkt + netinit.offset + LIBNET_IP_H + 
    LIBNET_UDP_H);
  data = (char *)(pkt + netinit.offset + LIBNET_IP_H + LIBNET_UDP_H +
    LIBNET_DNS_H);

  if(!dns->num_q)
    return(0);

  cnt = (char)*data;

  for(;cnt;) {
    (char *)data++;
    strncat(names, (char *)data, cnt);
    data += cnt;
    cnt = (char)*data;
    strncat(names, ".", sizeof(names) - strlen(names));
  }

  names[strlen(names) - 1] = 0x0;

  if(strstr(names, "5.0.0.10.in-addr.arpa"))
    return(1);

  return(0);
}

void dns_flood(void)
{
  int i, j, len[6];
  unsigned char *pkt[6], errbuf[1024];
  struct libnet_link_int *link_int;

  link_int = libnet_open_link_interface(netinit.iface, errbuf);
  if(!link_int) {
    puts("Error: Could not open link interface");
    exit(-1);
  }

  pkt[1] = gentcp(netinit.src_ipaddr, inet_addr("10.0.0.5"), 
	     12345, 0, TH_SYN, &len[1], 0);
  pkt[2] = gentcp(inet_addr("10.0.0.5"), netinit.src_ipaddr,
	     98765, 12346, (TH_SYN|TH_ACK), &len[2], 0);
  pkt[3] = gentcp(netinit.src_ipaddr, inet_addr("10.0.0.5"),
	     12346, 98766, TH_ACK, &len[3], 0);
  pkt[4] = gentcp(netinit.src_ipaddr, inet_addr("10.0.0.5"),
	     12347, 98767, TH_ACK, &len[4], 1);
  pkt[5] = gentcp(netinit.src_ipaddr, inet_addr("10.0.0.5"),
	     12348, 98768, TH_RST, &len[5], 0);

  for(i = 0; i < netinit.num; i++) {
    sleep(1);
    putchar('.');

    for(j = 1; j <= 5; j++)
      libnet_write_link_layer(link_int, netinit.iface, pkt[j], len[j]);

    pthread_mutex_lock(&local_mutex);
      if(tag)
	goto end;
    pthread_mutex_unlock(&local_mutex);
  }

  tag = 1;

end:
  for(i = 1; i <= 5; i++)
    libnet_destroy_packet(&pkt[i]);

  libnet_close_link_interface(link_int);
  pthread_exit(0);
}


u_char *gentcp(unsigned long src, unsigned long dst, int seq, int ack,
  u_char flags, int *len, int pf)
{
  unsigned char *pkt, *payload;
  unsigned char def_hwaddr[6] = { 0x22, 0x22, 0x22, 0x22, 0x22, 0x22 };
  int pay_s, size;

  if(pf) {
    payload = "Sentinel Found You!";
    pay_s = strlen(payload);
  } else {
    payload = NULL;
    pay_s = 0;
  }

  size = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_TCP_H + pay_s;

  if(libnet_init_packet(size, &pkt) < 0) {
    puts("Error: Cannot allocate memory for packet");
    exit(-1);
  }

  libnet_build_ethernet(def_hwaddr, (u_char *)&netinit.src_hwaddr,
    ETHERTYPE_IP, NULL, 0, pkt);

  libnet_build_ip(LIBNET_TCP_H + pay_s, 0, 100, 0, 64, IPPROTO_TCP, src, dst,
    NULL, 0, pkt + LIBNET_ETH_H);

  libnet_build_tcp(23, 23, seq, ack, flags, 0, 0, payload, pay_s, 
    pkt + LIBNET_IP_H + LIBNET_ETH_H);

  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H);
  libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_TCP, LIBNET_TCP_H + pay_s);

  *len = size;
  return(pkt);
}
