#include <sentinel.h>

void sentinel_init(struct sentinel *s, int method)
{
  s->method = method;
  s->size = 0;
  s->positive = 0;
  s->tail = NULL;
  s->head = NULL;
}

void sentinel_list_insert(struct sentinel *s, char *ip)
{
  struct host_info *host_info;

  host_info = (struct host_info *)malloc(sizeof(struct host_info));

  host_info->ip = strdup(ip);
  host_info->ip_addr = libnet_name_resolve(ip, 0);
  host_info->results = 0;
  host_info->methods = 0;

  if(!s->size) 
    s->tail = host_info;

  s->size++;

  host_info->next = s->head;
  s->head = host_info;
}
