#include <sentinel.h>

void title();
void usage(char *);

struct netinit netinit;

int main(int argc, char **argv)
{
  int opt, method = 0;
  char *host, *class_c, *infile, *outfile, *prog;
  struct sentinel sentinel;
  struct utsname hinfo;
  struct in_addr addr;

  opterr = 0;  
  host = class_c = infile = outfile = NULL;
  netinit.num = 10;
  prog = argv[0];

  setvbuf(stdout, NULL, _IONBF, 0);

  while((opt = getopt(argc, argv, "adec:f:i:n:")) != EOF) {
    switch(opt) {
      case 'a': method |= ARP; break;
      case 'd': method |= DNS; break;
      case 'e': method |= ETHERPING; break;
      case 'c': class_c = optarg; break;
      case 'f': infile = optarg; break;
      case 'i': netinit.iface = strdup(optarg); break;
      case 'n': netinit.num = atoi(optarg); break;
      default: usage(prog); break;
    }
  }

  if(!class_c && !infile) {
    argv += optind;
    host = argv[0];
  }

  if((!class_c && !infile && !host) || !method)
    usage(prog);

  if(class_c && infile)
    usage(prog);

  net_init();

  title();

  addr.s_addr = netinit.src_ipaddr;
  uname(&hinfo);

  printf("Executing on: '%s' running on %s %s on a(n) %s\n\n",
    hinfo.nodename, hinfo.sysname, hinfo.release, hinfo.machine);

  printf("Device: %s\n", netinit.iface);
  printf("Source IP Address: %s\n", inet_ntoa(addr));
  printf("Source Hardware Address: ");
  printf("%02x:%02x:%02x:%02x:%02x:%02x\n\n", 
    netinit.src_hwaddr.ether_addr_octet[0],
    netinit.src_hwaddr.ether_addr_octet[1],
    netinit.src_hwaddr.ether_addr_octet[2],
    netinit.src_hwaddr.ether_addr_octet[3],
    netinit.src_hwaddr.ether_addr_octet[4],
    netinit.src_hwaddr.ether_addr_octet[5]);

  if(class_c) 
    init_classc(&sentinel, class_c, method);

  if(infile)
    init_ipfile(&sentinel, infile, method);

  if(host)
    if(init_host(&sentinel, host, method) < 0)
      return(-1);

  detect_promisc(&sentinel);

  if(sentinel.positive > 0) {
    report(&sentinel);
    exit(0);
  }

  puts("\nNo promiscuous systems discovered");
  exit(0);
}

void title() 
{
  printf("-- the sentinel project %s : by bind : copyright (c) 2000, 2001 "
         "--\n\n", VERSION);
} 

void usage(char *prog)
{
  title();
  printf("usage:\n"
         "  %s [options] [methods] [-c <x.x.x>] [-f <filename>] [host]\n\n"
         "methods:\n"
         "  -a arp test\n"
	 "  -d dns test\n"
	 "  -e icmp etherping test\n\n"
	 "options:\n"
	 "  -c <x.x.x> class c to scan\n"
         "  -f <file> file of ip addresses\n"
	 "  -i <device> network interface\n"
         "  -n <number> number of packets to send\n\n", prog);
  exit(-1);
}
