#ifndef _Config_h
#define _Config_h

/*
 *  subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *  Contact: kitone at free dot fr
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *  \file
 *  \brief 
 *  \author kitone (kitone at free dot fr)
 */

#include <glibmm/ustring.h>
#include <glib.h>
#include <list>

/*
 *
 */
class Config
{
public:

	/*
	 *
	 */
	Config();

	/*
	 *
	 */
	~Config();
	
	/*
	 *
	 */
	bool loadCfg();
	bool saveCfg();

	/*
	 *
	 */
	bool set_comment(const Glib::ustring &group, const Glib::ustring &key, const Glib::ustring &comment);

	
	/*
	 *
	 */
	bool has_group(const Glib::ustring &group);
	bool has_key(const Glib::ustring &group, const Glib::ustring &key);
	
	bool get_keys(const Glib::ustring &group, std::list<Glib::ustring> &list);

	/*
	 *
	 */
	bool set_value_bool(const Glib::ustring &group, const Glib::ustring &key, const bool &value);
	bool get_value_bool(const Glib::ustring &group, const Glib::ustring &key, bool &value);

	/*
	 *
	 */
	bool set_value_int(const Glib::ustring &group, const Glib::ustring &key, const int &value);
	bool get_value_int(const Glib::ustring &group, const Glib::ustring &key, int &value);

	/*
	 *
	 */
	bool set_value_string(const Glib::ustring &group, const Glib::ustring &key, const Glib::ustring &value);
	bool get_value_string(const Glib::ustring &group, const Glib::ustring &key, Glib::ustring &value);
	bool set_value_string_list(const Glib::ustring &group, const Glib::ustring &key, const std::list<Glib::ustring> &list);
	bool get_value_string_list(const Glib::ustring &group, const Glib::ustring &key, std::list<Glib::ustring> &list);

	/*
	 *
	 */
	bool remove_group(const Glib::ustring &group);
	bool remove_key(const Glib::ustring &group, const Glib::ustring &key);

	/*
	 *
	 */
	static Config& getInstance();

protected:
	GKeyFile* m_keyFile;		
};

#endif//_Config_h
