[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools_fmt n 1.0]
[copyright {2002-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Specification of a simple Tcl Markup Language for Manpages}]
[description]
[para]

This document specifies version 1 of a text format for man pages. The
name of this format is [term doctools] and it provides all the
necessary commands to write a manpage.

It is complemented by both the [term doctoc] format for writing tables
of contents and the [term docidx] format for writing keyword indices.

The formal specifications for these two formats can be found in the
companion documents [term doctoc_fmt] and [term docidx_fmt].

A third companion document describes the package [package doctools],
which provides commands for the processing of text in [term doctools]
format.

[para]

Like for the formats [term doctoc] and [term docidx] a generic
framework for the conversion of [term doctools] to any number of
different output formats is provided.

This framework is provided by the package [package doctools].

[para]

Anyone who wishes to write a toc formatting engine which plugs into
this framework has to read the document [term doctools_api]. This is the
formal specification of the API between the framework and its engines.


[section {FORMAT SPECIFICATION}]

[subsection OVERVIEW]

[term doctools] is similar to LaTeX. Input written in this format
consists primarily of text, with markup commands embedded into it. The
format used to mark commands is different from LaTeX however. All text
between matching pairs of [lb] and [rb] is a command, possibly with
arguments. Note that both brackets have to be on the same line for a
command to be recognized.

[para]

In contrast to both [term doctoc] and [term docidx] this format does
allow arbitrary text between markup commands. Only some places are
restricted to only white space.


[subsection GRAMMAR]

The overall syntax of a manpage is best captured in a formal
context-free grammar. Our notation for the grammar is EBNF. Strings
will stand for markup commands, however their arguments (if they have
any) are not part of the grammar. Our grammar contains lexical
elements as well.

[para]

First we specify the whitespace and other text at the lexical level,
which also includes comments.

[para]
[example {
    COMMENT  ::= "comment"
    WHITE    ::= { '\n' | '\t' | ' ' | '\r' | COMMENT }
    TEXT     ::= { All characters except '[' }
}]
[para]


Then we define rules for all the keywords. Here we introduce our
knowledge that some commands allow only whitespace after them.

[para]
[example {
    BEGIN      ::= "manpage_begin" WHITE
    END        ::= "manpage_end"	
    TITLE      ::= "titledesc"     WHITE
    MODULE     ::= "moddesc"       WHITE
    REQUIRE    ::= "require"       WHITE
    COPYRIGHT  ::= "copyright"     WHITE
    DESC       ::= "description"

    SECTION    ::= "section"
    SUBSEC     ::= "subsection"
    PARA       ::= "para"
    NL         ::= "nl"
    SEE_ALSO   ::= "see_also"
    KEYWORDS   ::= "keywords"

    ARG        ::= "arg"
    CMD        ::= "cmd"
    OPT        ::= "opt"
    EMPH       ::= "emph"
    STRONG     ::= "strong"
    SECTREF    ::= "sectref"
    USAGE      ::= "usage"
    SYSCMD     ::= "syscmd"
    METHOD     ::= "method"
    NAMESPACE  ::= "namespace"
    OPTION     ::= "option"
    WIDGET     ::= "widget"
    FUN        ::= "fun"
    TYPE       ::= "type"
    PACKAGE    ::= "package"
    CLASS      ::= "class"
    VAR        ::= "var"
    FILE       ::= "file"
    URI        ::= "uri"
    TERM       ::= "term"
    CONST      ::= "const"
    LB         ::= "lb"
    RB         ::= "rb"
    EX_BEGIN   ::= "example_begin"
    EX_END     ::= "example_end"
    EXAMPLE    ::= "example"

    LIST_BEGIN ::= "list_begin" WHITE
    LIST_END   ::= "list_end"
    LIST_ITEM  ::= "lst_item"
    BULLET     ::= "bullet"
    ENUM       ::= "enum"
    CALL       ::= "call"
    ARGDEF     ::= "arg_def"
    OPTDEF     ::= "opt_def"
    CMDDEF     ::= "cmd_def"
    TKODEF     ::= "tkoption_def"

    INCLUDE    ::= "include"
    VSET       ::= "vset"
    DEFUN      ::= { INCLUDE | VSET }
}]

At last we can specify the whole manpage. Here we introduce our
knowledge that inclusion of other files may happen essentially
everywhere, like the definition of document variables and comments.
The content of any included file has to fit into the including file
according to the location in the grammar the inclusion is at.

[para]
[example {
    MANPAGE      ::= DEFUN BEGIN HEADER DESC BODY END

    HEADER       ::= { TITLE | MODULE | COPYRIGHT } { REQUIRE }
    BODY         ::= REGULAR_TEXT { SECTION SECBODY }
    SECBODY      ::= REGULAR_TEXT { SUBSEC SUBSECBODY }
    SUBSECBODY   ::= REGULAR_TEXT

    REGULAR_TEXT ::= TEXT_CHUNK { PARA TEXT_CHUNK }
    TEXT_CHUNK   ::= { TEXT | DEFUN | XREF | MARKUP | COMMENT | A_LIST | AN_EXAMPLE }

    A_LIST       ::= LIST_BEGIN { ( LIST_ITEM | CALL ) LIST_TEXT } LIST_END
                   | LIST_BEGIN { BULLET LIST_TEXT } LIST_END
                   | LIST_BEGIN { ENUM   LIST_TEXT } LIST_END
                   | LIST_BEGIN { ARGDEF LIST_TEXT } LIST_END
                   | LIST_BEGIN { OPTDEF LIST_TEXT } LIST_END
                   | LIST_BEGIN { CMDDEF LIST_TEXT } LIST_END
                   | LIST_BEGIN { TKODEF LIST_TEXT } LIST_END

    LIST_TEXT    ::= TEXT_CHUNK { NL TEXT_CHUNK }

    AN_EXAMPLE   ::= EXAMPLE | EX_BEGIN EXAMPLE_TEXT EX_END
    EXAMPLE_TEXT ::= { TEXT | DEFUN | MARKUP }

    MARKUP       ::= { BRACKETS | SEMANTIC }

    XREF         ::= SEE_ALSO | KEYWORDS
    BRACKETS     ::= LB | RB
    SEMANTIC     ::= ARG | EMPH | CLASS | STRONG | OPTION
                   | CMD | TYPE | CONST | METHOD | SECTREF
                   | OPT | TERM | FUN   | SYSCMD | PACKAGE
                   | VAR | FILE | USAGE | WIDGET | NAMESPACE
                   | URI
}]


[subsection COMMANDS]

Here we specify the commands used in the grammar. Some commands
specified here were not used in the grammar at all. The usage of these
commands is confined to the arguments of other commands.


[list_begin definitions]

[call [cmd comment] [arg text]]

The command declares that the argument [arg text] is a comment.


[call [cmd include] [arg filename]]

This command loads the contents of the file [arg filename] for
processing at its own place.


[call [cmd vset] [arg varname] [arg value] ]

This form of the command sets the document variable [arg varname] to
the specified [arg value]. It does not generate output.


[call [cmd vset] [arg varname]]

This form of the command returns the value associated with the
document variable [arg varname]. 


[call [cmd lb]]

This command adds a left bracket to the output. [emph Note] that the
bracket commands are necessary as plain brackets are used to begin and
end the formatting commands.


[call [cmd rb]]

This command adds a right bracket to the output. [emph Note] that the
bracket commands are necessary as plain brackets are used to begin and
end the formatting commands.


[call [cmd manpage_begin] [arg command] [arg section] [arg version]]

This is the command to start a manpage. The arguments are the name of
the [arg command] described by the manpage, the [arg section] of the
manpages this manpage resides in, and the [arg version] of the module
containing the command.


[call [cmd manpage_end]]

This is the command to close a manpage.


[call [cmd moddesc] [arg desc]]

This command is optional. When used it will register its argument
[arg desc] as a short description of the module the manpage resides
in.


[call [cmd titledesc] [arg desc]]

This command is optional. When used it will register its argument
[arg desc] as the title of the manpage. When not used the information
from [cmd moddesc] will be used for the title as well.


[call [cmd copyright] [arg text]]

This command is optional. When used its argument [arg text] will
declare a copyright assignment for the manpage. When invoked more than
once the assignments are accumulated.

[nl]

A doctools processor application (like [syscmd dtplite]) is allowed to
provide such information too, but a formatting engine has to give the
accumulated arguments of this command precedence over the data coming
from the application.


[call [cmd description]]

This is the command to separate the header part of the manpage from
the main body.


[call [cmd require] [arg pkg] [opt [arg version]]]

This is the command to list the packages which are required by an
application or other library to import the described package and its
prerequisites.


[call [cmd section] [arg name]]

This is the command to partition the body of the manpage into named
sections. Note that the command [cmd description] at the beginning of
the manpage body implicitly starts a section named "DESCRIPTION". A
section command implicitly closes the last [cmd para]graph coming
before it and also implicitly opens the first paragraph of the new
section.

[call [cmd subsection] [arg name]]

This is the command to partition the body of a [term section] into
named sub-sections. A subsection command implicitly closes the last
[cmd para]graph coming before it and also implicitly opens the first
paragraph of the new section.


[call [cmd para]]

This is the command to partition the text in a section or sub-section
into paragraphs. Each invokation closes the paragraph coming before it
and opens a new paragraph for the text coming after.


[call [cmd see_also] [arg args]]

This is the command to define direct cross-references to other
documents. Each argument is a label identifying the referenced
document. If this command is used multiple times all the arguments
accumulate.


[call [cmd keywords] [arg args]]

This is the command to define the keywords applying to this
document. Each argument is a single keyword. If this command is used
multiple times all the arguments accumulate.


[call [cmd arg] [arg text]]

Declares that the argument [arg text] is the name of a command
argument.


[call [cmd cmd] [arg text]]

Declares that the argument [arg text] is the name of a command.


[call [cmd opt] [arg text]]

Declares that the argument [arg text] is something optional. Most
often used in conjunction with [cmd arg] to denote optional command
arguments. Example:

[example {
    [arg foo]
        A regular argument.

    [opt [arg foo]]
        An optional argument.
}]


[call [cmd emph] [arg text]]

Emphasize the [arg text].


[call [cmd strong] [arg text]]

Emphasize the [arg text]. Same as [cmd emph]. Usage of this command is
discouraged. The command is deprecated and present only for backward
compatibility.


[call [cmd sectref] [arg text] [opt [arg label]]]

Declares that the argument [arg text] is the name of a section
somewhere else in the document, and the current location should refer
to it.

Without an explicit [arg label] for the reference within the text the
section title [arg text] is used.


[call [cmd syscmd] [arg text]]

Declares that the argument [arg text] is the name of a system command.


[call [cmd method] [arg text]]

Declares that the argument [arg text] is the name of an object method.


[call [cmd namespace] [arg text]]

Declares that the argument [arg text] is the name of a namespace.


[call [cmd option] [arg text]]

Declares that the argument [arg text] is the name of an option.


[call [cmd widget] [arg text]]

Declares that the argument [arg text] is the name of a widget.


[call [cmd fun] [arg text]]

Declares that the argument [arg text] is the name of a function.


[call [cmd type] [arg text]]

Declares that the argument [arg text] is the name of a data type.


[call [cmd package] [arg text]]

Declares that the argument [arg text] is the name of a package.


[call [cmd class] [arg text]]

Declares that the argument [arg text] is the name of a class.


[call [cmd var] [arg text]]

Declares that the argument [arg text] is the name of a variable.


[call [cmd file] [arg text]]

Declares that the argument [arg text] is a file .


[call [cmd uri] [arg text] [opt [arg text]]]

Declares that the argument [arg text] is an uri. The second argument,
if it is present, is the human-readable description of the uri. In
other words, the label for the link. Without a labeling text the uri
is used as its own label.


[call [cmd term] [arg text]]

Declares that the argument [arg text] contains some unspecific
terminology.


[call [cmd const] [arg text]]

Declares that the argument [arg text] is a constant value.


[call [cmd nl]]

This command signals vertical space to separate blocks of text.

[comment {
    FUTURE: This is the same as para, but restricted to use inside of
    list elements. Whereas para's are restricted to usage outside list
    elements. Given that both do the same this separation is stupid.
    Doctools V2 will have only one command, 'para', useable everywhere.
    The formatting engine has to switch outputs, if truly necessary.
}]


[call [cmd example_begin]] 

This command begins an example block. Subsequent text belongs to the
example. Line breaks, spaces, and tabs have to be preserved literally.


[call [cmd example_end]] 

This command closes the example block.


[call [cmd example] [arg text]] 

This command wraps its argument [arg text] into an example. In other
words, it is a simpler form of markup for the creation of an
example. It should be used if the example text does not need need
special markup.


[call [cmd list_begin] [arg what]]

This command starts new list. The value of the argument [arg what]
determines what type of list is opened. This also defines what command
has to be used to start an item in the new list. The allowed types
(and their associated item commands) are:

[list_begin definitions]
[lst_item [emph bullet]]
[cmd bullet]

[lst_item [emph enum]]
[cmd enum]

[lst_item [emph definitions]]
[cmd lst_item] and [cmd call]

[lst_item [emph arg]]
[cmd arg_def]

[lst_item [emph cmd]]
[cmd cmd_def]

[lst_item [emph opt]]
[cmd opt_def]

[lst_item [emph tkoption]]
[cmd tkoption_def]

[list_end]
[nl]


[call [cmd list_end]]

This command ends the list opened by the last [cmd list_begin].


[call [cmd bullet]]

This command starts a new list item in a bulletted list. The previous
item is automatically closed.


[call [cmd enum]]

This command starts a new list item in an enumerated list. The
previous item is automatically closed.


[call [cmd lst_item] [arg text]]

This command starts a new list item in a definition list. The argument
is the term to be defined. The previous item is automatically closed.


[call [cmd call] [arg args]]

This command starts a new list item in a definition list, but the term
defined by it is a command and its arguments. The previous item is
automatically closed. The first argument is the name of the described
command, and everything after that are descriptions of the command
arguments.


[call [cmd arg_def] [arg type] [arg name] [opt [arg mode]]]

This command starts a new list item in an argument list. The previous
item is automatically closed. Specifies the data-[arg type] of the
described argument, its [arg name] and its i/o-[arg mode]. The latter
is optional.


[call [cmd opt_def] [arg name] [opt [arg arg]]]

This command starts a new list item in an option list. The previous
item is automatically closed. Specifies the [arg name] of the option
and its arguments ([arg arg]). The latter is a list, and can be left
out.


[call [cmd cmd_def] [arg command]]

This command starts a new list item in a command list.  The previous
item is automatically closed. Specifies the name of the [arg command].


[call [cmd tkoption_def] [arg name] [arg dbname] [arg dbclass]]

This command starts a new list item in a widget option list. The
previous item is automatically closed.

Specifies the [arg name] of the option, i.e. the name used in scripts,
the name used by the option database ([arg dbname]), and the class
(type) of the option ([arg dbclass]).


[call [cmd usage] [arg args]]

This command is like [cmd call], except that a formatting engine must
not generate output at the location of the command. In other words,
this command is [emph silent]. The data it defines may appear in a
different section of the output, for example a table of contents, or
synopsis, depending on the formatting engine and its output format.

[list_end]


[section EXAMPLE]

The sources of this manpage can serve as an example for all of the
markup described by it. Almost every possible construct is used here.


[see_also doctoc_fmt docidx_fmt doctools_api doctools]
[keywords markup {generic markup} manpage TMML HTML nroff LaTeX]
[manpage_end]

