from distutils.core import setup
import distutils.util
import distutils.file_util
import sys
import commands

# Metadata
NAME="telepathy-butterfly"
VERSION="0.1.4"
DESCRIPTION="Telepathy MSN connection manager"
AUTHOR="Ali Sabil"
AUTHOR_EMAIL="ali.sabil@gmail.com"
URL="http://telepathy.freedesktop.org/wiki/TelepathyButterfly",
LICENSE="GNU GPL",

# compatibility with python < 2.2.3
if sys.version < '2.2.3':
    from distutils.dist import DistributionMetadata
    DistributionMetadata.classifiers = None
    DistributionMetadata.download_url = None

# rebuild data/org.freedesktop.Telepathy.ConnectionManager.butterfly.service
service_file = ('[D-BUS Service]',
    'Name=org.freedesktop.Telepathy.ConnectionManager.butterfly',
    'Exec=%s/bin/telepathy-butterfly' % sys.prefix)
def rebuild_service_file():
    distutils.file_util.write_file('data/org.freedesktop.Telepathy.ConnectionManager.butterfly.service', service_file)
distutils.util.execute(rebuild_service_file,())


dbus_service_dir = commands.getoutput('pkg-config --variable=session_bus_services_dir dbus-1')
if dbus_service_dir ==  '':
    dbus_service_dir = 'share/dbus-1/services'
telepathy_manager_dir = 'share/telepathy/managers'
# Setup
setup(name=NAME,
      version=VERSION,
      description=DESCRIPTION,
      author=AUTHOR,
      author_email=AUTHOR_EMAIL,
      url=URL,
      license=LICENSE,
      platforms=['POSIX'],
      packages=['TelepathyButterfly'],
      scripts=['telepathy-butterfly'],
      data_files=[
          (dbus_service_dir, ['data/org.freedesktop.Telepathy.ConnectionManager.butterfly.service']),
          (telepathy_manager_dir, ['data/butterfly.manager'])
          ],
      classifiers=[
          'Development Status :: 4 - Beta',
          'Environment :: No Input/Output (Daemon)',
          'Intended Audience :: End Users/Desktop'
          'Intended Audience :: Developers',
          'Intended Audience :: Telecommunications Industry',
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Operating System :: POSIX',
          'Operating System :: MacOS :: MacOS X',
          'Programming Language :: Python',
          'Topic :: Communications :: Chat',
          'Topic :: Internet'
          ])
