/*
  Tux Paint Config UI file
  Originally generated by Fast Light User Interface Designer (fluid) v. 1.0104

  Torsten Giebl <wizard@turricane.org>
  Jan Wynholds
  Bill Kendrick <bill@newbreedsoftware.com>
  Martin Fuhrer <mfuhrer@gmail.com>

  http://www.tuxpaint.org/

  November 12, 2002 - February 28, 2008
*/

#include <libintl.h>
#include <math.h>
#include "tuxpaint-config2.h"
#include <FL/fl_ask.H>
#include <FL/fl_message.H>
#include <FL/Fl.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Slider.H>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>
#if USE_PAPERSIZES
#include <paper.h>
#endif
#include "version.h"
#include "about.h"

/* Current build stuff doesn't deal with gettext; jdrake 2004-10-02 */
#ifdef __APPLE__
extern "C" {
    #include "macosx_dialog.h"
}
#define gettext(text) text
#endif


// Win32 specific stuff to help set the window icon
#ifdef WIN32
#include "../visualc/resource.h"    // contains IDI_ICON1
#include "win32utils.h"              // Registry utilities
extern HINSTANCE fl_display;        // hInstance on win32 platform
#endif

//dont think save_conf will work for win32...
//need to redo with #IFDEF precompiler definitions and better writing

bool status_chng=0;

char conf_filename[256];

const char * window_widths[NUM_WINDOW_WIDTHS] = {
  "640",
  "768",
  "800",
  "854",
  "1024",
  "1280",
  "1400",
  "1600",
  "1680",
  "1920",
  "2048",
  "2560"
};

const char * window_heights[NUM_WINDOW_HEIGHTS] = {
  "480",
  "576",
  "600",
  "720",
  "768",
  "800",
  "960",
  "1024",
  "1050",
  "1080",
  "1200",
  "1536",
  "1600",
  "2048"
};

#define NUM_LANGS 82
#define LANG_NAME 0
#define LANG_CODE 1

const char * langs[NUM_LANGS][2] = {
	{"(Use system's setting)", "default"},
	{"Afrikaans", "afrikaans"},
	{"Albanian", "albanian"},
	{"Arabic", "arabic"},
        {"Azerbaijani", "azerbaijani"},
	{"Basque", "basque"},
	{"Belarusian", "belarusian"},
	{"Breton", "breton"},
	{"Bulgarian", "bulgarian"},
	{"Catalan", "catalan"},
        {"Chinese (Simplified)", "simplified-chinese"},
        {"Chinese (Traditional)", "traditional-chinese"},
	{"Croatian", "croatian"},
	{"Czech", "czech"},
	{"Danish", "danish"},
	{"Dutch", "dutch"},
	{"English (USA)", "american-english"},
	{"English (Australian)", "australian-english"},
	{"English (Britain)", "british"},
	{"English (Canadian)", "canadian-english"},
	{"English (South Africa)", "southafrican-english"},
	{"Esperanto", "esperanto"},
	{"Estonian", "estonian"},
	{"Faroese", "faroese"},
	{"Finnish", "finnish"},
	{"French", "french"},
	{"Gaelic (Ireland)", "gaelic"},
	{"Gaelic (Scotland)", "scottish"},
	{"Galician", "galician"},
	{"Georgian", "georgian"},
	{"German", "german"},
	{"Greek", "greek"},
	{"Gronings", "gronings"},
	{"Gujarati", "gujarati"},
	{"Hebrew", "hebrew"},
	{"Hindi", "hindi"},
	{"Hungarian", "hungarian"},
	{"Icelandic", "icelandic"},
	{"Indonesian", "indonesian"},
	{"Italian", "italian"},
	{"Japanese", "japanese"},
	{"Khmer", "khmer"},
	{"Kinyarwanda", "kinyarwanda"},
	{"Klingon", "klingon"},
	{"Korean", "korean"},
	{"Kurdish", "kurdish"},
        {"Latvian", "latvian"},
	{"Lithuanian", "lithuanian"},
	{"Macedonian", "macedonian"},
	{"Malay", "malay"},
	{"Ndebele", "ndebele"},
	{"Norwegian Bokml", "bokmal"},
	{"Norwegian Nynorsk", "nynorsk"},
	{"Occitan", "occitan"},
	{"Ojibwe", "ojibwe"},
	{"Polish", "polish"},
	{"Portuguese (Portugal)", "portuguese"},
        {"Portuguese (Brazilian)", "brazilian-portuguese"},
	{"Romanian", "romanian"},
	{"Russian", "russian"},
	{"Serbian", "serbian"},
	{"Slovak", "slovak"},
	{"Slovenian", "slovenian"},
	{"Spanish (Mexico)", "mexican-spanish"},
	{"Spanish (Spain)", "spanish"},
	{"Swahili", "swahili"},
	{"Swedish", "swedish"},
	{"Tagalog", "tagalog"},
	{"Tamil", "tamil"},
        {"Telugu", "telugu"},
	{"Thai", "thai"},
	{"Tibetan", "tibetan"},
	{"Turkish", "turkish"},
        {"Twi", "twi"},
	{"Ukrainian", "ukrainian"},
	{"Venda", "venda"},
	{"Vietnamese", "vietnamese"},
	{"Walloon", "walloon"},
	{"Welsh", "welsh"},
	{"Wolof", "wolof"},
	{"Xhosa", "xhosa"},
	{"Zapoteco", "zapoteco"}
};

#if USE_PAPERSIZES
int num_papersizes;
char * * papersizes;
#endif

static void set_change_status(int status)
{
  status_chng=status;
  if (status_chng == 0) {
    BUTTON_apply->deactivate();
    BUTTON_reset->deactivate();
  }
  else
  {
    BUTTON_apply->activate();
    BUTTON_reset->activate();    
  }
}

static void construct_conf_filename(int user)
{
  strcpy(conf_filename, "tuxpaint.cfg");  // default config file
  switch (user)
  {
    case (CURRENT_USER):
#if defined(WIN32)
    {
      char *savedir = 0;
      savedir = GetDefaultSaveDir("TuxPaint"); /* FIXME */
      snprintf(conf_filename, sizeof(conf_filename), "%s/tuxpaint.cfg", savedir);
      free(savedir);
    }
#elif defined(__BEOS__)      
      strcpy(conf_filename, "tuxpaint.cfg");
#elif defined(__APPLE__)
      if (getenv("HOME") != NULL)
      {
        char mkdirCommand[256];
        snprintf(mkdirCommand, sizeof(mkdirCommand),
                 "mkdir -p '%s/Library/Application Support/TuxPaint'", getenv("HOME"));
        system(mkdirCommand);
        snprintf(conf_filename, sizeof(conf_filename),
                 "%s/Library/Application Support/TuxPaint/tuxpaint.cfg", getenv("HOME"));     
      }
#else
      /* Linux and other Unixes:  Use 'rc' style (~/.tuxpaintrc) */
      if (getenv("HOME") != NULL)
      {
        snprintf(conf_filename, sizeof(conf_filename),
                 "%s/.tuxpaintrc", getenv("HOME"));
      }        
#endif
      break;
      
    case  (ALL_USERS):
#if defined(WIN32)
    {
      char *appdir = GetApplicationDir();
      snprintf(conf_filename, sizeof(conf_filename), "%s/tuxpaint.cfg", appdir);
      free(appdir);
    }
#elif defined(__BEOS__)     
      strcpy(conf_filename, "tuxpaint.cfg");
#elif defined(__APPLE__)
      system("mkdir -p '/Library/Application Support/TuxPaint'");
      strcpy(conf_filename, "/Library/Application Support/TuxPaint/tuxpaint.cfg");     
#else
      snprintf(conf_filename, sizeof(conf_filename), "%s/tuxpaint.conf", CONFDIR);   
#endif
      break;
  }
}

static void activate_widgets()
{
  /* Video & Sound: */
  /* -------------- */

  CHECKBUTTON_fullscreen->activate();
  if (CHECKBUTTON_fullscreen->value()) {
    CHECKBUTTON_native->activate();
  }
  CHOICE_windowwidth->activate();
  CHOICE_windowheight->activate();
  CHECKBUTTON_rotate->activate();
  CHECKBUTTON_screensaver->activate();
  CHECKBUTTON_soundeffects->activate();
  CHECKBUTTON_usecolorfile->activate();
  if (CHECKBUTTON_usecolorfile->value()) {
    FILEINPUT_colorfile->activate();
    BUTTON_browsecolorfile->activate();
  }
  
  
  /* Mouse & Keyboard: */
  /* ----------------- */
  
  CHECKBUTTON_fancycursorshapes->activate();
  CHECKBUTTON_hidecursor->activate();
  CHECKBUTTON_grabmousepointer->activate();
  CHECKBUTTON_mousewheelsupport->activate();
  CHECKBUTTON_nobuttondistinction->activate();
  CHECKBUTTON_enablekbd->activate();
  
  /* Simplification: */
  /* --------------- */

  CHECKBUTTON_disableshaperotation->activate();
  CHECKBUTTON_simpleshapeoutlines->activate();
  CHECKBUTTON_showuppercasetextonly->activate();
  CHECKBUTTON_disablequitbutton->activate();
  CHECKBUTTON_disablestampstool->activate();
  CHECKBUTTON_disablestampcontrols->activate();
  SLIDER_stampsize->activate();
  
  /* Locale: */
  /* ------- */
  
  CHOICE_language->activate();
  CHECKBUTTON_mirrorstamps->activate();  
  CHECKBUTTON_loadsystemfonts->activate();
  
  /* Printing: */
  /* --------- */

  CHECKBUTTON_allowprinting->activate();
  VALUEINPUT_printdelay->activate();
  CHECKBUTTON_usealtprintcmd->activate();
  if (CHECKBUTTON_usealtprintcmd->value()) {
    TEXTINPUT_printcmd->activate();
  }
  CHECKBUTTON_usealtprintdia->activate();
  if (CHECKBUTTON_usealtprintdia->value()) {
    TEXTINPUT_printdia->activate(); 
  }
  ROUNDBUTTON_printdialogmod->activate();
  ROUNDBUTTON_printdialogalways->activate();
  ROUNDBUTTON_printdialognever->activate();

#if USE_PAPERSIZES
  CHOICE_papersize->activate();
#endif
  
  /* Saving: */
  /* ------- */

  ROUNDBUTTON_askbeforeoverwriting->activate();
  ROUNDBUTTON_alwaysoverwriteolderversion->activate();
  ROUNDBUTTON_alwayssavenewpicture->activate();
  CHECKBUTTON_usealternatesavedir->activate();
  if (CHECKBUTTON_usealternatesavedir->value()) {
    FILEINPUT_alternatesavedir->activate();
    BUTTON_browsealternatesavedir->activate();
  }
  CHECKBUTTON_startblank->activate();
  CHECKBUTTON_disablesavebutton->activate();
  CHECKBUTTON_autosave->activate();

  /* Data: */
  /* ----- */

  CHECKBUTTON_nolockfile->activate();
  CHECKBUTTON_usealternatedatadir->activate();
  if (CHECKBUTTON_usealternatedatadir->value()) {
    FILEINPUT_alternatedatadir->activate();
    BUTTON_browsealternatedatadir->activate();
  }
}

static void deactivate_widgets()
{
  /* Video & Sound: */
  /* -------------- */
  
  CHECKBUTTON_fullscreen->deactivate();
  CHECKBUTTON_native->deactivate();
  CHOICE_windowwidth->deactivate();
  CHOICE_windowheight->deactivate();
  CHECKBUTTON_rotate->deactivate();
  CHECKBUTTON_screensaver->deactivate();
  CHECKBUTTON_soundeffects->deactivate();
  CHECKBUTTON_usecolorfile->deactivate();
  FILEINPUT_colorfile->deactivate();
  BUTTON_browsecolorfile->deactivate();
  
  /* Mouse & Keyboard: */
  /* ----------------- */
  
  CHECKBUTTON_fancycursorshapes->deactivate();
  CHECKBUTTON_hidecursor->deactivate();
  CHECKBUTTON_grabmousepointer->deactivate();
  CHECKBUTTON_mousewheelsupport->deactivate();
  CHECKBUTTON_nobuttondistinction->deactivate();
  CHECKBUTTON_enablekbd->deactivate();
  
  /* Simplification: */
  /* --------------- */
  
  CHECKBUTTON_disableshaperotation->deactivate();
  CHECKBUTTON_simpleshapeoutlines->deactivate();
  CHECKBUTTON_showuppercasetextonly->deactivate();
  CHECKBUTTON_disablequitbutton->deactivate();
  CHECKBUTTON_disablestampstool->deactivate();
  CHECKBUTTON_disablestampcontrols->deactivate();
  SLIDER_stampsize->deactivate();
  
  /* Locale: */
  /* ------- */
  
  CHOICE_language->deactivate();
  CHECKBUTTON_mirrorstamps->deactivate();  
  CHECKBUTTON_loadsystemfonts->deactivate();
  
  /* Printing: */
  /* --------- */
  
  CHECKBUTTON_allowprinting->deactivate();
  VALUEINPUT_printdelay->deactivate();
  TEXTINPUT_printcmd->deactivate();
  CHECKBUTTON_usealtprintcmd->deactivate();  
  TEXTINPUT_printdia->deactivate();
  CHECKBUTTON_usealtprintdia->deactivate();
  ROUNDBUTTON_printdialogmod->deactivate();
  ROUNDBUTTON_printdialogalways->deactivate();
  ROUNDBUTTON_printdialognever->deactivate();
#if USE_PAPERSIZES
  CHOICE_papersize->deactivate();
#endif
  
  /* Saving: */
  /* ------- */
  
  ROUNDBUTTON_askbeforeoverwriting->deactivate();
  ROUNDBUTTON_alwaysoverwriteolderversion->deactivate();
  ROUNDBUTTON_alwayssavenewpicture->deactivate();
  FILEINPUT_alternatesavedir->deactivate();
  BUTTON_browsealternatesavedir->deactivate();
  CHECKBUTTON_usealternatesavedir->deactivate();
  CHECKBUTTON_startblank->deactivate();
  CHECKBUTTON_disablesavebutton->deactivate();
  CHECKBUTTON_autosave->deactivate();
  
  /* Data: */
  /* ----- */
  
  FILEINPUT_alternatedatadir->deactivate();
  BUTTON_browsealternatedatadir->deactivate();
  CHECKBUTTON_usealternatedatadir->deactivate();
}

static bool conf_file_exists(int user)
{
  FILE *fd;
  char *flg="r";
  
  construct_conf_filename(user);
  fd = fopen(conf_filename,flg);
  if (fd != NULL) {
    fclose(fd);
    return true;
  }
  return false;
}


void save_conf(void)
{
   FILE *fd;
   char *flg="w";

   construct_conf_filename(CHOICE_settings->value());

   fd = fopen(conf_filename,flg);

   if (fd == NULL)
      {
        fl_message("Cannot write %s: %s",conf_filename, strerror(errno));
        return;
      }

   fprintf(fd,"# Generated by tuxpaint-config version " VER_VERSION "\n");

   /* Video & Sound: */
   /* -------------- */

   /* Video: */
   if ((CHKBUT_fulls_isdef())==0)
   {
      if (CHECKBUTTON_native->value() == 0)
        fprintf(fd,"fullscreen=yes\n");
      else
        fprintf(fd,"fullscreen=native\n");
   }
   
   if (CHECKBUTTON_native->value() == 1 &&
       CHKBUT_fulls_isdef() == 1)
   {
     fprintf(fd, "native=yes\n"); // keep track of native when fullscreen is disabled
   }

   if (CHOICE_windowwidth->value() != DEF_WINDOW_WIDTH ||
       CHOICE_windowheight->value() != DEF_WINDOW_HEIGHT)
     fprintf(fd,"windowsize=%sx%s\n",
       window_widths[CHOICE_windowwidth->value()],
       window_heights[CHOICE_windowheight->value()]);

   if (CHECKBUTTON_rotate->value() != 0)
     fprintf(fd,"orient=portrait\n");

   if (CHECKBUTTON_screensaver->value() != 0)
     fprintf(fd,"allowscreensaver=yes\n");

   /* Sound: */
   if (CHECKBUTTON_soundeffects->value()==0)
      fprintf(fd,"nosound=yes\n");

   /* Color file: */
   if (strlen(FILEINPUT_colorfile->value()) > 0)
   {
     if (CHECKBUTTON_usecolorfile->value()==1)
       fprintf(fd,"colorfile=%s\n",FILEINPUT_colorfile->value());
     else
       fprintf(fd,"# colorfile=%s\n",FILEINPUT_colorfile->value());
   }

   /* Mouse & Keyboard: */
   /* ----------------- */

   /* Mouse: */
   if ((CHKBUT_fancycursors_isdef())==0)
      fprintf(fd,"nofancycursors=yes\n");
   if (CHECKBUTTON_hidecursor->value()==1)
      fprintf(fd,"hidecursor=yes\n");
   if ((CHKBUT_grabmouse_isdef())==0)
      fprintf(fd,"grab=yes\n");
   if ((CHKBUT_mousewheelsup_isdef())==0)
      fprintf(fd,"nowheelmouse=yes\n");
   if (CHECKBUTTON_nobuttondistinction->value()==1)
      fprintf(fd,"nobuttondistinction=yes\n");

   /* Keyboard: */
   if (CHECKBUTTON_enablekbd->value()==0)
      fprintf(fd,"noshortcuts=yes\n");
// if ((CHKBUT_xxx_isdef())==0)
//    fprintf(fd,"keyboard=yes\n");


   /* Simplification: */
   /* --------------- */

   /* Interface: */
   if (CHECKBUTTON_disableshaperotation->value()==1)
      fprintf(fd,"simpleshapes=yes\n");
   if ((CHKBUT_smploutlns_isdef())==0)
      fprintf(fd,"outlines=yes\n");
   if ((CHKBUT_showUConly_isdef())==0)
      fprintf(fd,"uppercase=yes\n");

   /* Control: */
   if ((CHKBUT_disablequit_isdef())==0)
      fprintf(fd,"noquit=yes\n");
   if (CHECKBUTTON_disablestampstool->value()==1)
      fprintf(fd,"nostamps=yes\n");
   if (CHECKBUTTON_disablestampcontrols->value()==1)
      fprintf(fd,"nostampcontrols=yes\n");

   /* Stamp size */
   if (SLIDER_stampsize->value() != -1)
      fprintf(fd,"stampsize=%d\n", (int) floor(SLIDER_stampsize->value()));


   /* Locale: */
   /* ------- */

   if(CHOICE_language->value()!=0)
      fprintf(fd,"lang=%s\n",langs[CHOICE_language->value()][LANG_CODE]);
   if ((CHKBUT_mirstamps_isdef())==0)
      fprintf(fd,"mirrorstamps=yes\n");

   if (CHECKBUTTON_loadsystemfonts->value()==1)
      fprintf(fd,"sysfonts=yes\n");


   /* Printing: */
   /* --------- */

   /* Print Permissions: */
   if ((CHKBUT_allowprint_isdef())==0)
      fprintf(fd,"noprint=yes\n");
   if ((VALINP_printdel_isdef())==0)
      fprintf(fd,"printdelay=%d\n",(int) VALUEINPUT_printdelay->value());

   /* Print Command: */
   if (strlen(TEXTINPUT_printcmd->value()) > 0)
   {
     if (CHECKBUTTON_usealtprintcmd -> value() == 1)
       fprintf(fd,"printcommand=%s\n",TEXTINPUT_printcmd->value());
     else
       fprintf(fd,"# printcommand=%s\n",TEXTINPUT_printcmd->value());
   }

   /* Print Dialog Alt. Command: */
   if (strlen(TEXTINPUT_printdia->value()) > 0)
   {
     if (CHECKBUTTON_usealtprintdia -> value() == 1)
       fprintf(fd,"altprintcommand=%s\n",TEXTINPUT_printdia->value());
     else
       fprintf(fd,"# altprintcommand=%s\n",TEXTINPUT_printdia->value());
   }

   /* Show print dialog? */
   if (ROUNDBUTTON_printdialogalways->value()==1)
     fprintf(fd,"altprint=always\n");
   else if (ROUNDBUTTON_printdialognever->value()==1)
      fprintf(fd,"altprint=never\n");

#if USE_PAPERSIZES
   /* Specify a paper size? */
   if (CHOICE_papersize->value() != 0)
     fprintf(fd,"papersize=%s\n", papersizes[CHOICE_papersize->value()]);
#endif


   /* Saving: */
   /* ------- */

   /* Save Over Earlier Work: */
   if (ROUNDBUTTON_alwaysoverwriteolderversion->value()==1)
     fprintf(fd,"saveover=yes\n");
   else if (ROUNDBUTTON_alwayssavenewpicture->value()==1)
      fprintf(fd,"saveover=new\n");

   /* Save Directory: */
   if (strlen(FILEINPUT_alternatesavedir->value()) > 0)
   {
     if ((CHKBUT_altsavedir_isdef())==0)
       fprintf(fd,"savedir=%s\n",FILEINPUT_alternatesavedir->value());
     else
       fprintf(fd,"# savedir=%s\n",FILEINPUT_alternatesavedir->value());
   }

   /* Start blank? */
   if (CHECKBUTTON_startblank->value() == 1)
     fprintf(fd,"startblank=yes\n");

   /* Disable saving: */
   if (CHECKBUTTON_disablesavebutton->value()==1)
      fprintf(fd,"nosave=yes\n");

   /* Auto-save on quit? */
   if (CHECKBUTTON_autosave->value()==1)
      fprintf(fd,"autosave=yes\n");

   /* Data: */
   /* ----- */

   /* Lockfile: */
   if (CHECKBUTTON_nolockfile->value()==1)
       fprintf(fd,"nolockfile=yes\n");

   /* Data Directory: */
   if (strlen(FILEINPUT_alternatedatadir->value()) > 0)
   {
     if ((CHKBUT_altdatadir_isdef())==0)
       fprintf(fd,"datadir=%s\n",FILEINPUT_alternatedatadir->value());
     else
       fprintf(fd,"# datadir=%s\n",FILEINPUT_alternatedatadir->value());
   }


   fclose(fd);
  
   set_change_status(0);

/*
   FIXME: Add "--keyboard" option to UI and save/load routines
*/

}



void load_conf(void)
{
   FILE *fd;
   char *flg="r";
   char line[256];
   bool all_users_conf_file = conf_file_exists(ALL_USERS);

   CB_SetAllTabsToDefaults ();
   
   switch(CHOICE_settings->value())
   {
     case (CURRENT_USER):
       
       CHECKBUTTON_usealluserssettings->show();
       if (all_users_conf_file == false) 
       {
         CHECKBUTTON_usealluserssettings->value(0);
         CHECKBUTTON_usealluserssettings->deactivate();
         activate_widgets();
       }
       else 
       {
         bool cur_user_conf_file = conf_file_exists(CURRENT_USER);
         CHECKBUTTON_usealluserssettings->activate();
         if (cur_user_conf_file == true) 
         {
           CHECKBUTTON_usealluserssettings->value(0);
           activate_widgets();
         }
         else
         {
           CHECKBUTTON_usealluserssettings->value(1);
           deactivate_widgets();
         }
       }
       break;
       
     case (ALL_USERS):
       CHECKBUTTON_usealluserssettings->hide();
       activate_widgets();
       break;
   }
   
   construct_conf_filename( CHOICE_settings->value() );

   fd = fopen(conf_filename,flg);

   if (fd != NULL)
   {
     do
     {
       fgets(line, sizeof(line), fd);
       
       if (!feof(fd))
       {
	 /* Trim EOL char(s): */
	       
	 while (strlen(line) > 0 &&
		(line[strlen(line) - 1] == '\r' ||
		 line[strlen(line) - 1] == '\n'))
	 {
	   line[strlen(line) - 1] = '\0';
	 }

	 
	 /* Determine what option it is, and if we should alter the UI
	    to correspond */
	
	 /* Video & Sound: */
	 if (strcmp(line, "fullscreen=yes") == 0)
	   CHECKBUTTON_fullscreen->value(1);

	 if (strcmp(line, "fullscreen=native") == 0)
         {
	   CHECKBUTTON_fullscreen->value(1);
	   CHECKBUTTON_native->value(1);
         }

	 if (strcmp(line, "native=yes") == 0)
         {
	   CHECKBUTTON_native->value(1);
         }

	 if (strstr(line, "windowsize=") == line)
	 {
	   int i;
           char tmp[32];

           for (i = 0; i < NUM_WINDOW_WIDTHS; i++)
           {
             sprintf(tmp, "windowsize=%sx", window_widths[i]);
             if (strstr(line, tmp) == line)
	       CHOICE_windowwidth->value(i);
           }

           for (i = 0; i < NUM_WINDOW_WIDTHS; i++)
           {
             sprintf(tmp, "windowsize=%sx%s",
               window_widths[CHOICE_windowwidth->value()], window_heights[i]);
             if (strcmp(line, tmp) == 0)
	       CHOICE_windowheight->value(i);
           }
	 }
         else if (strcmp(line, "orient=portrait") == 0)
           CHECKBUTTON_rotate->value(1);
         else if (strcmp(line, "allowscreensaver=yes") == 0)
           CHECKBUTTON_screensaver->value(1);
	 else if (strcmp(line, "nosound=yes") == 0)
	   CHECKBUTTON_soundeffects->value(0);
	 
	 /* Mouse & Keyboard: */
	 else if (strcmp(line, "nofancycursors=yes") == 0)
	   CHECKBUTTON_fancycursorshapes->value(0);
	 else if (strcmp(line, "hidecursor=yes") == 0)
	   CHECKBUTTON_hidecursor->value(1);
	 else if (strcmp(line, "grab=yes") == 0)
	   CHECKBUTTON_grabmousepointer->value(1);
	 else if (strcmp(line, "nowheelmouse=yes") == 0)
	   CHECKBUTTON_mousewheelsupport->value(0);
	 else if (strcmp(line, "nobuttondistinction=yes") == 0)
	   CHECKBUTTON_nobuttondistinction->value(1);
	 else if (strcmp(line, "noshortcuts=yes") == 0)
	   CHECKBUTTON_enablekbd->value(0);

	 /* Simplifications: */
	 else if (strcmp(line, "simpleshapes=yes") == 0)
	   CHECKBUTTON_disableshaperotation->value(1);
	 else if (strcmp(line, "outlines=yes") == 0)
	   CHECKBUTTON_simpleshapeoutlines->value(1);
	 else if (strcmp(line, "uppercase=yes") == 0)
	   CHECKBUTTON_showuppercasetextonly->value(1);
	 else if (strcmp(line, "noquit=yes") == 0)
	   CHECKBUTTON_disablequitbutton->value(1);
	 else if (strcmp(line, "nostamps=yes") == 0)
	   CHECKBUTTON_disablestampstool->value(1);
	 else if (strcmp(line, "nostampcontrols=yes") == 0)
	   CHECKBUTTON_disablestampcontrols->value(1);
	 else if (strstr(line, "stampsize=") == line)
	   SLIDER_stampsize->value(atoi(line + 10));

	 /* Locale: */
	 else if (strstr(line, "lang=") == line)
	 {
	   char * lang;
	   int i;
	   
	   lang = strstr(line, "lang=") + strlen("lang=");
	   
	   for (i = 0; i < NUM_LANGS; i++)
	   {
	     if (strcmp(lang, langs[i][LANG_CODE]) == 0)
	       CHOICE_language->value(i);
	   }
	 }
	 else if (strcmp(line, "mirrorstamps=yes") == 0)
	   CHECKBUTTON_mirrorstamps->value();
	 else if (strcmp(line, "sysfonts=yes") == 0)
	   CHECKBUTTON_loadsystemfonts->value(1);

	 /* Printing: */
	 else if (strcmp(line, "noprint=yes") == 0)
	   CHECKBUTTON_allowprinting->value(0);
	 else if (strstr(line, "printdelay=") == line)
	 {
	   VALUEINPUT_printdelay->value(atoi(strstr(line, "printdelay=") +
				             strlen("printdelay=")));
	 }
	 else if (strstr(line, "printcommand=") != NULL)
	 {
	   TEXTINPUT_printcmd->value(strstr(line, "printcommand=") +
			             strlen("printcommand="));

	   if (strstr(line, "printcommand=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealtprintcmd->value(1);
	     TEXTINPUT_printcmd->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealtprintcmd->value(0);
	     TEXTINPUT_printcmd->deactivate();
	   }
	 }
	 else if (strstr(line, "altprintcommand=") != NULL)
	 {
	   TEXTINPUT_printcmd->value(strstr(line, "altprintcommand=") +
			             strlen("altprintcommand="));

	   if (strstr(line, "altprintcommand=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealtprintdia->value(1);
	     TEXTINPUT_printdia->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealtprintdia->value(0);
	     TEXTINPUT_printdia->deactivate();
	   }
	 }
	 
	 /* Print Dialog: */
	 else if (strcmp(line, "altprint=always") == 0)
	 {
           ROUNDBUTTON_printdialogmod->value(0);
           ROUNDBUTTON_printdialogalways->value(1);
           ROUNDBUTTON_printdialognever->value(0);
	 }
	 else if (strcmp(line, "altprint=never") == 0)
	 {
           ROUNDBUTTON_printdialogmod->value(0);
           ROUNDBUTTON_printdialogalways->value(0);
           ROUNDBUTTON_printdialognever->value(1);
	 }
	 else if (strcmp(line, "altprint=mod") == 0)
	 {
           ROUNDBUTTON_printdialogmod->value(1);
           ROUNDBUTTON_printdialogalways->value(0);
           ROUNDBUTTON_printdialognever->value(0);
	 }

#if USE_PAPERSIZES
         /* Paper Size: */
         else if (strstr(line, "papersize=") == line)
         {
           for (int i = 1; i < num_papersizes; i++)
           {
             if (strcmp(line + strlen("papersize="), papersizes[i]) == 0)
               CHOICE_papersize->value(i);
           }
         }
#endif
	 
	 /* Saving: */
	 else if (strcmp(line, "saveover=ask") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(1);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(0);
           ROUNDBUTTON_alwayssavenewpicture->value(0);
	 }
	 else if (strcmp(line, "saveover=yes") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(0);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(1);
           ROUNDBUTTON_alwayssavenewpicture->value(0);
	 }
	 else if (strcmp(line, "saveover=new") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(0);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(0);
           ROUNDBUTTON_alwayssavenewpicture->value(1);
	 }
	 else if (strstr(line, "savedir=") != NULL)
	 {
	   FILEINPUT_alternatesavedir->value(strstr(line, "savedir=") +
			                     strlen("savedir="));

	   if (strstr(line, "savedir=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealternatesavedir->value(1);
	     FILEINPUT_alternatesavedir->activate();
	     BUTTON_browsealternatesavedir->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealternatesavedir->value(0);
	     FILEINPUT_alternatesavedir->deactivate();
	     BUTTON_browsealternatesavedir->deactivate();
	   }
	 }
	 else if (strstr(line, "datadir=") != NULL)
	 {
	   FILEINPUT_alternatedatadir->value(strstr(line, "datadir=") +
			                     strlen("datadir="));

	   if (strstr(line, "datadir=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealternatedatadir->value(1);
	     FILEINPUT_alternatedatadir->activate();
	     BUTTON_browsealternatedatadir->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealternatedatadir->value(0);
	     FILEINPUT_alternatedatadir->deactivate();
	     BUTTON_browsealternatedatadir->deactivate();
	   }
	 }
	 else if (strcmp(line, "nolockfile=yes") == 0 ||
		  strcmp(line, "lockfile=no") == 0)
	 {
           CHECKBUTTON_nolockfile->value(1);
	 }
	 else if (strstr(line, "colorfile=") != NULL)
	 {
	   FILEINPUT_colorfile->value(strstr(line, "colorfile=") +
			                     strlen("colorfile="));

	   if (strstr(line, "colorfile=") == line)
	   {
             /* Active! */

	     CHECKBUTTON_usecolorfile->value(1);
	     FILEINPUT_colorfile->activate();
	     BUTTON_browsecolorfile->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usecolorfile->value(0);
	     FILEINPUT_colorfile->deactivate();
	     BUTTON_browsecolorfile->deactivate();
	   }
	 }
	 else if (strcmp(line, "nosave=yes") == 0)
	   CHECKBUTTON_disablesavebutton->value(1);
	 else if (strcmp(line, "startblank=yes") == 0)
	 /* Start blank? */
	   CHECKBUTTON_startblank->value(1);
	 else if (strcmp(line, "autosave=yes") == 0)
	 /* Auto-save on quit? */
	   CHECKBUTTON_autosave->value(1);
       }
     }
     while (!feof(fd));
   }
   
   set_change_status(0);
}

static void apply_settings(void)
{
  if (CHECKBUTTON_usealluserssettings->visible() && CHECKBUTTON_usealluserssettings->value()) 
  {
    construct_conf_filename(CURRENT_USER);
    remove(conf_filename);
    set_change_status(0);
  }
  else
  {
    save_conf();
  }  
}

Fl_Double_Window *WINDOW_tpc=(Fl_Double_Window *)0;

Fl_Tabs *TAB_alltabs=(Fl_Tabs *)0;

Fl_Group *TABE_about=(Fl_Group *)0;
Fl_Group *GROUP_abouttpc=(Fl_Group *)0;
Fl_Text_Display *TEXTOUTPUT_abouttext=(Fl_Text_Display *)0;
Fl_Text_Buffer *TEXTBUFFER_abouttext = new Fl_Text_Buffer();

Fl_Group *TABE_videoandsound=(Fl_Group *)0;

Fl_Group *GROUP_video=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_fullscreen=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_native=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_startblank=(Fl_Check_Button *)0;
Fl_Group *GROUP_resolution=(Fl_Group *)0;
Fl_Choice *CHOICE_windowwidth=(Fl_Choice *) DEF_WINDOW_WIDTH;
Fl_Choice *CHOICE_windowheight=(Fl_Choice *) DEF_WINDOW_HEIGHT;
Fl_Check_Button *CHECKBUTTON_rotate=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_screensaver=(Fl_Check_Button *)0;

Fl_Group *GROUP_sound=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_soundeffects=(Fl_Check_Button *)0;

Fl_Group *TABE_mouseandkeyboard=(Fl_Group *)0;
Fl_Group *GROUP_mouse=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_fancycursorshapes=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_hidecursor=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_grabmousepointer=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_mousewheelsupport=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_nobuttondistinction=(Fl_Check_Button *)0;

Fl_Group *GROUP_keyboard=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_enablekbd=(Fl_Check_Button *)0;

Fl_Group *TABE_simplification=(Fl_Group *)0;
Fl_Group *GROUP_interfacesimpl=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_disableshaperotation=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_simpleshapeoutlines=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_showuppercasetextonly=(Fl_Check_Button *)0;
Fl_Group *GROUP_controlsimpl=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_disablequitbutton=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_disablestampstool=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_disablestampcontrols=(Fl_Check_Button *)0;
Fl_Slider *SLIDER_stampsize=(Fl_Slider *)0;
Fl_Group *GROUP_stampsize=(Fl_Group *)0;

Fl_Group *TABE_locale=(Fl_Group *)0;
Fl_Group *GROUP_locale=(Fl_Group *)0;
Fl_Choice *CHOICE_language=(Fl_Choice *)0;
Fl_Check_Button *CHECKBUTTON_mirrorstamps=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_loadsystemfonts=(Fl_Check_Button *)0;

Fl_Group *TABE_printing=(Fl_Group *)0;
Fl_Group *GROUP_printperms=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_allowprinting=(Fl_Check_Button *)0;
Fl_Value_Input *VALUEINPUT_printdelay=(Fl_Value_Input *)0;
Fl_Box *LABEL_seconds=(Fl_Box *)0;
Fl_Group *GROUP_printcmd=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealtprintcmd=(Fl_Check_Button *)0;
Fl_Group *GROUP_printdia=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealtprintdia=(Fl_Check_Button *)0;

Fl_Group *GROUP_startblank=(Fl_Group *)0;

static void cb_SLIDER_stampsize(Fl_Slider*, void*)
{
  double val;

  val = floor(SLIDER_stampsize->value());
  SLIDER_stampsize->value(val);

  if (val == -1)
    SLIDER_stampsize->label("Default (no override)");
  else if (val >= 0 && val <= 4)
    SLIDER_stampsize->label("Override: Small");
  else if (val >= 4 && val < 8)
    SLIDER_stampsize->label("Override: Medium");
  else if (val >= 8)
    SLIDER_stampsize->label("Override: Large");

  set_change_status(1);
}

static void cb_CHECKBUTTON_usefullscreen(Fl_Check_Button*, void*)
{
  if (CHECKBUTTON_fullscreen -> value() == 1) 
  {
    CHECKBUTTON_native -> activate();
  }
  else
  {
    CHECKBUTTON_native -> deactivate();
    CHECKBUTTON_native -> value(0);
  }
  set_change_status(1);
}


static void cb_CHECKBUTTON_usealtprintcmd(Fl_Check_Button*, void*)
{
  if (CHECKBUTTON_usealtprintcmd -> value () == 1)
    {
      TEXTINPUT_printcmd -> activate   ();
    }
  else
    {
      TEXTINPUT_printcmd -> deactivate ();
    };
  set_change_status(1);
}

Fl_Input *TEXTINPUT_printcmd=(Fl_Input *)0;

static void cb_CHECKBUTTON_usealtprintdia(Fl_Check_Button*, void*)
{
  if (CHECKBUTTON_usealtprintdia -> value () == 1)
    {
      TEXTINPUT_printdia -> activate   ();
    }
  else
    {
      TEXTINPUT_printdia -> deactivate ();
    };
  set_change_status(1);
}

Fl_Input *TEXTINPUT_printdia=(Fl_Input *)0;

Fl_Group *TABE_saving=(Fl_Group *)0;

Fl_Group *GROUP_saveover=(Fl_Group *)0;
Fl_Round_Button *ROUNDBUTTON_askbeforeoverwriting=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_alwaysoverwriteolderversion=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_alwayssavenewpicture=(Fl_Round_Button *)0;

Fl_Round_Button *ROUNDBUTTON_printdialogmod=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_printdialogalways=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_printdialognever=(Fl_Round_Button *)0;

#if USE_PAPERSIZES
Fl_Choice *CHOICE_papersize=(Fl_Choice *)0;
#endif

Fl_Group *GROUP_savedir=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealternatesavedir=(Fl_Check_Button *)0;

Fl_Group *TABE_data=(Fl_Group *)0;

Fl_Group *GROUP_lockfile=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_nolockfile=(Fl_Check_Button *)0;

Fl_Group *GROUP_datadir=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealternatedatadir=(Fl_Check_Button *)0;

Fl_Group *GROUP_colorfile=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usecolorfile=(Fl_Check_Button *)0;

Fl_Group *GROUP_nosave=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_disablesavebutton=(Fl_Check_Button *)0;

Fl_Check_Button *CHECKBUTTON_autosave=(Fl_Check_Button *)0;

static void cb_CHECKBUTTON_usealternatesavedir(Fl_Check_Button*, void*) {
  if (CHECKBUTTON_usealternatesavedir -> value () == 1)
  {
    FILEINPUT_alternatesavedir    -> activate   ();
    BUTTON_browsealternatesavedir -> activate   ();
  }
  else
  {
    FILEINPUT_alternatesavedir    -> deactivate ();
    BUTTON_browsealternatesavedir -> deactivate ();
  }
  set_change_status(1);
}

Fl_File_Input *FILEINPUT_alternatesavedir=(Fl_File_Input *)0;

static void cb_BUTTON_browsealternatesavedir(Fl_Button*, void*) {
    const char *dirname="\n";
#ifdef __APPLE__
    dirname = choosePath(0, 1, 0);
#else
    dirname = fl_dir_chooser(gettext("Directory ?"),"");
    fl_file_chooser_callback(0);
#endif
    if (strlen(dirname) > 0) {
        FILEINPUT_alternatesavedir->value(dirname);
        WINDOW_tpc->show();
        set_change_status(1);
    }
}

Fl_Button *BUTTON_browsealternatesavedir=(Fl_Button *)0;


static void cb_CHECKBUTTON_usealternatedatadir(Fl_Check_Button*, void*) {
  if (CHECKBUTTON_usealternatedatadir -> value () == 1)
  {
    FILEINPUT_alternatedatadir    -> activate   ();
    BUTTON_browsealternatedatadir -> activate   ();
  }
  else
  {
    FILEINPUT_alternatedatadir    -> deactivate ();
    BUTTON_browsealternatedatadir -> deactivate ();
  }
  set_change_status(1);
}

Fl_File_Input *FILEINPUT_alternatedatadir=(Fl_File_Input *)0;

static void cb_BUTTON_browsealternatedatadir(Fl_Button*, void*) {
    const char *dirname="\n";
#ifdef __APPLE__
    dirname = choosePath(0, 1, 0);
#else
    dirname = fl_dir_chooser(gettext("Directory ?"),"");
    fl_file_chooser_callback(0);
#endif
    if (strlen(dirname) > 0) {
        FILEINPUT_alternatedatadir->value(dirname);
        WINDOW_tpc->show();
        set_change_status(1);
    }
}

Fl_Button *BUTTON_browsealternatedatadir=(Fl_Button *)0;

static void cb_CHECKBUTTON_usecolorfile(Fl_Check_Button*, void*) {
  if (CHECKBUTTON_usecolorfile -> value () == 1)
  {
    FILEINPUT_colorfile    -> activate   ();
    BUTTON_browsecolorfile -> activate   ();
  }
  else
  {
    FILEINPUT_colorfile    -> deactivate ();
    BUTTON_browsecolorfile -> deactivate ();
  }
  set_change_status(1);
}

Fl_File_Input *FILEINPUT_colorfile=(Fl_File_Input *)0;

static void cb_BUTTON_browsecolorfile(Fl_Button*, void*) {
    const char *filename="\n";
#ifdef __APPLE__
    filename = choosePath(1, 0, "txt");
#else    
    filename = fl_file_chooser(gettext("File ?"),"*.txt","",0);
    fl_file_chooser_callback(0);
#endif
    if (strlen(filename) > 0) {
        FILEINPUT_colorfile->value(filename);
        WINDOW_tpc->show();
        set_change_status(1);
    }
}

Fl_Button *BUTTON_browsecolorfile=(Fl_Button *)0;

Fl_Button *BUTTON_apply=(Fl_Button *)0;

void cb_BUTTON_apply(Fl_Button*, void*) {
  apply_settings();
}

static void cb_BUTTON_reset(Fl_Button*, void*) {
  load_conf();
}

Fl_Button *BUTTON_reset=(Fl_Button *)0;

Fl_Button *BUTTON_defaults=(Fl_Button *)0;
Fl_Button *BUTTON_quit=(Fl_Button *)0;

static void cb_BUTTON_defaults(Fl_Button*, void*) {
  CB_SetActualTabToDefaults ();
  WINDOW_tpc -> show ();
}

static void cb_status_chng(Fl_Widget*, void*) {
  set_change_status(1);
}

void confirm_exit_cb(Fl_Widget *, void *) {
  if (status_chng)
  {
    if (fl_choice(gettext("Quit without applying changes?"),
        gettext("&No"), gettext("&Yes"), NULL))
        exit(0);
  }
  else
  {
    exit(0);
  }
}

Fl_Choice *CHOICE_settings=(Fl_Choice *)0;
Fl_Check_Button *CHECKBUTTON_usealluserssettings=(Fl_Check_Button *)0;

static void cb_CHECKBUTTON_usealluserssettings(Fl_Check_Button*, void*)
{
  if (CHECKBUTTON_usealluserssettings->value() == 0) 
  {
    activate_widgets();
  }
  else
  {
    deactivate_widgets();
  }  
  set_change_status(1); 
}

static void cb_CHOICE_settings(Fl_Choice*, void*)
{
  if (status_chng)
  {
    const char* user = 0;
    char question[256];
    
    CHOICE_settings->value( !(CHOICE_settings->value()) );
    
    switch(CHOICE_settings->value())
    {
      case (CURRENT_USER):
        user = "current user";
        break;
      case (ALL_USERS):
        user = "all users";
        break;
    }    
    
    snprintf(question, sizeof(question), "Apply changes you made to %s?", user);
    if (fl_choice(gettext(question),
                  gettext("No"), gettext("Yes"), NULL))
    {
      apply_settings();
    }
    
    CHOICE_settings->value( !(CHOICE_settings->value()) );
  }  
  
  load_conf();
}

Fl_Double_Window* Show_TPC_Window() {
  Fl_Double_Window* w;
  { 
    Fl_Double_Window* o;
    int y = 0;  
#ifdef __APPLE__
    o = WINDOW_tpc = new Fl_Double_Window(676, 420, gettext("Tux Paint Config v" VER_VERSION));
    y = 20;  // vertical offset to account for lack of menu bar at top of window
#else
    o = WINDOW_tpc = new Fl_Double_Window(670, 420, gettext("Tux Paint Config v" VER_VERSION));
#endif
    w = o;
    o->callback((Fl_Callback*)confirm_exit_cb);
    { Fl_Tabs* o = TAB_alltabs = new Fl_Tabs(5, 30-y, 665, 340);
      o->box(FL_PLASTIC_UP_BOX);
      { Fl_Group* o = TABE_about = new Fl_Group(5, 64-y, 665, 306, gettext("About"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)132);
        o->selection_color((Fl_Color)92);
        o->align(37);
        { Fl_Group* o = GROUP_abouttpc = new Fl_Group(12, 72-y, 653, 288, gettext("About Tux Paint Config."));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          TEXTOUTPUT_abouttext = new Fl_Text_Display(35, 95-y, 610, 245);
	  TEXTOUTPUT_abouttext->buffer(TEXTBUFFER_abouttext);
	  
	  TEXTBUFFER_abouttext->text(about_text);
	  TEXTOUTPUT_abouttext->wrap_mode(1, 0);

	  //o->align(FL_ALIGN_CENTER);

          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_videoandsound = new Fl_Group(5, 64-y, 665, 306, gettext("Video & Sound"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)1);
        o->selection_color((Fl_Color)1);
        o->align(37);
        { Fl_Group* o = GROUP_video = new Fl_Group(12, 70-y, 323, 290, gettext("Video :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_fullscreen = new Fl_Check_Button(24, 92-y, 300, 30, gettext("&Fullscreen"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80066);
	    o->callback((Fl_Callback*)cb_CHECKBUTTON_usefullscreen);
          }
          { Fl_Box* o = new Fl_Box(24, 120-y, 300, 20, gettext("Run Tux Paint in fullscreen mode, rather than in a window."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Check_Button* o = CHECKBUTTON_native = new Fl_Check_Button(54, 134-y, 270, 30, gettext("&Native"));
            o->down_box(FL_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(54, 162-y, 270, 20, gettext("Use native screen resolution in fullscreen mode."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Choice* o = CHOICE_windowwidth = new Fl_Choice(24, 200-y, 150, 32, gettext("Window size : "));
            o->down_box(FL_BORDER_BOX);
            o->align(FL_ALIGN_TOP_LEFT);

	    int i;
	    for (i = 0; i < NUM_WINDOW_WIDTHS; i++)
	    {
	      o->add(window_widths[i], "", NULL, NULL, 0);
	    }

	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Choice* o = CHOICE_windowheight = new Fl_Choice(174, 200-y, 150, 32, "");
            o->down_box(FL_BORDER_BOX);
            o->align(FL_ALIGN_TOP_LEFT);

	    int i;
	    for (i = 0; i < NUM_WINDOW_HEIGHTS; i++)
	    {
	      o->add(window_heights[i], "", NULL, NULL, 0);
	    }

	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 236-y, 300, 36, gettext("Size of the window, or the resolution in fullscreen."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Check_Button* o = CHECKBUTTON_rotate = new Fl_Check_Button(24, 252-y, 300, 32, gettext("&Rotate Orientation"));
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 278-y, 300, 36, gettext("Swap width and height, to rotate 90 degrees (useful for portrait-display on a tablet PC)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Check_Button* o = CHECKBUTTON_screensaver = new Fl_Check_Button(24, 300-y, 300, 32, gettext("Allow S&creensaver"));
            o->down_box(FL_DOWN_BOX);
            o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 326-y, 300, 36, gettext("Don't disable your system's screensaver while Tux Paint is running."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_sound = new Fl_Group(340, 70-y, 324, 120, gettext("Sound :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_soundeffects = new Fl_Check_Button(360, 96-y, 292, 30, gettext("Enable &Sound Effects"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80073);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(360, 126-y, 292, 36, gettext("Enable/disable sound effects."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_colorfile = new Fl_Group(340, 195-y, 323, 165, gettext("Color Palette File :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usecolorfile = new Fl_Check_Button(350, 221-y, 302, 28, gettext("Use &Alternative Color Palette"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usecolorfile);
          }
          { Fl_Box* o = new Fl_Box(352, 249-y, 300, 30, gettext("Don't use default color palette, use colors defined in the following file:"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_File_Input* o = FILEINPUT_colorfile = new Fl_File_Input(352, 305-y, 218, 40, gettext("Color Palette File :"));
            o->align(69);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Button* o = BUTTON_browsecolorfile = new Fl_Button(576, 316-y, 77, 29, gettext("Browse..."));
            o->shortcut(0x80062);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_BUTTON_browsecolorfile);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_mouseandkeyboard = new Fl_Group(5, 64-y, 665, 306, gettext("Mouse & Keyboard"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)2);
        o->selection_color((Fl_Color)2);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_mouse = new Fl_Group(12, 70-y, 323, 290, gettext("Cursor :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_fancycursorshapes = new Fl_Check_Button(24, 96-y, 300, 25, gettext("&Fancy Cursor Shapes"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80066);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 121-y, 300, 45, gettext("Change the shape of the mouse pointer depending on where the mouse is and what you are doing."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Check_Button* o = CHECKBUTTON_hidecursor = new Fl_Check_Button(24, 170-y, 300, 25, gettext("&Hide Cursor"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80066);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 195-y, 300, 45, gettext("Completely hides cursor (useful on touchscreen devices)."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_keyboard = new Fl_Group(340, 70-y, 324, 84, gettext("Keyboard :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_enablekbd = new Fl_Check_Button(352, 96-y, 300, 30, gettext("Enable &Keyboard Shortcuts"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x8006b);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 121-y, 300, 54, gettext("Allows key combinations to be used as shortcuts for certain commands. (e.g., Control+S to Save)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_keyboard = new Fl_Group(340, 160-y, 324, 200, gettext("Mouse :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_grabmousepointer = new Fl_Check_Button(352, 186-y, 300, 25, gettext("&Grab Mouse Pointer"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80067);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 211-y, 300, 30, gettext("Prevents the mouse pointer from leaving the Tux Paint window."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_mousewheelsupport = new Fl_Check_Button(352, 235-y, 300, 25, gettext("Mouse &Wheel Support"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80077);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 260-y, 300, 30, gettext("Allows a mouse wheel to be used to scroll through items. (e.g., brushes, stamps)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_nobuttondistinction = new Fl_Check_Button(352, 295-y, 300, 25, gettext("No &Button Distinction"));
            o->down_box(FL_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 320-y, 300, 30, gettext("Allows middle and right mouse buttons to be used for clicking, too."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }

      { Fl_Group* o = TABE_simplification = new Fl_Group(5, 64-y, 665, 306, gettext("Simplification"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)3);
        o->selection_color((Fl_Color)3);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_interfacesimpl = new Fl_Group(10, 70-y, 326, 290, gettext("Interface Simplification :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_disableshaperotation = new Fl_Check_Button(24, 96-y, 300, 30, gettext("Disable Shape &Rotation"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80072);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 126-y, 300, 54, gettext("Shape tool's rotation step is disabled. Useful for younger children."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_simpleshapeoutlines = new Fl_Check_Button(24, 180-y, 300, 30, gettext("Simple Stamp &Outlines"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x8006f);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 210-y, 300, 54, gettext("Draw a rectangle around the cursor when placing stamps, rather than a detailed outline. (For slow computers and thin clients.)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_showuppercasetextonly = new Fl_Check_Button(24, 264-y, 300, 30, gettext("Show &Uppercase Text Only"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80075);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 294-y, 300, 54, gettext("Cause all text in Tux Paint (button labels, dialogs, etc.) to appear in UPPERCASE rather than Mixed Case."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_controlsimpl = new Fl_Group(340, 70-y, 323, 215, gettext("Control Simplification :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_disablequitbutton = new Fl_Check_Button(352, 96-y, 300, 30, gettext("Disable \'&Quit\' Button and [Escape] key"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80071);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 126-y, 300, 54, gettext("Clicking the window\'s close (X) button in the title bar, or pressing [Alt]+[F4] or [Shift]+[Ctrl]+[Escape] will still quit Tux Paint."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_disablestampstool = new Fl_Check_Button(352, 165-y, 300, 30, gettext("Disable \'&Stamps\' Tool"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80073);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 195-y, 300, 54, gettext("Do not load stamps at startup, thus disabling the Stamps tool."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_disablestampcontrols = new Fl_Check_Button(352, 220-y, 300, 30, gettext("Disable Stamp &Controls"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80063);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 250-y, 300, 54, gettext("Simplify the \'Stamps\' tool by removing the stamp control buttons (Shrink, Grow, Mirror and Flip)."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_stampsize = new Fl_Group(340, 290-y, 323, 70, gettext("Initial Stamp Size :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Slider* o = SLIDER_stampsize = new Fl_Slider(352, 310-y, 300, 20, "");
	    o->type(FL_HORIZONTAL);
	    o->range(-1, 10);
            o->value(-1);
	    o->slider_size(0.1);
            o->label("Default (no override)");
	    o->callback((Fl_Callback*)cb_SLIDER_stampsize);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_locale = new Fl_Group(5, 64-y, 665, 306, gettext("Languages"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)4);
        o->selection_color((Fl_Color)4);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_locale = new Fl_Group(12, 70-y, 323, 290, gettext("Language :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Choice* o = CHOICE_language = new Fl_Choice(20, 118-y, 300, 32, gettext("Language : "));
            o->down_box(FL_BORDER_BOX);
            o->align(FL_ALIGN_TOP_LEFT);
	    /* FIXME: Perhaps we can load these from Tux Paint itself using
	       a special command-line option? */
	    /* FIXME: The labels should all be wrapped in 'gettext()' calls */

	    int i;
	    for (i = 0; i < NUM_LANGS; i++)
	    {
	      o->add(langs[i][LANG_NAME], "", NULL, NULL, 0);
	    }

	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(20, 162-y, 300, 54, gettext("Run Tux Paint in a particular language (overriding system's settings)."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_mirrorstamps = new Fl_Check_Button(20, 228-y, 300, 32, gettext("&Mirror Stamps"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x8006d);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(20, 270-y, 300, 54, gettext("Automatically mirror-image all mirror-able stamps. Useful for users who prefer things appearing right-to-left."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_locale = new Fl_Group(340, 70-y, 323, 290, gettext("Fonts :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_loadsystemfonts = new Fl_Check_Button(350, 96-y, 302, 28, gettext("Load System &Fonts"));
            o->down_box(FL_DOWN_BOX);
	    o->value(0);
            o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 126-y, 300, 54, gettext("Attempt to load more fonts, found elsewhere on your computer. (Note: may cause instability!)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
	  o->end();
	}
        o->end();
      }
      { Fl_Group* o = TABE_printing = new Fl_Group(5, 64-y, 665, 306, gettext("Printing"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)5);
        o->selection_color((Fl_Color)5);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_printperms = new Fl_Group(12, 70-y, 323, 140, gettext("Print Permissions :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_allowprinting = new Fl_Check_Button(24, 90-y, 300, 24, gettext("Allow &Printing"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80070);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 110-y, 300, 40, gettext("Let users print from within Tux Paint."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Value_Input* o = VALUEINPUT_printdelay = new Fl_Value_Input(24, 152-y, 50, 29, gettext("Print Delay : "));
            o->maximum(3600);
            o->step(1);
            o->align(FL_ALIGN_TOP_LEFT);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = LABEL_seconds = new Fl_Box(81, 152-y, 244, 29, gettext("seconds"));
            o->box(FL_FLAT_BOX);
            o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
          }
          { Fl_Box* o = new Fl_Box(24, 182-y, 300, 40, gettext("Restrict printing to once every N seconds. (Enter '0' to allow unrestricted printing.)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
	}

        { Fl_Group* o = GROUP_printperms = new Fl_Group(12, 215-y, 323, 145, gettext("Show Printer Dialog :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);

          { Fl_Round_Button* o = ROUNDBUTTON_printdialogmod = new Fl_Round_Button(24, 235-y, 300, 24, gettext("Only when [Alt] &modifier key is held"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->shortcut(0x80061);
	    o->callback((Fl_Callback*)cb_status_chng);
          }

          { Fl_Round_Button* o = ROUNDBUTTON_printdialogalways = new Fl_Round_Button(24, 260-y, 300, 24, gettext("Always &show printer dialog"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->shortcut(0x80061);
	    o->callback((Fl_Callback*)cb_status_chng);
          }

          { Fl_Round_Button* o = ROUNDBUTTON_printdialognever = new Fl_Round_Button(24, 285-y, 300, 24, gettext("&Never show printer dialog"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->shortcut(0x80061);
	    o->callback((Fl_Callback*)cb_status_chng);
          }

          { Fl_Box* o = new Fl_Box(24, 310-y, 300, 24, gettext("(Even when [Alt] is held.)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          o->end();
        }


        { Fl_Group* o = GROUP_printcmd = new Fl_Group(340, 70-y, 323, 290, gettext("Print Commands :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealtprintcmd = new Fl_Check_Button(350, 90-y, 302, 24, gettext("Use &Alternative Print Command"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealtprintcmd);
          }
          { Fl_Box* o = new Fl_Box(352, 110-y, 300, 48, gettext("Override Tux Paint's default setting for print command ('lpr') with another. (Advanced! Unix/Linux only!)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Input* o = TEXTINPUT_printcmd = new Fl_Input(352, 140-y, 300, 29, ""); // gettext("Alternative Print Command : "));
            o->align(FL_ALIGN_TOP_LEFT);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 170-y, 300, 24, gettext("Enter the command for printing. It must accept a PostScript format on its standard input (STDIN)."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();


          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealtprintdia = new Fl_Check_Button(350, 200-y, 302, 24, gettext("Use &Alternative Print Dialog"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealtprintdia);
          }
          { Fl_Box* o = new Fl_Box(352, 220-y, 300, 48, gettext("Override Tux Paint's default setting for print dialog ('kprinter') with another. (Advanced! Unix/Linux only!)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Input* o = TEXTINPUT_printdia = new Fl_Input(352, 248-y, 300, 29, ""); // gettext("Alternative Print Dialog Command : "));
            o->align(FL_ALIGN_TOP_LEFT);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 274-y, 300, 48, gettext("Enter the print dialog command. It must accept a PostScript format on its standard input (STDIN)."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
       
#if USE_PAPERSIZES
          { Fl_Choice* o = CHOICE_papersize = new Fl_Choice(352, 320-y, 300, 29, gettext("Paper Size : "));
            o->down_box(FL_BORDER_BOX);
            o->align(FL_ALIGN_TOP_LEFT);

	    int i;
	    for (i = 0; i < num_papersizes; i++)
	    {
	      o->add(papersizes[i], "", NULL, NULL, 0);
	    }
            o->align(FL_ALIGN_TOP_LEFT);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
#endif
	  o->end();
	}

        o->end();
      }

      { Fl_Group* o = TABE_saving = new Fl_Group(5, 64-y, 665, 306, gettext("Saving"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)6);
        o->selection_color((Fl_Color)6);
        o->align(37);
        o->hide();

        { Fl_Group* o = GROUP_saveover = new Fl_Group(12, 70-y, 323, 200, gettext("Save Over Earlier Work :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Round_Button* o = ROUNDBUTTON_askbeforeoverwriting = new Fl_Round_Button(24, 96-y, 300, 28, gettext("&Ask Before Overwriting"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 120-y, 300, 30, gettext("When re-saving an image, ask whether to overwrite the earlier version, or make a new file."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Round_Button* o = ROUNDBUTTON_alwaysoverwriteolderversion = new Fl_Round_Button(24, 150-y, 300, 28, gettext("Always &Overwrite Older Version"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 174-y, 300, 30, gettext("When re-saving an image, always overwrite the earlier version. (Warning: Potential for lost work!)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Round_Button* o = ROUNDBUTTON_alwayssavenewpicture = new Fl_Round_Button(24, 204-y, 300, 28, gettext("Always Save &New Picture"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 228-y, 300, 30, gettext("When re-saving an image, always make a new file. (Warning: Potential for lots of files!)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
	{ Fl_Group* o = GROUP_startblank = new Fl_Group(12, 275-y, 323, 85, gettext("Start Blank :"));
	  o->box(FL_PLASTIC_UP_BOX);
	  o->labeltype(FL_EMBOSSED_LABEL);
	  o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	  {
	    Fl_Check_Button* o = CHECKBUTTON_startblank = new Fl_Check_Button(24, 301-y, 300, 28, gettext("Start with &Blank Canvas"));
            o->down_box(FL_DOWN_BOX);
            //o->shortcut(0x80071); // What should this be?
	    o->callback((Fl_Callback*)cb_status_chng);
          }
	  // FIXME: Add some descriptive text
          o->end();
	}
        { Fl_Group* o = GROUP_savedir = new Fl_Group(340, 70-y, 323, 160, gettext("Save Directory :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealternatesavedir = new Fl_Check_Button(350, 96-y, 302, 28, gettext("Use &Alternative Save Directory"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealternatesavedir);
          }
          { Fl_Box* o = new Fl_Box(352, 124-y, 300, 30, gettext("Do not save pictures in the standard directory, use the following location:"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_File_Input* o = FILEINPUT_alternatesavedir = new Fl_File_Input(352, 180-y, 218, 40, gettext("Alternative Save Directory :"));
            o->align(69);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Button* o = BUTTON_browsealternatesavedir = new Fl_Button(576, 191-y, 77, 29, gettext("Browse..."));
            o->shortcut(0x80062);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_BUTTON_browsealternatesavedir);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_nosave = new Fl_Group(340, 235-y, 323, 125, gettext("More Saving Options :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
	
          { Fl_Check_Button* o = CHECKBUTTON_disablesavebutton = new Fl_Check_Button(352, 260-y, 300, 28, gettext("Disable \'&Save\' Button"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80071);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 285-y, 300, 54, gettext("Don't allow pictures to be saved. Tux Paint acts as temporary \'scratch paper.\'"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

          { Fl_Check_Button* o = CHECKBUTTON_autosave = new Fl_Check_Button(352, 305-y, 300, 28, gettext("&Auto-save on Quit"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80071);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 328-y, 300, 54, gettext("Don't ask to save current picture when quitting; just save."));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }

	  o->end();
	}
        o->end();
      }
      { Fl_Group* o = TABE_data = new Fl_Group(5, 64-y, 665, 306, gettext("Data"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)7);
        o->selection_color((Fl_Color)7);
        o->align(37);
        o->hide();

	/* FIXME: Looks awful: */
        { Fl_Group* o = GROUP_lockfile = new Fl_Group(12, 70-y, 323, 160, gettext("Lockfile :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_nolockfile = new Fl_Check_Button(22, 96-y, 302, 28, gettext("&Don't use lockfile"));
            o->down_box(FL_DOWN_BOX);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 124-y, 300, 50, gettext("Do not check for a lockfile. Allow Tux Paint to be launched multiple times. (May be necessary in a networked environment.)"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
	}

	/* FIXME: Looks awful: */
        { Fl_Group* o = GROUP_datadir = new Fl_Group(340, 70-y, 323, 160, gettext("Data Directory :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealternatedatadir = new Fl_Check_Button(350, 96-y, 302, 28, gettext("Use &Alternative Data Directory"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealternatedatadir);
          }
          { Fl_Box* o = new Fl_Box(352, 124-y, 300, 30, gettext("Do not load brushes, stamps, etc. from the standard directory, use the following location:"));
            o->labelfont(FL_ITALIC);
            o->labelsize(10);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_File_Input* o = FILEINPUT_alternatedatadir = new Fl_File_Input(352, 180-y, 218, 40, gettext("Alternative Data Directory :"));
            o->align(69);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Button* o = BUTTON_browsealternatedatadir = new Fl_Button(576, 191-y, 77, 29, gettext("Browse..."));
            o->shortcut(0x80062);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_BUTTON_browsealternatedatadir);
          }
          o->end();
        }
        o->end();
      }
      o->end();
    } 
    { Fl_Choice* o = CHOICE_settings = new Fl_Choice(10, 398-y, 120, 22, gettext("Settings for : "));
      o->down_box(FL_BORDER_BOX);
      o->align(FL_ALIGN_TOP_LEFT);
      
      o->add("Current User", "", NULL, NULL, 0);
      o->add("All Users", "", NULL, NULL, 0);
      
      o->value(CURRENT_USER);
      
      o->callback((Fl_Callback*)cb_CHOICE_settings);
    } 
    { Fl_Check_Button* o = CHECKBUTTON_usealluserssettings = new Fl_Check_Button(140, 398-y, 180, 22, gettext("Use \"All Users\" Settings"));
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_CHECKBUTTON_usealluserssettings);
    }   
    { Fl_Button* o = BUTTON_apply = new Fl_Button(340, 388-y, 75, 32, gettext("Apply"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(FL_BOLD);
      o->align(FL_ALIGN_CLIP);
      o->callback((Fl_Callback*)cb_BUTTON_apply);
      o->deactivate();
    }
    { Fl_Button* o = BUTTON_reset = new Fl_Button(420, 388-y, 75, 32, gettext("Reset"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(FL_BOLD);
      o->callback( (Fl_Callback*)cb_BUTTON_reset );
      o->align(FL_ALIGN_CLIP);
    }
    { Fl_Button* o = BUTTON_defaults = new Fl_Button(500, 388-y, 75, 32, gettext("Defaults"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(FL_BOLD);
      o->callback((Fl_Callback*)cb_BUTTON_defaults);
      o->align(FL_ALIGN_CLIP);
    }
    { Fl_Button* o = BUTTON_quit = new Fl_Button(590, 388-y, 75, 32, gettext("Quit"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(FL_BOLD);
      o->callback((Fl_Callback*)confirm_exit_cb);
      o->align(FL_ALIGN_CLIP);
    }
    o->end();
  }
  
  
  /* It's kluge to do this here; sorry -bjk 2004-09-04 */

  load_conf();


  /* Show the window: */

#ifdef WIN32
  // must set the icon before calling show()
  WINDOW_tpc->icon((char *)LoadIcon(fl_display, MAKEINTRESOURCE(IDI_ICON1)));
#endif

  WINDOW_tpc -> show ();
  return w;
}
