/*
 * Copyright 2001 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VOIP_H
#define VOIP_H

struct voip_hdr {
	u_int8_t magic[2];
	u_int16_t id;
	u_int32_t seqnr;
	u_int32_t magicnr;
};

#define VOIP_IE_CON	0x04
#define		VOIP_CON_ALIVE	0x00
#define		VOIP_CON_PICKUP	0x06
#define		VOIP_CON_HANGUP	0x07
#define VOIP_IE_USER	0x08
#define		VOIP_USER_DIAL	0x03
#define VOIP_IE_DISPLAY	0x28
#define		VOIP_DISPLAY_STATUS	0x99

struct voip_signal {
	u_int8_t proto;
	u_int8_t fill1[7];
	u_int8_t cmd;
	u_int8_t fill2[2];
	u_int8_t plen;
};

void	voip_init(void);

struct pcap_pkthdr;
void	voip_sniff(u_char *, const struct pcap_pkthdr *, const u_char *);

#endif /* VOIP_H */
