/* $Id: frame.c,v 1.12 2000/04/06 01:25:00 aito Exp $ */
#include "fm.h"
#include "parsetag.h"
#include "myctype.h"
#include <signal.h>
#include <setjmp.h>

#ifdef KANJI_SYMBOLS
#define RULE_WIDTH 2
#else /* not KANJI_SYMBOLS */
#define RULE_WIDTH 1
#endif /* not KANJI_SYMBOLS */

static JMP_BUF  AbortLoading;
static int frameFileSeq;

static          MySignalHandler
KeyAbort(SIGNAL_ARG)
{
  LONGJMP(AbortLoading, 1);
}

struct frameset*
newFrameSet(struct parsed_tagarg *arg)
{
  struct parsed_tagarg *t;
  struct frameset *f;
  int i;
  char *cols = NULL, *rows = NULL, *p, *q;
  char *length[100];

  f = New(struct frameset);
  f->attr = F_FRAMESET;
  f->name = NULL;
  for (t = arg; t; t = t->next) {
    if (!strcasecmp(t->arg,"cols") && t->value)
      cols = t->value;
    else if (!strcasecmp(t->arg,"rows") && t->value)
      rows = t->value;
  }
  i = 0;
  if (cols) {
    length[i] = p = cols;
    while (*p != '\0')
      if (*p++ == ',')
	length[++i] = p;
    length[++i] = p + 1;
  }
  if (i > 1) {
    f->col = i;
    f->width = New_N(char*, i);
    p = length[i];
    do {
      i--;
      q = p - 2;
      p = length[i];
      switch (*q) {
	Str tmp;
      case '%':
	f->width[i] = allocStr(p, q - p + 1);
	break;
      case '*':
	f->width[i] = "*";
	break;
      default:
	tmp = Sprintf("%d", atoi(p));
	f->width[i] = tmp->ptr;
	break;
      }
    } while (i);
  } else {
    f->col = 1;
    f->width = New_N(char*,1);
    f->width[0] = "*";
  }
  i = 0;
  if (rows) {
    length[i] = p = rows;
    while (*p != '\0')
      if (*p++ == ',')
	length[++i] = p;
    length[++i] = p + 1;
  }
  if (i > 1) {
    f->row = i;
    f->height = New_N(char*, i);
    p = length[i];
    do {
      i--;
      q = p - 2;
      p = length[i];
      f->height[i] = allocStr(p, q - p + 1);
    } while (i);
  } else {
    f->row = 1;
    f->height = New_N(char*,1);
    f->height[0] = "*";
  }
  i = f->row * f->col;
  f->i = 0;
  f->frame = New_N(union frameset_element, i);
  do {
    i--;
    f->frame[i].element = NULL;
  } while (i);
  return f;
}

void
addFrame(struct frameset *f, struct parsed_tagarg *arg)
{
  struct parsed_tagarg *t;
  struct frame_body *body;

  if (f == NULL || f->i >= f->col * f->row)
    return;

  body = New(struct frame_body);
  body->attr = F_UNLOADED;
  body->name = NULL;
  body->url = NULL;
  body->source = NULL;
  body->referer = NULL;
  body->request = NULL;
  body->flags = 0;
  for (t = arg; t; t = t->next) {
    if (!strcasecmp(t->arg,"src") && t->value)
      body->url = t->value;
    else if (!strcasecmp(t->arg,"name") && t->value && *t->value != '_')
      body->name = t->value;
  }
  f->frame[f->i].body = body;
  f->i++;
}

void
deleteFrame(struct frame_body *b)
{
  if (b == NULL)
    return;
  if (b->source && b->flags & FB_TODELETE)
    pushText(fileToDelete,b->source);
  b->source = NULL;
  b->flags = 0;
  b->attr = F_UNLOADED;
  return;
}

void
addFrameSet(struct frameset *f, struct frameset *fset)
{
  int i;

  if (f == NULL) return;
  i = f->i;
  if (i >= f->col * f->row) return;
  f->frame[i].set = fset;
  f->i++;
}

void
deleteFrameSet(struct frameset *f)
{
  int i;

  if (f == NULL)
    return;
  for (i = 0; i < f->col * f->row; i++) {
    deleteFrameSetElement(f->frame[i]);
  }
  return;
}

void
deleteFrameSetElement(union frameset_element e)
{
  if (e.element == NULL)
    return;
  switch (e.element->attr) {
  case F_UNLOADED:
    break;
  case F_BODY:
    deleteFrame(e.body);
    break;
  case F_FRAMESET:
    deleteFrameSet(e.set);
    break;
  default:
    break;
  }
  return;
}

static struct frame_body *
copyFrame (struct frame_body *ob)
{
  struct frame_body *rb;

  rb = New(struct frame_body);
  bcopy((const void *) ob, (void *) rb, sizeof(struct frame_body));
  rb->flags &= ~FB_TODELETE;
  return rb;
}

struct frameset *
copyFrameSet (struct frameset *of)
{
  struct frameset *rf;
  int n;

  rf = New(struct frameset);
  n = of->col * of->row;
  bcopy((const void *) of, (void *) rf, sizeof(struct frameset));
  rf->width = New_N(char *, rf->col);
  bcopy((const void *) of->width,
	(void *) rf->width,
	sizeof(char *) * n);
  rf->height = New_N(char*, rf->row);
  bcopy((const void *) of->height,
	(void *) rf->height,
	sizeof(char *) * n);
  rf->frame = New_N(union frameset_element, n);
  while (n) {
    n--;
    if (!of->frame[n].element)
      goto attr_default;
    switch (of->frame[n].element->attr) {
    case F_UNLOADED:
    case F_BODY:
      rf->frame[n].body = copyFrame(of->frame[n].body);
      break;
    case F_FRAMESET:
      rf->frame[n].set = copyFrameSet(of->frame[n].set);
      break;
    default:
      attr_default:
      rf->frame[n].element = NULL;
      break;
    }
  }
  return rf;
}

void
pushFrameTree(struct frameset_queue **fqpp, struct frameset *fs)
{
  struct frameset_queue *rfq, *cfq = *fqpp;

  if (!fs)
    return;

  rfq = New(struct frameset_queue);
  rfq->back = cfq;
  if (cfq) {
    rfq->next = cfq->next;
    if (cfq->next)
      cfq->next->back = rfq;
    cfq->next = rfq;
  } else
    rfq->next = cfq;
  rfq->frameset = fs;
  *fqpp = rfq;
  return;
}

struct frameset *
popFrameTree(struct frameset_queue **fqpp)
{
  struct frameset_queue *rfq = NULL, *cfq = *fqpp;
  struct frameset *rfs = NULL;

  if (!cfq)
    return rfs;

  rfs = cfq->frameset;
  if (cfq->next) {
    (rfq = cfq->next)->back = cfq->back;
  }
  if (cfq->back) {
    (rfq = cfq->back)->next = cfq->next;
  }
  *fqpp = rfq;
  bzero((void *)cfq, sizeof(struct frameset_queue));
  return rfs;
}

void
resetFrameElement(union frameset_element *f_element,
		  Buffer *buf,
		  char *referer,
		  FormList *request)
{
  char *f_name;
  struct frame_body *f_body;

  f_name = f_element->element->name;
  if (buf->frameset) {
    /* frame cascade */
    deleteFrameSetElement(*f_element);
    f_element->set = buf->frameset;
    /* buf->frameset = popFrameTree(&(buf->frameQ)); */
    /* f_element->set->name = f_name; */
  } else {
    f_body = copyFrame(f_element->body);
    deleteFrameSetElement(*f_element);
    f_body->name = f_name;
    f_body->url = parsedURL2Str(&buf->currentURL)->ptr;
    f_body->flags = 0;
    if (buf->real_scheme == SCM_LOCAL) {
      f_body->source = buf->sourcefile;
    } else {
      Str tmp = Sprintf("%s/w3mframe%d.%d", rc_dir, getpid(), frameFileSeq++);
      rename(buf->sourcefile, tmp->ptr);
      f_body->source = tmp->ptr;
      f_body->flags |= FB_TODELETE;
      buf->sourcefile = NULL;
    }
    f_body->referer = referer;
    f_body->request = request;
    f_element->body = f_body;
  }
}
  
static char *prohibit_tags[] = {
  "html","head","body","/html","/head","/body",
  "meta","doctype","base",
  NULL
};

static char *table_tags[] = {
  "td", "/td", "tr", "/tr", "th", "/th",
  NULL
};

static struct frameset *
frame_download_source(struct frame_body *b, Buffer *current)
{
  Buffer *buf;
  struct frameset *ret_frameset = NULL;
  Str tmp;
  ParsedURL url;
  int flag = 0;

  if (b == NULL || b->url == NULL || b->url[0] == '\0')
    return NULL;
  parseURL2(b->url,&url,&current->currentURL);
  switch (url.scheme) {
  case SCM_LOCAL:
    b->source = url.file;
    b->flags = 0;
  default:
    buf = loadGeneralFile(b->url,
			  baseURL(current),
			  b->referer,
			  flag,
			  b->request);
    break;
  }
			
  if (buf == NULL || buf == NO_BUFFER) {
    b->source = NULL;
    b->flags = 0;
    return NULL;
  }
  if (buf->firstLine == NULL) {
    discardBuffer(buf);
    return NULL;
  }
  b->url = parsedURL2Str(&buf->currentURL)->ptr;
  if (buf->real_scheme != SCM_LOCAL) {
    tmp = Sprintf("%s/w3mframe%d.%d",rc_dir,getpid(),frameFileSeq++);
    rename(buf->sourcefile,tmp->ptr);
    b->source = tmp->ptr;
    b->flags |= FB_TODELETE;
    buf->sourcefile = NULL;
  }
  b->attr = F_BODY;
  if (buf->frameset) {
    ret_frameset = buf->frameset;
    ret_frameset->name = b->name;
    buf->frameset = popFrameTree(&(buf->frameQ));
  }
  discardBuffer(buf);
  return ret_frameset;
}

static int
createFrameFile(struct frameset *f, FILE *f1, Buffer *current, int level)
{
  int r, c, status, pre, a_target, is_anchor, t_stack;
  FILE *f2;
  Str tmp,tok,continuation;
  char code;
  char *p, *d_target, *p_target, *s_target, *t_target;
  ParsedURL base;
  MySignalHandler (*prevtrap)(SIGNAL_ARG) = NULL;

  if (f == NULL)
    return -1;

  if (level == 0) {
    if (SETJMP(AbortLoading) != 0) {
      if (fmInitialized)
        term_raw();
      signal(SIGINT, prevtrap);
      return -1;
    }
    prevtrap = signal(SIGINT, KeyAbort);
    if (fmInitialized)
      term_cbreak();

    f->name = "_top";
  }

  if (level > 7) {
    fputs("Too many frameset tasked.\n", f1);
    return -1;
  }

  if (level == 0) {
    fprintf(f1, "<html><head><title>%s</title></head><body>\n",
	    current->buffername);
    fputs("<table hborder width=\"100%\">\n", f1);
  }
  else 
    fputs("<table hborder>\n", f1);
  tok = Strnew();
  continuation = Strnew();
  status = R_ST_NORMAL;
  pre = 0;
  for (r = 0; r < f->row; r++) {
    fputs("<tr>\n", f1);
    for (c = 0; c < f->col; c++) {
      union frameset_element frame;
      struct frameset *f_frameset;
      int i = c + r * f->col;

      frame = f->frame[i];
      if (!r) {
        fprintf(f1, "<td width=\"%s\">\n", f->width[c]);
      }
      else {
        fputs("<td>\n", f1);
      }
      if (frame.element == NULL) {
	fputs("</td>\n", f1);
	continue;  
      }
      switch (frame.element->attr) {
      default:
	fprintf(f1, "Frameset %s: Illegal frame description", f->name);
	break;
      case F_UNLOADED:
	if (!frame.body->name && f->name) {
	  frame.body->name = Sprintf("%s_%d", f->name, i)->ptr;
	}
	f_frameset = frame_download_source(frame.body, current);
	if (f_frameset) {
	  deleteFrame(frame.body);
	  f->frame[i].set = frame.set = f_frameset;
	  goto render_frameset;
	}
 	/* fall through */
       case F_BODY:
 	f2 = NULL;
 	if (frame.body->source == NULL ||
 	    (f2 = fopen(frame.body->source,"r")) == NULL) {
 	  frame.body->attr = F_UNLOADED;
 	  fprintf(f1, "Can't open %s", frame.body->url);
 	  break;
 	}
 	parseURL2(frame.body->url, &base, &current->currentURL);
	p_target = f->name;
	s_target = frame.body->name;
	t_target = "_blank";
	d_target = TargetSelf ? s_target : t_target;
	code = 0;
 	t_stack = 0;
	while (1) {
	  tmp = Strmyfgets(f2);
	  if (tmp->length == 0) break;
#ifdef JP_CHARSET
	  code = checkShiftCode(tmp->ptr,code);
	  if (code != '\0' && code != InnerCode) {
	    tmp = conv(tmp->ptr,code,InnerCode);
	  }
#endif /* JP_CHARSET */
	  if (pre)
	    Strchop(tmp);
	  p = tmp->ptr;
	  while (read_token(tok,&p,&status,pre,0)) {
	    if (continuation->length > 0) {
	      Strcat(continuation,tok);
	      tok = continuation;
	      continuation = Strnew();
	    }
	    if (status != R_ST_NORMAL) {
	      if (Strlastchar(tok) == '\n') {
		Strchop(tok);
	      }
	      if (ST_IS_REAL_TAG(status)) {
		Strcat_char(tok,' ');
	      }
	      continuation = tok;
	      tok = Strnew();
	      break;
	    }
	    if (tok->ptr[0] == '<') {
	      struct parsed_tagarg *targ,*t;
	      Str tagname = Strnew();
	      int j;
	      ParsedURL url;

	      for (j = 1; 
		   j < tok->length && !IS_SPACE(tok->ptr[j]) && tok->ptr[j] != '>'; 
		   j++) {
		Strcat_char(tagname,tok->ptr[j]);
	      }
	      if (!strcasecmp(tagname->ptr,"base")) {
		targ = parse_tag(tok->ptr);
		for (t = targ; t; t = t->next) {
		  if (!strcasecmp(t->arg,"href") && t->value)
		    parseURL(t->value,&base,NULL);
		  else if (!strcasecmp(t->arg,"target") && t->value) {
		    if (!strcasecmp(t->value,"_self"))
		      d_target = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      d_target = p_target;
		    else
		      d_target = t->value;
		  }
		}
	      }
	      if (!strcasecmp(tagname->ptr,"title")) {
		fprintf(f1,"<!-- title:");
		continue;
	      }
	      else if (!strcasecmp(tagname->ptr,"/title")) {
		fprintf(f1,"-->");
		continue;
	      }
	      else if (strcasemstr(tagname->ptr,prohibit_tags,NULL) >= 0) {
		Strshrinkfirst(tok,j);
		Strshrink(tok,1);
		fprintf(f1,"<!-- %s %s -->",tagname->ptr,tok->ptr);
		continue;
	      }
	      else if (!strcasecmp(tagname->ptr, "/table")) {
		if (--t_stack < 0) {
		  t_stack = 0;
		  fputs("<!-- /table -->", f1);
		  continue;
		}
	      }
	      else if (!t_stack &&
		       strcasemstr(tagname->ptr, table_tags, NULL) >= 0) {
		fprintf(f1,"<!-- %s %s -->",tagname->ptr,tok->ptr);
		continue;
	      }
	      else if (!strcasecmp(tagname->ptr, "table"))
		t_stack++;
 
	      targ = parse_tag(tok->ptr);
	      if (!strcasecmp(tagname->ptr,"pre")) {
		pre = 1;
		tmp = Strnew_charp(p);
		Strchop(tmp);
		p = tmp->ptr;
	      }
	      else if (!strcasecmp(tagname->ptr,"/pre"))
		pre = 0;
 
	      fprintf(f1,"<%s",tagname->ptr);
	      is_anchor = 0;
	      a_target = 0;
	      if (!strcasecmp(tagname->ptr,"a")) {
		is_anchor = 1;
		a_target = 2;
		for (t = targ; t; t = t->next) {
		  if (a_target == 2 && !strcasecmp(t->arg,"href") && t->value)
		    a_target = 1;
		  else if (!strcasecmp(t->arg,"target") && t->value) {
		    a_target = 0;
		    if (!strcasecmp(t->value,"_self"))
		      t->value = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      t->value = p_target;
		    break;
		  }
		}
	      }
	      if (!strcasecmp(tagname->ptr,"form")) {
		a_target = 1;
		for (t = targ; t; t = t->next) {
		  if (!strcasecmp(t->arg,"target") && t->value) {
		    a_target = 0;
		    if (!strcasecmp(t->value,"_self"))
		      t->value = s_target;
		    else if (!strcasecmp(t->value,"_parent"))
		      t->value = p_target;
		    break;
		  }
		}
	      }
	      for (t = targ; t; t = t->next) {
		if ((!strcasecmp(t->arg,"src") || 
		     !strcasecmp(t->arg,"href") ||
		     !strcasecmp(t->arg,"action")) &&
		    t->value) {
		  if (strncasecmp(t->value,"mailto:",7) != 0) {
		    parseURL2(t->value,&url,&base);
		    t->value = htmlquote_str(parsedURL2Str(&url)->ptr);
		    if (code != '\0')
		      fprintf(f1," CHARSET=\"%c\"",code);
		  }
		}
		fprintf(f1," %s",t->arg);
		if (t->value)
		  fprintf(f1,"=\"%s\"",t->value);
	      }
	      if (a_target == 1) {
		/* there is HREF attribute and no TARGET attribute */
		fprintf(f1," TARGET=\"%s\"", d_target);
	      }
	      if (is_anchor)
		fprintf(f1," REFERER=\"%s\"",
			htmlquote_str(parsedURL2Str(&base)->ptr));
	      fprintf(f1,">");
	    }
	    else {
	      fputs(tok->ptr,f1);
	    }
	  }
	  fputc('\n',f1);
	}
	while (t_stack--)
	  fputs("</TABLE>\n", f1);
	fclose(f2);
 	break;
      case F_FRAMESET:
      render_frameset:
        if (!frame.set->name && f->name) {
	  frame.set->name = Sprintf("%s_%d", f->name, i)->ptr;
	}
	createFrameFile(frame.set, f1, current, level+1);
	break;
      }
      fputs("</td>\n", f1);
    }
    fputs("</tr>\n", f1);
  }

  fputs("</table>\n",f1);
  if (level == 0) {
    fputs("</body></html>\n",f1);
    signal(SIGINT,prevtrap);
    if (fmInitialized)
      term_raw();
  }
  return 0;
}

Buffer *
renderFrame(Buffer *Cbuf)
{
  Str tmp;
  FILE *f;
  Buffer *buf;
  int flag;
  struct frameset *fset;

  tmp = Sprintf("%s/w3mframe%d.%lx.html", rc_dir,getpid(),
		(unsigned long)Cbuf->frameQ);
  f = fopen(tmp->ptr,"w");
  if (f == NULL) return NULL;
  /*
  if (Cbuf->frameQ != NULL)
    fset = Cbuf->frameQ->frameset;
  else
  */
    fset = Cbuf->frameset;
  if (fset == NULL || createFrameFile(fset, f, Cbuf, 0) < 0)
    return NULL;
  fclose(f);
  flag = 0;
  if ((Cbuf->currentURL).is_nocache)
    flag |= RG_NOCACHE;  
  buf = loadGeneralFile(tmp->ptr,NULL,NULL,flag,NULL);
  if (buf == NULL) return NULL;
  buf->sourcefile = tmp->ptr;
  buf->bufferprop |= BP_FRAME;
  copyParsedURL(&buf->currentURL,&Cbuf->currentURL);
  return buf;
}

union frameset_element *
search_frame(struct frameset *fset, char *name)
{
  int i;
  union frameset_element *e = NULL;

  for (i = 0; i < fset->col * fset->row; i++) {
    e = &(fset->frame[i]);
    if (e->element != NULL) {
      if (e->element->name && !strcmp(e->element->name, name)) {
	return e;
      } else if (e->element->attr == F_FRAMESET &&
		 (e = search_frame(e->set, name))) {
	return e;
      }
    }
  }
  return NULL;
}
