/*
 * w3m local.h
 */

#ifndef LOCAL_H
#define LOCAL_H

#include <sys/types.h>
#ifdef DIRENT
#include <dirent.h>
typedef struct dirent Directory;
#else /* not DIRENT */
#include <sys/dir.h>
typedef struct direct Directory;
#endif /* not DIRENT */
#include <sys/stat.h>

#ifndef S_IFMT
#define S_IFMT  0170000
#endif /* not S_IFMT */
#ifndef S_IFREG
#define S_IFREG 0100000
#endif /* not S_IFREG */

#define NOT_REGULAR(m)	(((m) & S_IFMT) != S_IFREG)
#define IS_DIRECTORY(m) (((m) & S_IFMT) == S_IFDIR)

#ifndef S_ISDIR
#ifndef S_IFDIR
#define S_IFDIR 0040000
#endif /* not S_IFDIR */
#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#endif /* not S_ISDIR */

#ifdef READLINK
#ifndef S_IFLNK
#define S_IFLNK 0120000
#endif /* not S_IFLNK */
#ifndef S_ISLNK
#define S_ISLNK(m)	(((m) & S_IFMT) == S_IFLNK)
#endif /* not S_ISLNK */
#endif /* not READLINK */

#endif /* not LOCAL_H */
