/* parse HTML tag */
#include "myctype.h"
#include "indep.h"
#include "Str.h"
#include "parsetag.h"

struct parsed_tagarg *
parse_tag(char *argbuf)
{
  char           *p, *q;
  struct parsed_tagarg *tagarg = NULL, *t;

  p = argbuf;
  if (*p == '<') {
    while (*p && !IS_SPACE(*p) && *p != '>')
      p++;
  }
  while (IS_SPACE(*p))
    p++;
  while (1) {
    if (*p == '>' || *p == '\0')
      break;
    q = p;
    while (*p && *p != '=' && !IS_SPACE(*p) && *p != '>')
      p++;
    if (p == q) {
      /* bad tag? */
      p++;
      continue;
    }
    t = New(struct parsed_tagarg);
    t->next = tagarg;
    t->arg = allocStr(q, p - q);
    t->value = NULL;
    while (IS_SPACE(*p))
      p++;
    if (*p == '=') {
      /* get value */
      Str value = Strnew();
      p++;
      while (IS_SPACE(*p))
	p++;
      if (*p == '"') {
	p++;
	while (*p && *p != '"')
	  Strcat_char(value,*p++);
	t->value = cleanup_str(value->ptr);
	if (*p == '"')
	  p++;
      } else if (*p == '\'') {
	p++;
	while (*p && *p != '\'')
	  Strcat_char(value,*p++);
	t->value = cleanup_str(value->ptr);
	if (*p == '\'')
	  p++;
      } else if (*p) {
	while (*p && !IS_SPACE(*p) && *p != '>')
	  Strcat_char(value,*p++);
	t->value = cleanup_str(value->ptr);
      }
    }
    tagarg = t;
  }
  return tagarg;
}

char *
tag_get_value(struct parsed_tagarg *t, char *arg)
{
  for (; t; t = t->next) {
    if (!strcasecmp(t->arg,arg))
      return t->value;
  }
  return NULL;
}

int
tag_exists(struct parsed_tagarg *t, char *arg)
{
  for (; t; t = t->next) {
    if (!strcasecmp(t->arg,arg))
      return 1;
  }
  return 0;
}

struct parsed_tagarg *
cgistr2tagarg(char *cgistr)
{
  Str tag;
  Str value;
  struct parsed_tagarg *t0,*t;

  t = t0 = NULL;
  do {
    t = New(struct parsed_tagarg);
    t->next = t0;
    t0 = t;
    tag = Strnew();
    while (*cgistr && *cgistr != '=' && *cgistr != '&')
      Strcat_char(tag,*cgistr++);
    t->arg = form_unquote(tag)->ptr;
    t->value = NULL;
    if (*cgistr == '\0')
      return t;
    else if (*cgistr == '=') {
      cgistr++;
      value = Strnew();
      while (*cgistr && *cgistr != '&')
	Strcat_char(value,*cgistr++);
      t->value = form_unquote(value)->ptr;
    } else if (*cgistr == '&')
      cgistr++;
  } while (*cgistr);
  return t;
}

