/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorResources;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLConnectAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLDisconnectAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLRunAction;
import org.eclipse.wst.rdb.sqleditor.internal.actions.SQLSetStatementTerminatorAction;

public class SQLEditorActionContributor
extends TextEditorActionContributor {
    protected static final String RUN_MENU_ID = "org.eclipse.ui.run";
    protected static final String RUN_MENU_EXTERNAL_TOOLS_GROUP_ID = "ExternalToolsGroup";
    protected RetargetTextEditorAction fContentAssistProposalAction;
    protected RetargetTextEditorAction fContentAssistTipAction;
    protected RetargetTextEditorAction fContentFormatAction;
    protected RetargetTextEditorAction fRunSQLAction;
    private IPropertyChangeListener fConnectActionListener;
    private IPropertyChangeListener fSetStatementTerminatorActionListener;

    public SQLEditorActionContributor() {
        ResourceBundle bundle = SQLEditorResources.getResourceBundle();
        this.fContentAssistProposalAction = new RetargetTextEditorAction(bundle, "ContentAssistProposal.");
        this.fContentAssistTipAction = new RetargetTextEditorAction(bundle, "ContentAssistTip.");
        this.fContentFormatAction = new RetargetTextEditorAction(bundle, "ContentFormat.");
        this.fRunSQLAction = new RetargetTextEditorAction(bundle, "SQLEditor.runAction.");
    }

    public void contributeToMenu(IMenuManager mm) {
        IMenuManager runMenu;
        IMenuManager editMenu = mm.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.fContentAssistProposalAction);
            editMenu.add((IAction)this.fContentFormatAction);
            editMenu.add((IAction)this.fContentAssistTipAction);
        }
        if ((runMenu = mm.findMenuUsingPath(RUN_MENU_ID)) != null) {
            IContributionItem externalToolsGroupSeperator = runMenu.findUsingPath(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID);
            if (externalToolsGroupSeperator != null) {
                runMenu.insertBefore(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID, (IContributionItem)new Separator());
                runMenu.insertBefore(RUN_MENU_EXTERNAL_TOOLS_GROUP_ID, (IAction)this.fRunSQLAction);
            } else {
                runMenu.add((IContributionItem)new Separator());
                runMenu.add((IAction)this.fRunSQLAction);
            }
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        ITextEditor textEditor = null;
        if (targetEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)targetEditor;
        }
        this.fContentAssistProposalAction.setAction(this.getAction(textEditor, "ContentAssistProposal"));
        this.fContentAssistTipAction.setAction(this.getAction(textEditor, "ContentAssistTip"));
        this.fContentFormatAction.setAction(this.getAction(textEditor, "ContentFormat"));
        this.fRunSQLAction.setAction(this.getAction(textEditor, "SQLEditor.runAction"));
        SQLConnectAction connectAction = (SQLConnectAction)this.getAction(textEditor, "SQLEditor.connectAction");
        SQLDisconnectAction disconnectAction = (SQLDisconnectAction)this.getAction(textEditor, "SQLEditor.disconnectAction");
        SQLRunAction runAction = (SQLRunAction)this.getAction(textEditor, "SQLEditor.runAction");
        SQLSetStatementTerminatorAction setStatementTerminatorAction = (SQLSetStatementTerminatorAction)this.getAction(textEditor, "SQLEditor.setStatementTerminatorAction");
        if (targetEditor instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)targetEditor;
            if (connectAction != null) {
                connectAction.setSQLEditor(sqlEditor);
                if (this.fConnectActionListener != null) {
                    connectAction.removePropertyChangeListener(this.fConnectActionListener);
                }
                this.fConnectActionListener = sqlEditor;
                connectAction.addPropertyChangeListener(this.fConnectActionListener);
            }
            if (disconnectAction != null) {
                disconnectAction.setSQLEditor(sqlEditor);
                if (this.fConnectActionListener != null) {
                    disconnectAction.removePropertyChangeListener(this.fConnectActionListener);
                }
                this.fConnectActionListener = sqlEditor;
                disconnectAction.addPropertyChangeListener(this.fConnectActionListener);
            }
            if (runAction != null) {
                runAction.setSQLEditor(sqlEditor);
            }
            if (setStatementTerminatorAction != null) {
                setStatementTerminatorAction.setSQLEditor(sqlEditor);
                if (this.fSetStatementTerminatorActionListener != null) {
                    setStatementTerminatorAction.removePropertyChangeListener(this.fSetStatementTerminatorActionListener);
                }
                this.fSetStatementTerminatorActionListener = sqlEditor.getSQLStatementSupport();
                setStatementTerminatorAction.addPropertyChangeListener(this.fSetStatementTerminatorActionListener);
            }
        }
    }
}

