/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileEditorInputFactory;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerImpl;
import org.eclipse.wst.rdb.sqleditor.internal.ISQLEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorFileEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorage;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorageEditorInput;

public class SQLEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = "org.eclipse.wst.rdb.sqleditor.SQLEditorInputFactory";
    public static final String ID_FILE_EDITOR_INPUT = "SQLEditorFileEditorInput";
    public static final String ID_STORAGE_EDITOR_INPUT = "SQLEditorStorageEditorInput";
    public static final String KEY_CONN_INFO_NAME = "connInfoName";
    public static final String KEY_DEFAULT_SCHEMA_NAME = "defaultSchemaName";
    public static final String KEY_EDITOR_INPUT_TYPE = "editorInputType";
    public static final String KEY_STORAGE_CONTENT = "storageContent";
    public static final String KEY_STORAGE_NAME = "storageName";

    public IAdaptable createElement(IMemento memento) {
        ISQLEditorInput input = null;
        String editorInputType = memento.getString(KEY_EDITOR_INPUT_TYPE);
        if (editorInputType.equals(ID_FILE_EDITOR_INPUT)) {
            FileEditorInput fileInput;
            IFile fileResource;
            FileEditorInputFactory fileInputFactory = new FileEditorInputFactory();
            IAdaptable adaptable = fileInputFactory.createElement(memento);
            if (adaptable instanceof FileEditorInput && (fileResource = (fileInput = (FileEditorInput)adaptable).getFile()) != null) {
                SQLEditorFileEditorInput sqlFileInput = new SQLEditorFileEditorInput(fileResource);
                ConnectionInfo connInfo = null;
                String connInfoName = memento.getString(KEY_CONN_INFO_NAME);
                if (connInfoName != null) {
                    ConnectionManagerImpl connMgr = ConnectionManagerImpl.INSTANCE;
                    connInfo = connMgr.getConnectionInfo(connInfoName);
                    sqlFileInput.setConnectionInfo(connInfo);
                }
                String defaultSchemaName = memento.getString(KEY_DEFAULT_SCHEMA_NAME);
                sqlFileInput.setDefaultSchemaName(defaultSchemaName);
                input = sqlFileInput;
            }
        } else if (editorInputType.equals(ID_STORAGE_EDITOR_INPUT)) {
            String contentName = memento.getString(KEY_STORAGE_NAME);
            String contentString = memento.getString(KEY_STORAGE_CONTENT);
            SQLEditorStorage storage = new SQLEditorStorage(contentName, contentString);
            SQLEditorStorageEditorInput sqlStorageInput = new SQLEditorStorageEditorInput(storage);
            ConnectionInfo connInfo = null;
            String connInfoName = memento.getString(KEY_CONN_INFO_NAME);
            if (connInfoName != null) {
                ConnectionManagerImpl connMgr = ConnectionManagerImpl.INSTANCE;
                connInfo = connMgr.getConnectionInfo(connInfoName);
                sqlStorageInput.setConnectionInfo(connInfo);
            }
            String defaultSchemaName = memento.getString(KEY_DEFAULT_SCHEMA_NAME);
            sqlStorageInput.setDefaultSchemaName(defaultSchemaName);
            input = sqlStorageInput;
        }
        return input;
    }

    public static void saveState(IMemento memento, SQLEditorFileEditorInput input) {
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_FILE_EDITOR_INPUT);
        FileEditorInputFactory.saveState((IMemento)memento, (FileEditorInput)input);
        ConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoName = connInfo.getName();
            memento.putString(KEY_CONN_INFO_NAME, connInfoName);
        }
        String defaultSchemaName = input.getDefaultSchemaName();
        memento.putString(KEY_DEFAULT_SCHEMA_NAME, defaultSchemaName);
    }

    public static void saveState(IMemento memento, SQLEditorStorageEditorInput input) {
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_STORAGE_EDITOR_INPUT);
        String storageName = null;
        String storageContent = "";
        IStorage storage = input.getStorage();
        if (storage != null) {
            storageName = storage.getName();
            if (storage instanceof SQLEditorStorage) {
                SQLEditorStorage sqlEditorStorage = (SQLEditorStorage)storage;
                storageContent = sqlEditorStorage.getContentsString();
            }
        }
        memento.putString(KEY_STORAGE_NAME, storageName);
        memento.putString(KEY_STORAGE_CONTENT, storageContent);
        ConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoName = connInfo.getName();
            memento.putString(KEY_CONN_INFO_NAME, connInfoName);
        }
        String defaultSchemaName = input.getDefaultSchemaName();
        memento.putString(KEY_DEFAULT_SCHEMA_NAME, defaultSchemaName);
    }
}

