/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.internal.util.IArtifactEditFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;

public abstract class ArtifactEditProviderOperation
extends AbstractDataModelOperation {
    protected ArtifactEdit artifactEdit;
    protected EMFWorkbenchContext emfWorkbenchContext;

    public ArtifactEditProviderOperation() {
    }

    public ArtifactEditProviderOperation(IDataModel model) {
        super(model);
    }

    protected final void initialize(IProgressMonitor monitor) {
        this.emfWorkbenchContext = (EMFWorkbenchContext)WorkbenchResourceHelperBase.createEMFContext((IProject)this.getTargetProject(), null);
        IVirtualComponent component = this.getTargetComponent();
        this.artifactEdit = this.getArtifactEditForModule(component);
        this.doInitialize(monitor);
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    public IVirtualComponent getTargetComponent() {
        return ComponentCore.createComponent(this.getTargetProject());
    }

    private void doInitialize(IProgressMonitor monitor) {
    }

    protected ArtifactEdit getArtifactEditForModule(IVirtualComponent comp) {
        ArtifactEditRegistryReader reader = ArtifactEditRegistryReader.instance();
        IArtifactEditFactory factory = reader.getArtifactEdit(comp.getProject());
        if (factory == null) {
            return null;
        }
        return factory.createArtifactEditForWrite(comp);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public void dispose() {
        if (this.artifactEdit != null) {
            this.artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            this.artifactEdit.dispose();
        }
        super.dispose();
    }

    public final IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block3: {
            try {
                this.initialize(monitor);
                if (!this.validateEdit().isOK()) break block3;
                IStatus iStatus = this.doExecute(monitor, info);
                Object var3_5 = null;
                this.dispose();
                return iStatus;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.dispose();
                throw throwable;
            }
        }
        IStatus iStatus = Status.CANCEL_STATUS;
        Object var3_6 = null;
        this.dispose();
        return iStatus;
    }

    public abstract IStatus doExecute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public ArtifactEdit getArtifactEdit() {
        return this.artifactEdit;
    }

    protected IStatus validateEdit() {
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        return validator.validateState((EditModel)this.getArtifactEdit().getAdapter(ArtifactEditModel.ADAPTER_TYPE));
    }
}

