/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.ui.internal.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.wsi.ui.internal.WSIUIPlugin;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.logging.ILogger;
import org.eclipse.wst.xml.core.internal.validation.core.logging.LoggerFactory;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.validation.XMLValidationUIMessages;

public abstract class ValidateAction
extends Action {
    private static final String REFERENCED_FILE_ERROR_OPEN = "referencedFileError(";
    private static final String REFERENCED_FILE_ERROR_CLOSE = ")";
    private static final String REFERENCED_FILE_ERROR = "referencedFileError";
    private static final String GROUP_NAME = "groupName";
    private static final String FILE_PROTOCOL_NO_SLASH = "file:";
    private static final String FILE_PROTOCOL = "file:///";
    protected static final String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
    protected static final String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
    protected static final String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";
    protected boolean showDialog = true;
    protected IFile file = null;
    protected IReporter reporter;
    protected IValidator validator;

    public ValidateAction(IFile file, boolean showDialog) {
        this.showDialog = showDialog;
        this.file = file;
    }

    protected abstract void validate(IFile var1);

    protected void addInfoToMessage(ValidationMessage v, IMessage m) {
    }

    public void createMarkers(IFile iFile, ValidationMessage[] valmessages) {
        if (!this.fileIsOK(iFile)) {
            return;
        }
        int nummessages = valmessages.length;
        int i = 0;
        while (i < nummessages) {
            ValidationMessage validationMessage = valmessages[i];
            String uri = validationMessage.getUri();
            LocalizedMessage message = validationMessage.getSeverity() == ValidationMessage.SEV_LOW ? new LocalizedMessage(this.getValidationFrameworkSeverity(1), validationMessage.getMessage(), (IResource)iFile) : new LocalizedMessage(this.getValidationFrameworkSeverity(2), validationMessage.getMessage(), (IResource)iFile);
            message.setLineNo(validationMessage.getLineNumber());
            this.addInfoToMessage(validationMessage, (IMessage)message);
            List nestederrors = validationMessage.getNestedMessages();
            if (nestederrors != null && !nestederrors.isEmpty()) {
                message.setGroupName(REFERENCED_FILE_ERROR_OPEN + uri + REFERENCED_FILE_ERROR_CLOSE);
            }
            this.getOrCreateReporter().addMessage(this.getValidator(), (IMessage)message);
            ++i;
        }
        try {
            IMarker[] markers = iFile.findMarkers(null, true, 2);
            int i2 = 0;
            while (i2 < markers.length) {
                IMarker marker = markers[i2];
                String groupName = null;
                try {
                    groupName = (String)marker.getAttribute(GROUP_NAME);
                }
                catch (Exception exception) {}
                if (groupName != null && groupName.startsWith(REFERENCED_FILE_ERROR)) {
                    marker.setAttribute("done", true);
                }
                ++i2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void clearMarkers(IFile iFile) {
        if (this.fileIsOK(iFile)) {
            this.getOrCreateReporter().removeAllMessages(this.getValidator(), (Object)iFile);
        }
    }

    public void run() {
        try {
            Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration", true, ((Object)((Object)this)).getClass().getClassLoader());
            if (this.fileIsOK(this.file)) {
                if (this.showDialog) {
                    this.checkIfFileDirty(this.file);
                }
                try {
                    this.validate(this.file);
                }
                catch (Exception e) {
                    ILogger logger = LoggerFactory.getLoggerInstance();
                    logger.logError("", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {}
    }

    protected boolean fileIsOK(IFile file) {
        return file != null && file.exists() && file.getProject().isAccessible();
    }

    protected void checkIfFileDirty(IFile file) {
        IEditorPart[] dirtyEditors = WSIUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getDirtyEditors();
        int numeditors = dirtyEditors.length;
        int i = 0;
        while (i < numeditors) {
            FileEditorInput fileEditorInput;
            IEditorInput editorInput = dirtyEditors[i].getEditorInput();
            if (editorInput instanceof FileEditorInput && (fileEditorInput = (FileEditorInput)editorInput).getFile().equals((Object)file)) {
                String message = XMLValidationUIMessages._UI_SAVE_DIRTY_FILE_MESSAGE;
                String title = XMLValidationUIMessages._UI_SAVE_DIRTY_FILE_TITLE;
                if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message)) break;
                dirtyEditors[i].doSave(null);
                break;
            }
            ++i;
        }
    }

    public IReporter getReporter() {
        return this.reporter;
    }

    public void setReporter(IReporter reporter) {
        this.reporter = reporter;
    }

    public IValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    protected IReporter getOrCreateReporter() {
        if (this.reporter == null) {
            this.reporter = new WorkbenchReporter(this.file.getProject(), (IProgressMonitor)new NullProgressMonitor());
        }
        return this.reporter;
    }

    protected int getValidationFrameworkSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        return 4;
    }

    protected void openErrorDialog(String title, String message) {
        this.showProblemsView();
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    protected void openWarningDialog(String title, String message) {
        this.showProblemsView();
        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    protected void openValidDialog(String title, String message) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
    }

    protected void showProblemsView() {
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dw.getActivePage();
        IWorkbenchPart activePart = page.getActivePart();
        try {
            if (page != null) {
                page.showView("org.eclipse.ui.views.ProblemView");
            }
        }
        catch (PartInitException e) {
            Logger.logException((Throwable)e);
        }
        page.activate(activePart);
    }

    protected String createURIForFilePath(String filename) {
        if (!filename.startsWith(FILE_PROTOCOL_NO_SLASH)) {
            while (filename.startsWith("/")) {
                filename = filename.substring(1);
            }
            filename = FILE_PROTOCOL + filename;
        }
        return filename;
    }

    protected class ValidationOutcome {
        public boolean isValid = true;
        public boolean hasMessages = false;
    }
}

