/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.parser.favorites;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.impl.AbstractImpl;
import org.apache.wsil.impl.DescriptionImpl;
import org.apache.wsil.impl.LinkImpl;
import org.apache.wsil.impl.ServiceImpl;
import org.apache.wsil.impl.ServiceNameImpl;
import org.apache.wsil.impl.extension.uddi.BusinessDescriptionImpl;
import org.apache.wsil.impl.extension.uddi.ServiceDescriptionImpl;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesLink;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesService;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesUDDIBusiness;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesUDDIRegistry;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesUDDIService;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesUDDIServiceInterface;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesWSDL;
import org.eclipse.wst.ws.internal.parser.favorites.FavoritesWSIL;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesRegistryType;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesUDDIBusiness;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesUDDIRegistry;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesUDDIService;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesUDDIServiceInterface;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesWSDL;
import org.eclipse.wst.ws.internal.parser.favorites.IFavoritesWSIL;
import org.uddi4j.util.BusinessKey;
import org.uddi4j.util.ServiceKey;

public abstract class FavoritesRegistryTypeAbstract
implements IFavoritesRegistryType {
    public abstract String getReadLocation();

    public abstract String getWriteLocation();

    protected abstract WSILDocument getWSILDocument();

    public void init() {
        this.getWSILDocument();
    }

    protected WSILDocument loadWSILDocument(String path, boolean force) {
        try {
            WSILDocument wsilDoc = WSILDocument.newInstance();
            wsilDoc.read((Reader)new FileReader(new File(path)));
            return wsilDoc;
        }
        catch (Throwable throwable) {
            if (force) {
                try {
                    return WSILDocument.newInstance();
                }
                catch (Throwable throwable2) {
                    return null;
                }
            }
            return null;
        }
    }

    public String getFavoritesVersion() {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        Abstract[] abstracts = inspection.getAbstracts();
        if (abstracts.length > 0) {
            return abstracts[0].getText();
        }
        return null;
    }

    public void setFavoritesVersion(String version) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        AbstractImpl abst = new AbstractImpl();
        abst.setText(version);
        inspection.removeAbstracts();
        inspection.addAbstract((Abstract)abst);
    }

    public synchronized void save() throws WSILException, IOException {
        WSILDocument wsilDoc = this.getWSILDocument();
        if (wsilDoc != null) {
            wsilDoc.write(this.getWriteLocation());
        }
    }

    public IFavoritesUDDIRegistry[] getFavoritesUDDIRegistries() {
        Link[] links = this.loadUDDIRegistries();
        IFavoritesUDDIRegistry[] registries = new FavoritesUDDIRegistry[links.length];
        int i = 0;
        while (i < links.length) {
            registries[i] = new FavoritesUDDIRegistry();
            ((FavoritesLink)((Object)registries[i])).setLink(links[i]);
            ++i;
        }
        return registries;
    }

    public IFavoritesUDDIBusiness[] getFavoritesUDDIBusinesses() {
        Link[] links = this.loadUDDIBusinesses();
        IFavoritesUDDIBusiness[] businesses = new FavoritesUDDIBusiness[links.length];
        int i = 0;
        while (i < links.length) {
            businesses[i] = new FavoritesUDDIBusiness();
            ((FavoritesLink)((Object)businesses[i])).setLink(links[i]);
            ++i;
        }
        return businesses;
    }

    public IFavoritesUDDIService[] getFavoritesUDDIServices() {
        Service[] services = this.loadUDDIServices();
        IFavoritesUDDIService[] uddiServices = new FavoritesUDDIService[services.length];
        int i = 0;
        while (i < services.length) {
            uddiServices[i] = new FavoritesUDDIService();
            ((FavoritesService)((Object)uddiServices[i])).setService(services[i]);
            ++i;
        }
        return uddiServices;
    }

    public IFavoritesUDDIServiceInterface[] getFavoritesUDDIServiceInterfaces() {
        Service[] services = this.loadUDDIServiceInterfaces();
        IFavoritesUDDIServiceInterface[] serInts = new FavoritesUDDIServiceInterface[services.length];
        int i = 0;
        while (i < services.length) {
            serInts[i] = new FavoritesUDDIServiceInterface();
            ((FavoritesService)((Object)serInts[i])).setService(services[i]);
            ++i;
        }
        return serInts;
    }

    public IFavoritesWSDL[] getFavoritesWSDLs() {
        Service[] services = this.loadWSDLServices();
        IFavoritesWSDL[] wsdls = new FavoritesWSDL[services.length];
        int i = 0;
        while (i < services.length) {
            wsdls[i] = new FavoritesWSDL();
            ((FavoritesService)((Object)wsdls[i])).setService(services[i]);
            ++i;
        }
        return wsdls;
    }

    public IFavoritesWSIL[] getFavoritesWSILs() {
        Link[] links = this.loadWSILs();
        IFavoritesWSIL[] wsils = new FavoritesWSIL[links.length];
        int i = 0;
        while (i < links.length) {
            wsils[i] = new FavoritesWSIL();
            ((FavoritesLink)((Object)wsils[i])).setLink(links[i]);
            ++i;
        }
        return wsils;
    }

    public Link[] loadUDDIRegistries() {
        return this.loadLinksByNamespace("urn:uddi-org:api");
    }

    public Link[] loadUDDIBusinesses() {
        return this.loadLinksByNamespace("urn:uddi-org:api_v2");
    }

    public Service[] loadUDDIServices() {
        return this.loadServicesByNamespace("urn:uddi-org:api_v2");
    }

    public Service[] loadUDDIServiceInterfaces() {
        return this.loadServicesByNamespace("urn:uddi-org:api");
    }

    public Service[] loadWSDLServices() {
        return this.loadServicesByNamespace("http://schemas.xmlsoap.org/wsdl/");
    }

    public Link[] loadWSILs() {
        return this.loadLinksByNamespace("http://schemas.xmlsoap.org/ws/2001/10/inspection/");
    }

    private Service[] loadServicesByNamespace(String namespace) {
        Vector<Service> serviceVector = new Vector<Service>();
        WSILDocument wsilDoc = this.getWSILDocument();
        if (wsilDoc != null) {
            Inspection inspection = wsilDoc.getInspection();
            Service[] services = inspection.getServices();
            int i = 0;
            while (i < services.length) {
                Description[] desc = services[i].getDescriptions();
                if (desc[0].getReferencedNamespace().equals(namespace)) {
                    serviceVector.add(services[i]);
                }
                ++i;
            }
        }
        Object[] services = new Service[serviceVector.size()];
        serviceVector.copyInto(services);
        return services;
    }

    private Link[] loadLinksByNamespace(String namespace) {
        Vector<Link> linkVector = new Vector<Link>();
        WSILDocument wsilDoc = this.getWSILDocument();
        if (wsilDoc != null) {
            Inspection inspection = wsilDoc.getInspection();
            Link[] links = inspection.getLinks();
            int i = 0;
            while (i < links.length) {
                if (links[i].getReferencedNamespace().equals(namespace)) {
                    linkVector.add(links[i]);
                }
                ++i;
            }
        }
        Object[] links = new Link[linkVector.size()];
        linkVector.copyInto(links);
        return links;
    }

    public void addFavoritesUDDIRegistry(IFavoritesUDDIRegistry registry) {
        this.addUDDIRegistry(registry.getName(), registry.getInquiryURL(), registry.getPublishURL(), registry.getRegistrationURL());
    }

    public void addFavoritesUDDIBusiness(IFavoritesUDDIBusiness business) {
        this.addUDDIBusiness(business.getName(), business.getInquiryURL(), business.getBusinessKey());
    }

    public void addFavoritesUDDIService(IFavoritesUDDIService service) {
        this.addUDDIService(service.getName(), service.getInquiryURL(), service.getServiceKey());
    }

    public void addFavoritesUDDIServiceInterface(IFavoritesUDDIServiceInterface serviceInterface) {
        this.addUDDIServiceInterface(serviceInterface.getName(), serviceInterface.getInquiryURL(), serviceInterface.getServiceInterfaceKey());
    }

    public void addFavoritesWSDL(IFavoritesWSDL wsdl) {
        this.addWSDLService(wsdl.getWsdlUrl());
    }

    public void addFavoritesWSIL(IFavoritesWSIL wsil) {
        this.addWSILLink(wsil.getWsilUrl());
    }

    public Link addUDDIRegistry(String registryName, String inquiryAPI, String publishAPI, String registrationURL) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        LinkImpl link = new LinkImpl();
        AbstractImpl abst = new AbstractImpl();
        abst.setText(registryName);
        link.addAbstract((Abstract)abst);
        AbstractImpl abst2 = new AbstractImpl();
        abst2.setText(inquiryAPI);
        link.addAbstract((Abstract)abst2);
        AbstractImpl abst3 = new AbstractImpl();
        if (publishAPI != null) {
            abst3.setText(publishAPI);
        } else {
            abst3.setText("");
        }
        link.addAbstract((Abstract)abst3);
        AbstractImpl abst4 = new AbstractImpl();
        if (registrationURL != null) {
            abst4.setText(registrationURL);
        } else {
            abst4.setText("");
        }
        link.addAbstract((Abstract)abst4);
        link.setReferencedNamespace("urn:uddi-org:api");
        inspection.addLink((Link)link);
        return link;
    }

    public Link addUDDIBusiness(String businessName, String inquiryAPI, String businessKey) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        LinkImpl link = new LinkImpl();
        AbstractImpl abst = new AbstractImpl();
        abst.setText(businessName);
        link.addAbstract((Abstract)abst);
        link.setReferencedNamespace("urn:uddi-org:api_v2");
        BusinessDescriptionImpl bd = new BusinessDescriptionImpl();
        bd.setLocation(inquiryAPI);
        BusinessKey key = new BusinessKey(businessKey);
        bd.setBusinessKey(key);
        link.setExtensionElement((ExtensionElement)bd);
        inspection.addLink((Link)link);
        return link;
    }

    public Service addUDDIService(String serviceName, String inquiryAPI, String serviceKey) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        ServiceImpl service = new ServiceImpl();
        ServiceNameImpl name = new ServiceNameImpl();
        name.setText(serviceName);
        service.addServiceName((ServiceName)name);
        DescriptionImpl desc = new DescriptionImpl();
        desc.setReferencedNamespace("urn:uddi-org:api_v2");
        ServiceDescriptionImpl sd = new ServiceDescriptionImpl();
        sd.setLocation(inquiryAPI);
        ServiceKey key = new ServiceKey(serviceKey);
        sd.setServiceKey(key);
        desc.setExtensionElement((ExtensionElement)sd);
        service.addDescription((Description)desc);
        inspection.addService((Service)service);
        return service;
    }

    public Service addUDDIServiceInterface(String serIntName, String inquiryAPI, String serIntKey) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        ServiceImpl service = new ServiceImpl();
        ServiceNameImpl name = new ServiceNameImpl();
        name.setText(serIntName);
        service.addServiceName((ServiceName)name);
        DescriptionImpl desc = new DescriptionImpl();
        desc.setReferencedNamespace("urn:uddi-org:api");
        ServiceDescriptionImpl sd = new ServiceDescriptionImpl();
        sd.setLocation(inquiryAPI);
        ServiceKey key = new ServiceKey(serIntKey);
        sd.setServiceKey(key);
        desc.setExtensionElement((ExtensionElement)sd);
        service.addDescription((Description)desc);
        inspection.addService((Service)service);
        return service;
    }

    public Service addWSDLService(String url) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        ServiceImpl service = new ServiceImpl();
        DescriptionImpl desc = new DescriptionImpl();
        desc.setLocation(url);
        desc.setReferencedNamespace("http://schemas.xmlsoap.org/wsdl/");
        service.addDescription((Description)desc);
        inspection.addService((Service)service);
        return service;
    }

    public Link addWSILLink(String url) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        LinkImpl link = new LinkImpl();
        link.setLocation(url);
        link.setReferencedNamespace("http://schemas.xmlsoap.org/ws/2001/10/inspection/");
        inspection.addLink((Link)link);
        return link;
    }

    public void removeFavoritesUDDIRegistry(IFavoritesUDDIRegistry registry) {
        if (registry instanceof FavoritesUDDIRegistry) {
            this.removeLink(((FavoritesUDDIRegistry)registry).getLink());
        }
    }

    public void removeFavoritesUDDIBusiness(IFavoritesUDDIBusiness business) {
        if (business instanceof FavoritesUDDIBusiness) {
            this.removeLink(((FavoritesUDDIBusiness)business).getLink());
        }
    }

    public void removeFavoritesUDDIService(IFavoritesUDDIService service) {
        if (service instanceof FavoritesUDDIService) {
            this.removeService(((FavoritesUDDIService)service).getService());
        }
    }

    public void removeFavoritesUDDIServiceInterface(IFavoritesUDDIServiceInterface serviceInterface) {
        if (serviceInterface instanceof FavoritesUDDIServiceInterface) {
            this.removeService(((FavoritesUDDIServiceInterface)serviceInterface).getService());
        }
    }

    public void removeFavoritesWSDL(IFavoritesWSDL wsdl) {
        if (wsdl instanceof FavoritesWSDL) {
            this.removeService(((FavoritesWSDL)wsdl).getService());
        }
    }

    public void removeFavoritesWSIL(IFavoritesWSIL wsil) {
        if (wsil instanceof FavoritesWSIL) {
            this.removeLink(((FavoritesWSIL)wsil).getLink());
        }
    }

    public void removeService(Service service) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        inspection.removeService(service);
    }

    public void removeLink(Link link) {
        WSILDocument wsilDoc = this.getWSILDocument();
        Inspection inspection = wsilDoc.getInspection();
        inspection.removeLink(link);
    }
}

