/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;

public class FileUtil {
    public static URL resolveURL(URL url) {
        try {
            return Platform.resolve((URL)url);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File createTempFile(String name, String dir) {
        if (name == null || dir == null) {
            return null;
        }
        File temp = null;
        String filePath = name.replace('/', File.separatorChar);
        if (filePath.startsWith(File.separator)) {
            filePath = filePath.substring(1);
        }
        temp = new File(dir, filePath);
        FileUtil.verifyPath(temp, true);
        temp.deleteOnExit();
        return temp;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        int len = input.read(buf);
        while (len != -1) {
            output.write(buf, 0, len);
            len = input.read(buf);
        }
    }

    private static void verifyPath(File path, boolean isFile) {
        if (isFile && path.getAbsolutePath().endsWith(File.separator)) {
            path = path.getParentFile();
            isFile = false;
        }
        if (path.exists()) {
            return;
        }
        File parent = path.getParentFile();
        FileUtil.verifyPath(parent, false);
        if (!isFile) {
            path.mkdir();
        }
        path.deleteOnExit();
    }

    public static File resolveFile(URL url) {
        try {
            URL resolvedUrl = FileUtil.resolveURL(url);
            URI uri = new URI(resolvedUrl.getProtocol(), resolvedUrl.getHost(), resolvedUrl.getPath(), resolvedUrl.getQuery());
            return new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

