/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.contentassist;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.javascript.ui.internal.common.JSCommonUIPluginImages;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.FCContext;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;

class CompletionStringNode {
    private final String completionstring;
    private final String attributes;
    private Hashtable htAttributes = new Hashtable();
    static final String keyFollowClass = "fc";
    static final String keyIESupport = "iesupport";
    static final String keyNsSupport = "nssupport";
    static final String keyECMASupport = "ecmasupport";
    static final String keyShortGUIHelpText = "shortguihelptext";
    static final String keyWASJSPSupport = "wasjspsupport";
    static final String keyDisplayText = "displaytext";
    static final String keyAdditionalDisplayText = "additionaldisplaytext";
    static final String keyType = "type";

    public CompletionStringNode(String cs, String fc, String newAttributes) {
        this.completionstring = cs;
        this.attributes = null;
        String ns = "q";
        String ie = "q";
        String ecma = "q";
        if (newAttributes != null) {
            if (newAttributes.indexOf(";ns=y;") >= 0) {
                ns = "y";
            } else if (newAttributes.indexOf(";ns=n;") >= 0) {
                ns = "n";
            }
            if (newAttributes.indexOf(";ie=y;") >= 0) {
                ie = "y";
            } else if (newAttributes.indexOf(";ie=n;") >= 0) {
                ie = "n";
            }
            if (newAttributes.indexOf(";ecma=y;") >= 0) {
                ecma = "y";
            } else if (newAttributes.indexOf(";ecma=n;") >= 0) {
                ecma = "n";
            }
        }
        this.htAttributes.put(keyNsSupport, ns);
        this.htAttributes.put(keyIESupport, ie);
        this.htAttributes.put(keyECMASupport, ecma);
        this.htAttributes.put(keyFollowClass, fc);
    }

    public CompletionStringNode(String cs, Hashtable ht) {
        this.completionstring = cs;
        this.htAttributes = ht;
        this.attributes = null;
    }

    public Hashtable getAttributesH() {
        return this.htAttributes;
    }

    public String getAttributesS() {
        return this.attributes;
    }

    public String getCompletionString() {
        return this.completionstring;
    }

    public String getDefaultDisplayText() {
        String adt;
        String dt = (String)this.htAttributes.get(keyDisplayText);
        if (dt == null) {
            dt = this.completionstring;
        }
        if ((adt = (String)this.htAttributes.get(keyAdditionalDisplayText)) != null) {
            dt = String.valueOf(dt) + " " + adt;
        }
        return dt;
    }

    public String getFCName() {
        return (String)this.htAttributes.get(keyFollowClass);
    }

    public Image getImage(FCContext fcc) {
        FCContext fcc2;
        String fn = null;
        String completype = (String)this.htAttributes.get(keyType);
        if (completype != null) {
            if (completype.equals("javadocat")) {
                return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/jdoc_tag_obj.gif");
            }
            if (completype.equals("htmltag")) {
                return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/html_tag_obj.gif");
            }
        }
        if ((fcc2 = new FCContext(this, fcc)).getAttribute(keyWASJSPSupport) == "y") {
            return JSEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/methpub_obj.gif");
        }
        char ieSupport = fcc2.getAttribute(keyIESupport).charAt(0);
        switch (ieSupport) {
            case 'y': {
                fn = "yes";
                break;
            }
            case 'n': {
                fn = "no";
                break;
            }
            default: {
                fn = "unknown";
            }
        }
        fn = String.valueOf(fn) + "_";
        char nsSupport = fcc2.getAttribute(keyNsSupport).charAt(0);
        switch (nsSupport) {
            case 'y': {
                fn = String.valueOf(fn) + "yes";
                break;
            }
            case 'n': {
                fn = String.valueOf(fn) + "no";
                break;
            }
            default: {
                fn = String.valueOf(fn) + "unknown";
            }
        }
        return JSEditorPluginImageHelper.getInstance().getImage(JSCommonUIPluginImages.buildObjName(fn));
    }
}

