/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.filter;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISchemaNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ISequenceNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IStoredProcedureNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.ITableNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDFNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IUDTNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IViewNode;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;


/**
 * @author ledunnel
 */
public class FilterWizardPage extends RDBFilterWizardPage{

	/**
	 * @param pageName
	 * @param title
	 * @param titleImage
	 * @param sel
	 */
	protected FilterWizardPage(String pageName, String title, ImageDescriptor titleImage, ISelection sel) {
		super(pageName, title, titleImage, sel);
	}
	protected ConnectionFilter getConnectionFilter() {
		Object sel = ((StructuredSelection) selection).getFirstElement();
		ConnectionInfo connInfo = null;
		ConnectionFilter connFilter = null;
		if (sel instanceof IVirtualNode) {
			if (sel instanceof ISchemaNode) {
				connInfo = RDBCorePlugin.getDefault().getConnectionManager()
						.getConnectionInfo(
								(SQLObject) ((IVirtualNode) sel).getParent());
				connFilter = connInfo.getFilter(ConnectionFilter.SCHEMA_FILTER);
			} else {
				Schema schema = (Schema) ((IVirtualNode) sel).getParent();
				connInfo = RDBCorePlugin.getDefault().getConnectionManager()
						.getConnectionInfo((SQLObject) schema.getDatabase());
				connFilter = connInfo.getFilter(schema.getName() + "::" //$NON-NLS-1$
						+ getConnectionFilterType(sel));
			}
		}
		return connFilter;
	}
	
	private String getConnectionFilterType(Object sel){
		String connectionFilterType = ConnectionFilter.TABLE_FILTER;
		if (sel instanceof ITableNode) {
			connectionFilterType = ConnectionFilter.TABLE_FILTER;
		} else if (sel instanceof IViewNode) {
			connectionFilterType = ConnectionFilter.VIEW_FILTER;
		} else if (sel instanceof IStoredProcedureNode) {
			connectionFilterType = ConnectionFilter.STORED_PROCEDURE_FILTER;
		} else if (sel instanceof IUDFNode) {
			connectionFilterType = ConnectionFilter.USER_DEFINED_FUNCTION_FILTER;
		} else if (sel instanceof ISequenceNode) {
			connectionFilterType = ConnectionFilter.SEQUENCE_FILTER;
		} else if (sel instanceof IUDTNode) {
			connectionFilterType = ConnectionFilter.USER_DEFINED_TYPE_FILTER;
		}
		return connectionFilterType;
	}
	
	 protected void populateSelectionTable() {
	    // Clear filter
	 	ConnectionFilter filter = getConnectionFilter();
	 	Object sel = ((StructuredSelection) selection).getFirstElement();
	 	setConnectionFilter(sel, null);
	 	
	 	super.populateSelectionTable();
	 	
	    // Re-apply filter
	 	setConnectionFilter(sel, filter);
	 }
	 
	 public void setConnectionFilter(Object sel){
	 	ConnectionFilter connFilter = null;
	 	if (this.isFilterSpecified()){
	 		connFilter = new ConnectionFilterImpl();
	 		connFilter.setPredicate(this.getPredicate());
	 	}
	 	setConnectionFilter(sel, connFilter );
	 }
	 
	 
	 public void setConnectionFilter(Object sel, ConnectionFilter connFilter){
		ConnectionInfo connInfo = null;
		if (sel instanceof ISchemaNode) {
			connInfo = RDBCorePlugin.getDefault().getConnectionManager()
					.getConnectionInfo(
							(SQLObject) ((IVirtualNode) sel).getParent());
			if (connFilter == null) {
				connInfo.removeFilter(ConnectionFilter.SCHEMA_FILTER);
				((ICatalogObject) ((IVirtualNode) sel).getParent()).refresh();
			} else {
				connInfo.addFilter(ConnectionFilter.SCHEMA_FILTER, connFilter);
				((ICatalogObject) ((IVirtualNode) sel).getParent()).refresh();
			}
		} else if (sel instanceof IVirtualNode) {
			Schema schema = (Schema) ((IVirtualNode) sel).getParent();
			connInfo = RDBCorePlugin.getDefault().getConnectionManager()
					.getConnectionInfo((SQLObject) schema.getDatabase());
			if (connFilter == null) {
				connInfo.removeFilter(schema.getName() + "::" //$NON-NLS-1$
						+ getConnectionFilterType(sel));
				((ICatalogObject) schema).refresh();
			} else {
				connInfo.addFilter(schema.getName() + "::" //$NON-NLS-1$
						+ getConnectionFilterType(sel), connFilter);
				((ICatalogObject) schema).refresh();
			}
		}

//		// For testing purposes only{
//		if (connInfo != null) {
//			Iterator filters = connInfo.getFilters();
//			while (filters.hasNext()) {
//				ConnectionFilter connFilter = (ConnectionFilter) filters.next();
//				System.out.println(connFilter.getPredicate());
//				System.out.println(connFilter.getOperator());
//				System.out.println(connFilter.getPattern());
//				
//				String[] elements = connFilter.getPatternElements();
//				for (int index = 0; index < elements.length;index++) {
//				    System.out.println(elements[index]);
//				}
//			}
//		}	
	 }

}