/* $Id: umail.h,v 1.16 2002/07/13 23:29:18 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef     UMAIL_H
    #define     UMAIL_H

    #ifdef HAVE_CONFIG_H
    #include <config.h>
    #endif

    #ifdef __linux__
        #define __USE_BSD_SIGNAL
    #endif

    #include <stdio.h>
    #include <stdlib.h>
    #ifdef  HAVE_LIMITS_H
        #include <limits.h>
    #endif
    #include <signal.h>
    #if STDC_HEADERS || defined(USE_STDARG)
        #include <stdarg.h>
    #else
        #include <varargs.h>
    #endif
    #ifdef  HAVE_CTYPE_H
        #include <ctype.h>
    #endif
    #ifdef  HAVE_SYS_TIME_H
        #include <sys/time.h>
    #endif
    #include <sys/types.h>

    #ifdef  HAVE_PWD_H
        #include <pwd.h>
    #endif

    #ifdef X11FORMS_H
        #include <X11/forms.h>
    #else
        #include <forms.h>
    #endif

    #include "version.h"

    #define SLEN        256
    #define PLEN        MAXPATHLEN

    #define TIME_DBLCLICK   500000
    #define TIME_DBLCLICK_MIN   150000

    #ifndef TRUE
        #define FALSE       (0)
        #define TRUE        (!FALSE)
    #endif

    #define SHIFT 0x01
    #define CTRL 0x02

extern char conf_name[255];
extern char sender_name[127];
extern char homedir[255];
extern char configdir[255];
extern char maildir[255];
extern char tmpdir[255];
extern char user_n[32];
extern FL_FORM *main_form;

/* busy indicator */
extern u_int busy;

extern u_int supress_errors;

/* debug */
extern u_int debug;

    #define STAT_LEN        0x00
    #define DATE_LEN        0x01
    #define SIZE_LEN        0x02
    #define FROM_LEN        0x03
    #define SUBJ_LEN        0x04
    #define UID_LEN         0x05
extern int show_msg[6];

    #define FOLD_LEN        0x00
    #define FNUM_LEN        0x01
    #define FUNR_LEN        0x02
extern int show_fld[3];

    #define FLD_DUMMY_CLR   0x00
    #define FLD_SEARCH_CLR  0x01
    #define FLD_MARK_CLR    0x02
    #define FLD_RECENT_CLR  0x03
    #define FLD_SYSTEM_CLR  0x04
    #define FLD_IMAP_CLR    0x05
    #define FLD_CURR_CLR    0x06
    #define FLD_NORMAL_CLR  0x07
    #define FLD_NEWS_CLR    0x08
extern int color_fld[9];

    #define MSG_CURR_CLR    0x00
    #define MSG_UNREAD_CLR  0x01
    #define MSG_MARK_CLR    0x02
    #define MSG_NORMAL_CLR  0x03
    #define MSG_DELETED_CLR 0x04
extern int color_msg[5];

    #include "cfgfile.h"
    #define DONT_STORE      0x01    /* parameter should not be stored in cfg file */
    #define CF_UNSECURE     0x02    /* parameter may not be sent in bug report */
    #define CF_NOTCHANGED   0x04    /* configuration will be considered unchanged */

struct _mail_msg *next_msg(int ur, struct _mail_msg *cmsg);
struct _mail_msg *prev_msg(int ur, struct _mail_msg *cmsg);
struct _mail_msg *delete_msg(struct _mail_msg *cmsg);
struct _mail_msg *move_message(struct _mail_msg *cmsg,struct _mail_folder *fld);
struct _mail_msg *move_message_byrule(struct _mail_msg *cmsg);
int send_msg(struct _mail_msg *cmsg, int queue);

/* check if timer operation is permitted. returns 1 if not and 0 if yes */
int is_iconized();

/* clean exit */
RETSIGTYPE clean_exit(int s);

/* retrieve new mail */
int get_new_mail(int local_only, int by_timer);
void new_mail_notify();

/* return folder line suitable for placing in browser */
char *get_fld_line(struct _mail_folder *folder);

/* get color of folder line im browser */
int get_fld_color(struct _mail_folder *folder);

/*
 * Theese are definitions of functions which
 * return non-integer type and defined and used in
 * different files
 */
extern char *b_rmlsp();
extern FL_FORM *view_form(struct _mail_msg *msg, int view);
/* check if double click occured. id1 and id2 are unique for every different */
/* control. return 1 if double click and 0 if not */
extern int double_click(int id1, int id2);
extern int display_msg (int, const char *, const char *, ...);
    #define MSG_FATAL   0x00    /* fatal error , program will terminate */
    #define MSG_QUEST   0x01    /* ask yes/no question */
    #define MSG_WARN    0x02    /* warning , program will continue */
    #define MSG_STAT    0x04    /* display messages in status bar */
    #define MSG_MSG     0x05    /* display messages */
    #define MSG_LOG     0x06    /* message to be displayed in log window */
    #define MSG_STDERR  0x07    /* print to stderr */
/* modifiers */
    #define MSG_DEFNO   0x10    /* set focus to "No" (when MSG_QUEST) */

extern void fl_edit_error(char *fmt, ...);
/* set cursor of for for to cursor. If cursor = 0 restores default cursor */
/* should be called with cursor = -1 at startup for initalization */
void set_cursor(FL_FORM *form, int cursor);

/* current folder */
extern struct _mail_folder *current_folder;

int view_msg(struct _mail_msg *msg, int openwin);
int edit_msg(struct _mail_msg *msg);
void set_edit_cursor(struct _mail_msg *msg, int cx, int cy);
void msg_form_shutdown();
void msg_form_init();

void move_messages(struct _mail_folder *fld);
void copy_messages(struct _mail_folder *fld);

extern FL_OBJECT       *inc_timer, *send_timer, *trash_timer, *ttip_timer, *imap_timer, *pgp_timer, *asave_timer, *preview_timer;
extern FL_OBJECT       *menu_misc;
    #define TTIP_DELAY  1   /* delay before displaying a tooltip */
extern  void cb_ttip_timer(FL_OBJECT *obj, long param);

/* edit message icon pixmap */
extern Pixmap icon_MailEdit, icon_MailEdit_sh;

/* address book icon pixmap */
extern Pixmap icon_ABook, icon_ABook_sh;

void sig_timers();

/* faces (picons) staff */
    #ifdef FACES
char *xbm_to_face();
char *get_msg_face(struct _mail_msg *msg);
void update_faces(struct _mail_msg *msg);
    #endif
char *find_face(struct _mail_addr *addr, int *ftype);
    #define FACE_XPM    0x01
    #define FACE_XBM    0x02
    #define FACEFIELD   "X-Face"

/* this functions redraws different parts of the main window */
extern void redraw_folders();
extern void redraw_fld(struct _mail_folder *fld);
extern void redraw_fld_line(struct _mail_folder *fld);
extern void redraw_msg(struct _mail_msg *msg);
extern void redraw_fld_win();
extern void restore_fld_win();
extern void restore_msg_win();
extern void redraw_msg_win();
extern void refresh_msgs();
extern void refresh_folders();

extern FL_OBJECT *fl_find_last(FL_FORM* form, int find, FL_Coord mx, FL_Coord my);
extern "C" FL_OBJECT *fl_find_first(FL_FORM* form, int find, FL_Coord mx, FL_Coord my);

extern void show_button_descr(FL_OBJECT *obj);

void add_msg_addr(struct _mail_msg *msg);

void pop_account(struct _pop_src *pop);
void imap_account(struct _imap_src *imap);
void nntp_account();
void auth_smtp_account(char *hostname, char *username, char *password );

int abortpressed();
void abort_button_active(FL_OBJECT *button, int active);
void cb_button_abort(FL_OBJECT *obj, long param);

char *getmyhostname();
void update_title();
void select_found();

extern int ttips;   /* show tooltips */
/* xforms even handler */
int post_handler(FL_OBJECT *ob, int event,FL_Coord mx, FL_Coord my, int key, void *xev);

/* address book definitions */

    #define MAX_ADDR_IN_ALIAS   1023
    #define MAX_ABOOK_NAMELEN   16

/* address book entry */
typedef struct _abook_entry {
    struct _mail_addr *addr;    /* addresses */
    struct _abook_entry *next;  /* next entry */
    char    *description;       /* short description */
    u_int   type;           /* type of entry */
    #define ADDR_SINGLE 0x00    /* single address */
    #define ADDR_ALIAS  0x01    /* alias entry */
} abook_entry;

typedef struct _abook {
    struct _abook_entry *entries;   /* address book entries */
    char name[16];          /* address book name */
    u_int   flags;          /* special flags */
    #define ABOOK_LOCAL 0x00    /* local address book */
    #define ABOOK_REMOTE    0x01    /* remote address book */
} abook;

extern struct _abook_entry *find_addr(struct _mail_addr *addr);
extern int save_book();
extern int load_book(char *name);
extern struct _abook_entry * add_book(struct _mail_addr *new_addr , int ask);
extern void free_book();

extern int play_sound(char *soundfile, int volume);

    #ifdef  USE_SOUND
        #define AUDIO_DEVICE    "/dev/audio"
    #endif

struct _proc_info;

/* function to be called from SIGCHLD handler */
typedef void (*child_handle)(struct _proc_info *info);

typedef struct _proc_info {
    int pid;            /* process ID */
    int status;         /* process exit status */
    u_int wait;         /* how to wait for process */
    #define WAIT_ASYNC  0x00    /* don't wait, call handle at exit */
    #define WAIT_BG     0x01    /* wait , but make GUI work at the same time */
    #define WAIT_STOP   0x02    /* wait and stop program execution */
    #define WAIT_FINISHED   0x08    /* process ended (modifier) */
    child_handle handle;        /* handler function */
    child_handle init;      /* initialization function */
    void *u_data;           /* any user data */
    long ul_data;           /* any user data */
    int ifd,            /* file descriptors for stdin, stdout      */
    ofd,            /* and stderr */
    efd;
    int fd_in[2],           /* communication pipes for stdin, stdout   */
    fd_out[2],          /* and stderr */
    fd_err[2];
} proc_info;

    #define MAX_CHILDREN    0x0f    /* Can not run more then 15 child processes at the same time */

/* initialize pinfo */
void init_pinfo(struct _proc_info *pinfo);
/* duplicate pinf structure */
struct _proc_info *dup_pid_info(struct _proc_info *pinfo);
/* execute child process */
extern int exec_child(char *str, struct _proc_info *pinfo);
void my_check_forms(struct _proc_info *pinfo);
void my_check_forms2();
/* check forms and file descriptor. if type = 0 check for read , 1 - for  */
/* write and 2 - for both read and write */
/* returns 0 if fd has data available and -1 on error */
int my_check_io_forms(int fd, int type, int timeout);
RETSIGTYPE handler(); /* SIGCHLD handler */
void check_extprocs(); /* check and handle finished processes */
void init_procs();
void close_procs();

char *get_sign_file(struct _mail_msg *msg);
char *pup_choose_sign(FL_FORM *form);
extern  FL_FORM *signform;

void cb_help_button(FL_OBJECT *obj, long param);
void cb_msg_autosave(FL_OBJECT *obj, long num);
void helpchapter(int chapter);

void my_deactivate();
void my_activate();
void msg_text_activate(int active);

/* special xforms defaults */
typedef struct _xfdef {
    int popfsize, popfstyle, popcursor;
    int popbgcol, popfgcol;
} xfdef;

extern struct _xfdef xfdefs;
extern int xofft, yofft;
extern int readonly;

/* PGP functions and definitions */
struct pgpargs {
    char *passphrase;
    char *recp;
    char *userid;
    struct _mail_msg *msg;
};
extern void init_pgpargs(struct pgpargs * pargs);

extern int pgp_action(char* inbuf, int mode, struct pgpargs*);
extern char* input_passphrase();
extern unsigned long PGP_Lookup_PGPId(const char *name, FL_FORM *form);
    #define ENCODE 1    /* Encode with PGP */
    #define DECODE 2    /* Decode with PGP */
    #define SIGN   4    /* Sign with PGP signature */
    #define VERIFY 8    /* Verify PGP signature */
    #define EXTKEY 16   /* Extract public key */
    #define ADDKEY 32   /* Add public key to message */
    #define VRFYFL 64   /* Verify PGP signature in separate file */
    #define SIGNFL 128  /* Sign and put signature in separate file */

/* check is file is a PGP message */
/* returns -1 on error, 0 if it's not a PGP messages */
/* 1 if it's PGP encoded message, 2 if it's a PGP signed message */
/* 3 if it contains PGP public key */
extern int is_pgp(char *file);

/* decode PGP file */
extern int pgp_decode_file(char *file);

/* get list of PGP recipients */
extern char *get_pgp_recp(struct _mail_msg *msg);

/* set PGP user ID according to addr */
extern void set_pgp_user(struct _mail_addr *addr);

/* PGP encode message according to RFC2015 */
/* mode can be ENCODE or SIGN|ENCODE */
extern int pgp_encode_rfc2015(struct _mail_msg *msg, int mode);

/* PGP sign message according to RFC2015 */
extern int pgp_sign_rfc2015(struct _mail_msg *msg);

    #define PGP_MAX_TIMER       180 /* limit on "forget passphrase" timer */
    #define PREVIEW_MAX_TIMER   60  /* limit on "mark read" timer */

/* file viewer */
int file_view(char *file, struct _proc_info *pinfo);

void map_form(FL_FORM *form);

void disp_infowindow(void *ptr, int type);
    #define INFO_MSG    0x00
    #define INFO_FOLDER 0x01

struct _mime_mailcap *mcap_select(char *mtype, char *msubtype);

extern int logging;
    #define LOG_SMTP    0x04
    #define LOG_NET     0x08
    #define LOG_ERRORS  0x10
    #define LOG_NNTP    0x20

int load_sources();
int save_sources(char *tmpf);
void free_sources();
int search_sources(char * name);

int load_smtp_accounts();
int save_smtp_accounts(char *tmpf);

struct _retrieve_src *get_src_by_name(char *name);
struct _spool_src *get_spoolsrc_by_name(char *name);
struct _pop_src *get_popsrc_by_name(char *name);
struct _imap_src *get_imapsrc_by_name(char *name);

struct _retrieve_src *get_msg_src(struct _mail_msg *msg);
struct _spool_src *get_msg_spoolsrc(struct _mail_msg *msg);
struct _pop_src *get_msg_popsrc(struct _mail_msg *msg);
struct _imap_src *get_msg_imapsrc(struct _mail_msg *msg);

void set_menu_imap();

int text_dbl_call(FL_OBJECT *obj, char *word, int key, int r, int c);
struct _mime_msg *get_view_part(struct _mail_msg *msg);
#endif /* UMAIL_H */

#ifdef USE_GPASSWD
/* set passphrase for global password encryption */
void  set_passphrase(void); 
#endif /* USE_GPASSWD */
