/* $Id: connection.cpp,v 1.6 2002/01/26 03:14:53 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/


#include <fmail.h>

#include <string.h>
#include "connection.h"


connection::connection(int psock, string phost) {
	sock = psock;
	host = phost;
	memset((void*)buffer,'\0', sizeof(char) * CONNECTION_BUFFER);
}

connection::~connection() {
	if(sock!=-1)close(sock);
}

void connection::disconnect() {
	close(sock);
	sock=-1;
}

connection * connection::get() {
	return this;
}

string connection::getHost() {
	return host;
}

int connection::getSock() {
	return sock;
}

char * connection::getBuf() {
	return buffer;
}

bool operator == (const connection & lhs, const connection & rhs) {
	return((lhs.sock == rhs.sock) && (lhs.host == rhs.host));
}
