/* $Id: tip.cpp,v 1.1 2002/07/24 01:43:46 cfreeze Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>

#include <cfgfile.h>

#include <string>

#include "tip.h"

extern cfgfile Config;

static int ready = 0;
FD_TipOfTheDay_Form *tip_obj;


void FindNewTip(string & sNewTipe, string & sCfgKey);

void TipOfTheDay() {
	char buf[MAX_LEN_TIP_DATA];
	string sTipText;
	string sTipCfgKey;

	//if((wait == 2) && (ready == 1))
	if(ready == 1)
		return;

	FindNewTip(sTipText, sTipCfgKey);

	if(sTipText.size()) {

		tip_obj = create_form_TipOfTheDay_Form();


		snprintf(buf, sizeof(buf), "%s", sTipText.c_str());

		fl_set_object_label(tip_obj->Tip_Text, buf);
		fl_set_form_minsize(tip_obj->TipOfTheDay_Form, 380, 290);
		fl_set_form_maxsize(tip_obj->TipOfTheDay_Form, 380, 290);
		fl_show_form(tip_obj->TipOfTheDay_Form, FL_PLACE_CENTER, FL_TRANSIENT,
					 		"Tip Of The Day");

		fl_do_only_forms();

		fl_hide_form(tip_obj->TipOfTheDay_Form);
		fl_free_form(tip_obj->TipOfTheDay_Form);
		fl_free(tip_obj);
		tip_obj = NULL;

		if(!readonly) {
			//fprintf(stderr, "Storing key %s since it was viewed.", sTipCfgKey.c_str());
			Config.set(sTipCfgKey.c_str(), 1); //Save in cfg
			Config.save(0);
		}
	}

	return;
}

void FindNewTip(string & sNewTip, string & sCfgKey) {
	string sSearchResults;

	sNewTip.resize(0);
	sCfgKey.resize(0);

	for(int i = 0; i < NUMBEROFTIPS; i++) {
		sCfgKey = TipOfTheDayKeys[i];
		//fprintf(stderr,"Searching for Tip Key %s\n",sCfgKey.c_str());

		sSearchResults = Config.getString(sCfgKey,"");

		if(sSearchResults == "") {
			sNewTip = TipOfTheDayData[i];
			//fprintf(stderr,"Found Tip Key %s\n",sCfgKey.c_str());
			//fprintf(stderr,"Found Tip Data %s\n",sNewTip.c_str());
			return; //Found unviewed tip
		}
	}

	return;
}
















