.\" -*-Text-*-
.\"
.\" Copyright  1991-2001 by Bjrn Stabell, Ken Ronny Schouten, Bert Gijsbers & Dick Balaska.
.\"
.TH XPILOT 6 "Requires UDP and X11"
.ds )H GNU Public License 2.0 applies
.ds ]W XPilot 4.4.3: Nov 4, 2001
.if n .ad l	\" If nroff formatter, adjust left margin only
.if t .ad b	\" If troff formatter, adjust both margins

.SH NAME

xpilot \- XPilot multiplayer gravity war game client


.SH SYNOPSIS

.B xpilot
.B [-help]
.B [-version]
.B [-name \fInickname\fC]
.B [-team \fIteam-number\fC]
.B [-join]
.B [-list]
.B [-shutdown [\fImessage\fC]]
.B [-display \fIstring\fC]
.B [-port \fIport-number\fC]
.B [-text]
.B [\fIconfiguration-options]\fC
.B [\fIserver-host ...\fC]


.SH OVERVIEW

XPilot is a multiplayer game which looks a bit like Thrust for
the Commodore 64.  Thrust has some similarities with Atari's
coin-up games Gravitar and Asteriods (not a misspelling) - they
were the originals.  Several clones have appeared for various
computers, among others Gravity Force for the Commodore Amiga.

The main objective of the game varies as you can choose different
game modes, although the only modes supported as of today are
\fBcombat\fP (optionally with teams and/or limited lives) and
\fBrace\fP.  The former mode focuses more strongly on shooting
each other down, while the latter is more a piloting test than
anything else.

To start playing, you need to connect to a \fBserver\fP by
using a \fBclient\fP program called \fIxpilot\fP.  If there are
no servers running, you will have to start one of your own (see
man-page \fIxpilots(6)\fP).


.SS Options

.TP 15
.B -help
Prints some help, including commandline options.
.TP 15
.B -version
Prints the current version.
.TP 15
.B -name \fIplayer-name\fP
Lets you use an alternative name during the play (may be handy :).  If this
option isn't specified, and you haven't set the X resource \fPname\fP, you
will be known by your \fIlogin name\fR.
.TP 15
.B -team \fIteam-number\fP
Joins team number \fBteam-number\fR.  See below for notes about
team play.  When the server is not configured for team mode, this
option has no effect.
.TP 15
.B -help
Prints a small usage message.
.TP 15
.B -version
Prints version information.
.TP 15
.B -join
Automatically joins the first server you get response from.
If no \fIserver-host\fP is specified, a \fIbroadcast query\fP is
performed to locate a server on the local network.
.TP 15
.B -list
A \fIbroadcast query\fP is performed on the local network and status
information is displayed from all servers found.
.TP 15
.B -shutdown [\fImessage\fP]
Sends a shutdown to the server, the message part is optional.
.TP 15
.B -name \fInick\fP
Specifies your nick name.
.TP 15
.B -team \fInumber\fP
Specifies your wanted team number.
.TP 15
.B -display \fIdisplay-string\fP
Specifies which X server to contact.
.TP 15
.B -port \fInumber\fP
Specifies the port number to use when contacting a server.
.TP 15
.B -text
Invokes the old text-based \fBcommand prompt\fP interface instead
of the new \fBWelcome Window\fP.  If no \fIserver-host\fP is specified,
a \fIbroadcast query\fP is performed to locate a server on the local
network.  If a \fIserver-host\fP is specified, \fB-text\fP is implied.
.TP 15
.B \fIconfiguration-options\fP
All the X resource values can be configured separately from the command
line.  For example to change the ecm key to just `z' use;
.B -keyEcm z
.TP 15
.B \fIserver-host\fP
Tries to connect to server at host \fIserver-host\fP.  If successful
and \fB-join\fP is not specified, you are presented with the
\fBcommand prompt\fP.

If neither \fIserver-host\fP nor \fB-join\fP are specified, the
\fBWelcome Window\fP is displayed and a server may be selected from
there.

.SH PROMPT COMMANDS

When you startup \fBxpilot\fP specifying a server name but no \fB-join\fP
option, or \fB-text\fP is specified, you will get a prompt asking you
for directions.  You may type
.B h
or
.B ?
to list the available commands.  These are quite obvious and
deal with communication to the current server only.  You may
enter the game by pressing CR (Return/Enter).

If you are the owner of the server you will have a few extra
options.  See \fIxpilots(6)\fP.

.SH THE WELCOME WINDOW

When you startup \fBxpilot\fP without specifying a server name you will
be presented with a Welcome window with three buttons in the upper left
corner.  These buttons are:
.RS 5
.TP 12
.B Local
Search for \fBxpilot\fP servers on the local network and display a list
of matches.  Press the \fBJoin game\fP button beside the desired server name
to start playing.  If no servers are listed, you will need to start one.
See \fIxpilots(6)\fP.

.TP 12
.B Internet
Search the xpilot meta servers (see \fBnotes\fP section) for currently
running xpilot servers on the Internet.

If the meta servers could be contacted, a list of servers will be
displayed.

.TP 12
.B Quit
Press this button to exit the program.

.RS -5

When the \fBInternet\fP button is pressed and successfully retrieves the
list of xpilot servers from the meta servers, additional buttons appear
at the bottom and one under the \fBserver\fP column for each server
listed:

.RS 5
.TP 12
.B Next Page
If there is more than a screenful of servers, this will allow you to see
the rest of them.  A \fBFirst Page\fP button will appear to return to the
top of the list when you are not on the first page.  The page is initially
sorted by the \fBpl\fP column in descending order.

.TP 12
.B Measure Lag
This will fill the \fBping\fP column with the round-trip time for a packet
to reach each server (in milliseconds).  If the server is not reachable,
\fBnone\fP will appear in this column.  The results will be sorted by
\fBPl\fP in descending order and subsorted in ascending order by \fBPing\fP
time.

.TP 12
.B Server
The hostname of the server is displayed as a red button to join that server.

The button is highlighted when the program is attempting to establish a
connection to the server.  If the server cannot be contacted after two
retries, the button will revert to its unhighlighted state.  If the
button stays highlighted and you do not enter the game immediately,
this means you have been \fIqueued\fP to enter the game as soon as a
base is available.

The xpilot client does not handle the connection attempt in its
own thread and therefore blocks the current execution thread and will
not update the display or respond to button presses until a connection
is established or it gives up.  Thus, the only way to exit the queued
state is to close the xpilot client, either by using the window manager
to close the window, or forcibly with \fBkill(1)\fP or ^C.

Incorrectly configured server hosts may report a false hostname.
However, behind the scenes, the meta server sends us the IP number.  A
connection will be established to that IP number when the server button
is pressed so long as there isn't a network problem (such as a firewall
at either the client or server end not configured to permit access) that
prevents contact.
.RS -5

The columns of the Internet server table, from left to right are as
follows:

.RS 5
.TP 12
.B Pl
The number of human players on the server.

.TP 12
.B Q
The number of players currently queued to join the server.

.TP 12
.B Ba
The number of bases on this map.

.TP 12
.B Tm
The number of teams, if the map is a teamplay map.

.TP 12
.B FPS
The framerate of the server in frames-per-second.

.TP 12
.B Stat
The status of the game, e.g. \fBlock\fP if the game is locked.

.TP 12
.B Version
The version number of the server.

.TP 12
.B Map
The name of the map.

.TP 12
.B Server
The hostname of the server.

.RS -5

.SH THE GRAPHICAL USER INTERFACE

When you enter a game you will hopefully be presented a window.
This window is divided into three major areas:
.RS 5
.TP 12
.B Radar
(Top left) This area shows the map the server you are playing on
is using as well as the position of your fellow players (if they
aren't cloaked).  In race mode the radar also outputs the
position of the control posts.  Players are shown as small rectangles
The player you are currently locked onto is shown as a flashing
rectangle.

The server can optionally display missiles, mines and/or bombs (moving
mines) on this radar, and will display them using different symbols;
missiles are quick flashing small dots, mines and bombs slow flashing small
dots.  If nuclear mines or missiles are launched the radar can detect the
high energy radation emiited and will show these types of weapons on the
radar as alternating small and large rectangles.  The radar always has a
limited range for these objects, due to their small size.  The maximum
range depends on how much fuel you are carrying.

On teamplay maps, your fellow team members will appear as green dots on
the radar, whereas the enemy will appear as white dots.

.TP 12
.B Rating list
(Bottom left) This area shows the list of players (sorted with
respect to their \fBrating\fP, or `score') currently logged on
the server.  The player with the highest <rating>/<num of times
died> ratio - that is, the most `deadly' player - is underlined
with a dashed line.

First on each line, you might find a letter which gives you some
information about the status of the player:
.B R
means the player is a robot,
.B T
means the player is not a player but a detached tank,
.B D
means player is dead (only possible in limited lives mode),
.B P
means the player is paused and
.B W
means the player is waiting to join the game after login
(in limited lives mode).

Depending on the current game mode, you will also find
information about which teams each player belong to and how many
lives each player has left.

.TP 12
.B Game area
(Right) This is where the action is.  Most notably you will see
your fighter in the middle of the screen, hopefully you won't see
any shots or explosions yet!

You may also see some strange blue drawings surrounding your fighter - this
is the \fBHUD\fP (Head Up Display) which greatly simplifies and compresses
the information you need to know.  Currently, the HUD displays the
following information:
.RS 5
.TP 12
.B Bonus items
You may notice some symbols and numbers on the left side of the HUD,
these indicate which, and what quantity, of extra equipment you have.
This list can be turned off using the `o' key, then only items which
you gain or loose will be briefly shown on the HUD.  Pressing `o'
again will constantly show owned items.
.TP 12
.B Fuel
A fuel meter will appear on the right side of the HUD when you
are getting low on fuel, it will start flashing when your fuel
level gets dangerously low.  The fuel is numerically displayed on
the bottom right corner of the HUD.
.TP 12
.B Lock
The name of the player you have currently locked on is shown on
the top of the HUD.  The distance and bearing to that same player
is visualized by a dot where placement of the dot gives the
direction, and the size of the dot gives the distance.  The dot
will be filled if the player is not on the same team as you.  The
distance to the player also numerically displayed on the top
right corner of the HUD, it is measured in `blocks'.
.TP 12
.B Velocity
(Optional) The position of the HUD changes with the current
velocity.  The distance from the center of your screen is
proportional to your velocity.  Moving to the top moves the HUD
to the bottom.

In addition to the moving HUD, you can display a line from the
center of the HUD to the center of your ship.

Both indicators can be combined or used exclusivly (see
discussion about \fBXresources\fP below).
.TP 12
.B Score messages
Relevant score information is shown below the HUD, as well as on
the game field.
.TP 12
.B Time left
The amount of time the game will last if the the server was started
with a time limit.  This is displayed in the upper left corner of
your HUD.

.RS -5
.RS -5
Between the \fBradar\fP and the \fBRating list\fP there are three
push buttons: 
.RS 5
.TP 12
.B Quit
Exits the game and the program.
.TP 12
.B About
Pressing the \fBAbout\fP button will popup a three page help window.
It explains in short the functionality of all the items
you may encounter together with a graphical depiction of them.
.TP 12
.B Menu
The \fBMenu\fP button pops up a pull down menu with the following
buttons:
.RS 5
.TP 12
.B Keys
Will popup the \fBKeys\fP window, which contains a list of
all the \fBX keysyms\fP that have one or more xpilot actions
bound to them.
.TP 12
.B Config
Changes the \fBRating list\fP into a window with a list
of most of the options.  The options can be changed interactively.
Pushing the \fBSave configuration\fP button will save the options
and the key bindings to the .xpilotrc file in your home directory.
.TP 12
.B Score
Displays the players and their scores in the \fBRating list\fP window.
.TP 12
.B Player
Lists the players with their login name and their host address
in the \fBRating list\fP window.
.TP 12
.B MOTD
Displays the Message Of The Day if the server has one available.
.RS -5
.RS -5


.SH GAME CONCEPTS

The game objective varies as the server (\fIxpilots(6)\fP) is
very configurable.  However, below you will find short
descriptions of some of the main concepts of the game.


.SS Gravity

All objects in the game are affected by gravity - that is, they
will accelerate in the direction the gravity is strongest.  The
strength and direction of the gravity is user configurable (see
\fIxpilots(6)\fP), and can even be set to 0.

Some objects affect the gravity in a limited area, these are
called \fBgravs\fP and they exist in miscellaneous types
(attractive, repulsive, clockwise, anti-clockwise).  Gravs are
shown as red circles with some symbol inside which is different
for each type of grav.  (For more information on how the affect
the gravity, see \fIxpilots(6)\fP.)

.SS Wormholes

Wormholes are shown as red rotating circles.  They will
`teleport' you to another place in the world.  Generally, when
you go through a wormhole, you'll come out at the nearest
wormhole in the direction you were travelling.  Some wormholes
are enter-only and some are exit-only.  The exit-only ones are
invisible.  Passing through a wormhole will make you visible for
a while if you were cloaked.


.SS Fuel

You will also have to worry about your \fBfuel level\fP as most
equipment use fuel/energy and some even work better the more fuel
you have.

You may gain fuel by picking up special `fuel cans' (see
\fBbonus items\fP section) or refueling at a refuel station.
Refuel stations may be found in blocks in the world, they differ
from standard background blocks in that they have a red/black
\fBF\fP in them, and they are partly or completely filled with
red.  The amount of red determines how much fuel the station has
at available for you.  To refuel, you must hit the
\fIkeyRefuel\fP key (see \fBcontrols\fP section).

Fuel takes up mass and will also determine how big the explosion
will be when (sorry, `if' :) you meet your destiny.


.SS Combat

There are two different and mutually exclusive modes which have
greatly different objectives: \fBcombat mode\fP and \fBrace
mode\fP.  The most extensive is the \fBcombat mode\fP, which also
happens to be the default.

Here your main objective is to get as high a rating as possible
by `blasting away' on enemy fighters (human or robot controlled)
and cannons.  All will naturally fire back at you, so you will
also need some nifty piloting skills and/or some heavy equipment
to really enjoy living.  Extra weapons are explained in the
\fBbonus items\fP section.


.SS Race

In \fBrace mode\fP, your objective is to fly as fast as you can
through a specified route.  This is done by passing checkpoints
in a specified order.  The finish is reached after three laps.

The next checkpoint is always visible on the radar.


.SS Team play

\fBTeam play\fP is useful in combination with \fBcombat mode\fP.
It is different from straight \fBcombat mode\fP in that players
on your own team are not considered enemies.  There are some
additional objectives too.

You can gain points if the map you are using have \fBtargets\fP
or \fBtreasures\fP.  The main difference is that you get points
by blowing up an enemy's target using shots or mines.
A shot will only damage a target and if the target is completely
damaged then the next shot will blow it up.  A mine will immediately
destroy a target.  Two missile hits will also destroy a target.

Enemy treasures have to be stolen from the enemies and dropped on
your own treasure.  You pick up a treasure by using \fIkeyConnector\fP
when flying nearby the enemies treasure.  This will attach
the treasure to your ship with a strong rubber band. Now you have to move
your ship away from the treasure while holding the \fIkeyConnector\fP
down. When you reach a certain distance the rubber band will be drawn in
a sollied line. This means that the treasure is attached to your ship.
It is possible (in emergency situations :) to detach the enemy treasure
by pressing \fIkeyDropBall\fP, but this will of course not gain you or
your team any points.

Certain maps may configure targets as passable by team members, in
which case they can act as wall shields for team bases.

Provided that \fBteamImmunity: yes\fP is set on the map, your teammates
will appear as blue ships, and so will their shots.  With \fBteamImmunity\fP
you cannot be shot by members of your own team, nor do you bump into or
crash with them.  The enemy, and the enemy's shots are always white.

.SS Shields

You may or may not have shields at your disposal, depending on
the server options specified.  If you have, they are activacted
with the \fIkeyShield\fP key (see \fBcontrols\fP section).
Generally collisions with other objects (except for debris and
sparks) are lethal, but when you are hit by something with your
shields up then it will only cost you some fuel/energy.
If you didn't have enough fuel then the collision will be lethal
again.  Having your shields up costs fuel.


.SS Bonus items

During the game you might encounter blue triangles with red
symbols on - these are special bonus items which will make your
life easier.  As of today, these items include:

.RS 5
.TP 12
.B Fuel can
More fuel/energy.
.TP 12
.B Cloaking device
Makes you invisible for other players, both on radar and on the screen.
However, when you are hit by a shot or missile or bounce with another
player then you will be temporarily visible again.
.TP 12
.B Sensors
Enables you to see cloakers to a limited extent.  Having more sensors
improves this.
.TP 12
.B Rear cannon
Extra rear cannon.
.TP 12
.B Front cannons
2 extra front cannons.
.TP 12
.B Afterburner
Your main engine becomes more powerful and uses your fuel more 
efficiently.
.TP 12
.B Rockets
Pack of rockets.  These may be used as smart missiles, heat
seeking missiles, or just plain dumb torpedos.  Usually these
explode on impact with a small debris explosion.  However, if
enabled, nuclear and/or cluster variants of each may be possible.
See the description of \fIkeyToggleNuclear\fP, \fIkeyToggleCluster\fP
and \fIkeyToggleModifier\fP.
.TP 12
.B Mine
Pack of mines.  Can be dropped as either moving mine (bombing) or
stationary mine (mining).  Usually these will explode when someone else
comes within a few blocks, causing a large debris explosion.  However, if
enabled, nuclear and/or cluster variants of each may be possible.
Mines have a little intelligence and will not explode for
the player (or team members) who dropped them.  However, the
targetting of mines can be effected by ECMs (unless the
server option \fIecmsReprogramMines\fP is false).  If you
get close enough to a mine, you will be able to sense who
the mine is currently programmed by.  Mines dropped by
different players have a different external appearance --
mines dropped by you or your team show up hollow.
Reprogramming does not change the appearance of a mine, so
be careful because a hollow mine may not be safe.
See the description of \fIkeyToggleNuclear\fP, \fIkeyToggleCluster\fP,
and \fIkeyToggleModifier\fP.
.TP 12
.B Tank
Additional fuel tank (perhaps with some spare fuel).  As you pick
up more tanks, your weight increases and you'll have to
compensate by picking up afterburners.  You can change which tank
is the `active tank', that is the one that fuel is drained from
(if this tank is empty, fuel is drained from all tanks).
Refueling is quicker with more tanks.

To ease filling several tanks in parallel, all the tanks drain
into their left neighbours (0<-1<-\|.\|.\|.<-8); except your
active tank, which is watertight (it seems a bit complicated at
first, but trust me, you'll get it eventually :-).  Tanks don't
drain if they reach a certain minimum level (unless of course,
you use it as the active tank).

When you detach a tank it is the active one that is detached,
unless the active tank happens to be your main tank, in which the
tank with the highest number is used.  The detached tank will
have the shape of a ship and will carry your name, it will
immediately start thrusting (as long as fuel permits) and will
fool all heat-seekers to follow it.
.TP 12
.B ECM
Electronic Counter Measures.  ECM allows you to confuse and
re-target smart missiles within a certain range of your ship.
When missiles are zapped by ECM, they will become confused for a
while and then have a high probability of going after the player
who you were locked onto when you used the ECM.  The ECM will also
cause within a certain range to either explode or be more likely 
be temporarily be blinded such that they do not explode if you go
near them.  The closest mine within ECM range may be reprogrammed
to be safe for you and your team members. If another ship
is within range of the ECM, all it's sensors will freeze for a
while and if the ship was cloaked, it will become visible for a
while.  The ECM is activated by pressing the \fIkeyECM\fP key.
.TP 12
.B Transporter
Enables you to steal equipment and energy/fuel from the closest
fighter, provided it is within the transporters range.  You
activate the transporter by pressing the \fIkeyTransporter\fP key.
.TP 12
.B Laser
Gives you a laser weapon with limited range.  Having more of these
increases the range and the repeat rate of the laser subsystem.
.TP 12
.B Emergency Thrust
Gives you a limited amount of super thrusters, equivalent to a full
complement of afterburners.  With a light ship this is equivalent
to hitting hyperspace or warp factor 9.99.  Useful for stopping quickly
or running away fast from a deadly encounter.  The extra thrust 
capability is toggled on and off by a seperate key and can thus be
saved, the amount of time remaining is shown by a status bar below the
HUD.
.TP 12
.B Autopilot
Gives you a hover capability.  When engaged an `Autopilot' light will flash
above the HUD.  When engaged the autopilot computer will bring the ship
to a hover by the quickest (perhaps not safest) method possible.  It will
then leave you in a hover, unless in a strong gravity field where your
engines cannot cope.  Useful for hovering next to a refuel depot.
.TP 12
.B Tractor Beam
Not to be confused with a transporter, this enables you to push or pull
the ship you are currently locked onto.  The force is mutual, and thus
if your ship is lighter than your target you will move more towards him
than him towards you.  Best used with heavy ships to pull then push
annoying players into walls.
.TP 12
.B Emergency Shield
Gives you a limited amount of extra shield power, which prevents any
fuel loss from shots, debris, player and wall collisions, missiles, 
mines, etc.  While in use, the ship can smash into walls at any speed
and angle without fear of being killed.  The extra shield capability
is toggled on and off by a separate key and can thus be saved, with
the remaining amount of extra shield power being saved for later use.
Once toggled on, the extra shield power will take effect and be used
only while the normal shields are up.  Best used when confronted with
cluster mines and missles or deadly cannons.
.RS -5

.SH CONTROLS

The game understands quite some keys, but not all of them are
equally important.  The following keys are more or less sorted by
importance.  The name of the keys are also the Xresources you use
to redefine them, and the words inside the curly braces {} are
their default bindings.  See \fBXresources\fP section below.
.RS 2
.TP 4
\fIPrimary keys\fP
The primary keys are:
.RS 5
.TP 12
.B keyTurnLeft {a}
Turn left (anti-clockwise).
.TP 12
.B keyTurnRight {s}
Turn right (clockwise).
.TP 12
.B keyThrust {right Shift or left Shift}
Thrust me.
.TP 12
.B keyFireShot {return or linefeed}
Fire normal shot.
.TP 12
.B keyShield {space or Caps Lock}
Raise shield.  Must be held down for continuous use.
.TP 12
.B keyRefuel {f or left Ctrl or right Ctrl}
Try to connect to nearest fuel station.  Must be held down during refueling.
.TP 12
.B keyRepair {f}
Repair a target.
.RS -5
.TP 4
\fISecondary keys\fP
The following commands are not always available, some require bonus items
to have any functionality at all.
.RS 5
.TP 12
.B keySelfDestruct {q}
Self destruct.  At last we managed to include a timer, got rid of all those
nasty I'd-rather-die-by-my-own-hands-than-let-you-kill-me-and-get-all-
the-points pilots.
.TP 12
.B keyIdMode {u}
Toggle the ID mode.  Instead of the score list it will display the list
of players with their real names and computer addresses.
.TP 12
.B keyCloak {BackSpace or Delete}
Enable/disable cloaking device if available.  You will be invisible on both
radar and on screen, but beware - the device is not foolproof, it is
not cheap on your fuel and the only thing becoming invisible is your ship,
i.e. the exhaust-flames will still be visible.
.TP 12
.B keySwapSettings {Escape}
Toggle between two different settings.  You'll probably want more power
and a larger turn rate in combat than when you're doing some critical
maneuvering.
.TP 12
.B keyDropMine {Tab}
Drop a proximity mine.  The mine will detonate after a certain amount of
time (quite large actually) or when a foe comes too near.
.TP 12
.B keyDetachMine {bracketright}
Drop a moving mine - that is, a bomb.
.TP 12
.B keyDetonateMines {equal}
Detonate the mine you have dropped or thrown, which is closest to you.
.TP 12
.B keyEcm {bracketleft}
Fire an ECM pulse.
.TP 12
.B keyChangeHome {Home or h}
Change home base.  You will need to be landed on the base of your choice.
(The \fBHome\fP key is located just right of the \fBReturn\fP key on most
HP-keyboards.)  These keys are convenient for HP keyboards, also somewhat
adapted to SUN keyboards.
.TP 12
.B keyTankNext {e}
If you have additional tanks, the current tank will be the next tank.
.TP 12
.B keyTankPrev {w}
If you have additional tanks, the current tank will be the previous tank.
.TP 12
.B keyTankDetach {r}
Detach the current tank (or the last additional tank).
Heat-seeking missiles will hopefully follow this tank.
.TP 12
.B keyPause {p or Pause}
Park or paused hover mode - you can only park while you're landed on your own
home base, and when you park, you cannot rejoin the game until
the P has stopped blinking (to prevent users from using this
option to run away from a battle).  If you are not near your base and
you are travelling very slowly the ship will be brought to a standstill
on autopilot and cannot be unpaused until the `Autopilot' light stops
blinking.
.TP 12
.B keyFireMissile {backslash}
Fire smart missile if available.  The missile will home onto the player
that you have currently locked on.  You must have \fBa clear lock\fP on a
player for this to work.  Requires lock.
.TP 12
.B keyFireHeat {semicolon}
Fire a thrust controlled missile. Works like a smart missle, but
is faster and ECM isn't able to confuse it. Needs the thrust for
navigating.
.TP 12
.B keyFireTorpedo {quoteright}
Fire a missile without flight control. It runs very fast in shot
direction.
.TP 12
.B keyFireLaser {slash}
Fires a laser weapon in the direction you are pointing.  Lasers have
limited range and use a lot of fuel, but they are instantaneous and
therefore much more deadly than normal shots.  The precise electronics
of lasers can be irretrivially damaged by the high energy interference
generated by enemy ECMs.

.TP 12
.B keyToggleNuclear {n}
Pressing this key will toggle through the following indicators on your
HUD (bottom left), only if nuclear weapons are allowed;
.RS 12
.TP 4
.B N
All missiles or mines launched from now are limited nuclear weapons.
.TP 4
.B FN
All missiles or mines launched from now are full (or fusion) nuclear
weapons.

Pressing the key again clears the nuclear weapons mode.
.RS -12
.RS -5
.RS 12

You must have eight or more missiles, or four or more mines to launch
a nuclear missile or mine, and perhaps enough fuel as well.  If you do
not a message will be displayed at the bottom of the game area explaining
why and the weapon will not be fired.  

Firing a full (or fusion) nuclear weapon completely depletes your stock
of that weapon, limited nuclear weapons will deplete your stock by eight
missiles or four mines.

A nuclear missile or mine fired will have a mass and explosive power equal
and usually greater than the total number that were used.  Nuclear torpedos
are very fast, and all nuclear weapons explode violently (this may freeze
the server momentarily).  After firing a one off nuclear weapon, the `n'
indicator is cleared.
.RE
.RS 5
.TP 12
.B keyToggleCluster {c}
Pressing this key will toggle the following indicator on your
HUD (bottom left), only if cluster weapons are allowed;
.RS 12
.TP 4
.B C
All missiles or mines launched are cluster weapons.
.RS -12
.RS -5
.RS 12

Cluster weapons explode differently from normal weapons.  The explode with
a slower moving shower of killing shots and not debris, which may kill
or deplete shields just like a normal shot fired by your self.   Thus,
since cluster debris is deadly to yourself, you should be careful when
firing such a weapon.  After firing a one off cluster weapon, the `c'
indicator is cleared.

A cluster weapon will also use an almost equivalent
amount of fuel as if you had fired the shots using your cannon, and thus
large cluster explosions will use large amounts of fuel.  If you do not
have enough fuel a message saying so will be displayed at the bottom of
the game area and the weapon will not be launched.
.RE
.RS 5
.TP 12
.B keyToggleImplosion {i}
Pressing this key will toggle the following indicator on your
HUD (bottom left), only if modifiers are allowed;
.RS 12
.TP 4
.B I
All mine and missile explosions will be implosions instead.
.RS -12
.RS -5
.RS 5
.TP 12
.B keyToggleVelocity {v}
Pressing this key will toggle through \fBV1\fP through \fBV3\fP and
to no modifier in turn.  It affects the speed of nuclear and/or cluster explosions, higher modifier
numbers produce lower explosion velocities, and thus for the most effective
nuclear cluster explosion a \fBV2\fP or \fBV3\fP modifier should be used.
.TP 12
.B keyToggleMini {x}
Pressing this key will toggle through \fBX2\fP through \fBX4\fP and
then no modifier in turn.  The number shows how many miniture mines or
missiles will be fired for every key press.  The sum total damage and
cost of using miniture weapon is equivalent to a normal weapon of that type.
.TP 12
.B keyToggleSpread {z}
Pressing this key will toggle through \fBZ1\fP through \fBZ3\fP and
then no modifier.  The higher the number the closer the spread of fire
for minature weapons, it also affects the spread of wide and rear shots,
successively narrowing the stream of bullets such that \fBV3\fP is a single
beam of shots.
.TP 12
.B keyTogglePower {b}
Pressing this key will toggle through \fBB1\fP through \fBB3\fP and then
no modifier.  The higher the number the less powerful a tractor
beam is used, mainly for conserving energy or fine adjustment in pulling
somebody around.  The power setting also affects the engine to warhead
ratio in missiles, a higher setting will cause each missile to have more
powerful engines, and thus be much quicker and more maneaverable, but at
the cost of a drastically reduced damage capability.  However when
coupled with other modifiers this can cause severe psychological
advantages, consider the effect of trying to outrun four minuture full
cluster powered up nuclear smart missiles.
.TP 12
.B keyClearModifiers {k}
Clears all current modifiers in effect.
.TP 12
.B keyLoadModifiers1 {1}
Loads the modifiers stored in bank 1, as set by the modifierBank1 resource.
.TP 12
.B keyLoadModifiers2 {2}
Loads the modifiers stored in bank 2, as set by the modifierBank2 resource.
.TP 12
.B keyLoadModifiers3 {3}
Loads the modifiers stored in bank 3, as set by the modifierBank3 resource.
.TP 12
.B keyLoadModifiers4 {4}
Loads the modifiers stored in bank 4, as set by the modifierBank4 resource.
.TP 12
.B keyToggleAutoPilot {h}
This toggles the autopilot feature.  You need atleast one Autopilot item
before this will work.
.TP 12
.B keyToggleEmergencyThrust {j}
This toggles the emergency thrust item.  You need at least one emergency
thrust item, on first turning this on the item is used up and ten seconds
or so of emergency thrust is placed at your disposal.  The time is only
used up as you thrust, and hitting this key will return you back to normal
thrust while conserving the remaining boosted thrust.  If you posses both
Autopilot and Emergency Thrust items, pressing the Meta or Alt keys will
give the equivalent of emergency brakes.
.TP 12
.B keyToggleEmergencyShield {g}
This toggles the emergency shield item.  You need at least one emergency
shield item.  When first turning on, this item is used up and ten seconds
or so of emergency shield power is placed at your disposal.  The time is 
only used up as you use your regular shields, and hitting this key again
will return you back to normal shield power while conserving the remaining
emergency shield power.
.TP 12
.B keyTractorBeam {comma}
This will engage any tractor beam items on the player who you hold a lock
on, it causes a mutual attractive force between you and them, causing both
players to move towards each other.
.TP 12
.B keyPressorBeam {period}
This will engage any tractor beam items on the player who you hold a lock
on, it causes a mutual repulsive force between you and them, causing both
players to move away from each other.
.TP 12
.B keyTalk {m}
Pressing this key will toggle between the talk window being shown below
the HUD.  If your mouse pointer is outside the window you will still
have full control of your ship and pressing the talk key will disappear
(the current message will not be lost).  If you position your mouse
pointer within the window you can type a message using the keyboard,
however you ship will no longer respond to key presses.  The following
special keys are available;
.RS 12
.TP 4
.B Return Linefeed
This finishes and sends the message.  The talk window is also removed
from the screen and the message text cleared.
.TP 4
.B Backspace Del
These keys delete the last character.
.TP 4
.B Ctrl-W
This deletes the last word.
.TP 4
.B Ctrl-U
This deletes the entire line of text.
.TP 4
.B Esc
This removes the talk window without clearing the text.  This is useful
if you are typing a message and something important in the game happens
that requires you to control your ship.
.RS -12
.RS -5
.RS 12

Messages will usually be sent to every player logged in, including
yourself.  Messages received will always appear in the bottom of the
Game area, and will look like;

.nf
\fI<<Viper shouts>> Hello world\fP.
.fi

However you can send messages to individual players or teams by starting the
message with the player's name (or enough character from the beginning
of their name to make it unique) or team number followed by a colon, and
then the message.  Just placing a colon at the start of the message
will send it to everyone.  For example;

.nf
\fIvip: Hello\fP
.fi

will send a message to only one player who's name begins the letters \fIvip\fP
(the case does not matter).
.RE
.RS 5
.TP 12
.B keyToggleCompass {y}
Turns of the HUD compass display.
.TP 12
.B keyLockClose {Select Up}
Will lock onto the closest player if he/she is within range.
.TP 12
.B keyLockNextClose {Down}
Will lock onto the next closest player after the currently locked player.
.TP 12
.B keyLockNext {Next Right}
Will, if possible, lock onto the next player in the game.
.TP 12
.B keyLockPrev {Prior Left}
Will, if possible, lock onto the previous player in the game.
.TP 12
.B keyConnector {Control_L}
Use connector (for the moment, all this is used for is picking up
treasures/balls).
.TP 12
.B keyDropBall {d}
Drop the ball if you are carrying it.
.TP 0
These keys let you adjust the control sensitivity:
.TP 12
.B keyIncreasePower {KP_Multiply}
Increase engine power.
.TP 12
.B keyDecreasePower {KP_Divide}
Decrease engine power.
.TP 12
.B keyIncreaseTurnspeed {KP_Add}
Increase turn speed.
.TP 12
.B keyDecreaseTurnspeed {KP_Subtract}
Decrease turn speed.
.TP 12
.B keyToggleOwnedItems {o}
Causes all owned bonus items to be shown either constantly or for a brief
period after they change in amount on the HUD.
.TP 12
.B keyToggleMessages {0}
Causes messages to be shown or not shown.
.TP 12
.B keyReprogram {quoteleft}
Reprogram a modifier bank or lock bank.
.TP 12
.B keyLoadLock1 {5}
Load player lock from bank 1.
.TP 12
.B keyLoadLock2 {6}
Load player lock from bank 2.
.TP 12
.B keyLoadLock3 {7}
Load player lock from bank 3.
.TP 12
.B keyLoadLock4 {8}
Load player lock from bank 4.
.TP 12
.B keyToggleRecord {KP_5}.
Toggle recording of session to file (see the recordFile option).
This recording can later be reviewed with the \fIxp-replay(6)\fP program
.TP 12
.B keyPointerControl {KP_Enter}
Toggle mouse pointer control.
.TP 12
.B keySelectItem {KP_0 KP_Insert}
Press repeatedly to select an item to drop.  A small rectangle
will be drawn around the item you can drop.  Use the \fIkeyLoseItem\fP
key to actually drop the item.  Note that you cannot select tanks
to drop, tanks can only be released (see the \fIkeyTankDetach\fP option).
.TP 12
.B keyLoseItem {KP_Delete KP_Decimal}
Drop the item selected with the \fIkeySelectItem\fP key.  The
server can either delete the item or drop it back into the map
depending upon the value of the \fIloseItemDestroys\fP option.
.TP 12
.B keyPrintMessagesStdout {Print}
Print the current messages to stdout.
.TP 12
.B keyTalkCursorLeft {Left}
Move Cursor to the left in the talk window.
.TP 12
.B keyTalkCursorRight {Right}
Move Cursor to the right in the talk window.
.TP 12
.B keyTalkCursorUp {Up}
Browsing up in the history of the talk window.
.TP 12
.B keyTalkCursorDown {Down}
Browsing down in the history of the talk window.

.RS -5
.TP 4
\fIMouse control\fP
There are up to five mouse buttons available to define as keys:
.RS 5
.TP 12
.B pointerButton1 {keyFireShot}
Define which keys are pressed when mouse button one is pressed.
.TP 12
.B pointerButton2 {keyThrust}
Define which keys are pressed when mouse button two is pressed.
.TP 12
.B pointerButton3 {keyShield}
Define which keys are pressed when mouse button three is pressed.
.TP 12
.B pointerButton4 {}
Define which keys are pressed when mouse button four is pressed.
.TP 12
.B pointerButton5 {}
Define which keys are pressed when mouse button five is pressed.
.RS -5

.SH X RESOURCES

At startup xpilot will look for X resources in several places.
First it looks in the INSTLIBDIR (as defined during compilation,
mostly as something like /usr/local/games/xpilot/lib/)
for the file named xpilot.
After that it looks for more resources in
/usr/lib/X11/$LANG/app-defaults/xpilot,
$XUSERFILESEARCHPATH/xpilot,
$XAPPLRESDIR/$LANG/xpilot,
$HOME/app-defaults/$LANG/xpilot,
resources set using xrdb or else $HOME/.Xdefaults,
host specific resources in the file pointed to by $XENVIRONMENT
or else in $HOME/.Xdefaults-hostname
and finally in $HOME/.xpilotrc.
If the LANG environment variable is undefined or if that file doesn't
exist then it will look for the file as if LANG had been undefined.
Resources defined in files listed later will override resources in
files listed earlier.
If the
.B XPILOTRC
environment variable
is defined then its value is used instead of $HOME/.xpilotrc.
All of these resources can be overridden by
their corresponding command line arguments.
.RS 5
.TP 12
.B name
Nick name of your player.
.TP 12
.B team
Preferred team number.
.TP 12
.B port
Set the port number of the server.
Almost all servers use the default port, which is the
recommended policy.  You can find out about which port
is used by a server by querying the xpilot Meta server.
.TP 12
.B power
Primary power setting of your engine.  Primary in this context means that it
is part of the default setting, secondary means the other setting (two
different settings are available, pressing \fBEsc\fP will switch between
them).  You may change "sensitivity" of your ship by adjusting these
parameters.  Often you would like one setting to be more "rough" than the
other - one setting for fine maneuvering and one for racing. (Default 45.0)
.TP 12
.B turnSpeed
Primary turnspeed setting of your ship. (Default 30.0)
.TP 12
.B turnResistance
Primary turnresistance setting of your ship.  This value determines how
fast your ship will stop rotating, i.e. the rotating speed of your ship is
set equal to itself multiplied by this value.  Obviously the value has to
lie between 0.0 (exclusive) and 1.0 (inclusive).  (Default 0.12)
.TP 12
.B altPower
Secondary power setting of your engine. (Default 35.0)
.TP 12
.B altTurnSpeed
Secondary turnspeed setting of your ship. (Default 25.0)
.TP 12
.B altTurnResistance
Secondary turnresistance setting of your ship. (Default 0.12)
.TP 12
.B shipShape
Define the ship shape to use.  Because the argument to this option
is rather large (up to 500 bytes) the recommended way to set
this option is in the .xpilotrc file in your home directory.
The exact format is defined in the file README.ships in the xpilot
distribution.  Note that there is a nifty tool called editss for
easy ship creation.  See the xpilot FAQ for details.
See also the \fBshipShapeFile\fP option.
.TP 12
.B shipShapeFile
An optional file where shipshapes can be stored.
If this resource is defined and it refers to an existing file
then shipshapes can be referenced to by their name.
For instance if you define shipShapeFile to be
/home/myself/.shipshapes and this file contains one or more
shipshapes then you can select the shipshape by starting xpilot as:

xpilot -shipShape myshipshapename

Where "myshipshapename" should be the "name:" or "NM:" of
one of the shipshapes defined in /home/myself/.shipshapes.
Each shipshape definition should be defined on only one line.
All characters up to the first left parenthesis are ignored.
.TP 12
.B fuelNotify
The limit when the HUD fuel bar will become visible. (Default 500.0)
.TP 12
.B fuelWarning
The limit when the HUD fuel bar will start flashing. (Default 200.0)
.TP 12
.B fuelCritical
The limit when the HUD fuel bar will flash faster. (Default 100.0)
.TP 12
.B showHUD
Should the HUD be on or off. (Default true)
.TP 12
.B verticalHUDLine
Should the vertical lines in the HUD be drawn. (Default false)
.TP 12
.B horizontalHUDLine
Should the horizontal lines in the HUD be drawn. (Default true)
.TP 12
.B speedFactHUD
Should the HUD me moved, to indicate the current velocity. Negativ values will
inverse the moving of the HUD. (Default 0.0)
.TP 12
.B speedFactPTR
Uses a red line to indicate the current velocity. On edge of the line is the
center of the ship. The other end is moved in the same way, as the HUD, if
speedFactPTR is set.
.TP 12
.B charsPerSecond
This determines the speed in which messages are written, in characters
per second.
.TP 12
.B markingLights
Should the fighters have marking lights, just like airplanes?
.TP 12
.B sparkProb
The chance that sparks are drawn or not.
This gives a sparkling effect.
Valid values are in the range [0.0-1.0]
.TP 12
.B sparkSize
Size of sparks in pixels.
.TP 12
.B selectionAndHistory
Provide cut-and-paste for the player messages and the talk window and
a `history' for the talk window.
.TP 12
.B -maxLinesInHistory
Number of your messages saved in the `history' of the talk window.
`History' is accessible with `keyTalkCursorUp/Down'.
Valid values are in the range [1-128]. The default value is: 32.
.TP 12
.B shotSize
Size of shots in pixels.
.TP 12
.B teamShotSize
Size of team shots in pixels.
.TP 12
.B showShipName
Should all ships have the name of the player drawn below them.
.TP 12
.B showMineName
Should the name of the owner of the mine be drawn below the mine.
.TP 12
.B showMessages
Should messages appear on screen.
.TP 12
.B showItems
Should owned items be displayed permanently on the HUD,
or only when their amount has changed?
.TP 12
.B showItemsTime
The time in seconds to display item information when
it has changed and the showItems option is turned on.
.TP 12
.B clock
Display a small digital clock.
.TP 12
.B clockAMPM
Displays clock in 24hr or 12hr format. (Default: False)
.TP 12
.B noLocalMotd
Do not display the local Message Of The Day.
.TP 12
.B autoServerMotdPopup
Automatically popup the MOTD of the server on startup.
.TP 12
.B toggleShield
Have the shield status be changed only by a key press and ignore the
key release.
.TP 12
.B autoShield
When this option is on then shields are lowered automatically
when firing a weapon or dropping a mine.  After the firing
the shields are raised again too.
.TP 12
.B shieldDrawSolid
Are shields drawn in a solid line.
Not setting a value for this option will select the best value
automatically for your particular display system.
.TP 12
.B fuelMeter
Determines if the fuel meter should be visible. This meter visualizes your
fuel level in a different way than \fBfuelGauge\fP does.
.TP 12
.B fuelGauge
Determines if the fuel gauge should be visible. See \fBfuelMeter\fP.
.TP 12
.B turnSpeedMeter
Should the turnspeed meter be visible at all times. (Default false)
.TP 12
.B powerMeter
Should the power meter be visible at all times. (Default false)
.TP 12
.B backgroundPointDist
Specifies the block distance between points drawn in the background,
used in empty map regions.  8 is default, 0 means no points.
.TP 12
.B backgroundPointSize
Specifies the size of the background points.  The default is 2,
0 means no points.
.TP 12
.B titleFlip
Should the title bar change or not.
Some window managers like twm may have problems with
flipping title bars.  Hence this option to turn it off.
.TP 12
.B slidingRadar
If the game is in edgewrap mode (see \fIxpilots(6)\fP) then the
radar will keep your position on the radar in the center and
draw the rest of the radar around it.  This requires very
good X performance and a pretty fast workstation.  Default is off.
.TP 12
.B outlineWorld
Draws only the outline of all the blue map constructs.
.TP 12
.B filledWorld
Draws the walls solid.  Needs a fast graphics system.
.TP 12
.B texturedWalls
Draws the walls filled with a texture pattern.
See also the wallTextureFile option.
Be warned that this needs a very fast graphics system.
.TP 12
.B wallTextureFile
Specify a XPM format pixmap file to load the wall texture from.
.TP 12
.B texturePath
Optional search path for XPM texture files.
This is a list of one or more directories separated by colons.
.TP 12
.B packetSizeMeter
Turns on a meter displaying the maximum packet size of the last few seconds.
.TP 12
.B packetLostMeter
Turns on a meter displaying the percentage of packets lost in the last second
due to network failure (overload).
.TP 12
.B packetDropMeter
Turns on a meter displaying the percentage of packets dropped due to your
display not being able to keep up with the rate at which the server is
generating frame updates.  If possible lower the frame update rate of
the server with the -fps option.
.TP 12
.B receiveWindowSize
Specifies how big the receive window should be.  See
\fBNOTES\fP below.
.TP 12
.B sounds
Specifies the sound file.  (Only if sound is enabled.)
.TP 12
.B maxVolume
Specifies the volume to play sounds with, where 0 turns off
sound.  (Only if sound is enabled.)
.TP 12
.B audioServer
Specifies the audio server to use.  (Only if sound is enabled.)
.TP 12
.B geometry
Specifies the geometry to use like: -geometry 1280x1024+0+0.
.TP 12
.B keyboard
Set the X keyboard input if you want keyboard input from
another display.  The default is to use the keyboard input from
the X display.
.TP 12
.B recordFile
An optional file where a recording of a game can be made.
If this file is undefined then recording isn't possible.
See the keyToggleRecord option for how to make recordings.
.TP 12
.B visual
Specifies which visual to use.  You can see which visuals your
display supports by running: xpilot -visual list.
.TP 12
.B mono
Turns on mono display type.
.TP 12
.B colorSwitch <true/false>
Tells xpilot to use a color switching display technique or not.
Default is true if your display hardware has enough colors available.
.TP 12
.B maxColors
Tells xpilot how many colors you want it to use.
Default is 4, with a maximum of 16.  Valid values are 4, 8 and 16.
.TP 12
.B targetRadarColor
Which color number to use for drawing targets on the radar.
Valid values all powers of 2 smaller than maxColors.
.TP 12
.B hudColor
Specifies which color index to use for drawing the HUD.
The value for this option is a number ranging from 1 till the maxColors value.
.TP 12
.B hudLockColor
Specifies which color index to use for drawing the lock dot on the HUD.
The value for this option is a number ranging from 1 till the maxColors value.
.TP 12
.B wallColor
Specifies which color index to use for drawing the walls.
The value for this option is a number ranging from 1 till the maxColors value.
.TP 12
.B sparkColors
A list of color numbers to use for drawing sparks and debris
of varying temperature.
.TP 12
.B gameFont
The font used on the HUD and for nearly all text part of the game
field.
.TP 12
.B messageFont
The font used for messages displayed in the bottom left corner of
the game field.
.TP 12
.B scoreListFont
The font used on the score list.  Must be non-proportional.
.TP 12
.B buttonFont
The font used on all buttons.
.TP 12
.B textFont
The font used in the help and about windows.
.TP 12
.B talkFont
The font used in the talk window.
.TP 12
.B motdFont
The font used in the MOTD window and in the key list window.
This must be a non-proportional font.
.TP 12
.B black
Specifies the color to use for black.  Default is #000000 which is equivalent
to specifying Black.
.TP 12
.B white
Specifies the color to use for white.  Default is #FFFFFF which is equivalent
to specifying White.
.TP 12
.B blue
Specifies the color to use for blue.
.TP 12
.B red
Specifies the color to use for red.
.TP 12
.B color0
Specifies the color to use for color 0.  One can specify colors
up to color15 this way.  Black, white, blue and red are equivalent to
color0, color1, color2 and color3 respectively.
.RS -5


.SH INVOCATION EXAMPLES

The simplest invocation of the hand-shake program is to just type:
.IP
.B xpilot
.PP

This will force the program to search after a server on all the
machines on your attached network.

Say you know where the server is, and you don't want to be
prompted (handy in scripts etc.), you may type for example:
.IP
.B xpilot -join lglab08

where lglab08 is the name of the host running the server.
.PP
In the examples above your name would be your \fBlogin name\fP.
Let's say you want to be really cool and your login name is
.B gudmari,
well - you're in loads of trouble if you don't know about the
.B -name
option;
.IP
.B xpilot -name FireEater
.PP
will fix the problem for you.


.SH NOTES

For credit list, see the provided CREDITS file.


If the client crashes, you will be without autorepeat on your
keyboard.  To re-enable autorepeat, issue this command:
.IP
.B xset r
.PP
Please also note that xpilot can be addictive, and strenous
for both you and your keyboard.  We take no responsibility. :)


There is a \fBmeta server\fP running on \fBmeta.xpilot.org\fP,
port \fB4400\fP, into which all servers registers.  This way you
can easily check if there are any servers running nearby.  To use
it, try:
.IP
.B telnet meta.xpilot.org 4400
.B help
.B list
.PP

Or:
.IP
.B telnet meta.xpilot.org 4401
.PP

If you experience any problems with `jerkiness', you should try
to adjust the \fIreceiveWindowSize\fP Xresource.  The problem may
be that your X server can't display as fast as the xpilot server
is generating new frame updates.  So another option is setting
the number of frames for the server to a lower number or get a
faster X display system :)

The \fIreceiveWindowSize\fP resource allows you to tune the
buffering of frame updates a little.  When set to one then there
is no buffering and \fBxpilot\fP will just read the next frame
and display it.  When the display is slower than the xpilot
server this may give all sorts of problems like lagging behind
and lack of keyboard control.

When you set \fIreceiveWindowSize\fP to two then \fBxpilot\fP
will always try to read a second frame from the network and if
this succeeds it will discard the oldest frame.  A better number
for \fIreceiveWindowSize\fP is three which will discard the
oldest frame out of three and therefore be less subject to small
changes in network delivery times.  If your display is fast enough
and can keep up with rate at which the server is generating frames
then specifying a value bigger than one will not result in dropping
frames, but rather will it be a buffer for small changes in network
performance and computer load.  The maximum value of
\fIreceiveWindowSize\fP is four.


.SH ENVIRONMENT

If
.B XPILOTRC
is set then its value is used instead of $HOME/.xpilotrc
to find the file containing the xpilot resources.
.B XPILOTUSER
and 
.B XPILOTHOST
set the loginname and hostname as reported to the xpilots server.


.SH AUTHORS

\fBXPilot\fP was developed by
Bjrn Stabell <bjoern@xpilot.org> and
Ken Ronny Schouten <ken@xpilot.org> from the University of Troms, 
Bert Gijsbers <bert@xpilot.org> from the University of Amsterdam,
and Dick Balaska <dick@xpilot.org> from BuckoSoft.COM.


.SH BUG REPORTS

The product is seemingly stable, so bug reports are highly
appreciated.  Send email to \fBxpilot@xpilot.org\fP and we will
see what we can do.  We merely ask that you remember to include
the following information:
.IP
.PD 0
.RS 4
\(bu The platforms the bug occurs on
.TP
\(bu What kind of display you have (depth, color, type)
.TP
\(bu Which Xresources you're using.
.TP
\(bu The full version of xpilot, i.e., 4.4.3
.TP
\(bu What the bug looks like (symptoms)
.TP
\(bu When the bug usually occurs
.PP
.PD
.IP
.RS -4
We would also like to receive changes you do to make the code
compile on your machine (we would NOT like to receive the whole
program translated to K&R C, keep it ANSI :) If you don't have an
ANSI compiler, there are several utilities which may help you
de-ANSI-fy the code (unproto, unprotoize etc), but a better solution
will be to install the GNU C compiler on your system.


.SH COPYRIGHT & DISCLAIMER

xpilot is Copyright  1991-2001 by Bjrn Stabell, Ken Ronny Schouten, Bert Gijsbers & Dick Balaska.  xpilot comes with ABSOLUTELY NO WARRANTY;
for details see the provided LICENSE file.


.SH FILES
.PD 0
.TP 40
.B /usr/local/games/lib/xpilot/motd
Message of the day.
.TP
.B /usr/local/games/lib/xpilot/sounds
File containing the sound to sound-file mapping.
.PD

.SH SEE ALSO
xpilots(6), xp-replay(6)
.\"
.\" index		\fIxpilot\fP \- multiplayer war game
.\" index		\fIxpilots\fP \- server module for xpilot
