/*
 * Copyright (c) 1993, 1999 Alexandre Wennmacher (wennmach@geo.Uni-Koeln.DE)
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * This product includes software developed by Alexandre Wennmacher.
 * 4. The name of Alexandre Wennmacher may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY ALEXANDRE WENNMACHER AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALEXANDRE WENNMACHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <sys/param.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

/*
 * returns absolute pathname of progname
 */

char *
getmyabspath(char *progname, char *path)
{
    char *retval;
    char *token;
    char cwd[MAXPATHLEN];
    char resolvedpath[MAXPATHLEN];
    char testpath[MAXPATHLEN];
    size_t len;

/* If progname starts with a '/' it already is an absolute pathname.
 * Just test if this pathname exists and return.
 */

    if (*progname == '/') {
        if (access(progname, X_OK) == 0) {
/* progname is already an absolute pathname */
            (void)realpath(progname, resolvedpath);
            len = strlen(resolvedpath) + 1;
            retval = (char *)malloc(len*sizeof(char));
            strcpy(retval, resolvedpath);
            return retval;
        } else 
            return NULL;
    }

    if (strchr(progname, '/') != NULL) {
        if (access(progname, X_OK) == 0) {
/* progname is a relative pathname */
            (void)getcwd(cwd, MAXPATHLEN);
            (void)strcpy(testpath, cwd);
            (void)strcat(testpath, "/");
            (void)strcat(testpath, progname);
            (void)realpath(testpath, resolvedpath);
            len = strlen(resolvedpath) + 1;
            retval = (char *)malloc(len*sizeof(char));
            strcpy(retval, resolvedpath);
            return retval;
        } else
            return NULL;
    }

/* O.k., progname must be somewhere in the path */
    if (path == NULL)
        return NULL;

    token = strtok(path, ":");
    while (token != NULL) {
        (void)strcpy(testpath, token);
        (void)strcat(testpath, "/");
        (void)strcat(testpath, progname);
        if (access(testpath, X_OK) == 0) {
            (void)realpath(testpath, resolvedpath);
            len = strlen(resolvedpath) + 1;
            retval = (char *)malloc(len*sizeof(char));
            (void)strcpy(retval, resolvedpath);
            return retval;
        }
        token = strtok(NULL, ":");
    }

/* Not found */
    return NULL;
}
