untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcSd6gch2dJ4KcBbYVjVhIMW7zRz83fdJTX6VIozZwXyapIKzPle9zbjrrcmotwZA9yUCazOJy0k/mnezW0jkMws=

OpenBSD 6.4 errata 010, December 22, 2018:

The setsockopt(2) system call could overflow mbuf cluster kernel
memory by 4 bytes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 010_pcbopts.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_output.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_output.c,v
retrieving revision 1.348
diff -u -p -r1.348 ip_output.c
--- sys/netinet/ip_output.c	28 Aug 2018 15:15:02 -0000	1.348
+++ sys/netinet/ip_output.c	20 Dec 2018 12:39:51 -0000
@@ -1255,7 +1255,7 @@ ip_pcbopts(struct mbuf **pcbopt, struct 
 	 * actual options; move other options back
 	 * and clear it when none present.
 	 */
-	if (m->m_data + m->m_len + sizeof(struct in_addr) >= &m->m_dat[MLEN])
+	if (m_trailingspace(m) < sizeof(struct in_addr))
 		return (EINVAL);
 	cnt = m->m_len;
 	m->m_len += sizeof(struct in_addr);
