untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8op1NpyhleEAU/waCeO4T+4iWA0e1C7UzgMmH74v24z5mbmGYO6nGMADbbV1uOi/RskGdI1+EOCFo4nRB8gDMEQA=

OpenBSD 7.6 errata 013, April 9, 2025:

sshd(8) fix the DisableForwarding directive, which was failing to
disable X11 forwarding and agent forwarding as documented.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 013_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install OpenSSH:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/session.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/session.c,v
diff -u -p -r1.338 session.c
--- usr.bin/ssh/session.c	17 May 2024 00:30:24 -0000	1.338
+++ usr.bin/ssh/session.c	3 Apr 2025 09:47:33 -0000
@@ -1858,7 +1858,8 @@ session_auth_agent_req(struct ssh *ssh, 
 	if ((r = sshpkt_get_end(ssh)) != 0)
 		sshpkt_fatal(ssh, r, "%s: parse packet", __func__);
 	if (!auth_opts->permit_agent_forwarding_flag ||
-	    !options.allow_agent_forwarding) {
+	    !options.allow_agent_forwarding ||
+	    options.disable_forwarding) {
 		debug_f("agent forwarding disabled");
 		return 0;
 	}
@@ -2241,7 +2242,7 @@ session_setup_x11fwd(struct ssh *ssh, Se
 		ssh_packet_send_debug(ssh, "X11 forwarding disabled by key options.");
 		return 0;
 	}
-	if (!options.x11_forwarding) {
+	if (!options.x11_forwarding || options.disable_forwarding) {
 		debug("X11 forwarding disabled in server configuration file.");
 		return 0;
 	}
