#!/usr/bin/perl
# Copyright (C) 2007  Sylvain Beucler
# 
# This file is part of Savane.
# 
# Savane is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# 
# Savane is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# 
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Init GIT repository.

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(GitMakeArea);
our $version = 1;

sub GitMakeArea {
    my ($name,$dir_git) = @_;
    my $warning = '';

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_git =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_git) {
	# Layout: /srv/git/sources/project_name.git
        #         /srv/git/sources/project_name/other_module.git (TODO)
	
	# Create a repository
	# Define the git repository we work on
	$ENV{'GIT_DIR'} = $dir_git;

        # --shared sets g+s on directories
	system('git', 'init', '--shared=all');
	
	system('chgrp', '-R', $name, $dir_git);
        # needed to make the repo accessible via bare HTTP
	open(HOOK, ">$dir_git/hooks/post-update") or warn $!;
	print HOOK "#!/bin/sh\n";
	print HOOK "exec git update-server-info\n";
	close(HOOK);
	system('chmod', '+x', $dir_git.'/hooks/post-update');
	# forbid access to hooks
	system('chown', '-R', 'root:', $dir_git.'/hooks');
	system('chattr', '+i', $dir_git.'/hooks');

	# Create folder for subrepositories (need to code multi-repo support first)
	# TODO: precise directory location
	#system('mkdir', '-m', '2775', ".../$name/");
	#system('chown', "root:$name", ".../$name/");

	# 'git-cvsserver' support
	system('git', 'config', 'gitcvs.pserver.enabled', 1);
	system('git', 'config', 'gitcvs.ext.enabled', 0);
	system('git', 'config', 'gitcvs.dbname', '%G/gitcvs-db/sqlite');
	my $sqlite_dir = "$dir_git/gitcvs-db";
	system('mkdir', $sqlite_dir, '-m', '755');
	system('chown', 'nobody', $sqlite_dir);

	# Clean-up environment
	delete $ENV{'GIT_DIR'};

	return ' '.$dir_git.$warning;	
    }
    return 0;
}
