/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef ACTIVITYHANDLER_H
#define ACTIVITYHANDLER_H

#include <QObject>
#include <QVariantList>
#include <QTimer>
#include <QDateTime>
#include <QStringList>

#include <QDebug>

#include <QXmppClient.h>
#include <QXmppMucManager.h>

#include "globalobject.h"
#include "variableparser.h"
#include "helpers.h"


class ActivityHandler : public QObject
{
    Q_OBJECT

public:
    explicit ActivityHandler(GlobalObject *globalObject, QObject *parent = 0);
    ~ActivityHandler();

    void setActivityData(QVariantList dataList);

    QXmppPresence::AvailableStatusType presenceFromIndex(int presenceType);


signals:


public slots:
    void onMainTimerTick();
    void activityFinished();


private:
    QXmppClient *xmppClient;
    QXmppMucManager *mucManager;

    QVariantList activityDataList;

    QTimer *mainTimer;
    QTimer *currentActivityTimer;


    QVariantMap doneToday;
    QString activityInProgress;

    QStringList m_allRecipientJids;
    QStringList messagesAfter;

    QXmppPresence::AvailableStatusType oldStatusType;
    QString oldStatusMessage;


    GlobalObject *globalObj;
    VariableParser *varParser;
};

#endif // ACTIVITYHANDLER_H
