/*
 *   This file is part of AkariXB
 *   Copyright 2015-2018  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */


#include "identitymodule.h"


IdentityModule::IdentityModule(GlobalObject *globalObject,
                               QWidget *parent) : QWidget(parent)
{
    this->m_globalObject = globalObject;

    m_dataFile = new DataFile(m_globalObject->getDataDirectory()
                              + "/identity.axb",
                              this);


    m_nickLineEdit = new QLineEdit(this); // Multinicks? -- FIXME

    // Add formal name field? Last name fields?


    m_updateButton = new QPushButton(QIcon::fromTheme("document-save",
                                                      QIcon(":/images/button-save.png")),
                                     tr("&Update"),
                                     this);
    connect(m_updateButton, &QAbstractButton::clicked,
            this, &IdentityModule::updateData);


    m_formLayout = new QFormLayout();
    m_formLayout->addRow(tr("Nickname"), m_nickLineEdit);

    m_mainLayout = new QVBoxLayout();
    m_mainLayout->addLayout(m_formLayout);
    m_mainLayout->addStretch(1);
    m_mainLayout->addWidget(new QLabel("Formal name,\n"
                                       "likes and dislikes, etc.", this),
                            0, Qt::AlignCenter); // TMP-------------------------------
    m_mainLayout->addStretch(2);
    m_mainLayout->addWidget(m_updateButton, 0, Qt::AlignRight);
    this->setLayout(m_mainLayout);

    this->loadIdentity();

    qDebug() << "IdentityModule created";
}

IdentityModule::~IdentityModule()
{
    qDebug() << "IdentityModule destroyed";
}



void IdentityModule::loadIdentity()
{
    const QVariantList identityDataList = m_dataFile->loadData();

    QVariantMap identityMap;
    if (!identityDataList.isEmpty())
    {
        identityMap = identityDataList.first().toMap();
    }

    QString nickname = identityMap.value("nickname").toString();
    if (nickname.isEmpty())
    {
        nickname = "AkariXB"; // Default
    }
    m_nickLineEdit->setText(nickname);
    m_globalObject->setOwnNickname(nickname);


    // Load other values, likes list, dislikes list, etc


    if (!identityDataList.isEmpty())
    {
        m_globalObject->addToLog(tr("Loaded identity data for %1.",
                                    "%1 is a nickname").arg(nickname));
    }
}


//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// SLOTS //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


void IdentityModule::updateData()
{
    QString nickname = m_nickLineEdit->text().trimmed();
    if (nickname.isEmpty())
    {
        nickname = "AkariXB";  // Default
        m_nickLineEdit->setText(nickname);
    }

    m_globalObject->setOwnNickname(nickname);


    QVariantMap identityMap;
    identityMap.insert("nickname", nickname);
    // TODO: Insert other key:value pairs


    QVariantList identityDataList;
    identityDataList.append(identityMap);
    m_dataFile->saveData(identityDataList);

    m_globalObject->addToLog(tr("Saved identity data for %1.",
                                "%1 is a nickname").arg(nickname));
}

