/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "gtkshell.h"


/* Taken from the GTK+ Reference Manual */
void
gsh_file_dialog(GtkFileChooserAction action)
{
	GtkWidget *dialog;

	dialog=
		gtk_file_chooser_dialog_new(
			"File Chooser",
			GTK_WINDOW(gsh_window),
			action,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
			NULL);

	if(gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
	{
		gchar *name;
		name=gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
		puts(name);
		g_free(name);
	}

	exit(0);
}

void
gsh_file_open_dialog()
{
	gsh_file_dialog(GTK_FILE_CHOOSER_ACTION_OPEN);
}

void
gsh_file_save_dialog()
{
	gsh_file_dialog(GTK_FILE_CHOOSER_ACTION_SAVE);
}

void
gsh_folder_create_dialog()
{
	gsh_file_dialog(GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER);
}

void
gsh_folder_open_dialog()
{
	gsh_file_dialog(GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
}

