/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

GtkWidget *scrolled_window;
extern char *gsh_geometry;
gboolean gsh_dont_scroll=FALSE;

void
gsh_setup_scrolled_window()
{
	scrolled_window=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(
		GTK_SCROLLED_WINDOW(scrolled_window),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type(
		GTK_SCROLLED_WINDOW(scrolled_window),
		GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(gsh_window), 
		scrolled_window);
	gtk_widget_show(scrolled_window);

}

void
gsh_setup_containers()
{
 	gsh_hbox = gtk_hbox_new(FALSE, 2);
	
	if(!gsh_dont_scroll)
	{
		gsh_setup_scrolled_window();
		gtk_scrolled_window_add_with_viewport(
			GTK_SCROLLED_WINDOW(scrolled_window), 
			gsh_hbox);
	}
	else
	{
		gtk_container_add(GTK_CONTAINER(gsh_window),
			gsh_hbox);
	}

 gtk_widget_show(gsh_hbox);
 gsh_vbox = gtk_vbox_new(FALSE, 2);
 gtk_container_add(GTK_CONTAINER(gsh_hbox), gsh_vbox);
 gtk_widget_show(gsh_vbox);
}

void
gsh_set_geometry()
{
	assert(gsh_geometry);
	gtk_window_parse_geometry(GTK_WINDOW(gsh_window), 
		gsh_geometry);
}
void
gsh_check_and_set_geometry()
{
	if(gsh_geometry!=NULL)
	{	
		gsh_set_geometry();
		free(gsh_geometry);
	}
	else
	{
		asprintf(&gsh_geometry, "500x300");
		gsh_set_geometry();
		free(gsh_geometry);
	}

}

int
main(int argc, char **argv)
{
 	gtk_init(&argc, &argv);

 	gsh_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect (gsh_window, "delete-event",
		G_CALLBACK (gtk_main_quit), NULL);
  	g_signal_connect (gsh_window, "destroy",
		G_CALLBACK (gtk_main_quit), NULL); 

	if(((argc > 1) && (strlen(argv[1]) == 3)) 
		&& !strncmp(argv[1], "-os", 3))
	{
		gsh_dont_scroll=TRUE;
	}
	gsh_setup_containers();
 	gsh_parse_arguments(argc, argv);

	gsh_check_and_set_geometry();

 	gtk_widget_show(gsh_window);
	
 	gtk_main();

	return (0);
}
