/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

gboolean gsh_updater_defined=FALSE;
unsigned int gsh_update_period=1000;
struct gsh_updated_struct *gsh_updates=NULL;
/* #define DEBUG */

void
gsh_initialize_update_struct()
{
	gsh_updates=(struct gsh_updated_struct*)               
		xmalloc(sizeof(struct gsh_updated_struct));    
	gsh_updates->next=NULL;
}

void
gsh_check_updates_initialization()
{
#ifdef DEBUG
	puts("gsh_check_updates_initialization()");
#endif
	if(gsh_updates==NULL)
        {
		gsh_initialize_update_struct();
        }
}

void
gsh_iterate_to_end(struct gsh_updated_struct *iterator)
{
	while(iterator->next!=NULL) 
        {
                iterator=iterator->next;
        }
}

void
gsh_add_to_updates(struct gsh_updated_struct *update)
{
	struct gsh_updated_struct *iterator;

#ifdef DEBUG
	puts("gsh_add_to_updates()");
#endif
	gsh_check_updates_initialization();
	
	iterator=gsh_updates;

	gsh_iterate_to_end(iterator);

	iterator->next=update;
}

void
gsh_add_update(void (*function)(char*, void*),
	char *command, void *widget)
{
	struct gsh_updated_struct *item;

#ifdef DEBUG
	puts("gsh_add_update()");
#endif

	item=(struct gsh_updated_struct*)xmalloc(
		sizeof(struct gsh_updated_struct));

	item->next=NULL;
	asprintf(&item->command, "%s", command);
	item->widget=widget;
	item->function=function;

	gsh_add_to_updates(item);
}



void
gsh_start_updates()
{
#ifdef DEBUG
	puts("gsh_start_updates()");
#endif
	gsh_perform_updates(NULL);
	g_timeout_add(gsh_update_period, gsh_perform_updates, NULL);	
}
void
gsh_perform_updates_iterate(struct gsh_updated_struct *iterator)
{
	while(iterator->next!=NULL)                                    
        {
#ifdef DEBUG
        puts("gsh_perform_updates().while");
#endif          
                assert(iterator->command);
                assert(iterator->widget);
                iterator=iterator->next;
                iterator->function(iterator->command, iterator->widget);
	}	
}

gint
gsh_perform_updates(gpointer data)
{
	struct gsh_updated_struct *iterator;
#ifdef DEBUG
	puts("gsh_perform_updates()");
#endif
	
	data=NULL; /* DATA is unused.  */

	gsh_check_updates_initialization();
	
	/* First element is NULL.  */
	iterator=gsh_updates->next; 
	iterator->function(iterator->command, iterator->widget);
	
	gsh_perform_updates_iterate(iterator);
	
	return(TRUE);	
}

