/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com
 
  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

/* Free the returned value!  */
char*
antiright_beautified_label(char* current_argument_string)
{
      char *label_string=xmalloc(strlen(current_argument_string));
      int parse_counter;
      int label_counter;
      
      for(parse_counter=strlen(current_argument_string);
	  ((current_argument_string[parse_counter])!=' ' && (parse_counter>0));
	  parse_counter--);

      for(label_counter=0;
	  current_argument_string[parse_counter]!='\0';
	  parse_counter++)
	{
	  if(current_argument_string[parse_counter] == ' ')
	    {
	      parse_counter++; /* This gets rid of an extra leading
				  space.  */
	    }
	  if(current_argument_string[parse_counter] != '_')
	    {
	      label_string[label_counter]=
		current_argument_string[parse_counter];
	    }
	  else
	    {
	      label_string[label_counter]=' ';
	    }
	  label_counter++;
	}

      /* Ensure that the string is null-terminated.  */
      label_string[label_counter]='\0';

      return(label_string);
}

/* char* */
/* antiright_insert_string(char *text, char *insertion, unsigned int position) */
/* { */
/*   /\* Declare a counter for the output text.  *\/ */
/*   unsigned int output_counter=0; */
/*   /\* Declare a counter for the initial text.  *\/ */
/*   unsigned int text_counter=0; */
/*   /\* Declare a counter for the inserted text.  *\/ */
/*   unsigned int insertion_counter=0; */
/*   /\* Store these lengths to avoid excessive function calls.  *\/ */
/*   const unsigned int text_length=strlen(text); */
/*   const unsigned int insertion_length=strlen(insertion); */
/*   /\* Allocate enough memory to hold both strings and a null */
/*      character.  *\/ */
/*   char *output=(char*)xmalloc(text_length+insertion_length+1); */
/*   /\* Put all text before insertion point into output buffer.  *\/ */
/*   while(text_counter < position) */
/*     { */
/*       output[text_counter]=text[text_counter]; */
/*       text_counter++; */
/*     } */
/*   /\* Start inserting at position.  *\/ */
/*   output_counter=position; */
/*   while(insertion_counter <= insertion_length) */
/*     { */
/*       output[output_counter]=insertion[insertion_counter]; */
/*       output_counter++; */
/*       insertion_counter++; */
/*     } */
/*   /\* Add the rest of the initial text to the output.  *\/ */
/*   while(text_counter <= text_length) */
/*     { */
/*       output[output_counter]=text[text_counter]; */
/*       text_counter++; */
/*       output_counter++; */
/*     } */
/*   /\* Set the end of the output to be null terminated.  *\/ */
/*   output[output_counter]='\0'; */
/*   /\* The function user must make sure that the returned string is */
/*      freed after use.  *\/ */
/*   return(output); */
/* } */

/* char* */
/* antiright_delete_range(char *text, unsigned int start, unsigned int end) */
/* { */
/*   /\* Store the length of TEXT.  *\/ */
/*   const unsigned int text_length=strlen(text); */
/*   /\* Create an output string large enough to hold TEXT.  *\/ */
/*   char *output=(char*)xmalloc(text_length+1); */
/*   /\* Declare a counter for the text.  *\/ */
/*   unsigned int text_counter=0; */
/*   /\* Declare a counter for the output.  *\/ */
/*   unsigned int output_counter=0; */
/*   /\* Assign OUTPUT until START.  *\/ */
/*   while(text_counter < start) */
/*     { */
/*       /\* TEXT_COUNTER could be used but it is a clearer design to use */
/* 	 OUTPUT_CONUTER for assignment to OUTPUT.  *\/ */
/*       output[output_counter]=text[text_counter]; */
/*       output_counter++; */
/*       text_counter++; */
/*     } */
/*   /\* This sets the position at which assignment will once again start, */
/*      removing all text between start and end through such.  *\/ */
/*   text_counter=end+1; */
/*   /\* Start assignment from the character after END.  *\/ */
/*   while(text_counter <= text_length) */
/*     { */
/*       output[output_counter]=text[text_counter]; */
/*       text_counter++; */
/*       output_counter++; */
/*     } */
/*   /\* Set the end of the output to be null terminated.  *\/ */
/*   output[output_counter]='\0'; */
/*   /\* The function user must make sure that the returned string is */
/*      freed after use.  *\/ */
/*   return(output); */
/* } */

/* char* */
/* ar_insert_txt(char* source, char* text, unsigned int position) */
/* { */
/* 	unsigned int text_length, source_length, counter, text_counter; */
/* 	char* new_txt; */

/* 	source_length=strlen(source); */
/* 	text_length=strlen(text); */

/* 	new_txt=(char*)xmalloc(source_length+text_length+1); */
/* 	for(counter=0; counter<position; counter++) */
/* 	{ */
/* 		new_txt[counter]=source[counter]; */
/* 	} */
/* 	for(text_counter=0; text_counter<=text_length; text_counter++) */
/* 	{ */
/* 		new_txt[counter+text_counter]=text[text_counter]; */
/* 	} */
/* 	for(;counter<=(source_length+text_length); counter++) */
/* 	{ */
/* 		new_txt[counter+text_counter]=source[counter]; */
/* 	} */
/* 	return(new_txt); */
/* } */

