/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

void
gsh_setup_scrolled_window(struct GSH *gsh)
{
	gsh->scrolled_window=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(
		GTK_SCROLLED_WINDOW(gsh->scrolled_window),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type(
		GTK_SCROLLED_WINDOW(gsh->scrolled_window),
		GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(gsh->window), 
		gsh->scrolled_window);
	gtk_widget_show(gsh->scrolled_window);

}

void
gsh_setup_containers(struct GSH *gsh)
{
 	gsh->rows.h = gtk_hbox_new(FALSE, 2);
	
	if(!gsh->flags.dont_scroll)
	{
		gsh_setup_scrolled_window(gsh);
		gtk_scrolled_window_add_with_viewport(
			GTK_SCROLLED_WINDOW(gsh->scrolled_window), 
			gsh->rows.h);
	}
	else
	{
		gtk_container_add(GTK_CONTAINER(gsh->window),
			gsh->rows.h);
	}

 gtk_widget_show(gsh->rows.h);
 gsh->rows.v = gtk_vbox_new(FALSE, 2);
 gtk_container_add(GTK_CONTAINER(gsh->rows.h), gsh->rows.v);
 gtk_widget_show(gsh->rows.v);
}



