/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

GtkWidget *
gsh_create_main_window()
{
	GtkWidget *window;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (window, "delete-event",
		G_CALLBACK (gtk_main_quit), NULL);
  	g_signal_connect (window, "destroy",
		G_CALLBACK (gtk_main_quit), NULL); 

	return(window);		
}
void
gsh_GSH_Flags(struct GSH_Flags *flags)
{
	flags->dont_scroll=FALSE;
	flags->button_exits=FALSE;
	flags->updating=FALSE;
}
void
gsh_GSH_Rows(struct GSH_Rows *rows)
{
	/* rows->row is initialized by gsh_manage.  */
	rows->rows=8;
}
void
gsh_GSH(struct GSH *gsh)
{
	gsh->geometry=NULL;
	gsh->update_period=1000;
	gsh_GSH_Flags(&gsh->flags);
	gsh_GSH_Rows(&gsh->rows);
}
struct GSH *
gsh_new_GSH()
{
	struct GSH *gsh;

	gsh=(struct GSH *)xmalloc(sizeof(struct GSH));
	gsh_GSH(gsh);

	return gsh;
}
struct GSH *
gsh_init(int *argc, char ***argv)
{
	struct GSH *gsh;
	
	gsh=gsh_new_GSH();
	gsh_stack_init(gsh, argc, argv);

	return gsh;
}
void
gsh_stack_init(struct GSH *gsh, int *argc, char ***argv)
{
	gtk_init(argc, argv);
	gsh_GSH(gsh);
	gsh->window=gsh_create_main_window();
}

